/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.mservice;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.mservice.BidAnnouncementUpdateService;

public class BidAnnouncementUpdateServiceImpl
implements BidAnnouncementUpdateService,
IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            long start = System.currentTimeMillis();
            BizLog.log((String)"start announcement Upgrade  ");
            DynamicObject[] announcementList = BusinessDataServiceHelper.load((String)"bid_announcement", (String)"publishstatus,billstatus,billno,createtime", (QFilter[])new QFilter[0]);
            if (announcementList == null || announcementList.length == 0) {
                result.setLog("announcement data not exist");
                result.setSuccess(true);
                return result;
            }
            Arrays.stream(announcementList).forEach(item -> {
                String billstatus = item.getString("billstatus");
                Long createtime = item.getDate("createtime").getTime();
                item.set("billno", (Object)createtime.toString());
                if (billstatus.equals("A")) {
                    item.set("publishstatus", (Object)"N");
                } else {
                    item.set("publishstatus", (Object)"L");
                    item.set("billstatus", (Object)"C");
                }
            });
            SaveServiceHelper.save((DynamicObject[])announcementList);
            long time = System.currentTimeMillis() - start;
            BizLog.log((String)("end hao shi ms: " + time));
            result.setLog("success");
            result.setSuccess(true);
            BizLog.log((String)"success\uff01");
            return result;
        }
        catch (Exception e) {
            BizLog.log((String)e.getMessage());
            return result;
        }
    }
}

