/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.mservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.schedule.file.uitl.PageUtil;
import kd.scm.bid.mservice.BidBaseUnitHistoryUpdateService;

public class BidBaseUnitHistoryUpdateServiceImpl
implements BidBaseUnitHistoryUpdateService,
IUpgradeService {
    private static final String MATERIAL_ENTITY = "bd_material";
    private static final String PROJECT_SELECT_UNIT_SQL = "select distinct fmaterialid from t_bid_projectentry";
    private static final String PROJECT_UPDATE_UNIT_SQL = "update t_bid_projectentry set fbaseunitid = ? where fmaterialid = ?";
    private static final String DOCDETAIL_SELECT_UNIT_SQL = "select distinct fmaterialid from t_bid_biddocdetail";
    private static final String DOCDETAIL_UPDATE_UNIT_SQL = "update t_bid_biddocdetail set fbaseunitid = ? where fmaterialid = ?";
    private static final String BOTTOM_SELECT_UNIT_SQL = "select distinct fmaterialid from t_bid_bottom_projectentry";
    private static final String BOTTOM_UPDATE_UNIT_SQL = "update t_bid_bottom_projectentry set fbaseunitid = ? where fmaterialid = ?";
    private static final String PUBLISH_SELECT_UNIT_SQL = "select distinct fmaterialid from t_bid_projectdetail";
    private static final String PUBLISH_UPDATE_UNIT_SQL = "update t_bid_projectdetail set fbaseunitid = ? where fmaterialid = ?";
    private static final String OPEN_SELECT_UNIT_SQL = "select distinct fmaterialid from t_bid_bidopen_supdetail";
    private static final String OPEN_UPDATE_UNIT_SQL = "update t_bid_bidopen_supdetail set fbaseunitid = ? where fmaterialid = ?";
    private static final String OPEN_BOT_SELECT_UNIT_SQL = "select distinct fbotmaterialid from t_bid_open_bottomentry";
    private static final String OPEN_BOT_UPDATE_UNIT_SQL = "update t_bid_open_bottomentry set fbotbaseunitid = ? where fbotmaterialid = ?";
    private static final String ONLINE_SELECT_UNIT_SQL = "select distinct fmaterialid from t_ten_onlinebid_sd";
    private static final String ONLINE_UPDATE_UNIT_SQL = "update t_ten_onlinebid_sd set fbaseunitid = ? where fmaterialid = ?";
    private static final String QCLARIFY_SELECT_UNIT_SQL = "select distinct fmaterialid from t_bid_qclarifysupdetail";
    private static final String QCLARIFY_UPDATE_UNIT_SQL = "update t_bid_qclarifysupdetail set fbaseunitid = ? where fmaterialid = ?";
    private static final String BUSTALK_SELECT_UNIT_SQL = "select distinct fmaterialid from t_bid_bustalk_supdetail";
    private static final String BUSTALK_UPDATE_UNIT_SQL = "update t_bid_bustalk_supdetail set fbaseunitid = ? where fmaterialid = ?";
    private static final String BUSTALK_ONLINE_SELECT_UNIT_SQL = "select distinct fmaterialid from t_ten_onliebustalkentry_s";
    private static final String BUSTALK_ONLINE_UPDATE_UNIT_SQL = "update t_ten_onliebustalkentry_s set fbaseunitid = ? where fmaterialid = ?";
    private static final String DBACK_SELECT_UNIT_SQL = "select distinct fmaterialid from t_bid_decibackdetail";
    private static final String DBACK_UPDATE_UNIT_SQL = "update t_bid_decibackdetail set fbaseunitid = ? where fmaterialid = ?";
    private static final String DFINAL_SELECT_UNIT_SQL = "select distinct flmaterialid from t_bid_decifinaldetail";
    private static final String DFINAL_UPDATE_UNIT_SQL = "update t_bid_decifinaldetail set flbaseunitid = ? where flmaterialid = ?";
    private static final String DBOT_SELECT_UNIT_SQL = "select distinct fbotmaterialid from t_bid_biddec_bottomentry";
    private static final String DBOT_UPDATE_UNIT_SQL = "update t_bid_biddec_bottomentry set fbotbaseunitid = ? where fbotmaterialid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        try {
            BizLog.log((String)"BidBaseUnitHistoryUpdateServiceImpl \uff1astart");
            int pageNum = 1000;
            BizLog.log((String)"bidproject \uff1astart");
            this.updateBaseUnitData(pageNum, PROJECT_SELECT_UNIT_SQL, PROJECT_UPDATE_UNIT_SQL);
            BizLog.log((String)"bidproject \uff1aend");
            BizLog.log((String)"DOC \uff1astart");
            this.updateBaseUnitData(pageNum, DOCDETAIL_SELECT_UNIT_SQL, DOCDETAIL_UPDATE_UNIT_SQL);
            BizLog.log((String)"DOC \uff1aend");
            BizLog.log((String)"PUBLISH \uff1astart");
            this.updateBaseUnitData(pageNum, PUBLISH_SELECT_UNIT_SQL, PUBLISH_UPDATE_UNIT_SQL);
            BizLog.log((String)"PUBLISH \uff1aend");
            BizLog.log((String)"BOTTOM \uff1astart");
            this.updateBaseUnitData(pageNum, BOTTOM_SELECT_UNIT_SQL, BOTTOM_UPDATE_UNIT_SQL);
            BizLog.log((String)"BOTTOM \uff1aend");
            BizLog.log((String)"PUBLISH \uff1astart");
            this.updateBaseUnitData(pageNum, OPEN_SELECT_UNIT_SQL, OPEN_UPDATE_UNIT_SQL);
            this.updateBaseUnitData(pageNum, OPEN_BOT_SELECT_UNIT_SQL, OPEN_BOT_UPDATE_UNIT_SQL);
            BizLog.log((String)"PUBLISH \uff1aend");
            BizLog.log((String)"QCLARIFY\uff1astart");
            this.updateBaseUnitData(pageNum, QCLARIFY_SELECT_UNIT_SQL, QCLARIFY_UPDATE_UNIT_SQL);
            BizLog.log((String)"QCLARIFY \uff1aend");
            BizLog.log((String)"ONLINE \uff1astart");
            this.updateBaseUnitData(pageNum, ONLINE_SELECT_UNIT_SQL, ONLINE_UPDATE_UNIT_SQL);
            BizLog.log((String)"ONLINE \uff1aend");
            BizLog.log((String)"BUSTALK \uff1astart");
            this.updateBaseUnitData(pageNum, BUSTALK_SELECT_UNIT_SQL, BUSTALK_UPDATE_UNIT_SQL);
            BizLog.log((String)"BUSTALK \uff1aend");
            BizLog.log((String)"ONLINE BUSTALK \uff1astart");
            this.updateBaseUnitData(pageNum, BUSTALK_ONLINE_SELECT_UNIT_SQL, BUSTALK_ONLINE_UPDATE_UNIT_SQL);
            BizLog.log((String)"ONLINE BUSTALK \uff1aend");
            BizLog.log((String)"D \uff1astart");
            this.updateBaseUnitData(pageNum, DBACK_SELECT_UNIT_SQL, DBACK_UPDATE_UNIT_SQL);
            this.updateBaseUnitData(pageNum, DFINAL_SELECT_UNIT_SQL, DFINAL_UPDATE_UNIT_SQL);
            this.updateBaseUnitData(pageNum, DBOT_SELECT_UNIT_SQL, DBOT_UPDATE_UNIT_SQL);
            BizLog.log((String)"D \uff1aend");
            BizLog.log((String)"BidBaseUnitHistoryUpdateServiceImpl \uff1asuccess");
            upgradeResult.setSuccess(true);
        }
        catch (Exception e) {
            BizLog.log((String)"BidBaseUnitHistoryUpdateServiceImpl \uff1aerror");
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                BizLog.log((String)(stackTrace[0].getClassName() + stackTrace[0].getMethodName() + stackTrace[0].getLineNumber()));
            }
            BizLog.log((String)e.getMessage());
            upgradeResult.setSuccess(false);
        }
        return upgradeResult;
    }

    public void updateBaseUnitData(int pageNum, String querySql, String updateSql) {
        ArrayList materialIdList = new ArrayList(16);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)querySql, rs -> {
            while (rs.next()) {
                materialIdList.add(rs.getLong(1));
            }
            return null;
        });
        BizLog.log((String)("updateBaseUnitData size\uff1a" + materialIdList.size()));
        Map listMap = PageUtil.listPage(materialIdList, (int)pageNum);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1000);
        for (Map.Entry listData : listMap.entrySet()) {
            paramsList.clear();
            List currentList = (List)listData.getValue();
            DynamicObject[] materialArray = BusinessDataServiceHelper.load((String)MATERIAL_ENTITY, (String)"id,baseunit", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)currentList)});
            if (materialArray != null && materialArray.length > 0) {
                for (DynamicObject material : materialArray) {
                    DynamicObject baseUnit = material.getDynamicObject("baseunit");
                    if (baseUnit == null) continue;
                    Object[] param = new Object[]{baseUnit.getLong("id"), material.getLong("id")};
                    paramsList.add(param);
                }
            }
            if (paramsList == null || paramsList.size() <= 0) continue;
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, paramsList);
            BizLog.log((String)("DB.executeBatch\uff1a" + paramsList.size()));
        }
    }
}

