/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.mservice.BidDecisionBottomUpdateService;

public class BidDecisionBottomUpdateServiceImpl
implements BidDecisionBottomUpdateService,
IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            String selectProperties = "id,bidproject,baseprice,bottomsection,botsectionname,bottomentry,botpurentrycontent,botpurentryproject,botmaterialid, botmaterialdes,botqty,botcontrolamount,botcontrolvat,botctrlamtexceptvat,declareamount,finalauditamount,planamount,nottaxplanamount";
            DynamicObject[] decisionArray = BusinessDataServiceHelper.load((String)"bid_decision", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("billstatus", "!=", (Object)"D")});
            ArrayList<DynamicObject> decisionList = new ArrayList<DynamicObject>();
            for (DynamicObject decision : decisionArray) {
                DynamicObject decisionBidProject;
                DynamicObjectCollection bottomSectionCol = decision.getDynamicObjectCollection("bottomsection");
                if (!CollectionUtils.isEmpty((Collection)bottomSectionCol) || (decisionBidProject = decision.getDynamicObject("bidproject")) == null) continue;
                boolean bidBottomMake = decisionBidProject.getBoolean("bidbottommake");
                if (bidBottomMake) {
                    String selectFeild = "bidbottomamount,bidsection.sectionname,projectentry.purentrycontent,projectentry.purentryproject,projectentry.controlamount,projectentry.declareamount,projectentry.finalauditamount,projectentry.materialid,projectentry.materialdes,projectentry.qty,projectentry.controlvat,projectentry.ctrlamtexceptvat,projectentry.purentryworkload,projectentry.purentrycomment,projectentry.workload,projectentry.secdeposit,projectentry.qty,projectentry.nottaxplanamount,projectentry.planamount";
                    DynamicObject[] bidBottomMakes = BusinessDataServiceHelper.load((String)"bid_bottom_make", (String)selectFeild, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", decisionBidProject.getPkValue()), new QFilter("billstatus", "=", (Object)"C")});
                    if (bidBottomMakes.length > 0) {
                        this.getPurEntryDataFromBottomMake(decision, bidBottomMakes[0]);
                    } else {
                        this.getPurEntryDataFromBidProject((Long)decisionBidProject.getPkValue(), decision);
                    }
                } else {
                    this.getPurEntryDataFromBidProject((Long)decisionBidProject.getPkValue(), decision);
                }
                decisionList.add(decision);
            }
            if (!CollectionUtils.isEmpty(decisionList)) {
                DynamicObject[] saveDecisionArray = new DynamicObject[decisionList.size()];
                decisionList.toArray(saveDecisionArray);
                SaveServiceHelper.save((DynamicObject[])saveDecisionArray);
            }
            BizLog.log((String)"success\uff01");
            result.setSuccess(true);
        }
        catch (Exception e) {
            BizLog.log((String)e.getMessage());
        }
        return result;
    }

    protected void getPurEntryDataFromBottomMake(DynamicObject decision, DynamicObject bidBottomMake) {
        BigDecimal basePrice = BigDecimal.ZERO;
        DynamicObjectCollection bottomSectionColl = decision.getDynamicObjectCollection("bottomsection");
        bottomSectionColl.clear();
        DynamicObjectCollection bidBottomMakeSectionColl = bidBottomMake.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidBottomMakeSectionColl.size(); ++i) {
            DynamicObject bidBottomMakeSection = (DynamicObject)bidBottomMakeSectionColl.get(i);
            DynamicObject decisionBottomSection = bottomSectionColl.addNew();
            decisionBottomSection.set("botsectionname", bidBottomMakeSection.get("sectionname"));
            DynamicObjectCollection decisionBottomEntryColl = decisionBottomSection.getDynamicObjectCollection("bottomentry");
            DynamicObjectCollection projectEntryColl = bidBottomMakeSection.getDynamicObjectCollection("projectentry");
            for (int j = 0; j < projectEntryColl.size(); ++j) {
                DynamicObject decisionBottomEntry = decisionBottomEntryColl.addNew();
                DynamicObject projectEntry = (DynamicObject)projectEntryColl.get(j);
                decisionBottomEntry.set("botpurentrycontent", projectEntry.get("purentrycontent"));
                decisionBottomEntry.set("botpurentryproject", projectEntry.get("purentryproject"));
                decisionBottomEntry.set("botmaterialid", projectEntry.get("materialid"));
                decisionBottomEntry.set("botcontrolamount", projectEntry.get("controlamount"));
                decisionBottomEntry.set("declareamount", projectEntry.get("declareamount"));
                decisionBottomEntry.set("botcontrolvat", projectEntry.get("controlvat"));
                decisionBottomEntry.set("botctrlamtexceptvat", projectEntry.get("ctrlamtexceptvat"));
                decisionBottomEntry.set("finalauditamount", projectEntry.get("finalauditamount"));
                decisionBottomEntry.set("botqty", projectEntry.get("qty"));
                decisionBottomEntry.set("planamount", decisionBottomEntry.get("planamount"));
                decisionBottomEntry.set("nottaxplanamount", decisionBottomEntry.get("nottaxplanamount"));
                basePrice = basePrice.add(projectEntry.getBigDecimal("finalauditamount"));
            }
        }
        decision.set("baseprice", (Object)basePrice);
    }

    protected void getPurEntryDataFromBidProject(long projectId, DynamicObject decision) {
        DynamicObject queryBidProject = BusinessDataServiceHelper.loadSingle((String)"bid_project", (String)"bidsection,sectionname,projectentry,purentrycontent,purentryproject,materialid,materialdes,qty,controlamount,planamount,nottaxplanamount,controlvat,ctrlamtexceptvat,purentryworkload,purentrycomment", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
        if (queryBidProject == null) {
            return;
        }
        DynamicObjectCollection bidSection = queryBidProject.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection bottomSection = decision.getDynamicObjectCollection("bottomsection");
        bottomSection.clear();
        for (int i = 0; i < bidSection.size(); ++i) {
            DynamicObject section = (DynamicObject)bidSection.get(i);
            DynamicObject bottomSectionRow = bottomSection.addNew();
            bottomSectionRow.set("botsectionname", section.get("sectionname"));
            DynamicObjectCollection bottomentry = bottomSectionRow.getDynamicObjectCollection("bottomentry");
            bottomentry.clear();
            DynamicObjectCollection projectEntry = section.getDynamicObjectCollection("projectentry");
            for (int j = 0; j < projectEntry.size(); ++j) {
                DynamicObject entry = (DynamicObject)projectEntry.get(j);
                DynamicObject botentry = bottomentry.addNew();
                botentry.set("botpurentrycontent", entry.get("purentrycontent"));
                botentry.set("botpurentryproject", entry.get("purentryproject"));
                DynamicObject material = entry.getDynamicObject("materialid");
                if (material != null) {
                    material = BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)"name,modelnum,baseunit.name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((Long)material.getPkValue()))});
                }
                botentry.set("botmaterialid", (Object)material);
                botentry.set("botmaterialdes", entry.get("materialdes"));
                botentry.set("botqty", entry.get("qty"));
                botentry.set("botcontrolamount", entry.get("controlamount"));
                botentry.set("botcontrolamount", entry.get("ctrlamtexceptvat"));
                botentry.set("botcontrolvat", entry.get("controlvat"));
                botentry.set("declareamount", (Object)BigDecimal.ZERO);
                botentry.set("finalauditamount", (Object)BigDecimal.ZERO);
                botentry.set("planamount", entry.get("planamount"));
                botentry.set("nottaxplanamount", entry.get("nottaxplanamount"));
            }
        }
    }
}

