/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.mservice.BidIPUpdateService;

public class BidIPUpdateServiceImpl
implements BidIPUpdateService,
IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updateTenderRecord();
            this.updateDowndocRecord();
            this.updatePublishRecord();
            this.updateBidOpenRecord();
            this.updateMultiQuestClarifyRecord();
            this.updateAnswerQuestionRecord();
            BizLog.log((String)"success\uff01");
            result.setSuccess(true);
        }
        catch (Exception e) {
            BizLog.log((String)e.getMessage());
        }
        return result;
    }

    protected void updateTenderRecord() {
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"bid_tenderrecord", (String)"ip,\nsupplier,bidproject,sectionname,isillegalbid", (QFilter[])new QFilter[]{new QFilter("bidproject", "!=", (Object)0L), new QFilter("supplier", "!=", (Object)0L), new QFilter("id", "!=", (Object)0L)});
        if (records.length == 0) {
            return;
        }
        HashMap isIllageMap = new HashMap(16);
        Arrays.stream(records).filter(record -> record.getString("ip") != null && !record.getString("ip").isEmpty()).forEach(record -> {
            String ip = record.getString("ip");
            if (ip.contains(",")) {
                ip = ip.split(",")[0];
                record.set("ip", (Object)ip);
            }
            String key = this.getKey((DynamicObject)record, ip, true);
            List isIllageList = isIllageMap.computeIfAbsent(key, k -> new ArrayList());
            isIllageList.add(record);
        });
        Arrays.stream(records).filter(record -> record.getString("ip") != null && !record.getString("ip").isEmpty()).forEach(record -> {
            String ip = record.getString("ip");
            String key = this.getKey((DynamicObject)record, ip, true);
            List isIllageList = isIllageMap.getOrDefault(key, new ArrayList());
            if (isIllageList.size() <= 1) {
                return;
            }
            isIllageList.forEach(r -> r.set("isillegalbid", (Object)Boolean.TRUE));
        });
        SaveServiceHelper.save((DynamicObject[])records);
    }

    protected String getKey(DynamicObject record, String ip, boolean flag) {
        String result = "";
        Object bidproject = record.getDynamicObject("bidproject").getPkValue();
        result = ip + bidproject;
        if (flag) {
            String sectionname = record.getString("sectionname");
            result = result + sectionname;
        }
        return result;
    }

    protected void updateDowndocRecord() {
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"bid_downdocrecord", (String)"downdocip,supplier,bidproject,isillegalbid", (QFilter[])new QFilter[]{new QFilter("bidproject", "!=", (Object)0L), new QFilter("supplier", "!=", (Object)0L), new QFilter("id", "!=", (Object)0L)});
        if (records.length == 0) {
            return;
        }
        HashMap isIllageMap = new HashMap(16);
        Arrays.stream(records).filter(record -> record.getString("downdocip") != null && !record.getString("downdocip").isEmpty()).forEach(record -> {
            String ip = record.getString("downdocip");
            if (ip.contains(",")) {
                ip = ip.split(",")[0];
                record.set("downdocip", (Object)ip);
            }
            String key = this.getKey((DynamicObject)record, ip, false);
            List isIllageList = isIllageMap.computeIfAbsent(key, k -> new ArrayList());
            isIllageList.add(record);
        });
        Arrays.stream(records).filter(record -> record.getString("downdocip") != null && !record.getString("downdocip").isEmpty()).forEach(record -> {
            String ip = record.getString("downdocip");
            String key = this.getKey((DynamicObject)record, ip, false);
            List isIllageList = isIllageMap.getOrDefault(key, new ArrayList());
            if (isIllageList.size() <= 1) {
                return;
            }
            isIllageList.forEach(r -> r.set("isillegalbid", (Object)Boolean.TRUE));
        });
        SaveServiceHelper.save((DynamicObject[])records);
    }

    protected void updatePublishRecord() {
        DynamicObject[] bidpublishes = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)"bidsection,supplierentry,downdocip", (QFilter[])new QFilter[]{new QFilter("bidsection.supplierentry.downdocip", "!=", null).or(new QFilter("bidsection.supplierentry.downdocip", "!=", (Object)""))});
        Arrays.stream(bidpublishes).forEach(publish -> publish.getDynamicObjectCollection("bidsection").forEach(section -> section.getDynamicObjectCollection("supplierentry").forEach(entry -> {
            String downdocip = entry.getString("downdocip");
            if (!downdocip.contains(",")) {
                return;
            }
            entry.set("downdocip", (Object)downdocip.split(",")[0]);
        })));
        SaveServiceHelper.save((DynamicObject[])bidpublishes);
    }

    protected void updateBidOpenRecord() {
        DynamicObject[] bidOpens = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"bidsection,supplierentry,\nsupplier_ip", (QFilter[])new QFilter[]{new QFilter("bidsection.supplierentry.supplier_ip", "!=", null).or(new QFilter("bidsection.supplierentry.supplier_ip", "!=", (Object)""))});
        Arrays.stream(bidOpens).forEach(open -> open.getDynamicObjectCollection("bidsection").forEach(section -> section.getDynamicObjectCollection("supplierentry").forEach(entry -> {
            String downdocip = entry.getString("supplier_ip");
            if (!downdocip.contains(",")) {
                return;
            }
            entry.set("supplier_ip", (Object)downdocip.split(",")[0]);
        })));
        SaveServiceHelper.save((DynamicObject[])bidOpens);
    }

    protected void updateMultiQuestClarifyRecord() {
        DynamicObject[] clarifys = BusinessDataServiceHelper.load((String)"bid_multiquestclarify", (String)"bidsection,supplierentry,\nip", (QFilter[])new QFilter[]{new QFilter("bidsection.supplierentry.ip", "!=", null).or(new QFilter("bidsection.supplierentry.ip", "!=", (Object)""))});
        Arrays.stream(clarifys).forEach(clarify -> clarify.getDynamicObjectCollection("bidsection").forEach(section -> section.getDynamicObjectCollection("supplierentry").forEach(entry -> {
            String downdocip = entry.getString("ip");
            if (!downdocip.contains(",")) {
                return;
            }
            entry.set("ip", (Object)downdocip.split(",")[0]);
        })));
        SaveServiceHelper.save((DynamicObject[])clarifys);
    }

    protected void updateAnswerQuestionRecord() {
        DynamicObject[] questions = BusinessDataServiceHelper.load((String)"bid_answerquestion_reco", (String)"bid_answerquestions_list,questionip", (QFilter[])new QFilter[]{new QFilter("bid_answerquestions_list.questionip", "!=", null).or(new QFilter("bid_answerquestions_list.questionip", "!=", (Object)""))});
        Arrays.stream(questions).forEach(question -> question.getDynamicObjectCollection("bid_answerquestions_list").forEach(entry -> {
            String questionip = entry.getString("questionip");
            if (!questionip.contains(",")) {
                return;
            }
            entry.set("questionip", (Object)questionip.split(",")[0]);
        }));
        SaveServiceHelper.save((DynamicObject[])questions);
    }
}

