/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.mservice;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.mservice.BidProjectUpdateService;

public class BidProjectOrgUpdateServiceImpl
implements BidProjectUpdateService,
IUpgradeService {
    private static final String UPDATE_SQL = "update t_bid_project_a set fsubmittor = ? ,fsubmittime = ? where fid= ? and fsubmittor = 0 and fsubmittime is null";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            long start = System.currentTimeMillis();
            BizLog.log((String)"hyl start invitation Upgrade  ");
            HashSet<Character> billStatus = new HashSet<Character>();
            billStatus.add(Character.valueOf('B'));
            billStatus.add(Character.valueOf('I'));
            billStatus.add(Character.valueOf('C'));
            billStatus.add(Character.valueOf('X'));
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bid_project", (String)"id,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", billStatus)});
            HashMap invitationMap = new HashMap(16);
            for (DynamicObject object : objects) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(0, object.getDynamicObject("modifier") == null ? " " : object.getDynamicObject("modifier").getString("id"));
                list.add(1, object.getString("modifytime") == null ? " " : object.getString("modifytime"));
                invitationMap.put(object.getLong("id"), list);
            }
            if (CollectionUtils.isEmpty(invitationMap)) {
                result.setLog("invitation data not exist");
                result.setSuccess(true);
                return result;
            }
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
            for (Map.Entry invitationData : invitationMap.entrySet()) {
                if (invitationData.getValue() == null) continue;
                List value = (List)invitationData.getValue();
                Object[] paramArr = new Object[]{Long.valueOf((String)value.get(0)), Timestamp.valueOf((String)value.get(1)), invitationData.getKey()};
                BizLog.log((String)("hyl paramArr :" + Arrays.toString(paramArr)));
                paramsList.add(paramArr);
            }
            int size = paramsList.size();
            BizLog.log((String)("hyl size :" + size));
            int[] i = DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)UPDATE_SQL, paramsList);
            BizLog.log((String)("hyl i :" + Arrays.toString(i)));
            long time = System.currentTimeMillis() - start;
            BizLog.log((String)("end hao shi ms: " + time));
            BizLog.log((String)("hyl : " + time));
            result.setLog("success");
            result.setSuccess(true);
            BizLog.log((String)"success\uff01");
            return result;
        }
        catch (Exception e) {
            BizLog.log((String)e.getMessage());
            return result;
        }
    }
}

