/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.mservice;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.util.DateUtils;
import kd.scm.bid.mservice.BidPublishDateHistoryUpdateService;

public class BidPublishDateHistoryUpdateServiceImpl
implements BidPublishDateHistoryUpdateService,
IUpgradeService {
    private static final String PROJECT_QUERY_SQL = "SELECT T1.FID, T1.FANSWERCOMPLETE,T2.FBIDBUSTALKDATE FROM T_BID_PROJECT T1 INNER JOIN T_BID_PROJECT_A T2 ON T1.FID = T2.FID";
    private static final String PUBLISH_UPDATE_SQL = "UPDATE T_BID_BIDPUBLISH SET FANSWERINGENDTIME = ? ,FBIDBUSTALKDATE = ? WHERE FBIDPROJECTID = ? ";
    private static final String PUBLISH_TIMES_SQL = "UPDATE T_BID_BIDPUBLISH SET FPUBLISHTIMES = ? WHERE FID= ? ";
    private static final String PROJECT_A_QUERY_SQL = "SELECT FID, FBIDOPENTYPE FROM T_BID_PROJECT_A";
    private static final String PUBLISH_OPENTYEP_UPDATE_SQL = "UPDATE T_BID_BIDPUBLISH SET FBIDOPENTYPE = ?  WHERE FBIDPROJECTID = ? ";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            StringBuilder info = new StringBuilder();
            long start = System.currentTimeMillis();
            info.append("date update start 202209999");
            BizLog.log((String)"ri zhi 2022099999");
            this.publishDateUpdate(info);
            this.publishOpenTypeUpdate(info);
            this.publishPlanDateUpdate(info);
            this.publishTimesUpdate(info);
            long time = System.currentTimeMillis() - start;
            result.setLog(info.toString());
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setLog("geng xin yi chang : " + e);
            result.setSuccess(false);
            BizLog.log((String)e.getMessage());
        }
        return result;
    }

    public void publishDateUpdate(StringBuilder info) {
        HashMap ret = new HashMap(16);
        info.append("date update start 20220914");
        BizLog.log((String)"ri zhi 20220914");
        Map projectDateMap = (Map)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)PROJECT_QUERY_SQL, (Object[])new Object[0], rs -> {
            while (rs.next()) {
                ArrayList<Date> list = new ArrayList<Date>();
                list.add(0, rs.getDate(2) == null ? null : rs.getDate(2));
                list.add(1, rs.getDate(3) == null ? null : rs.getDate(3));
                ret.put(rs.getLong(1), list);
            }
            return ret;
        });
        info.append("date update start 202209142");
        BizLog.log((String)"ri zhi 202209142");
        if (CollectionUtils.isEmpty((Map)projectDateMap)) {
            info.append("t_bid_project data not exist \n");
            BizLog.log((String)"ri zhi 202209149");
            return;
        }
        info.append("date update start 202209143");
        BizLog.log((String)"ri zhi 202209143");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        for (Map.Entry projectDateData : projectDateMap.entrySet()) {
            if (projectDateData.getValue() == null) continue;
            List value = (List)projectDateData.getValue();
            java.util.Date answerComplete = (java.util.Date)value.get(0);
            java.util.Date bidBustalkDate = (java.util.Date)value.get(1);
            if (answerComplete != null) {
                answerComplete = DateUtils.endOfDay((java.util.Date)answerComplete);
            }
            if (bidBustalkDate != null) {
                bidBustalkDate = DateUtils.endOfDay((java.util.Date)bidBustalkDate);
            }
            Object[] paramArr = new Object[]{answerComplete, bidBustalkDate, projectDateData.getKey()};
            paramsList.add(paramArr);
        }
        BizLog.log((String)"ri zhi 202209144");
        info.append("date update start FANSWERCOMPLETE").append(((Object[])paramsList.get(0))[0]).append(" FBIDBUSTALKDATE ").append(((Object[])paramsList.get(0))[1]).append(" FBIDPROJECTID ").append(((Object[])paramsList.get(0))[2]);
        int[] i = DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)PUBLISH_UPDATE_SQL, paramsList);
        info.append("date update end");
        BizLog.log((String)"ri zhi 202209145");
        info.append(i.length);
    }

    public void publishOpenTypeUpdate(StringBuilder info) {
        HashMap ret = new HashMap(16);
        Map projectDateMap = (Map)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)PROJECT_A_QUERY_SQL, (Object[])new Object[0], rs -> {
            while (rs.next()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(0, rs.getString(2) == null ? null : rs.getString(2));
                ret.put(rs.getLong(1), list);
            }
            return ret;
        });
        if (CollectionUtils.isEmpty((Map)projectDateMap)) {
            info.append("t_bid_project_a data not exist \n");
            BizLog.log((String)"ri zhi de 20221201");
            return;
        }
        info.append("date update start 20221201");
        BizLog.log((String)"ri zhi 20221201");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        for (Map.Entry projectDateData : projectDateMap.entrySet()) {
            if (projectDateData.getValue() == null) continue;
            List value = (List)projectDateData.getValue();
            Object[] paramArr = new Object[]{value.get(0), projectDateData.getKey()};
            paramsList.add(paramArr);
        }
        BizLog.log((String)"ri zhi end 20221201");
        int[] i = DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)PUBLISH_OPENTYEP_UPDATE_SQL, paramsList);
        info.append("date update end 20221201");
        BizLog.log((String)"ri zhi 20221201 end");
        info.append(i.length);
    }

    public boolean isEmptyData(String tableKey) {
        ArrayList publishOpenIdList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)("SELECT FID FROM " + tableKey), (Object[])new Object[0], rs -> {
            while (rs.next()) {
                publishOpenIdList.add(rs.getLong(1));
            }
            return null;
        });
        return publishOpenIdList.isEmpty();
    }

    public void publishPlanDateUpdate(StringBuilder info) {
        if (this.isEmptyData("T_BID_BIDPUBLISH")) {
            return;
        }
        DynamicObject[] publishs = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)"planbidpublishdate1,probidpublishdate,planbidevaluationdate,probidevaluationdate,planbiddecisiondate,probiddecisiondate", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        if (publishs.length == 0) {
            info.append("t_bid_publish data not exist \n");
            return;
        }
        for (DynamicObject publish : publishs) {
            java.util.Date proBidDecisionDate;
            java.util.Date planBidDecisionDate;
            java.util.Date proBidEvaluationDate;
            java.util.Date planBidEvaluationDate;
            java.util.Date proBidpublishDate;
            java.util.Date planBidpublishDate1 = publish.getDate("planbidpublishdate1");
            if (planBidpublishDate1 != null) {
                publish.set("planbidpublishdate1", (Object)DateUtils.endOfDay((java.util.Date)planBidpublishDate1));
            }
            if ((proBidpublishDate = publish.getDate("probidpublishdate")) != null) {
                publish.set("probidpublishdate", (Object)DateUtils.endOfDay((java.util.Date)proBidpublishDate));
            }
            if ((planBidEvaluationDate = publish.getDate("planbidevaluationdate")) != null) {
                publish.set("planbidevaluationdate", (Object)DateUtils.endOfDay((java.util.Date)planBidEvaluationDate));
            }
            if ((proBidEvaluationDate = publish.getDate("probidevaluationdate")) != null) {
                publish.set("probidevaluationdate", (Object)DateUtils.endOfDay((java.util.Date)proBidEvaluationDate));
            }
            if ((planBidDecisionDate = publish.getDate("planbiddecisiondate")) != null) {
                publish.set("planbiddecisiondate", (Object)DateUtils.endOfDay((java.util.Date)planBidDecisionDate));
            }
            if ((proBidDecisionDate = publish.getDate("probiddecisiondate")) == null) continue;
            publish.set("probiddecisiondate", (Object)DateUtils.endOfDay((java.util.Date)proBidDecisionDate));
        }
        SaveServiceHelper.save((DynamicObject[])publishs);
    }

    public void publishTimesUpdate(StringBuilder info) {
        if (this.isEmptyData("T_BID_BIDPUBLISH")) {
            return;
        }
        DynamicObject[] publishs = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)"id,billstatus,rounds,listrounds,bidproject", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        DynamicObject[] publishNotCans = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)"id,billstatus,rounds,listrounds,bidproject", (QFilter[])new QFilter[]{new QFilter("billstatus", "!=", (Object)"X")});
        info.append("date update start 202209144");
        BizLog.log((String)"ri zhi 202209146");
        if (publishNotCans == null || publishNotCans.length == 0) {
            info.append("t_bid_publish publishTimes data not exist \n");
            BizLog.log((String)"ri zhi 202209148");
            return;
        }
        info.append("date update start 202209145");
        BizLog.log((String)"ri zhi 202209147");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        for (DynamicObject publishNotCan : publishNotCans) {
            Long project;
            String billStatus = publishNotCan.getString("billstatus");
            Long projectId = 0L;
            if (publishNotCan.getDynamicObject("bidproject") != null) {
                projectId = publishNotCan.getDynamicObject("bidproject").getLong("id");
            }
            int index = 0;
            if (!StringUtils.isEmpty((Object)billStatus) && billStatus.equals("P")) {
                for (DynamicObject publish : publishs) {
                    String tempPillStatus;
                    project = 1L;
                    if (publish.getDynamicObject("bidproject") != null) {
                        project = publish.getDynamicObject("bidproject").getLong("id");
                    }
                    if (StringUtils.isEmpty((Object)(tempPillStatus = publish.getString("billstatus"))) || !tempPillStatus.equals("P") && !tempPillStatus.equals("J") && !tempPillStatus.equals("X") || projectId.compareTo(project) != 0) continue;
                    ++index;
                }
            } else {
                for (DynamicObject publish : publishs) {
                    project = 1L;
                    if (publish.getDynamicObject("bidproject") != null) {
                        project = publish.getDynamicObject("bidproject").getLong("id");
                    }
                    if (projectId.compareTo(project) != 0) continue;
                    ++index;
                }
            }
            Object[] paramArr = new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u53d1\u6807", (String)"BidPublishDateHistoryUpdateServiceImpl_0", (String)"scm-bid-mservice", (Object[])new Object[0]), BidPublishDateHistoryUpdateServiceImpl.toChinese(index + "")), publishNotCan.getPkValue()};
            paramsList.add(paramArr);
        }
        BizLog.log((String)"ri zhi 2022091410");
        info.append("times update start times ").append(((Object[])paramsList.get(0))[0]).append(" FID").append(((Object[])paramsList.get(0))[1]);
        int[] i = DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)PUBLISH_TIMES_SQL, paramsList);
        info.append("times update end");
        BizLog.log((String)"ri zhi 2022091411");
        info.append(i.length);
    }

    public static String toChinese(String str) {
        String[] s1 = new String[]{ResManager.loadKDString((String)"\u96f6", (String)"BidPublishDateHistoryUpdateServiceImpl_1", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"BidPublishDateHistoryUpdateServiceImpl_2", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"BidPublishDateHistoryUpdateServiceImpl_3", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"BidPublishDateHistoryUpdateServiceImpl_4", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"BidPublishDateHistoryUpdateServiceImpl_5", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"BidPublishDateHistoryUpdateServiceImpl_6", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"BidPublishDateHistoryUpdateServiceImpl_7", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"BidPublishDateHistoryUpdateServiceImpl_8", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"BidPublishDateHistoryUpdateServiceImpl_9", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"BidPublishDateHistoryUpdateServiceImpl_10", (String)"scm-bid-mservice", (Object[])new Object[0])};
        String[] s2 = new String[]{ResManager.loadKDString((String)"\u5341", (String)"BidPublishDateHistoryUpdateServiceImpl_11", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidPublishDateHistoryUpdateServiceImpl_12", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidPublishDateHistoryUpdateServiceImpl_13", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"BidPublishDateHistoryUpdateServiceImpl_14", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"BidPublishDateHistoryUpdateServiceImpl_11", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidPublishDateHistoryUpdateServiceImpl_12", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidPublishDateHistoryUpdateServiceImpl_13", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"BidPublishDateHistoryUpdateServiceImpl_15", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"BidPublishDateHistoryUpdateServiceImpl_11", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidPublishDateHistoryUpdateServiceImpl_12", (String)"scm-bid-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidPublishDateHistoryUpdateServiceImpl_13", (String)"scm-bid-mservice", (Object[])new Object[0])};
        StringBuilder sb = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int num = str.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                sb.append(s1[num]).append(s2[n - 2 - i]);
                continue;
            }
            sb.append(s1[num]);
        }
        return sb.toString();
    }
}

