/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.common.constant.bill;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptionalColumnConstant {
    private List<Map<String, String>> columns = new ArrayList<Map<String, String>>();
    private static final String BidProjectEnum = "BidProjectEnum";
    private static final String BidAnnouncementEnum = "BidAnnouncementEnum";
    private static final String InvitationEnum = "InvitationEnum";
    private static final String DecisionEnum = "DecisionEnum";
    private static final String WinBidAnnouncementEnum = "WinBidAnnouncementEnum";
    private static final String BidNotificationEnum = "BidNotificationEnum";
    private static final String ThanksLetterEnum = "ThanksLetterEnum";
    private static final String QUERYENUM = "QueryEnum";
    private static final String NEGOTIATEENUM = "NegotiateEnum";
    private static final String BidAssInviteEnum = "BidAssInviteEnum";

    public List<Map<String, String>> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Map<String, String>> columns) {
        this.columns = columns;
    }

    public OptionalColumnConstant(String type) {
        ArrayList<String> bill = new ArrayList<String>(50);
        switch (type) {
            case "bidproject": {
                bill.add(BidProjectEnum);
                bill.add(BidAnnouncementEnum);
                break;
            }
            case "invitation": {
                bill.add(BidProjectEnum);
                bill.add(InvitationEnum);
                break;
            }
            case "decision": {
                bill.add(BidProjectEnum);
                bill.add(DecisionEnum);
                bill.add(WinBidAnnouncementEnum);
                break;
            }
            case "bidnotification": {
                bill.add(BidProjectEnum);
                bill.add(DecisionEnum);
                bill.add(BidAnnouncementEnum);
                bill.add(BidNotificationEnum);
                break;
            }
            case "thanksletter": {
                bill.add(BidProjectEnum);
                bill.add(DecisionEnum);
                bill.add(BidAnnouncementEnum);
                bill.add(ThanksLetterEnum);
                break;
            }
            case "query": {
                bill.add(BidProjectEnum);
                bill.add(QUERYENUM);
                break;
            }
            case "negotiate": {
                bill.add(BidProjectEnum);
                bill.add(NEGOTIATEENUM);
                break;
            }
            case "bidassinvite": {
                bill.add(BidProjectEnum);
                bill.add(BidAssInviteEnum);
                break;
            }
        }
        for (int i = 0; i < bill.size(); ++i) {
            try {
                Class<?> onwClass = Class.forName("kd.scm.bid.common.enums." + (String)bill.get(i));
                Enum[] enumConstants = (Enum[])onwClass.getEnumConstants();
                Method getLabel = onwClass.getMethod("getLabel", new Class[0]);
                Method getValue = onwClass.getMethod("getValue", new Class[0]);
                for (Enum enum1 : enumConstants) {
                    Object value = getValue.invoke((Object)enum1, new Object[0]);
                    Object label = getLabel.invoke((Object)enum1, new Object[0]);
                    HashMap<String, String> column = new HashMap<String, String>();
                    column.put(label.toString(), value.toString());
                    this.columns.add(column);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (type.equals("query")) {
            // empty if block
        }
    }

    public static void main(String[] args) {
        OptionalColumnConstant optionalColumnConstant = new OptionalColumnConstant("invitation");
        System.out.println(optionalColumnConstant.columns);
    }
}

