/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.common.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.util.SystemParamHelper;

public class BidDarkUtil {
    public static Long getPurRootOrgId() {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("02");
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        return Long.parseLong(rootNode.getId());
    }

    public static boolean isDrakFlag(String appId) {
        Long orgId = BidDarkUtil.getPurRootOrgId();
        Object darkFlag = SystemParamHelper.getSystemParameterValue(appId, orgId, "darkflag");
        if (darkFlag == null) {
            return false;
        }
        return (Boolean)darkFlag;
    }

    public static boolean isDarkOpen(String appId) {
        Long orgId = BidDarkUtil.getPurRootOrgId();
        Object darkOpen = SystemParamHelper.getSystemParameterValue(appId, orgId, "darkopen");
        if (darkOpen == null) {
            return false;
        }
        return (Boolean)darkOpen;
    }

    public static boolean isDarkOnlineBidEval(String appId) {
        Long orgId = BidDarkUtil.getPurRootOrgId();
        Object darkOnlineBidEval = SystemParamHelper.getSystemParameterValue(appId, orgId, "darkonlinebideval");
        if (darkOnlineBidEval == null) {
            return false;
        }
        return (Boolean)darkOnlineBidEval;
    }

    public static boolean isDarkBidEvaluation(String appId) {
        Long orgId = BidDarkUtil.getPurRootOrgId();
        Object darkBidEvaluation = SystemParamHelper.getSystemParameterValue(appId, orgId, "darkbidevaluation");
        if (darkBidEvaluation == null) {
            return false;
        }
        return (Boolean)darkBidEvaluation;
    }

    public static boolean isDarkNameFlag(String appId) {
        Long orgId = BidDarkUtil.getPurRootOrgId();
        Object darkNameFlag = SystemParamHelper.getSystemParameterValue(appId, orgId, "darknameflag");
        if (darkNameFlag == null) {
            return false;
        }
        return (Boolean)darkNameFlag;
    }

    public static List<String> getDarkSupplierNameList(String appId, int begin, int supplierCount) {
        List<Object> supplierDarkNameList = new ArrayList(supplierCount);
        String darkMarkType = BidDarkUtil.getDarkMarkType(appId);
        if ("1".equals(darkMarkType)) {
            if (supplierCount > 26) {
                String darkDiyNumber = BidDarkUtil.getDarkDiyName(appId, "2");
                supplierDarkNameList = BidDarkUtil.getDarkSupplierNameNumberList(darkDiyNumber, begin, supplierCount);
            } else {
                String darkDiyAlphabet = BidDarkUtil.getDarkDiyName(appId, darkMarkType);
                supplierDarkNameList = BidDarkUtil.getDarkSupplierNameAlphabetList(darkDiyAlphabet, begin, supplierCount);
            }
        } else {
            String darkDiyNumber = BidDarkUtil.getDarkDiyName(appId, darkMarkType);
            supplierDarkNameList = BidDarkUtil.getDarkSupplierNameNumberList(darkDiyNumber, begin, supplierCount);
        }
        return supplierDarkNameList;
    }

    public static List<String> getDarkSupplierNameList(String appId, int supplierCount) {
        return BidDarkUtil.getDarkSupplierNameList(appId, 0, supplierCount);
    }

    public static String getDarkMarkType(String appId) {
        Long orgId = BidDarkUtil.getPurRootOrgId();
        Object darkMarkType = SystemParamHelper.getSystemParameterValue(appId, orgId, "darkmarktype");
        if (darkMarkType == null) {
            return "1";
        }
        return (String)darkMarkType;
    }

    public static String getDarkDiyName(String appId, String darkMarkType) {
        String darkDiyNameKey;
        Long orgId = BidDarkUtil.getPurRootOrgId();
        Object darkDiyName = SystemParamHelper.getSystemParameterValue(appId, orgId, darkDiyNameKey = "1".equals(darkMarkType) ? "darkdiyalphabet" : "darkdiynumber");
        if (darkDiyName == null) {
            return ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"BidDarkUtil_0", (String)"scm-bid-common", (Object[])new Object[0]);
        }
        return (String)darkDiyName;
    }

    public static List<String> getDarkSupplierNameAlphabetList(String darkDiyAlphabet, int begin, int supplierCount) {
        ArrayList<String> supplierDarkNameList = new ArrayList<String>(supplierCount);
        for (int i = 0; i < supplierCount; ++i) {
            char sufFix = (char)(65 + i + begin);
            supplierDarkNameList.add(darkDiyAlphabet + sufFix);
        }
        Collections.shuffle(supplierDarkNameList);
        return supplierDarkNameList;
    }

    public static List<String> getDarkSupplierNameNumberList(String darkDiyNumber, int begin, int supplierCount) {
        ArrayList<String> supplierDarkNameList = new ArrayList<String>(supplierCount);
        for (int i = 1; i <= supplierCount; ++i) {
            supplierDarkNameList.add(darkDiyNumber + (begin + i));
        }
        Collections.shuffle(supplierDarkNameList);
        return supplierDarkNameList;
    }

    public static boolean isDarkEvaluation(String appId, Object openId, String type) {
        QFilter qFilter = new QFilter("bidopen", "=", openId);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("darkopen");
        joiner.add("darkonlinebideval");
        joiner.add("darkbidevaluation");
        joiner.add("darktype");
        joiner.add("darknameflag");
        DynamicObject biddark = BusinessDataServiceHelper.loadSingleFromCache((String)(appId + "_biddark"), (String)joiner.toString(), (QFilter[])qFilter.toArray());
        if (biddark != null && biddark.getBoolean("darkbidevaluation")) {
            String encTypc = biddark.getString("darktype");
            return encTypc.equalsIgnoreCase(BidOpenTypeEnum.MULTI.getValue()) || encTypc.equalsIgnoreCase(type);
        }
        return false;
    }

    public static boolean isDarkOpen(String appId, Object openId, String type) {
        QFilter qFilter = new QFilter("bidopen", "=", openId);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("darkopen");
        joiner.add("darkonlinebideval");
        joiner.add("darkbidevaluation");
        joiner.add("darktype");
        joiner.add("darknameflag");
        DynamicObject biddark = BusinessDataServiceHelper.loadSingleFromCache((String)(appId + "_biddark"), (String)joiner.toString(), (QFilter[])qFilter.toArray());
        if (biddark != null && biddark.getBoolean("darkopen")) {
            String encTypc = biddark.getString("darktype");
            return encTypc.equalsIgnoreCase(BidOpenTypeEnum.MULTI.getValue()) || encTypc.equalsIgnoreCase(type);
        }
        return false;
    }

    public static boolean isDrakSame(String appId, Object openId, String type) {
        QFilter qFilter = new QFilter("bidopen", "=", openId);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("darkopen");
        joiner.add("darkonlinebideval");
        joiner.add("darkbidevaluation");
        joiner.add("darktype");
        joiner.add("darknameflag");
        DynamicObject bidDark = BusinessDataServiceHelper.loadSingleFromCache((String)(appId + "_biddark"), (String)joiner.toString(), (QFilter[])qFilter.toArray());
        if (bidDark != null && bidDark.getBoolean("darkbidevaluation")) {
            String encTypc = bidDark.getString("darktype");
            return encTypc.equalsIgnoreCase(BidOpenTypeEnum.MULTI.getValue()) || encTypc.equalsIgnoreCase(type);
        }
        return false;
    }

    public static Table<String, Object, String> getEvaluationDark(String appId, Object openId) {
        HashBasedTable table = HashBasedTable.create();
        QFilter qFilter = new QFilter("bidopen", "=", openId);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("evaluationsection");
        joiner.add("evaluasectionname");
        joiner.add("evaluasupplierentry");
        joiner.add("evaluationsupplier");
        joiner.add("evaluationdarkname");
        DynamicObject bidDark = BusinessDataServiceHelper.loadSingle((String)(appId + "_biddark"), (String)joiner.toString(), (QFilter[])qFilter.toArray());
        DynamicObjectCollection evaluationsection = bidDark.getDynamicObjectCollection("evaluationsection");
        evaluationsection.forEach(arg_0 -> BidDarkUtil.lambda$getEvaluationDark$1((Table)table, arg_0));
        return table;
    }

    public static Table<String, Object, String> getOpenDarkByOpenId(String appId, Object openId) {
        HashBasedTable table = HashBasedTable.create();
        QFilter qFilter = new QFilter("bidopen", "=", openId);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("bidopensection");
        joiner.add("opensectionname");
        joiner.add("opensupplierentry");
        joiner.add("bidopensupplier");
        joiner.add("opendarkname");
        DynamicObject bidDark = BusinessDataServiceHelper.loadSingle((String)(appId + "_biddark"), (String)joiner.toString(), (QFilter[])qFilter.toArray());
        DynamicObjectCollection evaluationsection = bidDark.getDynamicObjectCollection("bidopensection");
        evaluationsection.forEach(arg_0 -> BidDarkUtil.lambda$getOpenDarkByOpenId$3((Table)table, arg_0));
        return table;
    }

    public static Table<String, Object, String> getEvaluationDarkByEvaluationId(String appId, Object evaluationId) {
        QFilter qFilter = new QFilter("id", "=", evaluationId);
        DynamicObject bidopen = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidevaluation"), (String)"bidopenid", (QFilter[])qFilter.toArray());
        if (bidopen != null) {
            return BidDarkUtil.getEvaluationDark(appId, bidopen.getLong("bidopenid"));
        }
        return null;
    }

    public static HashMap<String, List<HashMap<Long, String>>> getSupplierDarkName(DynamicObject bid_bidDark, boolean onlineEvalDark) {
        if (onlineEvalDark) {
            DynamicObjectCollection bidOnlineSection = bid_bidDark.getDynamicObjectCollection("bidonlinesection");
            HashMap<String, List<HashMap<Long, String>>> sectionAndSupplierMap = new HashMap<String, List<HashMap<Long, String>>>();
            for (DynamicObject section : bidOnlineSection) {
                DynamicObjectCollection supplierEntryColl = section.getDynamicObjectCollection("onlinesupplierentry");
                ArrayList supplierList = new ArrayList();
                for (DynamicObject supplierEntry : supplierEntryColl) {
                    Long supplierId = (Long)supplierEntry.getDynamicObject("onlinesupplier").getPkValue();
                    String supplierDarkName = supplierEntry.getString("onlinedarkname");
                    HashMap<Long, String> supplierNameMap = new HashMap<Long, String>();
                    supplierNameMap.put(supplierId, supplierDarkName);
                    supplierList.add(supplierNameMap);
                }
                String sectionName = section.getString("onlinesectionname");
                sectionAndSupplierMap.put(sectionName, supplierList);
            }
            return sectionAndSupplierMap;
        }
        return null;
    }

    private static /* synthetic */ void lambda$getOpenDarkByOpenId$3(Table table, DynamicObject row) {
        String sectionName = row.getString("opensectionname");
        DynamicObjectCollection supplierEntry = row.getDynamicObjectCollection("opensupplierentry");
        supplierEntry.forEach(subRow -> {
            DynamicObject supplier = subRow.getDynamicObject("bidopensupplier");
            table.put((Object)sectionName, supplier.getPkValue(), (Object)subRow.getString("opendarkname"));
        });
    }

    private static /* synthetic */ void lambda$getEvaluationDark$1(Table table, DynamicObject row) {
        String sectionName = row.getString("evaluasectionname");
        DynamicObjectCollection supplierEntry = row.getDynamicObjectCollection("evaluasupplierentry");
        supplierEntry.forEach(subRow -> {
            DynamicObject supplier = subRow.getDynamicObject("evaluationsupplier");
            table.put((Object)sectionName, supplier.getPkValue(), (Object)subRow.getString("evaluationdarkname"));
        });
    }
}

