/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class BidProjectAnnouncementsUtils {
    public static boolean multipleSendProjectAnnouncementsFlag(String appId) {
        Object pjAnnouncementValue = SystemParamHelper.getSystemParameterValue(appId, OrgUnitHelper.ROOT_ORG_ID, "pj_announcement");
        if (pjAnnouncementValue == null) {
            return false;
        }
        return !"1".equals(pjAnnouncementValue.toString());
    }

    public static boolean checkManyTimesSendAnnouncements(String appId, Long bidProjectId) {
        String entityName = BidProjectAnnouncementsUtils.getSendAnnouncementsStepEntity(appId, bidProjectId);
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            DynamicObjectCollection dataCollection = QueryServiceHelper.query((String)entityName, (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectId)});
            if (dataCollection == null || CollectionUtils.isEmpty((Collection)dataCollection)) {
                return true;
            }
            if (dataCollection.size() > 1) {
                return false;
            }
            if (dataCollection.size() == 1) {
                DynamicObject data = (DynamicObject)dataCollection.get(0);
                String billStatus = data.getString("billstatus");
                return "D".equals(billStatus) || "A".equals(billStatus);
            }
        }
        return true;
    }

    public static String getSendAnnouncementsStepEntity(String appId, Long bidProjectId) {
        DynamicObject bidProject = QueryServiceHelper.queryOne((String)(appId + "_project"), (String)"supplierinvitation,biddocument,bidpublish,bidopen,bidevaluation,bidbustalk,biddecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidProjectId)});
        if (bidProject != null) {
            if (bidProject.getBoolean("supplierinvitation")) {
                return appId + "_supplierinvitation";
            }
            if (bidProject.getBoolean("biddocument")) {
                return appId + "_biddocument_edit";
            }
            if (bidProject.getBoolean("bidpublish")) {
                return appId + "_bidpublish";
            }
            if (bidProject.getBoolean("bidopen")) {
                return appId + "_bidopen";
            }
            if (bidProject.getBoolean("bidevaluation")) {
                return appId + "_bidevaluation";
            }
            if (bidProject.getBoolean("bidbustalk")) {
                return appId + "_bidbustalk";
            }
            if (bidProject.getBoolean("biddecision")) {
                return appId + "_biddecision";
            }
        }
        return null;
    }

    public static void clearApplySupplierAndTenderData(Long announcementsId, String appId, Long bidProjectId) {
        DynamicObject[] applyAnnouncementArray;
        DynamicObject supplierInvitationData;
        String stepName = BidProjectAnnouncementsUtils.getSendAnnouncementsSupplierInvitationEntityName(appId, bidProjectId);
        TreeSet<Long> supplierIdSet = new TreeSet<Long>();
        HashMap<Long, Long> hasMap = new HashMap<Long, Long>();
        if (StringUtils.isNotBlank((CharSequence)stepName) && (supplierInvitationData = BusinessDataServiceHelper.loadSingle((String)stepName, (String)"supplierqty,supplierenrollqty,bidsection,supplierentry,bidenrollsection,supplierenrollentry,enrollsupplier,baoprojectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectId), new QFilter("billstatus", "in", (Object)new String[]{"D", "A"})})) != null) {
            supplierInvitationData.set("supplierenrollqty", null);
            supplierInvitationData.set("supplierqty", null);
            DynamicObjectCollection bidSectionCol = supplierInvitationData.getDynamicObjectCollection("bidsection");
            for (Object bidSection : bidSectionCol) {
                bidSection.getDynamicObjectCollection("supplierentry").clear();
            }
            DynamicObject[] bidEnrollSectionCol = supplierInvitationData.getDynamicObjectCollection("bidenrollsection");
            for (DynamicObject bidSection : bidEnrollSectionCol) {
                DynamicObjectCollection supplierEnrollEntryCol = bidSection.getDynamicObjectCollection("supplierenrollentry");
                for (DynamicObject supplierEnrollEntry : supplierEnrollEntryCol) {
                    Long supplierId = supplierEnrollEntry.getLong("enrollsupplier.id");
                    DynamicObject projectPartner = supplierEnrollEntry.getDynamicObject("baoprojectpartner");
                    if (projectPartner != null) {
                        hasMap.put(supplierId, projectPartner.getLong("id"));
                    }
                    supplierIdSet.add(supplierId);
                }
                bidSection.getDynamicObjectCollection("supplierenrollentry").clear();
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierInvitationData});
        }
        DynamicObject[] projectAnnouncementArray = BusinessDataServiceHelper.load((String)(appId + "_project_announcement"), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectId.toString()), new QFilter("id", "!=", (Object)announcementsId), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()), new QFilter("annotype", "=", (Object)"bidproject")}, (String)"createtime desc");
        ArrayList<Long> announcementIdList = new ArrayList<Long>();
        if (projectAnnouncementArray != null && projectAnnouncementArray.length > 0) {
            for (DynamicObject projectAnnouncement : projectAnnouncementArray) {
                projectAnnouncement.set("billstatus", (Object)BillStatusEnum.INVALIDXX.getVal());
                announcementIdList.add(projectAnnouncement.getLong("id"));
            }
            SaveServiceHelper.save((DynamicObject[])projectAnnouncementArray);
        }
        String tenAppId = BidProjectAnnouncementsUtils.getTenderAppId(appId);
        if (announcementIdList != null && announcementIdList.size() > 0 && (applyAnnouncementArray = BusinessDataServiceHelper.load((String)(tenAppId + "_apply"), (String)"status,publishdate, annotitle", (QFilter[])new QFilter[]{new QFilter("id", "in", announcementIdList)})) != null && applyAnnouncementArray.length > 0) {
            for (DynamicObject applyAnnouncement : applyAnnouncementArray) {
                applyAnnouncement.set("status", (Object)BillStatusEnum.INVALIDXX.getVal());
            }
            SaveServiceHelper.save((DynamicObject[])applyAnnouncementArray);
        }
        DeleteServiceHelper.delete((String)(tenAppId + "_mytender"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectId)});
        BizLog.log((String)("clearApplySupplierAndTenderData\u53d1\u5e03\u516c\u544a\u5220\u9664\u5916\u7f51\u6295\u6807\u8be6\u60c5\u6570\u636e\uff0c\u62db\u6807\u7acb\u9879ID: " + bidProjectId));
        if (supplierIdSet != null && supplierIdSet.size() > 0) {
            String notifyTypes = MessageChannelUtil.getNotifyType("Project_Notice_Cancel", "bid_project_announcement");
            for (Long supplierId : supplierIdSet) {
                Long supplierUserId = (Long)hasMap.get(supplierId);
                HashMap<String, Object> msgParam = new HashMap<String, Object>();
                if (projectAnnouncementArray != null && projectAnnouncementArray.length > 0) {
                    msgParam.put("id", projectAnnouncementArray[0].getPkValue());
                }
                msgParam.put("appId", appId);
                msgParam.put("supplierId", supplierId);
                msgParam.put("tplScene", "Project_Notice_Cancel");
                msgParam.put("msgentity", "bid_project_announcement");
                msgParam.put("title", null);
                msgParam.put("content", null);
                msgParam.put("operation", null);
                msgParam.put("urlParams", null);
                if (supplierUserId != null) {
                    msgParam.put("supplierBizUser", supplierUserId);
                } else {
                    msgParam.remove("supplierBizUser");
                }
                MessageCenterHelper.sendMessages(msgParam, false, appId, notifyTypes);
            }
        }
    }

    public static String getSendAnnouncementsSupplierInvitationEntityName(String appId, Long bidProjectId) {
        DynamicObject bidProject = QueryServiceHelper.queryOne((String)(appId + "_project"), (String)"supplierinvitation,biddocument,bidpublish,bidopen,bidevaluation,bidbustalk,biddecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidProjectId)});
        if (bidProject != null && bidProject.getBoolean("supplierinvitation")) {
            return appId + "_supplierinvitation";
        }
        return null;
    }

    public static String getTenderAppId(String appId) {
        if ("bid".equals(appId)) {
            return "ten";
        }
        return "resp";
    }
}

