/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class IPMonitorUtil {
    public static boolean thisRange(String appid, DynamicObject bidproject) {
        Long bidProject = bidproject.getLong("id");
        Set<DynamicObject> supplierSet = IPMonitorUtil.getPublishSupplier(appid, bidproject);
        if (supplierSet == null || supplierSet.size() == 1) {
            return true;
        }
        String entityName = "bid_iprecord";
        String unentityName = "bid_uniprecord";
        if (!"bid".equals(appid)) {
            entityName = "rebm_iprecord";
            unentityName = "rebm_uniprecord";
        }
        QFilter qFilter = new QFilter("bidproject", "=", (Object)bidProject);
        DeleteServiceHelper.delete((String)unentityName, (QFilter[])new QFilter[]{qFilter});
        DynamicObject[] IPDynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)"bidproject,stage,supplier,ip,operationtime", (QFilter[])new QFilter[]{qFilter}, (String)"supplier");
        if (IPDynamicObjects.length == 0) {
            return true;
        }
        HashSet<String> unnormalIPSet = new HashSet<String>();
        HashMap<String, String> iPsupplierMap = new HashMap<String, String>(IPDynamicObjects.length);
        for (DynamicObject ipDynamicObject : IPDynamicObjects) {
            if (ipDynamicObject.get("ip") == null) continue;
            String ip = ipDynamicObject.get("ip").toString();
            String unipsuppliers = "";
            if (ipDynamicObject.getDynamicObject("supplier") == null) continue;
            String idSupplier = ipDynamicObject.getDynamicObject("supplier").getString("id");
            if (iPsupplierMap.containsKey(ipDynamicObject.get("ip"))) {
                String unsupplier = (String)iPsupplierMap.get(ip);
                if (!unsupplier.contains(idSupplier)) {
                    unipsuppliers = unsupplier + "_" + idSupplier;
                    unnormalIPSet.add(ip);
                } else {
                    unipsuppliers = unsupplier;
                }
            } else {
                unipsuppliers = idSupplier;
            }
            iPsupplierMap.put(ip, unipsuppliers);
        }
        if (unnormalIPSet.size() == 0) {
            return true;
        }
        HashMap<String, List> iPDataMap = new HashMap<String, List>(unnormalIPSet.size());
        for (DynamicObject ipDynamicObject : IPDynamicObjects) {
            String ip;
            if (ipDynamicObject.get("ip") == null || !unnormalIPSet.contains(ip = ipDynamicObject.get("ip").toString())) continue;
            if (!iPDataMap.containsKey(ip)) {
                if (ipDynamicObject.getDynamicObject("supplier") == null || ipDynamicObject.getDynamicObject("bidproject") == null) continue;
                ArrayList<DynamicObject> listData = new ArrayList<DynamicObject>();
                listData.add(ipDynamicObject);
                iPDataMap.put(ip, listData);
                continue;
            }
            boolean isNotRepeat = true;
            List listData = (List)iPDataMap.get(ip);
            for (int i = 0; i < listData.size(); ++i) {
                if (ipDynamicObject.getDynamicObject("supplier") == null || ipDynamicObject.getDynamicObject("bidproject") == null) {
                    isNotRepeat = false;
                    break;
                }
                DynamicObject nowdynamicObject = (DynamicObject)listData.get(i);
                Long bidproject1 = nowdynamicObject.getDynamicObject("bidproject").getLong("id");
                Long bidproject2 = ipDynamicObject.getDynamicObject("bidproject").getLong("id");
                Long bidsupplier1 = nowdynamicObject.getDynamicObject("supplier").getLong("id");
                Long bidsupplier2 = ipDynamicObject.getDynamicObject("supplier").getLong("id");
                String stage1 = nowdynamicObject.getString("stage");
                String stage2 = ipDynamicObject.getString("stage");
                if (stage1 == null || stage2 == null) {
                    isNotRepeat = false;
                    break;
                }
                Date operationtime1 = nowdynamicObject.getDate("operationtime");
                Date operationtime2 = ipDynamicObject.getDate("operationtime");
                if (operationtime1 == null || operationtime2 == null) {
                    isNotRepeat = false;
                    break;
                }
                if (!bidproject1.equals(bidproject2) || !bidsupplier1.equals(bidsupplier2) || !stage1.equals(stage2)) continue;
                isNotRepeat = false;
                if (operationtime1.compareTo(operationtime2) >= 0) break;
                listData.set(i, ipDynamicObject);
                break;
            }
            if (!isNotRepeat) continue;
            listData.add(ipDynamicObject);
            iPDataMap.put(ip, listData);
        }
        boolean isnormal = true;
        for (Object key : iPDataMap.keySet()) {
            List undataList = (List)iPDataMap.get(key.toString());
            if (undataList.size() == 0) continue;
            for (int i = 0; i < undataList.size(); ++i) {
                DynamicObject nowdynamicObject = (DynamicObject)undataList.get(i);
                DynamicObject newDataEntity = BusinessDataServiceHelper.newDynamicObject((String)unentityName);
                newDataEntity.set("supplier", (Object)nowdynamicObject);
                newDataEntity.set("bidproject", (Object)bidproject);
                DynamicObject nowsupplier = (DynamicObject)nowdynamicObject.get("supplier");
                if (nowsupplier == null) continue;
                String nowid = nowsupplier.get("id").toString();
                DynamicObjectCollection entryentity = newDataEntity.getDynamicObjectCollection("entryentity");
                for (int j = 0; j < undataList.size(); ++j) {
                    String entryid;
                    DynamicObject dynamicObjectentry = (DynamicObject)undataList.get(j);
                    DynamicObject entrysupplier = (DynamicObject)dynamicObjectentry.get("supplier");
                    if (entrysupplier == null || (entryid = entrysupplier.getString("id")).equals(nowid)) continue;
                    DynamicObject dynamicObject = entryentity.addNew();
                    dynamicObject.set("unsupplier", (Object)dynamicObjectentry);
                    dynamicObject.set("contrastrange", (Object)"thisbidding");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDataEntity});
                isnormal = false;
            }
        }
        return isnormal;
    }

    public static boolean histRange(String appid, DynamicObject bidproject) {
        Long bidProject = bidproject.getLong("id");
        Set<DynamicObject> supplierSet = IPMonitorUtil.getPublishSupplier(appid, bidproject);
        if (supplierSet == null || supplierSet.size() == 1) {
            return true;
        }
        String entityName = "bid_iprecord";
        String unentityName = "bid_uniprecord";
        if (!"bid".equals(appid)) {
            entityName = "rebm_iprecord";
            unentityName = "rebm_uniprecord";
        }
        QFilter qFilterb = new QFilter("bidproject", "=", (Object)bidProject);
        DeleteServiceHelper.delete((String)unentityName, (QFilter[])new QFilter[]{qFilterb});
        ArrayList<Object> ids = new ArrayList<Object>(supplierSet.size());
        for (DynamicObject str : supplierSet) {
            ids.add(str.get("id"));
        }
        QFilter qFilter = new QFilter("supplier", "in", ids);
        DynamicObject[] IPDynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)"bidproject,stage,supplier,ip,operationtime", (QFilter[])new QFilter[]{qFilter}, (String)"supplier, operationtime desc");
        if (IPDynamicObjects.length == 0) {
            return true;
        }
        HashSet<String> unnormalIPSet = new HashSet<String>();
        HashMap<String, String> iPsupplierMap = new HashMap<String, String>(IPDynamicObjects.length);
        for (DynamicObject ipDynamicObject : IPDynamicObjects) {
            if (ipDynamicObject.get("ip") == null) continue;
            String ip = ipDynamicObject.get("ip").toString();
            String unipsuppliers = "";
            if (ipDynamicObject.getDynamicObject("supplier") == null) continue;
            String idSupplier = ipDynamicObject.getDynamicObject("supplier").getString("id");
            if (iPsupplierMap.containsKey(ipDynamicObject.get("ip"))) {
                String unsupplier = (String)iPsupplierMap.get(ip);
                if (!unsupplier.contains(idSupplier)) {
                    unipsuppliers = unsupplier + "_" + idSupplier;
                    unnormalIPSet.add(ip);
                } else {
                    unipsuppliers = unsupplier;
                }
            } else {
                unipsuppliers = idSupplier;
            }
            iPsupplierMap.put(ip, unipsuppliers);
        }
        if (unnormalIPSet.size() == 0) {
            return true;
        }
        HashMap<String, List> iPDataMap = new HashMap<String, List>(unnormalIPSet.size());
        for (DynamicObject ipDynamicObject : IPDynamicObjects) {
            String ip;
            if (ipDynamicObject.get("ip") == null || !unnormalIPSet.contains(ip = ipDynamicObject.get("ip").toString())) continue;
            if (!iPDataMap.containsKey(ip)) {
                if (ipDynamicObject.getDynamicObject("supplier") == null || ipDynamicObject.getDynamicObject("bidproject") == null) continue;
                ArrayList<DynamicObject> listData = new ArrayList<DynamicObject>();
                listData.add(ipDynamicObject);
                iPDataMap.put(ip, listData);
                continue;
            }
            boolean isNotRepeat = true;
            List listData = (List)iPDataMap.get(ip);
            for (int i = 0; i < listData.size(); ++i) {
                if (ipDynamicObject.getDynamicObject("supplier") == null || ipDynamicObject.getDynamicObject("bidproject") == null) {
                    isNotRepeat = false;
                    break;
                }
                DynamicObject nowdynamicObject = (DynamicObject)listData.get(i);
                Long bidproject1 = nowdynamicObject.getDynamicObject("bidproject").getLong("id");
                Long bidproject2 = ipDynamicObject.getDynamicObject("bidproject").getLong("id");
                Long bidsupplier1 = nowdynamicObject.getDynamicObject("supplier").getLong("id");
                Long bidsupplier2 = ipDynamicObject.getDynamicObject("supplier").getLong("id");
                String stage1 = nowdynamicObject.getString("stage");
                String stage2 = ipDynamicObject.getString("stage");
                if (stage1 == null || stage2 == null) {
                    isNotRepeat = false;
                    break;
                }
                Date operationtime1 = nowdynamicObject.getDate("operationtime");
                Date operationtime2 = ipDynamicObject.getDate("operationtime");
                if (operationtime1 == null || operationtime2 == null) {
                    isNotRepeat = false;
                    break;
                }
                if (!bidproject1.equals(bidproject2) || !bidsupplier1.equals(bidsupplier2) || !stage1.equals(stage2)) continue;
                isNotRepeat = false;
                if (operationtime1.compareTo(operationtime2) >= 0) break;
                listData.set(i, ipDynamicObject);
                break;
            }
            if (!isNotRepeat) continue;
            listData.add(ipDynamicObject);
            iPDataMap.put(ip, listData);
        }
        Date enddate = null;
        for (Object key3 : iPDataMap.keySet()) {
            List undataList3 = (List)iPDataMap.get(key3.toString());
            if (undataList3.size() == 0) continue;
            for (int i = 0; i < undataList3.size(); ++i) {
                Date endoperationtime;
                Long id;
                DynamicObject nowdynamicObject = (DynamicObject)undataList3.get(i);
                DynamicObject bidproject1 = nowdynamicObject.getDynamicObject("bidproject");
                if (bidproject1 == null || !bidProject.equals(id = Long.valueOf(bidproject1.getLong("id"))) || (endoperationtime = nowdynamicObject.getDate("operationtime")) == null) continue;
                enddate = enddate == null ? endoperationtime : (enddate.compareTo(endoperationtime) > 0 ? enddate : endoperationtime);
            }
        }
        boolean isnormal = true;
        for (Object key : iPDataMap.keySet()) {
            List undataList = (List)iPDataMap.get(key.toString());
            if (undataList.size() == 0) continue;
            for (int i = 0; i < undataList.size(); ++i) {
                Long id;
                DynamicObject bidproject1;
                DynamicObject nowdynamicObject = (DynamicObject)undataList.get(i);
                Date endoperationtime = nowdynamicObject.getDate("operationtime");
                if (endoperationtime == null || enddate == null || endoperationtime.compareTo(enddate) > 0 || (bidproject1 = nowdynamicObject.getDynamicObject("bidproject")) == null || !bidProject.equals(id = Long.valueOf(bidproject1.getLong("id")))) continue;
                DynamicObject newDataEntity = BusinessDataServiceHelper.newDynamicObject((String)unentityName);
                newDataEntity.set("supplier", (Object)nowdynamicObject);
                newDataEntity.set("bidproject", (Object)bidproject);
                DynamicObject nowsupplier = (DynamicObject)nowdynamicObject.get("supplier");
                if (nowsupplier == null) continue;
                String nowid = nowsupplier.get("id").toString();
                DynamicObjectCollection entryentity = newDataEntity.getDynamicObjectCollection("entryentity");
                boolean isSave = false;
                for (int j = 0; j < undataList.size(); ++j) {
                    Date endoperat;
                    String entryid;
                    DynamicObject dynamicObjectentry = (DynamicObject)undataList.get(j);
                    DynamicObject entrysupplier = (DynamicObject)dynamicObjectentry.get("supplier");
                    if (entrysupplier == null || (entryid = entrysupplier.getString("id")).equals(nowid) || (endoperat = dynamicObjectentry.getDate("operationtime")).compareTo(enddate) > 0) continue;
                    DynamicObject dynamicObject = entryentity.addNew();
                    dynamicObject.set("unsupplier", (Object)dynamicObjectentry);
                    DynamicObject bidproject2 = dynamicObjectentry.getDynamicObject("bidproject");
                    if (bidproject2 == null) continue;
                    Long id2 = bidproject2.getLong("id");
                    if (!bidProject.equals(id2)) {
                        dynamicObject.set("contrastrange", (Object)"histbidding");
                    } else {
                        dynamicObject.set("contrastrange", (Object)"thisbidding");
                    }
                    isSave = true;
                }
                if (!isSave) continue;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDataEntity});
                isnormal = false;
            }
        }
        return isnormal;
    }

    public static Set<DynamicObject> getPublishSupplier(String appid, DynamicObject bidproject) {
        String bidpublishName = "bid_bidpublish";
        if (!"bid".equals(appid)) {
            bidpublishName = "rebm_bidpublish";
        }
        Long bidProject = bidproject.getLong("id");
        QFilter qFilterstatu = new QFilter("billstatus", "=", (Object)"P");
        QFilter qFilterproj = new QFilter("bidproject", "=", (Object)bidProject);
        DynamicObject bidpublish = BusinessDataServiceHelper.loadSingle((String)bidpublishName, (QFilter[])new QFilter[]{qFilterproj, qFilterstatu});
        if (bidpublish == null) {
            return null;
        }
        HashSet<DynamicObject> supplierSet = new HashSet<DynamicObject>(10);
        DynamicObjectCollection bidsections = bidpublish.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidsection : bidsections) {
            DynamicObjectCollection supplierentrys = bidsection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplieren : supplierentrys) {
                if (supplieren.getDynamicObject("supplier") == null) continue;
                supplierSet.add(supplieren.getDynamicObject("supplier"));
            }
        }
        return supplierSet;
    }

    public static boolean checkIsBidIPAdmin(String appid, Object userId) {
        return QueryServiceHelper.exists((String)"perm_userrole", (QFilter[])new QFilter[]{new QFilter("user", "=", userId), new QFilter("role", "=", (Object)IPMonitorUtil.getBidAdminRoleIdByAppId(appid))});
    }

    public static String getBidAdminRoleIdByAppId(String appid) {
        return "bid".equals(appid) ? "33BZMFUWW76S" : "34+A9ZTHSQNK";
    }
}

