/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.common.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SupplierHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class MessageCenterHelper {
    private static Log logger = LogFactory.getLog(MessageCenterHelper.class);

    public static void sendMessage(Map<String, Object> param, DynamicObjectCollection supplierEntryColl, boolean isUrl) {
        for (DynamicObject supplierEntry : supplierEntryColl) {
            if (supplierEntry.getLong("id") == 0L || supplierEntry.getDynamicObject("supplier") == null) continue;
            param.put("supplierId", (Long)supplierEntry.getDynamicObject("supplier").getPkValue());
            MessageCenterHelper.sendMessage(param, isUrl);
        }
    }

    public static void sendMessage(Map<String, Object> param, boolean isUrl, Set<Long> supplierIds, Map supplierBizUsers) {
        for (Long supplierId : supplierIds) {
            if (supplierBizUsers.get(supplierId) == null) continue;
            param.put("supplierId", supplierId);
            param.put("supplierBizUser", (Long)supplierBizUsers.get(supplierId));
            MessageCenterHelper.sendMessage(param, isUrl);
        }
    }

    public static void sendMessageByPartnerUser(Map<String, Object> param, Set<Object> partnerIds, boolean isUrl) {
        if (partnerIds == null || partnerIds.size() == 0) {
            return;
        }
        boolean enable = SystemParamHelper.getSystemParameter((String)param.get("appId"), OrgUnitHelper.ROOT_ORG_ID, "msg");
        if (!enable) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageInfo.setSenderName(RequestContext.get().getUserName());
        ArrayList<Long> receiveUserIds = new ArrayList<Long>(100);
        for (Object pk : partnerIds) {
            receiveUserIds.add((Long)pk);
        }
        messageInfo.setUserIds(receiveUserIds);
        messageInfo.setBizDataId((Long)param.get("pkId"));
        messageInfo.setEntityNumber((String)param.get("formId"));
        messageInfo.setOperation((String)param.get("operation"));
        messageInfo.setTitle((String)param.get("title"));
        messageInfo.setContent((String)param.get("content"));
        messageInfo.setSignleEmail(true);
        messageInfo.setTplScene((String)param.get("tplScene"));
        List urlParams = (List)param.get("urlParams");
        if (isUrl && urlParams != null && urlParams.size() > 0) {
            StringBuilder buf = new StringBuilder();
            String contentUrl = System.getProperty("domain.contextUrl");
            logger.info("First contentUrl---------------" + contentUrl);
            String tenantCode = RequestContext.get().getTenantCode();
            logger.info("tenantCode---------------" + tenantCode);
            contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
            logger.info("Second contentUrl---------------" + contentUrl);
            int urlParamIndex = 0;
            buf.append(contentUrl);
            for (String urlParam : urlParams) {
                String temp;
                if (urlParamIndex == 0) {
                    temp = "?" + urlParam + "=" + param.get(urlParam);
                    buf.append(temp);
                } else {
                    temp = "&" + urlParam + "=" + param.get(urlParam);
                    buf.append(temp);
                }
                ++urlParamIndex;
            }
            buf.append("&checkRightAppId=");
            buf.append(param.get("appId"));
            messageInfo.setContentUrl(buf.toString());
        }
        MessageCenterHelper.sendMessage(messageInfo);
    }

    public static void sendMessage(MessageInfo messageInfo) {
        messageInfo.setSignleEmail(true);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public static void sendMessage(Map<String, Object> param, boolean isUrl) {
        boolean enable = SystemParamHelper.getSystemParameter((String)param.get("appId"), OrgUnitHelper.ROOT_ORG_ID, "msg");
        if (!enable) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageInfo.setSenderName(RequestContext.get().getUserName());
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        Long adminUserId = SupplierHelper.listAdminUserIdBySupplier((Long)param.get("supplierId"));
        receiveUserIds.add(adminUserId);
        Long supplierBizUser = (Long)param.get("supplierBizUser");
        if (supplierBizUser != null && supplierBizUser != 0L && !adminUserId.equals(supplierBizUser)) {
            receiveUserIds.add(supplierBizUser);
        }
        messageInfo.setUserIds(receiveUserIds);
        messageInfo.setBizDataId((Long)param.get("pkId"));
        messageInfo.setEntityNumber((String)param.get("formId"));
        messageInfo.setOperation((String)param.get("operation"));
        messageInfo.setTitle((String)param.get("title"));
        messageInfo.setContent((String)param.get("content"));
        messageInfo.setSignleEmail(true);
        messageInfo.setTplScene((String)param.get("tplScene"));
        List urlParams = (List)param.get("urlParams");
        if (isUrl && urlParams != null && urlParams.size() > 0) {
            StringBuilder buf = new StringBuilder();
            String contentUrl = System.getProperty("domain.contextUrl");
            logger.info("First contentUrl---------------" + contentUrl);
            String tenantCode = RequestContext.get().getTenantCode();
            logger.info("tenantCode---------------" + tenantCode);
            contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
            logger.info("Second contentUrl---------------" + contentUrl);
            int urlParamIndex = 0;
            buf.append(contentUrl);
            for (String urlParam : urlParams) {
                String temp;
                if (urlParamIndex == 0) {
                    temp = "?" + urlParam + "=" + param.get(urlParam);
                    buf.append(temp);
                } else {
                    temp = "&" + urlParam + "=" + param.get(urlParam);
                    buf.append(temp);
                }
                ++urlParamIndex;
            }
            buf.append("&checkRightAppId=");
            buf.append(param.get("appId"));
            messageInfo.setContentUrl(buf.toString());
        }
        MessageCenterHelper.sendMessage(messageInfo);
    }

    public static void sendMessages(HashMap<String, Object> param, boolean isUrl, Set<Long> supplierIds, Map<Long, Long> supplierBizUsers) {
        for (Long supplierId : supplierIds) {
            param.put("supplierId", supplierId);
            if (!supplierBizUsers.containsKey(supplierId)) continue;
            param.put("supplierBizUser", supplierBizUsers.get(supplierId));
            MessageCenterHelper.sendMessages(param, isUrl);
        }
    }

    public static void sendMessages(HashMap<String, Object> param, boolean isUrl) {
        boolean enable = SystemParamHelper.getSystemParameter((String)param.get("appId"), OrgUnitHelper.ROOT_ORG_ID, "msg");
        if (!enable) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageInfo.setSenderName(RequestContext.get().getUserName());
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        Long supplierBizUser = (Long)param.get("supplierBizUser");
        receiveUserIds.add(supplierBizUser);
        messageInfo.setUserIds(receiveUserIds);
        messageInfo.setBizDataId((Long)param.get("id"));
        messageInfo.setEntityNumber((String)param.get("msgentity"));
        messageInfo.setOperation((String)param.get("operation"));
        messageInfo.setTitle((String)param.get("title"));
        messageInfo.setContent((String)param.get("content"));
        messageInfo.setSignleEmail(true);
        messageInfo.setTplScene((String)param.get("tplScene"));
        List urlParams = (List)param.get("urlParams");
        if (isUrl && urlParams != null && urlParams.size() > 0) {
            StringBuilder buf = new StringBuilder();
            String contentUrl = System.getProperty("domain.contextUrl");
            logger.info("First contentUrl---------------" + contentUrl);
            String tenantCode = RequestContext.get().getTenantCode();
            logger.info("tenantCode---------------" + tenantCode);
            contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
            logger.info("Second contentUrl---------------" + contentUrl);
            buf.append(contentUrl);
            int urlParamIndex = 0;
            for (String urlParam : urlParams) {
                String temp;
                if (urlParamIndex == 0) {
                    temp = "?" + urlParam + "=" + param.get(urlParam);
                    buf.append(temp);
                } else {
                    temp = "&" + urlParam + "=" + param.get(urlParam);
                    buf.append(temp);
                }
                ++urlParamIndex;
            }
            buf.append("&checkRightAppId=");
            buf.append(param.get("appId"));
            messageInfo.setContentUrl(buf.toString());
        }
        messageInfo.setNotifyType(param.get("notifyType") == null ? null : param.get("notifyType").toString());
        MessageCenterHelper.sendMessage(messageInfo);
    }

    public static void sendMessages(HashMap<String, Object> param, boolean isUrl, List<Long> receiveUserIds) {
        boolean enable = SystemParamHelper.getSystemParameter((String)param.get("appId"), OrgUnitHelper.ROOT_ORG_ID, "msg");
        if (!enable) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageInfo.setSenderName(RequestContext.get().getUserName());
        messageInfo.setUserIds(receiveUserIds);
        messageInfo.setBizDataId((Long)param.get("id"));
        messageInfo.setEntityNumber((String)param.get("msgentity"));
        messageInfo.setOperation((String)param.get("operation"));
        messageInfo.setTitle((String)param.get("title"));
        messageInfo.setContent((String)param.get("content"));
        messageInfo.setSignleEmail(true);
        messageInfo.setTplScene((String)param.get("tplScene"));
        List urlParams = (List)param.get("urlParams");
        if (isUrl && urlParams != null && urlParams.size() > 0) {
            StringBuilder buf = new StringBuilder();
            String contentUrl = System.getProperty("domain.contextUrl");
            logger.info("First contentUrl---------------" + contentUrl);
            String tenantCode = RequestContext.get().getTenantCode();
            logger.info("tenantCode---------------" + tenantCode);
            contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
            logger.info("Second contentUrl---------------" + contentUrl);
            int urlParamIndex = 0;
            buf.append(contentUrl);
            for (String urlParam : urlParams) {
                String temp;
                if (urlParamIndex == 0) {
                    temp = "?" + urlParam + "=" + param.get(urlParam);
                    buf.append(temp);
                } else {
                    temp = "&" + urlParam + "=" + param.get(urlParam);
                    buf.append(temp);
                }
                ++urlParamIndex;
            }
            buf.append("&checkRightAppId=");
            buf.append(param.get("appId"));
            messageInfo.setContentUrl(buf.toString());
        }
        messageInfo.setNotifyType(param.get("notifyType") == null ? null : param.get("notifyType").toString());
        MessageCenterHelper.sendMessage(messageInfo);
    }

    public static void sendMessages(HashMap<String, Object> param, boolean isUrl, String appid) {
        boolean enable = SystemParamHelper.getSystemParameter((String)param.get("appId"), OrgUnitHelper.ROOT_ORG_ID, "msg");
        if (!enable) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageInfo.setSenderName(RequestContext.get().getUserName());
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        Long adminUserId = null;
        if ("rebm".equals(appid)) {
            long id = (Long)SupplierHelper.getSysSupByRESMSup((Long)param.get("supplierId")).getPkValue();
            adminUserId = SupplierHelper.listAdminUserIdBySupplier(id);
            receiveUserIds.add(adminUserId);
        } else {
            adminUserId = SupplierHelper.listAdminUserIdBySupplier((Long)param.get("supplierId"));
            receiveUserIds.add(adminUserId);
        }
        Long supplierBizUser = (Long)param.get("supplierBizUser");
        if (supplierBizUser != null && supplierBizUser != 0L && !adminUserId.equals(supplierBizUser)) {
            receiveUserIds.add(supplierBizUser);
        }
        messageInfo.setUserIds(receiveUserIds);
        messageInfo.setBizDataId((Long)param.get("id"));
        messageInfo.setEntityNumber((String)param.get("msgentity"));
        messageInfo.setOperation((String)param.get("operation"));
        messageInfo.setTitle((String)param.get("title"));
        messageInfo.setContent((String)param.get("content"));
        messageInfo.setSignleEmail(true);
        messageInfo.setTplScene((String)param.get("tplScene"));
        StringBuilder sb = new StringBuilder();
        List urlParams = (List)param.get("urlParams");
        if (isUrl && urlParams != null && urlParams.size() > 0) {
            String contentUrl = System.getProperty("domain.contextUrl");
            logger.info("First contentUrl---------------" + contentUrl);
            String tenantCode = RequestContext.get().getTenantCode();
            logger.info("tenantCode---------------" + tenantCode);
            contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
            logger.info("Second contentUrl---------------" + contentUrl);
            sb.append(contentUrl);
            int urlParamIndex = 0;
            for (String urlParam : urlParams) {
                String temp;
                if (urlParamIndex == 0) {
                    temp = "?" + urlParam + "=" + param.get(urlParam);
                    sb.append(temp);
                } else {
                    temp = "&" + urlParam + "=" + param.get(urlParam);
                    sb.append(temp);
                }
                ++urlParamIndex;
            }
            sb.append("&checkRightAppId=");
            sb.append(param.get("appId"));
            messageInfo.setContentUrl(sb.toString());
        }
        String notifyType = MessageChannelUtil.getNotifyType((String)param.get("tplScene"), (String)param.get("msgentity"));
        messageInfo.setNotifyType(notifyType);
        MessageCenterHelper.sendMessage(messageInfo);
    }

    public static void sendMessagesToOpetator(HashMap<String, Object> param, boolean isUrl, List<Long> receiveUserIds) {
        boolean enable = SystemParamHelper.getSystemParameter((String)param.get("appId"), OrgUnitHelper.ROOT_ORG_ID, "msg");
        if (!enable) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageInfo.setSenderName(RequestContext.get().getUserName());
        messageInfo.setUserIds(receiveUserIds);
        messageInfo.setBizDataId((Long)param.get("id"));
        messageInfo.setEntityNumber((String)param.get("msgentity"));
        messageInfo.setOperation((String)param.get("operation"));
        messageInfo.setTitle((String)param.get("title"));
        messageInfo.setContent((String)param.get("content"));
        messageInfo.setSignleEmail(true);
        String notifyType = MessageChannelUtil.getNotifyType((String)param.get("tplScene"), (String)param.get("msgentity"));
        messageInfo.setNotifyType(notifyType);
        messageInfo.setTplScene((String)param.get("tplScene"));
        List urlParams = (List)param.get("urlParams");
        if (isUrl && urlParams != null && urlParams.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String contentUrl = System.getProperty("domain.contextUrl");
            logger.info("First contentUrl---------------" + contentUrl);
            String tenantCode = RequestContext.get().getTenantCode();
            logger.info("tenantCode---------------" + tenantCode);
            contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
            logger.info("Second contentUrl---------------" + contentUrl);
            int urlParamIndex = 0;
            sb.append(contentUrl);
            for (String urlParam : urlParams) {
                String temp;
                if (urlParamIndex == 0) {
                    temp = "?" + urlParam + "=" + param.get(urlParam);
                    sb.append(temp);
                } else {
                    temp = "&" + urlParam + "=" + param.get(urlParam);
                    sb.append(temp);
                }
                ++urlParamIndex;
            }
            sb.append("&checkRightAppId=");
            sb.append(param.get("appId"));
            messageInfo.setContentUrl(sb.toString());
        }
        MessageCenterHelper.sendMessage(messageInfo);
    }

    public static void sendMessagesToOpetator(HashMap<String, Object> param, boolean isUrl, List<Long> receiveUserIds, String notifyType) {
        boolean enable = SystemParamHelper.getSystemParameter((String)param.get("appId"), OrgUnitHelper.ROOT_ORG_ID, "msg");
        if (!enable) {
            return;
        }
        if (!StringUtils.isNotEmpty((CharSequence)notifyType)) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setSenderId(null);
        messageInfo.setSenderName(RequestContext.get().getUserName());
        messageInfo.setUserIds(receiveUserIds);
        messageInfo.setBizDataId((Long)param.get("id"));
        messageInfo.setEntityNumber((String)param.get("msgentity"));
        messageInfo.setOperation((String)param.get("operation"));
        messageInfo.setTitle((String)param.get("title"));
        messageInfo.setContent((String)param.get("content"));
        messageInfo.setSignleEmail(true);
        messageInfo.setNotifyType(notifyType);
        messageInfo.setTplScene((String)param.get("tplScene"));
        List urlParams = (List)param.get("urlParams");
        if (isUrl && urlParams != null && urlParams.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String contentUrl = System.getProperty("domain.contextUrl");
            logger.info("First contentUrl---------------" + contentUrl);
            String tenantCode = RequestContext.get().getTenantCode();
            logger.info("tenantCode---------------" + tenantCode);
            contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
            logger.info("Second contentUrl---------------" + contentUrl);
            int urlParamIndex = 0;
            sb.append(contentUrl);
            for (String urlParam : urlParams) {
                String temp;
                if (urlParamIndex == 0) {
                    temp = "?" + urlParam + "=" + param.get(urlParam);
                    sb.append(temp);
                } else {
                    temp = "&" + urlParam + "=" + param.get(urlParam);
                    sb.append(temp);
                }
                ++urlParamIndex;
            }
            sb.append("&checkRightAppId=");
            sb.append(param.get("appId"));
            messageInfo.setContentUrl(sb.toString());
        }
        MessageCenterHelper.sendMessage(messageInfo);
    }

    public static void sendMessages(HashMap<String, Object> msgParam, DynamicObjectCollection supplierEntryColl, boolean isUrl) {
        for (DynamicObject supplierEntry : supplierEntryColl) {
            if (supplierEntry.getLong("id") == 0L || supplierEntry.getDynamicObject("supplier") == null) continue;
            msgParam.put("supplierBizUser", (Long)supplierEntry.getDynamicObject("supplier").getPkValue());
            msgParam.put("supplierId", (Long)supplierEntry.getDynamicObject("supplier").getPkValue());
            MessageCenterHelper.sendMessages(msgParam, isUrl);
        }
    }

    public static void sendMessages(HashMap<String, Object> msgParam, DynamicObject supplierEntry, boolean isUrl) {
        msgParam.put("supplierBizUser", supplierEntry.getLong("invitationuser.id"));
        msgParam.put("supplierId", (Long)supplierEntry.getDynamicObject("supplier").getPkValue());
        MessageCenterHelper.sendMessages(msgParam, isUrl);
    }

    public static void sendMessages(HashMap<String, Object> param, boolean isUrl, String appid, String notifyType) {
        Long supplierBizUser;
        boolean enable = SystemParamHelper.getSystemParameter((String)param.get("appId"), OrgUnitHelper.ROOT_ORG_ID, "msg");
        if (!enable) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageInfo.setSenderName(RequestContext.get().getUserName());
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        Long adminUserId = 0L;
        Long supplierId = (Long)param.get("supplierId");
        if (supplierId.compareTo(0L) != 0) {
            if ("rebm".equals(appid)) {
                long id = (Long)SupplierHelper.getSysSupByRESMSup((Long)param.get("supplierId")).getPkValue();
                adminUserId = SupplierHelper.listAdminUserIdBySupplier(id);
                receiveUserIds.add(adminUserId);
            } else {
                adminUserId = SupplierHelper.listAdminUserIdBySupplier((Long)param.get("supplierId"));
                receiveUserIds.add(adminUserId);
            }
        }
        if (param.containsKey("supplierBizUser") && (supplierBizUser = (Long)param.get("supplierBizUser")) != null && supplierBizUser != 0L && !adminUserId.equals(supplierBizUser)) {
            receiveUserIds.add(supplierBizUser);
        }
        messageInfo.setUserIds(receiveUserIds);
        messageInfo.setBizDataId((Long)param.get("id"));
        messageInfo.setEntityNumber((String)param.get("msgentity"));
        messageInfo.setOperation((String)param.get("operation"));
        messageInfo.setTitle((String)param.get("title"));
        messageInfo.setContent((String)param.get("content"));
        messageInfo.setSignleEmail(true);
        messageInfo.setTplScene((String)param.get("tplScene"));
        StringBuilder sb = new StringBuilder();
        List urlParams = (List)param.get("urlParams");
        if (isUrl && urlParams != null && urlParams.size() > 0) {
            String contentUrl = System.getProperty("domain.contextUrl");
            logger.info("First contentUrl---------------" + contentUrl);
            String tenantCode = RequestContext.get().getTenantCode();
            logger.info("tenantCode---------------" + tenantCode);
            contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
            logger.info("Second contentUrl---------------" + contentUrl);
            sb.append(contentUrl);
            int urlParamIndex = 0;
            for (String urlParam : urlParams) {
                String temp;
                if (urlParamIndex == 0) {
                    temp = "?" + urlParam + "=" + param.get(urlParam);
                    sb.append(temp);
                } else {
                    temp = "&" + urlParam + "=" + param.get(urlParam);
                    sb.append(temp);
                }
                ++urlParamIndex;
            }
            sb.append("&checkRightAppId=");
            sb.append(param.get("appId"));
            messageInfo.setContentUrl(sb.toString());
        }
        messageInfo.setNotifyType(notifyType);
        MessageCenterHelper.sendMessage(messageInfo);
    }

    public static void sendMessages(HashMap<String, Object> param, boolean isUrl, Set<Long> supplierIds, Map<Long, Long> supplierBizUsers, String notifyType) {
        for (Long supplierId : supplierIds) {
            param.put("supplierId", supplierId);
            if (!supplierBizUsers.containsKey(supplierId)) continue;
            param.put("supplierBizUser", supplierBizUsers.get(supplierId));
            MessageCenterHelper.sendMessagesFromNotify(param, isUrl, notifyType);
        }
    }

    public static void sendMessagesFromNotify(HashMap<String, Object> param, boolean isUrl, String notifyType) {
        boolean enable = SystemParamHelper.getSystemParameter((String)param.get("appId"), OrgUnitHelper.ROOT_ORG_ID, "msg");
        if (!enable) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageInfo.setSenderName(RequestContext.get().getUserName());
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        Long supplierBizUser = (Long)param.get("supplierBizUser");
        receiveUserIds.add(supplierBizUser);
        messageInfo.setUserIds(receiveUserIds);
        messageInfo.setBizDataId((Long)param.get("id"));
        messageInfo.setEntityNumber((String)param.get("msgentity"));
        messageInfo.setOperation((String)param.get("operation"));
        messageInfo.setTitle((String)param.get("title"));
        messageInfo.setContent((String)param.get("content"));
        messageInfo.setSignleEmail(true);
        messageInfo.setTplScene((String)param.get("tplScene"));
        List urlParams = (List)param.get("urlParams");
        if (isUrl && urlParams != null && urlParams.size() > 0) {
            StringBuilder buf = new StringBuilder();
            String contentUrl = System.getProperty("domain.contextUrl");
            logger.info("First contentUrl---------------" + contentUrl);
            String tenantCode = RequestContext.get().getTenantCode();
            logger.info("tenantCode---------------" + tenantCode);
            contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
            logger.info("Second contentUrl---------------" + contentUrl);
            buf.append(contentUrl);
            int urlParamIndex = 0;
            for (String urlParam : urlParams) {
                String temp;
                if (urlParamIndex == 0) {
                    temp = "?" + urlParam + "=" + param.get(urlParam);
                    buf.append(temp);
                } else {
                    temp = "&" + urlParam + "=" + param.get(urlParam);
                    buf.append(temp);
                }
                ++urlParamIndex;
            }
            buf.append("&checkRightAppId=");
            buf.append(param.get("appId"));
            messageInfo.setContentUrl(buf.toString());
        }
        messageInfo.setNotifyType(notifyType);
        MessageCenterHelper.sendMessage(messageInfo);
    }

    public static Set<Long> getSendUserId(String appId, Long bidProjectId) {
        HashSet<Long> sendUserIdSet = new HashSet<Long>();
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)(appId + "_project"));
        HashSet<Long> supplierIdSet = new HashSet<Long>();
        HashSet<Object> userIdSet = new HashSet<Object>();
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidpublish"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectId), new QFilter("billstatus", "not in", (Object)new String[]{BillStatusEnum.INVALID.getVal()})});
        if (bidPublish != null) {
            DynamicObjectCollection bidSectionCol = bidPublish.getDynamicObjectCollection("bidsection");
            for (Object bidSection : bidSectionCol) {
                DynamicObjectCollection dynamicObjectCollection = bidSection.getDynamicObjectCollection("supplierentry");
                for (Object supplierEntry : dynamicObjectCollection) {
                    DynamicObject projectPartner;
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    if (supplier != null) {
                        supplierIdSet.add(supplier.getLong("id"));
                    }
                    if ((projectPartner = supplierEntry.getDynamicObject("projectpartner")) == null) continue;
                    userIdSet.add(projectPartner.getPkValue());
                }
            }
        } else {
            DynamicObject projectPartner;
            DynamicObject supplier;
            DynamicObjectCollection supplierEntryCol;
            DynamicObjectCollection bidSectionColl;
            DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((String)(appId + "_supplierinvitation"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectId), new QFilter("billstatus", "not in", (Object)new String[]{BillStatusEnum.INVALIDXX.getVal()})});
            if (supplierInvitation != null) {
                bidSectionColl = supplierInvitation.getDynamicObjectCollection("bidsection");
                for (DynamicObject dynamicObject : bidSectionColl) {
                    supplierEntryCol = dynamicObject.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier != null) {
                            supplierIdSet.add(supplier.getLong("id"));
                        }
                        if ((projectPartner = supplierEntry.getDynamicObject("projectpartner")) == null) continue;
                        userIdSet.add(projectPartner.getPkValue());
                    }
                }
            } else {
                bidSectionColl = bidProject.getDynamicObjectCollection("bidrollsection");
                for (DynamicObject dynamicObject : bidSectionColl) {
                    supplierEntryCol = dynamicObject.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier != null) {
                            supplierIdSet.add(supplier.getLong("id"));
                        }
                        if ((projectPartner = supplierEntry.getDynamicObject("projectpartner")) == null) continue;
                        userIdSet.add(projectPartner.getPkValue());
                    }
                }
            }
        }
        if (!userIdSet.isEmpty()) {
            QFilter userQFilter = new QFilter("user", "in", userIdSet);
            DynamicObject[] bosBizPartnerUsers = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"id,isadmin,user,enable", (QFilter[])new QFilter[]{userQFilter});
            for (DynamicObject bosBizPartnerUser : bosBizPartnerUsers) {
                DynamicObject user = bosBizPartnerUser.getDynamicObject("user");
                boolean enable = bosBizPartnerUser.getBoolean("enable");
                if (user == null || !enable) continue;
                sendUserIdSet.add(user.getLong("id"));
            }
        }
        if (!supplierIdSet.isEmpty()) {
            List<Object> adminUserIdList = new ArrayList();
            List<Long> supplierIdList = supplierIdSet.stream().collect(Collectors.toList());
            if ("rebm".equals(appId)) {
                List<Long> sysSupplierIdList = SupplierHelper.getSysSupByResmSupplier(supplierIdList);
                adminUserIdList = SupplierHelper.listAdminUserIdListBySupplier(sysSupplierIdList);
            } else {
                adminUserIdList = SupplierHelper.listAdminUserIdListBySupplier(supplierIdList);
            }
            for (Long l : adminUserIdList) {
                sendUserIdSet.add(l);
            }
        }
        return sendUserIdSet;
    }

    public static List<Long> getSendUserIdList(String appId, Long bidProjectId) {
        Set<Long> sendUserIdSet = MessageCenterHelper.getSendUserId(appId, bidProjectId);
        return sendUserIdSet.stream().collect(Collectors.toList());
    }

    public static Table<Object, Object, List<Long>> getPublishMap(String appId, Object bidProjectId) {
        HashBasedTable table = HashBasedTable.create();
        ArrayList<Long> userIdList = null;
        QFilter qFilter = new QFilter("bidproject", "=", bidProjectId);
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal());
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidpublish"), (QFilter[])qFilter.toArray());
        if (bidPublish != null) {
            DynamicObjectCollection bidSectionCol = bidPublish.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidSection : bidSectionCol) {
                String sectionName = bidSection.getString("sectionname");
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    if (supplier == null) continue;
                    userIdList = new ArrayList<Long>();
                    if ("rebm".equals(appId)) {
                        userIdList.add(SupplierHelper.listAdminUserIdByResmSupplier(supplier.getLong("id")));
                    } else {
                        userIdList.add(SupplierHelper.listAdminUserIdBySupplier(supplier.getLong("id")));
                    }
                    DynamicObject projectPartner = supplierEntry.getDynamicObject("projectpartner");
                    if (projectPartner != null) {
                        userIdList.add(projectPartner.getLong("id"));
                    }
                    table.put((Object)sectionName, supplier.getPkValue(), userIdList.stream().distinct().collect(Collectors.toList()));
                }
            }
        }
        return table;
    }
}

