/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;

public class MobileDynamicEntryUtils {
    public static void rebuildGridCols(IFormView view, String entryKey, List<Map<String, Object>> dataList, Map<String, String> fieldsMap) {
        Map<String, Object> gridMeta = MobileDynamicEntryUtils.createGridColumns(fieldsMap);
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(entryKey, "createGridColumns", new Object[]{gridMeta});
        int pageIndex = 1;
        EntryGrid grid = (EntryGrid)view.getControl(entryKey);
        grid.getEntryState().setCurrentPageIndex(Integer.valueOf(pageIndex));
        ArrayList<String> fields = new ArrayList<String>(30);
        fieldsMap.forEach((key, value) -> fields.add((String)key));
        Map<String, Object> data = MobileDynamicEntryUtils.createGridPageData(pageIndex, dataList, fields);
        clientViewProxy.setEntryProperty(entryKey, "data", data);
    }

    private static Map<String, Object> createGridPageData(int pageIndex, List<Map<String, Object>> dataList, List<String> fields) {
        List<Object> rows = MobileDynamicEntryUtils.createRowsData(pageIndex, dataList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rowcount", dataList.size());
        data.put("rows", rows);
        data.put("pagerows", 10);
        data.put("pageindex", pageIndex);
        data.put("isSplitPage", Boolean.TRUE);
        data.put("pagecount", 2);
        data.put("datacount", dataList.size());
        Map<String, Integer> dataIndex = MobileDynamicEntryUtils.createDataIndex(data, fields);
        data.put("dataindex", dataIndex);
        return data;
    }

    private static Map<String, Integer> createDataIndex(Map<String, Object> data, List<String> fields) {
        int i;
        HashMap<String, Integer> dataIndex = new HashMap<String, Integer>(100);
        dataIndex.put("rk", 0);
        dataIndex.put("id", 1);
        int row = 1;
        for (i = 0; i < fields.size(); ++i) {
            dataIndex.put(fields.get(i), ++row);
        }
        i = data.size() + 1;
        dataIndex.put("l", i);
        dataIndex.put("s", i + 1);
        dataIndex.put("vi", i + 2);
        dataIndex.put("cprop", i + 3);
        return dataIndex;
    }

    private static List<Object> createRowsData(int pageIndex, List<Map<String, Object>> dataList) {
        ArrayList<Object> rows = new ArrayList<Object>(100);
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> map = dataList.get(i);
            ArrayList<Object> row = new ArrayList<Object>(100);
            int seq = (pageIndex - 1) * 10 + i + 1;
            row.add(seq - 1);
            row.add("");
            ArrayList<String> list = new ArrayList<String>(map.keySet());
            for (String key : list) {
                row.add(map.get(key));
            }
            rows.add(row);
        }
        return rows;
    }

    private static Map<String, Object> createGridColumns(Map<String, String> fieldsMap) {
        ArrayList<Map<String, Object>> columns = new ArrayList<Map<String, Object>>();
        MobileDynamicEntryUtils.buildColumn(columns, fieldsMap);
        HashMap<String, Object> gridMeta = new HashMap<String, Object>();
        gridMeta.put("rk", "rk");
        gridMeta.put("seq", "seq");
        gridMeta.put("columns", columns);
        gridMeta.put("vi", 63);
        return gridMeta;
    }

    private static void buildColumn(List<Map<String, Object>> columns, Map<String, String> fieldsMap) {
        String type = "text";
        fieldsMap.forEach((key, value) -> {
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                String[] split = value.split(":");
                String header = split[0];
                String width = split[1];
                columns.add(MobileDynamicEntryUtils.createColumn(key, header, type, width));
            }
        });
    }

    private static Map<String, Object> createColumn(String key, String caption, String type, String width) {
        HashMap<String, Object> txtColumn = new HashMap<String, Object>();
        txtColumn.put("dataIndex", key);
        txtColumn.put("header", new LocaleString(caption));
        txtColumn.put("vi", 63);
        txtColumn.put("w", new LocaleString(width));
        txtColumn.put("text-align", "default");
        HashMap<String, Object> txtEditor = new HashMap<String, Object>();
        if ("text".equalsIgnoreCase(type)) {
            txtEditor.put("type", "text");
        } else if ("date".equalsIgnoreCase(type)) {
            txtEditor.put("type", "date");
            txtEditor.put("df", "YYYY-MM-DD");
        } else if ("basedata".equalsIgnoreCase(type)) {
            txtEditor.put("dsp", "number");
            txtEditor.put("type", "basedata");
        } else if ("number".equalsIgnoreCase(type)) {
            txtEditor.put("type", "number");
        } else if ("combo".equalsIgnoreCase(type)) {
            txtEditor.put("type", "combo");
            ArrayList items = new ArrayList();
            ArrayList<String> o1 = new ArrayList<String>();
            o1.add("1");
            o1.add((String)new LocaleString("item1"));
            o1.add(null);
            items.add(o1);
            txtEditor.put("st", items);
        }
        txtColumn.put("editor", txtEditor);
        return txtColumn;
    }
}

