/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.common.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;

public class SupplierHelper {
    public static DynamicObject getSupplierByUserId(String userId) {
        if (userId == null) {
            userId = RequestContext.get().getUserId();
        }
        QFilter filter = new QFilter("user", "=", (Object)userId);
        DynamicObject partner = BusinessDataServiceHelper.loadSingle((String)"bos_bizpartneruser", (String)"bizpartner,org", (QFilter[])new QFilter[]{filter});
        if (partner == null) {
            return null;
        }
        DynamicObject bizPartner = (DynamicObject)partner.get("bizpartner");
        filter = new QFilter("bizpartner", "=", (Object)bizPartner.getPkValue().toString());
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"name", (QFilter[])new QFilter[]{filter});
        return supplier;
    }

    public static DynamicObject[] listUserBySupplierId(Long supplierId) {
        QFilter filter = new QFilter("id", "=", (Object)supplierId);
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"id,bizpartner", (QFilter[])new QFilter[]{filter});
        if (supplier == null) {
            return null;
        }
        DynamicObject bizPartner = (DynamicObject)supplier.get("bizpartner");
        if (bizPartner == null || bizPartner.getPkValue() == null) {
            return new DynamicObject[0];
        }
        filter = new QFilter("bizpartner", "=", (Object)bizPartner.getLong("id"));
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"user,org,isadmin", (QFilter[])new QFilter[]{filter});
        return coll;
    }

    public static DynamicObject[] listUserByResmSupplierId(Long supplierId) {
        QFilter filter = new QFilter("id", "=", (Object)supplierId);
        DynamicObject resmSupplier = BusinessDataServiceHelper.loadSingle((String)"resm_official_supplier", (String)"id,bizpartner", (QFilter[])new QFilter[]{filter});
        if (resmSupplier == null) {
            return null;
        }
        DynamicObject bizPartner = (DynamicObject)resmSupplier.get("bizpartner");
        if (bizPartner == null || bizPartner.getPkValue() == null) {
            return new DynamicObject[0];
        }
        filter = new QFilter("bizpartner", "=", bizPartner.getPkValue());
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"user,org,isadmin", (QFilter[])new QFilter[]{filter});
        return coll;
    }

    public static List<Long> listUserIdBySupplier(Long supplierId) {
        DynamicObject[] coll = SupplierHelper.listUserBySupplierId(supplierId);
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (coll != null) {
            for (int i = 0; i < coll.length; ++i) {
                DynamicObject user = coll[i];
                userIds.add(user.getLong("user.id"));
            }
        }
        return userIds;
    }

    public static Long listAdminUserIdBySupplier(Long supplierId) {
        DynamicObject[] coll = SupplierHelper.listUserBySupplierId(supplierId);
        if (coll != null) {
            for (int i = 0; i < coll.length; ++i) {
                DynamicObject user = coll[i];
                if (!user.getBoolean("isadmin")) continue;
                return user.getLong("user.id");
            }
        }
        return 0L;
    }

    public static Long listAdminUserIdByResmSupplier(Long supplierId) {
        DynamicObject[] coll = SupplierHelper.listUserByResmSupplierId(supplierId);
        if (coll != null) {
            for (int i = 0; i < coll.length; ++i) {
                DynamicObject user = coll[i];
                if (!user.getBoolean("isadmin")) continue;
                return user.getLong("user.id");
            }
        }
        return 0L;
    }

    public static DynamicObject getRESMSupBySysSup(Long supplierId) {
        return BusinessDataServiceHelper.loadSingle((String)"resm_official_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("syssupplier", "=", (Object)supplierId)});
    }

    public static DynamicObject getSysSupByRESMSup(Long supplierId) {
        DynamicObject officialSupplier = BusinessDataServiceHelper.loadSingle((String)"resm_official_supplier", (String)"id,syssupplier", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
        if (officialSupplier != null) {
            return officialSupplier.getDynamicObject("syssupplier");
        }
        return null;
    }

    public static List<Long> getSysSupByResmSupplier(List<Long> supplierIdList) {
        DynamicObject[] officialSupplierArray;
        ArrayList<Long> sysSupplierIdList = new ArrayList<Long>();
        for (DynamicObject officialSupplier : officialSupplierArray = BusinessDataServiceHelper.load((String)"resm_official_supplier", (String)"id,syssupplier", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIdList)})) {
            DynamicObject sysSupplier = officialSupplier.getDynamicObject("syssupplier");
            if (sysSupplier == null) continue;
            sysSupplierIdList.add(sysSupplier.getLong("id"));
        }
        return sysSupplierIdList;
    }

    public static List<Long> listAdminUserIdListBySupplier(List<Long> supplierIdList) {
        ArrayList<Long> adminUserIdList = new ArrayList<Long>();
        QFilter filter = new QFilter("id", "in", supplierIdList);
        DynamicObject[] bdSupplierArray = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,bizpartner", (QFilter[])new QFilter[]{filter});
        if (bdSupplierArray == null || bdSupplierArray.length == 0) {
            return null;
        }
        ArrayList<Long> bizPartnerIdList = new ArrayList<Long>();
        for (DynamicObject bdSupplier : bdSupplierArray) {
            DynamicObject bizPartner = bdSupplier.getDynamicObject("bizpartner");
            if (bizPartner == null || bizPartner.getPkValue() == null) continue;
            bizPartnerIdList.add(bizPartner.getLong("id"));
        }
        if (!CollectionUtils.isEmpty(bizPartnerIdList)) {
            DynamicObject[] bizPartnerUserArray;
            QFilter bizPartnerFilter = new QFilter("bizpartner", "in", bizPartnerIdList);
            QFilter isAdminFilter = new QFilter("isadmin", "=", (Object)"1");
            for (DynamicObject bizPartnerUser : bizPartnerUserArray = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"user,org,isadmin", (QFilter[])new QFilter[]{bizPartnerFilter, isAdminFilter})) {
                DynamicObject user = bizPartnerUser.getDynamicObject("user");
                if (user == null) continue;
                adminUserIdList.add(user.getLong("id"));
            }
        }
        return adminUserIdList;
    }
}

