/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.basedata;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class BidParameter
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.propertyChangedDarkFlag();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisibleDarkName();
    }

    void setVisibleDarkName() {
        boolean darkBidEvaluationFlag;
        int darkBidEvaluation;
        boolean darkOnlineBidEvalFlag;
        int darkOnlineBidEval;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean darkOpenFlag = dataEntity.getBoolean("darkopen");
        int darkOpen = darkOpenFlag ? 1 : 0;
        int selSum = darkOpen + (darkOnlineBidEval = (darkOnlineBidEvalFlag = dataEntity.getBoolean("darkonlinebideval")) ? 1 : 0) + (darkBidEvaluation = (darkBidEvaluationFlag = dataEntity.getBoolean("darkbidevaluation")) ? 1 : 0);
        if (selSum >= 2) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"darknameflag"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"darknameflag"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        String fieldKey = e.getProperty().getName();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        if ("darkopen".equals(fieldKey) || "darkonlinebideval".equals(fieldKey) || "darkbidevaluation".equals(fieldKey)) {
            this.propertyChangedDarkStep();
            this.setVisibleDarkName();
        } else if ("darkflag".equals(fieldKey)) {
            this.propertyChangedDarkFlag();
        } else if ("darkdiynumber".equals(fieldKey) || "darkdiyalphabet".equals(fieldKey) || "darkmarktype".equals(fieldKey)) {
            this.propertyChangedDarkDiyName();
        }
    }

    void propertyChangedDarkStep() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean darkOpenFlag = dataEntity.getBoolean("darkopen");
        boolean darkOnlineBidEvalFlag = dataEntity.getBoolean("darkonlinebideval");
        boolean darkBidEvaluationFlag = dataEntity.getBoolean("darkbidevaluation");
        if (darkOpenFlag || darkOnlineBidEvalFlag || darkBidEvaluationFlag) {
            dataEntity.set("darksteplabletext", (Object)"not null");
        } else {
            dataEntity.set("darksteplabletext", (Object)"");
        }
        this.getView().updateView("darksteplabletext");
    }

    void propertyChangedDarkFlag() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean darkFlag = dataEntity.getBoolean("darkflag");
        if (!darkFlag) {
            dataEntity.set("darksteplabletext", (Object)"darkflag is false");
            this.getView().updateView("darksteplabletext");
            dataEntity.set("darkdiyname", (Object)"darkflag is false");
            this.getView().updateView("darkdiyname");
        } else {
            dataEntity.set("darksteplabletext", (Object)"");
            this.getView().updateView("darksteplabletext");
            this.propertyChangedDarkStep();
            dataEntity.set("darkdiyname", (Object)"");
            this.getView().updateView("darkdiyname");
            this.propertyChangedDarkDiyName();
        }
    }

    void propertyChangedDarkDiyName() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String darkDiyAlphabet = dataEntity.getString("darkdiyalphabet");
        String darkDiyNumber = dataEntity.getString("darkdiynumber");
        if (StringUtils.isBlank((String)darkDiyAlphabet) || StringUtils.isBlank((String)darkDiyNumber)) {
            dataEntity.set("darkdiyname", (Object)"");
        } else {
            dataEntity.set("darkdiyname", (Object)"not null");
        }
        this.getView().updateView("darkdiyname");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String darkDiyAlphabet = dataEntity.getString("darkdiyalphabet");
        String darkDiyNumber = dataEntity.getString("darkdiynumber");
        String supplierDesciption = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"BidParameter_1", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        if (StringUtils.isBlank((String)darkDiyAlphabet) || supplierDesciption.equals(darkDiyAlphabet)) {
            this.getModel().setValue("darkdiyalphabet", (Object)supplierDesciption);
        }
        if (StringUtils.isBlank((String)darkDiyNumber) || supplierDesciption.equals(darkDiyNumber)) {
            this.getModel().setValue("darkdiynumber", (Object)supplierDesciption);
        }
    }
}

