/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.bill.BidTemplateConstant;
import kd.scm.bid.common.constant.bill.OptionalColumnConstant;
import kd.scm.bid.common.constant.entity.BidTemplateMangeEntity;
import kd.scm.bid.common.constant.entity.BidTemplateTypeEntity;
import kd.scm.bid.common.constant.entity.DefaultOrgReg;
import kd.scm.bid.common.enums.BidProjectEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.DefaultOrgUtil;
import kd.scm.bid.common.util.ReWfUtil;
import kd.scm.bid.formplugin.bill.helper.TemplateManageHelper;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;

public class BidTemplateMangeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BAR_SAVEANDNEW = "bar_saveandnew";
    private static final String BAR_SAVE = "bar_save";
    private static final String BAR_SUBMIT = "bar_submit";
    private static final String SUBMIT_AUDIT = "submitaudit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        OperationStatus operationStatus;
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.copyData();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String type = (String)parameter.getCustomParam("type");
        IDataModel model = this.getModel();
        String enable = model.getValue("enable").toString();
        if (model.getValue(BidTemplateMangeEntity.TYPE) == null) {
            DynamicObject templateType;
            if (StringUtils.isEmpty((CharSequence)type) && (templateType = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"templatetype", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[0])) != null && templateType.get("id") != null) {
                type = templateType.getString("id");
            }
            model.setValue(BidTemplateMangeEntity.TYPE, (Object)type);
        }
        if (!OperationStatus.ADDNEW.equals((Object)(operationStatus = parameter.getStatus()))) {
            String text = model.getValue(BidTemplateMangeEntity.CONTENT).toString();
            RichTextEditor editor = (RichTextEditor)this.getView().getControl(BidTemplateMangeEntity.RICHEDITOR);
            editor.setText(text);
            if ("1".equals(enable)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVEANDNEW});
            }
        }
        if (model.getValue(BidTemplateMangeEntity.TYPE) != null) {
            this.changeOptionalColumn((DynamicObject)model.getValue(BidTemplateMangeEntity.TYPE));
        }
        this.setButtonVisible(dataEntity);
    }

    protected void setButtonVisible(DynamicObject dataEntity) {
        String status = dataEntity.getString("status");
        if (BillStatusEnum.SUBMIT.getVal().equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE, SUBMIT_AUDIT});
            this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_AUDIT});
        }
        if (BillStatusEnum.AUDITED.getVal().equals(status) || BillStatusEnum.AUDITING.getVal().equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE, BAR_SUBMIT});
        }
        if (BillStatusEnum.AUDITING.getVal().equals(status)) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterBindData(EventObject e) {
        String isEnable;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        Long id = (Long)model.getValue("id");
        if (id != null && id != 0L && StringUtils.equals((CharSequence)(isEnable = (String)model.getValue("enable")), (CharSequence)"1")) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVEANDNEW});
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        DynamicObject org = model.getDataEntity(true).getDynamicObject("org");
        if (org == null) {
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            String formId = FormTypeConstants.getFormConstant((String)"templatemanage", ((Object)((Object)this)).getClass());
            DefaultOrgReg defaultOrgReg = new DefaultOrgReg(appId, "02", formId);
            Long orgId = DefaultOrgUtil.getEditUIDefaultOrg((DefaultOrgReg)defaultOrgReg);
            model.setValue("org", (Object)orgId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String enable;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        String tipMsg = this.checkPermisstion(operateKey);
        if (!StringUtils.isBlank((CharSequence)tipMsg)) {
            this.getView().showConfirm(tipMsg, MessageBoxOptions.OK);
            args.setCancel(true);
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus operationStatus = parameter.getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)operationStatus) && !"close".equals(operateKey) && (enable = model.getValue("enable").toString()).equals("1")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"BidTemplateMangeEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") || "submit".equals(operateKey) || SUBMIT_AUDIT.equals(operateKey)) {
            DynamicObject type = (DynamicObject)model.getValue(BidTemplateMangeEntity.TYPE);
            if (type == null) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u7c7b\u578b\u3002", (String)"BidTemplateMangeEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            model.setValue(BidTemplateMangeEntity.CONTENT, (Object)((RichTextEditor)this.getView().getControl("richtexteditorap")).getText());
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)SUBMIT_AUDIT)) {
            String formId = FormTypeConstants.getFormConstant((String)"templatemanage", ((Object)((Object)this)).getClass());
            boolean flag = ReWfUtil.hasEableProcess((String)formId);
            if (flag) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u7ecf\u542f\u52a8\u5ba1\u6279\u6d41\uff0c\u65e0\u6cd5\u64cd\u4f5c\u63d0\u4ea4\u5e76\u5ba1\u6838\u3002", (String)"BidTemplateMangeEdit_17", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                args.setCancel(true);
                return;
            }
            String status = (String)model.getValue("status");
            String enable2 = (String)model.getValue("enable");
            if (BillStatusEnum.AUDITED.getVal().equals(status) && "1".equals(enable2)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u70b9\u51fb\u63d0\u4ea4\u5e76\u5ba1\u6838\u3002", (String)"BidTemplateMangeEdit_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public String checkPermisstion(String opkey) {
        boolean haspermission;
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        Long orgId = (Long)this.getModel().getDataEntity().getDynamicObject("org").getPkValue();
        String entityName = FormTypeConstants.getFormConstant((String)"templatemanage", ((Object)((Object)this)).getClass());
        if ("save".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0196", orgId, appId, entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u4fdd\u5b58\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidTemplateMangeEdit_18", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("submit".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0009", orgId, appId, entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u63d0\u4ea4\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidTemplateMangeEdit_19", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("unsubmit".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0010", orgId, appId, entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u64a4\u9500\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidTemplateMangeEdit_20", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("delete".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0004", orgId, appId, entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5220\u9664\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidTemplateMangeEdit_21", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("audit".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0006", orgId, appId, entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5ba1\u6838\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidTemplateMangeEdit_22", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("unaudit".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0007", orgId, appId, entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u53cd\u5ba1\u6838\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidTemplateMangeEdit_23", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if (SUBMIT_AUDIT.equals(opkey) && !(haspermission = PermissionUtils.checkPermission("SubmitAudit", orgId, appId, entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u63d0\u4ea4\u5e76\u5ba1\u6838\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidTemplateMangeEdit_24", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus operationStatus = parameter.getStatus();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        this.holdRichContent();
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVEANDNEW});
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SAVE, BAR_SUBMIT});
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"audit")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
            this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_AUDIT, BidTemplateMangeEntity.RICHEDITOR});
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SAVE, BAR_SUBMIT});
            this.getView().setEnable(Boolean.TRUE, new String[]{BidTemplateMangeEntity.RICHEDITOR});
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)SUBMIT_AUDIT)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE, BAR_SUBMIT});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{BidTemplateMangeEntity.RICHEDITOR});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u5ba1\u6838\u6210\u529f\u3002", (String)"BidTemplateMangeEdit_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    public void holdRichContent() {
        RichTextEditor editor = (RichTextEditor)this.getView().getControl(BidTemplateMangeEntity.RICHEDITOR);
        String text = (String)this.getModel().getValue(BidTemplateMangeEntity.CONTENT);
        editor.setText(text);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)BidTemplateMangeEntity.TYPE)) {
            ChangeData[] changeData = e.getChangeSet();
            DynamicObject templateType = changeData[0].getDataEntity().getDynamicObject(BidTemplateMangeEntity.TYPE);
            if (templateType == null) {
                return;
            }
            this.changeOptionalColumn(templateType);
            this.setHead(templateType.getString("modeltype"));
            this.getModel().setValue(BidTemplateMangeEntity.CONTENT, (Object)((RichTextEditor)this.getView().getControl("richtexteditorap")).getText());
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)BidTemplateMangeEntity.OPTIONALCOLUMN)) {
            this.insertTagInEditor();
        }
    }

    public void changeOptionalColumn(DynamicObject templateType) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(BidTemplateMangeEntity.OPTIONALCOLUMN);
        ArrayList<ComboItem> modelItems = new ArrayList<ComboItem>();
        String modelType = templateType.getString(BidTemplateTypeEntity.MODELTYPE);
        OptionalColumnConstant aColumnConstant = new OptionalColumnConstant(modelType);
        List columns = aColumnConstant.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Map map = (Map)columns.get(i);
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getValue()).equals(BidProjectEnum.DESIGNDATE.getValue())) continue;
                modelItems.add(new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getValue()));
            }
        }
        comboEdit.setComboItems(modelItems);
    }

    public void insertTagInEditor() {
        IDataModel model = this.getModel();
        String label = model.getValue(BidTemplateMangeEntity.OPTIONALCOLUMN).toString();
        if (label.equals("")) {
            return;
        }
        String value = "";
        DynamicObject modelType = (DynamicObject)model.getValue(BidTemplateMangeEntity.TYPE);
        OptionalColumnConstant aColumnConstant = new OptionalColumnConstant(modelType.getString(BidTemplateTypeEntity.MODELTYPE));
        List columns = aColumnConstant.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Map map = (Map)columns.get(i);
            for (Map.Entry entry : map.entrySet()) {
                if (!((String)entry.getValue()).equals(label)) continue;
                value = (String)entry.getValue();
            }
        }
        RichTextEditor editor = (RichTextEditor)this.getView().getControl(BidTemplateMangeEntity.RICHEDITOR);
        String pString = TemplateManageHelper.getProjectTag(label, TemplateManageHelper.getSpecialValue(value));
        String text = editor.getText() == null ? pString : editor.getText() + pString;
        editor.setText(text);
    }

    public void setHead(String type) {
        StringBuilder result = new StringBuilder();
        RichTextEditor editor = (RichTextEditor)this.getView().getControl(BidTemplateMangeEntity.RICHEDITOR);
        BidTemplateConstant bidTemplateConstant = new BidTemplateConstant();
        String projectName = TemplateManageHelper.getSpecialValue(bidTemplateConstant.getProjectName());
        if ("bidproject".equals(type)) {
            String[] bidProjectLabels = bidTemplateConstant.getBidProjectLabels();
            String[] bidprojectValues = bidTemplateConstant.getBidProjectValues();
            for (int i = 0; i < bidProjectLabels.length; ++i) {
                String specialValue = TemplateManageHelper.getSpecialValue(bidprojectValues[i]);
                result.append(TemplateManageHelper.getProjectTag(bidProjectLabels[i], specialValue));
            }
        } else if (BidTemplateConstant.QUERY.equals(type)) {
            result.append(TemplateManageHelper.buildInsertInvitationHead(bidTemplateConstant.getQuerySupplierName(), String.format(ResManager.loadKDString((String)"\u6211\u53f8\u62df\u5bf9%s\u8fdb\u884c\u62db\u6807\u53d1\u8d77\u8d28\u7591\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u6f84\u6e05\u4fe1\u606f\u3002", (String)"BidTemplateMangeEdit_10", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName)));
            String[] bidQueryLabels = bidTemplateConstant.getBidQueryLabels();
            String[] bidQueryValues = bidTemplateConstant.getQueryValues();
            for (int i = 0; i < bidQueryLabels.length; ++i) {
                result.append(TemplateManageHelper.getProjectTag(bidQueryLabels[i], TemplateManageHelper.getSpecialValue(bidQueryValues[i])));
            }
            result.append("</p>");
        } else if ("negotiate".equals(type)) {
            result.append(TemplateManageHelper.buildInsertInvitationHead(bidTemplateConstant.getNegotiateSupplierName(), String.format(ResManager.loadKDString((String)"\u6211\u53f8\u62df\u5bf9%s\u8fdb\u884c\u62db\u6807\u53d1\u8d77\u5546\u52a1\u8c08\u5224\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u8c08\u5224\u4fe1\u606f\u3002", (String)"BidTemplateMangeEdit_16", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName)));
            String[] bidNegotiateLabels = bidTemplateConstant.getBidNegotiateLabels();
            String[] bidNegotiateValues = bidTemplateConstant.getBidNegotiateValues();
            for (int i = 0; i < bidNegotiateLabels.length; ++i) {
                result.append(TemplateManageHelper.getProjectTag(bidNegotiateLabels[i], TemplateManageHelper.getSpecialValue(bidNegotiateValues[i])));
            }
            result.append("</p>");
        } else if ("invitation".equals(type)) {
            result.append(TemplateManageHelper.buildInsertInvitationHead(bidTemplateConstant.getInviationSupplierName(), String.format(ResManager.loadKDString((String)"\u6211\u53f8\u62df\u5bf9%s\u8fdb\u884c\u62db\u6807\uff0c\u8bda\u9080\u5404\u5355\u4f4d\u8fdb\u884c\u6295\u6807\uff0c\u62db\u6807\u4fe1\u606f\u8be6\u60c5\u5982\u4e0b:", (String)"BidTemplateMangeEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName)));
            String[] bidInvitationLabels = bidTemplateConstant.getBidInvitationLabels();
            String[] bidinvitationValues = bidTemplateConstant.getInvitationValues();
            for (int i = 0; i < bidInvitationLabels.length; ++i) {
                result.append(TemplateManageHelper.getProjectTag(bidInvitationLabels[i], TemplateManageHelper.getSpecialValue(bidinvitationValues[i])));
            }
            result.append("</p>");
        } else if ("decision".equals(type)) {
            String[] bidWinningLabels = bidTemplateConstant.getBidWinningLabels();
            String[] bidWinningValues = bidTemplateConstant.getBidWinningValues();
            for (int i = 0; i < bidWinningLabels.length; ++i) {
                result.append(TemplateManageHelper.getProjectTag(bidWinningLabels[i], TemplateManageHelper.getSpecialValue(bidWinningValues[i])));
            }
        } else if ("bidnotification".equals(type)) {
            result.append(TemplateManageHelper.buildInsertHead(bidTemplateConstant.getSupplierName(), String.format(ResManager.loadKDString((String)"\u606d\u559c\uff01\u4f60\u53c2\u4e0e\u7684%s\u5df2\u7ecf\u4e2d\u6807\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u9644\u4ef6\uff0c\u671f\u5f85\u4e0e\u60a8\u7684\u5408\u4f5c\u3002", (String)"BidTemplateMangeEdit_12", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName)));
        } else if ("thanksletter".equals(type)) {
            result.append(TemplateManageHelper.buildInsertHead(bidTemplateConstant.getSupplierName(), String.format(ResManager.loadKDString((String)"\u5f88\u9057\u61be\uff01\u60a8\u53c2\u4e0e\u7684%s\u91c7\u8d2d\u62db\u6807\u5e76\u672a\u4e2d\u6807\uff0c\u611f\u8c22\u60a8\u5bf9\u6211\u4eec\u516c\u53f8\u7684\u5927\u529b\u652f\u6301\uff0c\u8bf7\u7ee7\u7eed\u5173\u6ce8\u6211\u4eec\u7684\u5176\u4ed6\u62db\u6807\u5185\u5bb9\u3002", (String)"BidTemplateMangeEdit_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName)));
        } else if ("bidassinvite".equals(type)) {
            String[] bidAssInviteLabels = bidTemplateConstant.getBidAssInviteLabels();
            String[] bidAssInviteValues = bidTemplateConstant.getBidAssInviteValues();
            for (int i = 0; i < bidAssInviteLabels.length; ++i) {
                result.append(TemplateManageHelper.getProjectTag(bidAssInviteLabels[i], TemplateManageHelper.getSpecialValue(bidAssInviteValues[i])));
            }
        }
        editor.setText(result.toString());
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey = arg.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)BidTemplateMangeEntity.ORG)) {
            List<Long> pos = this.getHasPermOrgs();
            if (pos == null) {
                return;
            }
            QFilter qFilter = new QFilter("id", "in", pos);
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        }
    }

    public List<Long> getHasPermOrgs() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List hasPermOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)this.getView().getEntityId(), (String)"47156aff000000ac");
        return hasPermOrgs;
    }

    public void copyData() {
        IDataModel model = this.getModel();
        Object sid = this.getView().getFormShowParameter().getCustomParam("sourceTemplateId");
        if (sid != null) {
            DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sid.toString()), (String)FormTypeConstants.getFormConstant((String)"templatemanage", ((Object)((Object)this)).getClass()));
            model.setValue(BidTemplateMangeEntity.NAME, (Object)template.getString(BidTemplateMangeEntity.NAME));
            model.setValue(BidTemplateMangeEntity.CONTENT, (Object)template.getString(BidTemplateMangeEntity.CONTENT));
            model.setValue(BidTemplateMangeEntity.TYPE, template.getDynamicObject(BidTemplateMangeEntity.TYPE).getPkValue());
            model.setValue(BidTemplateMangeEntity.ORG, template.getDynamicObject(BidTemplateMangeEntity.ORG).getPkValue());
            RichTextEditor editor = (RichTextEditor)this.getView().getControl(BidTemplateMangeEntity.RICHEDITOR);
            editor.setText(template.getString(BidTemplateMangeEntity.CONTENT));
            this.changeOptionalColumn(template.getDynamicObject(BidTemplateMangeEntity.TYPE));
        }
    }
}

