/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.bid.business.bill.IBidAnnocumentService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidAnnocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.enums.BidProjectDateEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.DateUtils;

public abstract class AdsBidProjectJustEdit
extends AbstractFormPlugin {
    private IBidAnnocumentService annocumentService = new BidAnnocumentServiceImpl();
    private ISupplierInvitationService supplierInvitationService = new SupplierInvitationServiceImpl();
    public static final Set<String> PLAN_DATE_FLAG = new HashSet<String>(16);
    public static final Set<String> DATE_END_FLAG = new HashSet<String>(16);

    public void compareDate(String dateType, Date date, Date oldDate, boolean flag, boolean isPublicBid) {
        String removeFlag;
        Date compareDate;
        if (date == null) {
            return;
        }
        Map<String, Boolean> status = this.hasLinkStatus(isPublicBid);
        BidProjectDateEnum curDate = BidProjectDateEnum.valueOf((String)dateType);
        int index = curDate.getIndex();
        Object pkvalue = this.getModel().getDataEntity().getPkValue();
        String billStatus = this.annocumentService.getBillStatus(pkvalue, (Object)"bidproject");
        DynamicObject invitation = this.supplierInvitationService.getInvitationByProjectId(Long.valueOf(pkvalue.toString()));
        if (DATE_END_FLAG.contains(dateType)) {
            date = DateUtils.endOfDay((Date)date);
        }
        List dates4Later = Arrays.stream(BidProjectDateEnum.values()).filter(dateEnum -> dateEnum.getIndex() < index).collect(Collectors.toList());
        Collections.sort(dates4Later, (d1, d2) -> d2.getIndex() - d1.getIndex());
        String entitytypeid = this.getView().getModel().getDataEntity(true).getString("entitytypeid");
        String appId = "rebm";
        if (entitytypeid.startsWith("bid")) {
            appId = "bid";
        }
        List<String> times = this.getTimes();
        for (BidProjectDateEnum date4Project : dates4Later) {
            Boolean isUsed = status.get(date4Project.name());
            if (isUsed != null && !isUsed.booleanValue() || BidProjectDateEnum.designdrawingenddate.name().equals(date4Project.name()) && "bid".equals(appId)) continue;
            String dateName = date4Project.name();
            compareDate = (Date)this.getModel().getValue(dateName);
            if (flag) {
                removeFlag = date4Project.name();
                if (("enrolldeadline".equals(dateType) || "invitationdeadline".equals(dateType) || "designdrawingenddate".equals(dateType)) && ("technicaldocenddate".equals(removeFlag) || "commercialdocenddate".equals(removeFlag)) || ("technicaldocenddate".equals(dateType) || "commercialdocenddate".equals(dateType)) && ("enrolldeadline".equals(removeFlag) || "invitationdeadline".equals(removeFlag) || "designdrawingenddate".equals(removeFlag))) continue;
            }
            if (compareDate == null) continue;
            if (times.contains(dateType) && !times.contains(dateName)) {
                compareDate = DateUtils.endOfDay((Date)compareDate);
            }
            if (DateUtils.compareDate((Date)date, (Date)compareDate) >= 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u987b\u665a\u4e8e\u7b49\u4e8e%2$s", (String)"AdsBidProjectJustEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), curDate.getAlias(), date4Project.getAlias() + "\uff01"));
            if (curDate == BidProjectDateEnum.enrolldeadline) {
                if (billStatus != null) {
                    if (date != null && oldDate != null) {
                        this.getModel().setValue(curDate.name(), (Object)oldDate);
                    }
                } else {
                    this.getModel().setValue(curDate.name(), null);
                }
            } else if (curDate == BidProjectDateEnum.invitationdeadline) {
                if (invitation != null && BillStatusEnum.SUBMIT.getVal().equals(invitation.getString("status"))) {
                    if (date != null && oldDate != null) {
                        this.getModel().setValue(curDate.name(), (Object)oldDate);
                    }
                } else {
                    this.getModel().setValue(curDate.name(), null);
                }
            } else {
                this.getModel().setValue(curDate.name(), null);
            }
            return;
        }
        List dates4Early = Arrays.stream(BidProjectDateEnum.values()).filter(dateEnum -> dateEnum.getIndex() > index).collect(Collectors.toList());
        Collections.sort(dates4Early, (d1, d2) -> d1.getIndex() - d2.getIndex());
        for (BidProjectDateEnum date4Project : dates4Early) {
            Boolean isUsed = status.get(date4Project.name());
            if (isUsed != null && !isUsed.booleanValue()) continue;
            compareDate = (Date)this.getModel().getValue(date4Project.name());
            if (flag) {
                removeFlag = date4Project.name();
                if (("enrolldeadline".equals(dateType) || "invitationdeadline".equals(dateType)) && ("technicaldocenddate".equals(removeFlag) || "commercialdocenddate".equals(removeFlag)) || ("technicaldocenddate".equals(dateType) || "commercialdocenddate".equals(dateType)) && ("enrolldeadline".equals(removeFlag) || "invitationdeadline".equals(removeFlag))) continue;
            }
            if (compareDate == null || DateUtils.compareDate((Date)date, (Date)compareDate) <= 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)" %1$s\u987b\u65e9\u4e8e\u7b49\u4e8e%2$s", (String)"AdsBidProjectJustEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), curDate.getAlias(), date4Project.getAlias() + "\uff01"));
            if (curDate == BidProjectDateEnum.enrolldeadline) {
                if (billStatus != null) {
                    if (date != null && oldDate != null) {
                        this.getModel().setValue(curDate.name(), (Object)oldDate);
                    }
                } else {
                    this.getModel().setValue(curDate.name(), null);
                }
            } else if (curDate == BidProjectDateEnum.invitationdeadline) {
                if (invitation != null && BillStatusEnum.SUBMIT.getVal().equals(invitation.getString("status"))) {
                    if (date != null && oldDate != null) {
                        this.getModel().setValue(curDate.name(), (Object)oldDate);
                    }
                } else {
                    this.getModel().setValue(curDate.name(), null);
                }
            } else {
                this.getModel().setValue(curDate.name(), null);
            }
            return;
        }
    }

    public Map<String, Boolean> hasLinkStatus(boolean isPublicBid) {
        boolean isSupplierInvitation = (Boolean)this.getModel().getValue("supplierinvitation");
        boolean isBidDocument = (Boolean)this.getModel().getValue("biddocument");
        boolean isBidPublish = (Boolean)this.getModel().getValue("bidpublish");
        boolean isBidOpen = (Boolean)this.getModel().getValue("bidopen");
        boolean isBidEvaluation = (Boolean)this.getModel().getValue("bidevaluation");
        boolean isBidBustalk = (Boolean)this.getModel().getValue("bidbustalk");
        boolean isBidDecision = (Boolean)this.getModel().getValue("biddecision");
        boolean isBidAnswerQuestion = (Boolean)this.getModel().getValue("bidanswerquestion");
        boolean isClarificaiton = (Boolean)this.getModel().getValue("clarificaiton");
        boolean isBidBottomMake = (Boolean)this.getModel().getValue("bidbottommake");
        boolean visitbidopendeadline = (Boolean)this.getModel().getValue("visitbidopendeadline");
        boolean visittechbackbidtime = (Boolean)this.getModel().getValue("visittechbackbidtime");
        boolean visitbusbackbidtime = (Boolean)this.getModel().getValue("visitbusbackbidtime");
        boolean visitbidopentime = (Boolean)this.getModel().getValue("visitbidopentime");
        boolean visittechopenbidtime = (Boolean)this.getModel().getValue("visittechopenbidtime");
        boolean visitbusopenbidtime = (Boolean)this.getModel().getValue("visitbusopenbidtime");
        HashMap<String, Boolean> status = new HashMap<String, Boolean>(16);
        status.put("enrolldeadline", isPublicBid);
        status.put("supplierinvienddate", isSupplierInvitation);
        status.put("invitationdeadline", !isPublicBid);
        status.put("technicaldocenddate", isBidDocument);
        status.put("commercialdocenddate", isBidDocument);
        status.put("bidpublishdate", isBidPublish);
        status.put("bidopendeadline", isBidOpen);
        status.put("bidevaluationdate", isBidEvaluation);
        status.put("bidbustalkdate", isBidBustalk);
        status.put("biddecisiondate", isBidDecision);
        status.put("answerquestiontime", isBidAnswerQuestion);
        status.put("answercomplete", isBidAnswerQuestion);
        status.put("bidbottommakedate", isBidBottomMake);
        status.put("clarificaitondate", isClarificaiton);
        status.put("techbackbidtime", visittechbackbidtime);
        status.put("busbackbidtime", visitbusbackbidtime);
        status.put("bidopentime", visitbidopentime);
        status.put("techopenbidtime", visittechopenbidtime);
        status.put("busopenbidtime", visitbusopenbidtime);
        return status;
    }

    public int compareDate(Date d1, Date d2) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatTail = new SimpleDateFormat("HH:mm:ss");
        String ds1 = format.format(d1);
        String ds2 = format.format(d2);
        String dst1 = formatTail.format(d1);
        String dst2 = formatTail.format(d2);
        if ((StringUtils.equals((CharSequence)"00:00:00", (CharSequence)dst1) || StringUtils.equals((CharSequence)"00:00:00", (CharSequence)dst2)) && ds1.equals(ds2)) {
            return 0;
        }
        return d1.compareTo(d2);
    }

    public List<String> getTimes() {
        ArrayList<String> times = new ArrayList<String>(20);
        times.add("enrolldeadline");
        times.add("invitationdeadline");
        times.add("answerquestiontime");
        times.add("bidopendeadline");
        times.add("techbackbidtime");
        times.add("busbackbidtime");
        times.add("bidopentime");
        times.add("techopenbidtime");
        times.add("busopenbidtime");
        return times;
    }

    static {
        PLAN_DATE_FLAG.add("enrolldeadline");
        PLAN_DATE_FLAG.add("invitationdeadline");
        PLAN_DATE_FLAG.add("supplierinvienddate");
        PLAN_DATE_FLAG.add("designdrawingenddate");
        PLAN_DATE_FLAG.add("technicaldocenddate");
        PLAN_DATE_FLAG.add("commercialdocenddate");
        PLAN_DATE_FLAG.add("bidpublishdate");
        PLAN_DATE_FLAG.add("answerquestiontime");
        PLAN_DATE_FLAG.add("answercomplete");
        PLAN_DATE_FLAG.add("clarificaitondate");
        PLAN_DATE_FLAG.add("bidbottommakedate");
        PLAN_DATE_FLAG.add("bidopendeadline");
        PLAN_DATE_FLAG.add("techbackbidtime");
        PLAN_DATE_FLAG.add("busbackbidtime");
        PLAN_DATE_FLAG.add("bidopentime");
        PLAN_DATE_FLAG.add("techopenbidtime");
        PLAN_DATE_FLAG.add("busopenbidtime");
        PLAN_DATE_FLAG.add("bidevaluationdate");
        PLAN_DATE_FLAG.add("bidbustalkdate");
        PLAN_DATE_FLAG.add("biddecisiondate");
        PLAN_DATE_FLAG.add("approachdate");
        DATE_END_FLAG.add("supplierinvienddate");
        DATE_END_FLAG.add("designdrawingenddate");
        DATE_END_FLAG.add("technicaldocenddate");
        DATE_END_FLAG.add("commercialdocenddate");
        DATE_END_FLAG.add("bidpublishdate");
        DATE_END_FLAG.add("answercomplete");
        DATE_END_FLAG.add("clarificaitondate");
        DATE_END_FLAG.add("bidbottommakedate");
        DATE_END_FLAG.add("bidevaluationdate");
        DATE_END_FLAG.add("bidbustalkdate");
        DATE_END_FLAG.add("biddecisiondate");
        DATE_END_FLAG.add("approachdate");
    }
}

