/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.util.IPMonitorUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BidCenterOpenIPList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(BidCenterOpenIPList.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long currUserId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        boolean isBidAdmin = IPMonitorUtil.checkIsBidIPAdmin((String)appId, (Object)currUserId);
        if (!isBidAdmin) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ipmonit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"ipdataexp"});
            BillList billList = (BillList)this.getControl("billlistap");
            List columns = billList.getShowListColumns();
            for (IListColumn column : columns) {
                if (!column.toString().equals("ipstatus") && !column.toString().equals("ipscope")) continue;
                column.setVisible(10);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        String entityName = "bid_ipdetail";
        if (!"bid".equals(appId)) {
            entityName = "rebm_ipdetail";
        }
        String projectName = "bid_project";
        if (!"bid".equals(appId)) {
            projectName = "rebm_project";
        }
        if ("ipmonit".equals(operateKey)) {
            Object bidProjectId = null;
            if (selectedRows.size() > 0) {
                bidProjectId = selectedRows.get(0).getPrimaryKeyValue();
                BillShowParameter formShowParameter = new BillShowParameter();
                formShowParameter.setFormId(entityName);
                formShowParameter.setCustomParam("bidproject", bidProjectId);
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setStatus(OperationStatus.EDIT);
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        } else if ("ipdataexp".equals(operateKey)) {
            String orgID = this.getPageCache().get("org");
            QFilter qFilter = new QFilter("ipstatus", "=", (Object)"unusual");
            QFilter qFilte2 = new QFilter("entitytypeid", "=", (Object)projectName);
            DynamicObject[] projects = BusinessDataServiceHelper.load((String)projectName, (String)"id,name,billno,ipstatus,ipscope,org,purprojectset,purtype,setupdate,bidmode", (QFilter[])new QFilter[]{new QFilter("org ", "=", (Object)Long.parseLong(orgID)), qFilter, qFilte2});
            String url = BidCenterOpenIPList.exportEntry(projects, appId);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                this.getView().download(url);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\uff01", (String)"BidCenterOpenIPList_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25,url\u751f\u6210\u5931\u8d25\u3002", (String)"BidCenterOpenIPList_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static String exportEntry(DynamicObject[] bidPeoject, String appid) {
        String fileName = String.format(ResManager.loadKDString((String)"IP\u76d1\u63a7\u6570\u636e%s.xlsx", (String)"BidCenterOpenIPList_3", (String)"scm-bid-formplugin", (Object[])new Object[0]), System.currentTimeMillis());
        SXSSFWorkbook wb = new SXSSFWorkbook(5000);
        BidCenterOpenIPList.createRow(wb, bidPeoject, appid);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e1) {
            logger.error((Throwable)e1);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e2) {
                logger.error((Throwable)e2);
            }
        }
        return url;
    }

    protected static void createRow(SXSSFWorkbook wb, DynamicObject[] bidProject, String appid) {
        BidCenterOpenIPList.contentData(wb, bidProject, appid);
    }

    static void contentData(SXSSFWorkbook wb, DynamicObject[] bidProjects, String appid) {
        Cell cell;
        SXSSFSheet sheet = wb.createSheet("sheet");
        sheet.trackAllColumnsForAutoSizing();
        int index = 0;
        CellStyle secondeStyle = wb.createCellStyle();
        secondeStyle.setFillForegroundColor(IndexedColors.TAN.getIndex());
        secondeStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        SXSSFRow row = sheet.createRow(index);
        String[] HeadArray = ResManager.loadKDString((String)"\u62db\u6807\u540d\u79f0,\u62db\u6807\u7f16\u53f7,IP\u76d1\u63a7\u72b6\u6001,IP\u76d1\u63a7\u8303\u56f4,\u91c7\u8d2d\u7ec4\u7ec7,\u91c7\u8d2d\u9879\u76ee,\u91c7\u8d2d\u7c7b\u578b,\u7acb\u9879\u65e5\u671f,\u91c7\u8d2d\u65b9\u5f0f,\u4f9b\u5e94\u5546\u540d\u79f0,\u4e1a\u52a1\u73af\u8282,IP\u5730\u5740,\u64cd\u4f5c\u65f6\u95f4,IP\u662f\u5426\u91cd\u590d,\u5bf9\u6bd4\u8303\u56f4,\u4f9b\u5e94\u5546\u540d\u79f0,\u62db\u6807\u540d\u79f0,\u4e1a\u52a1\u73af\u8282,IP\u5730\u5740,\u64cd\u4f5c\u65f6\u95f4", (String)"BidCenterOpenIPList_4", (String)"scm-bid-formplugin", (Object[])new Object[0]).split(",");
        for (int i = 0; i < HeadArray.length; ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, Math.min(65280, sheet.getColumnWidth(i) * 18 / 10));
            CellStyle mustFillColumnStyle = wb.createCellStyle();
            mustFillColumnStyle.setAlignment(HorizontalAlignment.CENTER);
            mustFillColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            mustFillColumnStyle.setFillForegroundColor(IndexedColors.TAN.getIndex());
            mustFillColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            Font mheadFont = wb.createFont();
            mheadFont.setColor(IndexedColors.BLACK1.getIndex());
            mustFillColumnStyle.setFont(mheadFont);
            cell = row.createCell(i);
            cell.setCellStyle(mustFillColumnStyle);
            cell.setCellValue(HeadArray[i]);
        }
        String name = "bid_uniprecord";
        if (!"bid".equals(appid)) {
            name = "rebm_uniprecord";
        }
        for (DynamicObject mybidProject : bidProjects) {
            DynamicObject[] load;
            boolean isProject = true;
            long id = mybidProject.getLong("id");
            String namepeoject = mybidProject.getString("name");
            String numberpeoject = mybidProject.getString("billno");
            String ipstatuspeoject = mybidProject.getString("ipstatus").equals("normal") ? ResManager.loadKDString((String)"\u6b63\u5e38", (String)"BidCenterOpenIPList_5", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f02\u5e38", (String)"BidCenterOpenIPList_6", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            String ipscopepeoject = mybidProject.getString("ipscope").equals("thisbidding") ? ResManager.loadKDString((String)"\u672c\u6b21\u62db\u6807", (String)"BidCenterOpenIPList_7", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5386\u53f2\u62db\u6807", (String)"BidCenterOpenIPList_8", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            String orgname = mybidProject.getDynamicObject("org").getString("name");
            String purprojectset = mybidProject.getString("purprojectset");
            String purtypename = mybidProject.getDynamicObject("purtype").getString("name");
            String setupdate = new SimpleDateFormat("yyyy-MM-dd").format(mybidProject.getDate("setupdate"));
            String bidmodename = mybidProject.getDynamicObject("bidmode").getString("name");
            for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)name, (String)"supplier,entryentity.unsupplier,entryentity.contrastrange", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)id)})) {
                boolean issupplier = true;
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                DynamicObject recordIP = dynamicObject.getDynamicObject("supplier");
                DynamicObject supplierDynamicObject = recordIP.getDynamicObject("supplier");
                String suppierName = "";
                if (supplierDynamicObject != null) {
                    suppierName = supplierDynamicObject.getString("name");
                }
                String stage = BidCenterOpenIPList.StageName(recordIP.getString("stage"));
                String ip = recordIP.getString("ip");
                String operationtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(recordIP.getDate("operationtime"));
                for (DynamicObject entey : entryentity) {
                    row = sheet.createRow(++index);
                    if (isProject) {
                        cell = row.createCell(0);
                        cell.setCellValue(namepeoject);
                        cell = row.createCell(1);
                        cell.setCellValue(numberpeoject);
                        cell = row.createCell(2);
                        cell.setCellValue(ipstatuspeoject);
                        cell = row.createCell(3);
                        cell.setCellValue(ipscopepeoject);
                        cell = row.createCell(4);
                        cell.setCellValue(orgname);
                        cell = row.createCell(5);
                        cell.setCellValue(purprojectset);
                        cell = row.createCell(6);
                        cell.setCellValue(purtypename);
                        cell = row.createCell(7);
                        cell.setCellValue(setupdate);
                        cell = row.createCell(8);
                        cell.setCellValue(bidmodename);
                        isProject = false;
                    }
                    if (issupplier) {
                        cell = row.createCell(9);
                        cell.setCellValue(suppierName);
                        cell = row.createCell(10);
                        cell.setCellValue(stage);
                        cell = row.createCell(11);
                        cell.setCellValue(ip);
                        cell = row.createCell(12);
                        cell.setCellValue(operationtime);
                        issupplier = false;
                    }
                    cell = row.createCell(13);
                    cell.setCellValue(ResManager.loadKDString((String)"\u662f", (String)"BidCenterOpenIPList_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    DynamicObject unrecordIP = entey.getDynamicObject("unsupplier");
                    String uncontrastrange = entey.getString("contrastrange").equals("thisbidding") ? ResManager.loadKDString((String)"\u672c\u6b21\u62db\u6807", (String)"BidCenterOpenIPList_7", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5386\u53f2\u62db\u6807", (String)"BidCenterOpenIPList_8", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                    DynamicObject unsupplierDynamicObject = unrecordIP.getDynamicObject("supplier");
                    String unsuppierName = "";
                    if (unsupplierDynamicObject != null) {
                        unsuppierName = unsupplierDynamicObject.getString("name");
                    }
                    DynamicObject unbidproject = unrecordIP.getDynamicObject("bidproject");
                    String unbidprojectName = unbidproject.getString("name");
                    String unstage = BidCenterOpenIPList.StageName(unrecordIP.getString("stage"));
                    String unip = unrecordIP.getString("ip");
                    String unoperationtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(unrecordIP.getDate("operationtime"));
                    cell = row.createCell(14);
                    cell.setCellValue(uncontrastrange);
                    cell = row.createCell(15);
                    cell.setCellValue(unsuppierName);
                    cell = row.createCell(16);
                    cell.setCellValue(unbidprojectName);
                    cell = row.createCell(17);
                    cell.setCellValue(unstage);
                    cell = row.createCell(18);
                    cell.setCellValue(unip);
                    cell = row.createCell(19);
                    cell.setCellValue(unoperationtime);
                }
            }
        }
    }

    static String StageName(String str) {
        if ("download".equals(str)) {
            return ResManager.loadKDString((String)"\u6807\u4e66\u4e0b\u8f7d", (String)"BidCenterOpenIPList_9", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("tender".equals(str)) {
            return ResManager.loadKDString((String)"\u6295\u6807", (String)"BidCenterOpenIPList_10", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("recall".equals(str)) {
            return ResManager.loadKDString((String)"\u64a4\u6807", (String)"BidCenterOpenIPList_11", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("clarify".equals(str)) {
            return ResManager.loadKDString((String)"\u6f84\u6e05", (String)"BidCenterOpenIPList_12", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("bustalk".equals(str)) {
            return ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224", (String)"BidCenterOpenIPList_13", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        return "";
    }
}

