/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidClarificaitonEditUI
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bidProjectF7 = dataEntity.getDynamicObject("bidproject");
        if (bidProjectF7 != null) {
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            String appId = bidProject.getString("entitytypeid").split("_")[0];
            DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidpublish"), (String)"id,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.email", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("billstatus", "=", (Object)"P")});
            TreeMap<String, DynamicObject> supplierMap = new TreeMap<String, DynamicObject>();
            if (bidPublish != null) {
                DynamicObjectCollection bidSectionList = bidPublish.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidSection : bidSectionList) {
                    DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                    if (supplierEntryCol == null) continue;
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier == null) continue;
                        supplierMap.put(supplier.getString("id"), supplierEntry);
                    }
                }
            }
            DynamicObjectCollection viewEntryList = dataEntity.getDynamicObjectCollection("entryview");
            ArrayList<String> supplierIdList = new ArrayList<String>();
            if (!CollectionUtils.isEmpty((Collection)viewEntryList)) {
                for (DynamicObject viewEntry : viewEntryList) {
                    DynamicObject supplier = viewEntry.getDynamicObject("supplier");
                    if (supplier == null) continue;
                    supplierIdList.add(supplier.getString("id"));
                }
            }
            for (Map.Entry supplier : supplierMap.entrySet()) {
                DynamicObject supplierInfo = (DynamicObject)supplier.getValue();
                if (!CollectionUtils.isEmpty(supplierIdList)) {
                    if (supplierIdList.contains(supplier.getKey())) continue;
                    this.createEntryView(supplierInfo, viewEntryList);
                    continue;
                }
                this.createEntryView(supplierInfo, viewEntryList);
            }
            if (!CollectionUtils.isEmpty((Collection)viewEntryList)) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            }
        }
        this.setButtonVisible();
    }

    public void createEntryView(DynamicObject supplierInfo, DynamicObjectCollection viewEntryList) {
        DynamicObject newEntry = viewEntryList.addNew();
        newEntry.set("supplier", supplierInfo.get("supplier"));
        newEntry.set("suppliercontact", supplierInfo.get("suppliercontact"));
        newEntry.set("contactphone", supplierInfo.get("contactphone"));
        newEntry.set("isdownload", (Object)0);
        newEntry.set("isview", (Object)0);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("submit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String billstatus = dataEntity.getString("billstatus");
            if (!"A".equals(billstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidClarificaitonEditUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (this.getView().getModel().getEntryRowCount("entryvideo") == 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u62db\u6807\u4ea4\u5e95\u6587\u4ef6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidClarificaitonEditUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showTipNotification(msg);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.setButtonVisible();
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void setButtonVisible() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus isEditable = formShowParameter.getStatus();
        String billStatus = this.getModel().getDataEntity(true).getString("billstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_del", "bar_submit", "bar_unsubmit", "bar_audit", "bar_unaudit", "bar_release", "bar_unrelease", "bar_close"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"contentpanel", "bar_release"});
        if (BillStatusEnum.DISBEGIN.getVal().equals(billStatus)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"clarificaitontheme"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_close"});
        } else if (BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"clarificaitontheme"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_del", "bar_submit", "bar_unsubmit", "bar_close"});
        } else if (BillStatusEnum.SUBMIT.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit", "bar_audit", "bar_unaudit", "bar_close"});
        } else if (BillStatusEnum.AUDITED.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_audit", "bar_unaudit", "bar_release", "bar_unrelease", "bar_close"});
            if (isEditable.equals((Object)OperationStatus.VIEW)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_release", "bar_unrelease"});
            }
        } else if (BillStatusEnum.AUDITING.getVal().equals(billStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanel", "clarificaitontheme"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_close"});
        } else if (BillStatusEnum.COMPLETE.getVal().equals(billStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanel", "bar_release", "clarificaitontheme"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_release", "bar_unrelease", "bar_close"});
        } else if (BillStatusEnum.INVALID.getVal().equals(billStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanel", "clarificaitontheme"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_close"});
        }
    }
}

