/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.basedata.IBidThanksLetterService;
import kd.scm.bid.business.basedata.IBidWinNoticeService;
import kd.scm.bid.business.basedata.serviceImpl.BidThanksLetterServiceImpl;
import kd.scm.bid.business.basedata.serviceImpl.BidWinNoticeServiceImpl;
import kd.scm.bid.business.bill.IBidAnnocumentService;
import kd.scm.bid.business.bill.IBidDecisionService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidAnnocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.PurchaseModel;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.BidBillEdit;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.scm.bid.formplugin.bill.helper.DynamicTabHelper;
import kd.scm.bid.formplugin.bill.helper.PermissionHepler;
import kd.scm.bid.formplugin.bill.util.SupplierInvalUtil;

public class BidDecisionEditUI
extends BidBillEdit
implements UploadListener,
CellClickListener {
    private IBidDecisionService service = new BidDecisionServiceImpl();
    private IBidAnnocumentService annocumentService = new BidAnnocumentServiceImpl();
    private IBidWinNoticeService winNoticeService = new BidWinNoticeServiceImpl();
    private IBidThanksLetterService thanksLetterService = new BidThanksLetterServiceImpl();
    private IBidProjectService projectService = new BidProjectServiceImpl();
    private static final String KEY_ATTACHMENT = "attachment";
    private static final String BILL_STATUS = "billstatus";
    private static final String BTN_VIEWBIDEVALUATION = "viewbidevaluationbtn";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid entryGrid4Supplier = (EntryGrid)this.getControl("supplierentry");
        if (entryGrid4Supplier == null) {
            return;
        }
        entryGrid4Supplier.addCellClickListener((CellClickListener)this);
    }

    @Override
    public String getBillId() {
        return FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass());
    }

    @Override
    protected boolean needHandleSupplier() {
        return true;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (OperationStatus.EDIT.equals((Object)operationStatus) || OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            Object id = ((BillShowParameter)formShowParameter).getPkId();
            if (id == null) {
                return;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(id.toString()));
            DynamicObject object = QueryServiceHelper.queryOne((String)"bid_decision", (String)BILL_STATUS, (QFilter[])new QFilter[]{qFilter});
            if (object == null) {
                return;
            }
            boolean eFlag = BillStatusEnum.INVALID.getVal().equals(object.get(BILL_STATUS));
            boolean xxFlag = BillStatusEnum.INVALIDXX.getVal().equals(object.get(BILL_STATUS));
            if (eFlag || xxFlag) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
        }
    }

    @Override
    protected boolean needFlagNewSupplier() {
        Boolean needflagnewsupplier = (Boolean)this.getModel().getValue("needflagnewsupplier");
        return needflagnewsupplier != null && needflagnewsupplier != false;
    }

    @Override
    protected boolean needContact() {
        return false;
    }

    @Override
    protected boolean needSupplierStatisticInfo() {
        return false;
    }

    public void beforeBindData(EventObject e) {
        DynamicObject bidDecision;
        String status;
        super.beforeBindData(e);
        String purDetailText = ResManager.loadKDString((String)"\u7f16\u8f91", (String)"BidDecisionEditUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        DynamicObject project = this.getView().getModel().getDataEntity(true).getDynamicObject("bidproject");
        DynamicObject bidOpen = null;
        if (project != null) {
            QFilter qFilter = new QFilter("bidproject.id", "=", project.getPkValue());
            QFilter statusFilter = new QFilter(BILL_STATUS, "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
            DynamicObject[] bidOpens = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{qFilter, statusFilter});
            if (bidOpens != null && bidOpens.length > 0) {
                bidOpen = bidOpens[0];
            }
        }
        if (!StringUtils.equals((CharSequence)"A", (CharSequence)(status = (bidDecision = this.getModel().getDataEntity(true)).getString(BILL_STATUS))) && !StringUtils.equals((CharSequence)"D", (CharSequence)status)) {
            EntryGrid aptitudeEntryGrid = (EntryGrid)this.getControl("supplierentry");
            aptitudeEntryGrid.setColumnProperty("score", "l", (Object)55);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"baseprice"});
        DynamicObjectCollection deSectionColl = bidDecision.getDynamicObjectCollection("bidsection");
        if (deSectionColl != null && deSectionColl.size() > 0) {
            for (DynamicObject section : deSectionColl) {
                DynamicObjectCollection suppliery = section.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplier : suppliery) {
                    supplier.set("commentdetail", (Object)purDetailText);
                    if (!status.equals(OperationStatus.VIEW.getValue() + "") && ("A".equals(status) || "D".equals(status))) continue;
                    purDetailText = ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidDecisionEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                    supplier.set("commentdetail", (Object)purDetailText);
                }
            }
        }
        if (bidOpen != null && !CollectionUtils.isEmpty((Collection)deSectionColl)) {
            DynamicObjectCollection tempPurDetails;
            bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpen.getString("id"), (String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
            MainEntityType bidDecisionType = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
            EntityType supbackdetailType = (EntityType)bidDecisionType.getAllEntities().get("supbackdetail");
            EntityType supfinaldetailType = (EntityType)bidDecisionType.getAllEntities().get("supfinaldetail");
            DynamicObjectCollection opSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
            DynamicObjectCollection dynamicObjectCollection = tempPurDetails = opSectionColl == null ? null : ((DynamicObject)deSectionColl.get(0)).getDynamicObjectCollection("supbackdetail");
            if (tempPurDetails == null || tempPurDetails.size() == 0) {
                for (DynamicObject deSection : deSectionColl) {
                    String deSectionName = deSection.getString("sectionname");
                    DynamicObjectCollection desupplierEntrys = deSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject desupplierEntry : desupplierEntrys) {
                        desupplierEntry.set("commentdetail", (Object)purDetailText);
                    }
                    DynamicObjectCollection newBackDetails = new DynamicObjectCollection((DynamicObjectType)supbackdetailType, (Object)deSection);
                    DynamicObjectCollection newFinalDetails = new DynamicObjectCollection((DynamicObjectType)supfinaldetailType, (Object)deSection);
                    for (DynamicObject opSection : opSectionColl) {
                        if (!StringUtils.equals((CharSequence)deSectionName, (CharSequence)opSection.getString("sectionname"))) continue;
                        DynamicObjectCollection opPurDetails = opSection.getDynamicObjectCollection("supplierdetail");
                        for (DynamicObject opPurDetail : opPurDetails) {
                            DynamicObject newBackDetail = new DynamicObject((DynamicObjectType)supbackdetailType);
                            DynamicObject newFinalDetail = new DynamicObject((DynamicObjectType)supfinaldetailType);
                            newBackDetail.set("seq", opPurDetail.get("seq"));
                            newBackDetail.set("lpursectionname", (Object)deSectionName);
                            newBackDetail.set("pursupplier", opPurDetail.get("pursupplier"));
                            newBackDetail.set("purentrycontent", opPurDetail.get("purentrycontent"));
                            newBackDetail.set("purentryproject", opPurDetail.get("purentryproject"));
                            newBackDetail.set("materialid", opPurDetail.get("materialid"));
                            newBackDetail.set("baseunit", opPurDetail.get("baseunit"));
                            newBackDetail.set("materialdes", opPurDetail.get("materialdes"));
                            newBackDetail.set("qty", opPurDetail.get("qty"));
                            newBackDetail.set("inclutaxprice", opPurDetail.get("inclutaxprice"));
                            newBackDetail.set("inclutaxamount", opPurDetail.get("inclutaxamount"));
                            newBackDetail.set("taxrate", opPurDetail.get("taxrate"));
                            newBackDetail.set("taxamount", opPurDetail.get("taxamount"));
                            newBackDetail.set("excepttaxamount", opPurDetail.get("excepttaxamount"));
                            newBackDetail.set("costrate", opPurDetail.get("costrate"));
                            newBackDetails.add((Object)newBackDetail);
                            newFinalDetail.set("seq", opPurDetail.get("seq"));
                            newFinalDetail.set("lpursupplier", opPurDetail.get("pursupplier"));
                            newFinalDetail.set("lpurentrycontent", opPurDetail.get("purentrycontent"));
                            newFinalDetail.set("lpurentryproject", opPurDetail.get("purentryproject"));
                            newFinalDetail.set("lmaterialid", opPurDetail.get("materialid"));
                            newFinalDetail.set("lmaterialdes", opPurDetail.get("materialdes"));
                            newFinalDetail.set("lqty", opPurDetail.get("qty"));
                            newFinalDetail.set("linclutaxprice", opPurDetail.get("inclutaxprice"));
                            newFinalDetail.set("linclutaxamount", opPurDetail.get("inclutaxamount"));
                            newFinalDetail.set("ltaxrate", opPurDetail.get("taxrate"));
                            newFinalDetail.set("ltaxamount", opPurDetail.get("taxamount"));
                            newFinalDetail.set("lexcepttaxamount", opPurDetail.get("excepttaxamount"));
                            newFinalDetail.set("lcostrate", opPurDetail.get("costrate"));
                            newFinalDetails.add((Object)newFinalDetail);
                        }
                    }
                    deSection.set("supbackdetail", (Object)newBackDetails);
                    deSection.set("supfinaldetail", (Object)newFinalDetails);
                }
            }
            this.setTotalFinalAuditAmount();
        } else {
            Object bidProjectId = this.getModel().getDataEntity().getDynamicObject("bidproject").getPkValue();
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            MainEntityType bidDecisionType = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
            EntityType supbackdetailType = (EntityType)bidDecisionType.getAllEntities().get("supbackdetail");
            EntityType supfinaldetailType = (EntityType)bidDecisionType.getAllEntities().get("supfinaldetail");
            DynamicObjectCollection bidProjectSection = bidProject.getDynamicObjectCollection("bidsection");
            DynamicObjectCollection tempPurDetails = ((DynamicObject)deSectionColl.get(0)).getDynamicObjectCollection("supbackdetail");
            if (tempPurDetails == null || tempPurDetails.size() == 0) {
                for (DynamicObject decisionSection : deSectionColl) {
                    DynamicObjectCollection newBackDetails = new DynamicObjectCollection((DynamicObjectType)supbackdetailType, (Object)decisionSection);
                    DynamicObjectCollection newFinalDetails = new DynamicObjectCollection((DynamicObjectType)supfinaldetailType, (Object)decisionSection);
                    String deSectionName = decisionSection.getString("sectionname");
                    for (int i = 0; i < bidProjectSection.size(); ++i) {
                        DynamicObject projectSection = (DynamicObject)bidProjectSection.get(i);
                        if (!StringUtils.equals((CharSequence)deSectionName, (CharSequence)projectSection.getString("sectionname"))) continue;
                        DynamicObjectCollection supplierEntryColl = decisionSection.getDynamicObjectCollection("supplierentry");
                        DynamicObjectCollection supbackdetailColl = decisionSection.getDynamicObjectCollection("supbackdetail");
                        for (DynamicObject supplierEntry : supplierEntryColl) {
                            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                            int result = 0;
                            for (DynamicObject supbackdetail : supbackdetailColl) {
                                Object supBackDetailPkValue = supbackdetail.getDynamicObject("pursupplier").getPkValue();
                                if (!supBackDetailPkValue.equals(supplier.getPkValue())) continue;
                                ++result;
                            }
                            if (result != 0) continue;
                            DynamicObjectCollection projectEntryColl = projectSection.getDynamicObjectCollection("projectentry");
                            for (DynamicObject projectEntry : projectEntryColl) {
                                DynamicObject newBackDetail = new DynamicObject((DynamicObjectType)supbackdetailType);
                                DynamicObject newFinalDetail = new DynamicObject((DynamicObjectType)supfinaldetailType);
                                newBackDetail.set("pursupplier", (Object)supplier);
                                newBackDetail.set("purentrycontent", projectEntry.get("purentrycontent"));
                                newBackDetail.set("purentryproject", projectEntry.get("purentryproject"));
                                newBackDetail.set("materialid", projectEntry.get("materialid"));
                                newBackDetail.set("baseunit", projectEntry.get("baseunit"));
                                newBackDetail.set("materialdes", projectEntry.get("materialdes"));
                                newBackDetail.set("qty", projectEntry.get("qty"));
                                newBackDetails.add((Object)newBackDetail);
                                newFinalDetail.set("lpursupplier", (Object)supplier);
                                newFinalDetail.set("lpurentrycontent", projectEntry.get("purentrycontent"));
                                newFinalDetail.set("lpurentryproject", projectEntry.get("purentryproject"));
                                newFinalDetail.set("lmaterialid", projectEntry.get("materialid"));
                                newFinalDetail.set("lmaterialdes", projectEntry.get("materialdes"));
                                newFinalDetail.set("lqty", projectEntry.get("qty"));
                                newFinalDetails.add((Object)newFinalDetail);
                            }
                        }
                    }
                    decisionSection.set("supbackdetail", (Object)newBackDetails);
                    decisionSection.set("supfinaldetail", (Object)newFinalDetails);
                }
            }
            this.setTotalFinalAuditAmount();
        }
        String datasource = bidDecision.getString("datasource");
        if ("2".equals(datasource)) {
            this.setTwoOrgToSupFinalDetail(bidDecision);
        }
    }

    protected void setTwoOrgToSupFinalDetail(DynamicObject bidDecision) {
        DynamicObject bidproject = bidDecision.getDynamicObject("bidproject");
        if (bidproject == null) {
            return;
        }
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((String)"bid_project", (String)"bidsection,projectentry,\npurentrycontent,purentryproject,materialid,baseunit,materialdes,qty,entryreqorg,entryrecorg", (QFilter[])new QFilter[]{new QFilter("id", "=", bidproject.getPkValue())});
        DynamicObjectCollection bidsection = bidProject.getDynamicObjectCollection("bidsection");
        if (bidsection.size() == 0) {
            return;
        }
        DynamicObject bidSection = (DynamicObject)bidsection.get(0);
        HashMap projectEntryMap = new HashMap(16);
        bidSection.getDynamicObjectCollection("projectentry").forEach(entry -> {
            String key = this.getKey((DynamicObject)entry, true);
            if (!key.isEmpty()) {
                projectEntryMap.put(key, entry);
            }
        });
        DynamicObjectCollection decisionSection = bidDecision.getDynamicObjectCollection("bidsection");
        if (decisionSection.size() == 0) {
            return;
        }
        DynamicObject section = (DynamicObject)decisionSection.get(0);
        section.getDynamicObjectCollection("supfinaldetail").forEach(entry -> {
            String key = this.getKey((DynamicObject)entry, false);
            DynamicObject projectentry = (DynamicObject)projectEntryMap.get(key);
            if (projectentry == null) {
                return;
            }
            entry.set("entryreqorg", (Object)projectentry.getDynamicObject("entryreqorg"));
            entry.set("entryrecorg", (Object)projectentry.getDynamicObject("entryrecorg"));
        });
    }

    public String getKey(DynamicObject entry, boolean isFromProject) {
        String materialdes;
        BigDecimal qty;
        DynamicObject materialid;
        DynamicObject purentryproject;
        StringBuilder sb = new StringBuilder();
        String purentrycontent = entry.getString(isFromProject ? "purentrycontent" : "lpurentrycontent");
        if (purentrycontent != null) {
            sb.append(purentrycontent);
        }
        if ((purentryproject = entry.getDynamicObject(isFromProject ? "purentryproject" : "lpurentryproject")) != null) {
            sb.append(purentryproject.getPkValue());
        }
        if ((materialid = entry.getDynamicObject(isFromProject ? "materialid" : "lmaterialid")) != null) {
            sb.append(materialid.getPkValue());
        }
        if ((qty = entry.getBigDecimal(isFromProject ? "qty" : "lqty")) != null) {
            sb.append(qty);
        }
        if ((materialdes = entry.getString(isFromProject ? "materialdes" : "lmaterialdes")) != null) {
            sb.append(materialdes);
        }
        return sb.toString();
    }

    public void setTotalFinalAuditAmount() {
        DynamicObject decision = this.getModel().getDataEntity(true);
        DynamicObject bidProject = decision.getDynamicObject("bidproject");
        boolean bidBottomMake = bidProject.getBoolean("bidbottommake");
        String appId = this.getModel().getDataEntityType().getAppId();
        boolean bidOpen = bidProject.getBoolean("bidopen");
        if (bidOpen) {
            this.getPurEntryDataFromBidOpen((Long)bidProject.getPkValue(), appId, decision);
        } else if (bidBottomMake) {
            String selectFeild = "bidbottomamount,bidsection.sectionname,projectentry.purentrycontent,projectentry.purentryproject,projectentry.controlamount,projectentry.declareamount,projectentry.finalauditamount,projectentry.materialid,projectentry.baseunit,projectentry.materialdes,projectentry.qty,projectentry.controlvat,projectentry.ctrlamtexceptvat,projectentry.purentryworkload,projectentry.purentrycomment,projectentry.workload,projectentry.secdeposit,projectentry.qty,projectentry.nottaxplanamount,projectentry.planamount,projectentry.listnumber,projectentry.listname,projectentry.resourceitem";
            DynamicObject[] bidBottomMakes = BusinessDataServiceHelper.load((String)(appId + "_bottom_make"), (String)selectFeild, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter(BILL_STATUS, "=", (Object)"C")});
            if (bidBottomMakes.length > 0) {
                this.getPurEntryDataFromBottomMake(appId, decision, bidBottomMakes[0]);
            } else {
                this.getPurEntryDataFromBidProject((Long)bidProject.getPkValue(), appId, decision);
            }
        } else {
            this.getPurEntryDataFromBidProject((Long)bidProject.getPkValue(), appId, decision);
        }
    }

    protected void getPurEntryDataFromBidProject(long projectId, String appId, DynamicObject decision) {
        String billStatus = decision.getString(BILL_STATUS);
        if ("D".equals(billStatus) || "X".equals(billStatus)) {
            DynamicObject queryBidProject = BusinessDataServiceHelper.loadSingle((String)(appId + "_project"), (String)"bidsection,sectionname,projectentry,purentrycontent,purentryproject,materialid,materialdes,qty,controlamount,planamount,nottaxplanamount,controlvat,ctrlamtexceptvat,purentryworkload,purentrycomment", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
            if (queryBidProject == null) {
                return;
            }
            queryBidProject = BusinessDataServiceHelper.loadSingle((Object)queryBidProject.getPkValue(), (String)(appId + "_project"));
            DynamicObjectCollection bidSection = queryBidProject.getDynamicObjectCollection("bidsection");
            DynamicObjectCollection bottomSection = decision.getDynamicObjectCollection("bottomsection");
            bottomSection.clear();
            for (int i = 0; i < bidSection.size(); ++i) {
                DynamicObject section = (DynamicObject)bidSection.get(i);
                DynamicObject bottomSectionRow = bottomSection.addNew();
                bottomSectionRow.set("botsectionname", section.get("sectionname"));
                DynamicObjectCollection bottomentry = bottomSectionRow.getDynamicObjectCollection("bottomentry");
                bottomentry.clear();
                DynamicObjectCollection projectEntry = section.getDynamicObjectCollection("projectentry");
                for (int j = 0; j < projectEntry.size(); ++j) {
                    DynamicObject entry = (DynamicObject)projectEntry.get(j);
                    DynamicObject botentry = bottomentry.addNew();
                    botentry.set("botpurentrycontent", entry.get("purentrycontent"));
                    botentry.set("botpurentryproject", entry.get("purentryproject"));
                    DynamicObject material = entry.getDynamicObject("materialid");
                    if (material != null) {
                        material = BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)"name,modelnum,baseunit.name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((Long)material.getPkValue()))});
                    }
                    botentry.set("botmaterialid", (Object)material);
                    botentry.set("botbaseunit", entry.get("baseunit"));
                    botentry.set("botmaterialdes", entry.get("materialdes"));
                    botentry.set("botqty", entry.get("qty"));
                    botentry.set("botcontrolamount", entry.get("controlamount"));
                    botentry.set("botcontrolvat", entry.get("controlvat"));
                    botentry.set("declareamount", (Object)BigDecimal.ZERO);
                    botentry.set("finalauditamount", (Object)BigDecimal.ZERO);
                    botentry.set("planamount", entry.get("planamount"));
                    botentry.set("nottaxplanamount", entry.get("nottaxplanamount"));
                    if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) continue;
                    botentry.set("botlistnumber", entry.get("listnumber"));
                    botentry.set("botlistname", entry.get("listname"));
                    botentry.set("botresourceitem", entry.get("resourceitem"));
                }
            }
        }
    }

    public void getPurEntryDataFromBidOpen(long projectId, String appId, DynamicObject decision) {
        String billStatus = decision.getString(BILL_STATUS);
        BigDecimal basePrice = BigDecimal.ZERO;
        if ("A".equals(billStatus) || "D".equals(billStatus)) {
            DynamicObject queryBidProject = BusinessDataServiceHelper.loadSingle((String)(appId + "_project"), (String)"id, bidopentype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
            String bidOpenType = queryBidProject.getString("bidopentype");
            DynamicObject bidOpen = null;
            String selectProperties = "bottomsection,botsectionname,bottomentry,botpurentrycontent,botpurentryproject,botmaterialid,botmaterialdes,botbaseunit,botqty,planamount,nottaxplanamount,botcontrolvat,botctrlamtexceptvat,botcontrolamount,botpurentryworkload,declareamount,finalauditamount,botlistnumber,botlistname,botresourceitem";
            if (StringUtils.isNotBlank((CharSequence)bidOpenType) && !StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)bidOpenType)) {
                if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenType)) {
                    bidOpen = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidopen"), (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()), new QFilter(BILL_STATUS, "=", (Object)BillStatusEnum.OPEN.getVal())});
                    if (bidOpen == null) {
                        bidOpen = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidopen"), (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()), new QFilter(BILL_STATUS, "=", (Object)BillStatusEnum.OPEN.getVal())});
                    }
                } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenType) && (bidOpen = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidopen"), (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()), new QFilter(BILL_STATUS, "=", (Object)BillStatusEnum.OPEN.getVal())})) == null) {
                    bidOpen = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidopen"), (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()), new QFilter(BILL_STATUS, "=", (Object)BillStatusEnum.OPEN.getVal())});
                }
            } else {
                bidOpen = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidopen"), (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter(BILL_STATUS, "=", (Object)BillStatusEnum.OPEN.getVal())});
            }
            if (bidOpen == null) {
                return;
            }
            DynamicObjectCollection openBottomSection = bidOpen.getDynamicObjectCollection("bottomsection");
            DynamicObjectCollection bottomSection = decision.getDynamicObjectCollection("bottomsection");
            bottomSection.clear();
            for (int i = 0; i < openBottomSection.size(); ++i) {
                DynamicObject section = (DynamicObject)openBottomSection.get(i);
                DynamicObject bottomSectionRow = bottomSection.addNew();
                bottomSectionRow.set("botsectionname", section.get("botsectionname"));
                DynamicObjectCollection bottomEntryCol = bottomSectionRow.getDynamicObjectCollection("bottomentry");
                bottomEntryCol.clear();
                DynamicObjectCollection openBottomEntryCol = section.getDynamicObjectCollection("bottomentry");
                for (int j = 0; j < openBottomEntryCol.size(); ++j) {
                    DynamicObject entry = (DynamicObject)openBottomEntryCol.get(j);
                    DynamicObject bottomEntry = bottomEntryCol.addNew();
                    bottomEntry.set("botpurentrycontent", entry.get("botpurentrycontent"));
                    bottomEntry.set("botpurentryproject", entry.get("botpurentryproject"));
                    DynamicObject material = entry.getDynamicObject("botmaterialid");
                    if (material != null) {
                        material = BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)"name,modelnum,baseunit.name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((Long)material.getPkValue()))});
                    }
                    bottomEntry.set("botmaterialid", (Object)material);
                    bottomEntry.set("botbaseunit", (Object)entry.getDynamicObject("botbaseunit"));
                    bottomEntry.set("botmaterialdes", entry.get("botmaterialdes"));
                    bottomEntry.set("botqty", entry.get("botqty"));
                    bottomEntry.set("botcontrolamount", entry.get("botcontrolamount"));
                    bottomEntry.set("declareamount", entry.get("declareamount"));
                    bottomEntry.set("botcontrolvat", entry.get("botcontrolvat"));
                    bottomEntry.set("botctrlamtexceptvat", entry.get("botctrlamtexceptvat"));
                    bottomEntry.set("finalauditamount", entry.get("finalauditamount"));
                    bottomEntry.set("planamount", entry.get("planamount"));
                    bottomEntry.set("nottaxplanamount", entry.get("nottaxplanamount"));
                    basePrice = basePrice.add(entry.getBigDecimal("finalauditamount"));
                    if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) continue;
                    bottomEntry.set("botlistnumber", entry.get("botlistnumber"));
                    bottomEntry.set("botlistname", entry.get("botlistname"));
                    bottomEntry.set("botresourceitem", entry.get("botresourceitem"));
                }
            }
            decision.set("baseprice", (Object)basePrice);
            this.getView().updateView("baseprice");
        }
    }

    protected void getPurEntryDataFromBottomMake(String appId, DynamicObject decision, DynamicObject bidBottomMake) {
        String billStatus = decision.getString(BILL_STATUS);
        BigDecimal basePrice = BigDecimal.ZERO;
        if ("A".equals(billStatus) || "D".equals(billStatus)) {
            DynamicObjectCollection bottomSectionColl = decision.getDynamicObjectCollection("bottomsection");
            bottomSectionColl.clear();
            DynamicObjectCollection bidBottomMakeSectionColl = bidBottomMake.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidBottomMakeSectionColl.size(); ++i) {
                DynamicObject bidBottomMakeSection = (DynamicObject)bidBottomMakeSectionColl.get(i);
                DynamicObject decisionBottomSection = bottomSectionColl.addNew();
                decisionBottomSection.set("botsectionname", bidBottomMakeSection.get("sectionname"));
                DynamicObjectCollection decisionBottomEntryColl = decisionBottomSection.getDynamicObjectCollection("bottomentry");
                DynamicObjectCollection projectEntryColl = bidBottomMakeSection.getDynamicObjectCollection("projectentry");
                for (int j = 0; j < projectEntryColl.size(); ++j) {
                    DynamicObject decisionBottomEntry = decisionBottomEntryColl.addNew();
                    DynamicObject projectEntry = (DynamicObject)projectEntryColl.get(j);
                    decisionBottomEntry.set("botpurentrycontent", projectEntry.get("purentrycontent"));
                    decisionBottomEntry.set("botpurentryproject", projectEntry.get("purentryproject"));
                    decisionBottomEntry.set("botmaterialid", projectEntry.get("materialid"));
                    decisionBottomEntry.set("botmaterialdes", projectEntry.get("materialdes"));
                    decisionBottomEntry.set("botbaseunit", projectEntry.get("baseunit"));
                    decisionBottomEntry.set("botcontrolamount", projectEntry.get("controlamount"));
                    decisionBottomEntry.set("declareamount", projectEntry.get("declareamount"));
                    decisionBottomEntry.set("botcontrolvat", projectEntry.get("controlvat"));
                    decisionBottomEntry.set("botctrlamtexceptvat", projectEntry.get("ctrlamtexceptvat"));
                    decisionBottomEntry.set("finalauditamount", projectEntry.get("finalauditamount"));
                    decisionBottomEntry.set("botqty", projectEntry.get("qty"));
                    decisionBottomEntry.set("planamount", projectEntry.get("planamount"));
                    decisionBottomEntry.set("nottaxplanamount", projectEntry.get("nottaxplanamount"));
                    basePrice = basePrice.add(projectEntry.getBigDecimal("finalauditamount"));
                    if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) continue;
                    decisionBottomEntry.set("botlistnumber", projectEntry.get("listnumber"));
                    decisionBottomEntry.set("botlistname", projectEntry.get("listname"));
                    decisionBottomEntry.set("botresourceitem", projectEntry.get("resourceitem"));
                }
            }
            decision.set("baseprice", (Object)basePrice);
            this.getView().updateView("baseprice");
        }
    }

    @Override
    public void afterBindData(EventObject eventobject) {
        super.afterBindData(eventobject);
        this.setBillStatus();
        DynamicObject project = (DynamicObject)this.getModel().getValue("bidproject");
        String billstatus = (String)this.getModel().getValue(BILL_STATUS);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_VIEWBIDEVALUATION});
        if (project != null) {
            if (!StringUtils.equals((CharSequence)billstatus, (CharSequence)"C")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"winnotice", "thanksletter"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"winnotice", "thanksletter"});
            }
            boolean isBidOpen = project.getBoolean("bidopen");
            boolean isBidEvaluation = project.getBoolean("bidevaluation");
            if (isBidEvaluation) {
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_VIEWBIDEVALUATION});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_VIEWBIDEVALUATION});
            }
            if (!isBidOpen) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"evaluatedecideway"});
                Object decide = this.getModel().getValue("evaluatedecideway");
                if (decide == null && StringUtils.equals((CharSequence)billstatus, (CharSequence)"D")) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"evaluatedecideway"});
                    this.getModel().setValue("evaluatedecideway", (Object)this.getDecideWayToWhetherHideScore());
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"evaluatedecideway"});
            }
        }
        this.setScoreByDecideWay();
        String appId = this.getModel().getDataEntityType().getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"issendwinnotice", "issendthanksletter", "winnotice", "thanksletter"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"issendwinnotice", "issendthanksletter", "winnotice", "thanksletter"});
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
        HashSet<Boolean> flags = new HashSet<Boolean>();
        if (bidSectionColl != null && bidSectionColl.size() > 0) {
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                int j;
                boolean isSendWinNotice = ((DynamicObject)bidSectionColl.get(i)).getBoolean("issendwinnotice");
                flags.add(isSendWinNotice);
                DynamicObjectCollection supplierColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                DynamicObjectCollection supplierFinalColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supfinaldetail");
                DynamicObjectCollection supplierBackColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supbackdetail");
                if (supplierColl != null && supplierColl.size() > 0) {
                    for (j = 0; j < supplierColl.size(); ++j) {
                        ((DynamicObject)supplierColl.get(j)).set("finaltaxrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("finaltaxrate").multiply(new BigDecimal("100")));
                        ((DynamicObject)supplierColl.get(j)).set("tendertaxrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("tendertaxrate").multiply(new BigDecimal("100")));
                        ((DynamicObject)supplierColl.get(j)).set("finalrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("finalrate").multiply(new BigDecimal("100")));
                        ((DynamicObject)supplierColl.get(j)).set("rate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("rate").multiply(new BigDecimal("100")));
                    }
                }
                if (supplierFinalColl != null && supplierFinalColl.size() > 0) {
                    for (j = 0; j < supplierFinalColl.size(); ++j) {
                        ((DynamicObject)supplierFinalColl.get(j)).set("ltaxrate", (Object)((DynamicObject)supplierFinalColl.get(j)).getBigDecimal("ltaxrate").multiply(new BigDecimal("100")));
                        ((DynamicObject)supplierFinalColl.get(j)).set("lcostrate", (Object)((DynamicObject)supplierFinalColl.get(j)).getBigDecimal("lcostrate").multiply(new BigDecimal("100")));
                    }
                }
                if (supplierBackColl == null || supplierBackColl.size() <= 0) continue;
                for (j = 0; j < supplierBackColl.size(); ++j) {
                    ((DynamicObject)supplierBackColl.get(j)).set("taxrate", (Object)((DynamicObject)supplierBackColl.get(j)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                    ((DynamicObject)supplierBackColl.get(j)).set("costrate", (Object)((DynamicObject)supplierBackColl.get(j)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                }
            }
            if (!flags.contains(Boolean.TRUE)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bidconfirmdes", "bidconfirmfile_new"});
            }
        }
        this.getView().updateView("supplierentry");
        this.getView().updateView("supfinaldetail");
        this.getView().updateView("supbackdetail");
        this.controlListBtnStatus();
        DynamicObjectCollection bottomsection = dataEntity.getDynamicObjectCollection("bottomsection");
        if (bottomsection.size() <= 1) {
            this.setSectionVisible();
        }
        DynamicObject purtype = null;
        if (project != null) {
            String docType = project.getString("doctype");
            if (!StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)docType) && StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)docType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"techfile", "techfile_new", "techrounds"});
            }
            purtype = project.getDynamicObject("purtype");
        }
        if (purtype != null) {
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bid_project");
            int bidtype = bidProject.getInt("bidtype");
            if (bidtype != 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"botpurentrycontent"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"botmaterialid"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"botmaterialname"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"botmaterialdes"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"botmodel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"botunit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"botbaseunit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"botqty"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"botinclutaxprice"});
            }
        }
        if ("D".equals(billstatus) || "A".equals(billstatus) || "B".equals(billstatus) || "I".equals(billstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sendnoticeflag", "sendthanksletterflag"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"sendnoticeflag", "sendthanksletterflag"});
        }
        this.setRoundsVisible();
    }

    protected void setRoundsVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bidproject = dataEntity.getDynamicObject("bidproject");
        long id = bidproject.getLong("id");
        String tenappid = this.getModel().getDataEntityType().getAppId().equals("bid") ? "ten" : "resp";
        boolean flag = QueryServiceHelper.exists((String)(tenappid + "_online_bid_detail"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)id)});
        if (!flag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bussrounds", "techrounds"});
        }
    }

    protected void setSectionVisible() {
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        if (splitContainer == null) {
            return;
        }
        EntryGrid enGrid = (EntryGrid)this.getControl("bottomsection");
        enGrid.selectRows(0, true);
        splitContainer.hidePanel(SplitDirection.left, true);
    }

    private void setScoreByDecideWay() {
        DynamicObject decide = (DynamicObject)this.getModel().getValue("evaluatedecideway");
        if (decide != null) {
            String evaname = decide.getString("name");
            Long typeId = decide.getLong("id");
            if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"score"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"score"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"score"});
        }
    }

    public void cellClick(CellClickEvent paramCellClickEvent) {
        String field = paramCellClickEvent.getFieldKey();
        int index = paramCellClickEvent.getRow();
        if (index == -1) {
            return;
        }
        if ("commentdetail".equals(field)) {
            OperationStatus status;
            Long id = (Long)this.getModel().getValue("id");
            DynamicObject bidProjectf7 = (DynamicObject)this.getModel().getValue("bidproject");
            DynamicObject bidProject = this.projectService.getBidProjectAllById(Long.valueOf(bidProjectf7.getLong("id")));
            boolean isMaterialpur = bidProject.getBoolean("ismaterialpur");
            boolean isratebidding = bidProject.getBoolean("isratebidding");
            int bidType = bidProject.getInt("bidtype");
            Long bidprojectid = bidProject.getLong("id");
            EntryGrid grid = (EntryGrid)paramCellClickEvent.getSource();
            IDataModel operate = grid.getModel();
            int row = paramCellClickEvent.getRow();
            DynamicObject supplierEntry = operate.getEntryRowEntity(grid.getKey(), row);
            String supplierid = "";
            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
            supplierid = supplier.getString("id");
            EntryGrid sectionGrid = (EntryGrid)this.getView().getControl("bidsection");
            IDataModel sectionOperate = sectionGrid.getModel();
            String sectionId = "";
            int sectionRow = sectionOperate.getEntryCurrentRowIndex("bidsection");
            DynamicObject sectionEntry = sectionOperate.getEntryRowEntity("bidsection", sectionRow);
            sectionId = sectionEntry.getString("id");
            String sectionName = sectionEntry.getString("sectionname");
            FormShowParameter para = new FormShowParameter();
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            para.setCustomParam("id", this.getModel().getDataEntity().getPkValue());
            String billStatus = (String)this.getModel().getValue(BILL_STATUS);
            if ("A".equals(billStatus) || "D".equals(billStatus)) {
                status = OperationStatus.EDIT;
                para.setStatus(status);
            } else {
                status = OperationStatus.VIEW;
                para.setStatus(status);
            }
            para.setFormId(FormTypeConstants.getFormConstant((String)"decision_purdetail", ((Object)((Object)this)).getClass()));
            para.setCustomParam("entryCurrentRowIndex", (Object)this.getModel().getEntryCurrentRowIndex("bidsection"));
            para.setCustomParam("supplierid", (Object)supplierid);
            para.setCustomParam("sectionId", (Object)sectionId);
            para.setCustomParam("isMaterialpur", (Object)isMaterialpur);
            para.setCustomParam("isratebidding", (Object)isratebidding);
            para.setCustomParam("bidType", (Object)bidType);
            para.setCustomParam("bidDecisionModelPK", this.getModel().getDataEntity().getPkValue());
            para.setCustomParam("id", (Object)id);
            para.setCustomParam("amountMap", this.getBotControlAmountMap(sectionEntry, supplierid));
            para.setCustomParam("sectionName", (Object)sectionName);
            para.setCustomParam("bidprojectid", (Object)bidprojectid);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, FormTypeConstants.getFormConstant((String)"decision_purdetail", ((Object)((Object)this)).getClass()));
            para.setCloseCallBack(callBack);
            this.getView().showForm(para);
        } else if ("operationcolumnap".equals(field)) {
            this.fileDownLoad(paramCellClickEvent);
        }
    }

    public void fileDownLoad(CellClickEvent arg0) {
        EntryGrid sectionGrid = (EntryGrid)this.getView().getControl("bidsection");
        IDataModel sectionOperate = sectionGrid.getModel();
        int sectionRow = sectionOperate.getEntryCurrentRowIndex("bidsection");
        DynamicObject sectionEntry = sectionOperate.getEntryRowEntity("bidsection", sectionRow);
        String sectionId = "";
        String sectionName = "";
        if (sectionEntry != null) {
            sectionId = sectionEntry.getString("id");
            sectionName = sectionEntry.getString("sectionname");
        }
        EntryGrid grid = (EntryGrid)arg0.getSource();
        IDataModel operate = grid.getModel();
        int row = arg0.getRow();
        DynamicObject supplierEntry = operate.getEntryRowEntity(grid.getKey(), row);
        String supplierId = "";
        String supplierName = "";
        if (supplierEntry != null) {
            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
            supplierId = supplier.getString("id");
            supplierName = supplier.getString("name");
            if (sectionId.equals("") || supplierId.equals("")) {
                return;
            }
            ArrayList attachmentIds = new ArrayList();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject bidproject = dataEntity.getDynamicObject("bidproject");
            Object bidprojectId = bidproject.getPkValue();
            String docType = bidproject.getString("doctype");
            String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
            BidFileHelper.getFileUrl((DynamicObject)supplierEntry, (String)docType, attachmentIds, (String)(serviceAppId + "_decision"), (Object)bidprojectId);
            String fielZipName = this.getFileZipName(bidprojectId, sectionName, supplierName, serviceAppId + "_decision", dataEntity.getPkValue(), serviceAppId);
            if (attachmentIds.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u6587\u4ef6\u3002", (String)"BidDecisionEditUI_52", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().download(BidFileHelper.downloadByAttachmentIds((String)fielZipName, attachmentIds));
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2a\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\u3002", (String)"BidDecisionEditUI_53", (String)"scm-bid-formplugin", (Object[])new Object[0]), attachmentIds.size()));
            }
        }
    }

    public String getFileZipName(Object bidprojectId, String sectionName, String supplierName, String formBillno, Object formId, String appid) {
        return BidFileHelper.getFileZipName((Object)bidprojectId, (String)sectionName, (String)supplierName, (String)formBillno, (Object)formId, (String)appid);
    }

    protected Map<String, BigDecimal> getSectionTotalBotAmountMap() {
        HashMap<String, BigDecimal> botSectionTotalAmountMap = new HashMap<String, BigDecimal>(16);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection bottomSectionCol = dataEntity.getDynamicObjectCollection("bottomsection");
        if (bottomSectionCol != null && bottomSectionCol.size() > 0) {
            for (DynamicObject bottomSection : bottomSectionCol) {
                String sectionName = bottomSection.getString("botsectionname");
                DynamicObjectCollection bottomEntryCol = bottomSection.getDynamicObjectCollection("bottomentry");
                BigDecimal sectionTotalBotControlAmount = BigDecimal.ZERO;
                BigDecimal sectionTotalFinalAuditAmount = BigDecimal.ZERO;
                for (DynamicObject bottomEntry : bottomEntryCol) {
                    sectionTotalBotControlAmount = sectionTotalBotControlAmount.add(bottomEntry.getBigDecimal("botcontrolamount"));
                    sectionTotalFinalAuditAmount = sectionTotalFinalAuditAmount.add(bottomEntry.getBigDecimal("finalauditamount"));
                }
                String totalControlKey = String.format("%s%s", sectionName, "totalControl");
                String totalFinalKey = String.format("%s%s", sectionName, "totalFinal");
                if (sectionTotalBotControlAmount.compareTo(BigDecimal.ZERO) > 0) {
                    botSectionTotalAmountMap.put(totalControlKey, sectionTotalBotControlAmount);
                }
                if (sectionTotalFinalAuditAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                botSectionTotalAmountMap.put(totalFinalKey, sectionTotalFinalAuditAmount);
            }
        }
        return botSectionTotalAmountMap;
    }

    protected Map<String, Map<String, BigDecimal>> getBotControlAmountMap(DynamicObject sectionEntry, String supplierId) {
        HashMap<String, Map<String, BigDecimal>> map = new HashMap<String, Map<String, BigDecimal>>(16);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String appId = this.getModel().getDataEntityType().getAppId();
        String sectionId = sectionEntry.getString("id");
        String sectionName = sectionEntry.getString("sectionname");
        DynamicObjectCollection bottomsection = dataEntity.getDynamicObjectCollection("bottomsection");
        if (bottomsection.size() > 0) {
            for (DynamicObject section : bottomsection) {
                String sectionname = section.getString("botsectionname");
                if (!sectionName.equals(sectionname)) continue;
                DynamicObjectCollection bottomentry = section.getDynamicObjectCollection("bottomentry");
                for (DynamicObject entry : bottomentry) {
                    Map<String, BigDecimal> finalMap;
                    Map<String, BigDecimal> controlMap;
                    DynamicObject botResourceItem;
                    String botPurEntryContent = null;
                    if (StringUtils.isNotBlank((CharSequence)entry.getString("botpurentrycontent"))) {
                        botPurEntryContent = entry.getString("botpurentrycontent");
                    }
                    BigDecimal botControlAmount = entry.getBigDecimal("botcontrolamount");
                    BigDecimal finalAuditAmount = entry.getBigDecimal("finalauditamount");
                    DynamicObject purProject = entry.getDynamicObject("botpurentryproject");
                    String projectId = null;
                    if (purProject != null) {
                        projectId = purProject.getString("id");
                    }
                    String materialId = null;
                    DynamicObject botMaterialId = entry.getDynamicObject("botmaterialid");
                    if (botMaterialId != null) {
                        materialId = botMaterialId.getString("id");
                    }
                    String resourceItemId = null;
                    if ("rebm".equals(appId) && (botResourceItem = entry.getDynamicObject("botresourceitem")) != null) {
                        resourceItemId = botResourceItem.getString("id");
                    }
                    String botMaterialdes = null;
                    if (StringUtils.isNotBlank((CharSequence)entry.getString("botmaterialdes"))) {
                        botMaterialdes = entry.getString("botmaterialdes");
                    }
                    if (botControlAmount.compareTo(BigDecimal.ZERO) == 0) {
                        botControlAmount = null;
                    }
                    if (finalAuditAmount.compareTo(BigDecimal.ZERO) == 0) {
                        finalAuditAmount = null;
                    }
                    String key = String.format("%s%s%s%s%s%s%s", sectionId, supplierId, botPurEntryContent, projectId, materialId, resourceItemId, botMaterialdes);
                    if (map.get("controlamount") == null) {
                        controlMap = new HashMap(16);
                        controlMap.put(key, botControlAmount);
                        map.put("controlamount", controlMap);
                    } else {
                        controlMap = (Map)map.get("controlamount");
                        controlMap.put(key, botControlAmount);
                    }
                    if (map.get("finalauditamount") == null) {
                        finalMap = new HashMap(16);
                        finalMap.put(key, finalAuditAmount);
                        map.put("finalauditamount", finalMap);
                        continue;
                    }
                    finalMap = (Map)map.get("finalauditamount");
                    finalMap.put(key, finalAuditAmount);
                }
            }
        }
        return map;
    }

    public void cellDoubleClick(CellClickEvent paramCellClickEvent) {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnmap;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)FormTypeConstants.getFormConstant((String)"annosection", ((Object)((Object)this)).getClass())) && (returnmap = (Map)closedCallBackEvent.getReturnData()) != null) {
            FormShowParameter parameter = (FormShowParameter)returnmap.get("parameter");
            int nowChose = (Integer)returnmap.get("nowChose");
            int realChonse = (Integer)returnmap.get("realChonse");
            Object sectionid = returnmap.get("sectionid");
            Object operType = parameter.getCustomParam("operType");
            Object pkid = parameter.getCustomParam("pkid");
            Long mainOrgId = Long.valueOf(parameter.getCustomParam("mainOrgId").toString());
            if (operType != null && operType.equals("opendecianno")) {
                Object id = parameter.getCustomParam("id");
                List sectionList = (List)parameter.getCustomParam("sectionList");
                ArrayList choseSection = new ArrayList();
                choseSection.add(sectionList.get(nowChose));
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"decisionannouncement", ((Object)((Object)this)).getClass()));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("sectionCount", (Object)realChonse);
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.setCustomParam("dbid", id);
                showParameter.setCustomParam("pkid", pkid);
                showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                showParameter.setCustomParam("parentType", (Object)"decision");
                showParameter.setCustomParam("sectionList", choseSection);
                showParameter.setCaption(ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a", (String)"BidDecisionEditUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)showParameter);
            } else if (operType != null && operType.equals("checkdecianno")) {
                Map map = this.annocumentService.getAnnouncementPKIdMap(pkid, (Object)"decision", sectionid);
                if (map != null) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId(FormTypeConstants.getFormConstant((String)"announcement_preview", ((Object)((Object)this)).getClass()));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.setCustomParam("annomap", (Object)map);
                    showParameter.setCustomParam("attachformid", (Object)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()));
                    if (parameter.getCustomParam("purtype") != null) {
                        showParameter.setCustomParam("purtype", parameter.getCustomParam("purtype"));
                    }
                    this.getView().showForm(showParameter);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u7f16\u5236\u4e2d\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidDecisionEditUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
            } else if (operType != null && operType.equals("revokedescanno")) {
                String billStatus = this.annocumentService.getBillStatus(pkid, (Object)"decision", sectionid);
                if (billStatus != null) {
                    if (billStatus.equals(BillStatusEnum.SAVE.getVal())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u4e2d\u6807\u516c\u544a\uff0c\u65e0\u9700\u64a4\u9500\u3002", (String)"BidDecisionEditUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                    if (billStatus.equals(BillStatusEnum.RELEASED.getVal())) {
                        this.annocumentService.changeAnnoStatusToA(pkid, (Object)"decision", sectionid);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u4e2d\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidDecisionEditUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u4e2d\u6807\u516c\u544a\uff0c\u65e0\u9700\u64a4\u9500\u3002", (String)"BidDecisionEditUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
            }
        }
        if (returnData != null && KEY_ATTACHMENT.equals(actionId)) {
            Map map = (Map)returnData;
            String clickFieldName = (String)map.get("type");
            Integer size = (Integer)map.get("size");
            Integer rowIndex = (Integer)map.get("rowIndex");
            this.getModel().setValue(clickFieldName, (Object)size, rowIndex.intValue());
        } else if ("sign".equals(actionId)) {
            Object rd = closedCallBackEvent.getReturnData();
            if (rd != null && "signSuccess".equals(rd)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u7ea6\u6210\u529f\u3002", (String)"BidDecisionEditUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                Object id = this.getModel().getDataEntity().getPkValue();
                DynamicObject decision = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
                DynamicObjectCollection decisionSectionCol = decision.getDynamicObjectCollection("bidsection");
                HashMap<Object, String> signDetail4Section = new HashMap<Object, String>(16);
                for (DynamicObject decisionSection : decisionSectionCol) {
                    signDetail4Section.put(decisionSection.getPkValue(), decisionSection.getString("signstatus"));
                }
                DynamicObjectCollection doc = this.getModel().getEntryEntity("bidsection");
                for (int i = 0; i < doc.size(); ++i) {
                    String signStatus;
                    DynamicObject section = (DynamicObject)doc.get(i);
                    Object id4Section = section.getPkValue();
                    if (id4Section == null || (signStatus = (String)signDetail4Section.get(id4Section)) == null) continue;
                    this.getModel().setValue("signstatus", (Object)signStatus, i);
                }
            }
        } else if (FormTypeConstants.getFormConstant((String)"selectsection", ((Object)((Object)this)).getClass()).equals(actionId)) {
            Object bidDecisionId = this.getModel().getDataEntity().getPkValue();
            Map returnDataMap = (Map)returnData;
            if (returnDataMap == null) {
                return;
            }
            Object noticeOrLetter = returnDataMap.get("noticeOrLetter");
            Object sectionId = returnDataMap.get("sectionId");
            DynamicObject bidDecision = this.service.getBidDecisionSingle((Long)bidDecisionId);
            BillShowParameter showParameter = new BillShowParameter();
            String sectionName = "";
            if ("notice".equals(noticeOrLetter.toString())) {
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()));
                DynamicObject bidProject = (DynamicObject)bidDecision.get("bidproject");
                Object noticeId = null;
                boolean issendwinnotice = false;
                DynamicObjectCollection bidSectionDynamicObjectCollection = (DynamicObjectCollection)bidDecision.get("bidsection");
                for (DynamicObject sectionItem : bidSectionDynamicObjectCollection) {
                    if (!sectionId.toString().equals(sectionItem.get("id").toString())) continue;
                    issendwinnotice = (Boolean)sectionItem.get("issendwinnotice");
                    sectionName = sectionItem.getString("sectionname");
                }
                if (issendwinnotice) {
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u4e2d\u6807\u901a\u77e5\u4e66", (String)"BidDecisionEditUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    showParameter.setStatus(OperationStatus.EDIT);
                    showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u4e66", (String)"BidDecisionEditUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                if (bidProject != null) {
                    QFilter projectFilter = new QFilter("bidproject.id", "=", (Object)bidProject.getLong("id"));
                    Iterator decisitionSectionFilter = new QFilter("decisionsectionid", "=", (Object)Long.parseLong(sectionId.toString()));
                    DynamicObject winnotice = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{projectFilter, decisitionSectionFilter});
                    if (winnotice != null) {
                        noticeId = winnotice.get("id");
                    }
                }
                showParameter.setPkId(noticeId);
            } else if ("letter".equals(noticeOrLetter.toString())) {
                List<DynamicObject> listSuppliers = DynamicTabHelper.listUnRecommendedSuppliers(sectionId, bidDecision);
                if (listSuppliers == null || listSuppliers.size() <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u4e0b\u7684\u4f9b\u5e94\u5546\u5747\u5df2\u4e2d\u6807\uff0c\u4e0d\u9700\u8981\u53d1\u9001\u611f\u8c22\u4fe1\u3002", (String)"BidDecisionEditUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"thanksletter", ((Object)((Object)this)).getClass()));
                DynamicObject bidProject = (DynamicObject)bidDecision.get("bidproject");
                Object letterId = null;
                boolean issendthanksletter = false;
                DynamicObjectCollection bidSectionDynamicObjectCollection = (DynamicObjectCollection)bidDecision.get("bidsection");
                for (DynamicObject sectionItem : bidSectionDynamicObjectCollection) {
                    if (!sectionId.toString().equals(sectionItem.get("id").toString())) continue;
                    issendthanksletter = (Boolean)sectionItem.get("issendthanksletter");
                    sectionName = sectionItem.getString("sectionname");
                }
                if (issendthanksletter) {
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u611f\u8c22\u4fe1", (String)"BidDecisionEditUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    showParameter.setStatus(OperationStatus.EDIT);
                    showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u9001\u611f\u8c22\u4fe1", (String)"BidDecisionEditUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                if (bidProject != null) {
                    QFilter projectFilter = new QFilter("bidproject.id", "=", (Object)bidProject.getLong("id"));
                    QFilter decisitionSectionFilter = new QFilter("decisionsectionid", "=", (Object)Long.parseLong(sectionId.toString()));
                    DynamicObject thanksletter = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"thanksletter", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{projectFilter, decisitionSectionFilter});
                    if (thanksletter != null) {
                        letterId = thanksletter.get("id");
                    }
                }
                showParameter.setPkId(letterId);
            }
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("sectionId", sectionId);
            showParameter.setCustomParam("bidDecisionId", bidDecisionId);
            showParameter.setCustomParam("sectionName", (Object)sectionName);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (FormTypeConstants.getFormConstant((String)"decision_purdetail", ((Object)((Object)this)).getClass()).equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            DynamicObject parentPurEntry;
            String presourceitem;
            String pmaterialdes;
            String pmaterialid;
            String ppurentryprojectid;
            String ppurentrycontent;
            String parentSupplierid;
            int i;
            Object[] resultObject = (Object[])closedCallBackEvent.getReturnData();
            HashMap resultMap = (HashMap)resultObject[0];
            int entryCurrentRowIndex = (Integer)resultMap.get("entryCurrentRowIndex");
            String supplierid = (String)resultMap.get("supplierid");
            ArrayList resultList = (ArrayList)resultMap.get("resultList");
            Map finalResultMap = (Map)resultMap.get("finalResultList");
            IDataModel model = this.getModel();
            model.setEntryCurrentRowIndex("bidsection", entryCurrentRowIndex);
            DynamicObject currencySection = model.getEntryRowEntity("bidsection", entryCurrentRowIndex);
            DynamicObjectCollection parentFinalPurDetails = currencySection.getDynamicObjectCollection("supfinaldetail");
            DynamicObjectCollection parentBackPurDetails = currencySection.getDynamicObjectCollection("supbackdetail");
            DynamicObjectCollection parentPurEntrys = currencySection.getDynamicObjectCollection("supplierentry");
            BigDecimal tenderprice = new BigDecimal(0);
            BigDecimal taxrate = new BigDecimal(0);
            BigDecimal pricevat = new BigDecimal(0);
            BigDecimal exceptvat = new BigDecimal(0);
            BigDecimal supplierRateSum = new BigDecimal(0);
            BigDecimal supplierRateCount = new BigDecimal(0);
            BigDecimal ltenderprice = new BigDecimal(0);
            BigDecimal ltaxrate = new BigDecimal(0);
            BigDecimal lpricevat = new BigDecimal(0);
            BigDecimal lexceptvat = new BigDecimal(0);
            BigDecimal lsupplierRateSum = new BigDecimal(0);
            BigDecimal lsupplierRateCount = new BigDecimal(0);
            String appId = this.getModel().getDataEntityType().getAppId();
            HashSet<BigDecimal> taxSet = new HashSet<BigDecimal>();
            int l = parentBackPurDetails.size();
            for (i = 0; i < l; ++i) {
                DynamicObject parentBackPurDetail = (DynamicObject)parentBackPurDetails.get(i);
                parentSupplierid = parentBackPurDetail.getDynamicObject("pursupplier").getString("id");
                ppurentrycontent = parentBackPurDetail.getString("purentrycontent") == null ? "" : parentBackPurDetail.getString("purentrycontent");
                ppurentryprojectid = parentBackPurDetail.getDynamicObject("purentryproject") == null ? "" : parentBackPurDetail.getDynamicObject("purentryproject").getString("id");
                pmaterialid = parentBackPurDetail.getDynamicObject("materialid") == null ? "" : parentBackPurDetail.getDynamicObject("materialid").getString("id");
                pmaterialdes = parentBackPurDetail.getString("materialdes") == null ? "" : parentBackPurDetail.getString("materialdes");
                presourceitem = "";
                if ("rebm".equals(appId)) {
                    String string = presourceitem = parentBackPurDetail.getDynamicObject("resourceitem") == null ? "" : parentBackPurDetail.getDynamicObject("resourceitem").getString("id");
                }
                if (!StringUtils.equals((CharSequence)supplierid, (CharSequence)parentSupplierid)) continue;
                int ll = resultList.size();
                for (int ii = 0; ii < ll; ++ii) {
                    String resourceitem;
                    Map resultDetailMap = (Map)resultList.get(ii);
                    String purentrycontent = (String)resultDetailMap.get("purentrycontent");
                    String purentryprojectid = (String)resultDetailMap.get("purentryprojectid");
                    String materialid = (String)resultDetailMap.get("materialid");
                    String materialdes = (String)resultDetailMap.get("materialdes");
                    String string = resourceitem = resultDetailMap.get("resourceitem") == null ? "" : resultDetailMap.get("resourceitem").toString();
                    if (!StringUtils.equals((CharSequence)ppurentrycontent, (CharSequence)purentrycontent) || !StringUtils.equals((CharSequence)ppurentryprojectid, (CharSequence)purentryprojectid) || !StringUtils.equals((CharSequence)pmaterialid, (CharSequence)materialid) || !StringUtils.equals((CharSequence)pmaterialdes, (CharSequence)materialdes) || !StringUtils.equals((CharSequence)presourceitem, (CharSequence)resourceitem)) continue;
                    model.setValue("inclutaxprice", resultDetailMap.get("inclutaxprice"), i);
                    model.setValue("inclutaxamount", resultDetailMap.get("inclutaxamount"), i);
                    model.setValue("bd_taxrate", resultDetailMap.get("bd_taxrate"), i);
                    model.setValue("taxrate", resultDetailMap.get("taxrate"), i);
                    model.setValue("taxamount", resultDetailMap.get("taxamount"), i);
                    model.setValue("excepttaxamount", resultDetailMap.get("excepttaxamount"), i);
                    model.setValue("qty", resultDetailMap.get("qty"), i);
                    model.setValue("costrate", resultDetailMap.get("costrate"), i);
                    tenderprice = tenderprice.add(new BigDecimal(resultDetailMap.get("inclutaxamount") + ""));
                    pricevat = pricevat.add(new BigDecimal(resultDetailMap.get("taxamount") + ""));
                    exceptvat = exceptvat.add(new BigDecimal(resultDetailMap.get("excepttaxamount") + ""));
                    supplierRateSum = supplierRateSum.add(new BigDecimal(resultDetailMap.get("costrate") + ""));
                    supplierRateCount = supplierRateCount.add(new BigDecimal(1));
                    taxSet.add((BigDecimal)resultDetailMap.get("taxrate"));
                }
            }
            if (parentPurEntrys != null && parentPurEntrys.size() > 0) {
                l = parentPurEntrys.size();
                for (i = 0; i < l; ++i) {
                    parentPurEntry = (DynamicObject)parentPurEntrys.get(i);
                    if (!StringUtils.equals((CharSequence)supplierid, (CharSequence)parentPurEntry.getDynamicObject("supplier").getString("id"))) continue;
                    if (resultList.size() == 1 || taxSet.size() == 1) {
                        Map resultDetailMap = (Map)resultList.get(0);
                        model.setValue("tendertaxrate", resultDetailMap.get("taxrate"), i);
                    } else if (exceptvat.compareTo(new BigDecimal(0)) != 0) {
                        taxrate = pricevat.divide(exceptvat, 4, 4);
                        model.setValue("tendertaxrate", (Object)taxrate.multiply(new BigDecimal("100")), i);
                    }
                    model.setValue("tendervat", (Object)pricevat, i);
                    model.setValue("tenderexceptvat", (Object)exceptvat, i);
                    model.setValue("tenderprice", (Object)tenderprice, i);
                    model.setValue("rate", (Object)supplierRateSum, i);
                }
            }
            taxSet.clear();
            l = parentFinalPurDetails.size();
            for (i = 0; i < l; ++i) {
                DynamicObject parentFinalPurDetail = (DynamicObject)parentFinalPurDetails.get(i);
                parentSupplierid = parentFinalPurDetail.getDynamicObject("lpursupplier").getString("id");
                ppurentrycontent = parentFinalPurDetail.getString("lpurentrycontent") == null ? "" : parentFinalPurDetail.getString("lpurentrycontent");
                ppurentryprojectid = parentFinalPurDetail.getDynamicObject("lpurentryproject") == null ? "" : parentFinalPurDetail.getDynamicObject("lpurentryproject").getString("id");
                pmaterialid = parentFinalPurDetail.getDynamicObject("lmaterialid") == null ? "" : parentFinalPurDetail.getDynamicObject("lmaterialid").getString("id");
                pmaterialdes = parentFinalPurDetail.getString("lmaterialdes") == null ? "" : parentFinalPurDetail.getString("lmaterialdes");
                presourceitem = "";
                if ("rebm".equals(appId)) {
                    presourceitem = parentFinalPurDetail.getDynamicObject("lresourceitem") == null ? "" : parentFinalPurDetail.getDynamicObject("lresourceitem").getString("id");
                }
                String key = parentSupplierid + ppurentrycontent + ppurentryprojectid + pmaterialid + pmaterialdes + presourceitem;
                if (!StringUtils.equals((CharSequence)supplierid, (CharSequence)parentSupplierid)) continue;
                Map dataMap = (Map)finalResultMap.get(key);
                if (dataMap == null) {
                    parentFinalPurDetail.set("isdelinsonpage", (Object)Boolean.TRUE);
                    continue;
                }
                model.setValue("linclutaxprice", dataMap.get("linclutaxprice"), i);
                model.setValue("linclutaxamount", dataMap.get("linclutaxamount"), i);
                model.setValue("lbd_taxrate", dataMap.get("lbd_taxrate"), i);
                model.setValue("ltaxrate", dataMap.get("ltaxrate"), i);
                model.setValue("ltaxamount", dataMap.get("ltaxamount"), i);
                model.setValue("lqty", dataMap.get("lqty"), i);
                model.setValue("lexcepttaxamount", dataMap.get("lexcepttaxamount"), i);
                model.setValue("lcostrate", dataMap.get("lcostrate"), i);
                ltenderprice = ltenderprice.add(new BigDecimal(dataMap.get("linclutaxamount") + ""));
                lpricevat = lpricevat.add(new BigDecimal(dataMap.get("ltaxamount") + ""));
                lexceptvat = lexceptvat.add(new BigDecimal(dataMap.get("lexcepttaxamount") + ""));
                lsupplierRateSum = lsupplierRateSum.add(new BigDecimal(dataMap.get("lcostrate") + ""));
                lsupplierRateCount = lsupplierRateCount.add(new BigDecimal(1));
                taxSet.add(new BigDecimal(dataMap.get("ltaxrate") + ""));
            }
            parentPurEntrys = this.getModel().getEntryRowEntity("bidsection", entryCurrentRowIndex).getDynamicObjectCollection("supplierentry");
            if (parentPurEntrys != null && parentPurEntrys.size() > 0) {
                l = parentPurEntrys.size();
                for (i = 0; i < l; ++i) {
                    parentPurEntry = (DynamicObject)parentPurEntrys.get(i);
                    if (!StringUtils.equals((CharSequence)supplierid, (CharSequence)parentPurEntry.getDynamicObject("supplier").getString("id"))) continue;
                    ltaxrate = taxSet.size() != 1 ? (lexceptvat.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : lpricevat.divide(lexceptvat, 4, 4)) : ((BigDecimal)taxSet.iterator().next()).divide(new BigDecimal("100"));
                    parentPurEntry.set("finaltaxrate", (Object)ltaxrate.multiply(new BigDecimal("100")));
                    parentPurEntry.set("finalvat", (Object)lpricevat);
                    parentPurEntry.set("finalexceptvat", (Object)lexceptvat);
                    parentPurEntry.set("finalprice", (Object)ltenderprice);
                    parentPurEntry.set("finalrate", (Object)lsupplierRateSum);
                    this.getView().updateView("supplierentry");
                    DynamicObject evaluatedecideway = model.getDataEntity(true).getDynamicObject("evaluatedecideway");
                    String evaname = evaluatedecideway.getString("name");
                    Long typeId = evaluatedecideway.getLong("id");
                    if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                        this.rangeSupplierEntry();
                    } else {
                        this.rangeSupplierEntryByScore();
                    }
                    this.sumAmount();
                    return;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        CloseCallBack closeCallBack;
        FormShowParameter showParameter;
        DynamicObject data;
        boolean hasPermission;
        boolean exsitInval;
        QFilter myFilter;
        DynamicObject exitDecision;
        super.beforeDoOperation(beforeDoOperationEventArgs);
        Lang lang = RequestContext.get().getLang();
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        operate.getOption().setVariableValue("form", "edit");
        String operateKey = operate.getOperateKey();
        Object bidDecisionId = this.getModel().getDataEntity().getPkValue();
        if ("alldownfile".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
            DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
            String billno = bidProject.getString("billno");
            String fileName = String.format(ResManager.loadKDString((String)"%s\u5b9a\u6807\u9644\u4ef6", (String)"BidDecisionEditUI_54", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno);
            String docType = bidProject.getString("doctype");
            this.getView().download(BidFileHelper.downAllFile((String)fileName, (Object)dataEntity.getPkValue(), (String)(serviceAppId + "_decision"), (String)serviceAppId, (String)docType));
        }
        if (null == (exitDecision = QueryServiceHelper.queryOne((String)"bid_decision", (String)"id", (QFilter[])new QFilter[]{myFilter = new QFilter("id", "=", bidDecisionId)}))) {
            beforeDoOperationEventArgs.setCancel(true);
            if ("close".equals(operateKey)) {
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"BidDecisionEditUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().setDataChanged(false);
            }
            return;
        }
        DynamicObject bidDecision = BusinessDataServiceHelper.loadSingle((Object)bidDecisionId, (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        DynamicObject bidProject = bidDecision.getDynamicObject("bidproject");
        DynamicObject org = bidDecision.getDynamicObject("org");
        Long orgId = (Long)org.getPkValue();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        if ((StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"submit") || StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"save")) && (exsitInval = SupplierInvalUtil.checkExsitUnAuditSuppleirInvalBill(bidProject, this.getBillId().split("_")[0]))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u4f9b\u5e94\u5546\u6dd8\u6c70\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidDecisionEditUI_56", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            beforeDoOperationEventArgs.setCancel(true);
            return;
        }
        if ("save".equals(operateKey)) {
            List<String> confirmTips;
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm) && (confirmTips = this.checkPurEntryData()) != null && confirmTips.size() > 0) {
                String[] tips = confirmTips.toArray(new String[0]);
                beforeDoOperationEventArgs.setCancel(true);
                StringBuilder s = new StringBuilder();
                if (confirmTips.size() == 1) {
                    s.append(tips[0]);
                } else {
                    int i = 0;
                    for (String confirmTip : confirmTips) {
                        String value = ++i + "\u3001" + confirmTip + "\r\n";
                        s.append(value);
                    }
                }
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
                this.getView().showConfirm(null, s.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
            }
            operate.getOption().setVariableValue(OPPARAM_AFTERCONFIRM, "true");
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"releasedescacco")) {
            hasPermission = PermissionHepler.checkPermission("QXX0117", orgId, appId, FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53d1\u5e03\u4e2d\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidDecisionEditUI_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"checkdescacco")) {
            hasPermission = PermissionHepler.checkPermission("QXX0118", orgId, appId, FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u770b\u4e2d\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidDecisionEditUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"revokedescacco") && !(hasPermission = PermissionHepler.checkPermission("QXX0119", orgId, appId, FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass())))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64a4\u9500\u4e2d\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidDecisionEditUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            beforeDoOperationEventArgs.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"viewbidevaluationmsg")) {
            BillShowParameter showParameter2 = new BillShowParameter();
            showParameter2.setFormId(FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()));
            DynamicObject project = (DynamicObject)this.getModel().getValue("bidproject");
            if (project != null) {
                DynamicObject[] bidEvaluations = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)"id,auditdate", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", project.getPkValue()), new QFilter(BILL_STATUS, "=", (Object)"C")}, (String)"auditdate desc");
                if (bidEvaluations != null && bidEvaluations.length > 0) {
                    showParameter2.setPkId(bidEvaluations[0].getPkValue());
                    showParameter2.setStatus(OperationStatus.VIEW);
                    showParameter2.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter2.setCustomParam("viewSource", (Object)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
                    this.getView().showForm((FormShowParameter)showParameter2);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\u8bc4\u6807\u4fe1\u606f\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"BidDecisionEditUI_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\u8bc4\u6807\u4fe1\u606f\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"BidDecisionEditUI_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            beforeDoOperationEventArgs.setCancel(true);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"audit")) {
            Long id = (Long)this.getModel().getValue("id");
            data = this.service.getBidDecisionSingle(id);
            String status = data.getString(BILL_STATUS);
            if (!StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.AUDITING.getVal()) && !StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.SUBMIT.getVal())) {
                beforeDoOperationEventArgs.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit")) {
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            Object pkid = this.annocumentService.getProjectPKId(pkValue);
            Map pidAndSecColMap = this.annocumentService.getPidAndSecCol(pkValue);
            if (pidAndSecColMap != null) {
                List sectionList = (List)pidAndSecColMap.get("sectionList");
                for (int i = 0; i < sectionList.size(); ++i) {
                    String billStatus = this.annocumentService.getBillStatus(pkid, (Object)"decision", ((Map)sectionList.get(i)).get("sectionPkid"));
                    if (billStatus == null || !billStatus.equals(BillStatusEnum.RELEASED.getVal())) continue;
                    beforeDoOperationEventArgs.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u5df2\u53d1\u5e03\u4e2d\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDecisionEditUI_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            Object bidProjectId = this.service.getBidProjectId((Object)Long.parseLong(pkValue.toString()));
            Long projectId = Long.parseLong(bidProjectId.toString());
            DynamicObject winNotice = this.winNoticeService.getWinNoticeByProjectId(projectId, "id");
            DynamicObject thanksLetter = this.thanksLetterService.getThanksLetterByProjectId(projectId, "id");
            if (winNotice != null && thanksLetter != null) {
                beforeDoOperationEventArgs.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u4e66\u548c\u611f\u8c22\u4fe1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDecisionEditUI_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            if (winNotice != null) {
                beforeDoOperationEventArgs.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u4e66\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDecisionEditUI_21", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            if (thanksLetter != null) {
                beforeDoOperationEventArgs.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u611f\u8c22\u4fe1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDecisionEditUI_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            this.winNoticeService.deleteWinNoticeByProjectId(projectId);
            this.thanksLetterService.deleteThanksLetterByProjectId(projectId);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection bidSectionCollection = dataEntity.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSectionCollection.size(); ++i) {
                DynamicObjectCollection supplierCollection = ((DynamicObject)bidSectionCollection.get(i)).getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplier : supplierCollection) {
                    if (!Lang.zh_CN.equals((Object)lang)) {
                        if (!Lang.zh_TW.equals((Object)lang)) {
                            supplier.set("commentdetail", (Object)"Edit");
                            continue;
                        }
                    }
                    supplier.set("commentdetail", (Object)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"BidDecisionEditUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
            }
            this.getView().updateView("supplierentry");
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"winnotice")) {
            Long id = (Long)this.getModel().getValue("id");
            data = this.service.getBidDecisionSingle(id);
            if (!(BillStatusEnum.AUDITED.getVal().equals(data.getString(BILL_STATUS)) || "S".equals(data.getString(BILL_STATUS)) || "R".equals(data.getString(BILL_STATUS)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u7684\u6570\u636e\u53d1\u5e03\u4e2d\u6807\u901a\u77e5\u4e66\u3002", (String)"BidDecisionEditUI_23", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            DynamicObjectCollection sectionColl = (DynamicObjectCollection)bidDecision.get("bidsection");
            int count = this.getModel().getEntryRowCount("bidsection");
            if (count > 1) {
                showParameter = new FormShowParameter();
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"selectsectionlist", ((Object)((Object)this)).getClass()));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCustomParam("sectionCollection", (Object)sectionColl);
                showParameter.setCustomParam("bidDecisionId", bidDecisionId);
                showParameter.setCustomParam("noticeOrLetter", (Object)"notice");
                closeCallBack = new CloseCallBack((IFormPlugin)this, FormTypeConstants.getFormConstant((String)"selectsection", ((Object)((Object)this)).getClass()));
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            } else {
                showParameter = new BillShowParameter();
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                DynamicObject sectionDynamicObject = (DynamicObject)sectionColl.get(0);
                showParameter.setCustomParam("sectionId", sectionDynamicObject.get("id"));
                showParameter.setCustomParam("bidDecisionId", bidDecisionId);
                showParameter.setCustomParam("sectionName", (Object)ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"BidDecisionEditUI_29", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                Object noticeId = null;
                if (bidProject != null) {
                    QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProject.getLong("id"));
                    DynamicObject winnotice = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (winnotice != null) {
                        noticeId = winnotice.get("id");
                    }
                }
                showParameter.setPkId(noticeId);
                showParameter.setHasRight(true);
                boolean issendwinnotice = (Boolean)sectionDynamicObject.get("issendwinnotice");
                if (issendwinnotice) {
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u4e2d\u6807\u901a\u77e5\u4e66", (String)"BidDecisionEditUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    showParameter.setStatus(OperationStatus.EDIT);
                    showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u4e66", (String)"BidDecisionEditUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                this.getView().showForm(showParameter);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"thanksletter")) {
            Long id = (Long)this.getModel().getValue("id");
            data = this.service.getBidDecisionSingle(id);
            if (!(BillStatusEnum.AUDITED.getVal().equals(data.getString(BILL_STATUS)) || "S".equals(data.getString(BILL_STATUS)) || "R".equals(data.getString(BILL_STATUS)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u7684\u6570\u636e\u53d1\u5e03\u611f\u8c22\u4fe1\u3002", (String)"BidDecisionEditUI_24", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                beforeDoOperationEventArgs.setCancel(true);
                return;
            }
            DynamicObjectCollection sectionCollection = (DynamicObjectCollection)bidDecision.get("bidsection");
            int count = this.getModel().getEntryRowCount("bidsection");
            if (count > 1) {
                showParameter = new FormShowParameter();
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"selectsectionlist", ((Object)((Object)this)).getClass()));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCustomParam("sectionCollection", (Object)sectionCollection);
                showParameter.setCustomParam("bidDecisionId", bidDecisionId);
                showParameter.setCustomParam("noticeOrLetter", (Object)"letter");
                closeCallBack = new CloseCallBack((IFormPlugin)this, FormTypeConstants.getFormConstant((String)"selectsection", ((Object)((Object)this)).getClass()));
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            } else {
                showParameter = new BillShowParameter();
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"thanksletter", ((Object)((Object)this)).getClass()));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                DynamicObject section = (DynamicObject)sectionCollection.get(0);
                Object sectionId = section.get("id");
                List<DynamicObject> listSuppliers = DynamicTabHelper.listUnRecommendedSuppliers(sectionId, bidDecision);
                if (listSuppliers == null || listSuppliers.size() <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u4e0b\u7684\u4f9b\u5e94\u5546\u5747\u5df2\u4e2d\u6807\uff0c\u4e0d\u9700\u8981\u53d1\u9001\u611f\u8c22\u4fe1\u3002", (String)"BidDecisionEditUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    beforeDoOperationEventArgs.setCancel(true);
                    return;
                }
                showParameter.setCustomParam("sectionId", sectionId);
                showParameter.setCustomParam("bidDecisionId", bidDecisionId);
                showParameter.setCustomParam("sectionName", (Object)ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"BidDecisionEditUI_29", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                Object letterId = null;
                if (bidProject != null) {
                    QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProject.getLong("id"));
                    DynamicObject thanksletter = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"thanksletter", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (thanksletter != null) {
                        letterId = thanksletter.get("id");
                    }
                }
                showParameter.setPkId(letterId);
                boolean issendthanksletter = (Boolean)section.get("issendthanksletter");
                if (issendthanksletter) {
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u611f\u8c22\u4fe1", (String)"BidDecisionEditUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    showParameter.setStatus(OperationStatus.EDIT);
                    showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u9001\u611f\u8c22\u4fe1", (String)"BidDecisionEditUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                this.getView().showForm(showParameter);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            RefObject afterConfirm = new RefObject();
            boolean isratebidding = (Boolean)bidProject.get("isratebidding");
            String docType = bidProject.getString("doctype");
            if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
                List<String> confirmTips;
                DynamicObjectCollection sections = dataEntity.getDynamicObjectCollection("bidsection");
                boolean flag = false;
                if (sections != null && !sections.isEmpty()) {
                    block4: for (DynamicObject section : sections) {
                        DynamicObjectCollection supEntries = section.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplier : supEntries) {
                            int techfile_new = supplier.getDynamicObjectCollection("techfile_new").size();
                            int commfile_new = supplier.getDynamicObjectCollection("commfile_new").size();
                            if (isratebidding) {
                                BigDecimal finalRate = supplier.getBigDecimal("finalrate");
                                BigDecimal rate = supplier.getBigDecimal("rate");
                                if (finalRate != null && rate.compareTo(BigDecimal.ZERO) != 0 && (techfile_new != 0 || !BidOpenTypeEnum.MULTI.getValue().equals(docType)) && commfile_new != 0) continue;
                                flag = true;
                                continue block4;
                            }
                            BigDecimal finalprice = supplier.getBigDecimal("finalprice");
                            if (finalprice != null && commfile_new != 0 && finalprice.compareTo(BigDecimal.ZERO) != 0 && (techfile_new != 0 || !BidOpenTypeEnum.MULTI.getValue().equals(docType))) continue;
                            flag = true;
                            continue block4;
                        }
                    }
                }
                if (flag) {
                    String value;
                    beforeDoOperationEventArgs.setCancel(true);
                    confirmTips = this.checkPurEntryData();
                    StringBuilder s = new StringBuilder();
                    int i = 0;
                    if (confirmTips != null && confirmTips.size() > 0) {
                        for (String confirmTip : confirmTips) {
                            String value2 = ++i + "\u3001" + confirmTip + "\r\n";
                            s.append(value2);
                        }
                    }
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                    if (isratebidding) {
                        if (!s.toString().isEmpty()) {
                            value = ++i + "\u3001";
                            s.append(value);
                        }
                        s.append(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4e0a\u4f20\u6807\u4e66\u6216\u201c\u8d39\u7387\u201d\u4e3a0\u7684\u5206\u5f55\u3002", (String)"BidDecisionEditUI_58", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        this.getView().showConfirm(null, s.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    } else {
                        if (!s.toString().isEmpty()) {
                            value = ++i + "\u3001";
                            s.append(value);
                        }
                        s.append(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4e0a\u4f20\u6807\u4e66\u6216\u201c\u6700\u7ec8\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09\u201d\u4e3a0\u7684\u5206\u5f55\u3002", (String)"BidDecisionEditUI_59", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        this.getView().showConfirm(null, s.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    }
                } else {
                    confirmTips = this.checkPurEntryData();
                    if (confirmTips != null && confirmTips.size() > 0) {
                        String[] tips = confirmTips.toArray(new String[0]);
                        StringBuilder s = new StringBuilder();
                        beforeDoOperationEventArgs.setCancel(true);
                        if (confirmTips.size() == 1) {
                            String value = tips[0] + "\r\n";
                            s.append(value);
                        } else {
                            int i = 0;
                            for (String confirmTip : confirmTips) {
                                String value = ++i + "\u3001" + confirmTip + "\r\n";
                                s.append(value);
                            }
                        }
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                        this.getView().showConfirm(null, s.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    }
                }
            }
            operate.getOption().setVariableValue(OPPARAM_AFTERCONFIRM, "true");
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"unsubmit")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection bidSectionCollection = dataEntity.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSectionCollection.size(); ++i) {
                DynamicObjectCollection supplierCollection = ((DynamicObject)bidSectionCollection.get(i)).getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplier : supplierCollection) {
                    if (!Lang.zh_CN.equals((Object)lang)) {
                        if (!Lang.zh_TW.equals((Object)lang)) {
                            supplier.set("commentdetail", (Object)"Edit");
                            continue;
                        }
                    }
                    supplier.set("commentdetail", (Object)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"BidDecisionEditUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
            }
            this.getView().updateView("supplierentry");
        }
    }

    protected List<String> checkPurEntryData() {
        BigDecimal botTotalFinalAuAmount;
        BigDecimal botTotalControlAmount;
        String totalFinalKey;
        String totalControlKey;
        String sectionName;
        BigDecimal sectionTotalFinalPrice;
        ArrayList<String> list = new ArrayList<String>(16);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Map<String, BigDecimal> totalSectionBotAmountMap = this.getSectionTotalBotAmountMap();
        Boolean enableMultiSection = dataEntity.getDynamicObject("bidproject").getBoolean("enablemultisection");
        DynamicObjectCollection bidSectionCol = dataEntity.getDynamicObjectCollection("bidsection");
        HashMap<String, BigDecimal> sectionAmountMap = new HashMap<String, BigDecimal>();
        for (DynamicObject bidSection : bidSectionCol) {
            sectionTotalFinalPrice = BigDecimal.ZERO;
            sectionName = bidSection.getString("sectionname");
            totalControlKey = String.format("%s%s", sectionName, "totalControl");
            totalFinalKey = String.format("%s%s", sectionName, "totalFinal");
            botTotalControlAmount = totalSectionBotAmountMap.get(totalControlKey) == null ? BigDecimal.ZERO : totalSectionBotAmountMap.get(totalControlKey);
            botTotalFinalAuAmount = totalSectionBotAmountMap.get(totalFinalKey) == null ? BigDecimal.ZERO : totalSectionBotAmountMap.get(totalFinalKey);
            DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryCol) {
                boolean isrecommended = supplierEntry.getBoolean("isrecommended");
                if (!isrecommended) continue;
                BigDecimal finalPrice = supplierEntry.getBigDecimal("finalprice");
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (botTotalControlAmount.compareTo(BigDecimal.ZERO) > 0 && botTotalControlAmount.compareTo(finalPrice) < 0) {
                    if (enableMultiSection.booleanValue()) {
                        list.add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u4f9b\u5e94\u5546\u201c%2$s\u201d\u6700\u7ec8\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09\u5927\u4e8e\u6807\u6bb5\u91c7\u8d2d\u63a7\u5236\u91d1\u989d\u3002", (String)"BidDecisionEditUI_60", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionName, supplier.getString("name")));
                    } else {
                        list.add(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%1$s\u201d\u6700\u7ec8\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09\u5927\u4e8e\u6807\u6bb5\u91c7\u8d2d\u63a7\u5236\u91d1\u989d\u3002", (String)"BidDecisionEditUI_61", (String)"scm-bid-formplugin", (Object[])new Object[0]), supplier.getString("name")));
                    }
                }
                if (botTotalFinalAuAmount.compareTo(BigDecimal.ZERO) > 0 && botTotalFinalAuAmount.compareTo(finalPrice) < 0) {
                    if (enableMultiSection.booleanValue()) {
                        list.add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u4f9b\u5e94\u5546\u201c%2$s\u201d\u6700\u7ec8\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09\u5927\u4e8e\u8be5\u6807\u6bb5\u6807\u5e95\u91d1\u989d\u3002", (String)"BidDecisionEditUI_62", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionName, supplier.getString("name")));
                    } else {
                        list.add(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%1$s\u201d\u6700\u7ec8\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09\u5927\u4e8e\u6807\u6bb5\u6807\u5e95\u91d1\u989d\u3002", (String)"BidDecisionEditUI_63", (String)"scm-bid-formplugin", (Object[])new Object[0]), supplier.getString("name")));
                    }
                }
                sectionTotalFinalPrice = sectionTotalFinalPrice.add(supplierEntry.getBigDecimal("finalprice"));
            }
            sectionAmountMap.put(sectionName, sectionTotalFinalPrice);
        }
        if (!sectionAmountMap.isEmpty()) {
            for (Map.Entry sectionMap : sectionAmountMap.entrySet()) {
                sectionTotalFinalPrice = (BigDecimal)sectionMap.getValue();
                sectionName = (String)sectionMap.getKey();
                totalControlKey = String.format("%s%s", sectionName, "totalControl");
                totalFinalKey = String.format("%s%s", sectionName, "totalFinal");
                botTotalControlAmount = totalSectionBotAmountMap.get(totalControlKey) == null ? BigDecimal.ZERO : totalSectionBotAmountMap.get(totalControlKey);
                BigDecimal bigDecimal = botTotalFinalAuAmount = totalSectionBotAmountMap.get(totalFinalKey) == null ? BigDecimal.ZERO : totalSectionBotAmountMap.get(totalFinalKey);
                if (botTotalControlAmount.compareTo(BigDecimal.ZERO) > 0 && botTotalControlAmount.compareTo(sectionTotalFinalPrice) < 0) {
                    if (enableMultiSection.booleanValue()) {
                        list.add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u6807\u91d1\u989d\u5927\u4e8e\u8be5\u6807\u6bb5\u91c7\u8d2d\u63a7\u5236\u91d1\u989d\u3002", (String)"BidDecisionEditUI_64", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionName));
                    } else {
                        list.add(String.format(ResManager.loadKDString((String)"\u5b9a\u6807\u603b\u91d1\u989d\u5927\u4e8e\u91c7\u8d2d\u63a7\u5236\u603b\u91d1\u989d\u3002", (String)"BidDecisionEditUI_65", (String)"scm-bid-formplugin", (Object[])new Object[0]), new Object[0]));
                    }
                }
                if (botTotalFinalAuAmount.compareTo(BigDecimal.ZERO) <= 0 || botTotalFinalAuAmount.compareTo(sectionTotalFinalPrice) >= 0) continue;
                if (enableMultiSection.booleanValue()) {
                    list.add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u6807\u91d1\u989d\u5927\u4e8e\u8be5\u6807\u6bb5\u6807\u5e95\u6700\u7ec8\u91d1\u989d\u3002", (String)"BidDecisionEditUI_66", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionName));
                    continue;
                }
                list.add(String.format(ResManager.loadKDString((String)"\u5b9a\u6807\u91d1\u989d\u5927\u4e8e\u6807\u5e95\u6700\u7ec8\u91d1\u989d\u3002", (String)"BidDecisionEditUI_67", (String)"scm-bid-formplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
        if (enableMultiSection.booleanValue()) {
            BigDecimal excTaxControlAmount = dataEntity.getBigDecimal("controlamount");
            BigDecimal basePrice = dataEntity.getBigDecimal("baseprice");
            BigDecimal excTaxAmount = dataEntity.getBigDecimal("amount");
            if (basePrice.compareTo(BigDecimal.ZERO) > 0 && basePrice.compareTo(excTaxAmount) < 0) {
                list.add(ResManager.loadKDString((String)"\u5b9a\u6807\u603b\u91d1\u989d\u5927\u4e8e\u6807\u5e95\u603b\u91d1\u989d\u3002", (String)"BidDecisionEditUI_68", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            if (excTaxControlAmount.compareTo(BigDecimal.ZERO) > 0 && excTaxControlAmount.compareTo(excTaxAmount) < 0) {
                list.add(ResManager.loadKDString((String)"\u5b9a\u6807\u603b\u91d1\u989d\u5927\u4e8e\u91c7\u8d2d\u63a7\u5236\u603b\u91d1\u989d\u3002", (String)"BidDecisionEditUI_65", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
        return list;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("submit".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
                this.getView().invokeOperation("submit", operateOption);
            }
        } else if ("save".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("save", operateOption);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String appId;
        boolean enable;
        int j;
        DynamicObjectCollection supplierBackColl;
        DynamicObjectCollection supplierFinalColl;
        DynamicObjectCollection supplierColl;
        DynamicObjectCollection bidSectionColl;
        int i;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Lang lang = RequestContext.get().getLang();
        if (operateKey.equals("alldownfile") && args.getOperationResult().isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5168\u90e8\u9644\u4ef6\u6210\u529f", (String)"BidDecisionEditUI_55", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
        String billstatus = dataEntity.getString(BILL_STATUS);
        EntryGrid supplierEntryGrid = (EntryGrid)this.getControl("supplierentry");
        if (StringUtils.equals((CharSequence)"A", (CharSequence)billstatus) || StringUtils.equals((CharSequence)"D", (CharSequence)billstatus)) {
            supplierEntryGrid.setColumnProperty("score", "l", (Object)0);
        } else {
            supplierEntryGrid.setColumnProperty("score", "l", (Object)55);
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"releasedescacco")) {
            this.itemClickAnnouncementProMsg();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"checkdescacco")) {
            this.itemClickCheckAnnouncement();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"revokedescacco")) {
            this.itemClickRevokeAnnouncement();
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"submit")) {
            billstatus = (String)this.getModel().getValue(BILL_STATUS);
            if (!billstatus.equals("A") && !billstatus.equals("D")) {
                DynamicObjectCollection bidSectionCollection = dataEntity.getDynamicObjectCollection("bidsection");
                for (i = 0; i < bidSectionCollection.size(); ++i) {
                    DynamicObjectCollection supplierCollection = ((DynamicObject)bidSectionCollection.get(i)).getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplier : supplierCollection) {
                        if (!Lang.zh_CN.equals((Object)lang)) {
                            if (!Lang.zh_TW.equals((Object)lang)) {
                                supplier.set("commentdetail", (Object)"View");
                                continue;
                            }
                        }
                        supplier.set("commentdetail", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidDecisionEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                }
                this.getView().updateView("supplierentry");
            }
            if (args.getOperationResult().isSuccess()) {
                bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
                if (bidSectionColl != null && bidSectionColl.size() > 0) {
                    for (i = 0; i < bidSectionColl.size(); ++i) {
                        supplierColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                        supplierFinalColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supfinaldetail");
                        supplierBackColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supbackdetail");
                        if (supplierColl != null && supplierColl.size() > 0) {
                            for (j = 0; j < supplierColl.size(); ++j) {
                                ((DynamicObject)supplierColl.get(j)).set("finaltaxrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("finaltaxrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierColl.get(j)).set("tendertaxrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("tendertaxrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierColl.get(j)).set("finalrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("finalrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierColl.get(j)).set("rate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("rate").multiply(new BigDecimal("100")));
                            }
                        }
                        if (supplierFinalColl != null && supplierFinalColl.size() > 0) {
                            for (j = 0; j < supplierFinalColl.size(); ++j) {
                                ((DynamicObject)supplierFinalColl.get(j)).set("ltaxrate", (Object)((DynamicObject)supplierFinalColl.get(j)).getBigDecimal("ltaxrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierFinalColl.get(j)).set("lcostrate", (Object)((DynamicObject)supplierFinalColl.get(j)).getBigDecimal("lcostrate").multiply(new BigDecimal("100")));
                            }
                        }
                        if (supplierBackColl == null || supplierBackColl.size() <= 0) continue;
                        for (j = 0; j < supplierBackColl.size(); ++j) {
                            ((DynamicObject)supplierBackColl.get(j)).set("taxrate", (Object)((DynamicObject)supplierBackColl.get(j)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                            ((DynamicObject)supplierBackColl.get(j)).set("costrate", (Object)((DynamicObject)supplierBackColl.get(j)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                        }
                    }
                }
                this.getView().updateView("supplierentry");
                this.getView().updateView("supfinaldetail");
                this.getView().updateView("supbackdetail");
            }
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"audit")) {
            billstatus = (String)this.getModel().getValue(BILL_STATUS);
            if (!StringUtils.equals((CharSequence)billstatus, (CharSequence)"C")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"winnotice", "thanksletter"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"winnotice", "thanksletter"});
            }
            if (args.getOperationResult().isSuccess()) {
                bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
                if (bidSectionColl != null && bidSectionColl.size() > 0) {
                    for (i = 0; i < bidSectionColl.size(); ++i) {
                        supplierColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                        supplierFinalColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supfinaldetail");
                        supplierBackColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supbackdetail");
                        if (supplierColl != null && supplierColl.size() > 0) {
                            for (j = 0; j < supplierColl.size(); ++j) {
                                ((DynamicObject)supplierColl.get(j)).set("finaltaxrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("finaltaxrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierColl.get(j)).set("tendertaxrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("tendertaxrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierColl.get(j)).set("finalrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("finalrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierColl.get(j)).set("rate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("rate").multiply(new BigDecimal("100")));
                            }
                        }
                        if (supplierFinalColl != null && supplierFinalColl.size() > 0) {
                            for (j = 0; j < supplierFinalColl.size(); ++j) {
                                ((DynamicObject)supplierFinalColl.get(j)).set("ltaxrate", (Object)((DynamicObject)supplierFinalColl.get(j)).getBigDecimal("ltaxrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierFinalColl.get(j)).set("lcostrate", (Object)((DynamicObject)supplierFinalColl.get(j)).getBigDecimal("lcostrate").multiply(new BigDecimal("100")));
                            }
                        }
                        if (supplierBackColl == null || supplierBackColl.size() <= 0) continue;
                        for (j = 0; j < supplierBackColl.size(); ++j) {
                            ((DynamicObject)supplierBackColl.get(j)).set("taxrate", (Object)((DynamicObject)supplierBackColl.get(j)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                            ((DynamicObject)supplierBackColl.get(j)).set("costrate", (Object)((DynamicObject)supplierBackColl.get(j)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                        }
                    }
                }
                this.getView().updateView("supplierentry");
                this.getView().updateView("supfinaldetail");
                this.getView().updateView("supbackdetail");
            }
        } else if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"deletesupplierentry")) {
            String value = operate.getOption().getVariableValue("ishasright");
            if (StringUtils.equals((CharSequence)value, (CharSequence)"true")) {
                DynamicObject evaluatedecideway = this.getModel().getDataEntity(true).getDynamicObject("evaluatedecideway");
                String evaname = evaluatedecideway.getString("name");
                Long typeId = evaluatedecideway.getLong("id");
                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                    this.rangeSupplierEntry();
                } else {
                    this.rangeSupplierEntryByScore();
                }
            }
        } else if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"unaudit") && args.getOperationResult().isSuccess()) {
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            Object pkid = this.annocumentService.getProjectPKId(pkValue);
            this.annocumentService.deleteAnnouncementByProId(pkid, (Object)"decision");
        }
        if (!(enable = SystemParamHelper.getSystemParameter((String)(appId = this.getModel().getDataEntityType().getAppId()), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"issendwinnotice", "issendthanksletter", "winnotice", "thanksletter"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"issendwinnotice", "issendthanksletter", "winnotice", "thanksletter"});
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"save")) {
            if (args.getOperationResult().isSuccess()) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_decision");
                DynamicObject bidDecision = this.getModel().getDataEntity(true);
                DynamicObject temp = BusinessDataServiceHelper.loadSingleFromCache((Object)bidDecision.getPkValue(), (DynamicObjectType)type);
                this.getModel().setValue("modifytime", temp.get("modifytime"));
                DynamicObjectCollection bidSectionColl2 = dataEntity.getDynamicObjectCollection("bidsection");
                if (bidSectionColl2 != null && bidSectionColl2.size() > 0) {
                    for (int i2 = 0; i2 < bidSectionColl2.size(); ++i2) {
                        int j2;
                        DynamicObjectCollection supplierColl2 = ((DynamicObject)bidSectionColl2.get(i2)).getDynamicObjectCollection("supplierentry");
                        DynamicObjectCollection supplierFinalColl2 = ((DynamicObject)bidSectionColl2.get(i2)).getDynamicObjectCollection("supfinaldetail");
                        DynamicObjectCollection supplierBackColl2 = ((DynamicObject)bidSectionColl2.get(i2)).getDynamicObjectCollection("supbackdetail");
                        if (supplierColl2 != null && supplierColl2.size() > 0) {
                            for (j2 = 0; j2 < supplierColl2.size(); ++j2) {
                                ((DynamicObject)supplierColl2.get(j2)).set("finaltaxrate", (Object)((DynamicObject)supplierColl2.get(j2)).getBigDecimal("finaltaxrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierColl2.get(j2)).set("tendertaxrate", (Object)((DynamicObject)supplierColl2.get(j2)).getBigDecimal("tendertaxrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierColl2.get(j2)).set("finalrate", (Object)((DynamicObject)supplierColl2.get(j2)).getBigDecimal("finalrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierColl2.get(j2)).set("rate", (Object)((DynamicObject)supplierColl2.get(j2)).getBigDecimal("rate").multiply(new BigDecimal("100")));
                            }
                        }
                        if (supplierFinalColl2 != null && supplierFinalColl2.size() > 0) {
                            for (j2 = 0; j2 < supplierFinalColl2.size(); ++j2) {
                                ((DynamicObject)supplierFinalColl2.get(j2)).set("ltaxrate", (Object)((DynamicObject)supplierFinalColl2.get(j2)).getBigDecimal("ltaxrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierFinalColl2.get(j2)).set("lcostrate", (Object)((DynamicObject)supplierFinalColl2.get(j2)).getBigDecimal("lcostrate").multiply(new BigDecimal("100")));
                            }
                        }
                        if (supplierBackColl2 == null || supplierBackColl2.size() <= 0) continue;
                        for (j2 = 0; j2 < supplierBackColl2.size(); ++j2) {
                            ((DynamicObject)supplierBackColl2.get(j2)).set("taxrate", (Object)((DynamicObject)supplierBackColl2.get(j2)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                            ((DynamicObject)supplierBackColl2.get(j2)).set("costrate", (Object)((DynamicObject)supplierBackColl2.get(j2)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                        }
                    }
                }
                this.getView().updateView("supplierentry");
                this.getView().updateView("supfinaldetail");
                this.getView().updateView("supbackdetail");
            }
            if (args.getOperateKey().equals("save") && args.getOperationResult().isSuccess()) {
                this.getView().invokeOperation("refresh");
            }
        }
        this.controlListBtnStatus();
        if ((StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"unaudit")) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void setSignBtnStatus() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"sign"});
        DynamicObject decision = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"id,billstatus");
        String value = decision.getString(BILL_STATUS);
        DynamicObject project = (DynamicObject)this.getModel().getValue("bidproject");
        if (project != null) {
            String purModel = project.getString("purmodel");
            if (PurchaseModel.StrategySourcing.getVal().equals(purModel) && (BillStatusEnum.AUDITED.getVal().equals(value) || BillStatusEnum.PARTSIGNED.getVal().equals(value))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"sign"});
            }
        }
        if (BillStatusEnum.PARTSIGNED.getVal().equals(value) || BillStatusEnum.SIGNED.getVal().equals(value)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_unaudit"});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"score", (CharSequence)fieldKey)) {
            DynamicObject evaluatedecideway = this.getModel().getDataEntity(true).getDynamicObject("evaluatedecideway");
            String evaname = evaluatedecideway.getString("name");
            Long typeId = evaluatedecideway.getLong("id");
            if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                this.rangeSupplierEntry();
            } else {
                this.rangeSupplierEntryByScore();
            }
        }
        if (StringUtils.equals((CharSequence)"finalvat", (CharSequence)fieldKey)) {
            this.sumAmount();
            return;
        }
        if (StringUtils.equals((CharSequence)"isrecommended", (CharSequence)fieldKey)) {
            if (newVal != null) {
                this.recommendedFieldChange((Boolean)newVal);
            }
            this.sumAmount();
            DynamicObject project = (DynamicObject)this.getModel().getValue("bidproject");
            if (project == null) {
                return;
            }
            String purTypeId = project.getString("purtype.id");
            DynamicObject purType = BusinessDataServiceHelper.loadSingle((Object)purTypeId, (String)FormTypeConstants.getFormConstant((String)"purtype", ((Object)((Object)this)).getClass()), (String)"enablemultiunitwon");
            Boolean enableMultiUnitWon = purType == null ? false : purType.getBoolean("enablemultiunitwon");
            String purModel = project.getString("purmodel");
            boolean isStrategy = PurchaseModel.StrategySourcing.getVal().equals(purModel);
            if (enableMultiUnitWon.booleanValue() || isStrategy) {
                return;
            }
            int index = cd.getRowIndex();
            if (index == -1) {
                return;
            }
            this.setIsRecommendedStatus((Boolean)newVal, index);
            return;
        }
        if (StringUtils.equals((CharSequence)"evaluatedecideway", (CharSequence)fieldKey)) {
            this.setScoreByDecideWay();
            if (newVal != null) {
                String evaname = ((DynamicObject)newVal).getString("name");
                Long typeId = ((DynamicObject)newVal).getLong("id");
                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                    this.rangeSupplierEntry();
                } else {
                    this.rangeSupplierEntryByScore();
                }
            }
        }
        if (StringUtils.equals((CharSequence)"finalrate", (CharSequence)fieldKey)) {
            if (this.isExistScore()) {
                return;
            }
            this.rangeSupplierEntryByFinalrate();
        }
        if (StringUtils.equals((CharSequence)"finalprice", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"finaltaxrate", (CharSequence)fieldKey)) {
            DynamicObject bidDecision = this.getModel().getDataEntity(true);
            EntryGrid sectionEntryGrid = (EntryGrid)this.getView().getControl("bidsection");
            AbstractGrid.GridState sectionEntryState = sectionEntryGrid.getEntryState();
            int sectionEntryFocusRow = sectionEntryState.getFocusRow();
            EntryGrid supplierEntryGrid = (EntryGrid)this.getView().getControl("supplierentry");
            AbstractGrid.GridState supplierEntryState = supplierEntryGrid.getEntryState();
            int supplierEntryFocusRow = supplierEntryState.getFocusRow();
            DynamicObject sectionEntryRow = (DynamicObject)bidDecision.getDynamicObjectCollection("bidsection").get(sectionEntryFocusRow);
            String FocusRowid = null;
            if (supplierEntryFocusRow > -1) {
                DynamicObject supplierEntryRow = (DynamicObject)sectionEntryRow.getDynamicObjectCollection("supplierentry").get(supplierEntryFocusRow);
                DynamicObject supplier = supplierEntryRow.getDynamicObject("supplier");
                FocusRowid = supplier.getString("id");
            }
            if (StringUtils.equals((CharSequence)"finalprice", (CharSequence)fieldKey)) {
                DynamicObject evaluatedecideway = this.getModel().getDataEntity(true).getDynamicObject("evaluatedecideway");
                String evaname = evaluatedecideway.getString("name");
                Long typeId = evaluatedecideway.getLong("id");
                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                    this.rangeSupplierEntry();
                } else {
                    this.rangeSupplierEntryByScore();
                }
            }
            DynamicObjectCollection supplierentry = this.getModel().getEntryEntity("supplierentry");
            DynamicObject supplierEntryRow = null;
            int onRow = -1;
            for (DynamicObject dynamicObject : supplierentry) {
                ++onRow;
                if (FocusRowid == null || !FocusRowid.equals(dynamicObject.getDynamicObject("supplier").getString("id"))) continue;
                supplierEntryRow = dynamicObject;
                break;
            }
            if (onRow > -1 && supplierEntryRow != null) {
                BigDecimal finalprice = supplierEntryRow.getBigDecimal("finalprice");
                BigDecimal finaltaxrate = supplierEntryRow.getBigDecimal("finaltaxrate");
                finaltaxrate = finaltaxrate.divide(new BigDecimal("100"));
                BigDecimal finaltax = BigDecimal.ZERO;
                BigDecimal finalnotTaxTenderPrice = BigDecimal.ZERO;
                if (finaltaxrate.compareTo(BigDecimal.ZERO) > 0 && finalprice.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal multiplyNumber = finalprice.multiply(finaltaxrate);
                    BigDecimal addNumbner = finaltaxrate.add(new BigDecimal(1));
                    finaltax = multiplyNumber.divide(addNumbner, 2, 4);
                    finalnotTaxTenderPrice = finalprice.subtract(finaltax);
                    this.getModel().setValue("finalvat", (Object)finaltax, onRow);
                    this.getModel().setValue("finalexceptvat", (Object)finalnotTaxTenderPrice, onRow);
                    this.getView().updateView("supplierentry");
                } else if (finalprice.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("finalvat", (Object)BigDecimal.ZERO, onRow);
                    this.getModel().setValue("finalexceptvat", (Object)BigDecimal.ZERO, onRow);
                    this.getView().updateView("supplierentry");
                } else if (finaltaxrate.compareTo(BigDecimal.ZERO) == 0) {
                    supplierEntryRow.set("finalvat", (Object)BigDecimal.ZERO);
                    supplierEntryRow.set("finalexceptvat", (Object)finalprice);
                    this.getView().updateView("supplierentry");
                }
            }
            this.sumAmount();
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"declareamount")) {
            BigDecimal basePrice = BigDecimal.ZERO;
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bottomentry");
            int[] selectRow = entryEntityGrid.getSelectRows();
            DynamicObjectCollection bottomSectionColl = dataEntity.getDynamicObjectCollection("bottomsection");
            for (int i = 0; i < bottomSectionColl.size(); ++i) {
                DynamicObject bidBottomSection = (DynamicObject)bottomSectionColl.get(i);
                DynamicObjectCollection openBottomEntryColl = bidBottomSection.getDynamicObjectCollection("bottomentry");
                for (int j = 0; j < openBottomEntryColl.size(); ++j) {
                    DynamicObject openBottomEntry = (DynamicObject)openBottomEntryColl.get(j);
                    openBottomEntry.set("finalauditamount", (Object)openBottomEntry.getBigDecimal("declareamount"));
                    basePrice = basePrice.add(openBottomEntry.getBigDecimal("declareamount"));
                }
            }
            dataEntity.set("baseprice", (Object)basePrice);
            this.getView().updateView("baseprice");
            this.getView().updateView("bottomentry");
        }
    }

    protected void recommendedFieldChange(boolean newVal) {
        EntryGrid supplierentryGrid = (EntryGrid)this.getView().getControl("supplierentry");
        int focusRow = supplierentryGrid.getEntryState().getFocusRow();
        if (focusRow < 0) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        EntryGrid bidsectionEntry = (EntryGrid)this.getView().getControl("bidsection");
        int sectionfocusRow = bidsectionEntry.getEntryState().getFocusRow();
        if (sectionfocusRow < 0) {
            sectionfocusRow = 0;
        }
        DynamicObject bidsection = (DynamicObject)dataEntity.getDynamicObjectCollection("bidsection").get(sectionfocusRow);
        DynamicObjectCollection supplierentry = bidsection.getDynamicObjectCollection("supplierentry");
        DynamicObject entry = (DynamicObject)supplierentry.get(focusRow);
        long supplier = (Long)entry.getDynamicObject("supplier").getPkValue();
        DynamicObjectCollection supfinaldetail = bidsection.getDynamicObjectCollection("supfinaldetail");
        supfinaldetail.forEach(supEntry -> {
            DynamicObject lpursupplier = supEntry.getDynamicObject("lpursupplier");
            if (lpursupplier == null) {
                return;
            }
            if (supplier == (Long)lpursupplier.getPkValue()) {
                supEntry.set("recommendedflag", (Object)newVal);
            }
        });
        this.getView().updateView("supfinaldetail");
    }

    private void sumAmount() {
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal amtExceptVat = BigDecimal.ZERO;
        DynamicObjectCollection bidSection = this.getModel().getEntryEntity("bidsection");
        for (int i = 0; i < bidSection.size(); ++i) {
            DynamicObjectCollection supplierEntry = ((DynamicObject)bidSection.get(i)).getDynamicObjectCollection("supplierentry");
            if (supplierEntry == null || supplierEntry.size() <= 0) continue;
            for (int j = 0; j < supplierEntry.size(); ++j) {
                BigDecimal fev;
                if (!((DynamicObject)supplierEntry.get(j)).getBoolean("isrecommended")) continue;
                BigDecimal fp = ((DynamicObject)supplierEntry.get(j)).getBigDecimal("finalprice");
                if (fp != null) {
                    amt = amt.add(fp);
                }
                if ((fev = ((DynamicObject)supplierEntry.get(j)).getBigDecimal("finalexceptvat")) == null) continue;
                amtExceptVat = amtExceptVat.add(fev);
            }
        }
        this.getModel().setValue("amount", (Object)amt);
        this.getModel().setValue("exctaxamount", (Object)amtExceptVat);
    }

    private void setIsRecommendedStatus(boolean newVal, int index) {
        if (newVal) {
            int size = this.getModel().getEntryEntity("supplierentry").size();
            for (int i = 0; i < size; ++i) {
                if (i == index) continue;
                this.getModel().setValue("isrecommended", (Object)Boolean.FALSE, i);
            }
            this.getView().updateView("supplierentry");
            if (this.needFlagNewSupplier()) {
                this.updateBackCroundColour();
            }
        }
    }

    public void rangeSupplierEntry() {
        String key;
        String id1;
        DynamicObject supplier1;
        DynamicObject entry;
        int i;
        DynamicObjectCollection ses = this.getModel().getEntryEntity("supplierentry");
        List scoreList = ses.stream().collect(Collectors.toList());
        scoreList.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                BigDecimal aver4;
                BigDecimal aver3 = o1.getBigDecimal("finalprice");
                if (aver3.compareTo(aver4 = o2.getBigDecimal("finalprice")) == 0) {
                    String id2;
                    DynamicObject supplier1 = (DynamicObject)o1.get("supplier");
                    DynamicObject supplier2 = (DynamicObject)o2.get("supplier");
                    String id1 = supplier1.getString("id");
                    return id1.compareTo(id2 = supplier2.getString("id")) > 0 ? 1 : -1;
                }
                return aver3.compareTo(aver4) > 0 ? 1 : -1;
            }
        });
        HashMap<String, Integer> sortMap = new HashMap<String, Integer>(16);
        for (i = 0; i < scoreList.size(); ++i) {
            DynamicObject se = (DynamicObject)scoreList.get(i);
            StringBuilder builder = new StringBuilder();
            DynamicObject supplier12 = (DynamicObject)se.get("supplier");
            String id12 = supplier12.getString("id");
            builder.append(se.getString("finalprice")).append(id12);
            if (sortMap.containsKey(builder.toString())) continue;
            sortMap.put(builder.toString(), i + 1);
        }
        for (i = 0; i < ses.size(); ++i) {
            entry = this.getModel().getEntryRowEntity("supplierentry", i);
            supplier1 = (DynamicObject)entry.get("supplier");
            id1 = supplier1.getString("id");
            key = entry.getString("finalprice") + id1;
            Integer temp = (Integer)sortMap.get(key);
            if (temp == null) continue;
            this.getModel().setValue("range", (Object)temp, i);
        }
        scoreList = this.getModel().getEntryEntity("supplierentry").stream().collect(Collectors.toList());
        scoreList.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                int aver2;
                int aver1 = o1.getInt("range");
                return aver1 - (aver2 = o2.getInt("range")) > 0 ? 1 : -1;
            }
        });
        ses.clear();
        for (i = 0; i < scoreList.size(); ++i) {
            entry = ses.addNew();
            this.copy((DynamicObject)scoreList.get(i), entry, i);
        }
        for (i = 0; i < ses.size(); ++i) {
            this.getModel().setValue("range", (Object)0, i);
            entry = this.getModel().getEntryRowEntity("supplierentry", i);
            supplier1 = (DynamicObject)entry.get("supplier");
            id1 = supplier1.getString("id");
            key = entry.getString("finalprice") + id1;
            Integer integer = (Integer)sortMap.get(key);
            if (integer == null) continue;
            this.getModel().setValue("range", (Object)integer, i);
        }
        this.getView().updateView("supplierentry");
    }

    public boolean isExistScore() {
        Long decideId;
        DynamicObject decide = (DynamicObject)this.getModel().getValue("evaluatedecideway");
        if (decide != null && (decideId = Long.valueOf(decide.getLong("id"))).longValue() != this.getDecideWayToWhetherHideScore().longValue()) {
            return false;
        }
        DynamicObjectCollection ses = this.getModel().getEntryEntity("supplierentry");
        for (DynamicObject se : ses) {
            BigDecimal score = se.getBigDecimal("score");
            if (score == null || score.compareTo(BigDecimal.ZERO) == 0) continue;
            return true;
        }
        return false;
    }

    public void rangeSupplierEntryByScore() {
        String key;
        String id1;
        DynamicObject supplier1;
        DynamicObject entry;
        int i;
        DynamicObjectCollection ses = this.getModel().getEntryEntity("supplierentry");
        List scoreList = ses.stream().collect(Collectors.toList());
        scoreList.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                BigDecimal aver2;
                BigDecimal aver1 = o1.getBigDecimal("score");
                return aver1.compareTo(aver2 = o2.getBigDecimal("score")) < 0 ? 1 : -1;
            }
        });
        scoreList.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                BigDecimal aver2;
                BigDecimal aver1 = o1.getBigDecimal("score");
                if (aver1.compareTo(aver2 = o2.getBigDecimal("score")) == 0) {
                    BigDecimal aver4;
                    BigDecimal aver3 = o1.getBigDecimal("finalprice");
                    if (aver3.compareTo(aver4 = o2.getBigDecimal("finalprice")) == 0) {
                        String id2;
                        DynamicObject supplier1 = (DynamicObject)o1.get("supplier");
                        DynamicObject supplier2 = (DynamicObject)o2.get("supplier");
                        String id1 = supplier1.getString("id");
                        return id1.compareTo(id2 = supplier2.getString("id")) > 0 ? 1 : -1;
                    }
                    return aver3.compareTo(aver4) > 0 ? 1 : -1;
                }
                return 0;
            }
        });
        HashMap<String, Integer> sortMap = new HashMap<String, Integer>(16);
        for (i = 0; i < scoreList.size(); ++i) {
            DynamicObject se = (DynamicObject)scoreList.get(i);
            StringBuilder builder = new StringBuilder();
            DynamicObject supplier12 = (DynamicObject)se.get("supplier");
            String id12 = supplier12.getString("id");
            builder.append(se.getString("score")).append(se.getString("finalprice")).append(id12);
            if (sortMap.containsKey(builder.toString())) continue;
            sortMap.put(builder.toString(), i + 1);
        }
        for (i = 0; i < ses.size(); ++i) {
            entry = this.getModel().getEntryRowEntity("supplierentry", i);
            supplier1 = (DynamicObject)entry.get("supplier");
            id1 = supplier1.getString("id");
            key = entry.getString("score") + entry.getString("finalprice") + id1;
            Integer temp = (Integer)sortMap.get(key);
            if (temp == null) continue;
            this.getModel().setValue("range", (Object)temp, i);
        }
        scoreList = this.getModel().getEntryEntity("supplierentry").stream().collect(Collectors.toList());
        scoreList.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                int aver2;
                int aver1 = o1.getInt("range");
                return aver1 - (aver2 = o2.getInt("range")) > 0 ? 1 : -1;
            }
        });
        ses.clear();
        for (i = 0; i < scoreList.size(); ++i) {
            entry = ses.addNew();
            this.copy((DynamicObject)scoreList.get(i), entry, i);
        }
        for (i = 0; i < ses.size(); ++i) {
            this.getModel().setValue("range", (Object)0, i);
            entry = this.getModel().getEntryRowEntity("supplierentry", i);
            supplier1 = (DynamicObject)entry.get("supplier");
            id1 = supplier1.getString("id");
            key = entry.getString("score") + entry.getString("finalprice") + id1;
            Integer integer = (Integer)sortMap.get(key);
            if (integer == null) continue;
            this.getModel().setValue("range", (Object)integer, i);
        }
        this.getView().updateView("supplierentry");
    }

    protected void copy(DynamicObject item, DynamicObject entry, int i) {
        entry.set("seq", (Object)(i + 1));
        entry.set("id", item.get("id"));
        entry.set("supplier", item.get("supplier"));
        entry.set("score", item.get("score"));
        entry.set("range", item.get("range"));
        entry.set("winorder", item.get("winorder"));
        entry.set("isrecommended", item.get("isrecommended"));
        entry.set("finalprice", item.get("finalprice"));
        entry.set("finaltaxrate", item.get("finaltaxrate"));
        entry.set("finalvat", item.get("finalvat"));
        entry.set("finalexceptvat", item.get("finalexceptvat"));
        entry.set("tenderprice", item.get("tenderprice"));
        entry.set("tendertaxrate", item.get("tendertaxrate"));
        entry.set("tendervat", item.get("tendervat"));
        entry.set("tenderexceptvat", item.get("tenderexceptvat"));
        entry.set("finalrate", item.get("finalrate"));
        entry.set("rate", item.get("rate"));
        DynamicObjectCollection techfile_new = item.getDynamicObjectCollection("techfile_new");
        DynamicObjectCollection commfile_new = item.getDynamicObjectCollection("commfile_new");
        DynamicObjectCollection techfile_new_entry = entry.getDynamicObjectCollection("techfile_new");
        DynamicObjectCollection commfile_new_entry = entry.getDynamicObjectCollection("commfile_new");
        techfile_new.forEach(attachment -> techfile_new_entry.addNew().set("fbasedataid", attachment.get("fbasedataid")));
        commfile_new.forEach(attachment -> commfile_new_entry.addNew().set("fbasedataid", attachment.get("fbasedataid")));
        entry.set("commentdetail", item.get("commentdetail"));
        entry.set("comment", item.get("comment"));
        entry.set("techrounds", item.get("techrounds"));
        entry.set("bussrounds", item.get("bussrounds"));
    }

    public void rangeSupplierEntryByFinalrate() {
        DynamicObjectCollection ses = this.getModel().getEntryEntity("supplierentry");
        List scoreSet = ses.stream().map(se -> se.getBigDecimal("finalrate")).map(BigDecimal::doubleValue).distinct().sorted((p1, p2) -> p2.compareTo((Double)p1)).collect(Collectors.toList());
        int size = ses.size();
        Collections.reverse(scoreSet);
        for (int i = 0; i < size; ++i) {
            int index;
            BigDecimal p = this.getModel().getEntryRowEntity("supplierentry", i).getBigDecimal("finalrate");
            if (p == null) {
                p = BigDecimal.ZERO;
            }
            if ((index = scoreSet.indexOf(p.doubleValue())) != -1) {
                this.getModel().setValue("range", (Object)(index + 1), i);
                continue;
            }
            this.getModel().setValue("range", (Object)(scoreSet.size() + 1), i);
        }
    }

    private void setBillStatus() {
        IDataEntityProperty property = this.getModel().getProperty(BILL_STATUS);
        this.getView().setVisible(Boolean.FALSE, new String[]{"sign"});
        if (property != null) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            } else {
                String value = (String)this.getModel().getValue(BILL_STATUS);
                if (BillStatusEnum.SAVE.getVal().equals(value) || BillStatusEnum.DISBEGIN.getVal().equals(value)) {
                    boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (bFromDb) {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                    } else {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
                    }
                } else if (BillStatusEnum.SUBMIT.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
                } else if (BillStatusEnum.AUDITING.getVal().equals(value) || BillStatusEnum.AUDITED.getVal().equals(value) || BillStatusEnum.SIGNED.getVal().equals(value) || BillStatusEnum.PARTSIGNED.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
                    if (!BillStatusEnum.SIGNED.getVal().equals(value)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"sign"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{"signstatus"});
                    }
                    if (BillStatusEnum.SIGNED.getVal().equals(value)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_unaudit"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{"signstatus"});
                    } else if (BillStatusEnum.PARTSIGNED.getVal().equals(value)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_unaudit"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{"signstatus"});
                    }
                    if (BillStatusEnum.AUDITING.getVal().equals(value)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unaudit", "sign", "bar_audit"});
                    }
                } else if (BillStatusEnum.INVALID.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_unaudit"});
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String changeFlag;
        super.beforeClosed(e);
        Object id = this.getModel().getValue("id");
        if (String.valueOf(id).equals("0") && (changeFlag = this.getPageCache().get("isChanged")) != null && changeFlag.equals("0")) {
            this.getModel().setDataChanged(false);
        }
        String billStatus = (String)this.getModel().getValue(BILL_STATUS);
        if (BillStatusEnum.PARTSIGNED.getVal().equals(billStatus) || BillStatusEnum.SIGNED.getVal().equals(billStatus) || BillStatusEnum.AUDITED.getVal().equals(billStatus) || BillStatusEnum.SUBMIT.getVal().equals(billStatus) || BillStatusEnum.AUDITING.getVal().equals(billStatus)) {
            this.getModel().setDataChanged(false);
        }
        if ("A".equals(billStatus) || "B".equals(billStatus) || "C".equals(billStatus)) {
            this.getModel().setDataChanged(false);
        }
    }

    private void controlListBtnStatus() {
        DynamicObject src = this.getModel().getDataEntity();
        Object id = src.getPkValue();
        String billStatus = src.getString(BILL_STATUS);
        IFormView view = this.getView();
        if (BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_del"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
        }
        if (BillStatusEnum.AUDITED.getVal().equals(billStatus)) {
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
            if (!enable) {
                view.setVisible(Boolean.FALSE, new String[]{"releasedescacco"});
            } else {
                Object pkid = this.annocumentService.getProjectPKId(id);
                DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
                if (BidModeHelper.isPublicBidding(project)) {
                    view.setVisible(Boolean.TRUE, new String[]{"releasedescacco"});
                    Long projectId = src.getLong("bidproject.id");
                    QFilter bidProjectQFilter = new QFilter("bidproject", "=", (Object)projectId.toString());
                    QFilter annotypeQFilter = new QFilter("annotype", "=", (Object)"decision");
                    QFilter billstatusFilter = new QFilter(BILL_STATUS, "=", (Object)BillStatusEnum.RELEASED.getVal());
                    Boolean canRevokedescacco = QueryServiceHelper.exists((String)"bid_announcement", (QFilter[])new QFilter[]{bidProjectQFilter, annotypeQFilter, billstatusFilter});
                    if (canRevokedescacco.booleanValue()) {
                        view.setEnable(Boolean.TRUE, new String[]{"revokedescacco"});
                    } else {
                        view.setEnable(Boolean.FALSE, new String[]{"revokedescacco"});
                    }
                } else {
                    view.setVisible(Boolean.FALSE, new String[]{"releasedescacco"});
                }
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"releasedescacco"});
        }
    }

    private void itemClickAnnouncementProMsg() {
        List sectionList;
        DynamicObject src = this.getModel().getDataEntity();
        Object id = src.getPkValue();
        DynamicObject org = src.getDynamicObject("org");
        Long mainOrgId = (Long)org.getPkValue();
        Object pkid = this.annocumentService.getProjectPKId(id);
        Map pidAndSecColMap = this.annocumentService.getPidAndSecCol(id);
        if (pidAndSecColMap != null && (sectionList = (List)pidAndSecColMap.get("sectionList")) != null && sectionList.size() > 0) {
            BillShowParameter showParameter;
            DynamicObject[] announcements = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"decisionannouncement", ((Object)((Object)this)).getClass()), (String)"section", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)pkid.toString())});
            Set isExitSectionSet = Arrays.stream(announcements).map(item -> item.getString("section")).collect(Collectors.toSet());
            int sectionSum = sectionList.size();
            Iterator iterator = sectionList.iterator();
            while (iterator.hasNext()) {
                Map section = (Map)iterator.next();
                if (!isExitSectionSet.contains(section.get("sectionPkid").toString())) continue;
                iterator.remove();
            }
            if (sectionList.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u4e0d\u5b58\u5728\u672a\u53d1\u5e03\u4e2d\u6807\u516c\u544a\u7684\u6807\u6bb5\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u3002", (String)"BidDecisionEditUI_44", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            if (sectionSum == 1) {
                showParameter = new BillShowParameter();
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"decisionannouncement", ((Object)((Object)this)).getClass()));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                String billStatus = this.annocumentService.getBillStatus(pkid, (Object)"decision");
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.setCustomParam("dbid", id);
                showParameter.setCustomParam("pkid", pkid);
                showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                showParameter.setCustomParam("parentType", (Object)"decision");
                showParameter.setCustomParam("sectionList", (Object)sectionList);
                showParameter.setCaption(ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a", (String)"BidDecisionEditUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                showParameter.setHasRight(true);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                showParameter = new FormShowParameter();
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"annosection", ((Object)((Object)this)).getClass()));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setCustomParam("sectionList", (Object)sectionList);
                showParameter.setCustomParam("pkid", pkid);
                showParameter.setCustomParam("id", id);
                showParameter.setCustomParam("dbid", id);
                showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                showParameter.setCustomParam("parentType", (Object)"decision");
                showParameter.setCustomParam("operType", (Object)"opendecianno");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FormTypeConstants.getFormConstant((String)"annosection", ((Object)((Object)this)).getClass())));
                showParameter.setHasRight(true);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private void itemClickCheckAnnouncement() {
        DynamicObject src = this.getModel().getDataEntity();
        Object id = src.getPkValue();
        Map pidAndSecColMap = this.annocumentService.getPidAndSecCol(id);
        if (pidAndSecColMap != null) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(FormTypeConstants.getFormConstant((String)"decisionannouncement", ((Object)((Object)this)).getClass()));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("parentType", (Object)"decision");
            showParameter.setCustomParam("projectPkid", pidAndSecColMap.get("projectPkid"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void itemClickRevokeAnnouncement() {
        List sectionList;
        DynamicObject src = this.getModel().getDataEntity();
        Object id = src.getPkValue();
        DynamicObject org = src.getDynamicObject("org");
        Long mainOrgId = (Long)org.getPkValue();
        Object pkid = this.annocumentService.getProjectPKId(id);
        Map pidAndSecColMap = this.annocumentService.getPidAndSecCol(id);
        if (pidAndSecColMap != null && (sectionList = (List)pidAndSecColMap.get("sectionList")) != null && sectionList.size() > 0) {
            if (sectionList.size() == 1) {
                String billStatus = this.annocumentService.getBillStatus(pkid, (Object)"decision");
                if (billStatus != null) {
                    if (billStatus.equals(BillStatusEnum.SAVE.getVal())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u4e2d\u6807\u516c\u544a\uff0c\u65e0\u9700\u64a4\u9500\u3002", (String)"BidDecisionEditUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                    if (billStatus.equals(BillStatusEnum.RELEASED.getVal())) {
                        this.annocumentService.changeAnnoStatusToA(pkid, (Object)"decision");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u4e2d\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidDecisionEditUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u4e2d\u6807\u516c\u544a\uff0c\u65e0\u9700\u64a4\u9500\u3002", (String)"BidDecisionEditUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
            } else {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"annosection", ((Object)((Object)this)).getClass()));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setCustomParam("sectionList", (Object)sectionList);
                showParameter.setCustomParam("pkid", pkid);
                showParameter.setCustomParam("id", id);
                showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                showParameter.setCustomParam("operType", (Object)"revokedescanno");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FormTypeConstants.getFormConstant((String)"annosection", ((Object)((Object)this)).getClass())));
                this.getView().showForm(showParameter);
            }
        }
    }

    public Long getDecideWayToWhetherHideScore() {
        return 493255064807351296L;
    }
}

