/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.basedata.IBidThanksLetterService;
import kd.scm.bid.business.basedata.IBidWinNoticeService;
import kd.scm.bid.business.basedata.serviceImpl.BidThanksLetterServiceImpl;
import kd.scm.bid.business.basedata.serviceImpl.BidWinNoticeServiceImpl;
import kd.scm.bid.business.bill.IBidAnnocumentService;
import kd.scm.bid.business.bill.IBidDecisionService;
import kd.scm.bid.business.bill.serviceImpl.BidAnnocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.scm.bid.formplugin.bill.helper.PermissionHepler;

public class BidDecisionListUI
extends AbstractListPlugin {
    private IBidDecisionService service = new BidDecisionServiceImpl();
    private IBidWinNoticeService winNoticeService = new BidWinNoticeServiceImpl();
    private IBidThanksLetterService thanksLetterService = new BidThanksLetterServiceImpl();
    private static final String KEY_CURRENTSTEP = "bidproject.currentstep";
    private IBidAnnocumentService annocumentService = new BidAnnocumentServiceImpl();
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)"bidproject_currentstep", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object id = sr.getPrimaryKeyValue();
            QFilter myFilter = new QFilter("id", "=", id);
            DynamicObject exitDecision = QueryServiceHelper.queryOne((String)"bid_decision", (String)"id", (QFilter[])new QFilter[]{myFilter});
            if (null == exitDecision) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"BidDecisionListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(this.getOpenFormId("projectprocess"));
            showParameter.setCustomParam("bidProjectId", this.service.getBidProjectId(id));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
            return;
        }
        if (StringUtils.equals((CharSequence)"bidproject_name", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object id = sr.getPrimaryKeyValue();
            QFilter myFilter = new QFilter("id", "=", id);
            DynamicObject exitDecision = QueryServiceHelper.queryOne((String)"bid_decision", (String)"id", (QFilter[])new QFilter[]{myFilter});
            if (null == exitDecision) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"BidDecisionListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        QFilter myFilter;
        DynamicObject exitDecision;
        ListSelectedRow myRow;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        formOperate.getOption().setVariableValue("form", "List");
        String entityKey = formOperate.getEntityId();
        String announcement_id = "bid_announcement";
        if ("rebm".equals(this.getView().getFormShowParameter().getServiceAppId())) {
            announcement_id = "rebm_announcement";
        }
        if (null != (myRow = ((IListView)this.getView()).getCurrentSelectedRowInfo()) && null == (exitDecision = QueryServiceHelper.queryOne((String)"bid_decision", (String)"id", (QFilter[])new QFilter[]{myFilter = new QFilter("id", "=", myRow.getPrimaryKeyValue())})) && !StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)"close") && !StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)"refresh")) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"BidDecisionListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = -1L;
        List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
        if (orgIds != null && orgIds.size() != 0) {
            orgId = (Long)orgIds.get(0);
        }
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        if (StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)"unaudit")) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            if (rows != null && rows.size() > 0) {
                for (ListSelectedRow row : rows) {
                    Object pkvalue = row.getPrimaryKeyValue();
                    Object pkid = this.annocumentService.getProjectPKId(pkvalue);
                    Map pidAndSecColMap = this.annocumentService.getPidAndSecCol(pkvalue);
                    if (pidAndSecColMap != null) {
                        List sectionList = (List)pidAndSecColMap.get("sectionList");
                        for (int i = 0; i < sectionList.size(); ++i) {
                            String billStatus = this.annocumentService.getBillStatus(pkid, (Object)"decision", ((Map)sectionList.get(i)).get("sectionPkid"));
                            if (billStatus != null && billStatus.equals(BillStatusEnum.RELEASED.getVal())) {
                                args.setCancel(true);
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u5df2\u53d1\u5e03\u4e2d\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDecisionListUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                return;
                            }
                            if (i != sectionList.size() - 1) continue;
                            this.annocumentService.deleteAnnouncementByProId(pkid, (Object)"decision");
                        }
                    }
                    Object bidProjectId = this.service.getBidProjectId((Object)Long.parseLong(pkvalue.toString()));
                    Long projectId = Long.parseLong(bidProjectId.toString());
                    DynamicObject winNotice = this.winNoticeService.getWinNoticeByProjectId(projectId, "id");
                    DynamicObject thanksLetter = this.thanksLetterService.getThanksLetterByProjectId(projectId, "id");
                    if (winNotice != null && thanksLetter != null) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u4e66\u548c\u611f\u8c22\u4fe1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDecisionListUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (winNotice != null) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u4e66\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDecisionListUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (thanksLetter != null) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u611f\u8c22\u4fe1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDecisionListUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.winNoticeService.deleteWinNoticeByProjectId(projectId);
                    this.thanksLetterService.deleteThanksLetterByProjectId(projectId);
                }
            }
        } else if (StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)"releasedescacco")) {
            ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
            if (src != null && src.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u4e2d\u6807\u516c\u544a\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidDecisionListUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            if (sr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u884c\u3002", (String)"BidDecisionListUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean hasPermission = PermissionHepler.checkPermission("QXX0117", orgId, appId, FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53d1\u5e03\u4e2d\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidDecisionListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)"checkdescacco")) {
            ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
            if (src != null && src.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u4e2d\u6807\u516c\u544a\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidDecisionListUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            if (sr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u884c\u3002", (String)"BidDecisionListUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean hasPermission = PermissionHepler.checkPermission("QXX0118", orgId, appId, FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u770b\u4e2d\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidDecisionListUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)"revokedescacco")) {
            ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
            if (src != null && src.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64a4\u9500\u4e2d\u6807\u516c\u544a\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidDecisionListUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            if (sr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u884c\u3002", (String)"BidDecisionListUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean hasPermission = PermissionHepler.checkPermission("QXX0119", orgId, appId, FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64a4\u9500\u4e2d\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidDecisionListUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)"submit")) {
            RefObject afterConfirm = new RefObject();
            if (!formOperate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                Object[] pkArray = new Object[rows.size()];
                for (int i = 0; i < rows.size(); ++i) {
                    pkArray[i] = rows.get(i).getPrimaryKeyValue();
                }
                boolean flag = false;
                DynamicObject[] coll = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass())));
                for (int i = 0; i < coll.length && !flag; ++i) {
                    String value;
                    StringBuilder s;
                    List<String> confirmTips;
                    DynamicObject dataEntity = coll[i];
                    Object bidDecisionId = dataEntity.get("id");
                    DynamicObject bidDecision = BusinessDataServiceHelper.loadSingle((Object)bidDecisionId, (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
                    DynamicObject bidProject = bidDecision.getDynamicObject("bidproject");
                    boolean isratebidding = (Boolean)bidProject.get("isratebidding");
                    String docType = bidProject.getString("doctype");
                    DynamicObjectCollection sections = dataEntity.getDynamicObjectCollection("bidsection");
                    if (sections != null && !sections.isEmpty()) {
                        block4: for (int j = 0; j < sections.size() && !flag; ++j) {
                            DynamicObject section = (DynamicObject)sections.get(j);
                            DynamicObjectCollection supEntries = section.getDynamicObjectCollection("supplierentry");
                            for (DynamicObject supplier : supEntries) {
                                DynamicObjectCollection techFile = supplier.getDynamicObjectCollection("techfile_new");
                                DynamicObjectCollection commFile = supplier.getDynamicObjectCollection("commfile_new");
                                if (isratebidding) {
                                    BigDecimal finalRate = supplier.getBigDecimal("finalrate");
                                    BigDecimal rate = supplier.getBigDecimal("rate");
                                    if (finalRate != null && rate != null && commFile.size() != 0 && finalRate.compareTo(BigDecimal.ZERO) != 0 && rate.compareTo(BigDecimal.ZERO) != 0 && (techFile.size() != 0 || !BidOpenTypeEnum.MULTI.getValue().equals(docType))) continue;
                                    flag = true;
                                    continue block4;
                                }
                                BigDecimal finalprice = supplier.getBigDecimal("finalprice");
                                if (finalprice != null && commFile.size() != 0 && finalprice.compareTo(BigDecimal.ZERO) != 0 && (techFile.size() != 0 || !BidOpenTypeEnum.MULTI.getValue().equals(docType))) continue;
                                flag = true;
                                continue block4;
                            }
                        }
                    }
                    if (flag) {
                        String value2;
                        args.setCancel(true);
                        confirmTips = this.checkPurEntryData(formOperate.getOperateKey(), dataEntity);
                        s = new StringBuilder();
                        boolean j = false;
                        if (confirmTips != null && confirmTips.size() > 0) {
                            for (String confirmTip : confirmTips) {
                                value = ++i + "\u3001" + confirmTip + "\r\n";
                                s.append(value);
                            }
                        }
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                        if (isratebidding) {
                            if (!s.toString().isEmpty()) {
                                value2 = ++i + "\u3001";
                                s.append(value2);
                            }
                            s.append(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4e0a\u4f20\u6807\u4e66\u6216\u201c\u8d39\u7387\u201d\u4e3a0\u7684\u5206\u5f55\u3002", (String)"BidDecisionListUI_64", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            this.getView().showConfirm(null, s.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                            continue;
                        }
                        if (!s.toString().isEmpty()) {
                            value2 = ++i + "\u3001";
                            s.append(value2);
                        }
                        s.append(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4e0a\u4f20\u6807\u4e66\u6216\u201c\u6700\u7ec8\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09\u201d\u4e3a0\u7684\u5206\u5f55\u3002", (String)"BidDecisionListUI_65", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        this.getView().showConfirm(null, s.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                        continue;
                    }
                    confirmTips = this.checkPurEntryData(formOperate.getOperateKey(), dataEntity);
                    s = new StringBuilder();
                    if (confirmTips == null || confirmTips.size() <= 0) continue;
                    args.setCancel(true);
                    if (confirmTips.size() == 1) {
                        String[] tips = confirmTips.toArray(new String[0]);
                        String value3 = tips[0] + "\r\n";
                        s.append(value3);
                    } else {
                        boolean j = false;
                        for (String confirmTip : confirmTips) {
                            value = ++i + "\u3001" + confirmTip + "\r\n";
                            s.append(value);
                        }
                    }
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                    this.getView().showConfirm(null, s.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                }
                formOperate.getOption().setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            }
        } else if (StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)"issuewinnotice")) {
            this.issueWinNoticeAndThanksLetter(args, this.getAppId() + "_" + "winnotice");
        } else if (StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)"viewwinnotice")) {
            this.viewWinNoticeAndThanksLetter(args, this.getAppId() + "_" + "winnotice");
        } else if (StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)"issuethanksletter")) {
            this.issueWinNoticeAndThanksLetter(args, this.getAppId() + "_" + "thanksletter");
        } else if (StringUtils.equals((CharSequence)formOperate.getOperateKey(), (CharSequence)"viewthanksletter")) {
            this.viewWinNoticeAndThanksLetter(args, this.getAppId() + "_" + "thanksletter");
        } else if ("push".equals(formOperate.getOperateKey())) {
            this.pushScmcContract(args);
        }
    }

    protected void pushScmcContract(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (listSelectedData.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u64cd\u4f5c\u591a\u6761\u6570\u636e\u3002", (String)"BidDecisionListUI_41", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    protected String getAppId() {
        return ((IListView)this.getView()).getBillFormId().split("_")[0];
    }

    protected List<String> checkPurEntryData(String operateKey, DynamicObject dataEntity) {
        BigDecimal botTotalFinalAuAmount;
        BigDecimal botTotalControlAmount;
        String totalFinalKey;
        String totalControlKey;
        String sectionName;
        BigDecimal sectionTotalFinalPrice;
        ArrayList<String> list = new ArrayList<String>(16);
        Map<String, BigDecimal> totalSectionBotAmountMap = this.getSectionTotalBotAmountMap(dataEntity);
        Boolean enableMultiSection = dataEntity.getDynamicObject("bidproject").getBoolean("enablemultisection");
        DynamicObjectCollection bidSectionCol = dataEntity.getDynamicObjectCollection("bidsection");
        HashMap<String, BigDecimal> sectionAmountMap = new HashMap<String, BigDecimal>();
        for (DynamicObject bidSection : bidSectionCol) {
            sectionTotalFinalPrice = BigDecimal.ZERO;
            sectionName = bidSection.getString("sectionname");
            totalControlKey = String.format("%s%s", sectionName, "totalControl");
            totalFinalKey = String.format("%s%s", sectionName, "totalFinal");
            botTotalControlAmount = totalSectionBotAmountMap.get(totalControlKey) == null ? BigDecimal.ZERO : totalSectionBotAmountMap.get(totalControlKey);
            botTotalFinalAuAmount = totalSectionBotAmountMap.get(totalFinalKey) == null ? BigDecimal.ZERO : totalSectionBotAmountMap.get(totalFinalKey);
            DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryCol) {
                boolean isrecommended = supplierEntry.getBoolean("isrecommended");
                if (!isrecommended) continue;
                BigDecimal finalPrice = supplierEntry.getBigDecimal("finalprice");
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (botTotalControlAmount.compareTo(BigDecimal.ZERO) > 0 && botTotalControlAmount.compareTo(finalPrice) < 0) {
                    if (enableMultiSection.booleanValue()) {
                        list.add(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u4e0b\u4f9b\u5e94\u5546\u3010%2$s\u3011\u6700\u7ec8\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09\u5927\u4e8e\u6807\u6bb5\u91c7\u8d2d\u63a7\u5236\u91d1\u989d\uff1b", (String)"BidDecisionListUI_66", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionName, supplier.getString("name")));
                    } else {
                        list.add(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u3010%1$s\u3011\u6700\u7ec8\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09\u5927\u4e8e\u6807\u6bb5\u91c7\u8d2d\u63a7\u5236\u91d1\u989d\uff1b", (String)"BidDecisionListUI_67", (String)"scm-bid-formplugin", (Object[])new Object[0]), supplier.getString("name")));
                    }
                }
                if (botTotalFinalAuAmount.compareTo(BigDecimal.ZERO) > 0 && botTotalFinalAuAmount.compareTo(finalPrice) < 0) {
                    if (enableMultiSection.booleanValue()) {
                        list.add(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u4e0b\u4f9b\u5e94\u5546\u3010%2$s\u3011\u6700\u7ec8\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09\u5927\u4e8e\u8be5\u6807\u6bb5\u6807\u5e95\u91d1\u989d\uff1b", (String)"BidDecisionListUI_68", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionName, supplier.getString("name")));
                    } else {
                        list.add(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u3010%1$s\u3011\u6700\u7ec8\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09\u5927\u4e8e\u6807\u6bb5\u6807\u5e95\u91d1\u989d\uff1b", (String)"BidDecisionListUI_69", (String)"scm-bid-formplugin", (Object[])new Object[0]), supplier.getString("name")));
                    }
                }
                sectionTotalFinalPrice = sectionTotalFinalPrice.add(supplierEntry.getBigDecimal("finalprice"));
            }
            sectionAmountMap.put(sectionName, sectionTotalFinalPrice);
        }
        if (!sectionAmountMap.isEmpty()) {
            for (Map.Entry sectionMap : sectionAmountMap.entrySet()) {
                sectionTotalFinalPrice = (BigDecimal)sectionMap.getValue();
                sectionName = (String)sectionMap.getKey();
                totalControlKey = String.format("%s%s", sectionName, "totalControl");
                totalFinalKey = String.format("%s%s", sectionName, "totalFinal");
                botTotalControlAmount = totalSectionBotAmountMap.get(totalControlKey) == null ? BigDecimal.ZERO : totalSectionBotAmountMap.get(totalControlKey);
                BigDecimal bigDecimal = botTotalFinalAuAmount = totalSectionBotAmountMap.get(totalFinalKey) == null ? BigDecimal.ZERO : totalSectionBotAmountMap.get(totalFinalKey);
                if (botTotalControlAmount.compareTo(BigDecimal.ZERO) > 0 && botTotalControlAmount.compareTo(sectionTotalFinalPrice) < 0) {
                    if (enableMultiSection.booleanValue()) {
                        list.add(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u4e2d\u6807\u91d1\u989d\u5927\u4e8e\u8be5\u6807\u6bb5\u91c7\u8d2d\u63a7\u5236\u91d1\u989d\uff1b", (String)"BidDecisionListUI_70", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionName));
                    } else {
                        list.add(String.format(ResManager.loadKDString((String)"\u5b9a\u6807\u603b\u91d1\u989d\u5927\u4e8e\u91c7\u8d2d\u63a7\u5236\u603b\u91d1\u989d\uff1b", (String)"BidDecisionListUI_71", (String)"scm-bid-formplugin", (Object[])new Object[0]), new Object[0]));
                    }
                }
                if (botTotalFinalAuAmount.compareTo(BigDecimal.ZERO) <= 0 || botTotalFinalAuAmount.compareTo(sectionTotalFinalPrice) >= 0) continue;
                if (enableMultiSection.booleanValue()) {
                    list.add(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u4e2d\u6807\u91d1\u989d\u5927\u4e8e\u8be5\u6807\u6bb5\u6807\u5e95\u6700\u7ec8\u91d1\u989d\uff1b", (String)"BidDecisionListUI_72", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionName));
                    continue;
                }
                list.add(String.format(ResManager.loadKDString((String)"\u5b9a\u6807\u91d1\u989d\u5927\u4e8e\u6807\u5e95\u6700\u7ec8\u91d1\u989d\u3002\uff1b", (String)"BidDecisionListUI_73", (String)"scm-bid-formplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
        if (enableMultiSection.booleanValue()) {
            BigDecimal excTaxControlAmount = dataEntity.getBigDecimal("controlamount");
            BigDecimal basePrice = dataEntity.getBigDecimal("baseprice");
            BigDecimal excTaxAmount = dataEntity.getBigDecimal("amount");
            if (basePrice.compareTo(BigDecimal.ZERO) > 0 && basePrice.compareTo(excTaxAmount) < 0) {
                list.add(ResManager.loadKDString((String)"\u5b9a\u6807\u603b\u91d1\u989d\u5927\u4e8e\u6807\u5e95\u603b\u91d1\u989d\uff1b", (String)"BidDecisionListUI_74", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            if (excTaxControlAmount.compareTo(BigDecimal.ZERO) > 0 && excTaxControlAmount.compareTo(excTaxAmount) < 0) {
                list.add(ResManager.loadKDString((String)"\u5b9a\u6807\u603b\u91d1\u989d\u5927\u4e8e\u91c7\u8d2d\u63a7\u5236\u603b\u91d1\u989d\uff1b", (String)"BidDecisionListUI_71", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
        return list;
    }

    protected Map<String, BigDecimal> getSectionTotalBotAmountMap(DynamicObject dataEntity) {
        HashMap<String, BigDecimal> botSectionTotalAmountMap = new HashMap<String, BigDecimal>(16);
        DynamicObjectCollection bottomSectionCol = dataEntity.getDynamicObjectCollection("bottomsection");
        if (bottomSectionCol != null && bottomSectionCol.size() > 0) {
            for (DynamicObject bottomSection : bottomSectionCol) {
                String sectionName = bottomSection.getString("botsectionname");
                DynamicObjectCollection bottomEntryCol = bottomSection.getDynamicObjectCollection("bottomentry");
                BigDecimal sectionTotalBotControlAmount = BigDecimal.ZERO;
                BigDecimal sectionTotalFinalAuditAmount = BigDecimal.ZERO;
                for (DynamicObject bottomEntry : bottomEntryCol) {
                    sectionTotalBotControlAmount = sectionTotalBotControlAmount.add(bottomEntry.getBigDecimal("botcontrolamount"));
                    sectionTotalFinalAuditAmount = sectionTotalFinalAuditAmount.add(bottomEntry.getBigDecimal("finalauditamount"));
                }
                String totalControlKey = String.format("%s%s", sectionName, "totalControl");
                String totalFinalKey = String.format("%s%s", sectionName, "totalFinal");
                if (sectionTotalBotControlAmount.compareTo(BigDecimal.ZERO) > 0) {
                    botSectionTotalAmountMap.put(totalControlKey, sectionTotalBotControlAmount);
                }
                if (sectionTotalFinalAuditAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                botSectionTotalAmountMap.put(totalFinalKey, sectionTotalFinalAuditAmount);
            }
        }
        return botSectionTotalAmountMap;
    }

    protected void issueWinNoticeAndThanksLetter(BeforeDoOperationEventArgs args, String entityTypeId) {
        boolean noticeOrThanksLetter = "winnotice".equals(entityTypeId.split("_")[1]);
        String tips = noticeOrThanksLetter ? ResManager.loadKDString((String)"\u4e2d\u6807\u901a\u77e5\u4e66", (String)"BidDecisionListUI_18", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u611f\u8c22\u4fe1", (String)"BidDecisionListUI_19", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u64cd\u4f5c\u591a\u6761\u6570\u636e\u3002", (String)"BidDecisionListUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (selectedRows.size() == 0) {
            return;
        }
        long primaryKeyValue = (Long)selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject decision = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass())));
        if (decision == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u64cd\u4f5c\u7684\u6570\u636e\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"BidDecisionListUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String billStatus = decision.getString("billstatus");
        if (!("C".equals(billStatus) || "S".equals(billStatus) || "R".equals(billStatus))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u7684\u6570\u636e\u53d1\u5e03%s\u3002", (String)"BidDecisionListUI_17", (String)"scm-bid-formplugin", (Object[])new Object[0]), tips));
            args.setCancel(true);
            return;
        }
        DynamicObject bidProject = decision.getDynamicObject("bidproject");
        DynamicObjectCollection section = decision.getDynamicObjectCollection("bidsection");
        if (section.size() == 1) {
            boolean flag;
            boolean bl = flag = noticeOrThanksLetter ? ((DynamicObject)section.get(0)).getBoolean("issendwinnotice") : ((DynamicObject)section.get(0)).getBoolean("issendthanksletter");
            if (flag) {
                String bidDecisionListUI_20 = String.format(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u4e0d\u5b58\u5728\u672a\u53d1\u5e03%1$s\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u3002", (String)"BidDecisionListUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]), tips);
                this.getView().showTipNotification(bidDecisionListUI_20);
                args.setCancel(true);
            } else {
                if (!noticeOrThanksLetter) {
                    DynamicObjectCollection supplierentry = ((DynamicObject)section.get(0)).getDynamicObjectCollection("supplierentry");
                    if (supplierentry.size() == 1) {
                        String bidDecisionListUI_20 = String.format(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u4e0d\u5b58\u5728\u672a\u53d1\u5e03%1$s\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u3002", (String)"BidDecisionListUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]), tips);
                        this.getView().showTipNotification(bidDecisionListUI_20);
                        args.setCancel(true);
                        return;
                    }
                    boolean hasUnSendThanksLetter = true;
                    for (DynamicObject row : supplierentry) {
                        boolean isrecommended = row.getBoolean("isrecommended");
                        if (isrecommended) continue;
                        hasUnSendThanksLetter = false;
                        break;
                    }
                    if (hasUnSendThanksLetter) {
                        String bidDecisionListUI_20 = String.format(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u4e0d\u5b58\u5728\u672a\u53d1\u5e03%1$s\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u3002", (String)"BidDecisionListUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]), tips);
                        this.getView().showTipNotification(bidDecisionListUI_20);
                        args.setCancel(true);
                        return;
                    }
                }
                this.openWinNoticeEditSingleSection(section, decision, bidProject, entityTypeId);
            }
        } else if (section.size() > 1) {
            boolean flag = true;
            boolean isSend = true;
            for (DynamicObject row : section) {
                boolean bl = isSend = noticeOrThanksLetter ? row.getBoolean("issendwinnotice") : row.getBoolean("issendthanksletter");
                if (isSend) continue;
                flag = false;
                break;
            }
            if (flag) {
                String bidDecisionListUI_20 = String.format(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u4e0d\u5b58\u5728\u672a\u53d1\u5e03%1$s\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u3002", (String)"BidDecisionListUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]), tips);
                this.getView().showTipNotification(bidDecisionListUI_20);
                args.setCancel(true);
            } else {
                this.openSelectSectionEdit(decision, section, noticeOrThanksLetter);
            }
        }
    }

    protected void openSelectSectionEdit(DynamicObject decision, DynamicObjectCollection section, boolean noticeOrThanksLetter) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormTypeConstants.getFormConstant((String)"selectsectionlist", ((Object)((Object)this)).getClass()));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("sectionCollection", (Object)section);
        showParameter.setCustomParam("bidDecisionId", (Object)decision.getLong("id"));
        showParameter.setCustomParam("noticeOrLetter", (Object)(noticeOrThanksLetter ? "notice" : "letter"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, FormTypeConstants.getFormConstant((String)"selectsection", ((Object)((Object)this)).getClass()));
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    protected void openWinNoticeEditSingleSection(DynamicObjectCollection sectionColl, DynamicObject decision, DynamicObject bidProject, String entityTypeId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityTypeId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject sectionDynamicObject = (DynamicObject)sectionColl.get(0);
        showParameter.setCustomParam("sectionId", sectionDynamicObject.get("id"));
        showParameter.setCustomParam("bidDecisionId", (Object)decision.getLong("id"));
        showParameter.setCustomParam("sectionName", (Object)sectionDynamicObject.getString("sectionname"));
        Object id = null;
        if (bidProject != null) {
            QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProject.getLong("id"));
            DynamicObject winnoticeOrThanksLetter = QueryServiceHelper.queryOne((String)entityTypeId, (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (winnoticeOrThanksLetter != null) {
                id = winnoticeOrThanksLetter.get("id");
            }
        }
        showParameter.setPkId(id);
        showParameter.setHasRight(true);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void viewWinNoticeAndThanksLetter(BeforeDoOperationEventArgs args, String entityTypeId) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u64cd\u4f5c\u591a\u6761\u6570\u636e\u3002", (String)"BidDecisionListUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (selectedRows.size() == 0) {
            return;
        }
        long primaryKeyValue = (Long)selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject decision = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"billstatus,bidproject", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)primaryKeyValue), new QFilter("billstatus", "!=", (Object)"XX")});
        if (decision == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u64cd\u4f5c\u7684\u6570\u636e\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"BidDecisionListUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(entityTypeId);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCustomParam("bidproject", (Object)decision.getLong("bidproject"));
        listShowParameter.setCustomParam("decisionId", (Object)primaryKeyValue);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("submit".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("submit", operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            if (rows != null && rows.size() > 0) {
                for (ListSelectedRow row : rows) {
                    Object pkvalue = row.getPrimaryKeyValue();
                    Object pkid = this.annocumentService.getProjectPKId(pkvalue);
                    this.annocumentService.deleteAnnouncementByProId(pkid, (Object)"decision");
                }
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"releasedescacco")) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            this.itemClickAnnouncementProMsg(sr);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"checkdescacco")) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            this.itemClickCheckAnnouncement(sr);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"revokedescacco")) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            this.itemClickRevokeAnnouncement(sr);
        }
    }

    private void itemClickAnnouncementProMsg(ListSelectedRow sr) {
        Object id = sr.getPrimaryKeyValue();
        Object pkid = this.annocumentService.getProjectPKId(id);
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        long mainOrgId = sr.getMainOrgId();
        if (BidModeHelper.isPublicBidding(project)) {
            if (BillStatusEnum.AUDITED.getVal().equals(sr.getBillStatus()) || BillStatusEnum.SIGNED.getVal().equals(sr.getBillStatus()) || BillStatusEnum.PARTSIGNED.getVal().equals(sr.getBillStatus())) {
                List sectionList;
                Map pidAndSecColMap = this.annocumentService.getPidAndSecCol(id);
                if (pidAndSecColMap != null && (sectionList = (List)pidAndSecColMap.get("sectionList")) != null && sectionList.size() > 0) {
                    BillShowParameter showParameter;
                    DynamicObject[] announcements = BusinessDataServiceHelper.load((String)this.getOpenFormId("announcement"), (String)"section", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)project.getPkValue().toString())});
                    Set isExitSectionSet = Arrays.stream(announcements).map(item -> item.getString("section")).collect(Collectors.toSet());
                    int sectionSum = sectionList.size();
                    Iterator iterator = sectionList.iterator();
                    while (iterator.hasNext()) {
                        Map section = (Map)iterator.next();
                        if (!isExitSectionSet.contains(section.get("sectionPkid").toString())) continue;
                        iterator.remove();
                    }
                    if (sectionList.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u4e0d\u5b58\u5728\u672a\u53d1\u5e03\u4e2d\u6807\u516c\u544a\u7684\u6807\u6bb5\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u3002", (String)"BidDecisionListUI_62", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (sectionSum == 1) {
                        showParameter = new BillShowParameter();
                        showParameter.setFormId(this.getOpenFormId("announcement"));
                        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        showParameter.setStatus(OperationStatus.ADDNEW);
                        showParameter.setCustomParam("dbid", id);
                        showParameter.setCustomParam("pkid", pkid);
                        showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                        showParameter.setCustomParam("parentType", (Object)"decision");
                        showParameter.setCustomParam("sectionList", (Object)sectionList);
                        showParameter.setCaption(ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a", (String)"BidDecisionListUI_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        showParameter.setHasRight(true);
                        this.getView().showForm((FormShowParameter)showParameter);
                    } else {
                        showParameter = new FormShowParameter();
                        String formId = this.getOpenFormId("annosection");
                        showParameter.setFormId(formId);
                        showParameter.getOpenStyle().setShowType(ShowType.Modal);
                        showParameter.setStatus(OperationStatus.VIEW);
                        showParameter.setCustomParam("sectionList", (Object)sectionList);
                        showParameter.setCustomParam("pkid", pkid);
                        showParameter.setCustomParam("id", id);
                        showParameter.setCustomParam("dbid", id);
                        showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                        showParameter.setCustomParam("parentType", (Object)"decision");
                        showParameter.setCustomParam("operType", (Object)"opendecianno");
                        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
                        showParameter.setHasRight(true);
                        this.getView().showForm((FormShowParameter)showParameter);
                    }
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u5df2\u5ba1\u6279\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u4e2d\u6807\u516c\u544a\u3002", (String)"BidDecisionListUI_23", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u516c\u5f00\u62db\u6807\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u4e2d\u6807\u516c\u544a\u3002", (String)"BidDecisionListUI_24", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    private void itemClickCheckAnnouncement(ListSelectedRow sr) {
        Object id = sr.getPrimaryKeyValue();
        Object pkid = this.annocumentService.getProjectPKId(id);
        long mainOrgId = sr.getMainOrgId();
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        if (project != null && BidModeHelper.isPublicBidding(project)) {
            if (BillStatusEnum.AUDITED.getVal().equals(sr.getBillStatus()) || BillStatusEnum.SIGNED.getVal().equals(sr.getBillStatus()) || BillStatusEnum.PARTSIGNED.getVal().equals(sr.getBillStatus())) {
                Map pidAndSecColMap = this.annocumentService.getPidAndSecCol(id);
                if (pidAndSecColMap != null) {
                    Object projectPkid = pidAndSecColMap.get("projectPkid");
                    ListShowParameter showParameter = new ListShowParameter();
                    showParameter.setBillFormId(this.getOpenFormId("announcement"));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setCustomParam("parentType", (Object)"decision");
                    showParameter.setCustomParam("projectPkid", projectPkid);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u5df2\u5ba1\u6279\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u4e2d\u6807\u516c\u544a\u3002", (String)"BidDecisionListUI_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u516c\u5f00\u62db\u6807\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u4e2d\u6807\u516c\u544a\u3002", (String)"BidDecisionListUI_27", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    private void itemClickRevokeAnnouncement(ListSelectedRow sr) {
        Object id = sr.getPrimaryKeyValue();
        Object pkid = this.annocumentService.getProjectPKId(id);
        long mainOrgId = sr.getMainOrgId();
        DynamicObject decision = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_decision", (String)"bidproject");
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)decision.getDynamicObject("bidproject").getPkValue(), (String)(this.getAppId() + "_project"));
        if (BidModeHelper.isPublicBidding(project)) {
            if (BillStatusEnum.AUDITED.getVal().equals(sr.getBillStatus()) || BillStatusEnum.SIGNED.getVal().equals(sr.getBillStatus()) || BillStatusEnum.PARTSIGNED.getVal().equals(sr.getBillStatus())) {
                List sectionList;
                Map pidAndSecColMap = this.annocumentService.getPidAndSecCol(id);
                if (pidAndSecColMap != null && (sectionList = (List)pidAndSecColMap.get("sectionList")) != null && sectionList.size() > 0) {
                    if (sectionList.size() == 1) {
                        String billStatus = this.annocumentService.getBillStatus(pkid, (Object)"decision");
                        if (billStatus != null) {
                            if (billStatus.equals(BillStatusEnum.RELEASED.getVal())) {
                                this.annocumentService.changeAnnoStatusToA(pkid, (Object)"decision");
                                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u4e2d\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidDecisionListUI_29", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            } else {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u4e2d\u6807\u516c\u544a\uff0c\u65e0\u9700\u64a4\u9500\u3002", (String)"BidDecisionListUI_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            }
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u4e2d\u6807\u516c\u544a\uff0c\u65e0\u9700\u64a4\u9500\u3002", (String)"BidDecisionListUI_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        }
                    } else {
                        FormShowParameter showParameter = new FormShowParameter();
                        String formId = this.getOpenFormId("annosection");
                        showParameter.setFormId(formId);
                        showParameter.getOpenStyle().setShowType(ShowType.Modal);
                        showParameter.setStatus(OperationStatus.VIEW);
                        showParameter.setCustomParam("sectionList", (Object)sectionList);
                        showParameter.setCustomParam("pkid", pkid);
                        showParameter.setCustomParam("id", id);
                        showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                        showParameter.setCustomParam("operType", (Object)"revokedescanno");
                        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
                        this.getView().showForm(showParameter);
                    }
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u5df2\u5ba1\u6279\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u4e2d\u6807\u516c\u544a\u3002", (String)"BidDecisionListUI_30", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u516c\u5f00\u62db\u6807\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u4e2d\u6807\u516c\u544a\u3002", (String)"BidDecisionListUI_31", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (StringUtils.equals((CharSequence)"tbledit", (CharSequence)evt.getItemKey())) {
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            if (listSelectedRowCollection.isEmpty() || listSelectedRowCollection.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BidDecisionListUI_32", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (listSelectedRowCollection.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u5bf9\u591a\u6761\u6570\u636e\u8fdb\u884c\u7f16\u5236\u64cd\u4f5c\u3002", (String)"BidDecisionListUI_33", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Object id = listSelectedRowCollection.get(0).getPrimaryKeyValue();
            QFilter myFilter = new QFilter("id", "=", id);
            DynamicObject exitDecision = QueryServiceHelper.queryOne((String)"bid_decision", (String)"id", (QFilter[])new QFilter[]{myFilter});
            if (null == exitDecision) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"BidDecisionListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            String billstatus = listSelectedRowCollection.get(0).getBillStatus();
            if (!StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.DISBEGIN.getVal()) && !StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.SAVE.getVal())) {
                DynamicObject bidDecision = this.service.getBidDecisionSingle((Long)listSelectedRowCollection.get(0).getPrimaryKeyValue());
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u80fd\u7f16\u5236\u672a\u5f00\u59cb\u548c\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"BidDecisionListUI_49", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidDecision.getString("bidproject.billno")));
                evt.setCancel(true);
                return;
            }
            if (!this.service.checkBidDocFinished(id)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u5b58\u5728\u672a\u5ba1\u6279\u7684\u6807\u4e66\u7f16\u5236\uff0c\u4e0d\u5141\u8bb8\u7f16\u5236\u3002", (String)"BidDecisionListUI_35", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            this.getView().invokeOperation("modify");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map returnmap = (Map)closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)this.getOpenFormId("annosection"))) {
            if (returnmap != null) {
                FormShowParameter parameter = (FormShowParameter)returnmap.get("parameter");
                int nowChose = (Integer)returnmap.get("nowChose");
                int realChonse = (Integer)returnmap.get("realChonse");
                Object sectionid = returnmap.get("sectionid");
                Object operType = parameter.getCustomParam("operType");
                Object pkid = parameter.getCustomParam("pkid");
                Long mainOrgId = Long.valueOf(parameter.getCustomParam("mainOrgId").toString());
                if (operType != null && operType.equals("opendecianno")) {
                    Object id = parameter.getCustomParam("id");
                    List sectionList = (List)parameter.getCustomParam("sectionList");
                    ArrayList choseSection = new ArrayList();
                    choseSection.add(sectionList.get(nowChose));
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId(this.getOpenFormId("announcement"));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setCustomParam("sectionCount", (Object)realChonse);
                    showParameter.setStatus(OperationStatus.ADDNEW);
                    showParameter.setCustomParam("dbid", id);
                    showParameter.setCustomParam("pkid", pkid);
                    showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                    showParameter.setCustomParam("parentType", (Object)"decision");
                    showParameter.setCustomParam("sectionList", choseSection);
                    showParameter.setCaption(ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a", (String)"BidDecisionListUI_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    this.getView().showForm((FormShowParameter)showParameter);
                } else if (operType != null && operType.equals("checkdecianno")) {
                    Map map = this.annocumentService.getAnnouncementPKIdMap(pkid, (Object)"decision", sectionid);
                    if (map != null) {
                        FormShowParameter showParameter = new FormShowParameter();
                        showParameter.setFormId(this.getOpenFormId("announcement_preview"));
                        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        showParameter.setStatus(OperationStatus.VIEW);
                        showParameter.setCustomParam("annomap", (Object)map);
                        showParameter.setCustomParam("attachformid", (Object)this.getOpenFormId("announcement"));
                        if (parameter.getCustomParam("purtype") != null) {
                            showParameter.setCustomParam("purtype", parameter.getCustomParam("purtype"));
                        }
                        this.getView().showForm(showParameter);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u7f16\u5236\u4e2d\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidDecisionListUI_25", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                } else if (operType != null && operType.equals("revokedescanno")) {
                    String billStatus = this.annocumentService.getBillStatus(pkid, (Object)"decision", sectionid);
                    if (billStatus != null) {
                        if (billStatus.equals(BillStatusEnum.RELEASED.getVal())) {
                            this.annocumentService.changeAnnoStatusToA(pkid, (Object)"decision", sectionid);
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u4e2d\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidDecisionListUI_29", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u4e2d\u6807\u516c\u544a\uff0c\u65e0\u9700\u64a4\u9500\u3002", (String)"BidDecisionListUI_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        }
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u4e2d\u6807\u516c\u544a\uff0c\u65e0\u9700\u64a4\u9500\u3002", (String)"BidDecisionListUI_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        } else if (returnmap != null && FormTypeConstants.getFormConstant((String)"selectsection", ((Object)((Object)this)).getClass()).equals(closedCallBackEvent.getActionId())) {
            this.openSonPage(returnmap);
        }
    }

    protected void openSonPage(Map<String, Object> returnmap) {
        long decisionId = (Long)this.getSelectedRows().get(0).getPrimaryKeyValue();
        DynamicObject decision = BusinessDataServiceHelper.loadSingle((Object)decisionId, (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        String noticeOrLetter = returnmap.get("noticeOrLetter").toString();
        String sectionId = returnmap.get("sectionId").toString();
        BillShowParameter billShowParameter = new BillShowParameter();
        DynamicObject bidProject = decision.getDynamicObject("bidproject");
        String tips = "notice".equals(noticeOrLetter) ? ResManager.loadKDString((String)"\u4e2d\u6807\u901a\u77e5\u4e66", (String)"BidDecisionListUI_18", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u611f\u8c22\u4fe1", (String)"BidDecisionListUI_19", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        String entityTypeId = "notice".equals(noticeOrLetter) ? FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()) : FormTypeConstants.getFormConstant((String)"thanksletter", ((Object)((Object)this)).getClass());
        DynamicObjectCollection section = decision.getDynamicObjectCollection("bidsection");
        String sectionName = null;
        for (DynamicObject row : section) {
            QFilter decisitionSectionFilter;
            QFilter projectFilter;
            DynamicObject winnotice;
            boolean isSend;
            if (!sectionId.equals(row.getString("id"))) continue;
            sectionName = row.getString("sectionname");
            boolean bl = isSend = "notice".equals(noticeOrLetter) ? row.getBoolean("issendwinnotice") : row.getBoolean("issendthanksletter");
            if (isSend) {
                String bidDecisionListUI_20 = String.format(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u4e0d\u5b58\u5728\u672a\u53d1\u5e03%1$s\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u3002", (String)"BidDecisionListUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]), tips);
                this.getView().showTipNotification(bidDecisionListUI_20);
                return;
            }
            if (!"notice".equals(noticeOrLetter)) {
                boolean flag = true;
                DynamicObjectCollection supplierentry = row.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierRow : supplierentry) {
                    boolean isrecommended = supplierRow.getBoolean("isrecommended");
                    if (isrecommended) continue;
                    flag = false;
                }
                if (flag) {
                    String bidDecisionListUI_20 = String.format(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u4e0d\u5b58\u5728\u672a\u53d1\u5e03%1$s\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u3002", (String)"BidDecisionListUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]), tips);
                    this.getView().showTipNotification(bidDecisionListUI_20);
                    return;
                }
            }
            billShowParameter.setFormId(entityTypeId);
            billShowParameter.setStatus(OperationStatus.EDIT);
            billShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u53d1\u9001%1$s", (String)"BidDecisionListUI_63", (String)"scm-bid-formplugin", (Object[])new Object[0]), tips));
            Object id = null;
            if (bidProject != null && (winnotice = QueryServiceHelper.queryOne((String)entityTypeId, (String)"id", (QFilter[])new QFilter[]{projectFilter = new QFilter("bidproject.id", "=", (Object)bidProject.getLong("id")), decisitionSectionFilter = new QFilter("decisionsectionid", "=", (Object)Long.parseLong(sectionId))})) != null) {
                id = winnotice.get("id");
            }
            billShowParameter.setPkId(id);
        }
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setCustomParam("sectionId", (Object)sectionId);
        billShowParameter.setCustomParam("bidDecisionId", (Object)decisionId);
        billShowParameter.setCustomParam("sectionName", (Object)sectionName);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "projectprocess": {
                return "bid_projectprocess";
            }
            case "announcement": {
                return "bid_decisionannouncement";
            }
            case "announcement_preview": {
                return "bid_announcement_preview";
            }
            case "annosection": {
                return "bid_annosection";
            }
        }
        return null;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList view = (BillList)this.getView().getControl("billlistap");
        String appId = ((BillEntityType)view.getEntityType()).getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"releasedescacco"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"releasedescacco"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        filters.add(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()));
        super.setFilter(e);
    }
}

