/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.CommonUtil;

public class BidDecisionWinListFormPlugin
extends AbstractListPlugin {
    public static IBidProjectService projectService = new BidProjectServiceImpl();

    public void initialize() {
        super.initialize();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        String formId = list.getBillFormId();
        String ObjectId = "";
        String bidFormId = "";
        if (formId.contains("bid")) {
            ObjectId = "bid_decisionwinning";
            bidFormId = "bid_project";
        } else {
            ObjectId = "rebm_decisionwinning";
            bidFormId = "rebm_project";
        }
        Set<Long> preuserness = this.getPreusernessForId(bidFormId, formId.split("_")[0]);
        ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
        Object bidDecisionWinId = sr.getPrimaryKeyValue();
        if (bidDecisionWinId != null) {
            DynamicObject bidproject = null;
            DynamicObject decisionwinning = BusinessDataServiceHelper.loadSingle((Object)bidDecisionWinId, (String)ObjectId);
            if (decisionwinning != null) {
                bidproject = decisionwinning.getDynamicObject("bidproject");
            }
            if (bidproject != null && !preuserness.contains(Long.valueOf(bidproject.getPkValue().toString()))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u62db\u6807\u7acb\u9879\u7684\u4e1a\u52a1\u7ecf\u529e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidDecisionWinListFormPlugin_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        BillList list = (BillList)e.getSource();
        String formId = list.getBillFormId();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object supperid = customParams.get("supperid");
        List allFilters = e.getQFilters();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            QFilter filters = new QFilter("bidsection.supplierentry.supplier", "=", supperid).and("bidsection.supplierentry.isrecommended", "=", (Object)Boolean.TRUE);
            allFilters.add(filters);
        }
        for (QFilter qFilter : allFilters) {
            String property = qFilter.getProperty();
            if (!"billstatus".equals(property)) continue;
            qFilter.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.SIGNED.getVal())).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.PARTSIGNED.getVal()));
        }
    }

    public Set<Long> getPreusernessForId(String formId, String appId) {
        String userId = RequestContext.get().getUserId();
        boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            Set bidProIds = projectService.generatorPermissionFilter((Object)userId, "08");
            Set<Long> collect = bidProIds.stream().map(item -> Long.parseLong(item)).collect(Collectors.toSet());
            return collect;
        }
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)formId, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)-1)});
        return Arrays.stream(loads).map(load -> load.getLong("id")).collect(Collectors.toSet());
    }

    public String getBidAdminRoleID(String appId) {
        if (appId.contains("bid")) {
            return "/FFXFSRKI73+";
        }
        return "/V6OAY0JH+8R";
    }

    class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection data = super.getData(start, limit);
            if (data == null || data.size() < 1) {
                return data;
            }
            for (DynamicObject row : data) {
                row.set("bidsection.supplierentry.finaltaxrate", (Object)row.getBigDecimal("bidsection.supplierentry.finaltaxrate").multiply(new BigDecimal(100)));
            }
            return data;
        }
    }
}

