/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import com.google.common.collect.HashBasedTable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidEvalMethodEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.util.BidDarkUtil;
import kd.scm.bid.formplugin.bill.util.BidEvaluationUtil;

public class BidEvaluationEditUI
extends AbstractFormPlugin
implements RowClickEventListener,
SelectRowsEventListener {
    private IBidOpenService bidOpenService = new BidOpenServiceImpl();
    private static Log logger = LogFactory.getLog(BidEvaluationEditUI.class);

    public void beforeBindData(EventObject e) {
        this.calculateRank();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        AbstractOperate cotrol = (AbstractOperate)event.getSource();
        String operateKey = cotrol.getOperateKey();
        if (operateKey.equals("refresh")) {
            this.getView().getPageCache().put("isRefresh", "true");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        boolean success;
        OperationResult operationResult = event.getOperationResult();
        String operateKey = event.getOperateKey();
        if ((operateKey.equals("save") || operateKey.equals("submit") || operateKey.equals("audit") || operateKey.equals("unaudit")) && (success = operationResult.isSuccess())) {
            logger.info("SAVERanking\uff01");
        }
    }

    public void calculateRank() {
        DynamicObject bidprojectInfo;
        String doctype;
        DynamicObject bidEvaluation = this.getModel().getDataEntity();
        Long bidopenId = Long.parseLong(this.getModel().getValue("bidopenid").toString());
        String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
        DynamicObject bidOpen = this.bidOpenService.getBidOpenByIdAndType(bidopenId, serviceAppId);
        String evaltype = bidEvaluation.getString("evaltype");
        String evalMethod = bidOpen.getString("evaluatedmethod");
        DynamicObjectCollection bidsection_DOC = bidOpen.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection bidsectionenrollCol = bidEvaluation.getDynamicObjectCollection("bidsectionenroll");
        HashMap mapCandidate = new HashMap();
        HashBasedTable darkTable = HashBasedTable.create();
        if (BidDarkUtil.isDarkEvaluation((String)serviceAppId, (Object)bidopenId, (String)evaltype)) {
            darkTable = BidDarkUtil.getEvaluationDark((String)serviceAppId, (Object)bidopenId);
            this.getView().setVisible(Boolean.FALSE, new String[]{"suppliername"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"suppliername_dark"});
        }
        if (bidsectionenrollCol != null && bidsectionenrollCol.size() > 0) {
            for (DynamicObject bidSectionenroll_DO : bidsectionenrollCol) {
                HashMap map = new HashMap();
                DynamicObjectCollection bidevalResult_DOC = bidSectionenroll_DO.getDynamicObjectCollection("bidevalresult");
                for (DynamicObject bidevalResult_DOCC : bidevalResult_DOC) {
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    map1.put("supplier", bidevalResult_DOCC.getDynamicObject("supplier"));
                    map1.put("suppliername", bidevalResult_DOCC.getString("supplierName"));
                    map1.put("suppliername_dark", bidevalResult_DOCC.getString("supplierName_dark"));
                    map1.put("suppliernumber", bidevalResult_DOCC.getString("supplierNumber"));
                    map1.put("candidate", bidevalResult_DOCC.getBoolean("candidate"));
                    map1.put("remark", bidevalResult_DOCC.getString("remark"));
                    map.put(bidevalResult_DOCC.getDynamicObject("supplier").getLong("id"), map1);
                }
                mapCandidate.put(bidSectionenroll_DO.getLong("opensectid"), map);
            }
        }
        if (bidsectionenrollCol != null && bidsectionenrollCol.size() > 0) {
            bidsectionenrollCol.clear();
        }
        String evalType = bidEvaluation.getString("evaltype");
        String techEvalResult = ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807\u4e0d\u5408\u683c\u3002", (String)"BidEvaluationEditUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        String busEvalResult = ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807\u4e0d\u5408\u683c\u3002", (String)"BidEvaluationEditUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        HashMap mapSupplier = new HashMap();
        for (DynamicObject bidsection_DO : bidsection_DOC) {
            Map map;
            ArrayList list;
            DynamicObject bidprojectInfo2;
            String doctype2;
            long opensectid;
            Map candidateMap;
            Map map2;
            Map<String, Integer> map3;
            DynamicObject bidSectionenroll_DO = bidsectionenrollCol.addNew();
            String sectionName = bidsection_DO.getString("sectionname");
            bidSectionenroll_DO.set("sectname", (Object)sectionName);
            bidSectionenroll_DO.set("opensectid", (Object)bidsection_DO.getLong("id"));
            DynamicObjectCollection bidevalResult_DOC = bidSectionenroll_DO.getDynamicObjectCollection("bidevalresult");
            DynamicObjectCollection supplierEntry_DOC = bidsection_DO.getDynamicObjectCollection("supplierentry");
            mapSupplier.clear();
            for (DynamicObject supplierEntry_DO : supplierEntry_DOC) {
                BigDecimal tenderPrice;
                DynamicObject supplier;
                boolean isTender = supplierEntry_DO.getBoolean("supplier_istender");
                boolean isOut = supplierEntry_DO.getBoolean("supplier_isinvalid");
                boolean isOuts = supplierEntry_DO.getBoolean("evalsupplierinvalid");
                String evalResult = supplierEntry_DO.getString("supplier_invalidreason");
                if ("MULTI".equals(evalType)) {
                    if ((!isTender || isOut) && (!isTender || !isOut || !isOuts)) continue;
                    supplier = supplierEntry_DO.getDynamicObject("supplier");
                    tenderPrice = supplierEntry_DO.getBigDecimal("supplier_tenderprice");
                    map3 = new HashMap<String, Object>();
                    map3.put("tenderPrice", (Integer)((Object)tenderPrice));
                    map3.put("costrate_rel", (Integer)supplierEntry_DO.get("supplier_rate"));
                    map3.put("supplier", (Integer)supplier);
                    map3.put("supplierNumber", (Integer)supplier.get("number"));
                    map3.put("supplierName", (Integer)supplier.get("name"));
                    map3.put("supplierName_dark", (Integer)darkTable.get((Object)sectionName, supplier.getPkValue()));
                    mapSupplier.put(supplier.getPkValue(), map3);
                    continue;
                }
                if ("BUSSINESS".equals(evalType)) {
                    if ((!isTender || isOut) && (!isTender || !isOut || !isOuts || techEvalResult.equals(evalResult))) continue;
                    supplier = supplierEntry_DO.getDynamicObject("supplier");
                    tenderPrice = supplierEntry_DO.getBigDecimal("supplier_tenderprice");
                    map3 = new HashMap();
                    map3.put("tenderPrice", (Integer)((Object)tenderPrice));
                    map3.put("costrate_rel", (Integer)supplierEntry_DO.get("supplier_rate"));
                    map3.put("supplier", (Integer)supplier);
                    map3.put("supplierNumber", (Integer)supplier.get("number"));
                    map3.put("supplierName", (Integer)supplier.get("name"));
                    map3.put("supplierName_dark", (Integer)darkTable.get((Object)sectionName, supplier.getPkValue()));
                    mapSupplier.put(supplier.getPkValue(), map3);
                    continue;
                }
                if (!"TECHNICAL".equals(evalType) || (!isTender || isOut) && (!isTender || !isOut || !isOuts || busEvalResult.equals(evalResult))) continue;
                supplier = supplierEntry_DO.getDynamicObject("supplier");
                tenderPrice = supplierEntry_DO.getBigDecimal("supplier_tenderprice");
                map3 = new HashMap();
                map3.put("tenderPrice", (Integer)((Object)tenderPrice));
                map3.put("costrate_rel", (Integer)supplierEntry_DO.get("supplier_rate"));
                map3.put("supplier", (Integer)supplier);
                map3.put("supplierNumber", (Integer)supplier.get("number"));
                map3.put("supplierName", (Integer)supplier.get("name"));
                map3.put("supplierName_dark", (Integer)darkTable.get((Object)sectionName, supplier.getPkValue()));
                mapSupplier.put(supplier.getPkValue(), map3);
            }
            DynamicObjectCollection tenderGradingDetailLoadArray = QueryServiceHelper.query((String)"bid_tendergradingdetail", (String)"evaluationid,opensectionid,supplierid,techevalresult,busevalresult", (QFilter[])new QFilter[]{new QFilter("evaluationid", "=", bidEvaluation.getPkValue())});
            for (int i = 0; i < tenderGradingDetailLoadArray.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)tenderGradingDetailLoadArray.get(i);
                if (!dynamicObject.get("opensectionid").equals(bidsection_DO.getPkValue()) || !mapSupplier.containsKey(dynamicObject.get("supplierid"))) continue;
                Map map4 = (Map)mapSupplier.get(dynamicObject.get("supplierid"));
                map4.put("techevalresult", dynamicObject.get("techevalresult"));
                map4.put("busevalresult", dynamicObject.get("busevalresult"));
            }
            BigDecimal techweight = (BigDecimal)bidEvaluation.get("techweight");
            BigDecimal commweight = (BigDecimal)bidEvaluation.get("commweight");
            BizLog.log((String)(ResManager.loadKDString((String)"\u8bc4\u6807\u7ed3\u679c\uff1a", (String)"BidEvaluationEditUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]) + bidsection_DO.getString("sectionname")));
            String scoreDetailSelectFields = "id,entryseq,technical,commercial,proficient,proficient.id,section.id,proficient.name,proficient.majortypenames,supplier.id,bidevaluationentry.supplier.id,bidevaluationentry.supplier.number,bidevaluationentry.supplier.name,commercialscore,technicalscore,bidevaluation.evaltype,bidevaluation.bidproject.id,bidevaluation.bidproject.bidopentype";
            QFilter filters = new QFilter("bidevaluation.id", "=", bidEvaluation.getPkValue());
            filters.and(new QFilter("section.sectionname", "=", (Object)bidsection_DO.getString("sectionname")));
            DynamicObjectCollection bidEvalScoreDetailColl = QueryServiceHelper.query((String)"bid_bidevalscoredetail", (String)scoreDetailSelectFields, (QFilter[])new QFilter[]{filters});
            if (bidEvalScoreDetailColl != null && bidEvalScoreDetailColl.size() > 0) {
                for (int i = 0; i < bidEvalScoreDetailColl.size(); ++i) {
                    BigDecimal commercialscore;
                    DynamicObject dynamicObject = (DynamicObject)bidEvalScoreDetailColl.get(i);
                    if (!mapSupplier.containsKey(dynamicObject.get("supplier.id"))) continue;
                    map3 = (Map)mapSupplier.get(dynamicObject.get("supplier.id"));
                    BigDecimal technicalscore = dynamicObject.getBigDecimal("technicalscore");
                    if (technicalscore != null && technicalscore.compareTo(BigDecimal.ZERO) != 0) {
                        if (map3.get("technicalCount") != null) {
                            map3.put("technicalCount", Integer.parseInt(map3.get("technicalCount").toString()) + 1);
                            map3.put("technicalscore", (Integer)((Object)technicalscore.add((BigDecimal)map3.get("technicalscore"))));
                        } else {
                            map3.put("technicalCount", 1);
                            map3.put("technicalscore", (Integer)((Object)technicalscore));
                        }
                    }
                    if ((commercialscore = dynamicObject.getBigDecimal("commercialscore")) == null || commercialscore.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (map3.get("commercialCount") != null) {
                        map3.put("commercialCount", Integer.parseInt(map3.get("commercialCount").toString()) + 1);
                        map3.put("commercialscore", (Integer)((Object)commercialscore.add((BigDecimal)map3.get("commercialscore"))));
                        continue;
                    }
                    map3.put("commercialCount", 1);
                    map3.put("commercialscore", (Integer)((Object)commercialscore));
                }
            }
            for (Map map5 : mapSupplier.values()) {
                BigDecimal technicalavgScore = BigDecimal.ZERO;
                if (map5.get("technicalCount") != null) {
                    int technicalCount = Integer.parseInt(map5.get("technicalCount").toString());
                    BigDecimal technicalscore = (BigDecimal)map5.get("technicalscore");
                    technicalavgScore = technicalscore.divide(new BigDecimal(technicalCount), 2);
                    map5.put("technicalscore", technicalavgScore);
                } else {
                    map5.put("technicalscore", BigDecimal.ZERO);
                }
                BigDecimal commercialavgScore = BigDecimal.ZERO;
                if (map5.get("commercialCount") != null) {
                    int commercialCount = Integer.parseInt(map5.get("commercialCount").toString());
                    BigDecimal commercialscore = (BigDecimal)map5.get("commercialscore");
                    commercialavgScore = commercialscore.divide(new BigDecimal(commercialCount), 2);
                    map5.put("commercialscore", commercialavgScore);
                } else {
                    map5.put("commercialscore", BigDecimal.ZERO);
                }
                boolean isonlineeval = bidOpen.getBoolean("isonlineeval");
                String scoretype = bidOpen.getString("scoretype");
                if (isonlineeval && scoretype.equals("sum")) {
                    map5.put("comprehensivescore", technicalavgScore.add(commercialavgScore));
                    continue;
                }
                map5.put("comprehensivescore", technicalavgScore.multiply(techweight).add(commercialavgScore.multiply(commweight)));
            }
            DynamicObject[] clarifyDataArray = this.getQuestionClarify(bidEvaluation.getPkValue());
            if (clarifyDataArray != null && clarifyDataArray.length > 0) {
                for (int j = 0; j < clarifyDataArray.length; ++j) {
                    DynamicObject clarifyData = clarifyDataArray[j];
                    DynamicObjectCollection clarifyBidSectionCol = clarifyData.getDynamicObjectCollection("bidsection");
                    for (DynamicObject clarifyBidSection : clarifyBidSectionCol) {
                        String clarifySectionName = clarifyBidSection.getString("sectionname");
                        if (!bidsection_DO.getString("sectionname").equals(clarifySectionName)) continue;
                        DynamicObjectCollection clarifySupplierDetailCol = clarifyBidSection.getDynamicObjectCollection("supplierdetail");
                        int size = clarifySupplierDetailCol.size();
                        for (int i = 0; i < clarifySupplierDetailCol.size(); ++i) {
                            DynamicObject supplierDetail = (DynamicObject)clarifySupplierDetailCol.get(i);
                            DynamicObject supplier = supplierDetail.getDynamicObject("pursupplier");
                            if (!mapSupplier.containsKey(supplier.getPkValue())) continue;
                            map2 = (Map)mapSupplier.get(supplier.getPkValue());
                            BigDecimal tenderPrice = (BigDecimal)map2.get("tenderPrice");
                            if (i == 0) {
                                tenderPrice = BigDecimal.ZERO;
                            }
                            if (tenderPrice == null) {
                                map2.put("tenderPrice", supplierDetail.getBigDecimal("inclutaxamount"));
                                continue;
                            }
                            map2.put("tenderPrice", tenderPrice.add(supplierDetail.getBigDecimal("inclutaxamount")));
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Map)(candidateMap = (Map)mapCandidate.get(opensectid = bidSectionenroll_DO.getLong("opensectid"))))) {
                for (Map.Entry entry : candidateMap.entrySet()) {
                    Object key = entry.getKey();
                    Map map22 = (Map)mapSupplier.get(key);
                    if (CollectionUtils.isEmpty((Map)map22)) continue;
                    Map value = (Map)entry.getValue();
                    map22.put("candidate", value.get("candidate"));
                    map22.put("remark", value.get("remark"));
                }
            }
            final boolean isBussiness = BidEvaluationUtil.getIsBussiness(evalMethod, evaltype, bidEvaluation);
            if (!StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL.getCode()) && evaltype.equals("BUSSINESS") && (doctype2 = (bidprojectInfo2 = bidEvaluation.getDynamicObject("bidproject")).getString("doctype")) != null && !doctype2.equals("") && !doctype2.equals("BUSSINESS")) {
                Long technicalID = null;
                DynamicObjectCollection bidevaluationCollection = QueryServiceHelper.query((String)FormTypeConstants.getFormConstant((String)"bidevaluation", BidEvaluationEditUI.class), (String)"id,evaltype,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidprojectInfo2.getPkValue())});
                for (DynamicObject bidevaluationInfo : bidevaluationCollection) {
                    if (!bidevaluationInfo.getString("evaltype").equals("TECHNICAL") || !bidevaluationInfo.getString("billstatus").equals("C")) continue;
                    technicalID = bidevaluationInfo.getLong("id");
                }
                DynamicObjectCollection tenderGradingDetailLoadArray1 = QueryServiceHelper.query((String)"bid_tendergradingdetail", (String)"evaluationid,opensectionid,sectionname,supplierid,techevalresult,busevalresult", (QFilter[])new QFilter[]{new QFilter("evaluationid", "=", technicalID)});
                for (int i = 0; i < tenderGradingDetailLoadArray1.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)tenderGradingDetailLoadArray1.get(i);
                    if (!dynamicObject.get("sectionname").equals(bidsection_DO.getString("sectionname")) || !mapSupplier.containsKey(dynamicObject.get("supplierid"))) continue;
                    map2 = (Map)mapSupplier.get(dynamicObject.get("supplierid"));
                    map2.put("techevalresult", dynamicObject.get("techevalresult"));
                }
            }
            if (StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DX.getCode())) {
                list = new ArrayList(mapSupplier.entrySet());
                Collections.sort(list, new Comparator<Map.Entry<Object, Map<String, Object>>>(){

                    @Override
                    public int compare(Map.Entry<Object, Map<String, Object>> o1, Map.Entry<Object, Map<String, Object>> o2) {
                        Map<String, Object> map1 = o1.getValue();
                        Map<String, Object> map2 = o2.getValue();
                        BigDecimal tenderPrice1 = (BigDecimal)map1.get("tenderPrice");
                        BigDecimal tenderPrice2 = (BigDecimal)map2.get("tenderPrice");
                        String techevalresult1 = (String)map1.get("techevalresult");
                        String busevalresult1 = (String)map1.get("busevalresult");
                        String techevalresult2 = (String)map2.get("techevalresult");
                        String busevalresult2 = (String)map2.get("busevalresult");
                        if (tenderPrice1 == null) {
                            tenderPrice1 = BigDecimal.ZERO;
                        }
                        if (tenderPrice2 == null) {
                            tenderPrice2 = BigDecimal.ZERO;
                        }
                        if (techevalresult1 == null || techevalresult1.equals("")) {
                            techevalresult1 = "0";
                        }
                        if (techevalresult2 == null || techevalresult2.equals("")) {
                            techevalresult2 = "0";
                        }
                        if (busevalresult1 == null || busevalresult1.equals("")) {
                            busevalresult1 = "0";
                        }
                        if (busevalresult2 == null || busevalresult2.equals("")) {
                            busevalresult2 = "0";
                        }
                        if (isBussiness) {
                            if (busevalresult1.equals("0") && busevalresult2.equals("0")) {
                                return 0;
                            }
                            if (busevalresult1.equals("0") && busevalresult2.equals("1")) {
                                return 1;
                            }
                            if (busevalresult1.equals("1") && busevalresult2.equals("0")) {
                                return -1;
                            }
                            if (busevalresult1.equals("1") && busevalresult2.equals("1")) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                        } else {
                            if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                                return 0;
                            }
                            if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && techevalresult2.equals("1") && busevalresult2.equals("1")) {
                                return 1;
                            }
                            if (techevalresult1.equals("1") && busevalresult1.equals("1") && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                                return -1;
                            }
                            if (techevalresult1.equals("1") && busevalresult1.equals("1") && techevalresult2.equals("1") && busevalresult2.equals("1")) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                        }
                        return 0;
                    }
                });
                for (int i = 0; i < list.size(); ++i) {
                    map = (Map)((Map.Entry)list.get(i)).getValue();
                    DynamicObject bidevalResult_DOCC = bidevalResult_DOC.addNew();
                    bidevalResult_DOCC.set("supplier", map.get("supplier"));
                    bidevalResult_DOCC.set("suppliername", map.get("supplierName"));
                    bidevalResult_DOCC.set("suppliername_dark", map.get("supplierName_dark"));
                    bidevalResult_DOCC.set("suppliernumber", map.get("supplierNumber"));
                    bidevalResult_DOCC.set("technicalresult", map.get("techevalresult"));
                    bidevalResult_DOCC.set("commercialresult", map.get("busevalresult"));
                    bidevalResult_DOCC.set("tenderprice", map.get("tenderPrice"));
                    bidevalResult_DOCC.set("costrate_rel", map.get("costrate_rel"));
                    bidevalResult_DOCC.set("technicalscore", map.get("technicalscore"));
                    bidevalResult_DOCC.set("commercialscore", map.get("commercialscore"));
                    bidevalResult_DOCC.set("score", map.get("comprehensivescore"));
                    bidevalResult_DOCC.set("ranking", (Object)(i + 1));
                    bidevalResult_DOCC.set("candidate", map.get("candidate"));
                    bidevalResult_DOCC.set("remark", map.get("remark"));
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"technicalscore", "commercialscore", "score"});
                if (!isBussiness) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{"technicalresult"});
                continue;
            }
            if (StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL.getCode())) {
                list = new ArrayList(mapSupplier.entrySet());
                Collections.sort(list, new Comparator<Map.Entry<Object, Map<String, Object>>>(){

                    @Override
                    public int compare(Map.Entry<Object, Map<String, Object>> o1, Map.Entry<Object, Map<String, Object>> o2) {
                        DynamicObject evaobject;
                        Map<String, Object> map1 = o1.getValue();
                        Map<String, Object> map2 = o2.getValue();
                        BigDecimal comprehensivescore1 = (BigDecimal)map1.get("comprehensivescore");
                        BigDecimal comprehensivescore2 = (BigDecimal)map2.get("comprehensivescore");
                        BigDecimal tenderPrice1 = (BigDecimal)map1.get("tenderPrice");
                        BigDecimal tenderPrice2 = (BigDecimal)map2.get("tenderPrice");
                        if (tenderPrice1 == null) {
                            tenderPrice1 = BigDecimal.ZERO;
                        }
                        if (tenderPrice2 == null) {
                            tenderPrice2 = BigDecimal.ZERO;
                        }
                        if (comprehensivescore1 == null) {
                            comprehensivescore1 = BigDecimal.ZERO;
                        }
                        if (comprehensivescore2 == null) {
                            comprehensivescore2 = BigDecimal.ZERO;
                        }
                        if ((evaobject = BidEvaluationEditUI.this.getModel().getDataEntity(true).getDynamicObject("evaluatedecideway")) != null) {
                            String evaname = evaobject.getString("name");
                            Long typeId = evaobject.getLong("id");
                            if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                        }
                        if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                            return tenderPrice1.compareTo(tenderPrice2);
                        }
                        return comprehensivescore2.compareTo(comprehensivescore1);
                    }
                });
                for (int i = 0; i < list.size(); ++i) {
                    map = (Map)((Map.Entry)list.get(i)).getValue();
                    DynamicObject bidevalResult_DOCC = bidevalResult_DOC.addNew();
                    bidevalResult_DOCC.set("supplier", map.get("supplier"));
                    bidevalResult_DOCC.set("suppliername", map.get("supplierName"));
                    bidevalResult_DOCC.set("suppliername_dark", map.get("supplierName_dark"));
                    bidevalResult_DOCC.set("suppliernumber", map.get("supplierNumber"));
                    bidevalResult_DOCC.set("technicalresult", map.get("techevalresult"));
                    bidevalResult_DOCC.set("commercialresult", map.get("busevalresult"));
                    bidevalResult_DOCC.set("tenderprice", map.get("tenderPrice"));
                    bidevalResult_DOCC.set("costrate_rel", map.get("costrate_rel"));
                    bidevalResult_DOCC.set("technicalscore", map.get("technicalscore"));
                    bidevalResult_DOCC.set("commercialscore", map.get("commercialscore"));
                    bidevalResult_DOCC.set("score", map.get("comprehensivescore"));
                    bidevalResult_DOCC.set("ranking", (Object)(i + 1));
                    bidevalResult_DOCC.set("candidate", map.get("candidate"));
                    bidevalResult_DOCC.set("remark", map.get("remark"));
                }
                if (!StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL.getCode())) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{"technicalresult", "commercialresult"});
                continue;
            }
            if (!StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL_DX.getCode())) continue;
            list = new ArrayList(mapSupplier.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<Object, Map<String, Object>>>(){

                @Override
                public int compare(Map.Entry<Object, Map<String, Object>> o1, Map.Entry<Object, Map<String, Object>> o2) {
                    Map<String, Object> map1 = o1.getValue();
                    Map<String, Object> map2 = o2.getValue();
                    BigDecimal comprehensivescore1 = (BigDecimal)map1.get("comprehensivescore");
                    BigDecimal comprehensivescore2 = (BigDecimal)map2.get("comprehensivescore");
                    String techevalresult1 = (String)map1.get("techevalresult");
                    String busevalresult1 = (String)map1.get("busevalresult");
                    String techevalresult2 = (String)map2.get("techevalresult");
                    String busevalresult2 = (String)map2.get("busevalresult");
                    BigDecimal tenderPrice1 = (BigDecimal)map1.get("tenderPrice");
                    BigDecimal tenderPrice2 = (BigDecimal)map2.get("tenderPrice");
                    if (tenderPrice1 == null) {
                        tenderPrice1 = BigDecimal.ZERO;
                    }
                    if (tenderPrice2 == null) {
                        tenderPrice2 = BigDecimal.ZERO;
                    }
                    if (comprehensivescore1 == null) {
                        comprehensivescore1 = BigDecimal.ZERO;
                    }
                    if (comprehensivescore2 == null) {
                        comprehensivescore2 = BigDecimal.ZERO;
                    }
                    if (techevalresult1 == null || techevalresult1.equals("")) {
                        techevalresult1 = "0";
                    }
                    if (techevalresult2 == null || techevalresult2.equals("")) {
                        techevalresult2 = "0";
                    }
                    if (busevalresult1 == null || busevalresult1.equals("")) {
                        busevalresult1 = "0";
                    }
                    if (busevalresult2 == null || busevalresult2.equals("")) {
                        busevalresult2 = "0";
                    }
                    if (isBussiness) {
                        if (busevalresult1.equals("0") && busevalresult2.equals("0")) {
                            return 0;
                        }
                        if (busevalresult1.equals("0") && busevalresult2.equals("1")) {
                            return 1;
                        }
                        if (busevalresult1.equals("1") && busevalresult2.equals("0")) {
                            return -1;
                        }
                        if (busevalresult1.equals("1") && busevalresult2.equals("1")) {
                            return tenderPrice1.compareTo(tenderPrice2);
                        }
                    } else {
                        if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                            return comprehensivescore2.compareTo(comprehensivescore1);
                        }
                        if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && techevalresult2.equals("1") && busevalresult2.equals("1")) {
                            return 1;
                        }
                        if (techevalresult1.equals("1") && busevalresult1.equals("1") && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                            return -1;
                        }
                        if (techevalresult1.equals("1") && busevalresult1.equals("1") && (techevalresult2.equals("1") || busevalresult2.equals("1"))) {
                            DynamicObject evaobject = BidEvaluationEditUI.this.getModel().getDataEntity(true).getDynamicObject("evaluatedecideway");
                            if (evaobject != null) {
                                String evaname = evaobject.getString("name");
                                Long typeId = evaobject.getLong("id");
                                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                                    return tenderPrice1.compareTo(tenderPrice2);
                                }
                            }
                            if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                            return comprehensivescore2.compareTo(comprehensivescore1);
                        }
                    }
                    return 0;
                }
            });
            for (int i = 0; i < list.size(); ++i) {
                map = (Map)((Map.Entry)list.get(i)).getValue();
                DynamicObject bidevalResult_DOCC = bidevalResult_DOC.addNew();
                bidevalResult_DOCC.set("supplier", map.get("supplier"));
                bidevalResult_DOCC.set("suppliername", map.get("supplierName"));
                bidevalResult_DOCC.set("suppliername_dark", map.get("supplierName_dark"));
                bidevalResult_DOCC.set("suppliernumber", map.get("supplierNumber"));
                bidevalResult_DOCC.set("technicalresult", map.get("techevalresult"));
                bidevalResult_DOCC.set("commercialresult", map.get("busevalresult"));
                bidevalResult_DOCC.set("tenderprice", map.get("tenderPrice"));
                bidevalResult_DOCC.set("costrate_rel", map.get("costrate_rel"));
                bidevalResult_DOCC.set("technicalscore", map.get("technicalscore"));
                bidevalResult_DOCC.set("commercialscore", map.get("commercialscore"));
                bidevalResult_DOCC.set("score", map.get("comprehensivescore"));
                bidevalResult_DOCC.set("ranking", (Object)(i + 1));
                bidevalResult_DOCC.set("candidate", map.get("candidate"));
                bidevalResult_DOCC.set("remark", map.get("remark"));
            }
            if (!StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL.getCode())) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{"technicalresult", "commercialresult"});
        }
        this.setTechnicalResultVisible(bidEvaluation, evaltype, evalMethod);
        if (bidsection_DOC.size() == 1) {
            SplitContainer splitCon = (SplitContainer)this.getView().getControl("splitcontainerap");
            splitCon.changeFlexStatus(SplitDirection.left, true);
        }
        if ((doctype = (bidprojectInfo = bidEvaluation.getDynamicObject("bidproject")).getString("doctype")) != null && !doctype.equals("") && doctype.equals("BUSSINESS")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"technicalscore"});
        }
        if (evaltype.equals("TECHNICAL")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap2"});
            return;
        }
    }

    public void setTechnicalResultVisible(DynamicObject bidEvaluation, String evaltype, String evalMethod) {
        DynamicObject bidProject = bidEvaluation.getDynamicObject("bidproject");
        String doctype = bidProject.getString("doctype");
        if (StringUtils.equals((CharSequence)evaltype, (CharSequence)"BUSSINESS") && StringUtils.isNotEmpty((CharSequence)doctype) && StringUtils.equals((CharSequence)doctype, (CharSequence)"BUSSINESS") && !StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL.getCode())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"technicalresult"});
        }
        if (StringUtils.equals((CharSequence)evaltype, (CharSequence)"BUSSINESS") && StringUtils.isNotEmpty((CharSequence)doctype) && StringUtils.equals((CharSequence)doctype, (CharSequence)"MULTI")) {
            if (!StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL.getCode())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"technicalresult"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"technicalresult"});
            }
        }
    }

    public DynamicObject[] getQuestionClarify(Object bidEvaluationId) {
        QFilter clarifyTypeFilter = null;
        clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()).or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()));
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
        QFilter reSubMissTendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        QFilter bidEvaluationFilter = new QFilter("bidevaluationid", "=", bidEvaluationId);
        StringBuilder selectProper = new StringBuilder("id,submitdate,tenderprice,pricevat,tax,notaxtenderprice,rate,bidsection,bidsection.sectionname,clarifysupplier,clarifytype,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate,supplierdetail.bd_taxrate");
        DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)(((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2] + "_questionclarify"), (String)selectProper.toString(), (QFilter[])new QFilter[]{bidEvaluationFilter, billStatusFilter, clarifyTypeFilter, reSubMissTendersFilter}, (String)"submitdate asc");
        return dataArray;
    }
}

