/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.ScoreMethod;
import kd.scm.bid.common.enums.ScoreType;

public class BidEvaluationScoreList
extends AbstractListPlugin {
    protected IBidEvaluationService bidEvaluationService = new BidEvaluationServiceImpl();

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("submit".equals(operateKey)) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            Object primaryKeyValue = listSelectedData.get(0).getPrimaryKeyValue();
            DynamicObject evalProject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bid_bidevaluation");
            ArrayList scoreDetailDataList = new ArrayList();
            ArrayList entryDataList = new ArrayList();
            DynamicObjectCollection sectionColl = evalProject.getDynamicObjectCollection("bidsection");
            sectionColl.stream().forEach(section -> {
                Object secondSectionId = this.getSecondSectionId(evalProject, (DynamicObject)section);
                List<HashMap<String, Object>> scoreDetailByDataBaseList = this.getScoreDetailByDataBase(secondSectionId, (DynamicObject)section);
                scoreDetailDataList.addAll(scoreDetailByDataBaseList);
                entryDataList.addAll(this.calcTotalRow(scoreDetailByDataBaseList, evalProject, (DynamicObject)section, secondSectionId));
            });
            if (!scoreDetailDataList.isEmpty()) {
                this.bidEvaluationService.saveSupplierScoreDetail(scoreDetailDataList, entryDataList);
            }
        }
    }

    protected List<HashMap<String, Object>> getScoreDetailByDataBase(Object secondSectionId, DynamicObject section) {
        ArrayList<HashMap<String, Object>> rowMapList = new ArrayList<HashMap<String, Object>>();
        String scoreDetailSelectFields = "id,entryseq,technical,commercial,proficient.id,section.id,proficient.name,proficient.majortypenames,supplier.id,bidevaluationentry.supplier.id,bidevaluationentry.supplier.number,bidevaluationentry.supplier.name,commercialscore,technicalscore,bidevaluation.evaltype,bidevaluation.bidproject.id,bidevaluation.bidproject.bidopentype";
        DynamicObjectCollection bidEvalScoreDetailColl = this.bidEvaluationService.listBidEvalScoreDetailBySections(Long.valueOf(Long.parseLong(section.getPkValue().toString())), scoreDetailSelectFields);
        if (null != secondSectionId) {
            StringBuilder ids = new StringBuilder();
            for (DynamicObject bidEvalThere : bidEvalScoreDetailColl) {
                Object thereSupplierId = bidEvalThere.get("supplier.id");
                ids.append(thereSupplierId);
            }
            DynamicObjectCollection bidEvalScoreDetailCollSecondSection = this.bidEvaluationService.listBidEvalScoreDetailBySections(Long.valueOf(Long.parseLong(secondSectionId.toString())), scoreDetailSelectFields);
            if (!CollectionUtils.isEmpty((Collection)bidEvalScoreDetailCollSecondSection)) {
                Iterator it = bidEvalScoreDetailCollSecondSection.iterator();
                while (it.hasNext()) {
                    DynamicObject thisScore = (DynamicObject)it.next();
                    Object thisSupplierId = thisScore.get("supplier.id");
                    if (ids.toString().contains(thisSupplierId.toString())) continue;
                    it.remove();
                }
                bidEvalScoreDetailColl.addAll((Collection)bidEvalScoreDetailCollSecondSection);
            }
        }
        HashMap tempMap = new HashMap();
        if (bidEvalScoreDetailColl != null && bidEvalScoreDetailColl.size() > 0) {
            for (int i = 0; i < bidEvalScoreDetailColl.size(); ++i) {
                BigDecimal commercialscore;
                DynamicObject bidEvalScoreDetail = (DynamicObject)bidEvalScoreDetailColl.get(i);
                Object supplierId = bidEvalScoreDetail.get("bidevaluationentry.supplier.id");
                Long proficientId = bidEvalScoreDetail.getLong("proficient.id");
                String key = section.getPkValue() + "_" + proficientId + "_" + supplierId;
                HashMap<String, Object> rowDataMap = tempMap.getOrDefault(key, new HashMap());
                boolean technical = bidEvalScoreDetail.getBoolean("technical");
                boolean commercial = bidEvalScoreDetail.getBoolean("commercial");
                rowDataMap.put("proficientid", proficientId);
                rowDataMap.put("istechnical", technical);
                rowDataMap.put("iscommercial", commercial);
                rowDataMap.put("supplierid_", supplierId);
                if (null != secondSectionId) {
                    String evalType = bidEvalScoreDetail.getString("bidevaluation.evaltype");
                    if ("TECHNICAL".equals(evalType)) {
                        BigDecimal technicalscore = bidEvalScoreDetail.getBigDecimal("technicalscore");
                        rowDataMap.put("technical_", technicalscore);
                    } else {
                        commercialscore = bidEvalScoreDetail.getBigDecimal("commercialscore");
                        rowDataMap.put("commercial_", commercialscore);
                    }
                } else {
                    BigDecimal technicalscore = bidEvalScoreDetail.getBigDecimal("technicalscore");
                    rowDataMap.put("technical_", technicalscore);
                    commercialscore = bidEvalScoreDetail.getBigDecimal("commercialscore");
                    rowDataMap.put("commercial_", commercialscore);
                }
                rowDataMap.put("section", section.getPkValue());
                tempMap.put(key, rowDataMap);
            }
            rowMapList.addAll(tempMap.values());
        }
        return rowMapList;
    }

    protected List<HashMap<String, Object>> calcTotalRow(List<HashMap<String, Object>> scoreDetailByDataBaseList, DynamicObject evalProject, DynamicObject section, Object secondSectionId) {
        ArrayList<HashMap<String, Object>> supplierTotalSorceMap = new ArrayList<HashMap<String, Object>>(10);
        Map<Object, SupplierScore> supplierMap = this.sumSupplierSorce(scoreDetailByDataBaseList, evalProject, section, secondSectionId);
        BigDecimal techweight = evalProject.getBigDecimal("techweight");
        BigDecimal commweight = evalProject.getBigDecimal("commweight");
        String scoreMethod = evalProject.getString("scoremethod");
        String scoreType = evalProject.getString("scoretype");
        String evalType = evalProject.getString("evaltype");
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"bidopen_proficient,bidopen_proficient.proficient", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", evalProject.getDynamicObject("bidproject").getPkValue())});
        DynamicObjectCollection proficientList = bidOpen.getDynamicObjectCollection("bidopen_proficient");
        int proficientTotal = proficientList.size();
        for (Map.Entry<Object, SupplierScore> supplierEntry : supplierMap.entrySet()) {
            SupplierScore supplier = supplierEntry.getValue();
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal sumTechnicalSorce = supplier.getSumTechnicalSorce();
            BigDecimal sumCommercialSorce = supplier.getSumCommercialSorce();
            int technicalCount = supplier.getTechnicalCount();
            int commercialCount = supplier.getCommercialCount();
            if (technicalCount > 0 || commercialCount > 0) {
                BigDecimal sumCommercialSorceT;
                BigDecimal sumTechnicalSorceT;
                if (ScoreType.SUM.getVal().equals(scoreType)) {
                    sumTechnicalSorceT = sumTechnicalSorce;
                    sumCommercialSorceT = sumCommercialSorce;
                } else {
                    sumTechnicalSorceT = sumTechnicalSorce.multiply(techweight);
                    sumCommercialSorceT = sumCommercialSorce.multiply(commweight);
                }
                if (ScoreMethod.AVG_SCORE.getVal().equals(scoreMethod) || ScoreMethod.SPECIAL.getVal().equals(scoreMethod)) {
                    BigDecimal totalTechnicalSorce = technicalCount > 0 ? sumTechnicalSorceT.divide(new BigDecimal(technicalCount), 4, 4) : BigDecimal.ZERO;
                    BigDecimal totalCommercialSorce = commercialCount > 0 ? sumCommercialSorceT.divide(new BigDecimal(commercialCount), 4, 4) : BigDecimal.ZERO;
                    total = totalCommercialSorce.add(totalTechnicalSorce);
                    total = total.setScale(2, 4);
                } else if (ScoreMethod.TRUNC_AVG_SCORE.getVal().equals(scoreMethod)) {
                    if (proficientTotal != technicalCount || proficientTotal != commercialCount) {
                        BigDecimal maxTechnicalScore = supplier.getMaxTechnicalScore();
                        BigDecimal minTechnicalScore = supplier.getMinTechnicalScore();
                        BigDecimal totalTechnicalSorce = sumTechnicalSorce.subtract(maxTechnicalScore).subtract(minTechnicalScore);
                        BigDecimal maxCommercialScore = supplier.getMaxCommercialScore();
                        BigDecimal minCommercialScore = supplier.getMinCommercialScore();
                        BigDecimal totalCommercialSorce = sumCommercialSorce.subtract(maxCommercialScore).subtract(minCommercialScore);
                        if (ScoreType.SUM.getVal().equals(scoreType)) {
                            sumTechnicalSorceT = totalTechnicalSorce;
                            sumCommercialSorceT = totalCommercialSorce;
                        } else {
                            sumTechnicalSorceT = totalTechnicalSorce.multiply(techweight);
                            sumCommercialSorceT = totalCommercialSorce.multiply(commweight);
                        }
                        BigDecimal totalTechnicalSorceT = technicalCount - 2 > 0 ? sumTechnicalSorceT.divide(new BigDecimal(technicalCount - 2), 4, 4) : BigDecimal.ZERO;
                        BigDecimal totalCommercialSorceT = commercialCount - 2 > 0 ? sumCommercialSorceT.divide(new BigDecimal(commercialCount - 2), 4, 4) : BigDecimal.ZERO;
                        total = totalTechnicalSorceT.add(totalCommercialSorceT);
                        total = total.setScale(2, 4);
                    } else {
                        BigDecimal maxTotalScore = supplier.getMaxTotalScore();
                        BigDecimal minTotalScore = supplier.getMinTotalScore();
                        total = proficientTotal - 2 > 0 ? sumTechnicalSorceT.add(sumCommercialSorceT).subtract(maxTotalScore).subtract(minTotalScore).divide(new BigDecimal(technicalCount - 2), 4, 4) : BigDecimal.ZERO;
                        total = total.setScale(2, 4);
                    }
                }
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
            resultMap.put("section", section.getPkValue());
            resultMap.put("supplierid_", supplierEntry.getKey());
            resultMap.put("commercial_", total);
            supplierTotalSorceMap.add(resultMap);
        }
        return supplierTotalSorceMap;
    }

    protected Map<Object, SupplierScore> sumSupplierSorce(List<HashMap<String, Object>> scoreDetailByDataBaseList, DynamicObject evalProject, DynamicObject section, Object secondSectionId) {
        HashMap<Object, SupplierScore> supplierScoreMap = new HashMap<Object, SupplierScore>();
        BigDecimal techweight = evalProject.getBigDecimal("techweight");
        BigDecimal commweight = evalProject.getBigDecimal("commweight");
        String scoreType = evalProject.getString("scoretype");
        String selectFields = "id,entryseq,section.id,supplier.id,supplier.number,supplier.name,score";
        DynamicObjectCollection bidEvaluationEntryColl = this.bidEvaluationService.listBidEvalEntryBySections(Long.valueOf(Long.parseLong(section.getPkValue().toString())), selectFields);
        bidEvaluationEntryColl.forEach(bidEvaluationEntry -> {
            Long supplierId = bidEvaluationEntry.getLong("supplier.id");
            SupplierScore supplierScore = new SupplierScore();
            BigDecimal totalScore = BigDecimal.ZERO;
            for (Map scoreDetailByDataBase : scoreDetailByDataBaseList) {
                if (!scoreDetailByDataBase.get("supplierid_").equals(supplierId)) continue;
                Boolean technical = (Boolean)scoreDetailByDataBase.get("istechnical");
                Boolean commercial = (Boolean)scoreDetailByDataBase.get("iscommercial");
                BigDecimal technicalscore = scoreDetailByDataBase.getOrDefault("technical_", BigDecimal.ZERO);
                supplierScore.setSumTechnicalSorce(supplierScore.getSumTechnicalSorce().add(technicalscore));
                supplierScore.setTechnicalCount(supplierScore.getTechnicalCount() + 1);
                if (technicalscore.compareTo(supplierScore.getMaxTechnicalScore()) > 0) {
                    supplierScore.setMaxTechnicalScore(technicalscore);
                }
                if (technicalscore.compareTo(supplierScore.getMinTechnicalScore()) < 0) {
                    supplierScore.setMaxTechnicalScore(technicalscore);
                }
                BigDecimal commercialscore = scoreDetailByDataBase.getOrDefault("commercial_", BigDecimal.ZERO);
                supplierScore.setSumCommercialSorce(supplierScore.getSumCommercialSorce().add(commercialscore));
                supplierScore.setCommercialCount(supplierScore.getCommercialCount() + 1);
                if (commercialscore.compareTo(supplierScore.getMaxCommercialScore()) > 0) {
                    supplierScore.setMaxCommercialScore(commercialscore);
                }
                if (commercialscore.compareTo(supplierScore.getMinCommercialScore()) < 0) {
                    supplierScore.setMaxCommercialScore(commercialscore);
                }
                totalScore = ScoreType.SUM.getVal().equals(scoreType) ? totalScore.add(technicalscore).add(commercialscore) : totalScore.add(technicalscore.multiply(techweight)).add(commercialscore.multiply(commweight));
                if (supplierScore.getMaxTotalScore().compareTo(totalScore) < 0) {
                    supplierScore.setMaxTotalScore(totalScore);
                }
                if (supplierScore.getMinTotalScore().compareTo(totalScore) <= 0) continue;
                supplierScore.setMinTotalScore(totalScore);
            }
            supplierScoreMap.put(supplierId, supplierScore);
        });
        return supplierScoreMap;
    }

    protected Object getSecondSectionId(DynamicObject evalProject, DynamicObject section) {
        Object bidProjectId = evalProject.getDynamicObject("bidproject").getPkValue();
        String evalType = evalProject.getString("evaltype");
        Object evalPkValue = evalProject.getPkValue();
        String sectionName = section.getString("sectionname");
        DynamicObject[] evalObjectArr = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"bidsection,sectionname", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)});
        if (evalObjectArr.length > 1) {
            DynamicObject BidProject = evalProject.getDynamicObject("bidproject");
            String openType = BidProject.getString("bidopentype");
            Object secondSectionId = null;
            for (DynamicObject eval : evalObjectArr) {
                if (eval.getPkValue().equals(evalPkValue)) continue;
                DynamicObjectCollection thisBidSection = eval.getDynamicObjectCollection("bidsection");
                for (DynamicObject sectionNameAndId : thisBidSection) {
                    if (!StringUtils.equals((CharSequence)sectionName, (CharSequence)sectionNameAndId.getString("sectionname"))) continue;
                    secondSectionId = sectionNameAndId.getPkValue();
                }
            }
            if (openType.equals(BidOpenSelectTypeEnum.TECHBUSINESS.getValue()) && StringUtils.equals((CharSequence)"BUSSINESS", (CharSequence)evalType)) {
                return secondSectionId;
            }
            if (openType.equals(BidOpenSelectTypeEnum.BUSSINESSTECH.getValue()) && StringUtils.equals((CharSequence)"TECHNICAL", (CharSequence)evalType)) {
                return secondSectionId;
            }
        }
        return null;
    }

    protected static class SupplierScore {
        private BigDecimal sumCommercialSorce = BigDecimal.ZERO;
        private BigDecimal sumTechnicalSorce = BigDecimal.ZERO;
        private int technicalCount = 0;
        private int commercialCount = 0;
        private BigDecimal maxTechnicalScore = BigDecimal.ZERO;
        private BigDecimal minTechnicalScore = new BigDecimal(100);
        private BigDecimal maxCommercialScore = BigDecimal.ZERO;
        private BigDecimal minCommercialScore = new BigDecimal(100);
        private BigDecimal maxTotalScore = BigDecimal.ZERO;
        private BigDecimal minTotalScore = new BigDecimal(100);

        protected SupplierScore() {
        }

        public BigDecimal getSumCommercialSorce() {
            return this.sumCommercialSorce;
        }

        public SupplierScore setSumCommercialSorce(BigDecimal sumCommercialSorce) {
            this.sumCommercialSorce = sumCommercialSorce;
            return this;
        }

        public BigDecimal getSumTechnicalSorce() {
            return this.sumTechnicalSorce;
        }

        public SupplierScore setSumTechnicalSorce(BigDecimal sumTechnicalSorce) {
            this.sumTechnicalSorce = sumTechnicalSorce;
            return this;
        }

        public int getTechnicalCount() {
            return this.technicalCount;
        }

        public SupplierScore setTechnicalCount(int technicalCount) {
            this.technicalCount = technicalCount;
            return this;
        }

        public int getCommercialCount() {
            return this.commercialCount;
        }

        public SupplierScore setCommercialCount(int commercialCount) {
            this.commercialCount = commercialCount;
            return this;
        }

        public BigDecimal getMaxTechnicalScore() {
            return this.maxTechnicalScore;
        }

        public SupplierScore setMaxTechnicalScore(BigDecimal maxTechnicalScore) {
            this.maxTechnicalScore = maxTechnicalScore;
            return this;
        }

        public BigDecimal getMinTechnicalScore() {
            return this.minTechnicalScore;
        }

        public SupplierScore setMinTechnicalScore(BigDecimal minTechnicalScore) {
            this.minTechnicalScore = minTechnicalScore;
            return this;
        }

        public BigDecimal getMaxCommercialScore() {
            return this.maxCommercialScore;
        }

        public SupplierScore setMaxCommercialScore(BigDecimal maxCommercialScore) {
            this.maxCommercialScore = maxCommercialScore;
            return this;
        }

        public BigDecimal getMinCommercialScore() {
            return this.minCommercialScore;
        }

        public SupplierScore setMinCommercialScore(BigDecimal minCommercialScore) {
            this.minCommercialScore = minCommercialScore;
            return this;
        }

        public BigDecimal getMaxTotalScore() {
            return this.maxTotalScore;
        }

        public SupplierScore setMaxTotalScore(BigDecimal maxTotalScore) {
            this.maxTotalScore = maxTotalScore;
            return this;
        }

        public BigDecimal getMinTotalScore() {
            return this.minTotalScore;
        }

        public SupplierScore setMinTotalScore(BigDecimal minTotalScore) {
            this.minTotalScore = minTotalScore;
            return this;
        }

        public String toString() {
            return "SupplierScore{sumCommercialSorce=" + this.sumCommercialSorce + ", sumTechnicalSorce=" + this.sumTechnicalSorce + ", technicalCount=" + this.technicalCount + ", commercialCount=" + this.commercialCount + ", maxTechnicalScore=" + this.maxTechnicalScore + ", minTechnicalScore=" + this.minTechnicalScore + ", maxCommercialScore=" + this.maxCommercialScore + ", minCommercialScore=" + this.minCommercialScore + ", maxTotalScore=" + this.maxTotalScore + ", minTotalScore=" + this.minTotalScore + '}';
        }
    }
}

