/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IBidProficientExtractService;
import kd.scm.bid.business.bill.serviceImpl.BidProficientExtractServiceImpl;

public class BidExtractProficientEditUI
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    protected IBidProficientExtractService service = new BidProficientExtractServiceImpl();

    private DynamicObjectType getEntryType(String parentBillId, String entryId) {
        MainEntityType parentDT = EntityMetadataCache.getDataEntityType((String)parentBillId);
        DynamicObject parent = new DynamicObject((DynamicObjectType)parentDT);
        DynamicObjectCollection entryCol = parent.getDynamicObjectCollection(entryId);
        DynamicObjectType entryDT = entryCol.getDynamicObjectType();
        return entryDT;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter para = this.getView().getFormShowParameter();
        String oldExtractId = (String)para.getCustomParam("oldExtractId");
        DynamicObjectType orgEntryDT = this.getEntryType(this.getView().getEntityId(), "orgentry");
        DynamicObjectType conditionEntryDT = this.getEntryType(this.getView().getEntityId(), "extractcondition");
        Long bidproject = (Long)para.getCustomParam("bidproject");
        this.getModel().setValue("bidproject", (Object)bidproject);
        if (StringUtils.isNotBlank((CharSequence)oldExtractId)) {
            DynamicObject oldExtract = BusinessDataServiceHelper.loadSingle((Object)oldExtractId, (String)this.getView().getEntityId());
            this.getModel().setValue("orgpriority", oldExtract.get("orgpriority"));
            DynamicObjectCollection oldOrgEntry = oldExtract.getDynamicObjectCollection("orgentry");
            for (int i = 0; i < oldOrgEntry.size(); ++i) {
                DynamicObject orgEntry = new DynamicObject(orgEntryDT);
                orgEntry.setParent((Object)this.getModel().getDataEntity());
                this.getModel().createNewEntryRow("orgentry", orgEntry);
                this.getModel().setValue("org", ((DynamicObject)oldOrgEntry.get(i)).get("org.id"), i);
            }
            DynamicObjectCollection oldConditonEntry = oldExtract.getDynamicObjectCollection("extractcondition");
            for (int i = 0; i < oldConditonEntry.size(); ++i) {
                DynamicObject condition = new DynamicObject(conditionEntryDT);
                condition.setParent((Object)this.getModel().getDataEntity());
                this.getModel().createNewEntryRow("extractcondition", condition);
                DynamicObject oldCondition = (DynamicObject)oldConditonEntry.get(i);
                this.getModel().setValue("proficientsource", oldCondition.get("proficientsource"), i);
                this.getModel().setValue("proficienttype", oldCondition.get("proficienttype"), i);
                this.getModel().setValue("majortype", oldCondition.get("majortype"), i);
                this.getModel().setValue("proficientlevel", oldCondition.get("proficientlevel"), i);
                this.getModel().setValue("proficientcount", oldCondition.get("proficientcount"), i);
            }
        }
    }

    private String getAppId() {
        return this.getModel().getDataEntityType().getAppId();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() == null) {
            return;
        }
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        if ("confirm".equals(operate.getOperateKey())) {
            String message = "";
            DynamicObjectCollection orgCol = this.getModel().getEntryEntity("orgentry");
            DynamicObjectCollection realOrgCol = new DynamicObjectCollection();
            ArrayList<Object> orgIdList = new ArrayList<Object>(10);
            for (int i = 0; i < orgCol.size(); ++i) {
                orgIdList.add(((DynamicObject)orgCol.get(i)).getDynamicObject("org").getPkValue());
                realOrgCol.add((Object)((DynamicObject)orgCol.get(i)).getDynamicObject("org"));
            }
            boolean orgPriority = (Boolean)this.getModel().getValue("orgpriority");
            Object[] resultObject = new Object[3];
            HashMap<String, DynamicObject[]> resultMap = new HashMap<String, DynamicObject[]>();
            HashMap<String, String[]> conditionMap = new HashMap<String, String[]>();
            DynamicObjectCollection extractConditionCol = this.getView().getModel().getEntryEntity("extractcondition");
            FormShowParameter para = this.getView().getFormShowParameter();
            List existedProficientList = (List)para.getCustomParam("existedProficient");
            HashSet<String> selectedSet = new HashSet<String>(existedProficientList);
            for (int i = 0; i < extractConditionCol.size(); ++i) {
                String key;
                HashSet<String> idSet = new HashSet<String>();
                DynamicObject extractCondition = (DynamicObject)extractConditionCol.get(i);
                List filters = this.service.listQFilterByExtractCondition(extractCondition);
                filters.add(new QFilter("entitytypeid", "=", (Object)(this.getAppId() + "_" + "proficient")));
                if (!orgPriority) {
                    filters.add(new QFilter("org", "in", orgIdList));
                    Set selectedSetLong = selectedSet.stream().map(v -> Long.parseLong(v)).collect(Collectors.toSet());
                    filters.add(new QFilter("id", "not in", selectedSetLong));
                    int proficientCount = extractCondition.getInt("proficientcount");
                    DynamicObject[] dataArr = new DynamicObject[proficientCount];
                    String[] conditionArr = new String[proficientCount];
                    QFilter[] filterArr = new QFilter[filters.size()];
                    DynamicObject[] proficientArr = BusinessDataServiceHelper.load((String)(this.getAppId() + "_proficient_f7"), (String)"id,sex,telephone,type,proficienttype,proficientlevel,majortypenames", (QFilter[])filters.toArray(filterArr));
                    if (proficientCount > proficientArr.length) {
                        String editUI14 = String.format(ResManager.loadKDString((String)"\u6761\u4ef6%s\u7b5b\u9009\u7684\u6570\u636e\u5c11\u4e8e\u6240\u586b\u5199\u7684\u4e13\u5bb6\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BidExtractProficientEditUI_35", (String)"scm-bid-formplugin", (Object[])new Object[0]), i + 1);
                        message = message + editUI14 + "\r\n";
                    } else {
                        List<Integer> randomNumList = this.randomSet(proficientArr.length, proficientCount);
                        if (randomNumList != null && !CollectionUtils.isEmpty(randomNumList)) {
                            for (int j = 0; j < proficientCount; ++j) {
                                idSet.add(String.valueOf(proficientArr[randomNumList.get(j)].getPkValue()));
                                selectedSet.add(String.valueOf(proficientArr[randomNumList.get(j)].getPkValue()));
                                dataArr[j] = proficientArr[randomNumList.get(j)];
                                conditionArr[j] = this.getConditionString(extractCondition);
                            }
                        }
                    }
                    key = String.format(ResManager.loadKDString((String)"\u6761\u4ef6%s", (String)"BidExtractProficientEditUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]), i + 1);
                    resultMap.put(key, dataArr);
                    conditionMap.put(key, conditionArr);
                    continue;
                }
                int proficientCount = extractCondition.getInt("proficientcount");
                ArrayList<DynamicObject> resultProficientList = new ArrayList<DynamicObject>();
                Set selectedSetLong = selectedSet.stream().map(v -> Long.parseLong(v)).collect(Collectors.toSet());
                filters.add(new QFilter("id", "not in", selectedSetLong));
                DynamicObject[] dataArr = new DynamicObject[proficientCount];
                int numFlag = 0;
                String[] conditionArr = new String[proficientCount];
                for (int j = 0; j < orgIdList.size(); ++j) {
                    int k;
                    filters.add(new QFilter("org", "=", orgIdList.get(j)));
                    QFilter[] filterArr = new QFilter[filters.size()];
                    DynamicObject[] proficientArr = BusinessDataServiceHelper.load((String)(this.getAppId() + "_proficient_f7"), (String)"id,sex,telephone,type,proficienttype,proficientlevel,majortypenames", (QFilter[])filters.toArray(filterArr));
                    filters.remove(filters.size() - 1);
                    if (proficientArr.length < proficientCount - numFlag) {
                        for (k = 0; k < proficientArr.length; ++k) {
                            dataArr[numFlag] = proficientArr[k];
                            ++numFlag;
                        }
                        continue;
                    }
                    for (k = 0; k < proficientArr.length; ++k) {
                        resultProficientList.add(proficientArr[k]);
                    }
                    if (numFlag + resultProficientList.size() >= proficientCount) break;
                }
                if (proficientCount > numFlag + resultProficientList.size()) {
                    message = message + String.format(ResManager.loadKDString((String)"\u6761\u4ef6%s\u7b5b\u9009\u7684\u6570\u636e\u5c11\u4e8e\u6240\u586b\u5199\u7684\u4e13\u5bb6\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BidExtractProficientEditUI_35", (String)"scm-bid-formplugin", (Object[])new Object[0]), i + 1) + "\r\n";
                } else {
                    for (int k = 0; k < numFlag; ++k) {
                        selectedSet.add(String.valueOf(dataArr[k].getPkValue()));
                        conditionArr[k] = this.getConditionString(extractCondition);
                    }
                    List<Integer> randomNumList = this.randomSet(resultProficientList.size(), proficientCount - numFlag);
                    for (int k = 0; k < proficientCount - numFlag; ++k) {
                        idSet.add(String.valueOf(((DynamicObject)resultProficientList.get(randomNumList.get(k))).getPkValue()));
                        selectedSet.add(String.valueOf(((DynamicObject)resultProficientList.get(randomNumList.get(k))).getPkValue()));
                        dataArr[numFlag + k] = (DynamicObject)resultProficientList.get(randomNumList.get(k));
                        conditionArr[numFlag + k] = this.getConditionString(extractCondition);
                    }
                }
                key = String.format(ResManager.loadKDString((String)"\u6761\u4ef6%s", (String)"BidExtractProficientEditUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]), i + 1);
                resultMap.put(key, dataArr);
                conditionMap.put(key, conditionArr);
            }
            if (message != null && !message.equals("")) {
                this.getView().showTipNotification(message);
            } else {
                ArrayList<String> proficientNameList = new ArrayList<String>();
                ArrayList<String> proficientIdList = new ArrayList<String>();
                Long pk = ORM.create().genLongId((IDataEntityType)this.createExtractType());
                this.getModel().setValue("id", (Object)pk);
                Object id = this.getModel().getValue("id");
                Collection resultCol = resultMap.values();
                ArrayList resultList = new ArrayList(resultCol);
                for (int j = 0; j < resultList.size(); ++j) {
                    DynamicObject[] proficientResultArr = (DynamicObject[])resultList.get(j);
                    for (int k = 0; k < proficientResultArr.length; ++k) {
                        proficientIdList.add(String.valueOf(proficientResultArr[k].getPkValue()));
                        proficientNameList.add(String.valueOf(proficientResultArr[k].get("name")));
                    }
                }
                resultObject[0] = resultMap;
                resultObject[1] = conditionMap;
                resultObject[2] = id;
                this.getModel().setValue("extractresultname", (Object)((Object)proficientNameList).toString());
                this.getModel().setValue("extractresultid", (Object)((Object)proficientIdList).toString());
                this.getView().returnDataToParent((Object)resultObject);
                this.getView().invokeOperation("save");
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    private MainEntityType createExtractType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId());
        return mainType;
    }

    private String getConditionString(DynamicObject condition) {
        String proficientLevel;
        DynamicObject majorType;
        String proficientType;
        StringBuilder result = new StringBuilder();
        String proficientSource = condition.getString("proficientsource");
        if (proficientSource != null) {
            String str;
            if (proficientSource.equals("internalExperts")) {
                str = String.format(ResManager.loadKDString((String)"\u4e13\u5bb6\u6765\u6e90\uff1a\u5185\u90e8\u4e13\u5bb6%s", (String)"BidExtractProficientEditUI_27", (String)"scm-bid-formplugin", (Object[])new Object[0]), ",");
                result.append(str);
            } else if (proficientSource.equals("externalExperts")) {
                str = String.format(ResManager.loadKDString((String)"\u4e13\u5bb6\u6765\u6e90\uff1a\u5916\u90e8\u4e13\u5bb6%s", (String)"BidExtractProficientEditUI_28", (String)"scm-bid-formplugin", (Object[])new Object[0]), ",");
                result.append(str);
            }
        }
        if ((proficientType = condition.getString("proficienttype")) != null) {
            String str;
            if (proficientType.equals("01")) {
                str = String.format(ResManager.loadKDString((String)"\u4e13\u5bb6\u7c7b\u578b\uff1a\u7ba1\u7406\u4eba\u5458%s", (String)"BidExtractProficientEditUI_25", (String)"scm-bid-formplugin", (Object[])new Object[0]), ",");
                result.append(str);
            } else if (proficientType.equals("02")) {
                str = String.format(ResManager.loadKDString((String)"\u4e13\u5bb6\u7c7b\u578b\uff1a\u4e2d\u5c42\u4eba\u5458%s", (String)"BidExtractProficientEditUI_29", (String)"scm-bid-formplugin", (Object[])new Object[0]), ",");
                result.append(str);
            } else if (proficientType.equals("03")) {
                str = String.format(ResManager.loadKDString((String)"\u4e13\u5bb6\u7c7b\u578b\uff1a\u6280\u672f\u4eba\u5458%s", (String)"BidExtractProficientEditUI_30", (String)"scm-bid-formplugin", (Object[])new Object[0]), ",");
                result.append(str);
            }
        }
        if ((majorType = condition.getDynamicObject("majortype")) != null) {
            Object majorTypeName = majorType.get("name");
            String message = String.format(ResManager.loadKDString((String)"\u4e13\u4e1a\u5206\u7c7b\uff1a%s", (String)"BidExtractProficientEditUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), majorTypeName + ",");
            result.append(message);
        }
        if ((proficientLevel = condition.getString("proficientlevel")) != null) {
            String str;
            if (proficientLevel.equals("A")) {
                str = String.format(ResManager.loadKDString((String)"\u4e13\u5bb6\u7ea7\u522b\uff1aA%s", (String)"BidExtractProficientEditUI_31", (String)"scm-bid-formplugin", (Object[])new Object[0]), ",");
                result.append(str);
            } else if (proficientLevel.equals("B")) {
                str = String.format(ResManager.loadKDString((String)"\u4e13\u5bb6\u7ea7\u522b\uff1aB%s", (String)"BidExtractProficientEditUI_32", (String)"scm-bid-formplugin", (Object[])new Object[0]), ",");
                result.append(str);
            } else if (proficientLevel.equals("C")) {
                str = String.format(ResManager.loadKDString((String)"\u4e13\u5bb6\u7ea7\u522b\uff1aC%s", (String)"BidExtractProficientEditUI_33", (String)"scm-bid-formplugin", (Object[])new Object[0]), ",");
                result.append(str);
            } else if (proficientLevel.equals("D")) {
                str = String.format(ResManager.loadKDString((String)"\u4e13\u5bb6\u7ea7\u522b\uff1aD%s", (String)"BidExtractProficientEditUI_34", (String)"scm-bid-formplugin", (Object[])new Object[0]), ",");
                result.append(str);
            }
        }
        int proficientcount = condition.getInt("proficientcount");
        result.append(ResManager.loadKDString((String)"\u4e13\u5bb6\u4eba\u6570\uff1a", (String)"BidExtractProficientEditUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0])).append(proficientcount);
        return result.toString();
    }

    private List<Integer> randomSet(int max, int n) {
        HashSet<Integer> numSet = new HashSet<Integer>(50);
        if (n > max + 1) {
            return null;
        }
        SecureRandom random = new SecureRandom();
        while (numSet.size() < n) {
            int num = random.nextInt(max);
            numSet.add(num);
        }
        return new ArrayList<Integer>(numSet);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String fieldKey = paramBeforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)"org", (CharSequence)fieldKey)) {
            DynamicObjectCollection orgCol = this.getModel().getEntryEntity("orgentry");
            ArrayList<Object> orgIdList = new ArrayList<Object>();
            for (int i = 0; i < orgCol.size(); ++i) {
                if (((DynamicObject)orgCol.get(i)).getDynamicObject("org") == null) continue;
                orgIdList.add(((DynamicObject)orgCol.get(i)).getDynamicObject("org").getPkValue());
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter orgFilter = new QFilter("id", "not in", orgIdList);
            qFilters.add(orgFilter);
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(qFilters);
        }
    }
}

