/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bill.IBidAnnocumentService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidAnnocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;

public class BidInvitationUI
extends AbstractFormPlugin
implements SearchEnterListener,
PagerClickListener,
CellClickListener {
    private static final String NAME = "name";
    private static final String PUBLISHDATE = "publishdate";
    private static final String ENDTIME = "endtime";
    private static final String STATUS = "status";
    private static final String SEARCHAP = "searchap";
    private static final String ROWID = "rowid";
    private IBidAnnocumentService annocumentService = new BidAnnocumentServiceImpl();
    private IBidProjectService iBidProjectService = new BidProjectServiceImpl();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.createEntryRow("");
    }

    public void search(SearchEnterEvent arg0) {
        Search search = (Search)arg0.getSource();
        if (StringUtils.equals((CharSequence)search.getKey(), (CharSequence)SEARCHAP)) {
            String searchText = arg0.getText();
            this.createEntryRow(searchText);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addCellClickListener((CellClickListener)this);
        this.addPageStyle();
    }

    public List<Map<String, String>> doSearchList(String searchText) {
        ArrayList<Map<String, String>> messes = new ArrayList<Map<String, String>>();
        QFilter qFilter = new QFilter("annotitle", "like", (Object)searchText);
        String appId = this.getModel().getDataEntityType().getAppId();
        qFilter.and(new QFilter("entitytypeid", "like", (Object)(appId + "%")));
        this.addMessage(messes, searchText, qFilter);
        QFilter qFilter1 = new QFilter("annotitle", "like", (Object)("%" + searchText + "%"));
        qFilter1.and(new QFilter("entitytypeid", "like", (Object)(appId + "%")));
        qFilter1.and(new QFilter("annotitle", "not like", (Object)searchText));
        this.addMessage(messes, searchText, qFilter1);
        return messes;
    }

    public void addMessage(List<Map<String, String>> messes, String searchText, QFilter qFilter) {
        QFilter qFilter2 = new QFilter("annotype", "=", (Object)this.getAnnoType());
        QFilter qFilter3 = new QFilter("billstatus", "=", (Object)"L");
        DynamicObjectCollection coll = QueryServiceHelper.query((String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()), (String)"id,annotitle,publishdate,signendtime,billstatus,bidproject", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3}, (String)"publishdate desc");
        if (coll != null && coll.size() > 0) {
            for (DynamicObject temp : coll) {
                HashMap<String, String> mess = new HashMap<String, String>();
                Long bidProjectId = temp.getLong("bidproject");
                String bidProjectName = this.iBidProjectService.getBidProjectById(bidProjectId, NAME).getString(0);
                mess.put(NAME, bidProjectName);
                mess.put(PUBLISHDATE, temp.getString(PUBLISHDATE));
                mess.put(ENDTIME, temp.getString("signendtime"));
                Date endtime = temp.getDate("signendtime");
                if (endtime != null) {
                    Date now = new Date();
                    if (endtime.before(now)) {
                        mess.put(STATUS, ResManager.loadKDString((String)"\u5df2\u622a\u6b62", (String)"BidInvitationUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    } else {
                        mess.put(STATUS, ResManager.loadKDString((String)"\u62a5\u540d\u4e2d", (String)"BidInvitationUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                }
                mess.put(ROWID, temp.getString("id"));
                messes.add(mess);
            }
        }
    }

    public String getAnnoType() {
        return "bidproject";
    }

    public void createEntryRow(String searchText) {
        List<Map<String, String>> messes = this.doSearchList(searchText);
        this.getModel().deleteEntryData("entryentity");
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>();
        for (Map<String, String> mess : messes) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue(ROWID, (Object)mess.get(ROWID), index);
            this.getModel().setValue(NAME, (Object)mess.get(NAME), index);
            this.getModel().setValue(PUBLISHDATE, (Object)mess.get(PUBLISHDATE), index);
            this.getModel().setValue(ENDTIME, (Object)mess.get(ENDTIME), index);
            this.getModel().setValue(STATUS, (Object)mess.get(STATUS), index);
            CellStyle statusStyle = this.setEntryNameColor(index, STATUS, mess.get(STATUS), true, ResManager.loadKDString((String)"\u62a5\u540d\u4e2d", (String)"BidInvitationUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), "#5fbf00");
            CellStyle namestyle = this.setEntryNameColor(index, NAME, mess.get(NAME), false, null, "#2b87f3");
            if (namestyle != null) {
                styles.add(namestyle);
            }
            if (statusStyle == null) continue;
            styles.add(statusStyle);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.setPageIndex(1);
        grid.setCellStyle(styles);
    }

    public CellStyle setEntryNameColor(int row, String key, String toCompare, boolean isCompare, String data, String color) {
        CellStyle toReturn = null;
        if (isCompare) {
            if (StringUtils.equals((CharSequence)toCompare, (CharSequence)data)) {
                toReturn = this.getStyle(row, key, color);
            }
        } else {
            toReturn = this.getStyle(row, key, color);
        }
        return toReturn;
    }

    private CellStyle getStyle(int row, String key, String color) {
        CellStyle style = new CellStyle();
        style.setRow(row);
        style.setFieldKey(key);
        style.setForeColor(color);
        return style;
    }

    public void pagerClick(PagerClickEvent arg0) {
    }

    public void addPageStyle() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        IDataModel operate = grid.getModel();
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>();
        this.changeEntryFieldColor(styles, operate.getEntryEntity("entryentity"));
        grid.setCellStyle(styles);
    }

    public void changeEntryFieldColor(List<CellStyle> styles, DynamicObjectCollection colls) {
        for (int i = 0; i < colls.size(); ++i) {
            CellStyle namestyle;
            DynamicObject row = (DynamicObject)colls.get(i);
            CellStyle statusStyle = this.setEntryNameColor(i, STATUS, row.getString(STATUS), true, ResManager.loadKDString((String)"\u62a5\u540d\u4e2d", (String)"BidInvitationUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), "#5fbf00");
            if (statusStyle != null) {
                styles.add(statusStyle);
            }
            if ((namestyle = this.setEntryNameColor(i, NAME, row.getString(NAME), false, null, "#2b87f3")) == null) continue;
            styles.add(namestyle);
        }
    }

    public void cellClick(CellClickEvent arg0) {
        String key = arg0.getFieldKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)NAME)) {
            String id = (String)this.getModel().getValue(ROWID, arg0.getRow());
            Long annoId = Long.parseLong(id);
            this.toAnnouncement(annoId);
        }
    }

    public void toAnnouncement(Long id) {
        DynamicObject purTypeObj;
        DynamicObject anno = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()), (String)"annotitle,content,publishdate,bidproject", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormTypeConstants.getFormConstant((String)"announcement_preview", ((Object)((Object)this)).getClass()));
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("annotitle", (Object)this.getAnnotitle());
        showParameter.setCustomParam("annocomment", (Object)anno.getString("annotitle"));
        String purTypeName = "";
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)anno.getString("bidproject"), (String)"bid_project");
        if (project != null && (purTypeObj = project.getDynamicObject("purtype")) != null) {
            purTypeName = purTypeObj.getString(NAME);
        }
        showParameter.setCustomParam("purtype", (Object)purTypeName);
        showParameter.setCustomParam("releasetime", (Object)anno.getDate(PUBLISHDATE));
        String string = anno.getString("content");
        if (string != null) {
            showParameter.setCustomParam("info", (Object)this.setRichTextEditorapStr(string, id));
        }
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.getView().showForm(showParameter);
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    public String getAnnotitle() {
        return ResManager.loadKDString((String)"\u62db\u6807\u516c\u544a\u8be6\u60c5", (String)"BidInvitationUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]);
    }

    private String getAppdiex() {
        return ResManager.loadKDString((String)"\u9644\u4ef6\uff1a", (String)"BidInvitationUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]);
    }

    private String setRichTextEditorapStr(String string, Object pkValue) {
        String formid = null;
        String appId = this.getModel().getDataEntityType().getAppId();
        if (appId.equals("bid")) {
            formid = "bid_announcement";
        } else if (appId.equals("rebm")) {
            formid = "rebm_announcement";
        } else {
            return string;
        }
        List attachs = this.annocumentService.getBillAttach((Object)formid, pkValue);
        if (attachs != null && attachs.size() != 0) {
            StringBuilder attachStrSb = new StringBuilder();
            attachStrSb.append(string);
            char ch = '\"';
            String frontStr = " <a href = " + ch;
            String afterStr = ch + "download=" + ch + "file" + ch + ">";
            for (int i = 0; i < attachs.size(); ++i) {
                String attachStr;
                String url = (String)((Map)attachs.get(i)).get("url");
                String name = (String)((Map)attachs.get(i)).get(NAME);
                if (i == 0) {
                    attachStr = "<p><b>&nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;&nbsp;&nbsp;" + this.getAppdiex() + "</b>" + frontStr + url + afterStr + name + "</a><p>";
                    attachStrSb.append(attachStr);
                }
                if (i <= 0) continue;
                attachStr = "<p>&nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + frontStr + url + afterStr + name + "</a></p>";
                attachStrSb.append(attachStr);
            }
            return attachStrSb.toString();
        }
        return string;
    }
}

