/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class BidOpenProficientEditUI
extends AbstractFormPlugin {
    private IBidOpenService bidOpenService = new BidOpenServiceImpl();
    private IBidProjectService projectService = new BidProjectServiceImpl();
    private IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String value = (String)this.getView().getFormShowParameter().getCustomParam("id");
        Long id = Long.parseLong(value);
        DynamicObject obj = this.bidOpenService.getBidOpenById(id);
        DynamicObject bidProject = obj.getDynamicObject("bidproject");
        String docTypeStr = bidProject.getString("doctype");
        IDataModel model = this.getModel();
        DynamicObjectCollection coll = obj.getDynamicObjectCollection("bidopen_proficient");
        int i = 0;
        EntryGrid proficientEntrys = (EntryGrid)this.getView().getControl("bidopen_proficient");
        IDataModel operate = proficientEntrys.getModel();
        int beforeNum = operate.getEntryRowCount("bidopen_proficient");
        model.setValue("bidopen", (Object)id);
        if (coll.size() > 0) {
            DynamicObjectType entryentityDT = this.getEntryType(this.getView().getEntityId(), "bidopen_proficient");
            StringBuilder startProficientIds = new StringBuilder();
            StringBuilder startProficientec = new StringBuilder();
            StringBuilder startProficienbus = new StringBuilder();
            for (DynamicObject temp : coll) {
                DynamicObject proficientEntry = new DynamicObject(entryentityDT);
                proficientEntry.setParent((Object)this.getModel().getDataEntity());
                this.getModel().createNewEntryRow("bidopen_proficient", proficientEntry);
                DynamicObject proficient = temp.getDynamicObject("proficient");
                if (proficient != null) {
                    String str = proficient.getString("id") + ",";
                    startProficientIds.append(str);
                    this.getModel().setValue("proficient", proficient.get("id"), i);
                    String tec = temp.getString("proficient_technical") + ",";
                    startProficientec.append(tec);
                    String bus = temp.get("proficient_commercial") + ",";
                    startProficienbus.append(bus);
                }
                model.setValue("proficient_technical", temp.get("proficient_technical"), i);
                model.setValue("proficient_commercial", temp.get("proficient_commercial"), i);
                model.setValue("proficient_comment", temp.get("proficient_comment"), i);
                model.setValue("selectionmethod", temp.get("selectionmethod"), i);
                ++i;
            }
            this.getPageCache().put("startProficientIds", startProficientIds.toString());
            this.getPageCache().put("startProficientec", startProficientec.toString());
            this.getPageCache().put("startProficienbus", startProficienbus.toString());
        }
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(docTypeStr)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"proficient_commercial"});
            proficientEntrys.setColumnProperty("proficient_technical", "l", (Object)55);
        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"proficient_technical"});
            proficientEntrys.setColumnProperty("proficient_commercial", "l", (Object)55);
        }
        this.getModel().setDataChanged(false);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("addproficient".equals(evt.getItemKey())) {
            ListShowParameter para = this.createF7(this.getOpenFormId("proficient_f7"), "bidopen_proficient", "proficient");
            this.getView().showForm((FormShowParameter)para);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String value = (String)this.getView().getFormShowParameter().getCustomParam("id");
        Long id = Long.parseLong(value);
        DynamicObject bidOpen = this.bidOpenService.getBidOpenById(id);
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"extractproficient", (CharSequence)key)) {
            HashMap<String, String> extractMap = new HashMap<String, String>();
            extractMap.put("formId", FormTypeConstants.getFormConstant((String)"proficient_extract", ((Object)((Object)this)).getClass()));
            boolean isExistProficientExtract = false;
            QFilter qFilter = new QFilter("bidopenname", "=", bidOpen.getPkValue());
            DynamicObject result = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"proficient_extract", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])qFilter.toArray());
            if (result != null) {
                isExistProficientExtract = true;
                extractMap.put("pkId", result.get("id").toString());
            }
            FormShowParameter extractPara = null;
            String extractId = this.getPageCache().get("extractId");
            if (extractId == null) {
                extractId = bidOpen.getString("extractrecoid");
            }
            extractPara = FormShowParameter.createFormShowParameter(extractMap);
            if (extractId != null && !extractId.equals(" ")) {
                extractPara.setCustomParam("oldExtractId", (Object)extractId);
            }
            if (isExistProficientExtract) {
                extractPara.setStatus(OperationStatus.EDIT);
            } else {
                extractPara.setStatus(OperationStatus.ADDNEW);
            }
            extractPara.getOpenStyle().setShowType(ShowType.Modal);
            ArrayList<String> existedProficientList = new ArrayList<String>();
            int proficientCount = this.getModel().getEntryRowCount("bidopen_proficient");
            for (int i = 0; i < proficientCount; ++i) {
                DynamicObject bidOpenProficient = this.getModel().getEntryRowEntity("bidopen_proficient", i);
                DynamicObject proficient = bidOpenProficient.getDynamicObject("proficient");
                if (proficient == null || proficient.getPkValue() == null) continue;
                existedProficientList.add(proficient.getString("id"));
            }
            extractPara.setCustomParam("id", (Object)bidOpen.getPkValue().toString());
            extractPara.setCustomParam("existedProficient", existedProficientList);
            extractPara.setCustomParam("bidproject", bidOpen.get("bidproject.id"));
            extractPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "extractproficient"));
            this.getView().showForm(extractPara);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.getModel().setDataChanged(false);
        OperationResult result = args.getOperationResult();
        if (StringUtils.equals((CharSequence)"savebidopen", (CharSequence)args.getOperateKey()) && result.isSuccess()) {
            String startProficientIds;
            this.getModel().setDataChanged(false);
            String bidOpenId = (String)this.getModel().getValue("bidopen");
            DynamicObject bidopen = this.bidOpenService.getBidOpenById(Long.valueOf(Long.parseLong(bidOpenId)));
            HashMap<Long, Long> openevaorMap = new HashMap<Long, Long>();
            HashMap<Long, Long> afteropenevaorMap = new HashMap<Long, Long>();
            HashMap proficientTec = new HashMap();
            String billstatus = bidopen.getString("billstatus");
            if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.OPEN.getVal())) {
                boolean isOnlineEval = bidopen.getBoolean("isonlineeval");
                if (isOnlineEval) {
                    String appId = bidopen.getString("entitytypeid").split("_")[0];
                    String startProficientIds2 = this.getPageCache().get("startProficientIds");
                    String startProficientec = this.getPageCache().get("startProficientec");
                    String startProficienbus = this.getPageCache().get("startProficienbus");
                    if (startProficientIds2 != null) {
                        DynamicObject[] onlinebidevalsde;
                        DynamicObject[] onlinebidevals;
                        List<String> startIds = Arrays.asList(startProficientIds2.split(","));
                        List<String> starttec = Arrays.asList(startProficientec.split(","));
                        ArrayList<Long> startIdsLong = new ArrayList<Long>(startIds.size());
                        for (int i = 0; i < startIds.size(); ++i) {
                            String id = startIds.get(i);
                            startIdsLong.add(Long.parseLong(id));
                            if (!"TECHNICAL".equals(bidopen.getString("opentype"))) continue;
                            proficientTec.put(Long.parseLong(id), starttec.get(i));
                        }
                        QFilter qFilter = new QFilter("bidevaluator", "in", startIdsLong);
                        QFilter qFilteropen = new QFilter("bidopenid", "=", (Object)Long.parseLong(bidOpenId));
                        for (DynamicObject onlinebideval : onlinebidevals = BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"id,bidevaluator", (QFilter[])new QFilter[]{qFilter, qFilteropen})) {
                            Long bidevaluator = onlinebideval.getDynamicObject("bidevaluator").getLong("id");
                            Long id = onlinebideval.getLong("id");
                            openevaorMap.put(bidevaluator, id);
                        }
                        ArrayList<Long> endtIds = new ArrayList<Long>();
                        ArrayList<String> endttec = new ArrayList<String>();
                        DynamicObject dataEntity = this.getModel().getDataEntity(true);
                        DynamicObjectCollection proficients = dataEntity.getDynamicObjectCollection("bidopen_proficient");
                        if (proficients.size() > 0) {
                            for (Object proficientRow : proficients) {
                                String proficient = proficientRow.getDynamicObject("proficient").getString("id");
                                endtIds.add(Long.parseLong(proficient));
                                if (!"TECHNICAL".equals(bidopen.getString("opentype"))) continue;
                                endttec.add(proficientRow.getString("proficient_technical"));
                            }
                        }
                        List expid = startIdsLong.stream().filter(item -> !endtIds.contains(item)).collect(Collectors.toList());
                        if ("TECHNICAL".equals(bidopen.getString("opentype")) && proficients.size() > 0) {
                            for (DynamicObject proficientRow : proficients) {
                                String proficient = proficientRow.getDynamicObject("proficient").getString("id");
                                String nowTec = proficientRow.getString("proficient_technical");
                                String s = (String)proficientTec.get(Long.parseLong(proficient));
                                if (!"false".equals(nowTec) || !"true".equals(s)) continue;
                                expid.add(Long.parseLong(proficient));
                            }
                        }
                        QFilter qFilterde = new QFilter("bidevaluator", "in", expid);
                        QFilter qFilteropende = new QFilter("bidopenid", "=", (Object)Long.parseLong(bidOpenId));
                        for (DynamicObject onlinebidevalde : onlinebidevalsde = BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"id", (QFilter[])new QFilter[]{qFilterde, qFilteropende})) {
                            String onid = "%" + onlinebidevalde.getString("id") + "%";
                            DeleteServiceHelper.delete((String)"wf_msg_message", (QFilter[])new QFilter[]{new QFilter("contenturl", "like", (Object)onid)});
                        }
                    }
                }
                Long projectId = bidopen.getLong("bidproject.id");
                DynamicObject bidproject = this.projectService.getBidProjectAllById(projectId);
                this.bidOpenService.deleteNextStepUnStarted(bidproject, BidStepEnum.BidOpen);
                this.bidOpenService.createNextStep(bidproject, BidStepEnum.BidOpen);
                if (isOnlineEval) {
                    this.onlineBidEvalService.deleteNextStepUnStarted(bidproject);
                    this.onlineBidEvalService.createByLastStep(bidproject);
                    ArrayList<Long> endtIds = new ArrayList<Long>();
                    DynamicObject dataEntity = this.getModel().getDataEntity(true);
                    DynamicObjectCollection proficients = dataEntity.getDynamicObjectCollection("bidopen_proficient");
                    if (proficients.size() > 0) {
                        for (DynamicObject proficientRow : proficients) {
                            String proficient = proficientRow.getDynamicObject("proficient").getString("id");
                            endtIds.add(Long.parseLong(proficient));
                        }
                    }
                    String appId = bidopen.getString("entitytypeid").split("_")[0];
                    QFilter afterqFilter = new QFilter("bidevaluator", "in", endtIds);
                    QFilter qFilteropende = new QFilter("bidopenid", "=", (Object)Long.parseLong(bidOpenId));
                    DynamicObject[] afteronlinebidevals = BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"id,bidevaluator", (QFilter[])new QFilter[]{afterqFilter, qFilteropende});
                    for (DynamicObject afteronlinebideval : afteronlinebidevals) {
                        Long afterbidevaluator = afteronlinebideval.getDynamicObject("bidevaluator").getLong("id");
                        Long afterid = afteronlinebideval.getLong("id");
                        afteropenevaorMap.put(afterbidevaluator, afterid);
                    }
                    if (proficients.size() > 0) {
                        for (DynamicObject proficientRow : proficients) {
                            String[] contenturl;
                            Long proficient = proficientRow.getDynamicObject("proficient").getLong("id");
                            String onid = "%" + openevaorMap.get(proficient) + "%";
                            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_msg_message", (String)"contenturl", (QFilter[])new QFilter[]{new QFilter("contenturl", "like", (Object)onid)});
                            if (dynamicObject == null || (contenturl = dynamicObject.getString("contenturl").split("pkId=")).length != 2) continue;
                            String conten = contenturl[0];
                            Long aLong = (Long)afteropenevaorMap.get(proficient);
                            dynamicObject.set("contenturl", (Object)(conten + "pkId=" + aLong));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                        }
                    }
                }
            }
            if ((startProficientIds = this.getPageCache().get("startProficientIds")) != null) {
                List<String> startIds = Arrays.asList(startProficientIds.split(","));
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObjectCollection proficients = dataEntity.getDynamicObjectCollection("bidopen_proficient");
                String appId = bidopen.getString("entitytypeid").split("_")[0];
                if (proficients.size() > 0) {
                    for (DynamicObject proficientRow : proficients) {
                        String proficient = proficientRow.getDynamicObject("proficient").getString("id");
                        if (startIds.contains(proficient)) continue;
                        this.sendMessageToProficients(bidopen, appId, proficient);
                    }
                }
            }
            String extractId = this.getPageCache().get("extractId");
            if (result.isSuccess()) {
                this.updateExtractRecoId(bidOpenId, extractId);
                this.getView().close();
            }
        }
    }

    protected void sendMessageToProficients(DynamicObject proObj, String appId, String proficientId) {
        String notifyTypes = "";
        String tplScene = "";
        if ("bid".equals(appId)) {
            notifyTypes = MessageChannelUtil.getNotifyType((String)"comfiropenToExperter", (String)"bid_bidopen");
            tplScene = "comfiropenToExperter";
        } else {
            notifyTypes = MessageChannelUtil.getNotifyType((String)"comfiropenToExperter_rebm", (String)"rebm_bidopen");
            tplScene = "comfiropenToExperter_rebm";
        }
        if (StringUtils.isEmpty((CharSequence)notifyTypes)) {
            return;
        }
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (!enable) {
            return;
        }
        MessageInfo messageProficientInfo = new MessageInfo();
        messageProficientInfo.setType("message");
        messageProficientInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageProficientInfo.setSenderName(RequestContext.get().getUserName());
        ArrayList<Long> proficientReceiveUserIds = new ArrayList<Long>(16);
        DynamicObject proficient = QueryServiceHelper.queryOne((String)(appId + "_proficient"), (String)"proficientname", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(proficientId))});
        if (proficient != null) {
            long userId = proficient.getLong("proficientname");
            proficientReceiveUserIds.add(userId);
        }
        messageProficientInfo.setUserIds(proficientReceiveUserIds);
        messageProficientInfo.setBizDataId((Long)proObj.getPkValue());
        messageProficientInfo.setEntityNumber(appId + "_bidopen");
        messageProficientInfo.setOperation("confirmopen");
        messageProficientInfo.setTitle(null);
        messageProficientInfo.setContent(null);
        messageProficientInfo.setTplScene(tplScene);
        messageProficientInfo.setNotifyType(notifyTypes);
        DynamicObjectCollection proficientColl = proObj.getDynamicObjectCollection("bidopen_proficient");
        String openType = proObj.getString("opentype");
        boolean isonlineeval = proObj.getBoolean("isonlineeval");
        HashMap<String, Object> param = new HashMap<String, Object>();
        ArrayList<String> onlinePKids = new ArrayList<String>();
        if (isonlineeval) {
            if ("bid".equals(appId)) {
                param.put("formId", "bid_onlinebideval");
            } else {
                param.put("formId", "rebm_onlinebideval");
            }
            QFilter qFilter = new QFilter("bidevaluator", "=", (Object)Long.parseLong(proficientId));
            QFilter qFilteropen = new QFilter("bidopenid", "=", proObj.getPkValue());
            QFilter qFiltert = new QFilter("evaltype", "=", (Object)"TECHNICAL");
            QFilter qFilterb = new QFilter("evaltype", "=", (Object)"BUSSINESS");
            QFilter qFilterm = new QFilter("evaltype", "=", (Object)"MULTI");
            DynamicObject[] onlinebidevals = null;
            onlinebidevals = "TECHNICAL".equals(openType) ? BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"id", (QFilter[])new QFilter[]{qFilter, qFilteropen, qFiltert}, (String)"bidevaluator") : ("BUSSINESS".equals(openType) ? BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"id", (QFilter[])new QFilter[]{qFilter, qFilteropen, qFilterb}, (String)"bidevaluator") : BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"id", (QFilter[])new QFilter[]{qFilter, qFilteropen}, (String)"bidevaluator"));
            for (DynamicObject onlinebideval : onlinebidevals) {
                Long onid = onlinebideval.getLong("id");
                param.put("pkId", onid);
                List<String> urlParams = Arrays.asList("formId", "pkId");
                if (urlParams == null || urlParams.size() <= 0) continue;
                StringBuilder buf = new StringBuilder();
                String contentUrl = System.getProperty("domain.contextUrl");
                String tenantCode = RequestContext.get().getTenantCode();
                contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
                buf.append(contentUrl);
                int urlParamIndex = 0;
                for (String urlParam : urlParams) {
                    String temp;
                    if (urlParamIndex == 0) {
                        temp = "?" + urlParam + "=" + param.get(urlParam);
                        buf.append(temp);
                    } else {
                        temp = "&" + urlParam + "=" + param.get(urlParam);
                        buf.append(temp);
                    }
                    ++urlParamIndex;
                }
                onlinePKids.add(buf.toString());
            }
            if (!onlinePKids.isEmpty()) {
                messageProficientInfo.setContentUrl((String)onlinePKids.get(0));
            }
        }
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageProficientInfo);
    }

    private void updateExtractRecoId(String bidOpenId, String extractId) {
        DynamicObject bidOpen = this.bidOpenService.getBidOpenById(Long.valueOf(bidOpenId));
        bidOpen.set("extractrecoid", (Object)extractId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidOpen});
    }

    private ListShowParameter createF7(String formName, String entryName, String entryEntityName) {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)formName, (boolean)true);
        EntryGrid proficientEntrys = (EntryGrid)this.getView().getControl(entryName);
        IDataModel operate = proficientEntrys.getModel();
        IDataModel model = this.getView().getModel();
        int rowCount = operate.getEntryRowCount(entryName);
        Long[] ids = new Long[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entity = (DynamicObject)model.getValue(entryEntityName, i);
            ids[i] = entity.getLong("id");
        }
        OpenStyle openStyle = para.getOpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        para.setShowQuickFilter(true);
        para.setMultiSelect(true);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("status", "=", (Object)BillStatusEnum.AUDITED.getVal()));
        qFilters.add(new QFilter("id", "not in", (Object)ids));
        qFilters.add(new QFilter("userdstatus", "=", (Object)"Enable"));
        para.getListFilterParameter().setQFilters(qFilters);
        para.setShowUsed(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formName);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject proficientEntry;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (this.getOpenFormId("proficient_f7").equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            ListSelectedRowCollection returnObj = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            int num = returnObj.size();
            EntryGrid proficientEntrys = (EntryGrid)this.getView().getControl("bidopen_proficient");
            IDataModel operate = proficientEntrys.getModel();
            int beforeNum = operate.getEntryRowCount("bidopen_proficient");
            DynamicObjectType entryentityDT = this.getEntryType(this.getView().getEntityId(), "bidopen_proficient");
            if (num > 0) {
                for (int i = beforeNum; i < num + beforeNum; ++i) {
                    proficientEntry = new DynamicObject(entryentityDT);
                    proficientEntry.setParent((Object)this.getModel().getDataEntity());
                    this.getModel().createNewEntryRow("bidopen_proficient", proficientEntry);
                    this.getModel().setValue("proficient", returnObj.get(i - beforeNum).getPrimaryKeyValue(), i);
                    this.getModel().setValue("selectionmethod", (Object)"add", i);
                }
            }
        }
        if ("extractproficient".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            HashMap<String, DynamicObject> proficientMap = new HashMap<String, DynamicObject>();
            int proficientCount = this.getModel().getEntryRowCount("bidopen_proficient");
            for (int i = 0; i < proficientCount; ++i) {
                DynamicObject bidOpenProficient = this.getModel().getEntryRowEntity("bidopen_proficient", i);
                DynamicObject proficient = bidOpenProficient.getDynamicObject("proficient");
                if (proficient == null || proficient.getPkValue() == null) continue;
                proficientMap.put(String.valueOf(proficient.getPkValue()), proficient);
            }
            DynamicObjectType entryentityDT = this.getEntryType(this.getView().getEntityId(), "bidopen_proficient");
            List returnData = (List)closedCallBackEvent.getReturnData();
            for (int j = 0; j < returnData.size(); ++j) {
                Map map = (Map)returnData.get(j);
                DynamicObject proficient = (DynamicObject)map.get("proficient");
                if (proficientMap.containsKey(String.valueOf(proficient.getPkValue()))) continue;
                proficientEntry = new DynamicObject(entryentityDT);
                proficientEntry.set("proficient", (Object)proficient);
                proficientEntry.setParent((Object)this.getModel().getDataEntity());
                int createNewEntryRow = this.getModel().createNewEntryRow("bidopen_proficient", proficientEntry);
                this.getModel().setValue("proficient_comment", map.get("extractcondition"), createNewEntryRow);
                this.getModel().setValue("selectionmethod", (Object)"extract", createNewEntryRow);
                String proficient_evaltype = (String)map.get("proficient_evaltype");
                if (proficient_evaltype.equals("TECHNICAL")) {
                    this.getModel().setValue("proficient_technical", (Object)Boolean.TRUE, createNewEntryRow);
                    this.getModel().setValue("proficient_commercial", (Object)Boolean.FALSE, createNewEntryRow);
                    continue;
                }
                if (proficient_evaltype.equals("BUSSINESS")) {
                    this.getModel().setValue("proficient_technical", (Object)Boolean.FALSE, createNewEntryRow);
                    this.getModel().setValue("proficient_commercial", (Object)Boolean.TRUE, createNewEntryRow);
                    continue;
                }
                if (!proficient_evaltype.equals("MULTI")) continue;
                this.getModel().setValue("proficient_technical", (Object)Boolean.TRUE, createNewEntryRow);
                this.getModel().setValue("proficient_commercial", (Object)Boolean.TRUE, createNewEntryRow);
            }
            this.getModel().updateCache();
        }
    }

    private DynamicObjectType getEntryType(String parentBillId, String entryId) {
        MainEntityType parentDT = EntityMetadataCache.getDataEntityType((String)parentBillId);
        DynamicObject parent = new DynamicObject((DynamicObjectType)parentDT);
        DynamicObjectCollection entryCol = parent.getDynamicObjectCollection(entryId);
        DynamicObjectType entryDT = entryCol.getDynamicObjectType();
        return entryDT;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"proficient_list"});
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "proficient_f7": {
                return "bid_proficient_f7";
            }
            case "extract_proficient": {
                return "bid_extract_proficient";
            }
        }
        return null;
    }
}

