/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.bid.business.bill.IBidAnnocumentService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidAnnocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.DefaultOrgReg;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidProjectDateEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BidTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.InvitationStatusEnum;
import kd.scm.bid.common.enums.PurchaseModel;
import kd.scm.bid.common.enums.RespBusiness;
import kd.scm.bid.common.util.BidProjectAnnouncementsUtils;
import kd.scm.bid.common.util.DefaultOrgUtil;
import kd.scm.bid.common.util.GetSysParamterUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.BidBillEdit;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.scm.bid.formplugin.bill.helper.PermissionHepler;
import kd.scm.bid.formplugin.bill.util.CheckAnnocumentIsSign;
import kd.scm.bid.formplugin.util.BidTransferUtil;

public class BidProjectEdit
extends BidBillEdit
implements BeforeF7SelectListener,
CellClickListener,
AfterF7SelectListener {
    public static final String PUR_TYPE_CHANGE = "purType_Change";
    private static final String FIELD_ENABLE_MULTI_SECTION = "enablemultisection";
    private static final String OPEN_BIDDING = "Open bidding";
    private static final String TITLE = "title";
    private static final String BILL_STATUS = "billstatus";
    private static final String NEED_REFRESH = "needRefresh";
    private static final String SECTION_PUR_DETAIL_SUPPLIER_CONTAINER = "purdetailsplitcontainer";
    private static final String SECTION_PUR_DETAIL_CONTAINER = "bidpurentrypanel";
    private static final String RECOSUPPLIERTABPAGE = "recosuppliertabpage";
    private static final String F7_POSITION = "position";
    private IBidProjectService projectService = new BidProjectServiceImpl();
    private IBidAnnocumentService annocumentService = new BidAnnocumentServiceImpl();
    private ISupplierInvitationService supplierInvitationService = new SupplierInvitationServiceImpl();
    private static final IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();

    public String getBidMethodId() {
        String bidModeId = "";
        QFilter[] qFilters = null;
        qFilters = new QFilter[]{new QFilter("entityTypeId", "=", (Object)"bid_bidmode"), new QFilter("enable", "=", (Object)"1")};
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bid_bidmode", (String)"id,number", (QFilter[])qFilters, (String)"number asc");
        if (coll != null && coll.size() != 0) {
            bidModeId = ((DynamicObject)coll.get(0)).getString("id");
        }
        return bidModeId;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject data = this.getModel().getDataEntity(true);
        if (BidModeHelper.isPublicBidding(data)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RECOSUPPLIERTABPAGE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{RECOSUPPLIERTABPAGE});
        }
        String entityType = this.getView().getEntityId();
        this.getModel().setValue("entitytypeid", (Object)entityType);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid4PurDetail = (EntryGrid)this.getControl("projectentry");
        if (entryGrid4PurDetail == null) {
            return;
        }
        entryGrid4PurDetail.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid4Session = (EntryGrid)this.getControl("bidsection");
        if (entryGrid4Session == null) {
            return;
        }
        entryGrid4Session.addRowClickListener((RowClickEventListener)this);
        EntryGrid enrollEntryGrid = (EntryGrid)this.getView().getControl("bidrollsection");
        enrollEntryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit positionEdit = (BasedataEdit)this.getView().getControl(F7_POSITION);
        positionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit userEdit = (BasedataEdit)this.getView().getControl("user");
        userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit userLeaderEdit = (BasedataEdit)this.getView().getControl("userleader");
        userLeaderEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit purtypeEdit = (BasedataEdit)this.getView().getControl("purtype");
        purtypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit purentryproject = (BasedataEdit)this.getView().getControl("purentryproject");
        purentryproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialid = (BasedataEdit)this.getView().getControl("materialid");
        materialid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        materialid.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    /*
     * WARNING - void declaration
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block58: {
            boolean enableMultiSec;
            DynamicObjectCollection bidSections;
            block68: {
                String operateKey;
                FormOperate operate;
                block67: {
                    String appId;
                    block65: {
                        DynamicObjectCollection sectionCols;
                        block66: {
                            block63: {
                                block64: {
                                    block62: {
                                        int selectLength;
                                        DynamicObjectCollection bidsection;
                                        int bidSectionSize;
                                        block61: {
                                            block59: {
                                                block60: {
                                                    DynamicObject section;
                                                    block57: {
                                                        DynamicObject bidMode;
                                                        boolean enable;
                                                        boolean hasPermission;
                                                        super.beforeDoOperation(args);
                                                        operate = (FormOperate)args.getSource();
                                                        operateKey = operate.getOperateKey();
                                                        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                                                        appId = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
                                                        Long orgPk = 0L;
                                                        if (org != null) {
                                                            orgPk = (Long)org.getPkValue();
                                                        }
                                                        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"invalid")) {
                                                            Object project;
                                                            String checkQueryIsProcess;
                                                            args.setCancel(true);
                                                            hasPermission = PermissionHepler.checkPermission("QXX0044", orgPk, appId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
                                                            if (!hasPermission) {
                                                                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6d41\u6807\u6309\u94ae\u7684\u6743\u9650\u3002", (String)"BidProjectEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                                                return;
                                                            }
                                                            BidDecisionServiceImpl decisionService = new BidDecisionServiceImpl();
                                                            DynamicObject decision = decisionService.getBidDecisionByProjectId((Long)this.getModel().getDataEntity().getPkValue(), "billstatus, datasource, synxkflag");
                                                            if (decision != null && BillStatusEnum.AUDITED.getVal().equals(decision.getString(BILL_STATUS))) {
                                                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62db\u6807\u9879\u5df2\u5b9a\u6807\uff0c\u4e0d\u5141\u8bb8\u6d41\u6807\u3002", (String)"BidProjectEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                                                return;
                                                            }
                                                            if (decision != null) {
                                                                String datasource = decision.getString("datasource");
                                                                Boolean synXkFlag = decision.getBoolean("synxkflag");
                                                                Boolean flag = synXkFlag != false && "1".equals(datasource);
                                                                if (flag.booleanValue()) {
                                                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5df2\u751f\u6210\u661f\u7a7a\u91c7\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6d41\u6807\u64cd\u4f5c\u3002", (String)"BidProjectEdit_49", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                                                    return;
                                                                }
                                                            }
                                                            if (StringUtils.isNotBlank((CharSequence)(checkQueryIsProcess = questionClarifyService.checkQueryIsProcess(Long.valueOf(Long.parseLong((project = this.getView().getModel().getDataEntity(true).getPkValue()).toString())), appId)))) {
                                                                this.getView().showErrorNotification(ResManager.loadKDString((String)checkQueryIsProcess, (String)"BidProjectListUI_16", (String)"BidProjectEdit_63", (Object[])new Object[0]));
                                                                return;
                                                            }
                                                            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("invalid", (IFormPlugin)this);
                                                            this.getView().showConfirm(ResManager.loadKDString((String)"\u6d41\u6807\u540e\u672c\u6b21\u7acb\u9879\u6240\u6709\u4e1a\u52a1\u5355\u636e\u90fd\u5c06\u53d8\u4e3a\u6d41\u6807\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BidProjectEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                                                        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"invalidcored")) {
                                                            args.setCancel(true);
                                                            ListShowParameter listShowParameter = new ListShowParameter();
                                                            listShowParameter.setCustomParam("bidproject", this.getView().getModel().getDataEntity(true).getPkValue());
                                                            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                                                            listShowParameter.setBillFormId(appId + "_projectcancel");
                                                            this.getView().showForm((FormShowParameter)listShowParameter);
                                                            return;
                                                        }
                                                        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"addnewannouncement")) {
                                                            hasPermission = PermissionHepler.checkPermission("QXX0114", orgPk, appId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
                                                            if (!hasPermission) {
                                                                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53d1\u5e03\u62db\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidProjectEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                                                args.setCancel(true);
                                                                return;
                                                            }
                                                        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"checkannouncement")) {
                                                            hasPermission = PermissionHepler.checkPermission("QXX0115", orgPk, appId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
                                                            if (!hasPermission) {
                                                                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u770b\u62db\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidProjectEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                                                args.setCancel(true);
                                                                return;
                                                            }
                                                        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"revokeannouncement")) {
                                                            hasPermission = PermissionHepler.checkPermission("QXX0116", orgPk, appId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
                                                            if (!hasPermission) {
                                                                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64a4\u9500\u62db\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidProjectEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                                                args.setCancel(true);
                                                                return;
                                                            }
                                                        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"publishinvitation")) {
                                                            this.publishInvitation(args);
                                                        } else if ("viewinvitation".equals(operateKey)) {
                                                            this.viewInvitation(args);
                                                        }
                                                        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                                                        Object customParam = formShowParameter.getCustomParam("adjustpromsg");
                                                        if ((customParam == null || !customParam.equals("yes")) && ("save".equals(operateKey) || "submit".equals(operateKey)) && (enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable")) && (bidMode = this.getModel().getDataEntity(true).getDynamicObject("bidmode")) != null) {
                                                            boolean hasOpen = bidMode.getBoolean("bidopen");
                                                            boolean hasPublish = bidMode.getBoolean("bidpublish");
                                                            if (hasOpen && !hasPublish) {
                                                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u91c7\u8d2d\u65b9\u5f0f\u7f3a\u5c11\u53d1\u6807\u73af\u8282\uff0c\u4e0d\u652f\u6301\u7ebf\u4e0a\u5f00\u6807\u3002", (String)"BidProjectEdit_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                                                args.setCancel(true);
                                                                return;
                                                            }
                                                        }
                                                        if (!"extractsupplier".equals(operateKey)) break block57;
                                                        int rowIndex = this.getModel().getEntryCurrentRowIndex("bidrollsection");
                                                        section = this.getModel().getEntryRowEntity("bidrollsection", rowIndex);
                                                        String id = this.getModel().getDataEntity().getPkValue().toString();
                                                        if ("0".equals(id)) {
                                                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u672c\u5355\u636e\u3002", (String)"BidProjectEdit_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                                            return;
                                                        }
                                                        if (section != null) {
                                                            Long sectionId = section.getLong("id");
                                                            DynamicObject bidProject = this.getModel().getDataEntity();
                                                            Object orgId = bidProject.getDynamicObject("org").getPkValue();
                                                            String entrustmentway = bidProject.getString("entrustmentway");
                                                            BillShowParameter showParameter = new BillShowParameter();
                                                            if ("bid".equals(FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()))) {
                                                                showParameter.setFormId("bid_patchsupplier");
                                                                showParameter.setCustomParam("isProject", (Object)Boolean.FALSE);
                                                                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bid_patchsupplier");
                                                                showParameter.setCloseCallBack(closeCallBack);
                                                                showParameter.setCustomParam("projectId", (Object)this.getModel().getDataEntity().getPkValue().toString());
                                                            } else {
                                                                showParameter.setFormId("rebm_patchsupplier");
                                                                ArrayList<Object> supplierGroupList = new ArrayList<Object>();
                                                                DynamicObjectCollection supplierGroupCol = bidProject.getDynamicObjectCollection("suppliergroup");
                                                                for (DynamicObject supplierGroup : supplierGroupCol) {
                                                                    DynamicObject baseData = supplierGroup.getDynamicObject("fbasedataid");
                                                                    if (baseData == null) continue;
                                                                    supplierGroupList.add(baseData.getPkValue());
                                                                }
                                                                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rebm_patchsupplier");
                                                                showParameter.setCloseCallBack(closeCallBack);
                                                                showParameter.setCustomParam("supplierGroupList", supplierGroupList);
                                                                showParameter.setCustomParam("isProject", (Object)Boolean.TRUE);
                                                                showParameter.setCustomParam("supplierInvitationId", (Object)this.getModel().getDataEntity().getPkValue().toString());
                                                            }
                                                            showParameter.setCustomParam("sectionId", (Object)sectionId);
                                                            if ("03".equals(entrustmentway)) {
                                                                Object entrustmentOrgId = null;
                                                                if (bidProject.getDynamicObject("entrustmentorgunit") != null) {
                                                                    entrustmentOrgId = bidProject.getDynamicObject("entrustmentorgunit").getPkValue();
                                                                }
                                                                showParameter.setCustomParam("orgId", entrustmentOrgId);
                                                            } else {
                                                                showParameter.setCustomParam("orgId", orgId);
                                                            }
                                                            showParameter.setCustomParam("operation", (Object)"extractsupplier");
                                                            showParameter.getOpenStyle().setShowType(ShowType.Modal);
                                                            showParameter.setStatus(OperationStatus.ADDNEW);
                                                            this.getView().showForm((FormShowParameter)showParameter);
                                                        }
                                                        break block58;
                                                    }
                                                    if (!"extracthistory".equals(operateKey)) break block59;
                                                    int rowIndex = this.getModel().getEntryCurrentRowIndex("bidrollsection");
                                                    section = this.getModel().getEntryRowEntity("bidrollsection", rowIndex);
                                                    DynamicObject extractSupplier = null;
                                                    if (section == null) break block58;
                                                    Long sectionId = section.getLong("id");
                                                    extractSupplier = "bid".equals(FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass())) ? BusinessDataServiceHelper.loadSingle((String)"rebm_propatchsupplier", (String)"id,extractsupplierentry", (QFilter[])new QFilter[]{new QFilter("sectionid", "=", (Object)sectionId), new QFilter("supplierid", "=", (Object)this.getModel().getDataEntity().getPkValue().toString())}) : BusinessDataServiceHelper.loadSingle((String)"rebm_patchsupplier", (String)"id,extractsupplierentry", (QFilter[])new QFilter[]{new QFilter("sectionid", "=", (Object)sectionId), new QFilter("supplierid", "=", (Object)this.getModel().getDataEntity().getPkValue().toString())});
                                                    if (extractSupplier == null) break block60;
                                                    ListShowParameter showParameter = new ListShowParameter();
                                                    if ("bid".equals(this.getAppId())) {
                                                        showParameter.setFormId("bid_patchsup_history");
                                                        showParameter.setCustomParam("projectId", this.getModel().getDataEntity().getPkValue());
                                                    } else {
                                                        showParameter.setFormId("rebm_extract_history");
                                                        showParameter.setCustomParam("supplierInvitationId", this.getModel().getDataEntity().getPkValue());
                                                    }
                                                    showParameter.setCustomParam("sectionId", (Object)sectionId);
                                                    showParameter.setCustomParam("operation", (Object)"extracthistory");
                                                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                                                    showParameter.setStatus(OperationStatus.VIEW);
                                                    this.getView().showForm((FormShowParameter)showParameter);
                                                    break block58;
                                                }
                                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u62bd\u53d6\u5386\u53f2\u8bb0\u5f55\u3002", (String)"BidProjectEdit_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                                return;
                                            }
                                            if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"newsectionentry")) break block61;
                                            this.getView().updateView("bidrollsection");
                                            this.getView().updateView("bidsection");
                                            break block58;
                                        }
                                        if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"deletesectionentry")) break block62;
                                        DynamicObject project = this.getModel().getDataEntity(true);
                                        DynamicObjectCollection rollSectionColl = project.getDynamicObjectCollection("bidrollsection");
                                        DynamicObjectCollection bidSectionColl = project.getDynamicObjectCollection("bidsection");
                                        DynamicObjectCollection supplierColl = this.getModel().getEntryEntity("supplierentry");
                                        EntryGrid entryGrid4Session = (EntryGrid)this.getControl("bidsection");
                                        int[] selects = entryGrid4Session.getSelectRows();
                                        if (selects.length == 0) {
                                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u64cd\u4f5c\u3002", (String)"BidProjectEdit_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                            return;
                                        }
                                        boolean enablemultisection = project.getBoolean(FIELD_ENABLE_MULTI_SECTION);
                                        if (enablemultisection && (bidSectionSize = (bidsection = project.getDynamicObjectCollection("bidsection")).size()) - (selectLength = selects.length) < 2) {
                                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u6807\u6bb5\u62db\u6807\u9700\u81f3\u5c11\u5305\u542b\u4e24\u4e2a\u6807\u6bb5", (String)"BidProjectEdit_72", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                            args.setCancel(true);
                                            return;
                                        }
                                        if (supplierColl != null && supplierColl.size() > 0) {
                                            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deletesectionentry", (IFormPlugin)this);
                                            String confirmTip = ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u5b58\u5728\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"BidProjectEdit_10", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                                            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                                        } else {
                                            for (int i = 0; i < selects.length; ++i) {
                                                int select = selects[i];
                                                for (int j = 0; j < rollSectionColl.size(); ++j) {
                                                    if (j != select) continue;
                                                    bidSectionColl.remove(j);
                                                    rollSectionColl.remove(j);
                                                }
                                            }
                                            this.getView().updateView("bidrollsection");
                                            this.getView().updateView("bidsection");
                                        }
                                        break block58;
                                    }
                                    if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"newprojectentry")) break block63;
                                    boolean enableMultiSection = (Boolean)this.getModel().getValue(FIELD_ENABLE_MULTI_SECTION);
                                    if (enableMultiSection) break block64;
                                    this.setSingleSectionStatus();
                                    break block58;
                                }
                                sectionCols = this.getModel().getEntryEntity("bidsection");
                                if (sectionCols != null && sectionCols.size() != 0) break block58;
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u65b0\u589e\u6807\u6bb5\u3002", (String)"BidProjectEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                args.setCancel(true);
                                break block58;
                            }
                            if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"newrollsupplierentry")) break block65;
                            boolean enableMultiSection = (Boolean)this.getModel().getValue(FIELD_ENABLE_MULTI_SECTION);
                            if (enableMultiSection) break block66;
                            this.setSingleSectionStatus();
                            break block58;
                        }
                        sectionCols = this.getModel().getEntryEntity("bidrollsection");
                        if (sectionCols != null && sectionCols.size() != 0) break block58;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u65b0\u589e\u6807\u6bb5\u3002", (String)"BidProjectEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        break block58;
                    }
                    if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"importpurplan")) break block58;
                    if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit")) break block67;
                    Object pkValue = this.getModel().getDataEntity().getPkValue();
                    String billStatus = this.annocumentService.getBillStatus(pkValue, (Object)"bidproject");
                    if (billStatus != null && billStatus.equals(BillStatusEnum.RELEASED.getVal())) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u5df2\u53d1\u5e03\u62db\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidProjectEdit_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String name = this.getModel().getDataEntity(true).getString("name");
                    if (QueryServiceHelper.exists((String)"bid_adjustmentrecord", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name), new QFilter("entitytypeid", "=", (Object)(appId + "_adjustmentrecord")), new QFilter(BILL_STATUS, "!=", (Object)"C")})) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7acb\u9879\u8c03\u6574\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidProjectEdit_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    break block58;
                }
                if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) break block58;
                Object bidType = this.getModel().getValue("bidtype");
                bidSections = this.getModel().getEntryEntity("bidsection");
                enableMultiSec = (Boolean)this.getModel().getValue(FIELD_ENABLE_MULTI_SECTION);
                if (StringUtils.isBlank((Object)bidType) || BidTypeEnum.PROJECT.getValue().equals(bidType)) break block68;
                String HavingRepSection = "";
                Boolean isHavingWeakRep = Boolean.FALSE;
                Boolean isHavingStrongRep = Boolean.FALSE;
                String agreeSubmit = this.getPageCache().get("agreeSubmit");
                for (DynamicObject bidsection : bidSections) {
                    ArrayList materials = new ArrayList(10);
                    String sectionname = bidsection.getString("sectionname");
                    DynamicObjectCollection projectentrySections = bidsection.getDynamicObjectCollection("projectentry");
                    for (int j = 0; j < projectentrySections.size(); ++j) {
                        void var26_75;
                        DynamicObject purDetail = (DynamicObject)projectentrySections.get(j);
                        if (purDetail.getDynamicObject("materialid") == null) {
                            return;
                        }
                        String newMaterial = purDetail.getDynamicObject("materialid").get("number").toString();
                        String newDescription = purDetail.getString("materialdes");
                        if (newDescription == null) {
                            newDescription = "";
                        }
                        for (Map map : materials) {
                            String oldMaterial = (String)map.get("material");
                            String oldDescription = (String)map.get("description");
                            if (oldMaterial.equals(newMaterial) && oldDescription.equals(newDescription)) {
                                if (!enableMultiSec) {
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u201d\u4ea7\u54c1\u7f16\u7801\u201c +\u201d\u4ea7\u54c1\u63cf\u8ff0\u201c,\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectEdit_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                } else {
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s:\u5b58\u5728\u91cd\u590d\u7684\u201c\u4ea7\u54c1\u7f16\u7801\u201d +\u201c\u4ea7\u54c1\u63cf\u8ff0\u201d,\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectEdit_15", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionname));
                                }
                                args.setCancel(true);
                                return;
                            }
                            if (oldMaterial.equals(newMaterial) && !oldDescription.equals(newDescription)) {
                                isHavingWeakRep = Boolean.TRUE;
                            }
                            if (!oldMaterial.equals(newMaterial) || !oldDescription.equals(newDescription)) continue;
                            isHavingStrongRep = Boolean.TRUE;
                        }
                        HashMap<String, Object> material = new HashMap<String, Object>();
                        String string = purDetail.getString("materialdes");
                        if (string == null) {
                            String string2 = "";
                        }
                        material.put("material", purDetail.getDynamicObject("materialid").get("number").toString());
                        material.put("description", var26_75);
                        materials.add(material);
                    }
                    if (!isHavingStrongRep.booleanValue()) continue;
                    HavingRepSection = HavingRepSection.concat(sectionname).concat("\u3001");
                }
                if (HavingRepSection.length() > 0) {
                    HavingRepSection = HavingRepSection.substring(0, HavingRepSection.length() - 1);
                }
                if (!isHavingWeakRep.booleanValue() || agreeSubmit != null) break block58;
                RefObject afterConfirm = new RefObject();
                if (operate.getOption().tryGetVariableValue("submit", afterConfirm)) break block58;
                args.setCancel(true);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("projectentry", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u201c\u4ea7\u54c1\u7f16\u7801\u201d ,\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4?", (String)"BidProjectEdit_16", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                break block58;
            }
            for (DynamicObject bidsection : bidSections) {
                String sectionname = bidsection.getString("sectionname");
                DynamicObjectCollection projectentrySections = bidsection.getDynamicObjectCollection("projectentry");
                int projectentrySectionSize = projectentrySections.size();
                for (int i = 0; i < projectentrySectionSize; ++i) {
                    DynamicObject detail = (DynamicObject)projectentrySections.get(i);
                    String purentrycontent = detail.getString("purentrycontent") == null ? "" : detail.getString("purentrycontent");
                    String purentryprojectid = detail.getDynamicObject("purentryproject") == null ? "" : detail.getDynamicObject("purentryproject").getString("id");
                    for (int j = i + 1; j < projectentrySectionSize; ++j) {
                        String detailCompareprojectid;
                        DynamicObject detailCompare = (DynamicObject)projectentrySections.get(j);
                        String detailComparecontent = detailCompare.getString("purentrycontent") == null ? "" : detailCompare.getString("purentrycontent");
                        String string = detailCompareprojectid = detailCompare.getDynamicObject("purentryproject") == null ? "" : detailCompare.getDynamicObject("purentryproject").getString("id");
                        if (!StringUtils.equals((CharSequence)purentrycontent, (CharSequence)detailComparecontent) || !StringUtils.equals((CharSequence)purentryprojectid, (CharSequence)detailCompareprojectid)) continue;
                        if (!enableMultiSec) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u201d\u62db\u6807\u5185\u5bb9\u201c +\u201d\u91c7\u8d2d\u9879\u76ee\u201c,\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectEdit_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        } else {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s:\u5b58\u5728\u91cd\u590d\u7684\u201c\u62db\u6807\u5185\u5bb9 \u201d+\u201c\u91c7\u8d2d\u9879\u76ee\u201d,\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectEdit_18", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionname));
                        }
                        args.setCancel(true);
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String fieldKey = closedCallBackEvent.getActionId();
        if (NEED_REFRESH.equals(fieldKey)) {
            this.getView().invokeOperation("refresh");
        }
        if ("bid_patchsupplier".equals(fieldKey) && closedCallBackEvent.getReturnData() != null) {
            Object[] resultObject = (Object[])closedCallBackEvent.getReturnData();
            List extractSupplier = (List)resultObject[0];
            int rowIndex = this.getModel().getEntryCurrentRowIndex("bidsection");
            DynamicObject section = this.getModel().getEntryRowEntity("bidrollsection", rowIndex);
            DynamicObjectCollection supplierColl = section.getDynamicObjectCollection("supplierentry");
            if (extractSupplier != null && extractSupplier.size() > 0) {
                for (int i = 0; i < extractSupplier.size(); ++i) {
                    DynamicObject supplierEntry = supplierColl.addNew();
                    supplierEntry.set("supplier", (Object)((DynamicObject)extractSupplier.get(i)).getDynamicObject("supplier"));
                    this.carryInfosBySupplier(this.getModel(), (Long)((DynamicObject)extractSupplier.get(i)).getDynamicObject("supplier").getPkValue(), i, supplierEntry);
                }
            }
            this.getView().updateView("supplierentry");
        } else if ("rebm_patchsupplier".equals(fieldKey) && closedCallBackEvent.getReturnData() != null) {
            Object[] resultObject = (Object[])closedCallBackEvent.getReturnData();
            List extractSupplier = (List)resultObject[0];
            int rowIndex = this.getModel().getEntryCurrentRowIndex("bidsection");
            DynamicObject section = this.getModel().getEntryRowEntity("bidrollsection", rowIndex);
            DynamicObjectCollection supplierColl = section.getDynamicObjectCollection("supplierentry");
            if (extractSupplier != null && extractSupplier.size() > 0) {
                for (int i = 0; i < extractSupplier.size(); ++i) {
                    DynamicObject supplierEntry = supplierColl.addNew();
                    DynamicObject resmSupplier = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)extractSupplier.get(i)).getDynamicObject("supplier").getPkValue(), (String)"resm_official_supplier");
                    supplierEntry.set("supplier", (Object)resmSupplier);
                    supplierEntry.set("suppliersource", (Object)"resm_official_supplier");
                    supplierEntry.set("suppliername", (Object)resmSupplier);
                    this.carryInfosBySupplier(this.getModel(), (Long)resmSupplier.getPkValue(), supplierColl.size() - 1, supplierEntry);
                }
            }
            this.getView().updateView("supplierentry");
        } else if ("publishInvitation".equals(fieldKey) && closedCallBackEvent.getReturnData() != null || "addsupplier".equals(fieldKey)) {
            // empty if block
        }
    }

    @Override
    protected void setSingleSectionStatus() {
        EntryGrid entryGrid4Session = (EntryGrid)this.getControl("bidsection");
        DynamicObjectCollection sectionCols = this.getModel().getEntryEntity("bidsection");
        EntryGrid entryRollGrid = (EntryGrid)this.getControl("bidrollsection");
        DynamicObjectCollection rollSectionCol = this.getModel().getEntryEntity("bidrollsection");
        this.getModel().beginInit();
        DynamicObject section = null;
        DynamicObject rollSection = null;
        EntityType type = this.projectService.createSectionType();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_project");
        EntityType rollType = (EntityType)mainType.getAllEntities().get("bidrollsection");
        if (sectionCols != null && sectionCols.size() != 0) {
            section = (DynamicObject)sectionCols.get(0);
        } else {
            section = new DynamicObject((DynamicObjectType)type);
            this.getModel().createNewEntryRow("bidsection", section);
        }
        if (rollSectionCol != null && rollSectionCol.size() != 0) {
            rollSection = (DynamicObject)rollSectionCol.get(0);
        } else {
            rollSection = new DynamicObject((DynamicObjectType)rollType);
            this.getModel().createNewEntryRow("bidrollsection", rollSection);
        }
        String sid = section.getString("id");
        String rid = section.getString("id");
        if ("0".equals(sid)) {
            ORM orm = ORM.create();
            long id = orm.genLongId((IDataEntityType)type);
            section.set("id", (Object)id);
            if ("0".equals(rid)) {
                rollSection.set("id", (Object)id);
            }
        }
        section.set("sectionname", (Object)ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"BidProjectEdit_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        rollSection.set("rollsectionname", (Object)ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"BidProjectEdit_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        BigDecimal deposit = (BigDecimal)this.getModel().getValue("deposit");
        this.getModel().setValue("secdeposit", (Object)deposit, 0);
        this.getView().updateView("bidsection");
        this.getView().updateView("bidrollsection");
        entryGrid4Session.selectRows(0);
        entryRollGrid.selectRows(0);
        this.getModel().endInit();
    }

    @Override
    public void afterBindData(EventObject e) {
        Boolean isCopy;
        FormShowParameter formShowParameter;
        Map<String, Boolean> stringBooleanMap;
        DynamicObject bidModel;
        FieldEdit projectentry_qty;
        boolean enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        Label label = (Label)this.getControl(TITLE);
        if (label != null) {
            FormShowParameter formShowParameter2 = this.getView().getFormShowParameter();
            String title = formShowParameter2.getCaption();
            if (StringUtils.isNotBlank((CharSequence)title)) {
                title = formShowParameter2.getFormConfig().getCaption().toString();
            }
            label.setText(formShowParameter2.getCaption());
        }
        boolean enableMultiSec = (Boolean)this.getModel().getValue(FIELD_ENABLE_MULTI_SECTION);
        this.setEnableMultiSection(enableMultiSec, true);
        this.setBillStatus();
        this.setPurModelStatus();
        this.setBidModelStatus();
        this.getView().setVisible((Boolean)this.getModel().getValue("clarificaiton"), new String[]{"clarificaitondate"});
        this.getView().setVisible((Boolean)this.getModel().getValue("bidbottommake"), new String[]{"bidbottommakedate"});
        Object sid = this.getView().getFormShowParameter().getCustomParam("sourceProjectId");
        if (sid != null) {
            this.getModel().setValue("sourceproject", sid);
            Object id = this.getModel().getDataEntity().getPkValue();
            if ("0".equals(id.toString())) {
                id = ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType());
                this.getModel().setValue("id", id);
            }
            this.projectService.copyAttachment(sid, id);
            this.getView().updateView("attachmentpanel");
        }
        this.setEntrustmentWayDisplayStytle();
        TextEdit purContent = (TextEdit)this.getView().getControl("purentrycontent");
        if (purContent != null) {
            purContent.setMustInput(true);
        }
        BasedataEdit position = (BasedataEdit)this.getView().getControl(F7_POSITION);
        position.setDisplayProp(F7_POSITION);
        Object id = this.getModel().getValue("id");
        if (String.valueOf(id).equals("0")) {
            this.getPageCache().put("isChanged", "0");
        }
        if (enable) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isallowrevoke"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isallowrevoke"});
        }
        String bidType = this.getModel().getDataEntity().getString("bidtype");
        if (BidTypeEnum.MATERIAL.getValue().equals(bidType) || BidTypeEnum.RESOURCE.getValue().equals(bidType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isratebidding"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"purentrycontent"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"workload"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"purentryworkload"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialid"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"model"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"unit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"baseunit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"qty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialdes"});
        }
        FieldEdit projectentry_materialid = (FieldEdit)this.getView().getControl("materialid");
        if (projectentry_materialid != null) {
            projectentry_materialid.setMustInput(true);
        }
        if ((projectentry_qty = (FieldEdit)this.getView().getControl("qty")) != null) {
            projectentry_qty.setMustInput(true);
        }
        this.controlListBtnStatus();
        String docTypeStr = (String)this.getModel().getValue("doctype");
        if (BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bidopentype"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"isseparatedoc"});
        } else {
            this.getModel().setValue("bidopentype", (Object)BidOpenSelectTypeEnum.UNIONOPEN.getValue());
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidopentype", "isseparatedoc", "backbidway", "bidopentype"});
            this.getModel().setValue("isseparatedoc", (Object)Boolean.FALSE);
            boolean isBidDocument = (Boolean)this.getModel().getValue("biddocument");
            if (isBidDocument) {
                if (docTypeStr.equals(BidOpenTypeEnum.TECHNICAL.getValue())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"technicaldocenddate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"commercialdocenddate"});
                } else if (docTypeStr.equals(BidOpenTypeEnum.BUSSINESS.getValue())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"commercialdocenddate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"technicaldocenddate"});
                }
            }
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        Object pkValue = dataEntity.getPkValue();
        if (null != pkValue && !WorkflowServiceHelper.inProcess((String)pkValue.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
        }
        if ((bidModel = dataEntity.getDynamicObject("bidmode")) != null && ((stringBooleanMap = BidModeHelper.hasPublicOrOpen(bidModel)) == null || stringBooleanMap.size() == 0)) {
            List<ComboItem> cis = this.makeCombByFlag(false, false, false);
            this.dealProchangeByBidmode(dataEntity, false, cis);
        }
        if ((formShowParameter = this.getView().getFormShowParameter()) != null && (isCopy = (Boolean)formShowParameter.getCustomParam("iscopy")) != null && isCopy.booleanValue()) {
            Long sourceProjectId = (Long)formShowParameter.getCustomParam("sourceProjectId");
            DynamicObject sourceData = BusinessDataServiceHelper.loadSingle((Object)sourceProjectId, (String)formShowParameter.getFormId());
            DynamicObjectCollection proficientEntry = dataEntity.getDynamicObjectCollection("bid_proficiententry");
            proficientEntry.clear();
            DynamicObjectCollection sourceProficientEntry = sourceData.getDynamicObjectCollection("bid_proficiententry");
            for (DynamicObject sourceProficient : sourceProficientEntry) {
                DynamicObject proficient = proficientEntry.addNew();
                proficient.set("proficient", (Object)sourceProficient.getDynamicObject("proficient"));
                proficient.set("proficient_technical", sourceProficient.get("proficient_technical"));
                proficient.set("proficient_commercial", sourceProficient.get("proficient_commercial"));
                proficient.set("proficient_comment", sourceProficient.get("proficient_comment"));
            }
            DynamicObjectCollection memberEntityCol = dataEntity.getDynamicObjectCollection("memberentity");
            memberEntityCol.clear();
            DynamicObjectCollection sourceMemberEntityCol = sourceData.getDynamicObjectCollection("memberentity");
            for (DynamicObject sourceMemberEntity : sourceMemberEntityCol) {
                DynamicObject memberEntity = memberEntityCol.addNew();
                memberEntity.set("user", (Object)sourceMemberEntity.getDynamicObject("user"));
                memberEntity.set(F7_POSITION, (Object)sourceMemberEntity.getDynamicObject(F7_POSITION));
                memberEntity.set("respbusiness", sourceMemberEntity.get("respbusiness"));
                memberEntity.set("isdirector", sourceMemberEntity.get("isdirector"));
                memberEntity.set("membercomment", sourceMemberEntity.get("membercomment"));
            }
            this.getView().updateView("memberentity");
            this.getView().updateView("bid_proficiententry");
        }
        String datasource = dataEntity.getString("datasource");
        String billstatus = dataEntity.getString(BILL_STATUS);
        if ("2".equals(datasource) && "A".equals(billstatus)) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
        }
    }

    public void setBillStatus() {
        IDataEntityProperty property = this.getModel().getProperty(BILL_STATUS);
        if (property != null) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            } else {
                String value = (String)this.getModel().getValue(BILL_STATUS);
                if (BillStatusEnum.SAVE.getVal().equals(value)) {
                    boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (bFromDb) {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                    } else {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
                    }
                } else if (BillStatusEnum.SUBMIT.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
                } else if (BillStatusEnum.AUDITED.getVal().equals(value) || BillStatusEnum.AUDITING.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
                    if (BillStatusEnum.AUDITING.getVal().equals(value)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unaudit", "bar_audit"});
                    }
                } else if (BillStatusEnum.INVALID.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String changeFlag;
        super.beforeClosed(e);
        Object id = this.getModel().getValue("id");
        if (String.valueOf(id).equals("0") && "0".equals(changeFlag = this.getPageCache().get("isChanged"))) {
            this.getModel().setDataChanged(false);
        }
        String billStatus = (String)this.getModel().getValue(BILL_STATUS);
        if (BillStatusEnum.AUDITED.getVal().equals(billStatus) || BillStatusEnum.SUBMIT.getVal().equals(billStatus) || BillStatusEnum.AUDITING.getVal().equals(billStatus)) {
            this.getModel().setDataChanged(false);
        }
    }

    public void commonPurModelBeforeChange(String purModel) {
        if (PurchaseModel.StrategySourcing.getVal().equals(purModel)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("purmodel", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5355\u9879\u91c7\u8d2d\u5207\u6362\u5230\u6218\u7565\u91c7\u8d2d\uff0c\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u91c7\u8d2d\u660e\u7ec6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BidProjectEdit_20", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            String confirmTip1 = ResManager.loadKDString((String)"\u5355\u9879\u91c7\u8d2d\u5207\u6362\u5230\u6218\u7565\u91c7\u8d2d\uff0c\u4f1a\u6e05\u9664\u5f53\u524d\u6807\u6bb5\u7684\u4fe1\u606f\u4ee5\u53ca\u91c7\u8d2d\u660e\u7ec6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BidProjectEdit_21", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            boolean enableMultiSection = (Boolean)this.getModel().getValue(FIELD_ENABLE_MULTI_SECTION);
            if (enableMultiSection) {
                this.getView().showConfirm(confirmTip1, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            } else {
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if (PurchaseModel.ProjectProcurement.getVal().equals(purModel)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_ENABLE_MULTI_SECTION, SECTION_PUR_DETAIL_CONTAINER, "purdetailcontainer"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"totalcontrol"});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Object pkvalue;
        String billStatus;
        super.propertyChanged(e);
        this.getPageCache().put("isChanged", "1");
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        DynamicObject bidModel = (DynamicObject)this.getModel().getValue("bidmode");
        boolean openBidingFlag = BidModeHelper.isPublicBiddingByModel(bidModel);
        if (StringUtils.equals((CharSequence)FIELD_ENABLE_MULTI_SECTION, (CharSequence)fieldKey)) {
            boolean enableMultiSection = (Boolean)newVal;
            String confirmTip = "";
            if (!enableMultiSection) {
                this.setEnableMul(false, false);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(FIELD_ENABLE_MULTI_SECTION, (IFormPlugin)this);
                DynamicObject data = this.getModel().getDataEntity(true);
                confirmTip = openBidingFlag ? ResManager.loadKDString((String)"\u591a\u6807\u6bb5\u5207\u6362\u4e3a\u5355\u6807\u6bb5\uff0c\u4f1a\u6e05\u9664\u5f53\u524d\u6807\u6bb5\u4fe1\u606f\u4ee5\u53ca\u91c7\u8d2d\u660e\u7ec6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BidProjectEdit_22", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u81ea\u52a8\u6e05\u7a7a\u91c7\u8d2d\u660e\u7ec6\u53ca\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"BidProjectEdit_23", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            } else {
                DynamicObjectCollection bidSection = this.getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
                DynamicObjectCollection bidRollSection = this.getModel().getDataEntity(true).getDynamicObjectCollection("bidrollsection");
                DynamicObject bidSectionNew2 = bidSection.addNew();
                bidSectionNew2.set("sectionname", (Object)ResManager.loadKDString((String)"\u6807\u6bb5\u4e8c", (String)"BidProjectEdit_71", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                DynamicObject bidRollSectionNew2 = bidRollSection.addNew();
                bidRollSectionNew2.set("rollsectionname", (Object)ResManager.loadKDString((String)"\u6807\u6bb5\u4e8c", (String)"BidProjectEdit_71", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("totalcontrol", null);
                this.setEnableMultiSection(true, false);
                this.getView().updateView("bidsection");
                this.getView().updateView("projectentry");
                this.getView().updateView("bidrollsection");
                this.getView().updateView("supplierentry");
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"user", (CharSequence)fieldKey)) {
            if (newVal == null) {
                return;
            }
            this.propertiesChange4User(cd, "memberentity", "user", F7_POSITION);
            return;
        }
        if (StringUtils.equals((CharSequence)"userleader", (CharSequence)fieldKey)) {
            if (newVal == null) {
                return;
            }
            this.propertiesChange4User(cd, "memberleaderentity", "userleader", "positionleader");
            return;
        }
        if (StringUtils.equals((CharSequence)"bidmode", (CharSequence)fieldKey)) {
            this.propertyChange_UpdateDataViewBYModel();
            return;
        }
        if (StringUtils.equals((CharSequence)"isseparatedoc", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"bidopentype", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"deposit", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"tenderfee", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"secdeposit", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"doctype", (CharSequence)fieldKey)) {
            BigDecimal tenFree = (BigDecimal)this.getModel().getValue("tenderfee");
            String chargeState = (String)this.getModel().getValue("chargingstage");
            if (tenFree.compareTo(BigDecimal.ZERO) < 0 && "notstage".equals(chargeState)) {
                return;
            }
            String billstatus = this.getModel().getValue(BILL_STATUS).toString();
            if (StringUtils.equals((CharSequence)"A", (CharSequence)billstatus)) {
                this.initRespBusiness();
                this.clearRespBusiness();
            }
            if (StringUtils.equals((CharSequence)"deposit", (CharSequence)fieldKey)) {
                BigDecimal deposit = (BigDecimal)this.getModel().getValue("deposit");
                DynamicObjectCollection bidsections = this.getModel().getEntryEntity("bidsection");
                for (int i = 0; i < bidsections.size(); ++i) {
                    BigDecimal secdeposit = ((DynamicObject)bidsections.get(i)).getBigDecimal("secdeposit");
                    if (secdeposit.compareTo(BigDecimal.ZERO) != 0 || deposit.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.getModel().setValue("secdeposit", (Object)deposit, i);
                }
            }
            return;
        }
        if (fieldKey.equals(BidProjectDateEnum.enrolldeadline.name()) && (billStatus = this.annocumentService.getBillStatus(pkvalue = this.getModel().getDataEntity().getPkValue(), (Object)"bidproject")) != null && newVal == null && BillStatusEnum.RELEASED.getVal().equals(billStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u62db\u6807\u516c\u544a\uff0c\u201d\u6295\u6807\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u201c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BidProjectEdit_25", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(fieldKey, (Object)((Date)oldVal));
            return;
        }
        if (fieldKey.equals(BidProjectDateEnum.invitationdeadline.name())) {
            pkvalue = this.getModel().getDataEntity().getPkValue();
            DynamicObject invitation = this.supplierInvitationService.getInvitationByProjectId(Long.valueOf(pkvalue.toString()));
            if (newVal == null && invitation != null && BillStatusEnum.SUBMIT.getVal().equals(invitation.getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u9080\u8bf7\u51fd\uff0c\u201d\u9080\u8bf7\u51fd\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u201c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BidProjectEdit_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(fieldKey, (Object)((Date)oldVal));
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"sectionname", (CharSequence)fieldKey)) {
            int index = cd.getRowIndex();
            if (index == -1) {
                return;
            }
            ArrayList<String> sectionNames = new ArrayList<String>();
            int rowCount = this.getModel().getEntryRowCount("bidsection");
            for (int i = 0; i < rowCount; ++i) {
                Optional<String> sectionName;
                if (i == index || !(sectionName = Optional.ofNullable(this.getModel().getEntryRowEntity("bidsection", i)).map(section -> section.getString("sectionname"))).isPresent()) continue;
                sectionNames.add(sectionName.get());
            }
            LocaleDynamicObjectCollection nv = (LocaleDynamicObjectCollection)newVal;
            String sn = (String)nv.getCurrentLocaleValue((IDataEntityProperty)nv.getDynamicObjectType().getProperties().get((Object)"sectionname"));
            if (sectionNames.size() > 0 && !StringUtils.isEmpty((CharSequence)sn) && !" ".equals(sn) && sectionNames.contains(sn)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6807\u6bb5\u540d\u79f0\u201d\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"BidProjectEdit_27", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().getEntryRowEntity("bidsection", index).set("sectionname", null);
                return;
            }
            DynamicObject project = this.getModel().getDataEntity(true);
            DynamicObjectCollection bidSectionColl = project.getDynamicObjectCollection("bidsection");
            DynamicObjectCollection rollSectionColl = project.getDynamicObjectCollection("bidrollsection");
            if (bidSectionColl.size() > rollSectionColl.size()) {
                for (int i = 0; i < bidSectionColl.size() - rollSectionColl.size(); ++i) {
                    this.getModel().createNewEntryRow("bidrollsection");
                }
            }
            this.getModel().setValue("rollsectionname", (Object)sn, index);
            return;
        }
        if (StringUtils.equals((CharSequence)"entrustmentway", (CharSequence)fieldKey)) {
            this.propertyChanged_EntrustmentWay();
            return;
        }
        if (StringUtils.equals((CharSequence)"contact", (CharSequence)fieldKey)) {
            if (newVal == null) {
                return;
            }
            DynamicObject user = (DynamicObject)newVal;
            this.getModel().setValue("contacttel", (Object)user.getString("phone"));
            this.getModel().setValue("proemail", (Object)user.getString("email"));
            return;
        }
        if (StringUtils.equals((CharSequence)"entrustmentorgunit", (CharSequence)fieldKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject eorg = (DynamicObject)newVal;
            if (org != null && eorg != null && org.getString("id").equals(eorg.getString("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u548c\u201c\u59d4\u6258\u91c7\u8d2d\u7ec4\u7ec7\u201d\u4e0d\u5141\u8bb8\u76f8\u540c\u3002", (String)"BidProjectEdit_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(fieldKey, null);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"controlamount", (CharSequence)fieldKey)) {
            double totalamount = this.getAllAmountByEntryKey("controlamount");
            this.getModel().setValue("totalcontrol", (Object)totalamount);
        }
        if (StringUtils.equals((CharSequence)"ctrlamtexceptvat", (CharSequence)fieldKey)) {
            double totalamount = this.getAllAmountByEntryKey("ctrlamtexceptvat");
            this.getModel().setValue("totalctrlexcvat", (Object)totalamount);
        }
        if (StringUtils.equals((CharSequence)"purtype", (CharSequence)fieldKey)) {
            this.purTypeOnChanged(newVal, oldVal);
        }
        if (StringUtils.equals((CharSequence)"isdeposit", (CharSequence)fieldKey)) {
            boolean isdeposit = (Boolean)newVal;
            this.getView().setEnable(Boolean.valueOf(!isdeposit), new String[]{"deposit"});
            this.clearDepitEntry(isdeposit, false);
            this.getView().getModel().getDataEntity(true).set("deposit", (Object)0);
            this.getView().updateView("deposit");
            this.initRespBusiness();
            this.clearRespBusiness();
            return;
        }
        if (StringUtils.equals((CharSequence)"chargingstage", (CharSequence)fieldKey)) {
            this.initRespBusiness();
            this.clearRespBusiness();
            return;
        }
        if (StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getAppId()) && StringUtils.equals((CharSequence)"isenablelist", (CharSequence)fieldKey)) {
            this.initRespBusiness();
            this.clearRespBusiness();
        }
        if (StringUtils.equals((CharSequence)"clarificaiton", (CharSequence)fieldKey)) {
            this.propertyChange_clarificaiton((Boolean)newVal);
        }
        if (StringUtils.equals((CharSequence)"bidbottommake", (CharSequence)fieldKey)) {
            this.propertyChange_bidBottomMake((Boolean)newVal);
        }
        if (StringUtils.equals((CharSequence)"purmodel", (CharSequence)fieldKey)) {
            String entityId = this.getView().getEntityId();
            String purModel = (String)newVal;
            if ("rebm_project".equals(entityId)) {
                DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
                DynamicObject org = dataEntity.getDynamicObject("org");
                String source = org == null ? GetSysParamterUtil.getIntegratetacticsBySysParamter(null).toString() : GetSysParamterUtil.getIntegratetacticsBySysParamter((Object)org.getPkValue()).toString();
                DynamicObject ecContractType = dataEntity.getDynamicObject("ec_contracttype");
                if (ecContractType != null && "3".equals(source)) {
                    if (PurchaseModel.StrategySourcing.getVal().equals(purModel)) {
                        this.setEnableMultiSection(false, true);
                        this.getModel().deleteEntryData("bidsection");
                        this.getModel().deleteEntryData("bidrollsection");
                        this.setSingleSectionStatus();
                        this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_ENABLE_MULTI_SECTION});
                        this.getModel().setValue("totalcontrol", (Object)0);
                        this.getModel().setValue("totalctrlexcvat", (Object)0);
                        this.getView().setVisible(Boolean.FALSE, new String[]{"totalcontrol"});
                    } else if (PurchaseModel.ProjectProcurement.getVal().equals(purModel)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_ENABLE_MULTI_SECTION, SECTION_PUR_DETAIL_CONTAINER, "purdetailcontainer"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{"totalcontrol"});
                    }
                } else {
                    this.commonPurModelBeforeChange(purModel);
                }
            } else {
                this.commonPurModelBeforeChange(purModel);
            }
        }
        if (StringUtils.equals((CharSequence)"materialid", (CharSequence)fieldKey)) {
            this.projectMaterialidChange(cd);
        }
    }

    public void projectMaterialidChange(ChangeData cd) {
        int index = cd.getRowIndex();
        DynamicObject materialid = (DynamicObject)cd.getNewValue();
        if (materialid != null) {
            DynamicObject baseUnit = materialid.getDynamicObject("baseunit");
            this.getModel().setValue("baseunit", (Object)baseUnit, index);
        }
    }

    public void propertiesChange4User(ChangeData cd, String memberEntryL, String userL, String position) {
        int index = cd.getRowIndex();
        Optional<DynamicObject> memberDetail = Optional.ofNullable(cd).map(RowDataEntity::getDataEntity).map(memberEntry -> memberEntry.getDynamicObject(userL)).map(user -> user.getDynamicObjectCollection("entryentity")).map(entries -> {
            List doc;
            if (entries.size() > 0 && (doc = entries.stream().filter(entry -> !entry.getBoolean("ispartjob")).collect(Collectors.toList())) != null && doc.size() > 0) {
                return (DynamicObject)doc.get(0);
            }
            return null;
        });
        if (memberDetail.isPresent()) {
            DynamicObject ent = memberDetail.get();
            this.getModel().setValue(position, (Object)ent, index);
        }
    }

    protected void propertyChange_bidBottomMake(boolean bidBottomMake) {
        this.getView().setVisible(Boolean.valueOf(bidBottomMake), new String[]{"bidbottommakedate"});
        if (!bidBottomMake) {
            this.getModel().setValue("bidbottommakedate", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidbottommakedate"});
        }
        this.initRespBusiness();
        this.clearRespBusiness();
    }

    protected void propertyChange_clarificaiton(boolean clarificaiton) {
        this.getView().setVisible(Boolean.valueOf(clarificaiton), new String[]{"clarificaitondate"});
        if (!clarificaiton) {
            this.getModel().setValue("clarificaitondate", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"clarificaitondate"});
        }
        this.initRespBusiness();
        this.clearRespBusiness();
    }

    public void propertyChange_UpdateDataViewBYModel() {
        this.setProjectProcessStatus();
        this.setBidModelStatus();
        this.clearRespBusiness();
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObject bidModel = data.getDynamicObject("bidmode");
        boolean openBidingFlag = BidModeHelper.isPublicBiddingByModel(bidModel);
        if (openBidingFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RECOSUPPLIERTABPAGE});
            Tab bidpreparetabap = (Tab)this.getView().getControl("bidpreparetabap");
            bidpreparetabap.activeTab("purdetailtabpage");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{RECOSUPPLIERTABPAGE});
        }
        this.setDesiByChargingstage();
        this.initRespBusiness();
        this.clearRespBusiness();
    }

    public void setDesiByChargingstage() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject bidModel = dataEntity.getDynamicObject("bidmode");
        Map<String, Boolean> stringBooleanMap = BidModeHelper.hasPublicOrOpen(bidModel);
        if (stringBooleanMap == null || stringBooleanMap.size() == 0) {
            List<ComboItem> cis = this.makeCombByFlag(false, false, false);
            this.dealProchangeByBidmode(dataEntity, false, cis);
        } else if (stringBooleanMap.get("bidpublish").booleanValue()) {
            List<Object> cis = new ArrayList();
            cis = stringBooleanMap.get("bidopen") != false ? this.makeCombByFlag(true, true, true) : this.makeCombByFlag(true, true, false);
            this.dealProchangeByBidmode(dataEntity, true, cis);
        } else {
            ArrayList<ComboItem> cis = new ArrayList();
            if (stringBooleanMap.get("bidopen").booleanValue()) {
                cis = this.makeCombByFlag(false, false, true);
                this.dealProchangeByBidmode(dataEntity, true, cis);
            } else {
                cis = this.makeCombByFlag(false, false, false);
                this.dealProchangeByBidmode(dataEntity, false, cis);
            }
        }
    }

    public List<ComboItem> makeCombByFlag(boolean backprojectFlag, boolean backbookFlag, boolean openprojectFlag) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(8);
        ComboItem item1 = new ComboItem();
        item1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u6536\u53d6", (String)"BidProjectEdit_64", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        item1.setValue("notstage");
        list.add(item1);
        if (backprojectFlag) {
            ComboItem item2 = new ComboItem();
            item2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6295\u6807", (String)"BidProjectEdit_65", (String)"scm-bid-formplugin", (Object[])new Object[0])));
            item2.setValue("backproject");
            list.add(item2);
        }
        if (backbookFlag) {
            ComboItem item3 = new ComboItem();
            item3.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6295\u6807+\u6807\u4e66\u4e0b\u8f7d", (String)"BidProjectEdit_66", (String)"scm-bid-formplugin", (Object[])new Object[0])));
            item3.setValue("backbook");
            list.add(item3);
        }
        if (openprojectFlag) {
            ComboItem item4 = new ComboItem();
            item4.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f00\u6807", (String)"BidProjectEdit_67", (String)"scm-bid-formplugin", (Object[])new Object[0])));
            item4.setValue("openproject");
            list.add(item4);
        }
        return list;
    }

    public void dealProchangeByBidmode(DynamicObject dataEntity, boolean visitFlag, List<ComboItem> cis) {
        ComboEdit mce = (ComboEdit)this.getView().getControl("chargingstage");
        if (cis != null && cis.size() > 0) {
            mce.setComboItems(cis);
            this.getView().getModel().getDataEntity(true).set("chargingstage", (Object)cis.get(0).getValue());
        }
        this.getView().setEnable(Boolean.valueOf(visitFlag), new String[]{"chargingstage"});
        dataEntity.set("isdeposit", (Object)Boolean.FALSE);
        dataEntity.set("issupplierget", (Object)Boolean.FALSE);
        dataEntity.set("deposit", (Object)0);
        this.clearDepitEntry(false, false);
        this.getView().setVisible(Boolean.TRUE, new String[]{"issupplierget"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"isdeposit", "issupplierget", "deposit"});
        this.getView().updateView("isdeposit");
        this.getView().updateView("chargingstage");
        this.getView().updateView("issupplierget");
        this.getView().updateView("deposit");
    }

    protected void purTypeOnChanged(Object newValue, Object oldValue) {
        String entityId = this.getView().getEntityId();
        if ("rebm_project".equals(entityId)) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            DynamicObject org = dataEntity.getDynamicObject("org");
            String source = org == null ? GetSysParamterUtil.getIntegratetacticsBySysParamter(null).toString() : GetSysParamterUtil.getIntegratetacticsBySysParamter((Object)org.getPkValue()).toString();
            if (!"3".equals(source)) {
                this.commonPurTypeOnChanged(newValue, oldValue);
            }
        } else {
            this.commonPurTypeOnChanged(newValue, oldValue);
        }
    }

    public void commonPurTypeOnChanged(Object newValue, Object oldValue) {
        boolean isEnableMaterial = false;
        if (null != newValue) {
            DynamicObject purType = (DynamicObject)newValue;
            isEnableMaterial = purType.getBoolean("materialpur");
        }
        if (isEnableMaterial) {
            this.getView().getModel().setValue("bidtype", (Object)BidTypeEnum.MATERIAL.getValue());
        } else {
            this.getView().getModel().setValue("bidtype", (Object)BidTypeEnum.PROJECT.getValue());
        }
        boolean oldEnableMaterial = false;
        if (null != oldValue) {
            DynamicObject oldPurType = (DynamicObject)oldValue;
            oldEnableMaterial = oldPurType.getBoolean("materialpur");
        }
        if (Boolean.compare(isEnableMaterial, oldEnableMaterial) != 0) {
            boolean hasEntryRow = false;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection sectionEntryColl = dataEntity.getDynamicObjectCollection("bidsection");
            for (DynamicObject sectionEntry : sectionEntryColl) {
                DynamicObjectCollection purDetailEntryColl = sectionEntry.getDynamicObjectCollection("projectentry");
                if (purDetailEntryColl.size() <= 0) continue;
                hasEntryRow = true;
                break;
            }
            if (hasEntryRow) {
                String oldPurTypeId = null;
                if (null != oldValue) {
                    oldPurTypeId = ((DynamicObject)oldValue).getPkValue().toString();
                }
                this.getPageCache().put("oldPurTypeId", oldPurTypeId);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(PUR_TYPE_CHANGE, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u91c7\u8d2d\u7c7b\u578b\uff0c\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u91c7\u8d2d\u660e\u7ec6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BidProjectEdit_59", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            } else {
                this.setFieldVisible();
            }
        }
    }

    protected void clearPurDetailEntry() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection sectionEntryColl = dataEntity.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < sectionEntryColl.size(); ++i) {
            DynamicObject sectionEntry = (DynamicObject)sectionEntryColl.get(i);
            DynamicObjectCollection purDetailEntryColl = sectionEntry.getDynamicObjectCollection("projectentry");
            purDetailEntryColl.clear();
        }
        this.getModel().setValue("totalctrlexcvat", (Object)BigDecimal.ZERO);
        this.getModel().setValue("totalcontrol", (Object)BigDecimal.ZERO);
        this.getView().updateView("projectentry");
    }

    public void setFieldVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String bidType = dataEntity.getString("bidtype");
        if (StringUtils.isNotEmpty((CharSequence)bidType)) {
            if (BidTypeEnum.MATERIAL.getValue().equals(bidType) || BidTypeEnum.RESOURCE.getValue().equals(bidType)) {
                FieldEdit projectEntryQty;
                this.getModel().setValue("isratebidding", (Object)Boolean.FALSE);
                this.getView().setVisible(Boolean.FALSE, new String[]{"isratebidding", "purentrycontent", "workload", "purentryworkload"});
                FieldEdit projectEntryMaterialId = (FieldEdit)this.getView().getControl("materialid");
                if (BidTypeEnum.MATERIAL.getValue().equals(bidType)) {
                    this.getModel().setValue("ismaterialpur", (Object)Boolean.TRUE);
                    this.getView().setVisible(Boolean.TRUE, new String[]{"materialname", "model", "unit", "baseunit", "qty", "materialdes"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"materialid"});
                    if (projectEntryMaterialId != null) {
                        projectEntryMaterialId.setMustInput(true);
                    }
                } else {
                    this.getModel().setValue("ismaterialpur", (Object)Boolean.FALSE);
                    this.getView().setVisible(Boolean.TRUE, new String[]{"qty", "materialdes", "baseunit"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "model", "unit"});
                    if (projectEntryMaterialId != null) {
                        projectEntryMaterialId.setMustInput(false);
                    }
                }
                if ((projectEntryQty = (FieldEdit)this.getView().getControl("qty")) != null) {
                    projectEntryQty.setMustInput(true);
                }
            } else if (BidTypeEnum.PROJECT.getValue().equals(bidType)) {
                this.getModel().setValue("ismaterialpur", (Object)Boolean.FALSE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"isratebidding", "purentrycontent", "workload"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"isratebidding"});
                boolean enableMultiSection = (Boolean)this.getModel().getValue(FIELD_ENABLE_MULTI_SECTION);
                if (enableMultiSection) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"purentryworkload"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"purentryworkload"});
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "model", "unit", "baseunit", "qty", "materialdes"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "model", "unit", "baseunit", "qty", "materialdes"});
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        if (StringUtils.equals((CharSequence)args.getOperateKey(), (CharSequence)"deletesectionentry")) {
            double totalamount = this.getAllAmountByEntryKey("controlamount");
            this.getModel().setValue("totalcontrol", (Object)totalamount);
            totalamount = this.getAllAmountByEntryKey("ctrlamtexceptvat");
            this.getModel().setValue("totalctrlexcvat", (Object)totalamount);
        } else if (StringUtils.equals((CharSequence)args.getOperateKey(), (CharSequence)"deleteprojectentry")) {
            double totalamount = this.getAllAmountByEntryKey("controlamount");
            this.getModel().setValue("totalcontrol", (Object)totalamount);
            totalamount = this.getAllAmountByEntryKey("ctrlamtexceptvat");
            this.getModel().setValue("totalctrlexcvat", (Object)totalamount);
        } else if (StringUtils.equals((CharSequence)args.getOperateKey(), (CharSequence)"unaudit") && args.getOperationResult().isSuccess()) {
            DynamicObject data = this.getModel().getDataEntity(true);
            Object pkValue = data.getPkValue();
            this.annocumentService.deleteAnnouncementByProId(pkValue, (Object)"bidproject");
            this.setFieldVisible();
        } else if (StringUtils.equals((CharSequence)args.getOperateKey(), (CharSequence)"unsubmit")) {
            this.getPageCache().put("agreeSubmit", null);
        } else if (StringUtils.equals((CharSequence)args.getOperateKey(), (CharSequence)"newrollsupplierentry")) {
            this.showBDSupplierForm();
        } else if (StringUtils.equals((CharSequence)args.getOperateKey(), (CharSequence)"newsectionentry")) {
            DynamicObject project = this.getModel().getDataEntity(true);
            DynamicObjectCollection bidSectionColl = project.getDynamicObjectCollection("bidsection");
            EntryGrid entryGrid4Session = (EntryGrid)this.getControl("bidsection");
            int[] selects = entryGrid4Session.getSelectRows();
            for (int i = 0; i < selects.length; ++i) {
                int select = selects[i];
                for (int j = 0; j < bidSectionColl.size(); ++j) {
                    if (j != select) continue;
                    this.getModel().createNewEntryRow("bidrollsection");
                }
            }
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidrollsection");
            entryEntityGrid.selectRows(selects[0], true);
            EntryGrid enGrid = (EntryGrid)this.getControl("bidsection");
            enGrid.selectRows(selects[0], true);
            this.getView().updateView("bidrollsection");
            this.getView().updateView("bidsection");
        }
        this.afterDoFromListBtn(args.getOperateKey());
        this.controlListBtnStatus();
    }

    public void controlListBtnStatus() {
        DynamicObject src = this.getModel().getDataEntity();
        Object id = src.getPkValue();
        String billStatus = src.getString(BILL_STATUS);
        IFormView view = this.getView();
        if (BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_del"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
        }
        if (BillStatusEnum.AUDITED.getVal().equals(billStatus)) {
            String appId;
            boolean enable;
            view.setVisible(Boolean.TRUE, new String[]{"invalid", "adjustpromsg"});
            DynamicObject decision = BusinessDataServiceHelper.loadSingle((String)"bid_decision", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", id)});
            if (decision != null) {
                String billstatus = decision.getString(BILL_STATUS);
                if (BillStatusEnum.PARTSIGNED.getVal().equals(billstatus) || BillStatusEnum.SIGNED.getVal().equals(billstatus)) {
                    view.setVisible(Boolean.FALSE, new String[]{"invalid"});
                }
            }
            if (!(enable = SystemParamHelper.getSystemParameter((String)(appId = this.getView().getFormShowParameter().getServiceAppId()), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"releaseannouncement"});
            } else {
                DynamicObject bidMode = this.getModel().getDataEntity(true).getDynamicObject("bidmode");
                if (BidModeHelper.isPublicBiddingByModel(bidMode)) {
                    view.setVisible(Boolean.TRUE, new String[]{"releaseannouncement"});
                    view.setEnable(Boolean.TRUE, new String[]{"releaseannouncement"});
                } else {
                    view.setVisible(Boolean.FALSE, new String[]{"releaseannouncement"});
                }
                String annoBillStatus = this.annocumentService.getBillStatus(id, (Object)"bidproject");
                if (annoBillStatus != null) {
                    if (annoBillStatus.equals(BillStatusEnum.RELEASED.getVal())) {
                        view.setEnable(Boolean.TRUE, new String[]{"revokeannouncement"});
                    } else {
                        view.setEnable(Boolean.FALSE, new String[]{"revokeannouncement"});
                    }
                } else {
                    view.setEnable(Boolean.FALSE, new String[]{"revokeannouncement"});
                }
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"releaseannouncement", "invalid", "adjustpromsg"});
        }
    }

    public void afterDoFromListBtn(String operateKey) {
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"adjustprojects")) {
            this.itemClick_adjustProMsg();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"addnewannouncement")) {
            this.itemClickAnnouncementProMsg();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"revokeannouncement")) {
            this.itemClickRevokeAnnouncement();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"checkannouncement")) {
            this.itemClickCheckAnnouncement();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"record")) {
            String appId = this.getModel().getDataEntityType().getAppId();
            long projectId = this.getModel().getDataEntity(true).getLong("id");
            QFilter filter = new QFilter("projectid", "=", (Object)projectId);
            DynamicObjectCollection adjustmentrecordColl = QueryServiceHelper.query((String)(appId + "_adjustmentrecord"), (String)"id", (QFilter[])filter.toArray());
            if (adjustmentrecordColl.size() > 0) {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setCustomParam("projectid", (Object)projectId);
                listShowParameter.setMultiSelect(false);
                listShowParameter.setHasRight(true);
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setBillFormId(appId + "_adjustmentrecord");
                this.getView().showForm((FormShowParameter)listShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u8c03\u6574\u8bb0\u5f55", (String)"BidProjectEdit_29", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void itemClick_adjustProMsg() {
        String appId = this.getModel().getDataEntityType().getAppId();
        String billno = this.getModel().getDataEntity().getString("billno");
        String billStatus = this.getModel().getDataEntity().getString(BILL_STATUS);
        Long pkId = (Long)this.getModel().getDataEntity().getPkValue();
        if (!BillStatusEnum.AUDITED.getVal().equals(billStatus) && !billStatus.equals("I")) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s: \u53ea\u6709\u5df2\u5ba1\u6279\u7684\u6570\u636e\u624d\u5141\u8bb8\u505a\u7acb\u9879\u8c03\u6574\u3002", (String)"BidProjectEdit_30", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
            return;
        }
        MainEntityType receiverbill = EntityMetadataCache.getDataEntityType((String)(appId + "_adjustmentrecord"));
        DynamicObject bill = new DynamicObject((DynamicObjectType)receiverbill);
        String billnos = CodeRuleServiceHelper.getNumber((String)(appId + "_adjustmentrecord"), (DynamicObject)bill, (String)null);
        if (billnos == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7acb\u9879\u8c03\u6574\u672a\u914d\u7f6e\u7f16\u7801\u89c4\u5219,\u8bf7\u5148\u914d\u7f6e\u3002", (String)"BidProjectEdit_73", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)(appId + "_project"));
        String name = project.getString("name");
        QFilter qFilter = new QFilter("name", "=", (Object)name);
        qFilter.and(BILL_STATUS, "!=", (Object)"C");
        DynamicObjectCollection adjustmentrecord = QueryServiceHelper.query((String)(appId + "_adjustmentrecord"), (String)"id", (QFilter[])qFilter.toArray());
        if (adjustmentrecord.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u672a\u5ba1\u6838\u7684\u7acb\u9879\u8c03\u6574\u5355\uff0c\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"BidProjectEdit_74", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter[] decisionFilter = new QFilter[]{new QFilter("bidproject", "=", (Object)pkId), new QFilter(BILL_STATUS, "in", (Object)new String[]{"B", "I", "C", "S", "R"})};
        boolean decisionFlag = QueryServiceHelper.exists((String)(appId + "_decision"), (QFilter[])decisionFilter);
        if (decisionFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u4e1a\u52a1\u5df2\u8fdb\u5165\u5b9a\u6807\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u518d\u8fdb\u884c\u7acb\u9879\u8c03\u6574\u3002", (String)"BidProjectEdit_75", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(appId + "_projectadjust");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setPkId((Object)pkId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void itemClick_cancelProMsg() {
        String appId = this.getModel().getDataEntityType().getAppId();
        String billno = this.getModel().getDataEntity().getString("billno");
        String billStatus = this.getModel().getDataEntity().getString(BILL_STATUS);
        Long pkId = (Long)this.getModel().getDataEntity().getPkValue();
        if (!BillStatusEnum.AUDITED.getVal().equals(billStatus) && !billStatus.equals("I")) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s: \u53ea\u6709\u5df2\u5ba1\u6279\u7684\u6570\u636e\u624d\u5141\u8bb8\u6d41\u6807\u3002", (String)"BidProjectEdit_68", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
            return;
        }
        QFilter qFilter = new QFilter("bidproject", "=", (Object)pkId);
        qFilter.and(BILL_STATUS, "!=", (Object)"C");
        boolean exists = QueryServiceHelper.exists((String)(appId + "_projectcancel"), (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u672a\u5ba1\u6838\u6216\u5ba1\u6838\u4e2d\u7684\u4f5c\u5e9f\u5355\uff0c\u8bf7\u5148\u5ba1\u6838\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidProjectEdit_76", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        qFilter = new QFilter("bidproject", "=", (Object)pkId);
        qFilter.and(BILL_STATUS, "=", (Object)"C");
        exists = QueryServiceHelper.exists((String)(appId + "_projectcancel"), (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u5ba1\u6838\u7684\u4f5c\u5e9f\u5355\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c\u3002", (String)"BidProjectEdit_77", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter[] decisionFilter = new QFilter[]{new QFilter("bidproject", "=", (Object)pkId), new QFilter(BILL_STATUS, "in", (Object)new String[]{"B", "I", "C", "S", "R"})};
        boolean decisionFlag = QueryServiceHelper.exists((String)(appId + "_decision"), (QFilter[])decisionFilter);
        if (decisionFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u4e1a\u52a1\u5df2\u8fdb\u5165\u5b9a\u6807\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u518d\u8fdb\u884c\u62db\u6807\u4f5c\u5e9f\u3002", (String)"BidProjectEdit_78", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean hasUnfinishedbidTransfer = BidTransferUtil.isHasUnfinishedbidTransfer(pkId, appId);
        if (hasUnfinishedbidTransfer) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u6570\u636e\u6b63\u5728\u8f6c\u529e\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u7acb\u9879\u8c03\u6574\u3002", (String)"BidProjectEdit_62", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(appId + "_projectcancel");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setAppId(appId);
        showParameter.setCustomParam("bidProjectId", (Object)pkId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void itemClickRevokeAnnouncement() {
        Object id = this.getModel().getDataEntity().getPkValue();
        String billStatus = this.annocumentService.getBillStatus(id, (Object)"bidproject");
        if (billStatus != null) {
            if (billStatus.equals(BillStatusEnum.SAVE.getVal())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u62db\u6807\u516c\u544a\uff0c\u65e0\u9700\u64a4\u9500\u3002", (String)"BidProjectEdit_38", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            if (billStatus.equals(BillStatusEnum.RELEASED.getVal())) {
                if (CheckAnnocumentIsSign.isSign(id.toString()).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u62a5\u540d\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectEdit_39", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date deadlinedate = this.annocumentService.getProjectDeadLineDate(id);
                if (deadlinedate != null) {
                    if (new Date().compareTo(deadlinedate) < 0) {
                        this.annocumentService.changeAnnoStatusToA(id, (Object)"bidproject");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u62db\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidProjectEdit_40", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u7684\u201d\u6295\u6807\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u201c\u5df2\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"BidProjectEdit_41", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.annocumentService.changeAnnoStatusToA(id, (Object)"bidproject");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u62db\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidProjectEdit_40", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u62db\u6807\u516c\u544a\uff0c\u65e0\u9700\u64a4\u9500\u3002", (String)"BidProjectEdit_38", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClickCheckAnnouncement() {
        DynamicObject src = this.getModel().getDataEntity();
        Object id = src.getPkValue();
        DynamicObject bidMode = this.getModel().getDataEntity(true).getDynamicObject("bidmode");
        if (!BidModeHelper.isPublicBiddingByModel(bidMode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u516c\u5f00\u62db\u6807\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectEdit_42", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        Map map = this.annocumentService.getAnnouncementPKIdMap(id, (Object)"bidproject", Boolean.FALSE);
        if (map != null) {
            DynamicObject purTypeObj;
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setMultiSelect(false);
            showParameter.setBillFormId(this.getAppId() + "_project_announcement");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("annomap", (Object)map);
            showParameter.setCustomParam("parentType", (Object)"bidproject");
            showParameter.setCustomParam("projectPkid", id);
            showParameter.setCustomParam("pkid", id);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, NEED_REFRESH));
            String purTypeName = "";
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            if (project != null && (purTypeObj = project.getDynamicObject("purtype")) != null) {
                purTypeName = purTypeObj.getString("name");
            }
            showParameter.setCustomParam("purtype", (Object)purTypeName);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u7f16\u5236\u62db\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectEdit_43", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClickAnnouncementProMsg() {
        DynamicObject src = this.getModel().getDataEntity();
        DynamicObject org = src.getDynamicObject("org");
        Long mainOrgId = (Long)org.getPkValue();
        Object id = src.getPkValue();
        DynamicObject bidMode = this.getModel().getDataEntity(true).getDynamicObject("bidmode");
        if (BidModeHelper.isPublicBiddingByModel(bidMode)) {
            if (!BillStatusEnum.AUDITED.getVal().equals(src.getString(BILL_STATUS))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u5df2\u5ba1\u6279\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectEdit_45", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("bidproject", "=", (Object)String.valueOf(id));
            QFilter filter2 = new QFilter("annotype", "=", (Object)"bidproject");
            String appId = this.getAppId();
            boolean exists = QueryServiceHelper.exists((String)(appId + "_project_announcement"), (QFilter[])new QFilter[]{filter, filter2});
            boolean multipleSendProjectAnnouncementsFlag = BidProjectAnnouncementsUtils.multipleSendProjectAnnouncementsFlag((String)appId);
            if (multipleSendProjectAnnouncementsFlag) {
                boolean sendAnnouncementsFlag = BidProjectAnnouncementsUtils.checkManyTimesSendAnnouncements((String)appId, (Long)((Long)id));
                if (!sendAnnouncementsFlag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u9001\u62db\u6807\u516c\u544a\uff01", (String)"BidProjectEdit_70", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u4e00\u6761\u516c\u544a\uff0c\u8bf7\u4e0d\u8981\u518d\u6b21\u53d1\u5e03\u3002", (String)"BidProjectEdit_79", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(appId + "_project_announcement");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            DynamicObject[] projectAnnouncementArray = BusinessDataServiceHelper.load((String)(appId + "_project_announcement"), (String)"billstatus,publishstatus", (QFilter[])new QFilter[]{filter, filter2}, (String)"createtime desc");
            if (projectAnnouncementArray != null && projectAnnouncementArray.length > 0) {
                DynamicObject lastProjectAnnouncement = projectAnnouncementArray[0];
                String billStatus = lastProjectAnnouncement.getString(BILL_STATUS);
                String publishStatus = lastProjectAnnouncement.getString("publishstatus");
                if (BillStatusEnum.INVALIDXX.getVal().equals(billStatus) || BillStatusEnum.AUDITED.getVal().equals(billStatus) && "L".equals(publishStatus)) {
                    showParameter.setStatus(OperationStatus.ADDNEW);
                    showParameter.setCustomParam("pkid", id);
                    showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                    showParameter.setCustomParam("parentType", (Object)"bidproject");
                } else {
                    showParameter.setPkId(lastProjectAnnouncement.getPkValue());
                    showParameter.setStatus(OperationStatus.EDIT);
                    showParameter.setCustomParam("parentType", (Object)"bidproject");
                    showParameter.setCustomParam("pkid", id);
                    showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                }
            } else {
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.setCustomParam("parentType", (Object)"bidproject");
                showParameter.setCustomParam("pkid", id);
                showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
            }
            showParameter.setCaption(ResManager.loadKDString((String)"\u62db\u6807\u516c\u544a", (String)"BidProjectEdit_44", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u516c\u5f00\u62db\u6807\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectEdit_46", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    protected double getAllAmountByEntryKey(String key) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("bidsection");
        IDataModel operate = grid.getModel();
        DynamicObjectCollection sections = operate.getEntryEntity("bidsection");
        if (sections != null && sections.size() > 0) {
            double totalamount = 0.0;
            for (DynamicObject section : sections) {
                DynamicObjectCollection details = section.getDynamicObjectCollection("projectentry");
                if (details == null || details.size() <= 0) continue;
                for (DynamicObject detail : details) {
                    BigDecimal amount = detail.getBigDecimal(key);
                    if (amount == null) continue;
                    totalamount += amount.doubleValue();
                }
            }
            return totalamount;
        }
        return 0.0;
    }

    public void setEntrustmentWayDisplayStytle() {
        String entrustmentWay = (String)this.getModel().getValue("entrustmentway");
        if ("01".equals(entrustmentWay)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrustmentsupplier"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrustmentorgunit"});
        } else if ("02".equals(entrustmentWay)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"entrustmentsupplier"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrustmentorgunit"});
        } else if ("03".equals(entrustmentWay)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrustmentsupplier"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"entrustmentorgunit"});
        }
    }

    public void propertyChanged_EntrustmentWay() {
        String entrustmentWay = (String)this.getModel().getValue("entrustmentway");
        this.getView().setEnable(Boolean.FALSE, new String[]{"entrustmentorgunit"});
        if ("01".equals(entrustmentWay)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrustmentsupplier"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrustmentorgunit"});
            this.getModel().setValue("entrustmentsupplier", null);
            this.getModel().setValue("entrustmentorgunit", null);
        } else if ("02".equals(entrustmentWay)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"entrustmentsupplier"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrustmentorgunit"});
            this.getModel().setValue("entrustmentorgunit", null);
        } else if ("03".equals(entrustmentWay)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrustmentsupplier"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"entrustmentorgunit"});
            this.getModel().setValue("entrustmentsupplier", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"entrustmentorgunit"});
        }
    }

    public Set<String> getProjectIds(int index) {
        HashSet<String> proIds = new HashSet<String>();
        int rowCount = this.getModel().getEntryRowCount("projectentry");
        for (int i = 0; i < rowCount; ++i) {
            Optional<Object> oid;
            if (i == index || !(oid = Optional.ofNullable(this.getModel().getEntryRowEntity("projectentry", i)).map(purDetail -> purDetail.getDynamicObject("purentryproject")).map(project -> project.get("id"))).isPresent()) continue;
            Object id = oid.get();
            proIds.add(id.toString());
        }
        return proIds;
    }

    public void setBidModelStatus() {
        DynamicObject bidMode;
        FieldEdit bidOpenType;
        boolean isBidProject = (Boolean)this.getModel().getValue("bidproject");
        boolean isSupplierInvitation = (Boolean)this.getModel().getValue("supplierinvitation");
        boolean isBidDocument = (Boolean)this.getModel().getValue("biddocument");
        boolean isBidPublish = (Boolean)this.getModel().getValue("bidpublish");
        boolean isBidOpen = (Boolean)this.getModel().getValue("bidopen");
        boolean isBidEvaluation = (Boolean)this.getModel().getValue("bidevaluation");
        boolean isBidBustalk = (Boolean)this.getModel().getValue("bidbustalk");
        boolean isBidDecision = (Boolean)this.getModel().getValue("biddecision");
        boolean isBidAnswerQuestion = (Boolean)this.getModel().getValue("bidanswerquestion");
        boolean isPublic = false;
        DynamicObject bidModel = (DynamicObject)this.getModel().getValue("bidmode");
        if (bidModel != null && BidModeHelper.isPublicBiddingByModel(bidModel)) {
            isPublic = true;
        }
        if (isBidOpen) {
            bidOpenType = (FieldEdit)this.getView().getControl("bidopentype");
            if (bidOpenType != null) {
                bidOpenType.setMustInput(true);
            }
        } else {
            bidOpenType = (FieldEdit)this.getView().getControl("bidopentype");
            if (bidOpenType != null) {
                bidOpenType.setMustInput(false);
            }
        }
        DynamicObject data = this.getModel().getDataEntity(true);
        boolean enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        boolean hasPublish = false;
        boolean hasOpen = false;
        if (enable && (bidMode = data.getDynamicObject("bidmode")) != null) {
            hasOpen = bidMode.getBoolean("bidopen");
            hasPublish = bidMode.getBoolean("bidpublish");
            if (hasOpen && !hasPublish) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u201d\u91c7\u8d2d\u65b9\u5f0f\u201c\u7f3a\u5c11\u53d1\u6807\u73af\u8282\uff0c\u4e0d\u652f\u6301\u7ebf\u4e0a\u5f00\u6807\u3002", (String)"BidProjectEdit_48", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
        if (hasPublish && enable) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"clarificaiton"});
            boolean isClarificaiton = (Boolean)this.getModel().getValue("clarificaiton");
            this.getView().setVisible(Boolean.valueOf(isClarificaiton), new String[]{"clarificaitondate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"clarificaiton", "clarificaitondate"});
            this.getModel().setValue("clarificaiton", (Object)Boolean.FALSE);
            this.getModel().setValue("clarificaitondate", null);
        }
        this.setDateVisible(isSupplierInvitation, isBidDocument, isBidPublish, isBidOpen, isBidDecision, isBidEvaluation, isBidAnswerQuestion, isPublic, isBidBustalk);
        this.initRespBusiness();
        if (!enable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"publishinvitation"});
        }
    }

    public void clearRespBusiness() {
        int i;
        int countMember = this.getModel().getEntryRowCount("memberentity");
        int countLeader = this.getModel().getEntryRowCount("memberleaderentity");
        for (i = 0; i < countMember; ++i) {
            this.getModel().setValue("respbusiness", (Object)",01,", i);
        }
        for (i = 0; i < countLeader; ++i) {
            this.getModel().setValue("respbusinessleader", (Object)",01,", i);
        }
        this.getView().updateView("memberentity");
        this.getView().updateView("memberleaderentity");
    }

    public void initRespBusiness() {
        boolean isBidProject = (Boolean)this.getModel().getValue("bidproject");
        boolean isSupplierInvitation = (Boolean)this.getModel().getValue("supplierinvitation");
        boolean isBidDocument = (Boolean)this.getModel().getValue("biddocument");
        boolean isBidPublish = (Boolean)this.getModel().getValue("bidpublish");
        boolean isBidOpen = (Boolean)this.getModel().getValue("bidopen");
        boolean isBidEvaluation = (Boolean)this.getModel().getValue("bidevaluation");
        boolean isBidDecision = (Boolean)this.getModel().getValue("biddecision");
        boolean isBidBustalk = (Boolean)this.getModel().getValue("bidbustalk");
        boolean isBidAnswerQuestion = (Boolean)this.getModel().getValue("bidanswerquestion");
        boolean isClarification = (Boolean)this.getModel().getValue("clarificaiton");
        boolean isBidBottomMake = (Boolean)this.getModel().getValue("bidbottommake");
        LinkedHashMap<String, Boolean> mapping = new LinkedHashMap<String, Boolean>();
        mapping.put("BidProject", isBidProject);
        mapping.put("SupplierInvitation", isSupplierInvitation);
        mapping.put("BidDocument", isBidDocument);
        mapping.put("BidPublish", isBidPublish);
        mapping.put("BidAnswerQuestion", isBidAnswerQuestion);
        mapping.put("BidBottomMake", isBidBottomMake);
        mapping.put("Clarificaiton", isClarification);
        mapping.put("BidOpen", isBidOpen);
        mapping.put("BidEvaluation", isBidEvaluation);
        mapping.put("BidBustalk", isBidBustalk);
        mapping.put("BidDecision", isBidDecision);
        List<ComboItem> cis = this.setComboItem(mapping);
        MulComboEdit mce = (MulComboEdit)this.getView().getControl("respbusiness");
        MulComboEdit mlr = (MulComboEdit)this.getView().getControl("respbusinessleader");
        mce.setComboItems(cis);
        mlr.setComboItems(cis);
        this.getView().updateView("memberentity");
        this.getView().updateView("memberleaderentity");
    }

    public List<ComboItem> setComboItem(Map<String, Boolean> mapping) {
        String bidOpenType = (String)this.getModel().getValue("bidopentype");
        List<ComboItem> cis = mapping.entrySet().stream().filter(Map.Entry::getValue).flatMap(entry -> {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            String key = (String)entry.getKey();
            if ("BidDocument".equals(key)) {
                boolean isSeparateDoc = (Boolean)this.getModel().getValue("isseparatedoc");
                String docTypeStr = (String)this.getModel().getValue("doctype");
                if (isSeparateDoc) {
                    RespBusiness td = RespBusiness.TechnicalDoc;
                    RespBusiness cd = RespBusiness.CommercialDoc;
                    ComboItem item1 = new ComboItem();
                    item1.setCaption(new LocaleString(td.getAlias()));
                    item1.setValue(td.getVal());
                    ComboItem item2 = new ComboItem();
                    item2.setCaption(new LocaleString(cd.getAlias()));
                    item2.setValue(cd.getVal());
                    if (BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) {
                        items.add(item1);
                        items.add(item2);
                    } else if (BidOpenTypeEnum.TECHNICAL.getValue().equals(docTypeStr)) {
                        items.add(item1);
                    } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr)) {
                        items.add(item2);
                    }
                } else {
                    RespBusiness rcd = RespBusiness.RespCreateDoc;
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(rcd.getAlias()));
                    item.setValue(rcd.getVal());
                    items.add(item);
                }
                return items.stream();
            }
            if ("BidOpen".equals(key)) {
                if (!BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenType) && StringUtils.isNotBlank((CharSequence)bidOpenType)) {
                    RespBusiness to = RespBusiness.TechnicalOpen;
                    RespBusiness bo = RespBusiness.BusinessOpen;
                    ComboItem item1 = new ComboItem();
                    item1.setCaption(new LocaleString(to.getAlias()));
                    item1.setValue(to.getVal());
                    ComboItem item2 = new ComboItem();
                    item2.setCaption(new LocaleString(bo.getAlias()));
                    item2.setValue(bo.getVal());
                    items.add(item1);
                    items.add(item2);
                } else {
                    RespBusiness rcd = RespBusiness.BidOpen;
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(rcd.getAlias()));
                    item.setValue(rcd.getVal());
                    items.add(item);
                }
                return items.stream();
            }
            if ("BidEvaluation".equals(key)) {
                if (!BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenType) && StringUtils.isNotBlank((CharSequence)bidOpenType)) {
                    RespBusiness te = RespBusiness.TechnicalEval;
                    RespBusiness be = RespBusiness.BusinessEval;
                    ComboItem item1 = new ComboItem();
                    item1.setCaption(new LocaleString(te.getAlias()));
                    item1.setValue(te.getVal());
                    ComboItem item2 = new ComboItem();
                    item2.setCaption(new LocaleString(be.getAlias()));
                    item2.setValue(be.getVal());
                    items.add(item1);
                    items.add(item2);
                } else {
                    RespBusiness rcd = RespBusiness.BidEvaluation;
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(rcd.getAlias()));
                    item.setValue(rcd.getVal());
                    items.add(item);
                }
                return items.stream();
            }
            RespBusiness rb = RespBusiness.valueOf((String)key);
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(rb.getAlias()));
            item.setValue(rb.getVal());
            items.add(item);
            return items.stream();
        }).collect(Collectors.toList());
        DynamicObject project = this.getModel().getDataEntity(true);
        BigDecimal tenderfee = project.getBigDecimal("tenderfee");
        String chargingstage = this.getView().getModel().getDataEntity(true).getString("chargingstage");
        boolean addBidPay = false;
        addBidPay = tenderfee.compareTo(BigDecimal.ZERO) > 0 ? true : !"notstage".equals(chargingstage);
        if (addBidPay) {
            RespBusiness rb = RespBusiness.valueOf((String)"BidPay");
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(rb.getAlias()));
            item.setValue(rb.getVal());
            cis.add(item);
        }
        return cis;
    }

    public void setProjectProcessStatus() {
        DynamicObject bidModel = (DynamicObject)this.getModel().getValue("bidmode");
        if (bidModel != null) {
            boolean isBidProject = bidModel.getBoolean("bidproject");
            boolean isSupplierInvitation = bidModel.getBoolean("supplierinvitation");
            boolean isBidDocument = bidModel.getBoolean("biddocument");
            boolean isBidPublish = bidModel.getBoolean("bidpublish");
            boolean isBidOpen = bidModel.getBoolean("bidopen");
            boolean isBidEvaluation = bidModel.getBoolean("bidevaluation");
            boolean isBidDecision = bidModel.getBoolean("biddecision");
            boolean isBidBustalk = bidModel.getBoolean("bidbustalk");
            boolean isBidAnswerQuestion = bidModel.getBoolean("bidanswerquestion");
            this.getModel().setValue("bidproject", (Object)isBidProject);
            this.getModel().setValue("supplierinvitation", (Object)isSupplierInvitation);
            this.getModel().setValue("biddocument", (Object)isBidDocument);
            this.getModel().setValue("bidpublish", (Object)isBidPublish);
            this.getModel().setValue("bidopen", (Object)isBidOpen);
            this.getModel().setValue("bidevaluation", (Object)isBidEvaluation);
            this.getModel().setValue("bidbustalk", (Object)isBidBustalk);
            this.getModel().setValue("biddecision", (Object)isBidDecision);
            this.getModel().setValue("bidanswerquestion", (Object)isBidAnswerQuestion);
            this.getModel().setValue("clarificaiton", (Object)Boolean.FALSE);
            this.getModel().setValue("bidbottommake", (Object)Boolean.FALSE);
        }
    }

    public void setDateVisible(boolean isSupplierInvitation, boolean isBidDocument, boolean isBidPublish, boolean isBidOpen, boolean isBidDecision, boolean isBidEvaluation, boolean isBidAnswerQuestion, boolean isPublic, boolean isBidBustalk) {
        if (!isPublic && isSupplierInvitation) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"invitationdeadline"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"publishinvitation"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"invitationstatus"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invitationdeadline"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"publishinvitation"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"invitationstatus"});
            this.getModel().setValue("invitationdeadline", null);
        }
        if (isPublic) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"enrolldeadline"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"enrolldeadline"});
            this.getModel().setValue("enrolldeadline", null);
        }
        if (isSupplierInvitation) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"supplierinvienddate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"supplierinvienddate"});
            this.getModel().setValue("supplierinvienddate", null);
        }
        if (isBidDocument) {
            String docTypeStr = (String)this.getModel().getValue("doctype");
            if (BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bidopentype"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"isseparatedoc"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"technicaldocenddate"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"commercialdocenddate"});
            } else {
                this.getModel().setValue("bidopentype", (Object)BidOpenSelectTypeEnum.UNIONOPEN.getValue());
                this.getView().setVisible(Boolean.FALSE, new String[]{"bidopentype"});
                this.getModel().setValue("isseparatedoc", (Object)Boolean.FALSE);
                this.getView().setVisible(Boolean.FALSE, new String[]{"isseparatedoc"});
                if (docTypeStr.equals(BidOpenTypeEnum.TECHNICAL.getValue())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"technicaldocenddate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"commercialdocenddate"});
                } else if (docTypeStr.equals(BidOpenTypeEnum.BUSSINESS.getValue())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"commercialdocenddate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"technicaldocenddate"});
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"technicaldocenddate", "commercialdocenddate"});
            this.getModel().setValue("technicaldocenddate", null);
            this.getModel().setValue("commercialdocenddate", null);
        }
        if (isBidPublish) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bidpublishdate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidpublishdate"});
            this.getModel().setValue("bidpublishdate", null);
        }
        if (isBidDecision) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"biddecisiondate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"biddecisiondate"});
            this.getModel().setValue("biddecisiondate", null);
        }
        if (isBidEvaluation) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bidevaluationdate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidevaluationdate"});
            this.getModel().setValue("bidevaluationdate", null);
        }
        if (isBidAnswerQuestion) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"answerquestiontime"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"answercomplete"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"answerquestiontime"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"answercomplete"});
            this.getModel().setValue("answerquestiontime", null);
            this.getModel().setValue("answercomplete", null);
        }
        if (isBidBustalk) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bidbustalkdate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidbustalkdate"});
            this.getModel().setValue("bidbustalkdate", null);
        }
    }

    public void setPurModelStatus() {
        String purModel = (String)this.getModel().getValue("purmodel");
        this.getView().setVisible(Boolean.TRUE, new String[]{"purdetailcontainer"});
        if (PurchaseModel.ProjectProcurement.getVal().equals(purModel)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_ENABLE_MULTI_SECTION, SECTION_PUR_DETAIL_CONTAINER});
        } else if (PurchaseModel.ConsortiumPurchasing.getVal().equals(purModel)) {
            this.getModel().beginInit();
            this.getModel().setValue(FIELD_ENABLE_MULTI_SECTION, (Object)Boolean.TRUE);
            this.getModel().endInit();
            this.getView().updateView(FIELD_ENABLE_MULTI_SECTION);
            this.getView().setVisible(Boolean.TRUE, new String[]{SECTION_PUR_DETAIL_CONTAINER});
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_ENABLE_MULTI_SECTION});
        } else if (PurchaseModel.StrategySourcing.getVal().equals(purModel)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"totalcontrol"});
            if (StringUtils.equals((CharSequence)"bid", (CharSequence)this.getAppId())) {
                boolean enableMultiSection = (Boolean)this.getModel().getValue(FIELD_ENABLE_MULTI_SECTION);
                if (enableMultiSection) {
                    this.getModel().setValue(FIELD_ENABLE_MULTI_SECTION, (Object)Boolean.FALSE);
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"purdetailcontainer", FIELD_ENABLE_MULTI_SECTION});
            }
        }
    }

    protected void setEnableMultiSection(boolean enableMultiSec, boolean init) {
        this.getModel().beginInit();
        SplitContainer splitContainer = (SplitContainer)this.getControl(SECTION_PUR_DETAIL_SUPPLIER_CONTAINER);
        SplitContainer splitRollContainer = (SplitContainer)this.getControl("sectionsplitcontainer");
        if (splitContainer == null) {
            return;
        }
        if (enableMultiSec) {
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidrollsection");
            entryEntityGrid.selectRows(0, true);
            EntryGrid enGrid = (EntryGrid)this.getControl("bidsection");
            enGrid.selectRows(0, true);
            splitContainer.changeFlexStatus(SplitDirection.left, false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"purentryworkload"});
            if (splitRollContainer != null) {
                splitRollContainer.changeFlexStatus(SplitDirection.left, false);
            }
        } else {
            this.getModel().setValue(this.ENABLE_MULTI_SECTION, (Object)enableMultiSec);
            splitContainer.changeFlexStatus(SplitDirection.left, true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"purentryworkload"});
            if (splitRollContainer != null) {
                splitRollContainer.changeFlexStatus(SplitDirection.left, true);
            }
        }
        this.setEnableMul(enableMultiSec, init);
        this.getModel().endInit();
        this.getView().updateView(this.ENABLE_MULTI_SECTION);
        this.getView().updateView("flexpanelap");
        this.getView().updateView("purmodel");
    }

    public void setEnableMul(boolean isMul, boolean init) {
        this.getView().setEnable(Boolean.valueOf(isMul), new String[]{"isdeposit"});
        this.getView().setVisible(Boolean.valueOf(isMul), new String[]{"isdeposit"});
        if (init) {
            String billno;
            if (this.getView().getFormShowParameter().getCustomParam("iscopy") != null && StringUtils.isBlank((CharSequence)(billno = this.getView().getModel().getDataEntity(true).getString("billno")))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"secdeposit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"suppliersecdeposit"});
                this.getView().getModel().getDataEntity(true).set("issupplierget", (Object)Boolean.FALSE);
                this.getView().getModel().getDataEntity(true).set("isdeposit", (Object)Boolean.FALSE);
                this.getView().updateView("issupplierget");
            }
            return;
        }
        this.clearDepitEntry(false, false);
        String chargingstage = this.getView().getModel().getDataEntity(true).getString("chargingstage");
        if (StringUtils.equals((CharSequence)chargingstage, (CharSequence)"notstage")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"deposit", "issupplierget", "isdeposit"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"deposit", "issupplierget", "isdeposit"});
        }
        this.getView().getModel().getDataEntity(true).set("isdeposit", (Object)Boolean.FALSE);
        this.getView().getModel().getDataEntity(true).set("deposit", (Object)0);
        this.getView().getModel().getDataEntity(true).set("issupplierget", (Object)Boolean.FALSE);
        this.getView().updateView("isdeposit");
        this.getView().updateView("deposit");
        this.getView().updateView("issupplierget");
    }

    public void clearDepitEntry(boolean visiableSecdeposit, boolean visiableSupplier) {
        DynamicObjectCollection sectionCollect = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
        if (sectionCollect != null && sectionCollect.size() > 0) {
            for (DynamicObject section : sectionCollect) {
                section.set("secdeposit", (Object)0);
            }
        }
        if ((sectionCollect = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("bidrollsection")) != null && sectionCollect.size() > 0) {
            for (DynamicObject section : sectionCollect) {
                DynamicObjectCollection supplierColl = section.getDynamicObjectCollection("supplierentry");
                for (DynamicObject row : supplierColl) {
                    row.set("suppliersecdeposit", (Object)0);
                }
            }
        }
        this.getView().setVisible(Boolean.valueOf(visiableSecdeposit), new String[]{"secdeposit"});
        this.getView().setVisible(Boolean.valueOf(visiableSupplier), new String[]{"suppliersecdeposit"});
        this.getView().updateView("bidsection");
        this.getView().updateView("supplierentry");
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        boolean isBidProject = (Boolean)this.getModel().getValue("bidproject");
        boolean isSupplierInvitation = (Boolean)this.getModel().getValue("supplierinvitation");
        boolean isBidDocument = (Boolean)this.getModel().getValue("biddocument");
        boolean isBidPublish = (Boolean)this.getModel().getValue("bidpublish");
        boolean isBidOpen = (Boolean)this.getModel().getValue("bidopen");
        boolean isBidEvaluation = (Boolean)this.getModel().getValue("bidevaluation");
        boolean isBidDecision = (Boolean)this.getModel().getValue("biddecision");
        boolean isBidBustalk = (Boolean)this.getModel().getValue("bidbustalk");
        boolean isBidAnswerQuestion = (Boolean)this.getModel().getValue("bidanswerquestion");
        boolean isClarification = (Boolean)this.getModel().getValue("clarificaiton");
        boolean isBidBottomMake = (Boolean)this.getModel().getValue("bidbottommake");
        LinkedHashMap<String, Boolean> mapping = new LinkedHashMap<String, Boolean>();
        mapping.put("BidProject", isBidProject);
        mapping.put("SupplierInvitation", isSupplierInvitation);
        mapping.put("BidDocument", isBidDocument);
        mapping.put("BidPublish", isBidPublish);
        mapping.put("BidAnswerQuestion", isBidAnswerQuestion);
        mapping.put("BidBottomMake", isBidBottomMake);
        mapping.put("Clarificaiton", isClarification);
        mapping.put("BidOpen", isBidOpen);
        mapping.put("BidEvaluation", isBidEvaluation);
        mapping.put("BidBustalk", isBidBustalk);
        mapping.put("BidDecision", isBidDecision);
        List<ComboItem> cis = this.setComboItem(mapping);
        String key = e.getEntryProp().toString();
        if ("bidsection".equals(key)) {
            BigDecimal deposit = (BigDecimal)this.getModel().getValue("deposit");
            DynamicObjectCollection bidsections = this.getModel().getEntryEntity("bidsection");
            if (bidsections.size() > 0 && deposit.compareTo(BigDecimal.ZERO) > 0) {
                this.getModel().setValue("secdeposit", (Object)deposit, bidsections.size() - 1);
            }
        } else if ("memberleaderentity".equals(key)) {
            StringBuffer value = new StringBuffer();
            if (cis.size() > 0) {
                value = new StringBuffer(cis.get(0).getValue());
                for (int i = 1; i < cis.size(); ++i) {
                    String currentValue = "," + cis.get(i).getValue();
                    value.append(currentValue);
                }
            }
            this.getModel().setValue("respbusinessleader", (Object)value, e.getRowDataEntities()[0].getRowIndex());
        }
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("bidsection".equals(entryGrid.getKey())) {
            int rowIndex = evt.getRow();
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidrollsection");
            entryEntityGrid.selectRows(rowIndex, true);
        } else if ("bidrollsection".equals(entryGrid.getKey())) {
            int rowIndex = evt.getRow();
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidsection");
            entryEntityGrid.selectRows(rowIndex, true);
            entryEntityGrid.focusCell(rowIndex, "rollsectionname");
        } else if ("supplierentry".equals(entryGrid.getKey())) {
            int rowIndex = evt.getRow();
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidrollsection");
            entryEntityGrid.selectRows(rowIndex, true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"invalid", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject queryDecision;
            String entityId = this.getView().getEntityId();
            String appId = entityId.split("_")[0];
            if ("bid".equals(appId) && (queryDecision = BusinessDataServiceHelper.loadSingle((String)"bid_decision", (String)"bidsection,supplierentry,xkpurorderbillno", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)this.getModel().getDataEntity().getPkValue())), new QFilter(BILL_STATUS, "!=", (Object)"XX")})) != null) {
                boolean flag = false;
                DynamicObjectCollection bidsections = queryDecision.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidsection : bidsections) {
                    DynamicObjectCollection supplierEntry = bidsection.getDynamicObjectCollection("supplierentry");
                    for (int i = 0; i < supplierEntry.size(); ++i) {
                        DynamicObject supplierEntryRow = (DynamicObject)supplierEntry.get(i);
                        String xkPurOrderBillno = supplierEntryRow.getString("xkpurorderbillno");
                        if (xkPurOrderBillno == null || xkPurOrderBillno.isEmpty()) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    break;
                }
                if (flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5df2\u751f\u6210\u661f\u7a7a\u91c7\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6d41\u6807\u64cd\u4f5c\u3002", (String)"BidProjectEdit_49", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.itemClick_cancelProMsg();
        }
        if (StringUtils.equals((CharSequence)FIELD_ENABLE_MULTI_SECTION, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                boolean mult = this.getView().getModel().getDataEntity(true).getBoolean(FIELD_ENABLE_MULTI_SECTION);
                this.setEnableMultiSection(mult, true);
                this.getModel().deleteEntryData("bidsection");
                this.getModel().deleteEntryData("bidrollsection");
                this.setSingleSectionStatus();
                this.getModel().setValue("totalcontrol", (Object)0);
                this.getModel().setValue("totalctrlexcvat", (Object)0);
                DynamicObject purType = (DynamicObject)this.getModel().getValue("purtype");
                if (purType == null || purType != null && !purType.getBoolean("materialpur")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"purentryworkload"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"purentryworkload"});
                }
            } else {
                this.getModel().beginInit();
                this.getModel().setValue(FIELD_ENABLE_MULTI_SECTION, (Object)Boolean.TRUE);
                this.getModel().endInit();
                this.getView().updateView(FIELD_ENABLE_MULTI_SECTION);
            }
        }
        if (StringUtils.equals((CharSequence)"purmodel", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.setEnableMultiSection(false, true);
                this.getModel().deleteEntryData("bidsection");
                this.getModel().deleteEntryData("bidrollsection");
                this.setSingleSectionStatus();
                this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_ENABLE_MULTI_SECTION, SECTION_PUR_DETAIL_CONTAINER, "purdetailcontainer"});
                this.getModel().setValue("totalcontrol", (Object)0);
                this.getModel().setValue("totalctrlexcvat", (Object)0);
                this.getView().setVisible(Boolean.FALSE, new String[]{"totalcontrol"});
            } else {
                this.getModel().setValue("purmodel", (Object)PurchaseModel.ProjectProcurement.getVal());
                this.getView().updateView("purmodel");
            }
        }
        if (StringUtils.equals((CharSequence)"projectentry", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("submit", "true");
            this.getView().invokeOperation("submit", operateOption);
        }
        if (StringUtils.equals((CharSequence)"deletesectionentry", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject project = this.getModel().getDataEntity(true);
            DynamicObjectCollection rollSectionColl = project.getDynamicObjectCollection("bidrollsection");
            DynamicObjectCollection bidSectionColl = project.getDynamicObjectCollection("bidsection");
            EntryGrid entryGrid4Session = (EntryGrid)this.getControl("bidsection");
            int[] selects = entryGrid4Session.getSelectRows();
            if (selects.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u64cd\u4f5c\u3002", (String)"BidProjectEdit_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            for (int i = 0; i < selects.length; ++i) {
                int select = selects[i];
                for (int j = 0; j < rollSectionColl.size(); ++j) {
                    if (j != select) continue;
                    this.getModel().deleteEntryData("supplierentry");
                    rollSectionColl.remove(j);
                    bidSectionColl.remove(j);
                }
            }
            this.getView().updateView("bidrollsection");
            this.getView().updateView("bidsection");
            this.getView().updateView("supplierentry");
        }
        if (StringUtils.equals((CharSequence)PUR_TYPE_CHANGE, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.clearPurDetailEntry();
                this.setFieldVisible();
            } else {
                String oldPurTypeId = this.getPageCache().get("oldPurTypeId");
                DynamicObject oldPurType = null;
                if (null != oldPurTypeId) {
                    String appId = this.getModel().getDataEntityType().getAppId();
                    oldPurType = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(oldPurTypeId), (String)(appId + "_purtype"));
                }
                this.getModel().getDataEntity().set("purtype", oldPurType);
                this.getView().updateView("purtype");
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        List<Object> hasSelectUser;
        String fieldKey = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)F7_POSITION)) {
            int rowIndex = arg0.getRow();
            if (rowIndex != -1) {
                DynamicObject member = this.getModel().getEntryRowEntity("memberentity", rowIndex);
                DynamicObject user = member.getDynamicObject("user");
                if (user == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bf9\u5e94\u7684\u62db\u6807\u5c0f\u7ec4\u6210\u5458\uff0c\u518d\u9009\u53d6\u5bf9\u5e94\u7684\u804c\u4f4d\u3002", (String)"BidProjectEdit_50", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    arg0.setCancel(true);
                    return;
                }
                String id = user.getString("id");
                if (!StringUtils.isEmpty((CharSequence)id) && !"0".equals(id)) {
                    QFilter qFilter = new QFilter("user.id", "=", (Object)id);
                    ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
            }
            return;
        }
        if ((StringUtils.equals((CharSequence)fieldKey, (CharSequence)"user") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"userleader")) && !(hasSelectUser = this.getHasSelectUser()).isEmpty()) {
            arg0.getCustomQFilters().add(new QFilter("id", "not in", hasSelectUser));
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"org")) {
            List<Long> pos = this.getHasPermOrgs();
            if (pos == null) {
                return;
            }
            QFilter qFilter = new QFilter("id", "in", pos);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"user")) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("usertypes.fbasedataid.number", "=", (Object)"PT01"));
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String datasource = dataEntity.getString("datasource");
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"purtype") && "2".equals(datasource)) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(new QFilter("materialpur", "=", (Object)Boolean.TRUE));
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"materialid") && "2".equals(datasource)) {
            this.setMaterialFilter(arg0, dataEntity);
        }
        if ("purentryproject".equals(fieldKey)) {
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (org == null) {
                return;
            }
            ArrayList<Long> curOrgList = new ArrayList<Long>(16);
            curOrgList.add((Long)org.getPkValue());
            List allSubordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)"02", curOrgList, (boolean)true);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("org", "in", (Object)allSubordinateOrgs));
        }
    }

    public List<Object> getHasSelectUser() {
        ArrayList<Object> selectUserIdList = new ArrayList<Object>();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection memberLeaderEntity = dataEntity.getDynamicObjectCollection("memberleaderentity");
        List userLeaderIdList = memberLeaderEntity.stream().filter(row -> row.getDynamicObject("userleader") != null).map(row -> row.getDynamicObject("userleader").getPkValue()).collect(Collectors.toList());
        selectUserIdList.addAll(userLeaderIdList);
        DynamicObjectCollection memberEntity = dataEntity.getDynamicObjectCollection("memberentity");
        List userIdList = memberEntity.stream().filter(row -> row.getDynamicObject("user") != null).map(row -> row.getDynamicObject("user").getPkValue()).collect(Collectors.toList());
        selectUserIdList.addAll(userIdList);
        return selectUserIdList;
    }

    protected void setMaterialFilter(BeforeF7SelectEvent arg0, DynamicObject dataEntity) {
        long sourceId = dataEntity.getLong("xkpurreqid");
        if (sourceId == 0L) {
            return;
        }
        DynamicObject purapplybill = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pm_purapplybill");
        if (purapplybill == null) {
            return;
        }
        DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
        HashSet curEntryMaterialIds = new HashSet(16);
        bidsection.forEach(section -> {
            DynamicObjectCollection projectentry = section.getDynamicObjectCollection("projectentry");
            projectentry.forEach(entry -> {
                DynamicObject materialid = entry.getDynamicObject("materialid");
                if (materialid != null) {
                    curEntryMaterialIds.add(materialid.getPkValue());
                }
            });
        });
        HashSet needAddMaterialIds = new HashSet(16);
        DynamicObjectCollection billentry = purapplybill.getDynamicObjectCollection("billentry");
        billentry.forEach(entry -> {
            DynamicObject material = entry.getDynamicObject("material").getDynamicObject("masterid");
            if (material != null && !curEntryMaterialIds.contains(material.getPkValue())) {
                needAddMaterialIds.add(material.getPkValue());
            }
        });
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("id", "in", needAddMaterialIds));
    }

    public void cellClick(CellClickEvent paramCellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent paramCellClickEvent) {
    }

    @Override
    protected boolean needHandleSupplier() {
        return true;
    }

    @Override
    protected boolean needContact() {
        return true;
    }

    @Override
    protected boolean needSupplierStatisticInfo() {
        return true;
    }

    @Override
    public String getBillId() {
        return "bid_project";
    }

    @Override
    protected boolean isSingleSection() {
        return (Boolean)this.getModel().getValue(this.ENABLE_MULTI_SECTION) == false;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = this.getModel().getDataEntity(true).getDynamicObject("org");
        if (org == null) {
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            String formId = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass());
            DefaultOrgReg defaultOrgReg = new DefaultOrgReg(appId, "02", formId);
            Long orgId = DefaultOrgUtil.getEditUIDefaultOrg((DefaultOrgReg)defaultOrgReg);
            this.getModel().setValue("org", (Object)orgId);
        }
        this.getModel().setItemValueByID("contact", (Object)RequestContext.get().getUserId(), 0);
        DynamicObject user = (DynamicObject)this.getModel().getValue("contact");
        if (user != null) {
            this.getModel().setValue("contacttel", (Object)user.getString("phone"));
            this.getModel().setValue("proemail", (Object)user.getString("email"));
        }
        this.getModel().setItemValueByID("bidmode", (Object)this.getBidMethodId(), 0);
        this.setProjectProcessStatus();
        EntityType type = this.projectService.createSectionType();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_project");
        EntityType rollType = (EntityType)mainType.getAllEntities().get("bidrollsection");
        DynamicObject section = new DynamicObject((DynamicObjectType)type);
        DynamicObject rollSection = new DynamicObject((DynamicObjectType)rollType);
        ORM orm = ORM.create();
        long id = orm.genLongId((IDataEntityType)type);
        section.set("id", (Object)id);
        section.set("sectionname", (Object)ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"BidProjectEdit_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        rollSection.set("id", (Object)id);
        rollSection.set("rollsectionname", (Object)ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"BidProjectEdit_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        DynamicObjectCollection members = (DynamicObjectCollection)this.getModel().getValue("memberentity");
        if (members != null) {
            String uid = RequestContext.get().getUserId();
            int newEntryRow = this.getModel().createNewEntryRow("memberentity");
            this.getModel().setItemValueByID("user", (Object)uid, newEntryRow);
            DynamicObject user4Bos = BusinessDataServiceHelper.loadSingle((Object)uid, (String)"bos_user");
            List entries = user4Bos.getDynamicObjectCollection("entryentity").stream().filter(entry -> !entry.getBoolean("ispartjob")).collect(Collectors.toList());
            if (entries != null && entries.size() > 0) {
                this.getModel().setItemValueByID(F7_POSITION, ((DynamicObject)entries.get(0)).getPkValue(), newEntryRow);
            }
            this.getModel().setValue("respbusiness", (Object)",01,", newEntryRow);
        }
        section.getDataEntityState().setPushChanged(true);
        rollSection.getDataEntityState().setPushChanged(true);
        ((DynamicObjectCollection)this.getModel().getValue("bidsection")).add((Object)section);
        ((DynamicObjectCollection)this.getModel().getValue("bidrollsection")).add((Object)rollSection);
        String appId = this.getAppId();
        String ipscope = "thisbidding";
        if ("bid".equals(appId)) {
            Object systemParameterValue = SystemParamHelper.getSystemParameterValue((String)"bid", (Long)OrgUnitHelper.getRootOrgId(), (String)"ip_monitor_scope");
            if (systemParameterValue != null) {
                ipscope = systemParameterValue.toString().equals("1") ? "thisbidding" : "histbidding";
            }
            this.getModel().setValue("ipscope", (Object)ipscope);
        } else {
            Object systemParameterValue1 = SystemParamHelper.getSystemParameterValue((String)"rebm", (Long)OrgUnitHelper.getRootOrgId(), (String)"ip_monitor_scope");
            if (systemParameterValue1 != null) {
                ipscope = systemParameterValue1.toString().equals("1") ? "thisbidding" : "histbidding";
            }
            this.getModel().setValue("ipscope", (Object)ipscope);
        }
    }

    public int compareDate(Date d1, Date d2) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatTail = new SimpleDateFormat("HH:mm:ss");
        String ds1 = format.format(d1);
        String ds2 = format.format(d2);
        String dst1 = formatTail.format(d1);
        String dst2 = formatTail.format(d2);
        if ((StringUtils.equals((CharSequence)"00:00:00", (CharSequence)dst1) || StringUtils.equals((CharSequence)"00:00:00", (CharSequence)dst2)) && ds1.equals(ds2)) {
            return 0;
        }
        return d1.compareTo(d2);
    }

    public List<Long> getHasPermOrgs() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List hasPermOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)this.getView().getEntityId(), (String)"47156aff000000ac");
        return hasPermOrgs;
    }

    public String getAppId() {
        return this.getModel().getDataEntityType().getAppId();
    }

    protected void publishInvitation(BeforeDoOperationEventArgs args) {
        QFilter statusFilter;
        if (!this.checkBeforePubInvitation(args)) {
            return;
        }
        Object bidProjectPkValue = this.getModel().getDataEntity().getPkValue();
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectPkValue);
        DynamicObjectCollection invitationColl = QueryServiceHelper.query((String)"bid_invitation", (String)"id,status,releasestatus", (QFilter[])new QFilter[]{qFilter, statusFilter = new QFilter("status", "not in", (Object)new String[]{"XX", "X"})}, (String)"createtime desc");
        if (invitationColl != null && invitationColl.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u9080\u8bf7\u51fd\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidProjectEdit_69", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.showInvitationForm();
    }

    protected void viewInvitation(BeforeDoOperationEventArgs args) {
        Object bidProjectId = this.getModel().getDataEntity().getPkValue();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCustomParam("bidProjectPk", bidProjectId);
        listShowParameter.setBillFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
        listShowParameter.setHasRight(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u5217\u8868", (String)"BidProjectEdit_54", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    protected boolean checkBeforePubInvitation(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String billStatus = dataEntity.getString(BILL_STATUS);
        DynamicObject bidModel = dataEntity.getDynamicObject("bidmode");
        boolean isOpenTender = false;
        if (null != bidModel) {
            isOpenTender = bidModel.getString("name").contains(ResManager.loadKDString((String)"\u516c\u5f00\u62db\u6807", (String)"BidProjectEdit_24", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
        if (isOpenTender || !BillStatusEnum.AUDITED.getVal().equals(billStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u9488\u5bf9\u5df2\u5ba1\u6838\u4e14\u975e\u516c\u5f00\u62db\u6807\u7684\u7acb\u9879\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"BidProjectEdit_80", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        boolean checkNextStepUnStarted = new BidProjectServiceImpl().checkNextStepUnStarted(dataEntity, BidStepEnum.BidProject);
        if (!checkNextStepUnStarted) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"BidProjectEdit_81", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        boolean isNeedSend = false;
        DynamicObjectCollection sectionEntryColl = dataEntity.getDynamicObjectCollection("bidrollsection");
        block0: for (DynamicObject sectionEntry : sectionEntryColl) {
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                String invitationStatus = supplierEntry.getString("invitationstatus");
                if (!"UNSEND".equals(invitationStatus)) continue;
                isNeedSend = true;
                continue block0;
            }
        }
        if (!isNeedSend) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f85\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"BidProjectEdit_82", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    protected void showInvitationForm() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object invitationId = null;
        QFilter qFilter = new QFilter("bidproject.id", "=", dataEntity.getPkValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)"A");
        DynamicObject[] invitationCol = BusinessDataServiceHelper.load((String)(this.getAppId() + "_invitation"), (String)"id,status", (QFilter[])new QFilter[]{qFilter, statusFilter}, (String)"createtime desc");
        if (invitationCol != null && invitationCol.length > 0) {
            invitationId = invitationCol[0].get("id");
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        showParameter.setCustomParam("bidProjectId", dataEntity.getPkValue());
        showParameter.setPkId(invitationId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u53d1\u5e03", (String)"BidProjectEdit_58", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        showParameter.setStatus(invitationId == null ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "publishInvitation");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setSupplierInvStatusAfterCopy();
    }

    protected void setSupplierInvStatusAfterCopy() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection sectionEntryColl = dataEntity.getDynamicObjectCollection("bidrollsection");
        if (sectionEntryColl.size() > 0) {
            for (DynamicObject sectionEntry : sectionEntryColl) {
                DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryColl) {
                    supplierEntry.set("invitationstatus", (Object)InvitationStatusEnum.UNSEND);
                }
            }
        }
    }

    public void tempDealSupplier(ClosedCallBackEvent closedCallBackEvent) {
        String appId = this.getModel().getDataEntityType().getAppId();
        String supplierFlag = "";
        supplierFlag = StringUtils.equals((CharSequence)"rebm", (CharSequence)appId) ? "suppliername" : "supplier";
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("bidsection");
        DynamicObject section = this.getModel().getEntryRowEntity("bidrollsection", rowIndex);
        DynamicObjectCollection supplierColl = section.getDynamicObjectCollection("supplierentry");
        for (DynamicObject row : supplierColl) {
            map.put(row.getDynamicObject(supplierFlag).getPkValue().toString(), row);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection bidrollsection = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("bidrollsection");
        Iterator bidRollIter = bidrollsection.iterator();
        int bidIndex = 0;
        while (bidRollIter.hasNext()) {
            DynamicObject bidsection = (DynamicObject)bidRollIter.next();
            DynamicObjectCollection supplierentry = bidsection.getDynamicObjectCollection("supplierentry");
            Iterator supplierIter = supplierentry.iterator();
            int supplierIndex = -1;
            while (supplierIter.hasNext()) {
                DynamicObject newUser;
                DynamicObject viewRow = (DynamicObject)supplierIter.next();
                String pkValue = viewRow.getDynamicObject(supplierFlag).getPkValue().toString();
                ++supplierIndex;
                if (!map.containsKey(pkValue) || (newUser = viewRow.getDynamicObject("projectpartner")) == null) continue;
                model.setValue("projectpartner", (Object)newUser, supplierIndex);
                model.setValue("suppliercontact", (Object)new LocaleString(newUser.getString("username")), supplierIndex);
                model.setValue("contactphone", (Object)newUser.getString("phone"), supplierIndex);
                model.setValue("email", (Object)newUser.getString("email"), supplierIndex);
            }
            ++bidIndex;
        }
        model.endInit();
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        BasedataEdit source = (BasedataEdit)afterF7SelectEvent.getSource();
        String fieldKey = source.getFieldKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"materialid")) {
            long sourceId = dataEntity.getLong("xkpurreqid");
            if (sourceId == 0L) {
                return;
            }
            DynamicObject purapplybill = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pm_purapplybill");
            if (purapplybill == null) {
                return;
            }
            HashSet<String> selectPkSet = new HashSet<String>(16);
            ListSelectedRowCollection listSelectedRowCollection = afterF7SelectEvent.getListSelectedRowCollection();
            for (ListSelectedRow listRow : listSelectedRowCollection) {
                String string = listRow.getPrimaryKeyValue().toString();
                selectPkSet.add(string);
            }
            DynamicObjectCollection bidsections = dataEntity.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidsection : bidsections) {
                DynamicObjectCollection projectentrys = bidsection.getDynamicObjectCollection("projectentry");
                block2: for (DynamicObject row : projectentrys) {
                    DynamicObject bidMaterialid = row.getDynamicObject("materialid");
                    if (!selectPkSet.contains(bidMaterialid.getPkValue().toString())) continue;
                    DynamicObjectCollection billentry = purapplybill.getDynamicObjectCollection("billentry");
                    for (DynamicObject entry : billentry) {
                        DynamicObject material = entry.getDynamicObject("material").getDynamicObject("masterid");
                        if (!StringUtils.equals((CharSequence)material.getPkValue().toString(), (CharSequence)bidMaterialid.getPkValue().toString())) continue;
                        String entryId = entry.getPkValue().toString();
                        Object baseqty = entry.get("baseqty");
                        DynamicObject entryreqorg = entry.getDynamicObject("entryreqorg");
                        DynamicObject entryrecorg = entry.getDynamicObject("entryrecorg");
                        row.set("xkpurregentryid", (Object)entryId);
                        row.set("qty", baseqty);
                        row.set("entryreqorg", (Object)entryreqorg);
                        row.set("entryrecorg", (Object)entryrecorg);
                        this.getView().updateView("bidsection");
                        this.getView().updateView("projectentry");
                        continue block2;
                    }
                }
            }
        }
    }
}

