/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidEvalMethodEnum;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.EvalItemType;
import kd.scm.bid.common.enums.ScoreMode;
import kd.scm.bid.common.enums.ScoreType;
import kd.scm.bid.formplugin.bill.AbstractCommontDateChange;

public class BidProjectOpenEvalPlanEditUI
extends AbstractCommontDateChange
implements BeforeF7SelectListener,
BasedataFuzzySearchListener {
    public static final String BIDOPENEVALITEMFLEX = "bidopenevalitementry1";
    public static final String EVELITEMSPLITCONTAINER = "evelitemsplitcontainer";
    public static final String OPENEVALBASEFLEX = "openevalbaseflex";
    public static final String OPENEVALPLANTABPAGE = "openevalplantabpage";
    public static final BigDecimal techWeightValue = new BigDecimal("0.6");
    public static final BigDecimal comWeightValue = new BigDecimal("0.4");
    public static final BigDecimal weightSumNumber = new BigDecimal("1");
    public static final String ADDEVALITEMENTRY = "addevalitementry";
    public static final String INSERTEVALITEMENTRY = "insertentry";
    public static final String CACHE_BID_DOCTYPE_OLDVALUE = "cachebiddoctypeoldvalue";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (dataEntity == null) {
            return;
        }
        Boolean isOnlineEval = dataEntity.getBoolean("isonlineeval");
        String evaluatedmethod = dataEntity.getString("evaluatedmethod");
        Boolean isOnline = false;
        isOnline = evaluatedmethod.equals("1") ? Boolean.valueOf(false) : isOnlineEval;
        this.showOnlinePageByIsOnlineEval(isOnline, Boolean.FALSE);
        this.showTechnicalCommercialByDocType(dataEntity.getString("doctype"), true);
        DynamicObject bidModel = dataEntity.getDynamicObject("bidmode");
        Boolean bidModelHasEvaluation = Boolean.FALSE;
        if (bidModel != null) {
            bidModelHasEvaluation = bidModel.getBoolean("bidevaluation");
        }
        if (isOnlineEval.booleanValue()) {
            this.setTypeVisible(dataEntity.getString("scoretype"));
        }
        this.getView().setVisible(bidModelHasEvaluation, new String[]{"isonlineeval"});
        DynamicObject evaluatedecideway = dataEntity.getDynamicObject("evaluatedecideway");
        if (evaluatedecideway == null) {
            dataEntity.set("evaluatedecideway", (Object)BusinessDataServiceHelper.loadSingle((Object)this.getDefaultEvaluateDecideWay(), (String)"bid_evaluatedecideway"));
            this.getView().updateView("evaluatedecideway");
        }
        if (dataEntity.getBigDecimal("techweight").compareTo(BigDecimal.ZERO) == 0 && dataEntity.getBigDecimal("comweight").compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue("techweight", (Object)techWeightValue);
        }
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        BasedataEdit bidevalTemplate = (BasedataEdit)this.getView().getControl("bidevaltemplate");
        bidevalTemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("suppliername");
        if (null != supplier) {
            supplier.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
        }
        BasedataEdit quotationscoresch = (BasedataEdit)this.getView().getControl("quotationscoresch");
        quotationscoresch.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        super.registerListener(e);
    }

    public void handleData(BasedataFuzzySearchEvent evt) {
        List queryData = evt.getQueryData();
        DynamicObjectCollection supplierEntryList = this.getModel().getEntryEntity("supplierentry");
        List supplierIdList = supplierEntryList.stream().map(item -> {
            DynamicObject supplierName = item.getDynamicObject("suppliername");
            if (null != supplierName) {
                return supplierName.getPkValue().toString();
            }
            return null;
        }).collect(Collectors.toList());
        queryData.removeIf(item -> {
            List itemList = (List)item;
            return supplierIdList.contains(itemList.get(0));
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getPageCache().put("isChanged", "1");
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity == null) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"evaluatedmethod", (CharSequence)fieldKey)) {
            if ("1".equals(newVal)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"techweight"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"comweight"});
                this.showOnlinePageByIsOnlineEval(Boolean.FALSE, Boolean.TRUE);
                return;
            }
            String doctype = this.getModel().getDataEntity(true).getString("doctype");
            if ("BUSSINESS".equals(doctype)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"comweight"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"techweight"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"comweight"});
            }
            Boolean isonlineeval = this.getView().getModel().getDataEntity(true).getBoolean("isonlineeval");
            this.showOnlinePageByIsOnlineEval(isonlineeval, Boolean.TRUE);
            return;
        }
        if (StringUtils.equals((CharSequence)"isonlineeval", (CharSequence)fieldKey)) {
            String method = this.getView().getModel().getDataEntity(true).getString("evaluatedmethod");
            if ("1".equals(method)) {
                return;
            }
            this.showOnlinePageByIsOnlineEval((Boolean)newVal, Boolean.TRUE);
        } else if (StringUtils.equals((CharSequence)"bidevaltemplate", (CharSequence)fieldKey)) {
            if (newVal == null) {
                return;
            }
            String bidEvalTemplatePkValue = ((DynamicObject)newVal).getPkValue().toString();
            this.updateOpenTypeEntryByTemplate(bidEvalTemplatePkValue);
        } else if (StringUtils.equals((CharSequence)"scoremode", (CharSequence)fieldKey)) {
            if (newVal == null) {
                return;
            }
            this.setEntryVisibleByScoreMode(newVal.toString());
        } else if (StringUtils.equals((CharSequence)"scoretype", (CharSequence)fieldKey)) {
            if (newVal == null) {
                return;
            }
            String scoreType = newVal.toString();
            this.setFlexStatusByScoreType(scoreType);
            this.getModel().setValue("bidevaltemplate", null);
        } else if (StringUtils.equals((CharSequence)"bidmode", (CharSequence)fieldKey)) {
            this.showIsOnlineEvalByBidModel(dataEntity);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"doctype")) {
            if (oldVal == null) {
                this.getPageCache().put(CACHE_BID_DOCTYPE_OLDVALUE, BidOpenTypeEnum.MULTI.getValue());
            } else {
                this.getPageCache().put(CACHE_BID_DOCTYPE_OLDVALUE, oldVal.toString());
            }
            if (this.isBidPlanUpdated()) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("doctype", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u5207\u6362\u62db\u6807\u8303\u56f4\uff0c\u5c06\u6e05\u9664\u62db\u6807\u65b9\u6848\u76f8\u5173\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BidProjectOpenEvalPlanEditUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                return;
            }
            if (newVal != null) {
                String docTypeStr = newVal.toString();
                this.propertyChange_UpdateViewByDocType(docTypeStr);
                this.deleteAllOpenEvalData();
                this.setScoreTypeItem(dataEntity.getString("scoremode"));
                this.showTechnicalCommercialByDocType(dataEntity.getString("doctype"), false);
                this.getView().updateView(OPENEVALPLANTABPAGE);
                this.changeDoctype(dataEntity, docTypeStr);
            }
        } else if (StringUtils.equals((CharSequence)"techweight", (CharSequence)fieldKey)) {
            BigDecimal newTechWeight = BigDecimal.ZERO;
            if (newVal != null) {
                newTechWeight = new BigDecimal(newVal.toString());
                BigDecimal newComWeight = weightSumNumber.subtract(newTechWeight).setScale(4, 4);
                dataEntity.set("comweight", (Object)newComWeight);
            } else {
                dataEntity.set("comweight", (Object)weightSumNumber);
            }
            this.getView().updateView("comweight");
        } else if (StringUtils.equals((CharSequence)"comweight", (CharSequence)fieldKey)) {
            BigDecimal newComWeight = BigDecimal.ZERO;
            if (newVal != null) {
                newComWeight = new BigDecimal(newVal.toString());
                BigDecimal newTechWeight = weightSumNumber.subtract(newComWeight).setScale(4, 4);
                dataEntity.set("techweight", (Object)newTechWeight);
            } else {
                dataEntity.set("techweight", (Object)weightSumNumber);
            }
            this.getView().updateView("techweight");
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"type") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"score") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"weight")) {
            this.changeDetailData();
        }
    }

    public void changeDoctype(DynamicObject dataEntity, String docTypeStr) {
        if (StringUtils.equals((CharSequence)"MULTI", (CharSequence)docTypeStr)) {
            this.getModel().setValue("backbidway", (Object)"totaltechnical");
            this.getModel().setValue("bidopentype", (Object)"UNIONOPEN");
            this.getModel().setValue("evaluatedmethod", (Object)"0");
            this.getView().setVisible(Boolean.TRUE, new String[]{"backbidway", "bidopentype"});
        } else {
            this.getModel().setValue("backbidway", (Object)"");
            this.getModel().setValue("bidopentype", (Object)"");
            this.getView().setVisible(Boolean.FALSE, new String[]{"backbidway", "bidopentype"});
        }
        this.getView().updateView("backbidway");
        this.getView().updateView("bidopentype");
        this.getView().updateView("evaluatedmethod");
        DynamicObject bidModel = (DynamicObject)this.getModel().getValue("bidmode");
        this.setVisitBackPlantime(docTypeStr, this.getModel().getValue("backbidway").toString());
        this.setVisitTypePlantime(docTypeStr, this.getModel().getValue("bidopentype").toString(), bidModel);
        this.cleanPlanDate(6, 11);
    }

    public boolean isBidPlanUpdated() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (dataEntity == null) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)dataEntity.getString("bidopentype"), (CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue())) {
            return true;
        }
        DynamicObject evaluateDecideWay = dataEntity.getDynamicObject("evaluatedecideway");
        if (evaluateDecideWay == null) {
            return true;
        }
        if (evaluateDecideWay != null && !StringUtils.equals((CharSequence)evaluateDecideWay.getPkValue().toString(), (CharSequence)this.getDefaultEvaluateDecideWay())) {
            return true;
        }
        if (dataEntity.getBigDecimal("techweight").compareTo(techWeightValue) != 0) {
            return true;
        }
        if (dataEntity.getBigDecimal("comweight").compareTo(comWeightValue) != 0) {
            return true;
        }
        if (dataEntity.getBoolean("isonlineeval")) {
            return true;
        }
        DynamicObjectCollection proficientEntry = dataEntity.getDynamicObjectCollection("bid_proficiententry");
        return proficientEntry != null && proficientEntry.size() > 0;
    }

    public void propertyChange_UpdateViewByDocType(String docTypeStr) {
        if (BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bidopentype"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"isseparatedoc"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"technicaldocenddate"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"commercialdocenddate"});
        } else {
            this.getModel().setValue("bidopentype", (Object)BidOpenSelectTypeEnum.UNIONOPEN.getValue());
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidopentype"});
            this.getModel().setValue("isseparatedoc", (Object)Boolean.FALSE);
            this.getView().setVisible(Boolean.FALSE, new String[]{"isseparatedoc"});
            boolean isBidDocument = (Boolean)this.getModel().getValue("biddocument");
            if (isBidDocument) {
                if (docTypeStr.equals(BidOpenTypeEnum.TECHNICAL.getValue())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"technicaldocenddate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"commercialdocenddate"});
                } else if (docTypeStr.equals(BidOpenTypeEnum.BUSSINESS.getValue())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"commercialdocenddate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"technicaldocenddate"});
                }
            }
        }
    }

    public void deleteAllOpenEvalData() {
        this.getModel().setValue("bidevaltemplate", null);
        this.getModel().setValue("scoretype", (Object)ScoreType.SUM.getVal());
        this.getModel().setValue("scoremode", (Object)ScoreMode.STANDARD.getVal());
        this.getModel().setValue("isonlineeval", (Object)Boolean.FALSE);
        this.getModel().setValue("evaluatedecideway", (Object)this.getDefaultEvaluateDecideWay());
        this.getModel().deleteEntryData("bid_opentypeentry");
        this.getModel().deleteEntryData("bid_proficiententry");
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        ListShowParameter showParameter;
        String fieldKey = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bidevaltemplate")) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"BidProjectOpenEvalPlanEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            String docTypeStr = dataEntity.getString("doctype");
            showParameter = (ListShowParameter)arg0.getFormShowParameter();
            QFilter qFilter = new QFilter("evaltype", "=", (Object)docTypeStr);
            long orgIdLong = org.getLong("id");
            List parentOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"02", (long)orgIdLong);
            parentOrgIds.add(orgIdLong);
            qFilter.and(new QFilter("org", "in", (Object)parentOrgIds));
            if ("bid".equals(this.getModel().getDataEntityType().getAppId())) {
                qFilter.and(new QFilter("entitytypeid", "=", (Object)"bid_bidevaltemplate"));
            } else {
                qFilter.and(new QFilter("entitytypeid", "!=", (Object)"bid_bidevaltemplate"));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"quotationscoresch")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"BidProjectOpenEvalPlanEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            Object orgId = org.getPkValue();
            QFilter qFilter = new QFilter("org", "=", orgId);
            showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"extractproficient", (CharSequence)operateKey)) {
            String id = this.getModel().getDataEntity().getPkValue().toString();
            if ("0".equals(id)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u672c\u5355\u636e\u3002", (String)"BidProjectOpenEvalPlanEditUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> extractMap = new HashMap<String, String>();
            extractMap.put("formId", FormTypeConstants.getFormConstant((String)"extract_proficient", ((Object)((Object)this)).getClass()));
            FormShowParameter extractPara = null;
            String extractId = String.valueOf(this.getModel().getValue("extractrecoid"));
            if (extractId.equals(" ")) {
                extractId = null;
            }
            extractPara = FormShowParameter.createFormShowParameter(extractMap);
            if (extractId != null) {
                extractPara.setCustomParam("oldExtractId", (Object)extractId);
            }
            extractPara.setStatus(OperationStatus.ADDNEW);
            extractPara.getOpenStyle().setShowType(ShowType.Modal);
            ArrayList<String> existedProficientList = new ArrayList<String>();
            int proficientCount = this.getModel().getEntryRowCount("bid_proficiententry");
            for (int i = 0; i < proficientCount; ++i) {
                DynamicObject bidOpenProficient = this.getModel().getEntryRowEntity("bid_proficiententry", i);
                DynamicObject proficient = bidOpenProficient.getDynamicObject("proficient");
                if (proficient == null || proficient.getPkValue() == null) continue;
                existedProficientList.add(proficient.getPkValue().toString());
            }
            extractPara.setCustomParam("existedProficient", existedProficientList);
            extractPara.setCustomParam("bidproject", (Object)this.getModel().getDataEntity().getLong("id"));
            extractPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "extractproficient"));
            this.getView().showForm(extractPara);
        } else if (StringUtils.equals((CharSequence)"addproficient", (CharSequence)operateKey)) {
            ListShowParameter para = this.createF7(FormTypeConstants.getFormConstant((String)"proficient_f7", ((Object)((Object)this)).getClass()), "bid_proficiententry", "proficient");
            this.getView().showForm((FormShowParameter)para);
        }
        DynamicObjectCollection openTypeEntry = this.getModel().getEntryEntity("bid_opentypeentry");
        for (DynamicObject openTypeEntryRow : openTypeEntry) {
            openTypeEntryRow.getDataEntityState().setPushChanged(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObjectCollection openTypeEntry;
        String billStatus;
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)ADDEVALITEMENTRY, (CharSequence)key) || StringUtils.equals((CharSequence)INSERTEVALITEMENTRY, (CharSequence)key)) {
            int[] selects;
            String scoreType;
            String string = scoreType = this.getModel().getValue("scoretype") == null ? "" : this.getModel().getValue("scoretype").toString();
            if (ScoreType.PART.getVal().equals(scoreType)) {
                EntryGrid detailType = (EntryGrid)this.getControl("bid_openevalentry");
                IDataModel operate = detailType.getModel();
                int activeRow = operate.getEntryRowCount("bid_openevalentry");
                if (StringUtils.equals((CharSequence)INSERTEVALITEMENTRY, (CharSequence)key)) {
                    int[] selects2 = detailType.getSelectRows();
                    if (selects2.length == 0) {
                        return;
                    }
                    activeRow = selects2[0];
                }
                EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bid_opentypeentry");
                selects = entryEntityGrid.getSelectRows();
                String detailTypeSValue = EvalItemType.DEFAULT.getVal();
                detailTypeSValue = selects == null || selects.length == 0 ? EvalItemType.TECHNICAL.getVal() : (selects[0] == 0 ? EvalItemType.TECHNICAL.getVal() : EvalItemType.COMMERCIAL.getVal());
                if (activeRow >= 0) {
                    int rowIndex = activeRow;
                    if (StringUtils.equals((CharSequence)ADDEVALITEMENTRY, (CharSequence)key)) {
                        if (activeRow == 0) {
                            rowIndex = 1;
                        }
                        --rowIndex;
                    }
                    this.getModel().setValue("type", (Object)detailTypeSValue, rowIndex);
                }
            }
            String docType = dataEntity.getString("doctype");
            if (!BidOpenTypeEnum.MULTI.getValue().equals(docType)) {
                EntryGrid detailType = (EntryGrid)this.getControl("bid_openevalentry");
                IDataModel operate = detailType.getModel();
                int activeRow = operate.getEntryRowCount("bid_openevalentry");
                if (StringUtils.equals((CharSequence)INSERTEVALITEMENTRY, (CharSequence)key)) {
                    selects = detailType.getSelectRows();
                    if (selects.length == 0) {
                        return;
                    }
                    activeRow = selects[0];
                }
                if (activeRow > 0) {
                    String detailTypeSValue = EvalItemType.DEFAULT.getVal();
                    if (BidOpenTypeEnum.TECHNICAL.getValue().equals(docType)) {
                        detailTypeSValue = EvalItemType.TECHNICAL.getVal();
                    } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
                        detailTypeSValue = EvalItemType.COMMERCIAL.getVal();
                    }
                    this.getModel().setValue("type", (Object)detailTypeSValue, activeRow - 1);
                }
            }
        }
        if (!"A".equals(billStatus = dataEntity.getString("billstatus"))) {
            EntryGrid aptitudeEntryGrid = (EntryGrid)this.getControl("bid_openevalentry");
            aptitudeEntryGrid.setColumnProperty("type", "l", (Object)55);
            EntryGrid proficientEntryGrid = (EntryGrid)this.getControl("bid_proficiententry");
            proficientEntryGrid.setColumnProperty("proficient_technical", "l", (Object)55);
            proficientEntryGrid.setColumnProperty("proficient_commercial", "l", (Object)55);
        }
        if ((StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) && (openTypeEntry = this.getModel().getEntryEntity("bid_opentypeentry")) != null && openTypeEntry.size() == 1) {
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bid_opentypeentry");
            entryEntityGrid.selectRows(0, true);
        }
        if ((StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key) || StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.showTechnicalCommercialByDocType(dataEntity.getString("doctype"), false);
            this.changeDetailData();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"doctype", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String docTypeStr = dataEntity.getString("doctype");
                this.propertyChange_UpdateViewByDocType(docTypeStr);
                this.deleteAllOpenEvalData();
                this.setScoreTypeItem(dataEntity.getString("scoremode"));
                this.showTechnicalCommercialByDocType(dataEntity.getString("doctype"), false);
                this.getView().updateView(OPENEVALPLANTABPAGE);
                this.changeDoctype(dataEntity, docTypeStr);
            } else {
                this.getModel().getDataEntity().set("doctype", (Object)this.getPageCache().get(CACHE_BID_DOCTYPE_OLDVALUE));
                this.getView().updateView("doctype");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        block6: {
            String actionId;
            block5: {
                super.closedCallBack(closedCallBackEvent);
                actionId = closedCallBackEvent.getActionId();
                if (!FormTypeConstants.getFormConstant((String)"proficient_f7", ((Object)((Object)this)).getClass()).equals(actionId) || closedCallBackEvent.getReturnData() == null) break block5;
                ListSelectedRowCollection returnObj = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                int num = returnObj.size();
                int beforeNum = this.getModel().getEntryRowCount("bid_proficiententry");
                DynamicObjectType entryentityDT = this.getEntryType(this.getView().getEntityId(), "bid_proficiententry");
                if (num <= 0) break block6;
                for (int i = beforeNum; i < num + beforeNum; ++i) {
                    DynamicObject proficientEntry = new DynamicObject(entryentityDT);
                    proficientEntry.setParent((Object)this.getModel().getDataEntity());
                    this.getModel().createNewEntryRow("bid_proficiententry", proficientEntry);
                    this.getModel().setValue("proficient", returnObj.get(i - beforeNum).getPrimaryKeyValue(), i);
                }
                break block6;
            }
            if ("extractproficient".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
                Object[] resultObject = (Object[])closedCallBackEvent.getReturnData();
                HashMap returnMap = (HashMap)resultObject[0];
                HashMap conditionMap = (HashMap)resultObject[1];
                Object extractId = resultObject[2];
                this.getModel().setValue("extractrecoid", extractId);
                HashMap<String, DynamicObject> proficientMap = new HashMap<String, DynamicObject>();
                int proficientCount = this.getModel().getEntryRowCount("bid_proficiententry");
                for (int i = 0; i < proficientCount; ++i) {
                    DynamicObject bidOpenProficient = this.getModel().getEntryRowEntity("bid_proficiententry", i);
                    DynamicObject proficient = bidOpenProficient.getDynamicObject("proficient");
                    if (proficient == null || proficient.getPkValue() == null) continue;
                    proficientMap.put(String.valueOf(proficient.getPkValue()), proficient);
                }
                DynamicObjectType entryentityDT = this.getEntryType(this.getView().getEntityId(), "bid_proficiententry");
                for (int i = 0; i < returnMap.size(); ++i) {
                    DynamicObject[] proficientArr = (DynamicObject[])returnMap.get(String.format(ResManager.loadKDString((String)"\u6761\u4ef6%1$s", (String)"BidProjectOpenEvalPlanEditUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]), i + 1));
                    String[] commontArr = (String[])conditionMap.get(String.format(ResManager.loadKDString((String)"\u6761\u4ef6%1$s", (String)"BidProjectOpenEvalPlanEditUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]), i + 1));
                    for (int j = 0; j < proficientArr.length; ++j) {
                        DynamicObject proficientEntry = new DynamicObject(entryentityDT);
                        proficientEntry.set("proficient", (Object)proficientArr[j]);
                        proficientEntry.setParent((Object)this.getModel().getDataEntity());
                        proficientMap.put(String.valueOf(proficientArr[j].getPkValue()), proficientArr[j]);
                        this.getModel().createNewEntryRow("bid_proficiententry", proficientEntry);
                        this.getModel().setValue("proficient_comment", (Object)String.format(ResManager.loadKDString((String)"\u62bd\u53d6\u6761\u4ef6%1$s:%2$s", (String)"BidProjectOpenEvalPlanEditUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]), i + 1, commontArr[j]), proficientMap.size() - 1);
                    }
                    this.getModel().updateCache();
                }
            }
        }
    }

    public ListShowParameter createF7(String formName, String entryName, String entryEntityName) {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)formName, (boolean)true);
        EntryGrid proficientEntrys = (EntryGrid)this.getView().getControl(entryName);
        IDataModel operate = proficientEntrys.getModel();
        IDataModel model = this.getView().getModel();
        int rowCount = operate.getEntryRowCount(entryName);
        Long[] ids = new Long[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entity = (DynamicObject)model.getValue(entryEntityName, i);
            Object id = entity.get("id");
            ids[i] = Long.parseLong(id.toString());
        }
        OpenStyle openStyle = para.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        para.setShowQuickFilter(true);
        para.setMultiSelect(true);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("status", "=", (Object)BillStatusEnum.AUDITED.getVal()));
        qFilters.add(new QFilter("id", "not in", (Object)ids));
        if (FormTypeConstants.getFormConstant((String)"proficient_f7", ((Object)((Object)this)).getClass()).equals(formName)) {
            List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"02", (boolean)false);
            qFilters.add(new QFilter("org", "in", (Object)orgIds));
        }
        para.getListFilterParameter().setQFilters(qFilters);
        para.setShowUsed(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formName);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    private DynamicObjectType getEntryType(String parentBillId, String entryId) {
        MainEntityType parentDT = EntityMetadataCache.getDataEntityType((String)parentBillId);
        DynamicObject parent = new DynamicObject((DynamicObjectType)parentDT);
        DynamicObjectCollection entryCol = parent.getDynamicObjectCollection(entryId);
        DynamicObjectType entryDT = entryCol.getDynamicObjectType();
        return entryDT;
    }

    private void setFlexStatusByScoreType(String scoreType) {
        DynamicObjectCollection openTypeEntry = this.getModel().getEntryEntity("bid_opentypeentry");
        this.getModel().deleteEntryData("bid_opentypeentry");
        if (scoreType == null) {
            return;
        }
        boolean isAddNew = false;
        if (ScoreType.SUM.getVal().equals(scoreType)) {
            if (openTypeEntry != null && !openTypeEntry.isEmpty()) {
                for (DynamicObject openTypeEntryRow : openTypeEntry) {
                    if (EvalItemType.DEFAULT.getVal().equals(openTypeEntryRow.getString("evalparenttype"))) {
                        int i = this.getModel().createNewEntryRow("bid_opentypeentry");
                        this.getModel().setValue("evalparenttype", openTypeEntryRow.get("evalparenttype"), i);
                        continue;
                    }
                    isAddNew = true;
                    break;
                }
            } else {
                isAddNew = true;
            }
            if (isAddNew) {
                int i = this.getModel().createNewEntryRow("bid_opentypeentry");
                this.getModel().setValue("evalparenttype", (Object)EvalItemType.DEFAULT.getVal(), i);
            }
        } else {
            if (openTypeEntry != null && !openTypeEntry.isEmpty()) {
                for (DynamicObject openTypeEntryRow : openTypeEntry) {
                    if (!EvalItemType.DEFAULT.getVal().equals(openTypeEntryRow.getString("evalparenttype"))) {
                        int i = this.getModel().createNewEntryRow("bid_opentypeentry");
                        this.getModel().setValue("evalparenttype", openTypeEntryRow.get("evalparenttype"), i);
                        continue;
                    }
                    isAddNew = true;
                    break;
                }
            } else {
                isAddNew = true;
            }
            if (isAddNew) {
                int i = this.getModel().createNewEntryRow("bid_opentypeentry");
                this.getModel().setValue("evalparenttype", (Object)EvalItemType.TECHNICAL.getVal(), i);
                i = this.getModel().createNewEntryRow("bid_opentypeentry");
                this.getModel().setValue("evalparenttype", (Object)EvalItemType.COMMERCIAL.getVal(), i);
            }
            this.getModel().setValue("techweight", (Object)techWeightValue);
            this.getModel().setValue("comweight", (Object)comWeightValue);
        }
        this.setTypeVisible(scoreType);
        this.getView().updateView("bid_opentypeentry");
        this.getView().updateView("bid_openevalentry");
        DynamicObjectCollection openTypeEntryNow = this.getModel().getEntryEntity("bid_opentypeentry");
        if (openTypeEntryNow != null && openTypeEntryNow.size() == 1) {
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bid_opentypeentry");
            entryEntityGrid.selectRows(0, true);
        }
    }

    private void setTypeVisible(String scoreType) {
        SplitContainer splitContainer = (SplitContainer)this.getControl(EVELITEMSPLITCONTAINER);
        if (ScoreType.PART.getVal().equals(scoreType)) {
            splitContainer.changeFlexStatus(SplitDirection.left, false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"type"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"techweight"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"comweight"});
        } else {
            splitContainer.changeFlexStatus(SplitDirection.left, true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"type"});
            if (ScoreType.SUM.getVal().equals(scoreType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"techweight"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"comweight"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"techweight"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"comweight"});
            }
        }
    }

    public void setEntryVisibleByScoreMode(String scoreMode) {
        if (scoreMode == null) {
            return;
        }
        FieldEdit scoreControl = (FieldEdit)this.getView().getControl("score");
        FieldEdit weightControl = (FieldEdit)this.getView().getControl("weight");
        if (ScoreMode.STANDARD.getVal().equals(scoreMode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"score"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"weight"});
            scoreControl.setMustInput(true);
            weightControl.setMustInput(false);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"score"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"weight"});
            scoreControl.setMustInput(false);
            weightControl.setMustInput(true);
        }
        FieldEdit typeControl = (FieldEdit)this.getView().getControl("type");
        typeControl.setMustInput(true);
        this.setScoreTypeItem(scoreMode);
    }

    public void setScoreTypeItem(String scoreMode) {
        if (scoreMode == null) {
            return;
        }
        String docTypeStr = this.getModel().getDataEntity().getString("doctype");
        String sumCaption = ResManager.loadKDString((String)"\u6280\u672f\u6807\u52a0\u5546\u52a1\u6807\u6ee1\u5206100\u5206", (String)"BidProjectOpenEvalPlanEditUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        String partCaption = ResManager.loadKDString((String)"\u6280\u672f\u6807\u548c\u5546\u52a1\u6807\u6ee1\u5206\u5404100\u5206", (String)"BidProjectOpenEvalPlanEditUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(docTypeStr)) {
            sumCaption = ResManager.loadKDString((String)"\u6280\u672f\u6807\u6ee1\u5206100\u5206", (String)"BidProjectOpenEvalPlanEditUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            partCaption = ResManager.loadKDString((String)"\u6280\u672f\u6807\u6ee1\u5206100\u5206", (String)"BidProjectOpenEvalPlanEditUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr)) {
            sumCaption = ResManager.loadKDString((String)"\u5546\u52a1\u6807\u6ee1\u5206100\u5206", (String)"BidProjectOpenEvalPlanEditUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            partCaption = ResManager.loadKDString((String)"\u5546\u52a1\u6807\u6ee1\u5206100\u5206", (String)"BidProjectOpenEvalPlanEditUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if (ScoreMode.WEIGHT.getVal().equals(scoreMode)) {
            sumCaption = ResManager.loadKDString((String)"\u6280\u672f\u6807\u52a0\u5546\u52a1\u6807\u6743\u91cd100%", (String)"BidProjectOpenEvalPlanEditUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            partCaption = ResManager.loadKDString((String)"\u6280\u672f\u6807\u548c\u5546\u52a1\u6807\u6743\u91cd\u5404100%", (String)"BidProjectOpenEvalPlanEditUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            if (BidOpenTypeEnum.TECHNICAL.getValue().equals(docTypeStr)) {
                sumCaption = ResManager.loadKDString((String)"\u6280\u672f\u6807\u6743\u91cd100%", (String)"BidProjectOpenEvalPlanEditUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                partCaption = ResManager.loadKDString((String)"\u6280\u672f\u6807\u6743\u91cd100%", (String)"BidProjectOpenEvalPlanEditUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr)) {
                sumCaption = ResManager.loadKDString((String)"\u5546\u52a1\u6807\u6743\u91cd100%", (String)"BidProjectOpenEvalPlanEditUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                partCaption = ResManager.loadKDString((String)"\u5546\u52a1\u6807\u6743\u91cd100%", (String)"BidProjectOpenEvalPlanEditUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            }
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ScoreType sumEnum = ScoreType.SUM;
        ScoreType partEnum = ScoreType.PART;
        ComboItem sumItem = new ComboItem();
        sumItem.setCaption(new LocaleString(sumCaption));
        sumItem.setValue(sumEnum.getVal());
        ComboItem partItem = new ComboItem();
        partItem.setCaption(new LocaleString(partCaption));
        partItem.setValue(partEnum.getVal());
        items.add(sumItem);
        items.add(partItem);
        ComboEdit scoreType = (ComboEdit)this.getView().getControl("scoretype");
        scoreType.setComboItems(items);
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(docTypeStr) || BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"scoretype"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"scoretype"});
        }
    }

    public void updateOpenTypeEntryByTemplate(String bidEvalTemplatePkValue) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"bidevaltemplate", ((Object)((Object)this)).getClass()));
        DynamicObject bidEvalTemplate = BusinessDataServiceHelper.loadSingle((Object)bidEvalTemplatePkValue, (DynamicObjectType)mainType);
        String bidScoreMode = bidEvalTemplate.getString("scoremode");
        this.getModel().getDataEntity().set("scoremode", (Object)bidScoreMode);
        this.setEntryVisibleByScoreMode(bidScoreMode);
        String bidScoreType = bidEvalTemplate.getString("scoretype");
        this.getModel().getDataEntity().set("scoretype", (Object)bidScoreType);
        this.setFlexStatusByScoreType(bidScoreType);
        this.getModel().getDataEntity().set("quotationscoresch", bidEvalTemplate.get("quotationscoresch"));
        DynamicObjectCollection bidEvalTemplateEntities = bidEvalTemplate.getDynamicObjectCollection("entryentity");
        this.getModel().deleteEntryData("bid_opentypeentry");
        for (DynamicObject dataEntity : bidEvalTemplateEntities) {
            int j = this.getModel().createNewEntryRow("bid_opentypeentry");
            this.getModel().setValue("evalparenttype", dataEntity.get("type1"), j);
        }
        this.getView().updateView("bid_opentypeentry");
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity("bid_opentypeentry");
        for (int i = 0; i < entryentitys.size(); ++i) {
            DynamicObject bidEvalTemplateEntryRow = (DynamicObject)bidEvalTemplateEntities.get(i);
            DynamicObjectCollection dataSub = bidEvalTemplateEntryRow.getDynamicObjectCollection("subentryentity");
            DynamicObject entryentity = (DynamicObject)entryentitys.get(i);
            DynamicObjectCollection sub = entryentity.getDynamicObjectCollection("bid_openevalentry");
            for (int j = 0; j < dataSub.size(); ++j) {
                DynamicObject object = (DynamicObject)dataSub.get(j);
                DynamicObject newObject = sub.addNew();
                newObject.set("seq", (Object)(j + 1));
                newObject.set("type", object.get("type"));
                newObject.set("item", object.get("item"));
                newObject.set("standard", object.get("standard"));
                newObject.set("score", object.get("score"));
                newObject.set("weight", object.get("weight"));
                newObject.set("quotationindex", object.get("quotationindex"));
            }
        }
        this.changeDetailData();
        this.getView().updateView("bid_openevalentry");
        this.getView().updateView(OPENEVALBASEFLEX);
    }

    public void changeDetailData() {
        String scoreType = this.getModel().getValue("scoretype") == null ? "" : this.getModel().getValue("scoretype").toString();
        Object isonlineeval = this.getModel().getValue("isonlineeval");
        if (((Boolean)isonlineeval).booleanValue() && ScoreType.SUM.getVal().equals(scoreType)) {
            BigDecimal techWeightValue = BigDecimal.ZERO;
            BigDecimal comWeightValue = BigDecimal.ZERO;
            DynamicObjectCollection evalitementry = this.getModel().getEntryEntity("bid_openevalentry");
            if (evalitementry == null) {
                return;
            }
            String scoreMode = this.getModel().getValue("scoremode") == null ? "" : this.getModel().getValue("scoremode").toString();
            for (DynamicObject entry : evalitementry) {
                if (ScoreMode.STANDARD.getVal().equals(scoreMode)) {
                    BigDecimal tempScore = entry.getBigDecimal("score");
                    if (EvalItemType.TECHNICAL.getVal().equals(entry.getString("type"))) {
                        techWeightValue = techWeightValue.add(tempScore);
                        continue;
                    }
                    if (!EvalItemType.COMMERCIAL.getVal().equals(entry.getString("type"))) continue;
                    comWeightValue = comWeightValue.add(tempScore);
                    continue;
                }
                BigDecimal tempWeight = entry.getBigDecimal("weight");
                if (EvalItemType.TECHNICAL.getVal().equals(entry.getString("type"))) {
                    techWeightValue = techWeightValue.add(tempWeight);
                    continue;
                }
                if (!EvalItemType.COMMERCIAL.getVal().equals(entry.getString("type"))) continue;
                comWeightValue = comWeightValue.add(tempWeight);
            }
            if (ScoreMode.STANDARD.getVal().equals(scoreMode)) {
                techWeightValue = techWeightValue.divide(new BigDecimal(100));
                comWeightValue = comWeightValue.divide(new BigDecimal(100));
            }
            this.getModel().getDataEntity().set("techweight", (Object)techWeightValue.doubleValue());
            this.getModel().getDataEntity().set("comweight", (Object)comWeightValue.doubleValue());
            this.getView().updateView("techweight");
            this.getView().updateView("comweight");
        }
    }

    public void showOnlinePageByIsOnlineEval(Boolean isOnlineEval, Boolean needClear) {
        if (isOnlineEval.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bidevaltemplate", "scoremode", "scoretype", "bidopenevalitementry", BIDOPENEVALITEMFLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{"quotationscoresch"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"techweight", "comweight"});
            SplitContainer splitContainer = (SplitContainer)this.getControl(EVELITEMSPLITCONTAINER);
            splitContainer.changeFlexStatus(SplitDirection.left, true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"type"});
            this.setEntryVisibleByScoreMode(this.getModel().getDataEntity().getString("scoremode"));
            if (needClear.booleanValue()) {
                this.getModel().setValue("bidevaltemplate", null);
                this.setFlexStatusByScoreType(this.getModel().getDataEntity().getString("scoretype"));
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidevaltemplate", "scoremode", "scoretype", BIDOPENEVALITEMFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{"quotationscoresch"});
            this.getModel().setValue("bidevaltemplate", null);
            this.getModel().setValue("scoretype", (Object)ScoreType.SUM.getVal());
            this.getModel().setValue("scoremode", (Object)ScoreMode.STANDARD.getVal());
            this.getModel().setValue("quotationscoresch", null);
            this.getModel().deleteEntryData("bid_opentypeentry");
            String docType = this.getModel().getDataEntity().getString("doctype");
            if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"comweight"});
                this.getModel().setValue("comweight", (Object)new BigDecimal("1"));
            } else if (BidOpenTypeEnum.TECHNICAL.getValue().equals(docType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"techweight"});
                this.getModel().setValue("techweight", (Object)new BigDecimal("1"));
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"techweight", "comweight"});
            }
        }
        this.getView().updateView("bid_openevalentry");
    }

    public void showIsOnlineEvalByBidModel(DynamicObject dataEntity) {
        DynamicObject bidModel = dataEntity.getDynamicObject("bidmode");
        Boolean bidModelHasEvaluation = Boolean.FALSE;
        if (bidModel != null) {
            bidModelHasEvaluation = bidModel.getBoolean("bidevaluation");
        }
        if (bidModelHasEvaluation.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isonlineeval"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isonlineeval"});
            this.getModel().setValue("isonlineeval", (Object)Boolean.FALSE);
        }
    }

    public void showTechnicalCommercialByDocType(String docType, boolean isAfterBind) {
        if (docType == null) {
            return;
        }
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(docType)) {
            String evaluatedMethod = this.getModel().getDataEntity().getString("evaluatedmethod");
            EntryGrid aptitudeEntryGrid = (EntryGrid)this.getControl("bid_openevalentry");
            aptitudeEntryGrid.setColumnProperty("type", "l", (Object)55);
            EntryGrid proficientEntryGrid = (EntryGrid)this.getControl("bid_proficiententry");
            proficientEntryGrid.setColumnProperty("proficient_technical", "l", (Object)55);
            proficientEntryGrid.setColumnProperty("proficient_commercial", "l", (Object)55);
            this.getView().setVisible(Boolean.FALSE, new String[]{"proficient_commercial"});
            if (!BidEvalMethodEnum.DX.getCode().equals(evaluatedMethod)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"comweight"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"techweight"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"comweight", "techweight"});
            }
            this.getModel().setValue("techweight", (Object)new BigDecimal("1"));
            if (!isAfterBind) {
                this.getModel().setValue("commercialdocenddate", null);
            }
        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
            String evaluatedMethod = this.getModel().getDataEntity().getString("evaluatedmethod");
            EntryGrid aptitudeEntryGrid = (EntryGrid)this.getControl("bid_openevalentry");
            aptitudeEntryGrid.setColumnProperty("type", "l", (Object)55);
            EntryGrid proficientEntryGrid = (EntryGrid)this.getControl("bid_proficiententry");
            proficientEntryGrid.setColumnProperty("proficient_technical", "l", (Object)55);
            proficientEntryGrid.setColumnProperty("proficient_commercial", "l", (Object)55);
            this.getView().setVisible(Boolean.FALSE, new String[]{"proficient_technical"});
            if (!BidEvalMethodEnum.DX.getCode().equals(evaluatedMethod)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"comweight"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"techweight"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"comweight", "techweight"});
            }
            this.getModel().setValue("comweight", (Object)new BigDecimal("1"));
            if (!isAfterBind) {
                this.getModel().setValue("technicaldocenddate", null);
            }
        } else if (BidOpenTypeEnum.MULTI.getValue().equals(docType)) {
            String billStatus = this.getModel().getDataEntity().getString("billstatus");
            String evaluatedMethod = this.getModel().getDataEntity().getString("evaluatedmethod");
            if (BillStatusEnum.SAVE.getVal().equals(billStatus)) {
                EntryGrid aptitudeEntryGrid = (EntryGrid)this.getControl("bid_openevalentry");
                aptitudeEntryGrid.setColumnProperty("type", "l", null);
                EntryGrid proficientEntryGrid = (EntryGrid)this.getControl("bid_proficiententry");
                proficientEntryGrid.setColumnProperty("proficient_technical", "l", null);
                proficientEntryGrid.setColumnProperty("proficient_commercial", "l", null);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"proficient_technical", "proficient_commercial"});
            if (!BidEvalMethodEnum.DX.getCode().equals(evaluatedMethod)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"comweight"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"techweight"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"comweight", "techweight"});
            }
            if (!isAfterBind) {
                this.getModel().setValue("comweight", (Object)comWeightValue);
                this.getModel().setValue("techweight", (Object)techWeightValue);
            }
        }
    }

    protected String getDefaultEvaluateDecideWay() {
        String appId = this.getModel().getDataEntityType().getAppId();
        if ("bid".equals(appId)) {
            return "493255064807351296";
        }
        return "500440646276878336";
    }
}

