/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.bidcenter.IBidCenterService;
import kd.scm.bid.business.bidcenter.impl.BidCenterServiceImpl;
import kd.scm.bid.business.bill.IBidProjectProcessService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectProcessServiceImpl;
import kd.scm.bid.business.util.BidUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.BidOpenSupplierDetailConstant;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.ProjectProcess;
import kd.scm.bid.common.enums.RespBusiness;
import kd.scm.bid.common.util.CommonUtil;

public class BidProjectProcessUI
extends AbstractFormPlugin {
    protected final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected static final String KEY_ZBLX = "zblx";
    protected static final String KEY_GFRW = "gfrw";
    protected static final String KEY_BSBZ = "bsbz";
    protected static final String KEY_BDBZ = "bdbz";
    protected static final String KEY_FB = "fb";
    protected static final String KEY_ZBJD = "zbjd";
    protected static final String KEY_DY = "dy";
    protected static final String KEY_KB = "kb";
    protected static final String KEY_PB = "pb";
    protected static final String KEY_DB = "db";
    protected static final String KEY_SWTP = "swtp";
    protected static final String KEY_LEFTLINE = "leftphap";
    protected static final String KEY_RIGHTLINE = "rightphap";
    protected static final String KEY_IMAGE = "image";
    protected static final String KEY_STATUS = "status";
    protected static final String KEY_PLANTIME = "plantime";
    protected static final String KEY_REALTIME = "realtime";
    protected static final String KEY_HINT = "hint";
    protected static final String KEY_ZBRW = "zbrw";
    protected static final String KEY_BSXD = "bsxd";
    protected static final String KEY_ZCFB = "zcfb";
    protected IBidProjectProcessService processService = new BidProjectProcessServiceImpl();
    protected IBidCenterService bidCenterService = new BidCenterServiceImpl();
    protected static final String STATUS = "billStatus";
    protected static final String PT = "planTime";
    protected static final String RT = "realTime";
    protected static final String MT = "modifytime";
    protected static final String JD = "jdTime";
    protected static final String BZ = "bzTime";
    protected static final String SP = "spTime";
    protected static final String COLOR_NORMAL = "#72D438";
    protected static final String COLOR_LATER = "#FE6378";
    protected static final String COLOR_BEFORE = "#C3CCD3";
    protected static final String CLASS_DISBEGIN = "kdfont kdfont-weikaishi";
    protected static final String CLASS_RUNNING = "kdfont kdfont-jinhangzhong";
    protected static final String CLASS_FINISH = "kdfont kdfont-yiwancheng";
    protected static final String IMAGE_PATH = "icons/pc/state/";
    protected static final String NOTDELAY_NOTSTART = "notdelay_notstart.png";
    protected static final String NOTDELAY_PROGRESSED = "notdelay_progressed.png";
    protected static final String NOTDELAY_FINISH = "success_28_28.png";
    protected static final String DELAY_NOTSTART = "delay_notstart.png";
    protected static final String DELAY_PROGRESSED = "delay_progressed.png";
    protected static final String DELAY_FINISH = "delay_finish.png";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object projectId = this.getView().getFormShowParameter().getCustomParam("bidProjectId");
        if (projectId != null) {
            Map processData = this.processService.getProjectProcessData(projectId.toString());
            this.setProcessView(processData);
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("top", "26");
        this.getView().updateControlMetadata("flexpanelap2", data);
    }

    protected void setProcessView(Map<String, Map<String, Object>> processData) {
        String[] keys;
        for (String key : keys = BidOpenSupplierDetailConstant.bidProjectProcessKeys()) {
            if (processData.containsKey(key)) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{"panel4" + key});
        }
        processData.entrySet().stream().forEach(entry -> {
            String processName = (String)entry.getKey();
            Map sinProData = (Map)entry.getValue();
            Date pt = null;
            Date rt = null;
            Date mt = null;
            String bz = null;
            String jd = null;
            String sp = null;
            ProjectProcess status = null;
            if (sinProData != null) {
                pt = (Date)sinProData.get(PT);
                rt = (Date)sinProData.get(RT);
                mt = (Date)sinProData.get(MT);
                bz = (String)sinProData.get(BZ);
                jd = (String)sinProData.get(JD);
                sp = (String)sinProData.get(SP);
                String billStatus = (String)sinProData.get(STATUS);
                status = this.getProcessStatus(processName, billStatus, pt, rt, mt);
                this.renderView(processName, pt, rt, jd, bz, sp, status);
            }
        });
    }

    protected void renderView(String processName, Date pt, Date rt, String jd, String bz, String sp, ProjectProcess status) {
        Image image = (Image)this.getView().getControl("image4" + processName);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat format4Time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Label label4PT = (Label)this.getView().getControl("plantime4" + processName);
        Label label4RT = (Label)this.getView().getControl("realtime4" + processName);
        Label label4JD = (Label)this.getView().getControl("jdTime4" + processName);
        Label label4BZ = (Label)this.getView().getControl("bzTime4" + processName);
        Label label4SP = (Label)this.getView().getControl("spTime4" + processName);
        Label label4Status = (Label)this.getView().getControl("status4" + processName);
        boolean wksFlag = false;
        if (status != null) {
            boolean bl = wksFlag = ProjectProcess.BEFORE_DISBEGIN == status || ProjectProcess.NORMAL_DISBEGIN == status || ProjectProcess.LATER_DISBEGIN == status;
            if (wksFlag) {
                label4Status.setText(ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"BidProjectProcessUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else if (ProjectProcess.BEFORE_RUNNING == status || ProjectProcess.NORMAL_RUNNING == status || ProjectProcess.LATER_RUNNING == status) {
                label4Status.setText(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"BidProjectProcessUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else if (ProjectProcess.BEFORE_FINISH == status || ProjectProcess.NORMAL_FINISH == status || ProjectProcess.LATER_FINISH == status) {
                label4Status.setText(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"BidProjectProcessUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
        if (KEY_KB.equals(processName)) {
            if (pt != null) {
                label4PT.setText(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\uff1a%1$s", (String)"BidProjectProcessUI_127", (String)"scm-bid-formplugin", (Object[])new Object[0]), format4Time.format(pt)));
            }
            if (rt != null) {
                label4RT.setText(String.format(ResManager.loadKDString((String)"\u5b9e\u9645\u65f6\u95f4\uff1a%1$s", (String)"BidProjectProcessUI_128", (String)"scm-bid-formplugin", (Object[])new Object[0]), format4Time.format(rt)));
            }
        } else {
            if (pt != null) {
                label4PT.setText(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u65e5\u671f\uff1a%1$s", (String)"BidProjectProcessUI_129", (String)"scm-bid-formplugin", (Object[])new Object[0]), format.format(pt)));
            }
            if (rt != null) {
                label4RT.setText(String.format(ResManager.loadKDString((String)"\u5b9e\u9645\u65e5\u671f\uff1a%1$s", (String)"BidProjectProcessUI_130", (String)"scm-bid-formplugin", (Object[])new Object[0]), format.format(rt)));
            }
        }
        if (status != null && !wksFlag) {
            label4JD.setText(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u65f6\u957f\uff1a%1$s", (String)"BidProjectProcessUI_131", (String)"scm-bid-formplugin", (Object[])new Object[0]), jd));
            label4BZ.setText(String.format(ResManager.loadKDString((String)"\u7f16\u5236\u65f6\u957f\uff1a%1$s", (String)"BidProjectProcessUI_132", (String)"scm-bid-formplugin", (Object[])new Object[0]), bz));
            label4SP.setText(String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u65f6\u957f\uff1a%1$s", (String)"BidProjectProcessUI_133", (String)"scm-bid-formplugin", (Object[])new Object[0]), sp));
        }
        if (ProjectProcess.BEFORE_DISBEGIN == status || ProjectProcess.NORMAL_DISBEGIN == status) {
            image.setUrl("icons/pc/state/notdelay_notstart.png");
        } else if (ProjectProcess.BEFORE_RUNNING == status || ProjectProcess.NORMAL_RUNNING == status) {
            image.setUrl("icons/pc/state/notdelay_progressed.png");
        } else if (ProjectProcess.BEFORE_FINISH == status || ProjectProcess.NORMAL_FINISH == status) {
            image.setUrl("icons/pc/state/success_28_28.png");
        } else if (ProjectProcess.LATER_DISBEGIN == status) {
            image.setUrl("icons/pc/state/delay_notstart.png");
        } else if (ProjectProcess.LATER_RUNNING == status) {
            image.setUrl("icons/pc/state/delay_progressed.png");
        } else {
            image.setUrl("icons/pc/state/delay_finish.png");
        }
        this.metroMapRemouid(processName, label4Status, label4RT, image);
    }

    protected void metroMapRemouid(String processName, Label label4Status, Label label4RT, Image image) {
        Label hint = (Label)this.getView().getControl(KEY_HINT);
        Object showFormType = null;
        Object nowId = null;
        try {
            showFormType = this.getView().getFormShowParameter().getCustomParam("showFormType");
            nowId = this.getView().getFormShowParameter().getCustomParam("nowId");
        }
        catch (Exception e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
        }
        if (showFormType == null || nowId == null) {
            return;
        }
        String appID = BidUtils.getAppID((String)this.getModel().getDataEntityType().getName());
        String entryNameZBRW = null;
        String entryNameBSXZ = null;
        String entryNameFB = null;
        if (appID.equals("bid")) {
            entryNameZBRW = "bid_supplierinvitation";
            entryNameBSXZ = "bid_biddocument_edit";
            entryNameFB = "bid_bidpublish";
        } else {
            entryNameZBRW = "rebm_supplierinvitation";
            entryNameBSXZ = "rebm_biddocument_edit";
            entryNameFB = "rebm_bidpublish";
        }
        boolean isNewFlowZBRW = false;
        boolean isNewFlowBSXD = false;
        boolean isNewFlowFB = false;
        switch ((String)showFormType) {
            case "gfrw": {
                isNewFlowZBRW = this.getIsNewFlow(nowId, showFormType, entryNameZBRW);
                break;
            }
            case "bsbz": {
                isNewFlowBSXD = this.getIsNewFlow(nowId, showFormType, entryNameBSXZ);
                break;
            }
            case "fb": {
                isNewFlowFB = this.getIsNewFlow(nowId, showFormType, entryNameFB);
            }
        }
        if (isNewFlowZBRW && processName.equals(KEY_GFRW) && showFormType.equals(KEY_GFRW)) {
            hint.setText(ResManager.loadKDString((String)"\u589e\u8865\u5165\u56f4\u4e2d\uff0c\u5165\u56f4\u5355\u5ba1\u6838\u540e\uff0c\u540e\u7eed\u4e1a\u52a1\u5c06\u91cd\u65b0\u5f00\u59cb\u3002", (String)"BidProjectProcessUI_135", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            label4Status.setText(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"BidProjectProcessUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            image.setUrl("icons/pc/state/notdelay_progressed.png");
            label4RT.setText(ResManager.loadKDString((String)"\u5b9e\u9645\u65f6\u95f4\uff1a", (String)"BidProjectProcessUI_134", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
        if (isNewFlowBSXD && processName.equals(KEY_BSBZ) && showFormType.equals(KEY_BSBZ)) {
            hint.setText(ResManager.loadKDString((String)"\u6807\u4e66\u4fee\u8ba2\u4e2d", (String)"BidProjectProcessUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            image.setUrl("icons/pc/state/notdelay_progressed.png");
            label4Status.setText(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"BidProjectProcessUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            label4RT.setText(ResManager.loadKDString((String)"\u5b9e\u9645\u65f6\u95f4\uff1a", (String)"BidProjectProcessUI_134", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
        if (isNewFlowFB && processName.equals(KEY_FB) && showFormType.equals(KEY_FB)) {
            hint.setText(ResManager.loadKDString((String)"\u518d\u6b21\u53d1\u6807\u4e2d\uff0c\u53d1\u6807\u5355\u5ba1\u6838\u540e\uff0c\u540e\u7eed\u4e1a\u52a1\u5c06\u91cd\u65b0\u5f00\u59cb\u3002", (String)"BidProjectProcessUI_136", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            image.setUrl("icons/pc/state/notdelay_progressed.png");
            label4Status.setText(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"BidProjectProcessUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            label4RT.setText(ResManager.loadKDString((String)"\u5b9e\u9645\u65f6\u95f4\uff1a", (String)"BidProjectProcessUI_134", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    protected boolean getIsNewFlow(Object nowId, Object showFormType, String entryName) {
        DynamicObject[] publishListData;
        boolean isNewFlow = true;
        DynamicObject Obj = BusinessDataServiceHelper.loadSingle((Object)nowId, (String)entryName);
        Object bidProjectId = this.getView().getFormShowParameter().getCustomParam("bidProjectId");
        DynamicObject[] objColl = BusinessDataServiceHelper.load((String)entryName, (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProjectId)});
        if (objColl.length == 1) {
            isNewFlow = false;
        }
        if (KEY_FB.equals(showFormType) && (publishListData = BusinessDataServiceHelper.load((String)entryName, (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProjectId), new QFilter("billstatus", "!=", (Object)"X")})) != null && publishListData.length == 1) {
            isNewFlow = false;
        }
        if (Obj.getString("billstatus").equals("C") || Obj.getString("billstatus").equals("J") || Obj.getString("billstatus").equals("X") || Obj.getString("billstatus").equals("P")) {
            isNewFlow = false;
        }
        return isNewFlow;
    }

    protected ProjectProcess getProcessStatus(String processName, String billStatus, Date pt, Date rt, Date mt) {
        ProjectProcess processStatus = null;
        Date curDate = new Date();
        if (billStatus == null || BillStatusEnum.DISBEGIN.getVal().equals(billStatus)) {
            if (pt != null) {
                if (this.compareDate(pt, curDate, processName) > 0) {
                    processStatus = ProjectProcess.BEFORE_DISBEGIN;
                } else if (this.compareDate(pt, curDate, processName) == 0) {
                    processStatus = ProjectProcess.NORMAL_DISBEGIN;
                } else if (this.compareDate(pt, curDate, processName) < 0) {
                    processStatus = ProjectProcess.LATER_DISBEGIN;
                }
            } else if (pt == null) {
                processStatus = ProjectProcess.NORMAL_DISBEGIN;
            }
        } else if (BillStatusEnum.SAVE.getVal().equals(billStatus) || BillStatusEnum.SUBMIT.getVal().equals(billStatus) || BillStatusEnum.AUDITING.getVal().equals(billStatus) || BillStatusEnum.ADJUSTING.getVal().equals(billStatus) || "Q".equals(billStatus) || KEY_KB.equals(processName) && "P".equals(billStatus) || "E".equals(billStatus) || (KEY_KB.equals(processName) || KEY_FB.equals(processName) || KEY_SWTP.equals(processName) || KEY_ZBJD.equals(processName)) && BillStatusEnum.AUDITED.getVal().equals(billStatus)) {
            if (pt != null) {
                if (this.compareDate(pt, curDate, processName) > 0) {
                    processStatus = ProjectProcess.BEFORE_RUNNING;
                } else if (this.compareDate(pt, curDate, processName) == 0) {
                    processStatus = ProjectProcess.NORMAL_RUNNING;
                } else if (this.compareDate(pt, curDate, processName) < 0) {
                    processStatus = ProjectProcess.LATER_RUNNING;
                }
            } else if (pt == null) {
                processStatus = ProjectProcess.NORMAL_RUNNING;
            }
        } else if (this.checkCurStatusFinished(processName, billStatus)) {
            if (pt != null && rt != null) {
                if (this.compareDate(pt, rt, processName) > 0) {
                    processStatus = ProjectProcess.BEFORE_FINISH;
                } else if (this.compareDate(pt, rt, processName) == 0) {
                    processStatus = ProjectProcess.NORMAL_FINISH;
                } else if (this.compareDate(pt, rt, processName) < 0) {
                    processStatus = ProjectProcess.LATER_FINISH;
                }
            } else if (pt == null) {
                processStatus = ProjectProcess.NORMAL_FINISH;
            }
        } else if (BillStatusEnum.INVALID.getVal().equals(billStatus)) {
            if (pt != null) {
                if (mt == null) {
                    if (this.compareDate(pt, curDate, processName) > 0) {
                        processStatus = ProjectProcess.BEFORE_DISBEGIN;
                    } else if (this.compareDate(pt, curDate, processName) == 0) {
                        processStatus = ProjectProcess.NORMAL_DISBEGIN;
                    } else if (this.compareDate(pt, curDate, processName) < 0) {
                        processStatus = ProjectProcess.LATER_DISBEGIN;
                    }
                } else if (rt == null) {
                    if (this.compareDate(pt, curDate, processName) > 0) {
                        processStatus = ProjectProcess.BEFORE_RUNNING;
                    } else if (this.compareDate(pt, curDate, processName) == 0) {
                        processStatus = ProjectProcess.NORMAL_RUNNING;
                    } else if (this.compareDate(pt, curDate, processName) < 0) {
                        processStatus = ProjectProcess.LATER_RUNNING;
                    }
                } else if (this.compareDate(pt, rt, processName) > 0) {
                    processStatus = ProjectProcess.BEFORE_FINISH;
                } else if (this.compareDate(pt, rt, processName) == 0) {
                    processStatus = ProjectProcess.NORMAL_FINISH;
                } else if (this.compareDate(pt, rt, processName) < 0) {
                    processStatus = ProjectProcess.LATER_FINISH;
                }
            } else {
                processStatus = mt == null ? ProjectProcess.NORMAL_DISBEGIN : (rt == null ? ProjectProcess.NORMAL_RUNNING : ProjectProcess.NORMAL_FINISH);
            }
        }
        return processStatus;
    }

    protected boolean checkCurStatusFinished(String processName, String billStatus) {
        boolean finished = false;
        if (KEY_ZBLX.equals(processName) || KEY_GFRW.equals(processName) || KEY_BSBZ.equals(processName) || KEY_PB.equals(processName) || KEY_BDBZ.equals(processName)) {
            if (BillStatusEnum.AUDITED.getVal().equals(billStatus)) {
                finished = true;
            }
        } else if (KEY_FB.equals(processName)) {
            if (BillStatusEnum.PUBLISHED.getVal().equals(billStatus)) {
                finished = true;
            }
        } else if (KEY_KB.equals(processName)) {
            if (BillStatusEnum.OPEN.getVal().equals(billStatus)) {
                finished = true;
            }
        } else if (KEY_DY.equals(processName)) {
            if ("F".equals(billStatus)) {
                finished = true;
            }
        } else if (KEY_DB.equals(processName)) {
            if (BillStatusEnum.AUDITED.getVal().equals(billStatus) || BillStatusEnum.PARTSIGNED.getVal().equals(billStatus) || BillStatusEnum.SIGNED.getVal().equals(billStatus)) {
                finished = true;
            }
        } else if (KEY_SWTP.equals(processName)) {
            if ("F".equals(billStatus)) {
                finished = true;
            }
        } else if (KEY_ZBJD.equals(processName) && "F".equals(billStatus)) {
            finished = true;
        }
        return finished;
    }

    protected int compareDate(Date d1, Date d2, String processName) {
        String ds2;
        if (KEY_KB.equals(processName)) {
            return d1.compareTo(d2);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String ds1 = format.format(d1);
        if (ds1.equals(ds2 = format.format(d2))) {
            return 0;
        }
        return d1.compareTo(d2);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button1 = (Button)this.getView().getControl("image4zblx");
        button1.addClickListener((ClickListener)this);
        Button button2 = (Button)this.getView().getControl("image4gfrw");
        button2.addClickListener((ClickListener)this);
        Button button3 = (Button)this.getView().getControl("image4bsbz");
        button3.addClickListener((ClickListener)this);
        Button button4 = (Button)this.getView().getControl("image4fb");
        button4.addClickListener((ClickListener)this);
        Button button5 = (Button)this.getView().getControl("image4dy");
        button5.addClickListener((ClickListener)this);
        Button button6 = (Button)this.getView().getControl("image4kb");
        button6.addClickListener((ClickListener)this);
        Button button7 = (Button)this.getView().getControl("image4pb");
        button7.addClickListener((ClickListener)this);
        Button button8 = (Button)this.getView().getControl("image4swtp");
        button8.addClickListener((ClickListener)this);
        Button button9 = (Button)this.getView().getControl("image4db");
        button9.addClickListener((ClickListener)this);
        Button button10 = (Button)this.getView().getControl("image4bdbz");
        button10.addClickListener((ClickListener)this);
        Button button11 = (Button)this.getView().getControl("image4zbjd");
        button11.addClickListener((ClickListener)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void click(EventObject evt) {
        Object memberTeList;
        DynamicObject[] bidOpenAll;
        String userId;
        Iterator memberLeaderEntityColl;
        Object memberList;
        DynamicObjectCollection memberColl;
        Object hasAllPermission;
        Object memberLeaderEntityColl2;
        Object member;
        ArrayList<String> memberList2;
        DynamicObjectCollection memberColl2;
        String appId;
        long org;
        DynamicObject entrustmentorgunit;
        DynamicObject bidProject;
        Long projectId;
        Lang lang;
        Control source;
        block142: {
            block143: {
                DynamicObject[] anwser;
                block144: {
                    int i;
                    int i2;
                    Object hasAllPermission2;
                    int i3;
                    super.click(evt);
                    source = (Control)evt.getSource();
                    lang = RequestContext.get().getLang();
                    IFormView parentView = this.getView().getParentView();
                    projectId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("bidProjectId").toString());
                    bidProject = BusinessDataServiceHelper.loadSingle((String)"bid_project", (String)"id,org,entrustmentorgunit,memberentity,memberentity.respbusiness,memberentity.user,memberentity.isdirector,billstatus,bidproject,supplierinvitation,biddocument,bidpublish,bidopen,bidanswerquestion,bidevaluation,bidbustalk,biddecision,bidopentype,memberleaderentity,memberleaderentity.userleader,memberleaderentity.respbusinessleader", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
                    if (bidProject == null) return;
                    entrustmentorgunit = bidProject.getDynamicObject("entrustmentorgunit");
                    DynamicObject orgData = bidProject.getDynamicObject("org");
                    org = (Long)orgData.getPkValue();
                    appId = this.getView().getFormShowParameter().getServiceAppId();
                    if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"image4zblx") && bidProject != null) {
                        DynamicObjectCollection memberColl3 = bidProject.getDynamicObjectCollection("memberentity");
                        ArrayList<String> memberList3 = new ArrayList<String>();
                        for (Object member2 : memberColl3) {
                            String[] values = member2.getString("respbusiness").split(",");
                            if (values != null && values.length > 0) {
                                for (int i4 = 0; i4 < values.length; ++i4) {
                                    if (!"01".equals(values[i4])) continue;
                                    memberList3.add(member2.getDynamicObject("user").getPkValue().toString());
                                }
                            }
                            if (!member2.getBoolean("isdirector")) continue;
                            memberList3.add(member2.getDynamicObject("user").getPkValue().toString());
                        }
                        DynamicObjectCollection memberLeaderEntityColl3 = bidProject.getDynamicObjectCollection("memberleaderentity");
                        for (DynamicObject memberLeaderEntity : memberLeaderEntityColl3) {
                            String[] values = memberLeaderEntity.getString("respbusinessleader").split(",");
                            if (values == null || values.length <= 0) continue;
                            for (i3 = 0; i3 < values.length; ++i3) {
                                if (!"01".equals(values[i3])) continue;
                                memberList3.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                            }
                        }
                        hasAllPermission2 = this.hasAllPermission(org, appId, memberList3, "bid_project", entrustmentorgunit);
                        if (hasAllPermission2 != null) {
                            this.getView().showTipNotification((String)hasAllPermission2);
                            return;
                        }
                        this.showBillByEditPermission(org, appId, bidProject, "bidproject");
                    }
                    if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"image4gfrw")) {
                        DynamicObject supinvi = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
                        if (supinvi != null) {
                            memberColl2 = bidProject.getDynamicObjectCollection("memberentity");
                            memberList2 = new ArrayList<String>();
                            hasAllPermission2 = memberColl2.iterator();
                        } else {
                            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                                this.getView().showTipNotification(" The current link has not occurred supplier shortlisted business, not allowed to view.");
                                return;
                            }
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u4f9b\u65b9\u5165\u56f4\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        while (hasAllPermission2.hasNext()) {
                            member = (DynamicObject)hasAllPermission2.next();
                            String[] values = member.getString("respbusiness").split(",");
                            if (values != null && values.length > 0) {
                                for (i3 = 0; i3 < values.length; ++i3) {
                                    if (!"02".equals(values[i3])) continue;
                                    memberList2.add(member.getDynamicObject("user").getPkValue().toString());
                                }
                            }
                            if (!member.getBoolean("isdirector")) continue;
                            memberList2.add(member.getDynamicObject("user").getPkValue().toString());
                        }
                        memberLeaderEntityColl2 = bidProject.getDynamicObjectCollection("memberleaderentity");
                        member = memberLeaderEntityColl2.iterator();
                        while (member.hasNext()) {
                            DynamicObject memberLeaderEntity = (DynamicObject)member.next();
                            String[] values = memberLeaderEntity.getString("respbusinessleader").split(",");
                            if (values == null || values.length <= 0) continue;
                            for (i2 = 0; i2 < values.length; ++i2) {
                                if (!"02".equals(values[i2])) continue;
                                memberList2.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                            }
                        }
                        hasAllPermission = this.hasAllPermission(org, appId, memberList2, "bid_supplierinvitation", entrustmentorgunit);
                        if (hasAllPermission != null) {
                            this.getView().showTipNotification((String)hasAllPermission);
                            return;
                        }
                        this.showBillByEditPermission(org, appId, bidProject, "supplierinvitation");
                    }
                    if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"image4bsbz")) {
                        HashSet<String> docuStatus = new HashSet<String>();
                        docuStatus.add("J");
                        docuStatus.add("X");
                        DynamicObject documnet = BusinessDataServiceHelper.loadSingle((String)"bid_biddocument_edit", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
                        if (documnet != null) {
                            memberColl = bidProject.getDynamicObjectCollection("memberentity");
                            memberList = new ArrayList();
                            hasAllPermission = memberColl.iterator();
                        } else {
                            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                                this.getView().showTipNotification(" The current link has not occurred the tender preparation business, is not allowed to view.");
                                return;
                            }
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u6807\u4e66\u7f16\u5236\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        while (hasAllPermission.hasNext()) {
                            DynamicObject member3 = (DynamicObject)hasAllPermission.next();
                            String[] values = member3.getString("respbusiness").split(",");
                            if (values != null && values.length > 0) {
                                for (i2 = 0; i2 < values.length; ++i2) {
                                    if (!"03".equals(values[i2]) && !"04".equals(values[i2]) && !"09".equals(values[i2])) continue;
                                    memberList.add(member3.getDynamicObject("user").getPkValue().toString());
                                }
                            }
                            if (!member3.getBoolean("isdirector")) continue;
                            memberList.add(member3.getDynamicObject("user").getPkValue().toString());
                        }
                        memberLeaderEntityColl = bidProject.getDynamicObjectCollection("memberleaderentity");
                        Iterator member3 = memberLeaderEntityColl.iterator();
                        while (member3.hasNext()) {
                            DynamicObject memberLeaderEntity = (DynamicObject)member3.next();
                            String[] values = memberLeaderEntity.getString("respbusinessleader").split(",");
                            if (values == null || values.length <= 0) continue;
                            for (i = 0; i < values.length; ++i) {
                                if (!"03".equals(values[i]) && !"04".equals(values[i]) && !"09".equals(values[i])) continue;
                                memberList.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                            }
                        }
                        String hasAllPermission3 = this.hasAllPermission(org, appId, (List<String>)memberList, "bid_biddocument_edit", entrustmentorgunit);
                        if (hasAllPermission3 != null) {
                            this.getView().showTipNotification(hasAllPermission3);
                            return;
                        }
                        this.showBillByEditPermission(org, appId, bidProject, "biddocument");
                    }
                    if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"image4fb")) {
                        HashSet<String> publishStatus = new HashSet<String>();
                        publishStatus.add("J");
                        publishStatus.add("X");
                        DynamicObject publish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
                        if (publish != null) {
                            memberColl = bidProject.getDynamicObjectCollection("memberentity");
                            memberList = new ArrayList();
                            memberLeaderEntityColl = memberColl.iterator();
                        } else {
                            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                                this.getView().showTipNotification(" The current link has not yet happened the bid issuing business, is not allowed to view.");
                                return;
                            }
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u53d1\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        while (memberLeaderEntityColl.hasNext()) {
                            DynamicObject member4 = (DynamicObject)memberLeaderEntityColl.next();
                            String[] values = member4.getString("respbusiness").split(",");
                            if (values != null && values.length > 0) {
                                for (int i5 = 0; i5 < values.length; ++i5) {
                                    if (!"05".equals(values[i5])) continue;
                                    memberList.add(member4.getDynamicObject("user").getPkValue().toString());
                                }
                            }
                            if (!member4.getBoolean("isdirector")) continue;
                            memberList.add(member4.getDynamicObject("user").getPkValue().toString());
                        }
                        memberLeaderEntityColl = bidProject.getDynamicObjectCollection("memberleaderentity");
                        Iterator member4 = memberLeaderEntityColl.iterator();
                        while (member4.hasNext()) {
                            DynamicObject memberLeaderEntity = (DynamicObject)member4.next();
                            String[] values = memberLeaderEntity.getString("respbusinessleader").split(",");
                            if (values == null || values.length <= 0) continue;
                            for (i = 0; i < values.length; ++i) {
                                if (!"05".equals(values[i])) continue;
                                memberList.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                            }
                        }
                        String hasAllPermission4 = this.hasAllPermission(org, appId, (List<String>)memberList, "bid_bidpublish", entrustmentorgunit);
                        if (hasAllPermission4 != null) {
                            this.getView().showTipNotification(hasAllPermission4);
                            return;
                        }
                        this.showBillByEditPermission(org, appId, bidProject, "bidpublish");
                    }
                    if (!StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"image4dy")) break block142;
                    anwser = BusinessDataServiceHelper.load((String)"bid_answerquestion_reco", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
                    DynamicObject bidAnswer = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"answerquestion", ((Object)((Object)this)).getClass()), (String)"id,billstatus,bidproject", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
                    memberColl = bidProject.getDynamicObjectCollection("memberentity");
                    memberList = new ArrayList();
                    for (DynamicObject member5 : memberColl) {
                        String[] values = member5.getString("respbusiness").split(",");
                        if (values != null && values.length > 0) {
                            for (int i6 = 0; i6 < values.length; ++i6) {
                                if (!"10".equals(values[i6])) continue;
                                memberList.add(member5.getDynamicObject("user").getPkValue().toString());
                            }
                        }
                        if (!member5.getBoolean("isdirector")) continue;
                        memberList.add(member5.getDynamicObject("user").getPkValue().toString());
                    }
                    memberLeaderEntityColl = bidProject.getDynamicObjectCollection("memberleaderentity");
                    Iterator member5 = memberLeaderEntityColl.iterator();
                    while (member5.hasNext()) {
                        DynamicObject memberLeaderEntity = (DynamicObject)member5.next();
                        String[] values = memberLeaderEntity.getString("respbusinessleader").split(",");
                        if (values == null || values.length <= 0) continue;
                        for (i = 0; i < values.length; ++i) {
                            if (!"10".equals(values[i])) continue;
                            memberList.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                        }
                    }
                    if (bidAnswer == null) break block143;
                    String hasAllPermission5 = this.hasAllPermission(org, appId, (List<String>)memberList, "bid_answerquestion_reco", entrustmentorgunit);
                    if (hasAllPermission5 != null) {
                        this.getView().showTipNotification(hasAllPermission5);
                        return;
                    }
                    String billstatus = bidAnswer.getString("billstatus");
                    if (!"Q".equals(billstatus)) break block144;
                    if (anwser != null && anwser.length > 0) {
                        this.showBillByEditPermission(org, appId, bidProject, "bidanswerquestion");
                        break block142;
                    } else {
                        boolean hasNewPermission = this.checkPermission("QXX0002", org, appId, "bid_answerquestion_reco");
                        if (hasNewPermission) {
                            HashMap<String, String> recoEditMap = new HashMap<String, String>();
                            recoEditMap.put("formId", FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass()));
                            FormShowParameter recoEditPara = FormShowParameter.createFormShowParameter(recoEditMap);
                            recoEditPara.setStatus(OperationStatus.ADDNEW);
                            recoEditPara.setCustomParam("bidproject", bidProject.getPkValue());
                            OpenStyle openStyle = recoEditPara.getOpenStyle();
                            openStyle.setShowType(ShowType.MainNewTabPage);
                            BidProjectProcessUI.processShowForm(this.getView(), recoEditPara);
                            this.getView().close();
                            break block142;
                        } else {
                            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                                this.getView().showTipNotification(" The current user does not have the added permission to answer questions, and is not allowed to add.");
                                return;
                            }
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7b54\u7591\u7684\u65b0\u589e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u3002", (String)"BidProjectProcessUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                }
                if (anwser != null && anwser.length > 0) {
                    this.showBillByEditPermission(org, appId, bidProject, "bidanswerquestion");
                    break block142;
                } else {
                    if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                        this.getView().showTipNotification(" There is no business data in the current link, so it cannot be viewed.");
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u4e0d\u5b58\u5728\u4e1a\u52a1\u6570\u636e\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"BidProjectProcessUI_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                this.getView().showTipNotification(" Answer question business has not occurred in the current link, so it is not allowed to view.");
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u7b54\u7591\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"image4kb")) {
            Iterator billstatus;
            userId = RequestContext.get().getUserId();
            bidOpenAll = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
            if (bidOpenAll != null && bidOpenAll.length > 0) {
                memberColl = bidProject.getDynamicObjectCollection("memberentity");
                memberList = new ArrayList();
                memberTeList = new ArrayList();
                ArrayList memberBuList = new ArrayList();
                billstatus = memberColl.iterator();
            } else {
                if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                    this.getView().showTipNotification(" Bid opening business has not occurred in the current link, so it is not allowed to view.");
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u5f00\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            while (billstatus.hasNext()) {
                DynamicObject member6 = (DynamicObject)billstatus.next();
                String[] values = member6.getString("respbusiness").split(",");
                if (values != null && values.length > 0) {
                    for (int i = 0; i < values.length; ++i) {
                        if ("06".equals(values[i])) {
                            memberList.add(member6.getDynamicObject("user").getPkValue().toString());
                        }
                        if ("11".equals(values[i])) {
                            memberList.add(member6.getDynamicObject("user").getPkValue().toString());
                        }
                        if (!"12".equals(values[i])) continue;
                        memberList.add(member6.getDynamicObject("user").getPkValue().toString());
                    }
                }
                if (!member6.getBoolean("isdirector")) continue;
                memberList.add(member6.getDynamicObject("user").getPkValue().toString());
            }
            DynamicObjectCollection memberLeaderEntityColl4 = bidProject.getDynamicObjectCollection("memberleaderentity");
            for (DynamicObject memberLeaderEntity : memberLeaderEntityColl4) {
                String[] values = memberLeaderEntity.getString("respbusinessleader").split(",");
                if (values == null || values.length <= 0) continue;
                for (int i = 0; i < values.length; ++i) {
                    if ("06".equals(values[i])) {
                        memberList.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                    }
                    if ("11".equals(values[i])) {
                        memberList.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                    }
                    if (!"12".equals(values[i])) continue;
                    memberList.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                }
            }
            String hasAllPermission6 = this.hasAllPermission(org, appId, (List<String>)memberList, "bid_bidopen", entrustmentorgunit);
            if (hasAllPermission6 != null) {
                this.getView().showTipNotification(hasAllPermission6);
                return;
            }
            String bidopentype = bidProject.getString("bidopentype");
            DynamicObject permissionMember = this.bidCenterService.getPermissionMember((Object)userId, (Object)projectId, this.getRespBusinessNo("bid_bidopen"));
            if (permissionMember != null) {
                boolean isdirector;
                String respbusiness = permissionMember.getString("respbusiness");
                QFilter bidFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                bidFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()));
                boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
                if (!(isAdmin || (isdirector = permissionMember.getBoolean("isdirector")) || !StringUtils.isNotBlank((CharSequence)bidopentype) || BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype) || respbusiness.contains(RespBusiness.TechnicalOpen.getVal()) && respbusiness.contains(RespBusiness.BusinessOpen.getVal()))) {
                    DynamicObject bidOpenCheck;
                    if (respbusiness.contains(RespBusiness.TechnicalOpen.getVal())) {
                        if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidopentype)) {
                            bidFilter = bidFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                            bidOpenCheck = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"opentype,billstatus,bidproject.id,bidproject.bidopentype", (QFilter[])new QFilter[]{bidFilter});
                            if (bidOpenCheck != null && !StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)bidOpenCheck.getString("billstatus")) && !StringUtils.equals((CharSequence)BillStatusEnum.INVALID.getVal(), (CharSequence)bidOpenCheck.getString("billstatus"))) {
                                if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                                    this.getView().showTipNotification(" Commercial bids have not been opened yet, and technical bids are not allowed to be edited.");
                                    return;
                                }
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u52a1\u6807\u5f00\u6807\u5c1a\u672a\u5f00\u6807\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u6280\u672f\u6807\u3002", (String)"BidProjectProcessUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                    } else if (respbusiness.contains(RespBusiness.BusinessOpen.getVal()) && StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidopentype)) {
                        bidFilter = bidFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                        bidOpenCheck = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"opentype,billstatus,bidproject.id,bidproject.bidopentype", (QFilter[])new QFilter[]{bidFilter});
                        if (bidOpenCheck != null && !StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)bidOpenCheck.getString("billstatus")) && !StringUtils.equals((CharSequence)BillStatusEnum.INVALID.getVal(), (CharSequence)bidOpenCheck.getString("billstatus"))) {
                            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                                this.getView().showTipNotification(" The technical bid has not been opened yet, and commercial bid editing is not allowed.");
                                return;
                            }
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6280\u672f\u6807\u5f00\u6807\u5c1a\u672a\u5f00\u6807\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u5546\u52a1\u6807\u3002", (String)"BidProjectProcessUI_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                }
            }
            this.showBillByEditPermission(org, appId, bidProject, "bidopen");
        }
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"image4pb")) {
            userId = RequestContext.get().getUserId();
            bidOpenAll = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
            if (bidOpenAll != null && bidOpenAll.length > 0) {
                memberColl = bidProject.getDynamicObjectCollection("memberentity");
                memberList = new ArrayList();
                memberTeList = memberColl.iterator();
            } else {
                if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                    this.getView().showTipNotification("The current link has not yet occurred bid evaluation business, not allowed to view.");
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u8bc4\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_21", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            while (memberTeList.hasNext()) {
                DynamicObject member7 = (DynamicObject)memberTeList.next();
                String[] values = member7.getString("respbusiness").split(",");
                if (values != null && values.length > 0) {
                    for (int i = 0; i < values.length; ++i) {
                        if ("07".equals(values[i])) {
                            memberList.add(member7.getDynamicObject("user").getPkValue().toString());
                        }
                        if ("13".equals(values[i])) {
                            memberList.add(member7.getDynamicObject("user").getPkValue().toString());
                        }
                        if (!"14".equals(values[i])) continue;
                        memberList.add(member7.getDynamicObject("user").getPkValue().toString());
                    }
                }
                if (!member7.getBoolean("isdirector")) continue;
                memberList.add(member7.getDynamicObject("user").getPkValue().toString());
            }
            memberLeaderEntityColl = bidProject.getDynamicObjectCollection("memberleaderentity");
            Iterator member7 = memberLeaderEntityColl.iterator();
            while (member7.hasNext()) {
                DynamicObject memberLeaderEntity = (DynamicObject)member7.next();
                String[] values = memberLeaderEntity.getString("respbusinessleader").split(",");
                if (values == null || values.length <= 0) continue;
                for (int i = 0; i < values.length; ++i) {
                    if ("07".equals(values[i])) {
                        memberList.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                    }
                    if ("13".equals(values[i])) {
                        memberList.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                    }
                    if (!"14".equals(values[i])) continue;
                    memberList.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                }
            }
            String hasAllPermission7 = this.hasAllPermission(org, appId, (List<String>)memberList, "bid_bidevaluation", entrustmentorgunit);
            if (hasAllPermission7 != null) {
                this.getView().showTipNotification(hasAllPermission7);
                return;
            }
            String bidopentype = bidProject.getString("bidopentype");
            DynamicObject permissionMember = this.bidCenterService.getPermissionMember((Object)userId, (Object)projectId, this.getRespBusinessNo("bid_bidevaluation"));
            if (permissionMember != null) {
                boolean isdirector;
                String respbusiness = permissionMember.getString("respbusiness");
                boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
                if (!(isAdmin || (isdirector = permissionMember.getBoolean("isdirector")) || !StringUtils.isNotBlank((CharSequence)bidopentype) || BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype) || respbusiness.contains("13") && respbusiness.contains("14"))) {
                    DynamicObject commEvalData;
                    if (respbusiness.contains("13")) {
                        DynamicObject techEvalData;
                        if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidopentype) && (techEvalData = this.bidCenterService.getTechEvalDataByBidId((Object)projectId, null)) == null) {
                            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                                this.getView().showTipNotification(" The technical bid evaluation business has not occurred in the current bidding item, so it is not allowed to view.");
                                return;
                            }
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u6280\u672f\u6807\u8bc4\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            return;
                        }
                    } else if (respbusiness.contains(RespBusiness.BusinessEval.getVal()) && StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidopentype) && (commEvalData = this.bidCenterService.getCommEvalDataByBidId((Object)projectId, null)) == null) {
                        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                            this.getView().showTipNotification(" The commercial bid evaluation business has not occurred in the current bidding item, so it is not allowed to check.");
                            return;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u5546\u52a1\u6807\u8bc4\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
            this.showBillByEditPermission(org, appId, bidProject, "bidevaluation");
        }
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"image4swtp")) {
            DynamicObject[] bustTalk = BusinessDataServiceHelper.load((String)"bid_bustalk", (String)"id,billstatus,bidsection,supplierentry", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
            if (bustTalk != null && bustTalk.length > 0) {
                memberColl2 = bidProject.getDynamicObjectCollection("memberentity");
                memberList2 = new ArrayList();
                memberList = memberColl2.iterator();
            } else {
                if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                    this.getView().showTipNotification("The current link has not occurred business negotiation business, not allowed to view.");
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u5546\u52a1\u8c08\u5224\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            while (memberList.hasNext()) {
                member = (DynamicObject)memberList.next();
                String[] values = member.getString("respbusiness").split(",");
                if (values != null && values.length > 0) {
                    for (int i = 0; i < values.length; ++i) {
                        if (!"15".equals(values[i])) continue;
                        memberList2.add(member.getDynamicObject("user").getPkValue().toString());
                    }
                }
                if (!member.getBoolean("isdirector")) continue;
                memberList2.add(member.getDynamicObject("user").getPkValue().toString());
            }
            memberLeaderEntityColl2 = bidProject.getDynamicObjectCollection("memberleaderentity");
            member = memberLeaderEntityColl2.iterator();
            while (member.hasNext()) {
                DynamicObject memberLeaderEntity = (DynamicObject)member.next();
                String[] values = memberLeaderEntity.getString("respbusinessleader").split(",");
                if (values == null || values.length <= 0) continue;
                for (int i = 0; i < values.length; ++i) {
                    if (!"15".equals(values[i])) continue;
                    memberList2.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                }
            }
            hasAllPermission = this.hasAllPermission(org, appId, memberList2, "bid_bustalk", entrustmentorgunit);
            if (hasAllPermission != null) {
                this.getView().showTipNotification((String)hasAllPermission);
                return;
            }
            if (bustTalk.length == 1) {
                Boolean haveData = Boolean.FALSE;
                DynamicObject bustalkOne = bustTalk[0];
                String billstatus = bustalkOne.getString("billstatus");
                if ("F".equals(billstatus)) {
                    DynamicObjectCollection bidsections = bustalkOne.getDynamicObjectCollection("bidsection");
                    for (DynamicObject bidsection : bidsections) {
                        DynamicObjectCollection supplierentry = bidsection.getDynamicObjectCollection("supplierentry");
                        if (supplierentry.size() <= 0) continue;
                        haveData = Boolean.TRUE;
                    }
                    if (!haveData.booleanValue()) {
                        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                            this.getView().showTipNotification("There is no business data in the current link, so it cannot be viewed.");
                            return;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u4e0d\u5b58\u5728\u4e1a\u52a1\u6570\u636e\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"BidProjectProcessUI_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
            this.showBillByEditPermission(org, appId, bidProject, "bidbustalk");
        }
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"image4db")) {
            DynamicObject decision = BusinessDataServiceHelper.loadSingle((String)"bid_decision", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
            if (decision != null) {
                memberColl2 = bidProject.getDynamicObjectCollection("memberentity");
                memberList2 = new ArrayList();
                memberLeaderEntityColl2 = memberColl2.iterator();
            } else {
                if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                    this.getView().showTipNotification("The current link has not occurred the bid determing business, is not allowed to view.");
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u5b9a\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_23", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            while (memberLeaderEntityColl2.hasNext()) {
                member = (DynamicObject)memberLeaderEntityColl2.next();
                String[] values = member.getString("respbusiness").split(",");
                if (values != null && values.length > 0) {
                    for (int i = 0; i < values.length; ++i) {
                        if (!"08".equals(values[i])) continue;
                        memberList2.add(member.getDynamicObject("user").getPkValue().toString());
                    }
                }
                if (!member.getBoolean("isdirector")) continue;
                memberList2.add(member.getDynamicObject("user").getPkValue().toString());
            }
            memberLeaderEntityColl2 = bidProject.getDynamicObjectCollection("memberleaderentity");
            member = memberLeaderEntityColl2.iterator();
            while (member.hasNext()) {
                DynamicObject memberLeaderEntity = (DynamicObject)member.next();
                String[] values = memberLeaderEntity.getString("respbusinessleader").split(",");
                if (values == null || values.length <= 0) continue;
                for (int i = 0; i < values.length; ++i) {
                    if (!"08".equals(values[i])) continue;
                    memberList2.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                }
            }
            hasAllPermission = this.hasAllPermission(org, appId, memberList2, "bid_decision", entrustmentorgunit);
            if (hasAllPermission != null) {
                this.getView().showTipNotification((String)hasAllPermission);
                return;
            }
            this.showBillByEditPermission(org, appId, bidProject, "biddecision");
        }
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"image4bdbz")) {
            DynamicObject bid_bottom_make = BusinessDataServiceHelper.loadSingle((String)"bid_bottom_make", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
            if (bid_bottom_make != null) {
                memberColl2 = bidProject.getDynamicObjectCollection("memberentity");
                memberList2 = new ArrayList();
                memberLeaderEntityColl2 = memberColl2.iterator();
            } else {
                if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                    this.getView().showTipNotification("The current link has not occurred the bid determing business, is not allowed to view.");
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u6807\u5e95\u7f16\u5236\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_24", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            while (memberLeaderEntityColl2.hasNext()) {
                member = (DynamicObject)memberLeaderEntityColl2.next();
                String[] values = member.getString("respbusiness").split(",");
                if (values != null && values.length > 0) {
                    for (int i = 0; i < values.length; ++i) {
                        if (!"19".equals(values[i])) continue;
                        memberList2.add(member.getDynamicObject("user").getPkValue().toString());
                    }
                }
                if (!member.getBoolean("isdirector")) continue;
                memberList2.add(member.getDynamicObject("user").getPkValue().toString());
            }
            memberLeaderEntityColl2 = bidProject.getDynamicObjectCollection("memberleaderentity");
            member = memberLeaderEntityColl2.iterator();
            while (member.hasNext()) {
                DynamicObject memberLeaderEntity = (DynamicObject)member.next();
                String[] values = memberLeaderEntity.getString("respbusinessleader").split(",");
                if (values == null || values.length <= 0) continue;
                for (int i = 0; i < values.length; ++i) {
                    if (!"19".equals(values[i])) continue;
                    memberList2.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
                }
            }
            hasAllPermission = this.hasAllPermission(org, appId, memberList2, "bid_bottom_make", entrustmentorgunit);
            if (hasAllPermission != null) {
                this.getView().showTipNotification((String)hasAllPermission);
                return;
            }
            this.showBillByEditPermission(org, appId, bidProject, "bidbottommake");
        }
        if (!StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"image4zbjd")) return;
        DynamicObject bid_clarificaiton = BusinessDataServiceHelper.loadSingle((String)"bid_clarificaiton", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
        if (bid_clarificaiton != null) {
            memberColl2 = bidProject.getDynamicObjectCollection("memberentity");
            memberList2 = new ArrayList();
            memberLeaderEntityColl2 = memberColl2.iterator();
        } else {
            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                this.getView().showTipNotification("The current link has not occurred the bid determing business, is not allowed to view.");
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u62db\u6807\u4ea4\u5e95\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_25", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        while (memberLeaderEntityColl2.hasNext()) {
            member = (DynamicObject)memberLeaderEntityColl2.next();
            String[] values = member.getString("respbusiness").split(",");
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    if (!"18".equals(values[i])) continue;
                    memberList2.add(member.getDynamicObject("user").getPkValue().toString());
                }
            }
            if (!member.getBoolean("isdirector")) continue;
            memberList2.add(member.getDynamicObject("user").getPkValue().toString());
        }
        memberLeaderEntityColl2 = bidProject.getDynamicObjectCollection("memberleaderentity");
        member = memberLeaderEntityColl2.iterator();
        while (member.hasNext()) {
            DynamicObject memberLeaderEntity = (DynamicObject)member.next();
            String[] values = memberLeaderEntity.getString("respbusinessleader").split(",");
            if (values == null || values.length <= 0) continue;
            for (int i = 0; i < values.length; ++i) {
                if (!"18".equals(values[i])) continue;
                memberList2.add(memberLeaderEntity.getDynamicObject("userleader").getPkValue().toString());
            }
        }
        hasAllPermission = this.hasAllPermission(org, appId, memberList2, "bid_clarificaiton", entrustmentorgunit);
        if (hasAllPermission != null) {
            this.getView().showTipNotification((String)hasAllPermission);
            return;
        }
        this.showBillByEditPermission(org, appId, bidProject, "bidclarificaiton");
    }

    protected void showBillByEditPermission(long org, String appId, DynamicObject data, String customParam) {
        BillShowParameter showParameter = new BillShowParameter();
        if (appId.equals("rebm")) {
            showParameter.setFormId("rebm_bidcenter");
        } else {
            showParameter.setFormId("bid_bidcenter");
        }
        showParameter.setPkId(data.getPkValue());
        showParameter.setCustomParam("opKeyFromList", (Object)customParam);
        showParameter.setCustomParam("bidProjectId", data.getPkValue());
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        BidProjectProcessUI.processShowForm(this.getView(), (FormShowParameter)showParameter);
        this.getView().close();
    }

    protected String hasAllPermission(long org, String appId, List<String> memberList, String step, DynamicObject entrustmentorgunit) {
        boolean hasBidCenterPermission;
        String userId = RequestContext.get().getUserId();
        String tip = null;
        Lang lang = RequestContext.get().getLang();
        boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            if (!memberList.contains(userId)) {
                tip = !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? "The current user does not have the business handling right of " + this.stepName(step) + "and is not allowed to view." : String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u7684\u4e1a\u52a1\u7ecf\u529e\u6743\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_26", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
                return tip;
            }
            if (entrustmentorgunit == null) {
                boolean hasPermission = this.checkPermission("QXX0001", org, appId, step);
                if (!hasPermission) {
                    tip = this.stepTipInfo(step);
                    return tip;
                }
            } else {
                Long entrustmentorgunitId = (Long)entrustmentorgunit.getPkValue();
                boolean hasPermission = this.checkPermission("QXX0001", entrustmentorgunitId, appId, step);
                if (!hasPermission) {
                    tip = this.stepTipInfo(step);
                    return tip;
                }
            }
        } else {
            boolean currentOrgPermission = true;
            if (entrustmentorgunit == null) {
                boolean hasPermission = this.checkPermission("QXX0001", org, appId, step);
                if (!hasPermission) {
                    currentOrgPermission = false;
                }
            } else {
                Long orgUnitId = (Long)entrustmentorgunit.getPkValue();
                boolean hasPermission = this.checkPermission("QXX0001", orgUnitId, appId, step);
                if (!hasPermission) {
                    currentOrgPermission = false;
                }
            }
            if (!memberList.contains(userId) && !currentOrgPermission) {
                tip = this.stepTipInfo(step);
                return tip;
            }
        }
        if (!(hasBidCenterPermission = this.checkPermission("QXX0001", org, appId, "bid_bidcenter"))) {
            tip = this.stepTipInfo("bid_bidcenter");
            return tip;
        }
        return null;
    }

    protected String stepTipInfo(String step) {
        String tip = null;
        Lang lang = RequestContext.get().getLang();
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            if ("bid_project".equals(step)) {
                tip = "The current user does not have the right to view the" + this.stepName(step) + "and is not allowed to view it.";
            } else if ("bid_supplierinvitation".equals(step)) {
                tip = "The current user does not have the right to view the" + this.stepName(step) + "and is not allowed to view it.";
            } else if ("bid_biddocument_edit".equals(step)) {
                tip = "The current user does not have the right to view the" + this.stepName(step) + "and is not allowed to view it.";
            } else if ("bid_bidpublish".equals(step)) {
                tip = "The current user does not have the right to view the" + this.stepName(step) + "and is not allowed to view it.";
            } else if ("bid_answerquestion_reco".equals(step)) {
                tip = "The current user does not have the right to view the" + this.stepName(step) + "and is not allowed to view it.";
            } else if ("bid_bidopen".equals(step)) {
                tip = "The current user does not have the right to view the" + this.stepName(step) + "and is not allowed to view it.";
            } else if ("bid_bidevaluation".equals(step)) {
                tip = "The current user does not have the right to view the" + this.stepName(step) + "and is not allowed to view it.";
            } else if ("bid_bustalk".equals(step)) {
                tip = "The current user does not have the right to view the" + this.stepName(step) + "and is not allowed to view it.";
            } else if ("bid_decision".equals(step)) {
                tip = "The current user does not have the right to view the" + this.stepName(step) + "and is not allowed to view it.";
            } else if ("bid_bidcenter".equals(step)) {
                tip = "The current user does not have the right to view the" + this.stepName(step) + "and is not allowed to view it.";
            }
        } else if ("bid_project".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_126", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_supplierinvitation".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_126", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_biddocument_edit".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_126", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_bidpublish".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_126", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_answerquestion_reco".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_126", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_bidopen".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_126", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_bidevaluation".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_126", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_bustalk".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_126", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_decision".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_126", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_bidcenter".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1$s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectProcessUI_126", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        }
        return tip;
    }

    protected String stepName(String step) {
        String name = null;
        Lang lang = RequestContext.get().getLang();
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            if ("bid_project".equals(step)) {
                name = "bidding project";
            } else if ("bid_supplierinvitation".equals(step)) {
                name = "supplier qualification";
            } else if ("bid_biddocument_edit".equals(step)) {
                name = "bidding document preparation";
            } else if ("bid_bidpublish".equals(step)) {
                name = "issue of bidding documents";
            } else if ("bid_answerquestion_reco".equals(step)) {
                name = "answer question";
            } else if ("bid_bidopen".equals(step)) {
                name = "bid opening";
            } else if ("bid_bidevaluation".equals(step)) {
                name = "evaluation of bid";
            } else if ("bid_bustalk".equals(step)) {
                name = "commercial negotiation";
            } else if ("bid_decision".equals(step)) {
                name = "bid award";
            } else if ("bid_bidcenter".equals(step)) {
                name = "bidding center";
            } else if ("bid_clarificaiton".equals(step)) {
                name = "bid clarificaiton";
            } else if ("bid_bottom_make".equals(step)) {
                name = "bid bottom make";
            }
        } else if ("bid_project".equals(step)) {
            name = ResManager.loadKDString((String)"\u62db\u6807\u7acb\u9879", (String)"BidProjectProcessUI_29", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_supplierinvitation".equals(step)) {
            name = ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4", (String)"BidProjectProcessUI_30", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_biddocument_edit".equals(step)) {
            name = ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236", (String)"BidProjectProcessUI_31", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidpublish".equals(step)) {
            name = ResManager.loadKDString((String)"\u53d1\u6807", (String)"BidProjectProcessUI_32", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_answerquestion_reco".equals(step)) {
            name = ResManager.loadKDString((String)"\u7b54\u7591", (String)"BidProjectProcessUI_33", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidopen".equals(step)) {
            name = ResManager.loadKDString((String)"\u5f00\u6807", (String)"BidProjectProcessUI_72", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidevaluation".equals(step)) {
            name = ResManager.loadKDString((String)"\u8bc4\u6807", (String)"BidProjectProcessUI_35", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bustalk".equals(step)) {
            name = ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224", (String)"BidProjectProcessUI_36", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_decision".equals(step)) {
            name = ResManager.loadKDString((String)"\u5b9a\u6807", (String)"BidProjectProcessUI_37", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidcenter".equals(step)) {
            name = ResManager.loadKDString((String)"\u62db\u6807\u4e2d\u5fc3", (String)"BidProjectProcessUI_38", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_clarificaiton".equals(step)) {
            name = ResManager.loadKDString((String)"\u62db\u6807\u4ea4\u5e95", (String)"BidProjectProcessUI_39", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bottom_make".equals(step)) {
            name = ResManager.loadKDString((String)"\u6807\u5e95\u7f16\u5236", (String)"BidProjectProcessUI_40", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        return name;
    }

    protected boolean checkPermission(String number, Long orgId, String appId, String entityNum) {
        QFilter[] filter = new QFilter[]{new QFilter("number", "=", (Object)number)};
        DynamicObject permissionObj = BusinessDataServiceHelper.loadSingle((String)"perm_permitem", (String)"id,number", (QFilter[])filter);
        int hasPermission = 0;
        if (permissionObj != null) {
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            String permItemId = permissionObj.get("id").toString();
            if (appId.equals("rebm")) {
                entityNum = this.replaceBeforeTip(entityNum);
            }
            hasPermission = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)appId, (String)entityNum, (String)permItemId);
        }
        return hasPermission == 1;
    }

    protected String replaceBeforeTip(String step) {
        String name = null;
        if ("bid_project".equals(step)) {
            name = "rebm_project";
        } else if ("bid_supplierinvitation".equals(step)) {
            name = "rebm_supplierinvitation";
        } else if ("bid_biddocument_edit".equals(step)) {
            name = "rebm_biddocument_edit";
        } else if ("bid_bidpublish".equals(step)) {
            name = "rebm_bidpublish";
        } else if ("bid_answerquestion_reco".equals(step)) {
            name = "rebm_answerquestion_reco";
        } else if ("bid_bidopen".equals(step)) {
            name = "rebm_bidopen";
        } else if ("bid_bidevaluation".equals(step)) {
            name = "rebm_bidevaluation";
        } else if ("bid_bustalk".equals(step)) {
            name = "rebm_bustalk";
        } else if ("bid_decision".equals(step)) {
            name = "rebm_decision";
        } else if ("bid_bidcenter".equals(step)) {
            name = "rebm_bidcenter";
        } else if ("bid_clarificaiton".equals(step)) {
            name = "rebm_clarificaiton";
        } else if ("bid_bottom_make".equals(step)) {
            name = "rebm_bottom_make";
        }
        return name;
    }

    public static void processShowForm(IFormView view, FormShowParameter parameter) {
        if (ShowType.NewWindow.equals((Object)view.getFormShowParameter().getOpenStyle().getShowType())) {
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            view.showForm(parameter);
        } else {
            IFormView tabView = BidProjectProcessUI.getTabControlView(view);
            if (tabView != null) {
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
                tabView.showForm(parameter);
                view.sendFormAction(tabView);
            } else {
                parameter.getOpenStyle().setShowType(ShowType.NewWindow);
                view.showForm(parameter);
            }
        }
    }

    public static IFormView getTabControlView(IFormView view) {
        IFormView parentView = view;
        while ((parentView = parentView.getParentView()) != null && !"pc_main_console".equals(parentView.getFormShowParameter().getFormId())) {
            Control control = parentView.getControl("_submaintab_");
            if (control == null) continue;
            return parentView;
        }
        return null;
    }

    public String getRespBusinessNo(String formId) {
        switch (formId) {
            case "bid_project": {
                return "01";
            }
            case "bid_supplierinvitation": {
                return "02";
            }
            case "bid_biddocument_edit": 
            case "bid_biddocument_history": {
                return "09";
            }
            case "bid_bidpublish": 
            case "bid_bidpublish_history": {
                return "05";
            }
            case "bid_answerquestion": {
                return "10";
            }
            case "bid_bidopen": {
                return "06";
            }
            case "bid_bidevaluation": {
                return "07";
            }
            case "bid_decision": {
                return "08";
            }
            case "bid_bustalk": {
                return "15";
            }
            case "bid_clarificaiton": {
                return "18";
            }
            case "bid_bottom_make": {
                return "19";
            }
        }
        return "null";
    }
}

