/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.formplugin.bill.BidProjectProcessUI;
import kd.scm.bid.formplugin.bill.util.BidProjectProcessUtil;

public class BidSubProjectProcessUI
extends BidProjectProcessUI {
    private static final Map<String, String> bussinessStepMap = new HashMap<String, String>(16);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        String image = "image";
        Button imageJSKBBtn = (Button)this.getControl(image + "4jskb");
        imageJSKBBtn.addClickListener((ClickListener)this);
        Button imageSWKBBtn = (Button)this.getControl(image + "4swkb");
        imageSWKBBtn.addClickListener((ClickListener)this);
        Button imageJSPBBtn = (Button)this.getControl(image + "4jspb");
        imageJSPBBtn.addClickListener((ClickListener)this);
        Button imageSWPBBtn = (Button)this.getControl(image + "4swpb");
        imageSWPBBtn.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.bindSeparateOpenLineData();
    }

    protected void bindSeparateOpenLineData() {
        Object projectId = this.getView().getFormShowParameter().getCustomParam("bidProjectId");
        if (projectId == null) {
            return;
        }
        DynamicObject bidProjectData = BidProjectProcessUtil.getBidProjectData(projectId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        boolean separateOpen = BidProjectProcessUtil.isSeparateOpen(bidProjectData);
        if (!separateOpen) {
            return;
        }
        Set<String> hasPermEntityBillSet = BidProjectProcessUtil.hasPermissionEntityBill(bidProjectData);
        String appId = bidProjectData.getString("entitytypeid").split("_")[0];
        boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        if (isAdmin) {
            if (bidProjectData.getBoolean("bidopen")) {
                Arrays.asList("11", "12").forEach(value -> this.setLinePanelValueByBusiness((String)value, bidProjectData));
            }
            if (bidProjectData.getBoolean("bidevaluation")) {
                Arrays.asList("13", "14").forEach(value -> this.setLinePanelValueByBusiness((String)value, bidProjectData));
            }
            return;
        }
        if (hasPermEntityBillSet.size() == 0) {
            return;
        }
        hasPermEntityBillSet.forEach(value -> this.setLinePanelValueByBusiness((String)value, bidProjectData));
    }

    public String bidAdminRoleId() {
        return "/FFXFSRKI73+";
    }

    protected void setLinePanelValueByBusiness(String value, DynamicObject bidProject) {
        if ("13t".equals(value) || "14s".equals(value)) {
            return;
        }
        String formId = FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass());
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        qFilterList.add(new QFilter("bidproject", "=", bidProject.getPkValue()));
        String type = null;
        switch (value) {
            case "11": {
                formId = FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass());
                qFilterList.add(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                type = BidOpenTypeEnum.TECHNICAL.getValue();
                break;
            }
            case "12": {
                formId = FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass());
                qFilterList.add(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                type = BidOpenTypeEnum.BUSSINESS.getValue();
                break;
            }
            case "13": {
                formId = FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass());
                qFilterList.add(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                type = BidOpenTypeEnum.TECHNICAL.getValue();
                break;
            }
            case "14": {
                formId = FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass());
                qFilterList.add(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                type = BidOpenTypeEnum.BUSSINESS.getValue();
            }
        }
        DynamicObject[] datas = this.loadBillDatasByNameAndFilter(formId, qFilterList);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        this.putPlanTimeByFormIdAndType(formId, type, bidProject, dataMap);
        Date now = new Date();
        Object planTime = dataMap.get("plantime");
        boolean isDelay = this.juageDelay(planTime, now);
        if (datas == null || datas.length == 0) {
            dataMap.put("status", ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"BidSubProjectProcessUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            dataMap.put("imageurl", isDelay ? "icons/pc/state/delay_notstart.png" : "icons/pc/state/notdelay_notstart.png");
        } else {
            Optional<DynamicObject> any = Arrays.stream(datas).filter(data -> !Arrays.asList("D", "XX", "X").contains(data.getString("billstatus"))).findAny();
            if (any.isPresent()) {
                if (formId.endsWith("bidopen")) {
                    this.getBidOpenDataMap(datas, dataMap, isDelay);
                } else {
                    this.getBidEvaluationDataMap(datas, dataMap, isDelay);
                }
            } else {
                dataMap.put("status", ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"BidSubProjectProcessUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                dataMap.put("imageurl", isDelay ? "icons/pc/state/delay_notstart.png" : "icons/pc/state/notdelay_notstart.png");
            }
        }
        dataMap.put("imagename", bussinessStepMap.get(value));
        this.bindData(dataMap);
    }

    protected boolean juageDelay(Object planTime, Date now) {
        if (planTime == null) {
            return false;
        }
        return ((Date)planTime).before(now);
    }

    protected void putPlanTimeByFormIdAndType(String formId, String type, DynamicObject bidProject, Map<String, Object> dataMap) {
        String dateField = null;
        dateField = formId.endsWith("bidopen") ? (BidOpenTypeEnum.TECHNICAL.getValue().equalsIgnoreCase(type) ? "techopenbidtime" : "busopenbidtime") : (BidOpenTypeEnum.TECHNICAL.getValue().equalsIgnoreCase(type) ? "busopenbidtime" : "bidevaluationdate");
        dataMap.put("plantime", bidProject.getDate(dateField));
    }

    protected void bindData(Map<String, Object> dataMap) {
        Object typeName = dataMap.get("imagename");
        Image image = (Image)this.getControl("image" + typeName);
        image.setUrl((String)dataMap.get("imageurl"));
        Label status = (Label)this.getControl("status" + typeName);
        status.setText((String)dataMap.get("status"));
        Label planTime = (Label)this.getControl("plantime" + typeName);
        if (dataMap.get("plantime") != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:dd");
            planTime.setText(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\uff1a%s", (String)"BidSubProjectProcessUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]), simpleDateFormat.format(dataMap.get("plantime"))));
        }
        Label realTime = (Label)this.getControl("realtime" + typeName);
        if (dataMap.get("realtime") != null) {
            realTime.setText(String.format(ResManager.loadKDString((String)"\u5b9e\u9645\u65f6\u95f4\uff1a%s", (String)"BidSubProjectProcessUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]), (String)dataMap.get("realtime")));
        }
        Label nodeTime = (Label)this.getControl("jdtime" + typeName);
        nodeTime.setText(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u65f6\u957f\uff1a%s", (String)"BidSubProjectProcessUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.formatLongToTime(dataMap.get("nodetime"))));
        Label bzTime = (Label)this.getControl("bztime" + typeName);
        bzTime.setText(String.format(ResManager.loadKDString((String)"\u7f16\u5236\u65f6\u957f\uff1a%s", (String)"BidSubProjectProcessUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.formatLongToTime(dataMap.get("biztime"))));
        Label auditTime = (Label)this.getControl("sptime" + typeName);
        auditTime.setText(String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u65f6\u957f\uff1a%s", (String)"BidSubProjectProcessUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.formatLongToTime(dataMap.get("audittime"))));
    }

    protected String formatLongToTime(Object longTime) {
        if (longTime == null || (Long)longTime == 0L) {
            return " ";
        }
        long time = (Long)longTime;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        long hours = time / 3600000L;
        long minutes = (time - hours * 3600000L) / 60000L;
        long s = time / 1000L - hours * 60L * 60L - minutes * 60L;
        return decimalFormat.format(hours) + ":" + decimalFormat.format(minutes) + ":" + decimalFormat.format(s);
    }

    protected void getBidEvaluationDataMap(DynamicObject[] datas, Map<String, Object> dataMap, boolean isDelay) {
        Optional<DynamicObject> any = Arrays.stream(datas).filter(data -> "C".equals(data.getString("billstatus"))).findAny();
        if (any.isPresent()) {
            DynamicObject evaluation = any.get();
            Date auditdate = evaluation.getDate("auditdate");
            isDelay = this.juageDelay(dataMap.get("plantime"), auditdate);
            dataMap.put("status", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"BidSubProjectProcessUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            dataMap.put("imageurl", "icons/pc/state/" + (isDelay ? "delay_finish.png" : "success_28_28.png"));
        }
        SimpleDateFormat longDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (DynamicObject data2 : datas) {
            String billStatus;
            if (!dataMap.containsKey("status")) {
                this.putNodeStatus(data2, dataMap, isDelay);
            }
            if ("C".equals(billStatus = data2.getString("billstatus"))) {
                Date realEvaluationDate = data2.getDate("auditdate");
                dataMap.put("realtime", longDateFormat.format(realEvaluationDate));
            }
            this.putTimeValue(data2, dataMap, "auditdate", "createtime", "nodetime");
            this.putTimeValue(data2, dataMap, "submittime", "createtime", "biztime");
            this.putTimeValue(data2, dataMap, "auditdate", "submittime", "audittime");
        }
    }

    protected void getBidOpenDataMap(DynamicObject[] datas, Map<String, Object> dataMap, boolean isDelay) {
        Optional<DynamicObject> any = Arrays.stream(datas).filter(data -> "O".equals(data.getString("billstatus"))).findAny();
        if (any.isPresent()) {
            DynamicObject open = any.get();
            Date realbidopendate = open.getDate("realbidopendate");
            isDelay = this.juageDelay(dataMap.get("plantime"), realbidopendate);
            dataMap.put("status", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"BidSubProjectProcessUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            dataMap.put("imageurl", "icons/pc/state/" + (isDelay ? "delay_finish.png" : "success_28_28.png"));
        }
        SimpleDateFormat longDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (DynamicObject data2 : datas) {
            String billStatus;
            if (!dataMap.containsKey("status")) {
                this.putNodeStatus(data2, dataMap, isDelay);
            }
            if ("O".equals(billStatus = data2.getString("billstatus"))) {
                Date realBidOpenDate = data2.getDate("realbidopendate");
                dataMap.put("realtime", longDateFormat.format(realBidOpenDate));
            }
            this.putTimeValue(data2, dataMap, "realbidopendate", "createtime", "nodetime");
            this.putTimeValue(data2, dataMap, "submittime", "createtime", "biztime");
            this.putTimeValue(data2, dataMap, "auditdate", "submittime", "audittime");
        }
    }

    protected void putTimeValue(DynamicObject data, Map<String, Object> dataMap, String minuendField, String subtractedField, String keyName) {
        Date createTime = data.getDate(subtractedField);
        Date realbidOpenDate = data.getDate(minuendField);
        if (createTime != null && realbidOpenDate != null) {
            long spendingTime = realbidOpenDate.getTime() - createTime.getTime();
            dataMap.put(keyName, spendingTime += ((Long)dataMap.getOrDefault(keyName, 0L)).longValue());
        }
    }

    protected void putNodeStatus(DynamicObject data, Map<String, Object> dataMap, boolean isDelay) {
        String billStatus = data.getString("billstatus");
        if ("D".equals(billStatus)) {
            dataMap.put("status", ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"BidSubProjectProcessUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            dataMap.put("imageurl", isDelay ? "icons/pc/state/delay_notstart.png" : "icons/pc/state/notdelay_notstart.png");
        } else if (this.getStatusListByFormId(data.getDynamicObjectType().getName()).contains(billStatus)) {
            dataMap.put("status", ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"BidSubProjectProcessUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            dataMap.put("imageurl", isDelay ? "icons/pc/state/delay_progressed.png" : "icons/pc/state/notdelay_progressed.png");
        }
    }

    protected List<String> getStatusListByFormId(String formId) {
        return formId.endsWith("bidopen") ? Arrays.asList("A", "B", "I", "C", "P") : Arrays.asList("A", "B", "I");
    }

    protected DynamicObject[] loadBillDatasByNameAndFilter(String formId, List<QFilter> qFilterList) {
        return BusinessDataServiceHelper.load((String)formId, (String)this.getQueryFieldsByFormId(formId), (QFilter[])qFilterList.toArray(new QFilter[0]));
    }

    protected String getQueryFieldsByFormId(String formId) {
        String selectedProperyies = null;
        selectedProperyies = formId.endsWith("bidopen") ? "id,createtime,rounds,auditdate,submittime,realbidopendate,modifytime,billstatus,opentype" : "id,createtime,rounds,auditdate,submittime,modifytime,billstatus,evaltype";
        return selectedProperyies;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"panel4jskb", "panel4swkb", "panel4swpb", "panel4jspb"});
        Object projectId = this.getView().getFormShowParameter().getCustomParam("bidProjectId");
        if (projectId == null) {
            return;
        }
        DynamicObject bidProjectData = BidProjectProcessUtil.getBidProjectData(projectId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        boolean separateOpen = BidProjectProcessUtil.isSeparateOpen(bidProjectData);
        if (!separateOpen) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"panel4kb", "panel4pb"});
        String appId = bidProjectData.getString("entitytypeid").split("_")[0];
        boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        if (isAdmin) {
            if (bidProjectData.getBoolean("bidopen")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"panel4jskb", "panel4swkb"});
            }
            if (bidProjectData.getBoolean("bidevaluation")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"panel4jspb", "panel4swpb"});
            }
            return;
        }
        Set<String> hasPermEntityBillSet = BidProjectProcessUtil.hasPermissionEntityBill(bidProjectData);
        if (hasPermEntityBillSet.size() == 0) {
            return;
        }
        hasPermEntityBillSet.forEach(bill -> this.getView().setVisible(Boolean.TRUE, new String[]{"panel" + bussinessStepMap.get(bill)}));
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        Object projectId = this.getView().getFormShowParameter().getCustomParam("bidProjectId");
        DynamicObject bidProjectData = BidProjectProcessUtil.getBidProjectData(projectId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        String appId = bidProjectData.getString("entitytypeid").split("_")[0];
        switch (key) {
            case "image4jskb": {
                this.technicalOpenClick(bidProjectData, appId);
                break;
            }
            case "image4swkb": {
                this.businessOpenClick(bidProjectData, appId);
                break;
            }
            case "image4jspb": {
                this.technicalEvalClick(bidProjectData, appId);
                break;
            }
            case "image4swpb": {
                this.businessEvalClick(bidProjectData, appId);
            }
        }
    }

    protected void businessEvalClick(DynamicObject bidProjectData, String appId) {
        if (!this.validatorBusinessEvalBill(bidProjectData, appId)) {
            return;
        }
        this.showBillByEditPermission(0L, appId, bidProjectData, "busibidevaluation");
    }

    protected void technicalEvalClick(DynamicObject bidProjectData, String appId) {
        if (!this.validatorTechnicalEvalBill(bidProjectData, appId)) {
            return;
        }
        this.showBillByEditPermission(0L, appId, bidProjectData, "techbidevaluation");
    }

    protected void businessOpenClick(DynamicObject bidProjectData, String appId) {
        if (!this.validatorBusinessOpenBill(bidProjectData, appId)) {
            return;
        }
        this.showBillByEditPermission(0L, appId, bidProjectData, "busibidopen");
    }

    public boolean checkHasPermission(DynamicObject bidProjectData, String appId, String entityName) {
        long orgId = (Long)bidProjectData.getDynamicObject("org").getPkValue();
        DynamicObject entrustmentorgunit = bidProjectData.getDynamicObject("entrustmentorgunit");
        String resultTips = this.hasAllPermission(orgId, appId, Collections.singletonList(String.valueOf(RequestContext.get().getCurrUserId())), entityName, entrustmentorgunit);
        if (resultTips != null) {
            this.getView().showTipNotification(resultTips);
            return true;
        }
        return false;
    }

    protected void technicalOpenClick(DynamicObject bidProjectData, String appId) {
        boolean c = this.validatorTechnicalOpenBill(bidProjectData, appId);
        if (!c) {
            return;
        }
        this.showBillByEditPermission(0L, appId, bidProjectData, "techbidopen");
    }

    protected boolean validatorTechnicalOpenBill(DynamicObject bidProjectData, String appId) {
        boolean exists = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectData.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "X"}), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue())});
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u6280\u672f\u5f00\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidSubProjectProcessUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return false;
        }
        return !this.checkHasPermission(bidProjectData, appId, "bid_bidopen");
    }

    protected boolean validatorBusinessOpenBill(DynamicObject bidProjectData, String appId) {
        boolean exists = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectData.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "X"}), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue())});
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u5546\u52a1\u5f00\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidSubProjectProcessUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection techOpens = QueryServiceHelper.query((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectData.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "X"}), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue())});
        Optional<DynamicObject> noFinishData = techOpens.stream().filter(data -> !"O".equals(data.getString("billstatus"))).findFirst();
        if (noFinishData.isPresent()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6280\u672f\u6807\u5f00\u6807\u5c1a\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u5546\u52a1\u6807\u3002", (String)"BidSubProjectProcessUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return false;
        }
        return !this.checkHasPermission(bidProjectData, appId, "bid_bidopen");
    }

    protected boolean validatorTechnicalEvalBill(DynamicObject bidProjectData, String appId) {
        boolean exists = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectData.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "X"}), new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue())});
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u6280\u672f\u6807\u8bc4\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidSubProjectProcessUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return false;
        }
        return !this.checkHasPermission(bidProjectData, appId, "bid_bidevaluation");
    }

    protected boolean validatorBusinessEvalBill(DynamicObject bidProjectData, String appId) {
        boolean exists = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectData.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "X"}), new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue())});
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u5c1a\u672a\u53d1\u751f\u5546\u52a1\u6807\u8bc4\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidSubProjectProcessUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return false;
        }
        return !this.checkHasPermission(bidProjectData, appId, "bid_bidevaluation");
    }

    static {
        bussinessStepMap.put("11", "4jskb");
        bussinessStepMap.put("12", "4swkb");
        bussinessStepMap.put("13", "4jspb");
        bussinessStepMap.put("14", "4swpb");
    }
}

