/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;

public class BidSupFinalDetailFormPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String detailEntryIds = (String)formShowParameter.getCustomParam("detailEntryIds");
        Object decisionId = formShowParameter.getCustomParam("decisionId");
        String sectionId = (String)formShowParameter.getCustomParam("sectionId");
        List<DynamicObject> decisionPurDetailEntryData = this.getDecisionPurDetailEntryData(decisionId, sectionId, detailEntryIds);
        this.createEntryData(decisionPurDetailEntryData, sectionId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPurTypeModelStatus();
    }

    private void setPurTypeModelStatus() {
        boolean isMaterialpur = (Boolean)this.getView().getFormShowParameter().getCustomParam("isMaterialpur");
        boolean isratebidding = (Boolean)this.getView().getFormShowParameter().getCustomParam("isratebidding");
        if (isMaterialpur) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"purentrycontent", "costrate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "model", "unit", "materialdes", "model", "baseunit", "qty", "inclutaxprice"});
            if (!isratebidding) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"costrate"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inclutaxamount", "taxrate", "taxamount", "excepttaxamount"});
            }
        }
    }

    protected void createEntryData(List<DynamicObject> decisionPurDetailEntryData, String sectionId) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        entryentity.clear();
        decisionPurDetailEntryData.forEach(entry -> {
            DynamicObject entryRow = entryentity.addNew();
            entryRow.set("purentrycontent", entry.get("lpurentrycontent"));
            entryRow.set("purentryproject", entry.get("lpurentryproject"));
            entryRow.set("materialid", entry.get("lmaterialid"));
            entryRow.set("sectionid", (Object)sectionId);
            entryRow.set("pursupplier", entry.get("lpursupplier"));
            entryRow.set("materialdes", entry.get("lmaterialdes"));
            entryRow.set("qty", entry.get("lqty"));
            entryRow.set("baseunit", entry.get("baseunit"));
            entryRow.set("inclutaxprice", entry.get("linclutaxprice"));
            entryRow.set("inclutaxamount", entry.get("linclutaxamount"));
            entryRow.set("lbd_taxrate", entry.get("lbd_taxrate"));
            entryRow.set("taxrate", (Object)new BigDecimal(100).multiply(entry.getBigDecimal("ltaxrate")));
            entryRow.set("taxamount", entry.get("ltaxamount"));
            entryRow.set("excepttaxamount", entry.get("lexcepttaxamount"));
            entryRow.set("costrate", entry.get("lcostrate"));
            entryRow.set("purdetailid", entry.getPkValue());
        });
    }

    protected List<DynamicObject> getDecisionPurDetailEntryData(Object decisionId, String sectionId, String detailEntryIds) {
        if (decisionId == null || sectionId == null || detailEntryIds == null) {
            return null;
        }
        List<String> needAddIds = Arrays.asList(detailEntryIds.split("###"));
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(16);
        DynamicObject decision = BusinessDataServiceHelper.loadSingle((Object)decisionId, (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        decision.getDynamicObjectCollection("bidsection").forEach(section -> {
            Object sectionid = section.getPkValue();
            if (!StringUtils.equals((CharSequence)sectionId, (CharSequence)sectionid.toString())) {
                return;
            }
            DynamicObjectCollection supfinaldetail = section.getDynamicObjectCollection("supfinaldetail");
            List collect = supfinaldetail.stream().filter(sup -> needAddIds.contains(sup.getPkValue().toString())).collect(Collectors.toList());
            detailList.addAll(collect);
        });
        return detailList;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("btnok".equals(operateKey)) {
            EntryGrid entry = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entry.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u64cd\u4f5c\u3002", (String)"BidSupFinalDetailFormPlugin_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            this.returnDataToParent(selectRows);
        }
    }

    protected void returnDataToParent(int[] selectRows) {
        ArrayList<Object> detailIds = new ArrayList<Object>(16);
        for (int selectRow : selectRows) {
            DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", selectRow);
            Object purdetailid = entry.get("purdetailid");
            detailIds.add(purdetailid);
        }
        HashMap<String, ArrayList<Object>> dataMap = new HashMap<String, ArrayList<Object>>(16);
        dataMap.put("purDetailIds", detailIds);
        this.getView().returnDataToParent(dataMap);
    }
}

