/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scm.bid.business.bill.IBidDarkService;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidDarkServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class BidSupplierBackBidEditPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String BIDDING = "bidding";
    private static final String DEADLINE = "deadline";
    private IBidOpenService bidOpenService = new BidOpenServiceImpl();
    private IBidProjectService projectService = new BidProjectServiceImpl();
    private IBidDarkService bidDarkService = new BidDarkServiceImpl();

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection bidSectionColl;
        String docType;
        String bidOpenSelectType;
        DynamicObject bidOpen;
        DynamicObject bidProject;
        Boolean isHasBidOpen;
        String bidOpenId;
        String openType;
        Object bidProjectId;
        block30: {
            SplitContainer splitContainer;
            super.afterBindData(e);
            this.getView().setEnable(Boolean.FALSE, new String[]{"revokebidnumber"});
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            bidProjectId = formShowParameter.getCustomParam("bidProjectId");
            openType = (String)formShowParameter.getCustomParam("opentype");
            bidOpenId = (String)formShowParameter.getCustomParam("bidopenid");
            String biddealinedate = (String)formShowParameter.getCustomParam("biddealinedate");
            String billFormId = (String)formShowParameter.getCustomParam("billFormId");
            DynamicObject bidProjectF7 = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bidproject_f7");
            this.getModel().setValue("bidproject", (Object)bidProjectF7);
            isHasBidOpen = this.checkIsHasBidOpen(bidProjectId, bidOpenId);
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"name,bidopendeadline,enablemultisection,isratebidding,bidopentype,doctype,currency");
            if (!bidProject.getBoolean("enablemultisection") && (splitContainer = (SplitContainer)this.getControl("splitcontainerap")) != null) {
                splitContainer.changeFlexStatus(SplitDirection.left, true);
            }
            if (bidProject.getBoolean("isratebidding")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tenderprice", "pricevat", "supplier_pricevat", "supplier_tenderprice", "float_scale"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"rate"});
            }
            bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
            Object name = bidProject.get("name");
            Object bidOpenDeadline = bidProject.get("bidopendeadline");
            bidOpenSelectType = bidProject.getString("bidopentype");
            docType = bidProject.getString("doctype");
            this.getModel().setValue("bidname", name);
            if (billFormId != null && billFormId.endsWith("_bidopen_history")) {
                this.getModel().setValue("biddealinedate", (Object)biddealinedate);
                this.getModel().setValue("bidstatus", (Object)DEADLINE);
            } else {
                this.getModel().setValue("biddealinedate", bidOpenDeadline);
                if (bidOpenDeadline != null) {
                    String endTime = bidOpenDeadline.toString();
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    try {
                        Date date = format.parse(endTime);
                        Date date1 = new Date();
                        int compareTo = date1.compareTo(date);
                        if (compareTo > 0) {
                            this.getModel().setValue("bidstatus", (Object)DEADLINE);
                            break block30;
                        }
                        this.getModel().setValue("bidstatus", (Object)BIDDING);
                    }
                    catch (ParseException e1) {
                        this.LOG.error(e1.getMessage(), (Throwable)e1);
                    }
                } else {
                    this.getModel().setValue("bidstatus", (Object)BIDDING);
                }
            }
        }
        this.setBillstatus(bidOpen);
        DynamicObject currency = bidProject.getDynamicObject("currency");
        int amtPrecision = 0;
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        if (!(bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection")).isEmpty()) {
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                int entryRow = this.getModel().createNewEntryRow("bidsection");
                this.getModel().setValue("entryid", bidSection.get("id"), entryRow);
                this.getModel().setValue("sectionname", bidSection.get("sectionname"), entryRow);
                for (int j = 0; j < supplierEntryColl.size(); ++j) {
                    DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                    this.getModel().setEntryCurrentRowIndex("bidsection", entryRow);
                    this.getModel().createNewEntryRow("supplierentry");
                    if (!isHasBidOpen.booleanValue()) {
                        this.getModel().setValue("manager", (Object)"*****", j);
                        this.getModel().setValue("tenderprice", (Object)"*****", j);
                        this.getModel().setValue("pricevat", (Object)"*****", j);
                        this.getModel().setValue("workday", (Object)"*****", j);
                        this.getModel().setValue("rate", (Object)"*****", j);
                        this.getModel().setValue("supplier_tenderprice", (Object)"*****", j);
                        this.getModel().setValue("supplier_pricevat", (Object)"*****", j);
                        this.getModel().setValue("float_scale", (Object)"*****", j);
                    } else {
                        this.getModel().setValue("manager", supplierEntry.get("supplier_manager"), j);
                        this.getModel().setValue("workday", supplierEntry.get("supplier_workday"), j);
                        if (supplierEntry.get("supplier_tenderprice") != null) {
                            this.getModel().setValue("tenderprice", (Object)this.fmtMicrometer(supplierEntry.getBigDecimal("supplier_tenderprice"), amtPrecision), j);
                        }
                        if (supplierEntry.get("supplier_taxrate") != null) {
                            BigDecimal tempTaxRate = supplierEntry.getBigDecimal("supplier_taxrate");
                            this.getModel().setValue("pricevat", (Object)tempTaxRate.multiply(new BigDecimal(100)).setScale(2, 4).stripTrailingZeros().toPlainString(), j);
                        }
                        if (supplierEntry.get("supplier_rate") != null) {
                            BigDecimal tempRate = supplierEntry.getBigDecimal("supplier_rate");
                            this.getModel().setValue("rate", (Object)tempRate.multiply(new BigDecimal(100)).setScale(2, 4).stripTrailingZeros().toPlainString(), j);
                        }
                        if (supplierEntry.get("supplier_pricevat") != null) {
                            this.getModel().setValue("supplier_pricevat", (Object)this.fmtMicrometer(supplierEntry.getBigDecimal("supplier_pricevat"), amtPrecision), j);
                        }
                        if (supplierEntry.get("supplier_tenderprice") != null) {
                            this.getModel().setValue("supplier_tenderprice", (Object)this.fmtMicrometer(supplierEntry.getBigDecimal("supplier_exceptvat"), amtPrecision), j);
                        }
                        if (supplierEntry.get("float_scale") != null) {
                            this.getModel().setValue("float_scale", (Object)supplierEntry.getString("float_scale"), j);
                        }
                    }
                    if (bidProject.getBoolean("isratebidding")) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"tenderprice", "pricevat", "supplier_pricevat", "supplier_tenderprice", "float_scale"});
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"rate"});
                    }
                    DynamicObjectCollection query = QueryServiceHelper.query((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)});
                    ArrayList<String> ids = new ArrayList<String>(16);
                    if (query.size() != 0) {
                        List id = query.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
                        ids.addAll(id.stream().map(m -> String.valueOf(m)).collect(Collectors.toList()));
                    } else {
                        ids.add(String.valueOf(bidOpenId));
                    }
                    DynamicObject[] tenderrecord = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"tenderrecord", ((Object)((Object)this)).getClass()), (String)"tender,ip,isillegalbid", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("sectionname", "=", (Object)bidSection.getString("sectionname")), new QFilter("supplier", "=", supplierEntry.getDynamicObject("supplier").getPkValue()), new QFilter("curbidopenid", "in", ids)});
                    if (!supplierEntry.getBoolean("supplier_istender")) {
                        this.getModel().setValue("supplier", supplierEntry.get("supplier"), j);
                        this.getModel().setValue("revokebidnumber", supplierEntry.get("supplier_revokebidnumber"), j);
                        this.getModel().setValue("tender", tenderrecord.length > 0 ? tenderrecord[tenderrecord.length - 1].get("tender") : supplierEntry.get("tender"), j);
                        this.getModel().setValue("ip", tenderrecord.length > 0 ? tenderrecord[tenderrecord.length - 1].get("ip") : supplierEntry.get("supplier_ip"), j);
                        this.getModel().setValue("isillegalbid", tenderrecord.length > 0 ? tenderrecord[tenderrecord.length - 1].get("isillegalbid") : supplierEntry.get("isillegalbid"), j);
                        this.getModel().setValue("viewrecord", (Object)(tenderrecord.length > 0 ? ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidSupplierBackBidEditPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ""), j);
                        continue;
                    }
                    this.getModel().setValue("detailid", supplierEntry.get("id"), j);
                    this.getModel().setValue("supplier", supplierEntry.get("supplier"), j);
                    this.getModel().setValue("istender", supplierEntry.get("supplier_istender"), j);
                    this.copyAttach((DynamicObjectCollection)this.getModel().getValue("techattach", j), supplierEntry.getDynamicObjectCollection("supplier_techattach"));
                    this.copyAttach((DynamicObjectCollection)this.getModel().getValue("comattach", j), supplierEntry.getDynamicObjectCollection("supplier_comattach"));
                    this.copyAttach((DynamicObjectCollection)this.getModel().getValue("tenattach", j), supplierEntry.getDynamicObjectCollection("supplier_tenattach"));
                    this.copyAttach((DynamicObjectCollection)this.getModel().getValue("otherattach", j), supplierEntry.getDynamicObjectCollection("supplier_otherattach"));
                    this.getModel().setValue("isfrombackbid", supplierEntry.get("supplier_isfrombackbid"), j);
                    this.getModel().setValue("tender", supplierEntry.get("tender"), j);
                    this.getModel().setValue("revokebidnumber", supplierEntry.get("supplier_revokebidnumber"), j);
                    this.getModel().setValue("tender", tenderrecord.length > 0 ? tenderrecord[tenderrecord.length - 1].get("tender") : supplierEntry.get("tender"), j);
                    this.getModel().setValue("ip", tenderrecord.length > 0 ? tenderrecord[tenderrecord.length - 1].get("ip") : supplierEntry.get("supplier_ip"), j);
                    this.getModel().setValue("isillegalbid", tenderrecord.length > 0 ? tenderrecord[tenderrecord.length - 1].get("isillegalbid") : supplierEntry.get("isillegalbid"), j);
                    this.getModel().setValue("viewrecord", (Object)(tenderrecord.length > 0 ? ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidSupplierBackBidEditPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ""), j);
                    this.getModel().setValue("purdetail", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidSupplierBackBidEditPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), j);
                }
            }
            this.getView().updateView("bidsection");
            this.getView().updateView("supplierentry");
            this.clickFristRows();
        }
        if (!isHasBidOpen.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"techattach", "comattach", "tenattach", "otherattach"});
        }
        this.setSupplierVisible(bidOpenSelectType, openType, docType);
        this.setRevokeBidNumberVisible();
        boolean isDark = bidOpen.getBoolean("isdark");
        if (isDark) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplier"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tender"});
            this.bidDarkService.setEntryDarkSupplierName((Object)Long.parseLong(bidOpenId), this.getModel().getDataEntity(true), this.getModel().getDataEntityType().getAppId());
            this.getView().updateView("supplierentry");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"darksuppliername"});
        }
    }

    protected void copyAttach(DynamicObjectCollection newAttachFiles, DynamicObjectCollection oldAttachFiles) {
        if (CollectionUtils.isEmpty((Collection)oldAttachFiles)) {
            return;
        }
        oldAttachFiles.stream().forEach(item -> {
            DynamicObject inviteAttach = newAttachFiles.addNew();
            inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
        });
    }

    protected void setBillstatus(DynamicObject bidOpen) {
        long bidpublishid = bidOpen.getLong("bidpublishid");
        QFilter filter = new QFilter("bidpublishid", "=", (Object)bidpublishid);
        String formConstant = FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass());
        DynamicObject[] bidopenArr = BusinessDataServiceHelper.load((String)formConstant, (String)"billstatus,sourcebillstatus", (QFilter[])new QFilter[]{filter});
        Stream.of(bidopenArr).filter(item -> item.getString("billstatus").equals("O")).findAny().ifPresent(el -> this.getModel().setValue("bidstatus", (Object)DEADLINE));
    }

    private void clickFristRows() {
        IDataModel dataModel = this.getModel();
        int sectionRowCount = dataModel.getEntryRowCount("bidsection");
        if (sectionRowCount > 0) {
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidsection");
            entryEntityGrid.selectRows(0, true);
        }
    }

    private void setSupplierVisible(String bidOpenSelectType, String openType, String docType) {
        if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenSelectType)) {
            if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)openType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"rate", "tenderprice", "pricevat", "purdetail", "comattach", "supplier_pricevat", "supplier_tenderprice", "float_scale"});
            } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)openType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"techattach", "tenattach", "otherattach"});
            }
        } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenSelectType)) {
            if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)openType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"rate", "tenderprice", "pricevat", "purdetail", "comattach", "tenattach", "otherattach", "supplier_pricevat", "supplier_tenderprice", "float_scale"});
            } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)openType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"techattach"});
            }
        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"techattach"});
        }
    }

    private void setRevokeBidNumberVisible() {
        long orgId = 0L;
        String appId = this.getModel().getDataEntityType().getAppId();
        boolean isRevoke = SystemParamHelper.getRevokeBidSystemParameter((String)appId, (Long)(orgId = this.getModel().getDataEntity().getDynamicObject("bidproject").getDynamicObject("org").getLong("id")), (String)"revoke");
        if (!isRevoke) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"revokebidnumber"});
        }
    }

    private Boolean checkIsHasBidOpen(Object bidProjectId, Object bidOpenId) {
        QFilter filter = new QFilter("bidproject", "=", bidProjectId);
        filter.and(new QFilter("id", "=", (Object)Long.valueOf(bidOpenId.toString())));
        DynamicObject bidopen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"billstatus,sourcebillstatus,isfromreback", (QFilter[])new QFilter[]{filter});
        if (bidopen == null) {
            return Boolean.FALSE;
        }
        boolean isfromreback = bidopen.getBoolean("isfromreback");
        if (!isfromreback && (bidopen.get("billstatus").equals("O") || bidopen.get("sourcebillstatus").equals("O"))) {
            return Boolean.TRUE;
        }
        if (isfromreback && "O".equals(bidopen.getString("billstatus"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String fmtMicrometer(BigDecimal price, int amtPrecision) {
        BigDecimal k = price.setScale(amtPrecision, RoundingMode.UP);
        return k.toString();
    }

    public void cellClick(CellClickEvent paramCellClickEvent) {
        String itemName = paramCellClickEvent.getFieldKey();
        if ("purdetail".equals(itemName)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String bidOpenid = (String)formShowParameter.getCustomParam("bidopenid");
            DynamicObject bidOpen = this.bidOpenService.getBidOpenById(Long.valueOf(bidOpenid));
            if (StringUtils.equals((CharSequence)bidOpen.getString("billstatus"), (CharSequence)BillStatusEnum.INVALIDXX.getVal())) {
                if (!StringUtils.equals((CharSequence)bidOpen.getString("sourcebillstatus"), (CharSequence)"O")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c1a\u672a\u5f00\u6807\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"BidSupplierBackBidEditPlugin_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (!StringUtils.equals((CharSequence)bidOpen.getString("billstatus"), (CharSequence)"O")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c1a\u672a\u5f00\u6807\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"BidSupplierBackBidEditPlugin_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject bidProject = bidOpen.getDynamicObject("bidproject");
            DynamicObject bidProjectf7 = this.projectService.getBidProjectAllById(Long.valueOf(bidProject.getLong("id")));
            int bidType = bidProjectf7.getInt("bidtype");
            boolean isMaterialpur = bidProject.getBoolean("ismaterialpur");
            boolean isratebidding = bidProject.getBoolean("isratebidding");
            EntryGrid grid = (EntryGrid)paramCellClickEvent.getSource();
            IDataModel operate = grid.getModel();
            int row = paramCellClickEvent.getRow();
            DynamicObject supplierEntry = operate.getEntryRowEntity(grid.getKey(), row);
            String supplierid = "";
            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
            supplierid = supplier.getString("id");
            EntryGrid sectionGrid = (EntryGrid)this.getView().getControl("bidsection");
            IDataModel sectionOperate = sectionGrid.getModel();
            int sectionRow = sectionOperate.getEntryCurrentRowIndex("bidsection");
            DynamicObject sectionEntry = sectionOperate.getEntryRowEntity("bidsection", sectionRow);
            String sectionId = sectionEntry.getString("id");
            String sectionName = sectionEntry.getString("sectionName");
            FormShowParameter para = new FormShowParameter();
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            para.setStatus(OperationStatus.VIEW);
            para.setFormId(FormTypeConstants.getFormConstant((String)"bidopen_purdetail", ((Object)((Object)this)).getClass()));
            para.setCustomParam("supplierid", (Object)supplierid);
            para.setCustomParam("sectionId", (Object)sectionId);
            para.setCustomParam("sectionName", (Object)sectionName);
            para.setCustomParam("isMaterialpur", (Object)isMaterialpur);
            para.setCustomParam("isratebidding", (Object)isratebidding);
            para.setCustomParam("bidOpenId", (Object)bidOpen.getLong("id"));
            para.setCustomParam("bidType", (Object)bidType);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, FormTypeConstants.getFormConstant((String)"bidopen_purdetail", ((Object)((Object)this)).getClass()));
            para.setCloseCallBack(callBack);
            this.getView().showForm(para);
        }
        if ("viewrecord".equals(itemName)) {
            this.viewRecordHistory();
        }
    }

    protected void viewRecordHistory() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("supplierentry");
        int curRow = grid.getModel().getEntryCurrentRowIndex("supplierentry");
        DynamicObject supplierEntry = grid.getModel().getEntryRowEntity("supplierentry", curRow);
        String downrecord = supplierEntry.getString("viewrecord");
        if (downrecord == null || downrecord.isEmpty()) {
            return;
        }
        EntryGrid sectionGrid = (EntryGrid)this.getView().getControl("bidsection");
        IDataModel sectionOperate = sectionGrid.getModel();
        int sectionRow = sectionOperate.getEntryCurrentRowIndex("bidsection");
        DynamicObject sectionEntry = sectionOperate.getEntryRowEntity("bidsection", sectionRow);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bidprojectId = formShowParameter.getCustomParam("bidProjectId");
        long openId = Long.parseLong(formShowParameter.getCustomParam("bidopenid").toString());
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"bidpublishid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)openId)});
        Object supplierId = supplierEntry.getDynamicObject("supplier").getPkValue();
        FormShowParameter fromShowParameter = new FormShowParameter();
        String billName = FormTypeConstants.getFormConstant((String)"record_show", ((Object)((Object)this)).getClass());
        fromShowParameter.setFormId(billName);
        fromShowParameter.setCustomParam("bidprojectId", bidprojectId);
        fromShowParameter.setCustomParam("supplierId", supplierId);
        fromShowParameter.setCustomParam("sectionName", (Object)sectionEntry.getString("sectionname"));
        fromShowParameter.setCustomParam("appId", (Object)billName.split("_")[0]);
        fromShowParameter.setCustomParam("bill", (Object)"open");
        DynamicObject bidOpen = QueryServiceHelper.queryOne((String)"bid_bidopen", (String)"isdark", (QFilter[])new QFilter("id", "=", (Object)openId).toArray());
        fromShowParameter.setCustomParam("isdark", (Object)(bidOpen.getBoolean("isdark") + ""));
        List<String> bidpublishid = this.getNeedReTenSupplier(queryOne == null ? 0L : queryOne.getLong("bidpublishid"));
        if (bidpublishid.contains(sectionEntry.getString("sectionname") + supplierId)) {
            fromShowParameter.setCustomParam("openid", Collections.singletonList(openId));
        } else {
            DynamicObjectCollection query = QueryServiceHelper.query((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidprojectId)});
            if (query.size() != 0) {
                List id = query.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
                fromShowParameter.setCustomParam("openid", id);
            } else {
                fromShowParameter.setCustomParam("openid", Collections.singletonList(openId));
            }
        }
        fromShowParameter.setCaption(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u6295\u6807&\u64a4\u6807\u8bb0\u5f55", (String)"BidSupplierBackBidEditPlugin_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fromShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        fromShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(fromShowParameter);
    }

    protected List<String> getNeedReTenSupplier(long publishId) {
        ArrayList<String> supplierIds = new ArrayList<String>(16);
        if (publishId == 0L) {
            return supplierIds;
        }
        DynamicObject publish = BusinessDataServiceHelper.loadSingle((Object)publishId, (String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (String)String.join((CharSequence)",", "bidsection", "sectionname", "supplierentry", "supplier", "tenderstrategy"));
        if (publish == null) {
            return supplierIds;
        }
        DynamicObjectCollection bidsection = publish.getDynamicObjectCollection("bidsection");
        bidsection.forEach(e -> {
            String sectionname = e.getString("sectionname");
            DynamicObjectCollection supplierentry = e.getDynamicObjectCollection("supplierentry");
            supplierentry.forEach(s -> {
                String tenderstrategy = s.getString("tenderstrategy");
                if ("NEEDBID".equals(tenderstrategy)) {
                    Object supplierId = s.getDynamicObject("supplier").getPkValue();
                    supplierIds.add(sectionname + supplierId);
                }
            });
        });
        return supplierIds;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private void loadPurSupplierDetailByBidOpen() {
        boolean isHasDetail;
        DynamicObject bidSupplierBack = this.getModel().getDataEntity(true);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bidProjectId = formShowParameter.getCustomParam("bidProjectId");
        DynamicObject bidOpenTemp = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)});
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bidopen");
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenTemp.getLong("id"), (DynamicObjectType)type);
        DynamicObjectCollection oldSupplierDetails = ((DynamicObject)bidSupplierBack.getDynamicObjectCollection("bidsection").get(0)).getDynamicObjectCollection("supplierdetail");
        boolean bl = isHasDetail = oldSupplierDetails != null && oldSupplierDetails.size() != 0;
        if (!isHasDetail) {
            // empty if block
        }
    }

    private void loadPurSupplierDetail() {
        DynamicObject bidSupplierBack = this.getModel().getDataEntity(true);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bidProjectId = formShowParameter.getCustomParam("bidProjectId");
        DynamicObjectCollection sectionColl = bidSupplierBack.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection oldSupplierDetails = ((DynamicObject)bidSupplierBack.getDynamicObjectCollection("bidsection").get(0)).getDynamicObjectCollection("supplierdetail");
        String purdetailText = ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidSupplierBackBidEditPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        boolean isHasDetail = true;
        if (oldSupplierDetails == null || oldSupplierDetails.size() == 0) {
            isHasDetail = false;
        }
        String appId = this.getModel().getDataEntityType().getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        MainEntityType newOneType = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
        EntityType supplierDetailType = (EntityType)newOneType.getAllEntities().get("supplierdetail");
        DynamicObject bidProjectData = this.projectService.getBidProjectAllById((Long)bidProjectId);
        for (DynamicObject dynamicObject : sectionColl) {
        }
    }

    public void cellDoubleClick(CellClickEvent paramCellClickEvent) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("supplierentry");
        entryGrid.addCellClickListener((CellClickListener)this);
    }
}

