/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.SupplierStatisticServiceImpl;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.formplugin.bill.BidBillEdit;

public class BidSupplierEntollUI
extends AbstractFormPlugin
implements HyperLinkClickListener {
    protected ISupplierInvitationService supplierInvitationService = new SupplierInvitationServiceImpl();
    protected IBidProjectService projectService = new BidProjectServiceImpl();
    private String status = ResManager.loadKDString((String)"\u62a5\u540d\u4e2d", (String)"BidSupplierEntollUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object projectId = this.getView().getFormShowParameter().getCustomParam("bidProjectId");
        if (projectId != null) {
            QFilter qFilter = new QFilter("bidproject.id", "=", projectId);
            String selectedFields = "bidProject.name,bidProject.enrolldeadline,id,billstatus";
            DynamicObject supplierInvitation = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)selectedFields, (QFilter[])new QFilter[]{qFilter});
            this.setBidProject(supplierInvitation, Long.parseLong(projectId.toString()));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        SubEntryGrid supplierenrollentry = (SubEntryGrid)this.getView().getControl("subentryentity");
        if (supplierenrollentry != null) {
            supplierenrollentry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    private void setBidProject(DynamicObject supplierInvitation, Long projectId) {
        if (supplierInvitation == null) {
            return;
        }
        String name = supplierInvitation.getString("bidProject.name");
        Date enrolldeadline = supplierInvitation.getDate("bidProject.enrolldeadline");
        this.getModel().setValue("bidproject", (Object)name);
        this.getModel().setValue("enrolldeadline", (Object)enrolldeadline);
        Date newDate = new Date();
        if (enrolldeadline != null && newDate.after(enrolldeadline)) {
            this.status = ResManager.loadKDString((String)"\u5df2\u622a\u6b62", (String)"BidSupplierEntollUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        this.getModel().setValue("status", (Object)this.status);
        this.getView().updateView("bidproject");
        this.getView().updateView("enrolldeadline");
        this.getView().updateView("status");
        Long supplierInvitationId = supplierInvitation.getLong("id");
        this.setSupplierEnrollEntry(supplierInvitationId, projectId);
        this.getModel().setValue("supplierinvitationid", (Object)supplierInvitationId);
        this.getView().updateView("supplierinvitationid");
        if (!BillStatusEnum.DISBEGIN.getVal().equals(supplierInvitation.getString("billstatus")) && !BillStatusEnum.SAVE.getVal().equals(supplierInvitation.getString("billstatus"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnok"});
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private void setSupplierEnrollEntry(Long supplierInvitationId, Long projectId) {
        DynamicObject supplierEnroll = this.supplierInvitationService.getSupplierInvitationById(supplierInvitationId);
        DynamicObjectCollection supplierEnrollEntry = supplierEnroll.getDynamicObjectCollection("bidenrollsection");
        DynamicObject bidProject = this.projectService.getBidProjectById(projectId, "id,enablemultisection");
        SupplierStatisticServiceImpl suppStatService = new SupplierStatisticServiceImpl();
        String appId = this.getModel().getDataEntityType().getAppId();
        if (!supplierEnrollEntry.isEmpty()) {
            for (int i = 0; i < supplierEnrollEntry.size(); ++i) {
                DynamicObject enrollEntry = (DynamicObject)supplierEnrollEntry.get(i);
                DynamicObjectCollection supplierEnrollDetailColl = enrollEntry.getDynamicObjectCollection("supplierenrollentry");
                int entryRow = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("entrysectionid", enrollEntry.get("id"), entryRow);
                this.getModel().setValue("entrysectionname", enrollEntry.get("entrysectionname"), entryRow);
                for (int j = 0; j < supplierEnrollDetailColl.size(); ++j) {
                    DynamicObject detail = (DynamicObject)supplierEnrollDetailColl.get(j);
                    DynamicObject enrollsupplier = detail.getDynamicObject("enrollsupplier");
                    this.getModel().setEntryCurrentRowIndex("entryentity", entryRow);
                    this.getModel().createNewEntryRow("subentryentity");
                    this.getModel().setValue("enrollid", detail.get("id"), j);
                    this.getModel().setValue("enrollsupplier", (Object)enrollsupplier, j);
                    this.getModel().setValue("enrollsuppliercontact", detail.get("enrollsuppliercontact"), j);
                    this.getModel().setValue("enrollcontactphone", detail.get("enrollcontactphone"), j);
                    this.getModel().setValue("enrollemail", detail.get("enrollemail"), j);
                    this.getModel().setValue("enrolladdress", detail.get("enrolladdress"), j);
                    this.getModel().setValue("enrollfax", detail.get("enrollfax"), j);
                    this.getModel().setValue("isinvitation", detail.get("isinvitation"), j);
                    this.getModel().setValue("enrollsuppliercomment", detail.get("enrollsuppliercomment"), j);
                    this.getModel().setValue("announcement", detail.get("announcement"), j);
                    DynamicObjectCollection newAttachFiles = (DynamicObjectCollection)this.getModel().getValue("registerattachfile", j);
                    DynamicObjectCollection oldAttachFiles = detail.getDynamicObjectCollection("registerattachfile");
                    oldAttachFiles.stream().forEach(item -> {
                        DynamicObject inviteAttach = newAttachFiles.addNew();
                        inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
                    });
                    this.getModel().setValue("isregister", (Object)Boolean.TRUE, j);
                    this.getModel().setValue("isrecommend", (Object)Boolean.TRUE, j);
                    DynamicObject supplierStatistic = suppStatService.getSupplierStatistic(Long.valueOf(enrollsupplier.getLong("id")), appId + "_supplierstatistic");
                    this.getModel().setValue("enrollsupplierstatistic", supplierStatistic.get("id"), j);
                }
            }
            this.getView().updateView("subentryentity");
            this.getView().updateView("entryentity");
            this.clickFristRows();
            SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
            if (!bidProject.getBoolean("enablemultisection")) {
                splitContainer.changeFlexStatus(SplitDirection.left, true);
            } else {
                splitContainer.changeFlexStatus(SplitDirection.left, false);
            }
        }
    }

    private void clickFristRows() {
        IDataModel dataModel = this.getModel();
        int sectionRowCount = dataModel.getEntryRowCount("entryentity");
        if (sectionRowCount > 0) {
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("entryentity");
            entryEntityGrid.selectRows(0, true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"savesupplierenroll") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().close();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("enrollwonqty".equals(fieldName)) {
            IFormView view = this.getView();
            String formId = view.getFormShowParameter().getFormId();
            long curOrgId = RequestContext.get().getOrgId();
            String appId = BidBillEdit.getAppId(view, formId);
            String pernNumber = "QXX1100";
            boolean hasPerm = BidBillEdit.checkPermission(pernNumber, curOrgId, appId, formId);
            if (!hasPerm) {
                view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u6743\u67e5\u770b\u4e2d\u6807\u8be6\u60c5\u3002", (String)"BidSupplierEntollUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
            DynamicObject supplierstatisticInfo = (DynamicObject)this.getModel().getValue("enrollsupplierstatistic", rowIndex);
            if (supplierstatisticInfo == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4e2d\u6807\u4fe1\u606f", (String)"BidSupplierEntollUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            int wonqty = supplierstatisticInfo.getInt("wonqty");
            if (wonqty > 0) {
                DynamicObject supplierInfo = (DynamicObject)this.getModel().getValue("enrollsupplier", rowIndex);
                HashMap<String, Object> otherParam = new HashMap<String, Object>();
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Object orgid = formShowParameter.getCustomParam("orgid");
                otherParam.put("orgid", orgid);
                if (supplierInfo != null) {
                    otherParam.put("supperid", supplierInfo.getPkValue());
                }
                this.viewBiddingDetails(view, otherParam);
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4e2d\u6807\u4fe1\u606f", (String)"BidSupplierEntollUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void viewBiddingDetails(IFormView view, Map<String, Object> otherParam) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        String billFormId = this.getOpenBillFormId();
        showParameter.setBillFormId(billFormId);
        showParameter.setCustomParams(otherParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getListFilterParameter().setSelectEntity("supplierentry");
        view.showForm((FormShowParameter)showParameter);
    }

    protected String getOpenBillFormId() {
        String split;
        String billFormId = "bid_decisionwinning";
        String formId = this.getView().getFormShowParameter().getFormId();
        if (formId != null && "rebm".equals(split = formId.split("_")[0])) {
            billFormId = "rebm_decisionwinning";
        }
        return billFormId;
    }
}

