/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IAttachmentModel;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidSupplierFileEditUI
extends AbstractBasePlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        boolean tenderGrading = false;
        boolean fromClarifyFlag = false;
        try {
            tenderGrading = (Boolean)this.getView().getFormShowParameter().getCustomParam("tendergrading");
            fromClarifyFlag = (Boolean)this.getView().getFormShowParameter().getCustomParam("fromClarifyFlag");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fromClarifyFlag) {
            String clarifyNewDataId = (String)this.getView().getFormShowParameter().getCustomParam("clarifyNewDataId");
            String attachKey = (String)this.getView().getFormShowParameter().getCustomParam("attachKey");
            String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
            List attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)clarifyNewDataId, (String)attachKey);
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
            attachmentPanel.bindData(attachments);
        } else if (!fromClarifyFlag && param.getCustomParam("isFromBackBid") == null) {
            this.getView().setStatus(OperationStatus.VIEW);
            if (param.getCustomParam("sectionId") != null) {
                this.getModel().setValue("sectionId", param.getCustomParam("sectionId"));
                this.getModel().setValue("supplierId", param.getCustomParam("supplierId"));
            }
            String type = (String)param.getCustomParam("type");
            this.getModel().setValue("type", (Object)type);
            this.getModel().setDataChanged(false);
        } else if (tenderGrading) {
            tenderGrading = (Boolean)this.getView().getFormShowParameter().getCustomParam("tendergrading");
            Long bidOpenId = (Long)this.getView().getFormShowParameter().getCustomParam("bidopenid");
            String sectionName = (String)this.getView().getFormShowParameter().getCustomParam("sectionName");
            Long supplierId = (Long)this.getView().getFormShowParameter().getCustomParam("supplierId");
            String typeName = (String)param.getCustomParam("typeName");
            DynamicObject tempBidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)(this.getAppId() + "_bidopen"), (String)"id,bidsection,sectionname,supplierentry,supplier,supplier_techattach,supplier_comattach");
            if (tempBidOpen != null) {
                DynamicObjectCollection bidSectionCol = tempBidOpen.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidSection : bidSectionCol) {
                    String currentSectionName = bidSection.getString("sectionname");
                    if (!sectionName.equals(currentSectionName)) continue;
                    DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        Long currentSupplierId = supplierEntry.getDynamicObject("supplier").getLong("id");
                        if (!supplierId.equals(currentSupplierId)) continue;
                        ArrayList<DynamicObject> fileList = new ArrayList<DynamicObject>();
                        if ("techattachment".equals(typeName)) {
                            DynamicObjectCollection techAttachCol = supplierEntry.getDynamicObjectCollection("supplier_techattach");
                            techAttachCol.forEach(t -> fileList.add(t.getDynamicObject("fbasedataid")));
                        } else {
                            DynamicObjectCollection comAttachCol = supplierEntry.getDynamicObjectCollection("supplier_comattach");
                            comAttachCol.forEach(t -> fileList.add(t.getDynamicObject("fbasedataid")));
                        }
                        List<Map<String, Object>> attachmentList = this.buildAttachmentDataFromEdit(fileList);
                        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
                        attachmentPanel.bindData(attachmentList);
                    }
                }
            }
        } else {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_close"});
            HashMap<String, String> activeItem = new HashMap<String, String>();
            activeItem.put("l", "4");
            this.getView().updateControlMetadata("attachmentpanelap", activeItem);
            Boolean isHistory = (Boolean)param.getCustomParam("isHistory");
            Boolean isFromBackBid = (Boolean)param.getCustomParam("isFromBackBid");
            if (isFromBackBid != null && isFromBackBid.booleanValue() && isHistory != null && !isHistory.booleanValue()) {
                this.getAttachments(param);
            }
        }
        String billStatus = "";
        billStatus = tenderGrading ? this.getView().getParentView().getParentView().getModel().getDataEntity(true).getString("billstatus") : this.getView().getParentView().getModel().getDataEntity(true).getString("billstatus");
        if (BillStatusEnum.DISBEGIN.getVal().equals(billStatus) || BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"baritemap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_close"});
        }
    }

    private List<Map<String, Object>> buildAttachmentDataFromEdit(List<DynamicObject> fileList) {
        ArrayList<Map<String, Object>> attachDataList = new ArrayList<Map<String, Object>>();
        fileList.forEach(attach -> {
            HashMap<String, Object> attachMap = new HashMap<String, Object>();
            attachMap.put("description", attach.getString("description"));
            attachMap.put("type", attach.getString("type"));
            InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(attach.getString("url"));
            String saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(attach.getString("name"), (InputStream)new BufferedInputStream(inputStream), 7200);
            attachMap.put("url", saveUrl);
            attachMap.put("uid", this.getUid());
            attachMap.put("name", attach.getString("name"));
            attachMap.put("size", attach.get("size"));
            attachMap.put("fattachmentpanel", "attachmentpanel");
            attachMap.put("entityNum", this.getView().getEntityId());
            attachMap.put("billPkId", String.valueOf(this.getModel().getValue("id")));
            attachMap.put("fcreatemen", attach.get("creator"));
            attachMap.put("fmodifytime", attach.get("modifytime"));
            attachMap.put("status", "success");
            attachMap.put("client", null);
            attachDataList.add(attachMap);
        });
        return attachDataList;
    }

    private StringBuffer getUid() {
        StringBuffer uid = new StringBuffer("rc-upload-");
        uid.append(new Date().getTime());
        uid.append('-');
        SecureRandom random = new SecureRandom();
        int index = (int)(1.0 + random.nextDouble() * 10.0);
        uid.append(index);
        return uid;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        if (param.getCustomParam("isFromBackBid") == null) {
            AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
            IAttachmentModel field = panel.getAttachmentModel();
            int size = field.getData(this.getModel(), "attachmentpanelap").size();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("size", size);
            map.put("clickFieldName", param.getCustomParam("clickFieldName"));
            map.put("clickRow", param.getCustomParam("clickRow"));
            map.put("sectionId", this.getModel().getValue("sectionId"));
            map.put("supplierId", param.getCustomParam("supplierId"));
            map.put("billid", param.getCustomParam("bidopenid"));
            this.getView().returnDataToParent(map);
        }
    }

    private void getAttachments(FormShowParameter param) {
        Object isfromrebid;
        DynamicObject onlineBidData;
        Long bidProjectId = (Long)param.getCustomParam("bidProjectId");
        Long supplierId = Long.parseLong(param.getCustomParam("supplierId").toString());
        Long bidPublishId = (Long)param.getCustomParam("bidpublishid");
        String typeName = (String)param.getCustomParam("typeName");
        String sectionName = (String)param.getCustomParam("sectionName");
        QFilter filter = new QFilter("bidproject", "=", (Object)bidProjectId);
        QFilter supplierFilter = new QFilter("supplier", "=", (Object)supplierId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal());
        String onlineBidFormId = this.getTenAppId() + "_" + "online_bid";
        if (bidPublishId != null) {
            QFilter bidPublishIdFilter = new QFilter("bidpublishid", "=", (Object)bidPublishId);
            onlineBidData = BusinessDataServiceHelper.loadSingle((String)onlineBidFormId, (String)"id", (QFilter[])new QFilter[]{filter, supplierFilter, bidPublishIdFilter, statusFilter});
        } else {
            onlineBidData = BusinessDataServiceHelper.loadSingle((String)onlineBidFormId, (String)"id", (QFilter[])new QFilter[]{filter, supplierFilter, statusFilter});
        }
        if (onlineBidData == null && "1".equals(isfromrebid = this.getView().getFormShowParameter().getCustomParam("isfromrebid"))) {
            DynamicObject[] onlineBidDatas = BusinessDataServiceHelper.load((String)onlineBidFormId, (String)"id,rounds", (QFilter[])new QFilter[]{filter, supplierFilter, new QFilter("bidpublishid", "=", (Object)bidPublishId)});
            if (onlineBidDatas == null || onlineBidDatas.length == 0) {
                return;
            }
            for (DynamicObject onlineBid : onlineBidDatas) {
                int oldRounds;
                if (onlineBidData == null) {
                    onlineBidData = onlineBid;
                    continue;
                }
                int rounds = onlineBid.getInt("rounds");
                if (rounds <= (oldRounds = onlineBidData.getInt("rounds"))) continue;
                onlineBidData = onlineBid;
            }
        }
        if (onlineBidData != null) {
            if ("inviteattachment".equals(typeName)) {
                List attachments = AttachmentServiceHelper.getAttachments((String)onlineBidFormId, (Object)onlineBidData.getPkValue(), (String)typeName);
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
                attachmentPanel.bindData(attachments);
            } else {
                String onlineBidDetailFormId = this.getTenAppId() + "_" + "online_bid_detail";
                DynamicObject onlineBidDetail = BusinessDataServiceHelper.loadSingle((String)onlineBidDetailFormId, (String)"id", (QFilter[])new QFilter[]{new QFilter("sectionname", "=", (Object)sectionName), new QFilter("onlinebidid", "=", onlineBidData.getPkValue())});
                if (onlineBidDetail != null) {
                    List attachments = AttachmentServiceHelper.getAttachments((String)onlineBidDetailFormId, (Object)onlineBidDetail.getPkValue(), (String)typeName);
                    AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
                    attachmentPanel.bindData(attachments);
                }
            }
        }
    }

    public String getTenAppId() {
        String appId = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
        if ("rebm".equals(appId)) {
            return "resp";
        }
        return "ten";
    }

    public String getAppId() {
        return ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
    }
}

