/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.BizLog;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.IBidSupplierFileService;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidSupplierFileServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidEvalMethodEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.util.BidDarkUtil;
import kd.scm.bid.formplugin.bill.util.BidEvaluationUtil;
import kd.scm.bid.formplugin.bill.util.TenderGradingUtil;

public class BidTenderGradingEdit
extends AbstractFormPlugin
implements RowClickEventListener,
CellClickListener,
ClickListener {
    protected IBidEvaluationService bidEvaluationService = new BidEvaluationServiceImpl();
    protected TenderGradingUtil tenderGradingUtil = new TenderGradingUtil();
    protected IBidSupplierFileService bidSupplierFileService = new BidSupplierFileServiceImpl();

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        String appId = (String)formShowParameter.getCustomParam("appId");
        Long bidOpenId = (Long)formShowParameter.getCustomParam("bidOpenId");
        EntryAp evalScoreEntryAp = this.tenderGradingUtil.createTenderGradingAp(bidOpenId, appId);
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "tendergrading");
        mapEntry.put("columns", (String)evalScoreEntryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long bidOpenId = (Long)formShowParameter.getCustomParam("bidOpenId");
        String appId = (String)formShowParameter.getCustomParam("appId");
        this.tenderGradingUtil.registerDynamicProps(newMainType, bidOpenId, appId);
        e.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormView formView = (FormView)e.getSource();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String appId = (String)formShowParameter.getCustomParam("appId");
        Long bidOpenId = (Long)formShowParameter.getCustomParam("bidOpenId");
        EntryAp evalScoreEntryAp = this.tenderGradingUtil.createTenderGradingAp(bidOpenId, appId);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("tendergrading");
        List fieldEdits = ((Container)evalScoreEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                Container c = (Container)fieldEdit;
                for (Control control : c.getItems()) {
                    control.setView(this.getView());
                }
                fieldEdit.setView(this.getView());
                entryGrid.getItems().add(c);
                continue;
            }
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
        this.setSupplierEntryLock();
        this.setSupplierEntryVisible();
    }

    public void afterBindData(EventObject e) {
        ComboEdit busEvalResult;
        super.afterBindData(e);
        ComboEdit techEvalResult = (ComboEdit)this.getView().getControl("techevalresult");
        if (techEvalResult != null) {
            techEvalResult.setComboItems(this.getEvalResultComboItemList());
        }
        if ((busEvalResult = (ComboEdit)this.getView().getControl("busevalresult")) != null) {
            busEvalResult.setComboItems(this.getEvalResultComboItemList());
        }
        this.getModel().setDataChanged(false);
        this.setSupplierEntryVisible();
        this.getView().updateView("tenderGradAp");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("tendergrading");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"techevaladvice")) {
            this.receiveLargerText(closedCallBackEvent, "techevaladvice");
        } else if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"bsevaladvice")) {
            this.receiveLargerText(closedCallBackEvent, "bsevaladvice");
        }
    }

    public void receiveLargerText(ClosedCallBackEvent args, String Key) {
        if (args.getReturnData() == null) {
            return;
        }
        String returnData = (String)args.getReturnData();
        DynamicObject parentDataEntity = this.getView().getParentView().getModel().getDataEntity(true);
        DynamicObjectCollection evalTenderSectionCol = parentDataEntity.getDynamicObjectCollection("evaltendersection");
        Object sectionName = this.getView().getFormShowParameter().getCustomParam("sectionName");
        ArrayList<String> seqSet = new ArrayList<String>();
        for (DynamicObject evalTenderSection : evalTenderSectionCol) {
            String evalsectionname = evalTenderSection.getString("evalsectionname");
            if (!sectionName.equals(evalsectionname)) continue;
            DynamicObjectCollection saveadviceList = evalTenderSection.getDynamicObjectCollection("saveadvice");
            String CRO = this.getView().getPageCache().get("row");
            int clickRowCount = Integer.parseInt(CRO);
            seqSet.clear();
            for (DynamicObject saveadvice : saveadviceList) {
                String seq = saveadvice.get("seq").toString();
                seqSet.add(seq);
            }
            if (seqSet.indexOf(String.valueOf(clickRowCount)) != -1) {
                for (DynamicObject saveadvice : saveadviceList) {
                    int seq = (Integer)saveadvice.get("seq");
                    if (seq != clickRowCount) continue;
                    if ("techevaladvice".equals(Key)) {
                        saveadvice.set("savetechevaladvice", (Object)returnData);
                        saveadvice.set("savetechevaladvice_tag", (Object)returnData);
                    } else {
                        saveadvice.set("savebsevaladvice", (Object)returnData);
                        saveadvice.set("savebsevaladvice_tag", (Object)returnData);
                    }
                    break;
                }
            } else {
                DynamicObject dynamicObject = saveadviceList.addNew();
                dynamicObject.set("seq", (Object)clickRowCount);
                if ("techevaladvice".equals(Key)) {
                    dynamicObject.set("savetechevaladvice", (Object)returnData);
                    dynamicObject.set("savetechevaladvice_tag", (Object)returnData);
                } else {
                    dynamicObject.set("savebsevaladvice", (Object)returnData);
                    dynamicObject.set("savebsevaladvice_tag", (Object)returnData);
                }
            }
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            DynamicObjectCollection supplierEntryCol = dataEntity.getDynamicObjectCollection("tendergrading");
            if (Key.equals("techevaladvice")) {
                ((DynamicObject)supplierEntryCol.get(clickRowCount)).set("techevaladvice", (Object)returnData);
                ((DynamicObject)supplierEntryCol.get(clickRowCount)).set("techevaladvice_tag", (Object)returnData);
                continue;
            }
            ((DynamicObject)supplierEntryCol.get(clickRowCount)).set("bsevaladvice", (Object)returnData);
            ((DynamicObject)supplierEntryCol.get(clickRowCount)).set("bsevaladvice_tag", (Object)returnData);
        }
        this.getView().updateView();
        this.getView().getModel().updateCache();
        this.getView().getParentView().getModel().updateCache();
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.equals("techevalresult")) {
            ComboEdit techEvalResultEdit = new ComboEdit();
            techEvalResultEdit.setKey(key);
            techEvalResultEdit.setEntryKey("tendergrading");
            techEvalResultEdit.setView(this.getView());
            e.setControl((Control)techEvalResultEdit);
        } else if (key.equals("busevalresult")) {
            ComboEdit techEvalResultEdit = new ComboEdit();
            techEvalResultEdit.setKey(key);
            techEvalResultEdit.setEntryKey("tendergrading");
            techEvalResultEdit.setView(this.getView());
            e.setControl((Control)techEvalResultEdit);
        }
    }

    public List<ComboItem> getEvalResultComboItemList() {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        ComboItem comboItem1 = new ComboItem();
        comboItem1.setValue("1");
        comboItem1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u683c", (String)"BidTenderGradingEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        comboItemList.add(comboItem1);
        ComboItem comboItem2 = new ComboItem();
        comboItem2.setValue("0");
        comboItem2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u5408\u683c", (String)"BidTenderGradingEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        comboItemList.add(comboItem2);
        return comboItemList;
    }

    public void setSupplierEntryVisible() {
        Long bidOpenId;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String evalType = (String)formShowParameter.getCustomParam("evalType");
        boolean isOnlineEval = (Boolean)formShowParameter.getCustomParam("isOnlineEval");
        boolean isRateBidding = (Boolean)formShowParameter.getCustomParam("isRateBidding");
        String evaluatedMethod = (String)formShowParameter.getCustomParam("evaluatedMethod");
        String appId = (String)formShowParameter.getCustomParam("appId");
        if (BidDarkUtil.isDarkEvaluation((String)appId, (Object)(bidOpenId = (Long)formShowParameter.getCustomParam("bidOpenId")), (String)evalType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"suppliername"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"suppliername_dark"});
        }
        if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)evalType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bsevaladvice", "busevalresult", "busevalresultcollect", "supplier_comfile", "supplier_rate", "supplier_tenderprice", "supplier_taxrate", "supplier_pricevat", "supplier_exceptvat", "purdetail", "supplier_illustration", "float_scale"});
        } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)evalType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_techfile", "techevaladvice", "techevalresult", "techevalresultcollect"});
            if (isRateBidding) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"supplier_rate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"techevaladvice", "techevalresult", "supplier_tenderprice", "supplier_taxrate", "supplier_pricevat", "supplier_exceptvat", "float_scale"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_rate"});
            }
        } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.MULTI.getValue(), (CharSequence)evalType)) {
            if (isRateBidding) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"supplier_rate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_tenderprice", "supplier_taxrate", "supplier_pricevat", "supplier_exceptvat"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_rate"});
            }
        }
        if (BidEvalMethodEnum.DL.getCode().equals(evaluatedMethod)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"techevalresult", "techevalresultcollect", "busevalresult", "busevalresultcollect"});
        }
        if (!isOnlineEval) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"techevalresultcollect", "busevalresultcollect"});
        }
    }

    public void setSupplierEntryLock() {
        String billStatus = this.getView().getParentView().getModel().getDataEntity(true).getString("billstatus");
        if (BillStatusEnum.AUDITING.getVal().equals(billStatus) || BillStatusEnum.AUDITED.getVal().equals(billStatus) || BillStatusEnum.SUBMIT.getVal().equals(billStatus)) {
            DynamicObjectCollection tenderGradingCol = this.getModel().getEntryEntity("tendergrading");
            for (int i = 0; i < tenderGradingCol.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"techevalresult", "busevalresult"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long openSectionId = (Long)formShowParameter.getCustomParam("openSectionId");
        String evalType = (String)formShowParameter.getCustomParam("evalType");
        String fieldKey = e.getProperty().getName();
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        if ("techevalresult".equals(fieldKey) || "busevalresult".equals(fieldKey)) {
            DynamicObjectCollection supplierEntryCol = dataEntity.getDynamicObjectCollection("tendergrading");
            for (DynamicObject supplierEntry : supplierEntryCol) {
                String supplierId = supplierEntry.getString("supplier");
                String techEvalResultKey = TenderGradingUtil.getEvalResultKey("proficient_tech_", openSectionId, supplierId);
                String bsEvalResultKey = TenderGradingUtil.getEvalResultKey("proficient_bus_", openSectionId, supplierId);
                if (StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.MULTI.getValue())) {
                    parentPageCache.put(techEvalResultKey, supplierEntry.getString("techevalresult"));
                    parentPageCache.put(bsEvalResultKey, supplierEntry.getString("busevalresult"));
                    continue;
                }
                if (StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.TECHNICAL.getValue())) {
                    parentPageCache.put(techEvalResultKey, supplierEntry.getString("techevalresult"));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.BUSSINESS.getValue())) continue;
                parentPageCache.put(bsEvalResultKey, supplierEntry.getString("busevalresult"));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.insertTenderGradingRow();
    }

    public void insertTenderGradingRow() {
        DynamicObject bidevalResult_DOCC;
        DynamicObjectCollection bidevalResult_DOC;
        Long opensectid;
        ArrayList list;
        Map map;
        DynamicObject bidprojectInfo;
        String doctype;
        DynamicObject[] tenderGradingDetailLoadArray;
        IPageCache pageCache = this.getView().getPageCache();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        boolean isOnlineEval = (Boolean)formShowParameter.getCustomParam("isOnlineEval");
        String appId = (String)formShowParameter.getCustomParam("appId");
        Long bidOpenId = (Long)formShowParameter.getCustomParam("bidOpenId");
        Long bidEvaluationId = (Long)formShowParameter.getCustomParam("bidEvaluationId");
        Long openSectionId = (Long)formShowParameter.getCustomParam("openSectionId");
        boolean enableMultiSection = (Boolean)formShowParameter.getCustomParam("enableMultiSection");
        String sectionName = (String)formShowParameter.getCustomParam("sectionName");
        String evalType = (String)formShowParameter.getCustomParam("evalType");
        Long bidProject = (Long)formShowParameter.getCustomParam("bidProject");
        HashMap<String, String> tenderGradingDetailMap = new HashMap<String, String>(16);
        for (DynamicObject tenderGradingDetailLoad : tenderGradingDetailLoadArray = BusinessDataServiceHelper.load((String)"bid_tendergradingdetail", (String)"evaluationid,opensectionid,supplierid,techevalresult,busevalresult", (QFilter[])new QFilter[]{new QFilter("evaluationid", "=", (Object)bidEvaluationId)})) {
            String techEvalResultKey = "proficient_tech_" + tenderGradingDetailLoad.get("opensectionid") + "_" + tenderGradingDetailLoad.get("supplierid");
            String busEvalResultKey = "proficient_bus_" + tenderGradingDetailLoad.get("opensectionid") + "_" + tenderGradingDetailLoad.get("supplierid");
            tenderGradingDetailMap.put(techEvalResultKey, tenderGradingDetailLoad.getString("techevalresult"));
            tenderGradingDetailMap.put(busEvalResultKey, tenderGradingDetailLoad.getString("busevalresult"));
        }
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)(appId + "_bidopen"));
        if (bidOpen != null) {
            String bsevaladvice_tag;
            String bsevaladvice;
            Object techevaladvice_tag;
            String techevaladvice;
            Cloneable bsevaladviceSet_tag;
            Cloneable bsevaladviceSet;
            Table darkTable = null;
            if (BidDarkUtil.isDarkEvaluation((String)appId, (Object)bidOpenId, (String)evalType)) {
                darkTable = BidDarkUtil.getEvaluationDark((String)appId, (Object)bidOpenId);
            }
            Map<String, Integer> fileCountMap = this.getBidOpenFileCount(bidOpen);
            DynamicObjectCollection bidOpenSectionCol = bidOpen.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidOpenSection : bidOpenSectionCol) {
                DynamicObject[] currentSectionName = bidOpenSection.getString("sectionname");
                if (!openSectionId.equals(bidOpenSection.getLong("id"))) continue;
                DynamicObjectCollection bidOpenSupplierEntry = bidOpenSection.getDynamicObjectCollection("supplierentry");
                DynamicObjectCollection evalSupplierEntryCol = dataEntity.getDynamicObjectCollection("tendergrading");
                if (bidOpenSupplierEntry != null && bidOpenSupplierEntry.size() > 0) {
                    for (int k = 0; k < bidOpenSupplierEntry.size(); ++k) {
                        DynamicObject openSupplierEntry = (DynamicObject)bidOpenSupplierEntry.get(k);
                        DynamicObject supplier = openSupplierEntry.getDynamicObject("supplier");
                        boolean supplierInvalid = openSupplierEntry.getBoolean("supplier_isinvalid");
                        boolean isTender = openSupplierEntry.getBoolean("supplier_istender");
                        Boolean saveDbFlag = Boolean.FALSE;
                        String techKey = "proficient_tech_" + openSectionId + "_" + supplier.getString("id");
                        String bsKey = "proficient_bus_" + openSectionId + "_" + supplier.getString("id");
                        String techFileKey = String.format("%s_%s_%s", currentSectionName, supplier.getString("id"), "tech");
                        String comFileKey = String.format("%s_%s_%s", currentSectionName, supplier.getString("id"), "com");
                        if (!CollectionUtils.isEmpty(tenderGradingDetailMap) && (tenderGradingDetailMap.containsKey(techKey) || tenderGradingDetailMap.containsKey(bsKey))) {
                            saveDbFlag = Boolean.TRUE;
                        }
                        if ((!isTender || supplierInvalid) && !saveDbFlag.booleanValue()) continue;
                        DynamicObject evalSupplierEntry = evalSupplierEntryCol.addNew();
                        evalSupplierEntry.set("seq", (Object)k);
                        evalSupplierEntry.set("supplier", supplier.getPkValue());
                        evalSupplierEntry.set("bidopensectionid", (Object)openSectionId);
                        evalSupplierEntry.set("sectionname", (Object)sectionName);
                        if (darkTable != null) {
                            evalSupplierEntry.set("suppliername_dark", darkTable.get((Object)sectionName, supplier.getPkValue()));
                        }
                        evalSupplierEntry.set("suppliername", supplier.get("name"));
                        Integer techFileCount = fileCountMap.get(techFileKey) != null ? fileCountMap.get(techFileKey) : Integer.valueOf(0);
                        Integer comFileCount = fileCountMap.get(comFileKey) != null ? fileCountMap.get(comFileKey) : Integer.valueOf(0);
                        evalSupplierEntry.set("supplier_techfile", (Object)techFileCount);
                        evalSupplierEntry.set("supplier_comfile", (Object)comFileCount);
                        evalSupplierEntry.set("supplier_rate", (Object)openSupplierEntry.getBigDecimal("supplier_rate").multiply(new BigDecimal("100")));
                        evalSupplierEntry.set("supplier_tenderprice", (Object)openSupplierEntry.getBigDecimal("supplier_tenderprice"));
                        evalSupplierEntry.set("supplier_taxrate", (Object)openSupplierEntry.getBigDecimal("supplier_taxrate").multiply(new BigDecimal("100")));
                        evalSupplierEntry.set("supplier_pricevat", (Object)openSupplierEntry.getBigDecimal("supplier_pricevat"));
                        evalSupplierEntry.set("supplier_exceptvat", (Object)openSupplierEntry.getBigDecimal("supplier_exceptvat"));
                        evalSupplierEntry.set("isfrombackbid", (Object)openSupplierEntry.getBoolean("supplier_isfrombackbid"));
                        evalSupplierEntry.set("supplier_illustration", (Object)openSupplierEntry.getString("supplier_illustration"));
                        evalSupplierEntry.set("purdetail", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidTenderGradingEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        evalSupplierEntry.set("gradeoperationcolumnap", (Object)ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"BidTenderGradingEdit_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                }
                this.setTechOrBusEvalResult(dataEntity, appId, evalType, bidOpenId, openSectionId, isOnlineEval, tenderGradingDetailMap);
                if (!isOnlineEval) continue;
                this.setTechEvalAndBusResultCollect(dataEntity, appId, bidOpen, openSectionId);
            }
            Map<String, List<DynamicObject>> clarifyNewDataMap = this.getQuestionClarify(bidEvaluationId, appId, evalType);
            if (!CollectionUtils.isEmpty(clarifyNewDataMap)) {
                this.setClarifyNewDataToSupplierEntry(dataEntity, openSectionId, enableMultiSection, clarifyNewDataMap, appId);
            }
            if (isOnlineEval) {
                DynamicObject[] dynamicObject;
                for (DynamicObject object : dynamicObject = BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"bidevaluator,supplier.name,sectionname2,techevaladvice,bsevaladvice,techevaladvice_tag,bsevaladvice_tag", (QFilter[])new QFilter[]{new QFilter("bidProject", "=", (Object)bidProject), new QFilter("billstatus", "=", (Object)"C"), new QFilter("evaltype", "=", (Object)evalType)})) {
                    int i;
                    DynamicObjectCollection bidSectionColl = object.getDynamicObjectCollection("bidsectionenroll");
                    String bidevalautor = object.getDynamicObject("bidevaluator").getString("name");
                    HashMap<Long, String> techevaladviceSet = new HashMap<Long, String>();
                    HashMap<Long, Object> techevaladviceSet_tag = new HashMap<Long, Object>();
                    bsevaladviceSet = new HashMap();
                    bsevaladviceSet_tag = new HashMap();
                    techevaladvice = "";
                    techevaladvice_tag = "";
                    bsevaladvice = "";
                    bsevaladvice_tag = "";
                    DynamicObjectCollection supplierEntryCol = dataEntity.getDynamicObjectCollection("tendergrading");
                    String sectionname = ((DynamicObject)supplierEntryCol.get(0)).getString("sectionname");
                    for (i = 0; i < bidSectionColl.size(); ++i) {
                        String sectionname2 = ((DynamicObject)bidSectionColl.get(i)).getString("sectionname2");
                        DynamicObjectCollection supplierentryCollection = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                        if (!sectionname.equals(sectionname2)) continue;
                        for (DynamicObject supplierentry : supplierentryCollection) {
                            Long supId = supplierentry.getLong("supplier.id");
                            techevaladvice = supplierentry.getString("techevaladvice");
                            techevaladvice_tag = supplierentry.getString("techevaladvice_tag");
                            bsevaladvice = supplierentry.getString("bsevaladvice");
                            bsevaladvice_tag = supplierentry.getString("bsevaladvice_tag");
                            techevaladviceSet.put(supId, techevaladvice);
                            techevaladviceSet_tag.put(supId, techevaladvice_tag);
                            ((HashMap)bsevaladviceSet).put(supId, bsevaladvice);
                            ((HashMap)bsevaladviceSet_tag).put(supId, bsevaladvice_tag);
                        }
                    }
                    for (i = 0; i < supplierEntryCol.size(); ++i) {
                        Long supplierId = ((DynamicObject)supplierEntryCol.get(i)).getLong("supplier");
                        ((DynamicObject)supplierEntryCol.get(i)).set("techevaladvice", (Object)(((DynamicObject)supplierEntryCol.get(i)).get("techevaladvice") + bidevalautor + ":" + (String)techevaladviceSet.get(supplierId) + "\n"));
                        ((DynamicObject)supplierEntryCol.get(i)).set("techevaladvice_tag", (Object)(((DynamicObject)supplierEntryCol.get(i)).get("techevaladvice_tag") + bidevalautor + ":" + (String)techevaladviceSet_tag.get(supplierId) + "\n"));
                        ((DynamicObject)supplierEntryCol.get(i)).set("bsevaladvice", (Object)(((DynamicObject)supplierEntryCol.get(i)).get("bsevaladvice") + bidevalautor + ":" + (String)((HashMap)bsevaladviceSet).get(supplierId) + "\n"));
                        ((DynamicObject)supplierEntryCol.get(i)).set("bsevaladvice_tag", (Object)(((DynamicObject)supplierEntryCol.get(i)).get("bsevaladvice_tag") + bidevalautor + ":" + (String)((HashMap)bsevaladviceSet_tag).get(supplierId) + "\n"));
                    }
                }
            } else {
                DynamicObject parentDataEntity = this.getView().getParentView().getModel().getDataEntity(true);
                DynamicObjectCollection evalTenderSectionCol = parentDataEntity.getDynamicObjectCollection("evaltendersection");
                ArrayList<String> techevaladviceSet = new ArrayList<String>();
                for (DynamicObject evalTenderSection : evalTenderSectionCol) {
                    if (!openSectionId.equals(evalTenderSection.getLong("opensectionid"))) continue;
                    DynamicObjectCollection saveadviceList = evalTenderSection.getDynamicObjectCollection("saveadvice");
                    DynamicObjectCollection supplierEntryCol = dataEntity.getDynamicObjectCollection("tendergrading");
                    techevaladviceSet.clear();
                    ArrayList<String> seqSet = new ArrayList<String>();
                    ArrayList<Object> techevaladviceSet_tag = new ArrayList<Object>();
                    bsevaladviceSet = new ArrayList();
                    bsevaladviceSet_tag = new ArrayList();
                    techevaladvice = "";
                    techevaladvice_tag = "";
                    bsevaladvice = "";
                    bsevaladvice_tag = "";
                    String seq = "";
                    for (DynamicObject svaeadvice : saveadviceList) {
                        seq = svaeadvice.get("seq").toString();
                        techevaladvice = (String)svaeadvice.get("savetechevaladvice");
                        techevaladvice_tag = (String)svaeadvice.get("savetechevaladvice_tag");
                        bsevaladvice = (String)svaeadvice.get("savebsevaladvice");
                        bsevaladvice_tag = (String)svaeadvice.get("savebsevaladvice_tag");
                        seqSet.add(seq);
                        techevaladviceSet.add(techevaladvice);
                        techevaladviceSet_tag.add(techevaladvice_tag);
                        bsevaladviceSet.add(bsevaladvice);
                        bsevaladviceSet_tag.add(bsevaladvice_tag);
                    }
                    for (int i = 0; i < supplierEntryCol.size(); ++i) {
                        int index = seqSet.indexOf(String.valueOf(i));
                        if (index != -1) {
                            ((DynamicObject)supplierEntryCol.get(i)).set("techevaladvice", techevaladviceSet.get(index));
                            ((DynamicObject)supplierEntryCol.get(i)).set("techevaladvice_tag", techevaladviceSet_tag.get(index));
                            ((DynamicObject)supplierEntryCol.get(i)).set("bsevaladvice", bsevaladviceSet.get(index));
                            ((DynamicObject)supplierEntryCol.get(i)).set("bsevaladvice_tag", bsevaladviceSet_tag.get(index));
                            continue;
                        }
                        ((DynamicObject)supplierEntryCol.get(i)).set("techevaladvice", (Object)"");
                        ((DynamicObject)supplierEntryCol.get(i)).set("techevaladvice_tag", (Object)"");
                        ((DynamicObject)supplierEntryCol.get(i)).set("bsevaladvice", (Object)"");
                        ((DynamicObject)supplierEntryCol.get(i)).set("bsevaladvice_tag", (Object)"");
                    }
                }
            }
        }
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = this.getView().getParentView().getModel();
        String evalMethod = parentModel.getValue("evaluatedmethod").toString();
        String evaltype = parentModel.getValue("evaltype").toString();
        DynamicObjectCollection tenderGradingCol = dataEntity.getDynamicObjectCollection("tendergrading");
        HashMap mapSupplier = new HashMap();
        String bidopensectionid = "";
        for (DynamicObject tenderGradingInfo : tenderGradingCol) {
            String supplierId = tenderGradingInfo.getString("supplier");
            bidopensectionid = tenderGradingInfo.getString("bidopensectionid");
            String techevalresult = tenderGradingInfo.getString("techevalresult");
            String busevalresult = tenderGradingInfo.getString("busevalresult");
            Map supplierMap = (Map)mapSupplier.get(supplierId);
            if (!CollectionUtils.isEmpty((Map)supplierMap)) {
                supplierMap.put("technicalresult", techevalresult);
                supplierMap.put("commercialresult", busevalresult);
                continue;
            }
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("technicalresult", techevalresult);
            map2.put("commercialresult", busevalresult);
            mapSupplier.put(supplierId, map2);
        }
        DynamicObject bidEvaluation = parentModel.getDataEntity();
        final boolean isBussiness = BidEvaluationUtil.getIsBussiness(evalMethod, evaltype, bidEvaluation);
        final DynamicObject evaobject = parentModel.getDataEntity(true).getDynamicObject("evaluatedecideway");
        boolean isMulit = false;
        if (!StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL.getCode()) && evaltype.equals("BUSSINESS") && (doctype = (bidprojectInfo = bidEvaluation.getDynamicObject("bidproject")).getString("doctype")) != null && !doctype.equals("") && doctype.equals("MULTI")) {
            isMulit = true;
        }
        DynamicObjectCollection bidsectionenrollCol = parentModel.getDataEntity(true).getDynamicObjectCollection("bidsectionenroll");
        for (DynamicObject bidSectionenroll_DO : bidsectionenrollCol) {
            Long opensectid2 = bidSectionenroll_DO.getLong("opensectid");
            if (!opensectid2.toString().equals(bidopensectionid)) continue;
            DynamicObjectCollection bidevalResult_DOC2 = bidSectionenroll_DO.getDynamicObjectCollection("bidevalresult");
            for (DynamicObject bidevalResult_DOCC2 : bidevalResult_DOC2) {
                String supplierId = bidevalResult_DOCC2.getDynamicObject("supplier").getPkValue().toString();
                map = (Map)mapSupplier.get(supplierId);
                if (CollectionUtils.isEmpty((Map)map)) continue;
                map.put("supplier", bidevalResult_DOCC2.get("supplier"));
                map.put("suppliername", bidevalResult_DOCC2.get("suppliername"));
                map.put("suppliernumber", bidevalResult_DOCC2.get("suppliernumber"));
                map.put("tenderprice", bidevalResult_DOCC2.get("tenderprice"));
                map.put("technicalscore", bidevalResult_DOCC2.get("technicalscore"));
                map.put("commercialscore", bidevalResult_DOCC2.get("commercialscore"));
                map.put("comprehensivescore", bidevalResult_DOCC2.get("score"));
                if (isMulit) {
                    map.put("technicalresult", bidevalResult_DOCC2.get("technicalresult"));
                }
                map.put("candidate", bidevalResult_DOCC2.get("candidate"));
                map.put("remark", bidevalResult_DOCC2.get("remark"));
            }
        }
        if (StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DX.getCode())) {
            list = new ArrayList(mapSupplier.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, Map<String, Object>>>(){

                @Override
                public int compare(Map.Entry<String, Map<String, Object>> o1, Map.Entry<String, Map<String, Object>> o2) {
                    Map<String, Object> map1 = o1.getValue();
                    Map<String, Object> map2 = o2.getValue();
                    BigDecimal tenderPrice1 = (BigDecimal)map1.get("tenderprice");
                    BigDecimal tenderPrice2 = (BigDecimal)map2.get("tenderprice");
                    String techevalresult1 = (String)map1.get("technicalresult");
                    String busevalresult1 = (String)map1.get("commercialresult");
                    String techevalresult2 = (String)map2.get("technicalresult");
                    String busevalresult2 = (String)map2.get("commercialresult");
                    if (tenderPrice1 == null) {
                        tenderPrice1 = BigDecimal.ZERO;
                    }
                    if (tenderPrice2 == null) {
                        tenderPrice2 = BigDecimal.ZERO;
                    }
                    if (techevalresult1 == null || techevalresult1.equals("")) {
                        techevalresult1 = "0";
                    }
                    if (techevalresult2 == null || techevalresult2.equals("")) {
                        techevalresult2 = "0";
                    }
                    if (busevalresult1 == null || busevalresult1.equals("")) {
                        busevalresult1 = "0";
                    }
                    if (busevalresult2 == null || busevalresult2.equals("")) {
                        busevalresult2 = "0";
                    }
                    if (isBussiness) {
                        if (busevalresult1.equals("0") && busevalresult2.equals("0")) {
                            return tenderPrice1.compareTo(tenderPrice2);
                        }
                        if (busevalresult1.equals("0") && busevalresult2.equals("1")) {
                            return 1;
                        }
                        if (busevalresult1.equals("1") && busevalresult2.equals("0")) {
                            return -1;
                        }
                        if (busevalresult1.equals("1") && busevalresult2.equals("1")) {
                            return tenderPrice1.compareTo(tenderPrice2);
                        }
                    } else {
                        if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                            return 0;
                        }
                        if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && techevalresult2.equals("1") && busevalresult2.equals("1")) {
                            return 1;
                        }
                        if (techevalresult1.equals("1") && busevalresult1.equals("1") && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                            return -1;
                        }
                        if (techevalresult1.equals("1") && busevalresult1.equals("1") && techevalresult2.equals("1") && busevalresult2.equals("1")) {
                            return tenderPrice1.compareTo(tenderPrice2);
                        }
                    }
                    return 0;
                }
            });
            for (DynamicObject bidSectionenroll_DO : bidsectionenrollCol) {
                opensectid = bidSectionenroll_DO.getLong("opensectid");
                if (!opensectid.toString().equals(bidopensectionid)) continue;
                bidevalResult_DOC = bidSectionenroll_DO.getDynamicObjectCollection("bidevalresult");
                for (int i = 0; i < bidevalResult_DOC.size(); ++i) {
                    bidevalResult_DOCC = (DynamicObject)bidevalResult_DOC.get(i);
                    map = null;
                    if (list.size() == bidevalResult_DOC.size()) {
                        map = (Map)((Map.Entry)list.get(i)).getValue();
                    } else {
                        String toString = bidevalResult_DOCC.getDynamicObject("supplier").getPkValue().toString();
                        Optional<Map> findFirst = list.stream().filter(l -> {
                            Map value = (Map)l.getValue();
                            DynamicObject supplier = (DynamicObject)value.get("supplier");
                            if (supplier == null) {
                                return false;
                            }
                            return StringUtils.equals((CharSequence)toString, (CharSequence)supplier.getPkValue().toString());
                        }).map(l -> (Map)l.getValue()).findFirst();
                        if (findFirst.isPresent()) {
                            map = findFirst.get();
                        }
                        if (map == null || map.size() == 0) continue;
                    }
                    bidevalResult_DOCC.set("supplier", map.get("supplier"));
                    bidevalResult_DOCC.set("suppliername", map.get("suppliername"));
                    bidevalResult_DOCC.set("suppliernumber", map.get("suppliernumber"));
                    bidevalResult_DOCC.set("technicalresult", map.get("technicalresult"));
                    bidevalResult_DOCC.set("commercialresult", map.get("commercialresult"));
                    bidevalResult_DOCC.set("tenderprice", map.get("tenderprice"));
                    bidevalResult_DOCC.set("technicalscore", map.get("technicalscore"));
                    bidevalResult_DOCC.set("commercialscore", map.get("commercialscore"));
                    bidevalResult_DOCC.set("score", map.get("comprehensivescore"));
                    bidevalResult_DOCC.set("ranking", (Object)(i + 1));
                    bidevalResult_DOCC.set("candidate", map.get("candidate"));
                    bidevalResult_DOCC.set("remark", map.get("remark"));
                }
            }
        } else if (StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL.getCode())) {
            list = new ArrayList(mapSupplier.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, Map<String, Object>>>(){

                @Override
                public int compare(Map.Entry<String, Map<String, Object>> o1, Map.Entry<String, Map<String, Object>> o2) {
                    Map<String, Object> map1 = o1.getValue();
                    Map<String, Object> map2 = o2.getValue();
                    BigDecimal comprehensivescore1 = (BigDecimal)map1.get("comprehensivescore");
                    BigDecimal comprehensivescore2 = (BigDecimal)map2.get("comprehensivescore");
                    BigDecimal tenderPrice1 = (BigDecimal)map1.get("tenderprice");
                    BigDecimal tenderPrice2 = (BigDecimal)map2.get("tenderprice");
                    if (tenderPrice1 == null) {
                        tenderPrice1 = BigDecimal.ZERO;
                    }
                    if (tenderPrice2 == null) {
                        tenderPrice2 = BigDecimal.ZERO;
                    }
                    if (comprehensivescore1 == null) {
                        comprehensivescore1 = BigDecimal.ZERO;
                    }
                    if (comprehensivescore2 == null) {
                        comprehensivescore2 = BigDecimal.ZERO;
                    }
                    if (evaobject != null) {
                        String evaname = evaobject.getString("name");
                        Long typeId = evaobject.getLong("id");
                        if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                            return tenderPrice1.compareTo(tenderPrice2);
                        }
                    }
                    if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                        return tenderPrice1.compareTo(tenderPrice2);
                    }
                    return comprehensivescore2.compareTo(comprehensivescore1);
                }
            });
            for (DynamicObject bidSectionenroll_DO : bidsectionenrollCol) {
                opensectid = bidSectionenroll_DO.getLong("opensectid");
                if (!opensectid.toString().equals(bidopensectionid)) continue;
                bidevalResult_DOC = bidSectionenroll_DO.getDynamicObjectCollection("bidevalresult");
                for (int i = 0; i < bidevalResult_DOC.size(); ++i) {
                    bidevalResult_DOCC = (DynamicObject)bidevalResult_DOC.get(i);
                    map = null;
                    if (list.size() == bidevalResult_DOC.size()) {
                        map = (Map)((Map.Entry)list.get(i)).getValue();
                    } else {
                        String toString = bidevalResult_DOCC.getDynamicObject("supplier").getPkValue().toString();
                        map = list.stream().filter(l -> {
                            Map value = (Map)l.getValue();
                            DynamicObject supplier = (DynamicObject)value.get("supplier");
                            if (supplier == null) {
                                return false;
                            }
                            return StringUtils.equals((CharSequence)toString, (CharSequence)supplier.getPkValue().toString());
                        }).map(l -> (Map)l.getValue()).findFirst().get();
                        if (map == null || map.size() == 0) continue;
                    }
                    bidevalResult_DOCC.set("supplier", map.get("supplier"));
                    bidevalResult_DOCC.set("suppliername", map.get("suppliername"));
                    bidevalResult_DOCC.set("suppliernumber", map.get("suppliernumber"));
                    bidevalResult_DOCC.set("technicalresult", map.get("technicalresult"));
                    bidevalResult_DOCC.set("commercialresult", map.get("commercialresult"));
                    bidevalResult_DOCC.set("tenderprice", map.get("tenderprice"));
                    bidevalResult_DOCC.set("technicalscore", map.get("technicalscore"));
                    bidevalResult_DOCC.set("commercialscore", map.get("commercialscore"));
                    bidevalResult_DOCC.set("score", map.get("comprehensivescore"));
                    bidevalResult_DOCC.set("ranking", (Object)(i + 1));
                    bidevalResult_DOCC.set("candidate", map.get("candidate"));
                    bidevalResult_DOCC.set("remark", map.get("remark"));
                }
            }
        } else if (StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL_DX.getCode())) {
            list = new ArrayList(mapSupplier.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, Map<String, Object>>>(){

                @Override
                public int compare(Map.Entry<String, Map<String, Object>> o1, Map.Entry<String, Map<String, Object>> o2) {
                    Map<String, Object> map1 = o1.getValue();
                    Map<String, Object> map2 = o2.getValue();
                    BigDecimal comprehensivescore1 = (BigDecimal)map1.get("comprehensivescore");
                    BigDecimal comprehensivescore2 = (BigDecimal)map2.get("comprehensivescore");
                    String techevalresult1 = (String)map1.get("technicalresult");
                    String busevalresult1 = (String)map1.get("commercialresult");
                    String techevalresult2 = (String)map2.get("technicalresult");
                    String busevalresult2 = (String)map2.get("commercialresult");
                    BigDecimal tenderPrice1 = (BigDecimal)map1.get("tenderprice");
                    BigDecimal tenderPrice2 = (BigDecimal)map2.get("tenderprice");
                    if (tenderPrice1 == null) {
                        tenderPrice1 = BigDecimal.ZERO;
                    }
                    if (tenderPrice2 == null) {
                        tenderPrice2 = BigDecimal.ZERO;
                    }
                    if (comprehensivescore1 == null) {
                        comprehensivescore1 = BigDecimal.ZERO;
                    }
                    if (comprehensivescore2 == null) {
                        comprehensivescore2 = BigDecimal.ZERO;
                    }
                    if (techevalresult1 == null || techevalresult1.equals("")) {
                        techevalresult1 = "0";
                    }
                    if (techevalresult2 == null || techevalresult2.equals("")) {
                        techevalresult2 = "0";
                    }
                    if (busevalresult1 == null || busevalresult1.equals("")) {
                        busevalresult1 = "0";
                    }
                    if (busevalresult2 == null || busevalresult2.equals("")) {
                        busevalresult2 = "0";
                    }
                    if (isBussiness) {
                        if (busevalresult1.equals("0") && busevalresult2.equals("0")) {
                            if (evaobject != null) {
                                String evaname = evaobject.getString("name");
                                Long typeId = evaobject.getLong("id");
                                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                                    return tenderPrice1.compareTo(tenderPrice2);
                                }
                            }
                            if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                            return comprehensivescore2.compareTo(comprehensivescore1);
                        }
                        if (busevalresult1.equals("0") && busevalresult2.equals("1")) {
                            return 1;
                        }
                        if (busevalresult1.equals("1") && busevalresult2.equals("0")) {
                            return -1;
                        }
                        if (busevalresult1.equals("1") && busevalresult2.equals("1")) {
                            if (evaobject != null) {
                                String evaname = evaobject.getString("name");
                                Long typeId = evaobject.getLong("id");
                                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                                    return tenderPrice1.compareTo(tenderPrice2);
                                }
                            }
                            if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                            return comprehensivescore2.compareTo(comprehensivescore1);
                        }
                    } else {
                        if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                            if (evaobject != null) {
                                String evaname = evaobject.getString("name");
                                Long typeId = evaobject.getLong("id");
                                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                                    return tenderPrice1.compareTo(tenderPrice2);
                                }
                            }
                            if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                            return comprehensivescore2.compareTo(comprehensivescore1);
                        }
                        if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && techevalresult2.equals("1") && busevalresult2.equals("1")) {
                            return 1;
                        }
                        if (techevalresult1.equals("1") && busevalresult1.equals("1") && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                            return -1;
                        }
                        if (techevalresult1.equals("1") && busevalresult1.equals("1") && (techevalresult2.equals("1") || busevalresult2.equals("1"))) {
                            if (evaobject != null) {
                                String evaname = evaobject.getString("name");
                                Long typeId = evaobject.getLong("id");
                                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                                    return tenderPrice1.compareTo(tenderPrice2);
                                }
                            }
                            if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                            return comprehensivescore2.compareTo(comprehensivescore1);
                        }
                    }
                    return 0;
                }
            });
            for (DynamicObject bidSectionenroll_DO : bidsectionenrollCol) {
                opensectid = bidSectionenroll_DO.getLong("opensectid");
                if (!opensectid.toString().equals(bidopensectionid)) continue;
                bidevalResult_DOC = bidSectionenroll_DO.getDynamicObjectCollection("bidevalresult");
                for (int i = 0; i < bidevalResult_DOC.size(); ++i) {
                    bidevalResult_DOCC = (DynamicObject)bidevalResult_DOC.get(i);
                    map = null;
                    if (list.size() == bidevalResult_DOC.size()) {
                        map = (Map)((Map.Entry)list.get(i)).getValue();
                    } else {
                        String toString = bidevalResult_DOCC.getDynamicObject("supplier").getPkValue().toString();
                        map = list.stream().filter(l -> {
                            Map value = (Map)l.getValue();
                            DynamicObject supplier = (DynamicObject)value.get("supplier");
                            if (supplier == null) {
                                return false;
                            }
                            return StringUtils.equals((CharSequence)toString, (CharSequence)supplier.getPkValue().toString());
                        }).map(l -> (Map)l.getValue()).findFirst().get();
                        if (map == null || map.size() == 0) continue;
                    }
                    bidevalResult_DOCC.set("supplier", map.get("supplier"));
                    bidevalResult_DOCC.set("suppliername", map.get("suppliername"));
                    bidevalResult_DOCC.set("suppliernumber", map.get("suppliernumber"));
                    bidevalResult_DOCC.set("technicalresult", map.get("technicalresult"));
                    bidevalResult_DOCC.set("commercialresult", map.get("commercialresult"));
                    bidevalResult_DOCC.set("tenderprice", map.get("tenderprice"));
                    bidevalResult_DOCC.set("technicalscore", map.get("technicalscore"));
                    bidevalResult_DOCC.set("commercialscore", map.get("commercialscore"));
                    bidevalResult_DOCC.set("score", map.get("comprehensivescore"));
                    bidevalResult_DOCC.set("ranking", (Object)(i + 1));
                    bidevalResult_DOCC.set("candidate", map.get("candidate"));
                    bidevalResult_DOCC.set("remark", map.get("remark"));
                }
            }
        }
        parentView.updateView("bidevalresult");
        this.getView().sendFormAction(parentView);
    }

    public Map<String, Integer> getBidOpenFileCount(DynamicObject tempBidOpen) {
        HashMap<String, Integer> fileCountMap = new HashMap<String, Integer>();
        DynamicObjectCollection bidSectionCol = tempBidOpen.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidSection : bidSectionCol) {
            String currentSectionName = bidSection.getString("sectionname");
            DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryCol) {
                Long currentSupplierId = supplierEntry.getDynamicObject("supplier").getLong("id");
                String techKey = String.format("%s_%s_%s", currentSectionName, currentSupplierId, "tech");
                String comKey = String.format("%s_%s_%s", currentSectionName, currentSupplierId, "com");
                DynamicObjectCollection techAttachCol = supplierEntry.getDynamicObjectCollection("supplier_techattach");
                fileCountMap.put(techKey, techAttachCol.size());
                DynamicObjectCollection comAttachCol = supplierEntry.getDynamicObjectCollection("supplier_comattach");
                fileCountMap.put(comKey, comAttachCol.size());
            }
        }
        return fileCountMap;
    }

    public void setTechEvalAndBusResultCollect(DynamicObject dataEntity, String appId, DynamicObject bidOpen, Long openSectionId) {
        Map onlineEvalResult = this.bidEvaluationService.getOnlineEvalResult(appId, new QFilter[]{new QFilter("bidopenid", "=", bidOpen.getPkValue()), new QFilter("bidsection.opensrcsectionid", "=", (Object)openSectionId), new QFilter("billstatus", "=", (Object)"C")});
        HashSet<String> evaluatorIdSet = new HashSet<String>();
        DynamicObjectCollection proficientCol = bidOpen.getDynamicObjectCollection("bidopen_proficient");
        for (DynamicObject proficientEntry : proficientCol) {
            DynamicObject proficient = proficientEntry.getDynamicObject("proficient");
            if (proficient == null) continue;
            evaluatorIdSet.add(proficient.getString("id"));
        }
        DynamicObjectCollection supplierEntryCol = dataEntity.getDynamicObjectCollection("tendergrading");
        for (DynamicObject supplierEntry : supplierEntryCol) {
            if (!openSectionId.equals(supplierEntry.getLong("bidopensectionid"))) continue;
            String supplierId = supplierEntry.getString("supplier");
            for (String evaluatorId : evaluatorIdSet) {
                String bsKey;
                Object bsEvaluatorEvalResult;
                String techKey = "proficient_tech_" + openSectionId + "_" + evaluatorId + "_" + supplierId;
                Object techEvaluatorEvalResult = onlineEvalResult.get(techKey);
                if (techEvaluatorEvalResult != null) {
                    supplierEntry.set("proficient_tech_" + evaluatorId, techEvaluatorEvalResult);
                }
                if ((bsEvaluatorEvalResult = onlineEvalResult.get(bsKey = "proficient_bus_" + openSectionId + "_" + evaluatorId + "_" + supplierId)) == null) continue;
                supplierEntry.set("proficient_bus_" + evaluatorId, bsEvaluatorEvalResult);
            }
        }
    }

    public void setTechOrBusEvalResult(DynamicObject dataEntity, String appId, String evalType, Long bidOpenId, Long openSectionId, boolean isOnlineEval, Map<String, String> tenderGradingDetailMap) {
        DynamicObjectCollection supplierEntryCol = dataEntity.getDynamicObjectCollection("tendergrading");
        for (DynamicObject supplierEntry : supplierEntryCol) {
            String bsEvalResult;
            if (!openSectionId.equals(supplierEntry.getLong("bidopensectionid"))) continue;
            String supplierId = supplierEntry.getString("supplier");
            IPageCache parentPageCache = this.getView().getParentView().getPageCache();
            String techEvalResultKey = TenderGradingUtil.getEvalResultKey("proficient_tech_", openSectionId, supplierId);
            String bsEvalResultKey = TenderGradingUtil.getEvalResultKey("proficient_bus_", openSectionId, supplierId);
            String techEvalResult = parentPageCache.get(techEvalResultKey);
            if (StringUtils.isEmpty((CharSequence)techEvalResult) && !CollectionUtils.isEmpty(tenderGradingDetailMap)) {
                techEvalResult = tenderGradingDetailMap.get(techEvalResultKey);
            }
            if (StringUtils.isEmpty((CharSequence)(bsEvalResult = parentPageCache.get(bsEvalResultKey))) && !CollectionUtils.isEmpty(tenderGradingDetailMap)) {
                bsEvalResult = tenderGradingDetailMap.get(bsEvalResultKey);
            }
            if (isOnlineEval && (StringUtils.isEmpty((CharSequence)techEvalResult) || StringUtils.isEmpty((CharSequence)bsEvalResult))) {
                Map onlineEvalResult = this.bidEvaluationService.getOnlineEvalResult(appId, new QFilter[]{new QFilter("bidopenid", "=", (Object)bidOpenId), new QFilter("bidsection.opensrcsectionid", "=", (Object)openSectionId), new QFilter("billstatus", "=", (Object)"C")});
                if (StringUtils.isEmpty((CharSequence)techEvalResult) && !CollectionUtils.isEmpty((Map)onlineEvalResult) && onlineEvalResult.get(techEvalResultKey) != null) {
                    techEvalResult = onlineEvalResult.get(techEvalResultKey).toString();
                }
                if (StringUtils.isEmpty((CharSequence)bsEvalResult) && onlineEvalResult.get(bsEvalResultKey) != null) {
                    bsEvalResult = onlineEvalResult.get(bsEvalResultKey).toString();
                }
            }
            techEvalResult = StringUtils.isEmpty((CharSequence)techEvalResult) ? "1" : techEvalResult;
            String string = bsEvalResult = StringUtils.isEmpty((CharSequence)bsEvalResult) ? "1" : bsEvalResult;
            if (StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.MULTI.getValue())) {
                supplierEntry.set("techevalresult", (Object)techEvalResult);
                supplierEntry.set("busevalresult", (Object)bsEvalResult);
                continue;
            }
            if (StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.TECHNICAL.getValue())) {
                supplierEntry.set("techevalresult", (Object)techEvalResult);
                continue;
            }
            if (!StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.BUSSINESS.getValue())) continue;
            supplierEntry.set("busevalresult", (Object)bsEvalResult);
        }
    }

    public void setClarifyNewDataToSupplierEntry(DynamicObject dataEntity, Long openSectionId, boolean enableMultiSection, Map<String, List<DynamicObject>> clarifyNewDataMap, String appId) {
        IPageCache pageCache = this.getView().getPageCache();
        DynamicObjectCollection supplierEntryCol = dataEntity.getDynamicObjectCollection("tendergrading");
        for (DynamicObject supplierEntry : supplierEntryCol) {
            String supplierId = supplierEntry.getString("supplier");
            String supplierName = supplierEntry.getString("suppliername");
            String sectionName = supplierEntry.getString("sectionname");
            String key = supplierId + "&&" + supplierName + "&&" + sectionName;
            List<DynamicObject> clarifyNewDataList = clarifyNewDataMap.get(key);
            if (CollectionUtils.isEmpty(clarifyNewDataList) && (enableMultiSection || CollectionUtils.isEmpty(clarifyNewDataList = clarifyNewDataMap.get(supplierId + "&&" + supplierName + "&&")))) continue;
            String cacheKeySuffix = sectionName + "_" + supplierId;
            for (DynamicObject clarifyNewData : clarifyNewDataList) {
                clarifyNewData = BusinessDataServiceHelper.loadSingle((Object)clarifyNewData.getPkValue(), (String)(appId + "_questionclarify"));
                String clarifyType = clarifyNewData.getString("clarifytype");
                if (BidOpenTypeEnum.TECHNICAL.getValue().equals(clarifyType)) {
                    List techAttachments = AttachmentServiceHelper.getAttachments((String)clarifyNewData.getDynamicObjectType().getName(), (Object)clarifyNewData.getPkValue(), (String)"techattachment");
                    supplierEntry.set("supplier_techfile", (Object)techAttachments.size());
                    pageCache.put("technical_" + cacheKeySuffix, clarifyNewData.getString("id"));
                    continue;
                }
                List comAttachments = AttachmentServiceHelper.getAttachments((String)clarifyNewData.getDynamicObjectType().getName(), (Object)clarifyNewData.getPkValue(), (String)"commercattachment");
                if (BidOpenTypeEnum.MULTI.getValue().equals(clarifyType)) {
                    List techAttachments = AttachmentServiceHelper.getAttachments((String)clarifyNewData.getDynamicObjectType().getName(), (Object)clarifyNewData.getPkValue(), (String)"techattachment");
                    supplierEntry.set("supplier_comfile", (Object)comAttachments.size());
                    supplierEntry.set("supplier_techfile", (Object)techAttachments.size());
                    pageCache.put("commercial_" + cacheKeySuffix, clarifyNewData.getString("id"));
                    pageCache.put("technical_" + cacheKeySuffix, clarifyNewData.getString("id"));
                } else {
                    supplierEntry.set("supplier_comfile", (Object)comAttachments.size());
                    pageCache.put("commercial_" + cacheKeySuffix, clarifyNewData.getString("id"));
                }
                supplierEntry.set("supplier_tenderprice", (Object)clarifyNewData.getBigDecimal("tenderprice"));
                supplierEntry.set("supplier_taxrate", (Object)clarifyNewData.getBigDecimal("pricevat").multiply(new BigDecimal(100)));
                supplierEntry.set("supplier_pricevat", clarifyNewData.get("tax"));
                supplierEntry.set("supplier_exceptvat", (Object)clarifyNewData.getBigDecimal("notaxtenderprice"));
                supplierEntry.set("supplier_rate", clarifyNewData.get("rate"));
                DynamicObject parentDataEntity = this.getView().getParentView().getModel().getDataEntity(true);
                DynamicObjectCollection evalTenderSectionCol = parentDataEntity.getDynamicObjectCollection("evaltendersection");
                for (DynamicObject evalTenderSection : evalTenderSectionCol) {
                    DynamicObject biddingDetailMaterial;
                    DynamicObject supplier;
                    if (!openSectionId.equals(evalTenderSection.getLong("opensectionid"))) continue;
                    DynamicObjectCollection supplierDetailList = evalTenderSection.getDynamicObjectCollection("supplierdetail");
                    DynamicObjectCollection clarifySupplierDetailCol = null;
                    DynamicObjectCollection clarifyBidSectionCol = clarifyNewData.getDynamicObjectCollection("bidsection");
                    for (DynamicObject clarifyBidSection : clarifyBidSectionCol) {
                        String evlaSectionName;
                        String clarifySectionName = clarifyBidSection.getString("sectionname");
                        if (!StringUtils.equals((CharSequence)clarifySectionName, (CharSequence)(evlaSectionName = evalTenderSection.getString("evalsectionname")))) continue;
                        clarifySupplierDetailCol = clarifyBidSection.getDynamicObjectCollection("supplierdetail");
                        break;
                    }
                    if (clarifySupplierDetailCol == null) continue;
                    HashMap<String, DynamicObject> supplierDetailMap = new HashMap<String, DynamicObject>();
                    if (clarifySupplierDetailCol == null) continue;
                    for (DynamicObject supplierDetail : clarifySupplierDetailCol) {
                        supplier = supplierDetail.getDynamicObject("pursupplier");
                        biddingDetailMaterial = supplierDetail.getDynamicObject("materialid");
                        if (supplier == null) continue;
                        String purEntryContent = supplierDetail.getString("purentrycontent");
                        if (StringUtils.isBlank((CharSequence)purEntryContent) || "null".equals(purEntryContent)) {
                            purEntryContent = "";
                        }
                        String supplierDetailKey = sectionName + supplier.getString("id") + '_' + purEntryContent + '_' + (biddingDetailMaterial == null ? "" : biddingDetailMaterial.getPkValue()) + '_' + (supplierDetail.getDynamicObject("purentryproject") == null ? "" : supplierDetail.getDynamicObject("purentryproject").getString("id")) + '_' + (supplierDetail.getString("materialdes") == null ? "" : supplierDetail.getString("materialdes"));
                        supplierDetailMap.put(supplierDetailKey, supplierDetail);
                    }
                    if (supplierDetailMap == null || CollectionUtils.isEmpty(supplierDetailMap)) continue;
                    for (DynamicObject supplierDetail : supplierDetailList) {
                        String supplierDetailKey;
                        DynamicObject clarifySupplierDetail;
                        supplier = supplierDetail.getDynamicObject("pursupplier");
                        biddingDetailMaterial = supplierDetail.getDynamicObject("materialid");
                        if (supplier == null || (clarifySupplierDetail = (DynamicObject)supplierDetailMap.get(supplierDetailKey = sectionName + supplier.getString("id") + '_' + supplierDetail.getString("purentrycontent") + '_' + (biddingDetailMaterial == null ? "" : biddingDetailMaterial.getPkValue()) + '_' + (supplierDetail.getDynamicObject("purentryproject") == null ? "" : supplierDetail.getDynamicObject("purentryproject").getString("id")) + '_' + (supplierDetail.getString("materialdes") == null ? "" : supplierDetail.getString("materialdes")))) == null) continue;
                        this.updateSupplierDetail(clarifySupplierDetail, supplierDetail);
                    }
                }
            }
        }
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().getParentView().updateView("supplierdetail");
        this.getView().getParentView().updateView("evaltendersection");
    }

    public void cellClick(CellClickEvent arg) {
        CloseCallBack callBack;
        FormShowParameter showParameter;
        DynamicObject supplierEntry;
        IDataModel supplierEntryOperate;
        EntryGrid supplierEntryGrid;
        String itemName = arg.getFieldKey();
        String typeName = null;
        String type = null;
        if ("supplier_techfile".equals(itemName)) {
            typeName = "techattachment";
            type = "techFile";
        } else if ("supplier_comfile".equals(itemName)) {
            typeName = "busattachment";
            type = "comFile";
        }
        IPageCache pageCache = this.getView().getPageCache();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean isOnlineEval = (Boolean)formShowParameter.getCustomParam("isOnlineEval");
        String appId = (String)formShowParameter.getCustomParam("appId");
        int selectSectionRow = (Integer)formShowParameter.getCustomParam("selectSectionRow");
        IFormView parentView = this.getView().getParentView();
        String billStatus = parentView.getModel().getDataEntity(true).getString("billstatus");
        int clickRowCount = arg.getRow();
        pageCache.put("row", clickRowCount + "");
        if (StringUtils.equals((CharSequence)"techevaladvice", (CharSequence)itemName)) {
            supplierEntryGrid = (EntryGrid)arg.getSource();
            supplierEntryOperate = supplierEntryGrid.getModel();
            supplierEntry = supplierEntryOperate.getEntryRowEntity(supplierEntryGrid.getKey(), clickRowCount);
            String techevaladvice_tag = supplierEntry.getString("techevaladvice_tag");
            showParameter = new FormShowParameter();
            showParameter.setFormId("ide_largertextedit");
            showParameter.setCustomParam("fieldKey", (Object)"techevaladvice");
            showParameter.setCaption(ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807\u610f\u89c1", (String)"BidTenderGradingEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("largeTextValue", (Object)(techevaladvice_tag.endsWith("\n") ? techevaladvice_tag.substring(0, techevaladvice_tag.length() - 1) : techevaladvice_tag));
            if (isOnlineEval) {
                showParameter.setCustomParam("lock", (Object)Boolean.TRUE);
            } else if (BillStatusEnum.AUDITING.getVal().equals(billStatus) || BillStatusEnum.AUDITED.getVal().equals(billStatus) || BillStatusEnum.SUBMIT.getVal().equals(billStatus)) {
                showParameter.setCustomParam("lock", (Object)Boolean.TRUE);
            } else {
                callBack = new CloseCallBack((IFormPlugin)this, "techevaladvice");
                showParameter.setCloseCallBack(callBack);
            }
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)"bsevaladvice", (CharSequence)itemName)) {
            supplierEntryGrid = (EntryGrid)arg.getSource();
            supplierEntryOperate = supplierEntryGrid.getModel();
            supplierEntry = supplierEntryOperate.getEntryRowEntity(supplierEntryGrid.getKey(), clickRowCount);
            String bsevaladvice_tag = supplierEntry.getString("bsevaladvice_tag");
            showParameter = new FormShowParameter();
            showParameter.setFormId("ide_largertextedit");
            showParameter.setCustomParam("fieldKey", (Object)"bsevaladvice");
            showParameter.setCaption(ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807\u610f\u89c1", (String)"BidTenderGradingEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("largeTextValue", (Object)(bsevaladvice_tag.endsWith("\n") ? bsevaladvice_tag.substring(0, bsevaladvice_tag.length() - 1) : bsevaladvice_tag));
            if (isOnlineEval) {
                showParameter.setCustomParam("lock", (Object)Boolean.TRUE);
            } else if (BillStatusEnum.AUDITING.getVal().equals(billStatus) || BillStatusEnum.AUDITED.getVal().equals(billStatus) || BillStatusEnum.SUBMIT.getVal().equals(billStatus)) {
                showParameter.setCustomParam("lock", (Object)Boolean.TRUE);
            } else {
                callBack = new CloseCallBack((IFormPlugin)this, "bsevaladvice");
                showParameter.setCloseCallBack(callBack);
            }
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
        if ("supplier_techfile".equals(itemName) || "supplier_comfile".equals(itemName)) {
            EntryGrid grid = (EntryGrid)parentView.getControl("evaltendersection");
            IDataModel operate = grid.getModel();
            DynamicObject sectionEntry = operate.getEntryRowEntity("evaltendersection", selectSectionRow);
            Long sectionId = ((DynamicObject)parentView.getModel().getEntryEntity("evaltendersection").get(selectSectionRow)).getLong("opensectionid");
            EntryGrid supplierEntryGrid2 = (EntryGrid)arg.getSource();
            IDataModel supplierEntryOperate2 = supplierEntryGrid2.getModel();
            DynamicObject supplierEntry2 = supplierEntryOperate2.getEntryRowEntity(supplierEntryGrid2.getKey(), clickRowCount);
            Long supplierId = supplierEntry2.getLong("supplier");
            String sectionName = sectionEntry.getString("evalsectionname");
            DynamicObject bidProject = parentView.getModel().getDataEntity(true).getDynamicObject("bidproject");
            boolean isHistory = false;
            if (BillStatusEnum.INVALIDXX.getVal().equals(billStatus)) {
                isHistory = true;
            }
            boolean fromClarifyFlag = false;
            String cacheKey = "";
            String attachKey = "";
            if ("supplier_techfile".equals(itemName)) {
                cacheKey = "technical_" + sectionName + "_" + supplierId;
                attachKey = "techattachment";
            } else if ("supplier_comfile".equals(itemName)) {
                cacheKey = "commercial_" + sectionName + "_" + supplierId;
                attachKey = "commercattachment";
            }
            String clarifyNewDataId = pageCache.get(cacheKey);
            if (!StringUtils.isEmpty((CharSequence)clarifyNewDataId)) {
                fromClarifyFlag = true;
            }
            if (fromClarifyFlag) {
                BillShowParameter para = new BillShowParameter();
                para.setCustomParam("formId", (Object)(appId + "_questionclarify"));
                para.setCustomParam("clarifyNewDataId", (Object)clarifyNewDataId);
                para.setCustomParam("tendergrading", (Object)Boolean.TRUE);
                para.setCustomParam("fromClarifyFlag", (Object)Boolean.TRUE);
                para.setCustomParam("attachKey", (Object)attachKey);
                para.setFormId(FormTypeConstants.getFormConstant((String)"supplier_file", ((Object)((Object)this)).getClass()));
                OpenStyle openStyle = para.getOpenStyle();
                openStyle.setShowType(ShowType.Modal);
                para.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)para);
            } else {
                Long bidOpenId = (Long)formShowParameter.getCustomParam("bidOpenId");
                DynamicObject tempBidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,bidsection,sectionname");
                DynamicObjectCollection bidSection = tempBidOpen.getDynamicObjectCollection("bidsection");
                Object openSectionId = null;
                for (int i = 0; i < bidSection.size(); ++i) {
                    if (!((DynamicObject)bidSection.get(i)).getString("sectionname").equals(sectionName)) continue;
                    openSectionId = (Long)((DynamicObject)bidSection.get(i)).getPkValue();
                    break;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("formId", appId + "_supplier_file");
                FormShowParameter para = FormShowParameter.createFormShowParameter(map);
                para.setCustomParam("bidopenid", (Object)bidOpenId);
                para.setCustomParam("bidProjectId", bidProject.getPkValue());
                para.setCustomParam("sectionId", (Object)sectionId);
                para.setCustomParam("openSectionId", openSectionId);
                para.setCustomParam("sectionName", (Object)sectionName);
                para.setCustomParam("supplierId", (Object)supplierId);
                para.setCustomParam("typeName", (Object)typeName);
                para.setCustomParam("bidpublishid", parentView.getModel().getValue("bidpublishid"));
                para.setCustomParam("type", (Object)typeName);
                para.setCustomParam("isFromBackBid", (Object)Boolean.FALSE);
                para.setCustomParam("isHistory", (Object)isHistory);
                para.setCustomParam("tendergrading", (Object)Boolean.TRUE);
                para.setCustomParam("clickFieldName", (Object)itemName);
                para.setCustomParam("clickRow", (Object)clickRowCount);
                OpenStyle openStyle = para.getOpenStyle();
                openStyle.setShowType(ShowType.Modal);
                para.setStatus(OperationStatus.VIEW);
                this.getView().showForm(para);
            }
        }
        if ("purdetail".equals(itemName)) {
            Long bidProjectId = (Long)formShowParameter.getCustomParam("bidProject");
            Long bidOpenId = (Long)formShowParameter.getCustomParam("bidOpenId");
            boolean isMaterialPur = (Boolean)formShowParameter.getCustomParam("isMaterialPur");
            boolean isRateBidding = (Boolean)formShowParameter.getCustomParam("isRateBidding");
            int bidType = (Integer)formShowParameter.getCustomParam("bidtype");
            EntryGrid grid = (EntryGrid)arg.getSource();
            IDataModel operate = grid.getModel();
            DynamicObject supplierEntry3 = operate.getEntryRowEntity(grid.getKey(), clickRowCount);
            String supplierId = supplierEntry3.getString("supplier");
            EntryGrid sectionGrid = (EntryGrid)this.getView().getParentView().getControl("evaltendersection");
            IDataModel sectionOperate = sectionGrid.getModel();
            DynamicObject sectionEntry = sectionOperate.getEntryRowEntity("evaltendersection", selectSectionRow);
            String sectionId = sectionEntry.getString("opensectionid");
            String sectionName = sectionEntry.getString("evalsectionname");
            DynamicObjectCollection purAllDetails = sectionEntry.getDynamicObjectCollection("supplierdetail");
            MainEntityType bidEvaluationType = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()));
            EntityType supplierDetailType = (EntityType)bidEvaluationType.getAllEntities().get("supplierdetail");
            DynamicObjectCollection purDetails = new DynamicObjectCollection((DynamicObjectType)supplierDetailType, (Object)sectionEntry);
            for (DynamicObject purDetail : purAllDetails) {
                DynamicObject purSupplierOb = purDetail.getDynamicObject("pursupplier");
                if (!StringUtils.equals((CharSequence)supplierId, (CharSequence)purSupplierOb.getString("id"))) continue;
                purDetails.add((Object)purDetail);
            }
            FormShowParameter para = new FormShowParameter();
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            para.setStatus(OperationStatus.VIEW);
            para.setFormId(appId + "_bidopen_purdetail");
            para.setCustomParam("supplierid", (Object)supplierId);
            para.setCustomParam("sectionId", (Object)sectionId);
            para.setCustomParam("sectionName", (Object)sectionName);
            para.setCustomParam("isMaterialpur", (Object)isMaterialPur);
            para.setCustomParam("isratebidding", (Object)isRateBidding);
            para.setCustomParam("bidType", (Object)bidType);
            para.setCustomParam("tendergrading", (Object)Boolean.TRUE);
            para.setCustomParam("purDetails", (Object)purDetails);
            para.setCustomParam("bidProject", (Object)bidProjectId);
            para.setCustomParam("bidOpenId", (Object)bidOpenId);
            CloseCallBack callBack2 = new CloseCallBack((IFormPlugin)this, appId + "_bidopen_purdetail");
            para.setCloseCallBack(callBack2);
            this.getView().showForm(para);
        }
        if ("gradeoperationcolumnap".equals(itemName)) {
            this.fileDownLoad(arg);
        }
    }

    public void fileDownLoad(CellClickEvent arg) {
        IPageCache pageCache = this.getView().getPageCache();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        int selectSectionRow = (Integer)formShowParameter.getCustomParam("selectSectionRow");
        IFormView parentView = this.getView().getParentView();
        int clickRowCount = arg.getRow();
        EntryGrid grid = (EntryGrid)parentView.getControl("evaltendersection");
        IDataModel operate = grid.getModel();
        DynamicObject sectionEntry = operate.getEntryRowEntity("evaltendersection", selectSectionRow);
        EntryGrid supplierEntryGrid = (EntryGrid)arg.getSource();
        IDataModel supplierEntryOperate = supplierEntryGrid.getModel();
        DynamicObject supplierEntry = supplierEntryOperate.getEntryRowEntity(supplierEntryGrid.getKey(), clickRowCount);
        Long supplierId = supplierEntry.getLong("supplier");
        String sectionName = sectionEntry.getString("evalsectionname");
        boolean fromClarifyFlag = false;
        String tecCacheKey = "technical_" + sectionName + "_" + supplierId;
        String comCacheKey = "commercial_" + sectionName + "_" + supplierId;
        String tecClarifyNewDataId = pageCache.get(tecCacheKey);
        String comClarifyNewDataId = pageCache.get(comCacheKey);
        String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
        DynamicObject parentDataEntity = parentView.getModel().getDataEntity(true);
        String evalType = parentDataEntity.getString("evaltype");
        if (!StringUtils.isEmpty((CharSequence)tecClarifyNewDataId) || !StringUtils.isEmpty((CharSequence)comClarifyNewDataId)) {
            fromClarifyFlag = true;
        }
        DynamicObject bidProject = parentDataEntity.getDynamicObject("bidproject");
        Object bidprojectId = bidProject.getPkValue();
        String supplierName = supplierEntry.getString("suppliername");
        String supplierNameDark = supplierEntry.getString("suppliername_dark");
        if (StringUtils.isNotEmpty((CharSequence)supplierNameDark)) {
            supplierName = supplierNameDark;
        }
        Long bidOpenId = (Long)formShowParameter.getCustomParam("bidOpenId");
        if (fromClarifyFlag) {
            ArrayList<String> urlList = new ArrayList<String>();
            String formId = serviceAppId + "_questionclarify";
            this.getQuestionClaritfyFile(evalType, formId, urlList, tecClarifyNewDataId, comClarifyNewDataId, supplierId, sectionName);
            String fielZipName = this.getFileZipName(bidprojectId, sectionName, supplierName, serviceAppId + "_bidevaluation", parentDataEntity.getPkValue(), serviceAppId);
            if (urlList.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u6587\u4ef6\u3002", (String)"BidTenderGradingEdit_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().download(BidFileHelper.downloadByAttachmentUrls((String)fielZipName, (String[])urlList.toArray(new String[0])));
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2a\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\u3002", (String)"BidTenderGradingEdit_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), urlList.size()));
            }
            BizLog.log((String)(ResManager.loadKDString((String)"\u8bc4\u6807\u9644\u4ef6\u4e0b\u8f7d----\u6765\u6e90\u8d28\u7591\u6f84\u6e05----", (String)"BidTenderGradingEdit_9", (String)"scm-bid-formplugin", (Object[])new Object[0]) + ResManager.loadKDString((String)"\u8bc4\u6807ID\uff1a", (String)"BidTenderGradingEdit_10", (String)"scm-bid-formplugin", (Object[])new Object[0]) + parentDataEntity.getPkValue() + ResManager.loadKDString((String)"\u4e0b\u8f7d\u4eba\uff1a", (String)"BidTenderGradingEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]) + RequestContext.get().getUserId() + ResManager.loadKDString((String)"\u9644\u4ef6\u6570\u91cf\uff1a ", (String)"BidTenderGradingEdit_12", (String)"scm-bid-formplugin", (Object[])new Object[0]) + urlList.size() + "tecClarifyNewDataId:" + tecClarifyNewDataId + "comClarifyNewDataId" + comClarifyNewDataId));
        } else {
            ArrayList<Long> attachmentIds = new ArrayList<Long>();
            this.getOpenFile(bidOpenId, serviceAppId, supplierId, sectionName, evalType, attachmentIds);
            String fielZipName = this.getFileZipName(bidprojectId, sectionName, supplierName, serviceAppId + "_bidevaluation", parentDataEntity.getPkValue(), serviceAppId);
            if (attachmentIds.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u6587\u4ef6\u3002", (String)"BidTenderGradingEdit_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().download(BidFileHelper.downloadByAttachmentIds((String)fielZipName, attachmentIds));
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2a\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\u3002", (String)"BidTenderGradingEdit_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), attachmentIds.size()));
            }
            BizLog.log((String)(ResManager.loadKDString((String)"\u8bc4\u6807\u9644\u4ef6\u4e0b\u8f7d----\u5f00\u6807----", (String)"BidTenderGradingEdit_13", (String)"scm-bid-formplugin", (Object[])new Object[0]) + ResManager.loadKDString((String)"\u8bc4\u6807ID\uff1a", (String)"BidTenderGradingEdit_10", (String)"scm-bid-formplugin", (Object[])new Object[0]) + parentDataEntity.getPkValue() + ResManager.loadKDString((String)"\u4e0b\u8f7d\u4eba\uff1a", (String)"BidTenderGradingEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]) + RequestContext.get().getUserId() + ResManager.loadKDString((String)"\u9644\u4ef6\u6570\u91cf\uff1a ", (String)"BidTenderGradingEdit_12", (String)"scm-bid-formplugin", (Object[])new Object[0]) + attachmentIds.size()));
        }
    }

    public void getQuestionClaritfyFile(String evalType, String formId, List<String> urlList, String tecClarifyNewDataId, String comClarifyNewDataId, Long supplierId, String sectionName) {
        if ("TECHNICAL".equals(evalType)) {
            ArrayList<Long> attachmentIds = new ArrayList<Long>();
            String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long bidOpenId = (Long)formShowParameter.getCustomParam("bidOpenId");
            if (tecClarifyNewDataId != null) {
                List techattachment = AttachmentServiceHelper.getAttachments((String)formId, (Object)tecClarifyNewDataId, (String)"techattachment");
                for (Map map : techattachment) {
                    Long attPkId = (Long)map.get("attPkId");
                    attachmentIds.add(attPkId);
                }
                this.getFielUrlAttachment(urlList, attachmentIds);
            } else {
                this.getOpenFile(bidOpenId, serviceAppId, supplierId, sectionName, "TECHNICAL", attachmentIds);
                this.getFielUrl(urlList, attachmentIds);
            }
        } else if ("BUSSINESS".equals(evalType)) {
            ArrayList<Long> attachmentIds = new ArrayList<Long>();
            String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long bidOpenId = (Long)formShowParameter.getCustomParam("bidOpenId");
            if (comClarifyNewDataId != null) {
                List commercattachment = AttachmentServiceHelper.getAttachments((String)formId, (Object)comClarifyNewDataId, (String)"commercattachment");
                for (Map map : commercattachment) {
                    Long attPkId = (Long)map.get("attPkId");
                    attachmentIds.add(attPkId);
                }
                this.getFielUrlAttachment(urlList, attachmentIds);
            } else {
                this.getOpenFile(bidOpenId, serviceAppId, supplierId, sectionName, "BUSSINESS", attachmentIds);
                this.getFielUrl(urlList, attachmentIds);
            }
        } else if ("MULTI".equals(evalType)) {
            Long attPkId;
            ArrayList<Long> attachmentIds = new ArrayList<Long>();
            String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long bidOpenId = (Long)formShowParameter.getCustomParam("bidOpenId");
            if (tecClarifyNewDataId != null) {
                List techattachment = AttachmentServiceHelper.getAttachments((String)formId, (Object)tecClarifyNewDataId, (String)"techattachment");
                for (Map map : techattachment) {
                    attPkId = (Long)map.get("attPkId");
                    attachmentIds.add(attPkId);
                }
                this.getFielUrlAttachment(urlList, attachmentIds);
            } else {
                this.getOpenFile(bidOpenId, serviceAppId, supplierId, sectionName, "TECHNICAL", attachmentIds);
                this.getFielUrl(urlList, attachmentIds);
            }
            attachmentIds.clear();
            if (comClarifyNewDataId != null) {
                List commercattachment = AttachmentServiceHelper.getAttachments((String)formId, (Object)comClarifyNewDataId, (String)"commercattachment");
                for (Map map : commercattachment) {
                    attPkId = (Long)map.get("attPkId");
                    attachmentIds.add(attPkId);
                }
                this.getFielUrlAttachment(urlList, attachmentIds);
            } else {
                this.getOpenFile(bidOpenId, serviceAppId, supplierId, sectionName, "BUSSINESS", attachmentIds);
                this.getFielUrl(urlList, attachmentIds);
            }
        }
    }

    public void getFielUrl(List<String> urlList, ArrayList<Long> attachmentIds) {
        QFilter qFilter = new QFilter("id", "in", attachmentIds);
        DynamicObject[] attachments = BusinessDataServiceHelper.load((String)"bd_attachment", (String)"id,url", (QFilter[])new QFilter[]{qFilter});
        Arrays.stream(attachments).forEach(attachment -> urlList.add(FileServiceExtFactory.getAttachFileServiceExt().getRealPath(attachment.getString("url"))));
    }

    public void getFielUrlAttachment(List<String> urlList, ArrayList<Long> attachmentIds) {
        QFilter qFilter = new QFilter("id", "in", attachmentIds);
        DynamicObject[] attachments = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"id,ffileid", (QFilter[])new QFilter[]{qFilter});
        Arrays.stream(attachments).forEach(attachment -> urlList.add(FileServiceExtFactory.getAttachFileServiceExt().getRealPath(attachment.getString("ffileid"))));
    }

    public void getOpenFile(Long bidOpenId, String serviceAppId, Long supplierId, String sectionName, String evalType, ArrayList<Long> attachmentIds) {
        DynamicObject tempBidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)(serviceAppId + "_bidopen"), (String)"id,bidsection,sectionname,supplierentry,supplier,supplier_techattach,supplier_comattach");
        if (tempBidOpen != null) {
            DynamicObjectCollection bidSectionCol = tempBidOpen.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidSection : bidSectionCol) {
                String currentSectionName = bidSection.getString("sectionname");
                if (!sectionName.equals(currentSectionName)) continue;
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject bidOpenSupplierEntry : supplierEntryCol) {
                    DynamicObjectCollection techAttach;
                    Long currentSupplierId = bidOpenSupplierEntry.getDynamicObject("supplier").getLong("id");
                    if (!supplierId.equals(currentSupplierId)) continue;
                    if ("TECHNICAL".equals(evalType)) {
                        techAttach = bidOpenSupplierEntry.getDynamicObjectCollection("supplier_techattach");
                        techAttach.forEach(attachment -> {
                            Long o = (Long)attachment.getDynamicObject("fbasedataid").get("id");
                            attachmentIds.add(o);
                        });
                        continue;
                    }
                    if ("BUSSINESS".equals(evalType)) {
                        DynamicObjectCollection comAttach = bidOpenSupplierEntry.getDynamicObjectCollection("supplier_comattach");
                        comAttach.forEach(attachment -> {
                            Long o = (Long)attachment.getDynamicObject("fbasedataid").get("id");
                            attachmentIds.add(o);
                        });
                        continue;
                    }
                    if (!"MULTI".equals(evalType)) continue;
                    techAttach = bidOpenSupplierEntry.getDynamicObjectCollection("supplier_techattach");
                    DynamicObjectCollection comAttach = bidOpenSupplierEntry.getDynamicObjectCollection("supplier_comattach");
                    techAttach.forEach(attachment -> {
                        Long o = (Long)attachment.getDynamicObject("fbasedataid").get("id");
                        attachmentIds.add(o);
                    });
                    comAttach.forEach(attachment -> {
                        Long o = (Long)attachment.getDynamicObject("fbasedataid").get("id");
                        attachmentIds.add(o);
                    });
                }
            }
        }
    }

    public String getFileZipName(Object bidprojectId, String sectionName, String supplierName, String formBillno, Object formId, String appid) {
        return BidFileHelper.getFileZipName((Object)bidprojectId, (String)sectionName, (String)supplierName, (String)formBillno, (Object)formId, (String)appid);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public Map<String, List<DynamicObject>> getQuestionClarify(Long bidEvaluationId, String appId, String openType) {
        LinkedHashMap<String, List<DynamicObject>> result = new LinkedHashMap<String, List<DynamicObject>>();
        QFilter clarifyTypeFilter = null;
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(openType)) {
            clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(openType)) {
            clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()).or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()));
        }
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
        QFilter reSubMissTendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        QFilter bidEvaluationFilter = new QFilter("bidevaluationid", "=", (Object)bidEvaluationId);
        DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)(appId + "_questionclarify"), (String)"id,submitdate,tenderprice,pricevat,tax,notaxtenderprice,rate,bidsection,bidsection.sectionname,clarifysupplier,clarifytype,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate", (QFilter[])new QFilter[]{bidEvaluationFilter, billStatusFilter, clarifyTypeFilter, reSubMissTendersFilter}, (String)"submitdate asc");
        if (dataArray.length > 0) {
            Map<String, List<DynamicObject>> clarifySupplierMap = Arrays.stream(dataArray).collect(Collectors.groupingBy(t -> t.getString("clarifysupplier")));
            clarifySupplierMap.forEach((key, values) -> {
                if (values.size() > 1) {
                    Date date = null;
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
                    for (DynamicObject clarify : values) {
                        Date submitDate = clarify.getDate("submitdate");
                        if (submitDate == null) continue;
                        if (date == null) {
                            date = submitDate;
                            list.add(clarify);
                            continue;
                        }
                        if (!submitDate.after(date)) continue;
                        list.clear();
                        list.add(clarify);
                    }
                    result.put((String)key, (List<DynamicObject>)list);
                } else {
                    result.put((String)key, (List<DynamicObject>)values);
                }
            });
        }
        return result;
    }

    public void updateSupplierDetail(DynamicObject clarifySupplierDetail, DynamicObject supplierDetail) {
        supplierDetail.set("inclutaxprice", (Object)clarifySupplierDetail.getBigDecimal("inclutaxprice"));
        supplierDetail.set("inclutaxamount", (Object)clarifySupplierDetail.getBigDecimal("inclutaxamount"));
        supplierDetail.set("taxrate", (Object)clarifySupplierDetail.getBigDecimal("taxrate").multiply(new BigDecimal(100)));
        supplierDetail.set("taxamount", clarifySupplierDetail.get("taxamount"));
        supplierDetail.set("excepttaxamount", (Object)clarifySupplierDetail.getBigDecimal("excepttaxamount"));
        supplierDetail.set("costrate", (Object)clarifySupplierDetail.getBigDecimal("costrate").multiply(new BigDecimal(100)));
    }
}

