/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.RichTextEditorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidAnnocumentService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidAnnocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidNotificationEnum;
import kd.scm.bid.common.enums.DecisionEnum;
import kd.scm.bid.common.enums.TemplateModelTypeEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.helper.AttachmentHelper;
import kd.scm.bid.formplugin.bill.helper.DynamicTabHelper;
import kd.scm.bid.formplugin.bill.helper.TemplateManageHelper;
import kd.scm.bid.formplugin.bill.util.MyTenderUtils;
import kd.scm.bid.formplugin.bill.util.NoticeMessageUtil;
import kd.scm.bid.formplugin.bill.util.SendDecisionResultUtil;

public class BidWinNoticeEditUI
extends AbstractFormPlugin
implements UploadListener,
BeforeF7SelectListener {
    protected IBidProjectService projectService = new BidProjectServiceImpl();
    protected IBidAnnocumentService bidAnnocumentService = new BidAnnocumentServiceImpl();
    private static String ATTACHE_TAG = "atta";
    private static String RICHTEXT_TAG = "rich";
    private static String SEND_BUTTON = "send";
    private static String PREVIEW_BUTTON = "preview";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        List<DynamicObject> listSuppliers = null;
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Object sectionId = formShowParameter.getCustomParam("sectionId");
        Object bidDecisionId = formShowParameter.getCustomParam("bidDecisionId");
        DynamicObject bidDecision = null;
        if (sectionId == null && bidDecisionId == null) {
            Object pkId = ((BaseShowParameter)formShowParameter).getPkId();
            DynamicObject winnotice = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()), (String)"bidproject,decisionsectionid", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
            sectionId = winnotice.getLong("decisionsectionid");
            long bidproject = winnotice.getLong("bidproject");
            DynamicObject decision = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidproject), new QFilter("billstatus", "!=", (Object)"XX")});
            bidDecision = BusinessDataServiceHelper.loadSingle((Object)decision.getLong("id"), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        } else {
            bidDecision = BusinessDataServiceHelper.loadSingle((Object)((Long)bidDecisionId), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        }
        listSuppliers = DynamicTabHelper.listRecommendedSuppliers(sectionId, bidDecision);
        if (listSuppliers == null || listSuppliers.size() == 0) {
            return;
        }
        Map<String, Object> mapHead = this.getMapHead(listSuppliers);
        e.getItems().add(mapHead);
    }

    private Map<String, Object> getMapHead(List<DynamicObject> listSuppliers) {
        TabAp tab = this.createDynamicTabAp(listSuppliers);
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        mapHead.put("id", "suppliertab");
        mapHead.put("items", tab.createControl().get("items"));
        return mapHead;
    }

    private TabAp createDynamicTabAp(List<DynamicObject> listSuppliers) {
        TabAp tab = new TabAp();
        for (int i = 0; i < listSuppliers.size(); ++i) {
            DynamicObject supplier = listSuppliers.get(i);
            tab.setKey("suppliertab" + i);
            TabPageAp tpa = this.createTabPageAp(supplier);
            tab.getItems().add(tpa);
        }
        return tab;
    }

    private TabPageAp createTabPageAp(DynamicObject supplier) {
        String supplierId = supplier.getString("id");
        String supplierName = supplier.getString("name");
        TabPageAp tpa = new TabPageAp();
        tpa.setKey(supplierId);
        tpa.setId(supplierId);
        tpa.setName(new LocaleString(supplierName));
        RichTextEditorAp richTextAp = new RichTextEditorAp();
        String richKey = RICHTEXT_TAG + supplierId;
        richTextAp.setId(richKey);
        richTextAp.setLockPrintable(true);
        richTextAp.setKey(richKey);
        richTextAp.setName(new LocaleString(supplierName));
        richTextAp.setLock("view");
        richTextAp.setHeight(new LocaleString("400px"));
        tpa.getItems().add(richTextAp);
        AttachmentPanelAp attaAp = new AttachmentPanelAp();
        String attaKey = ATTACHE_TAG + supplierId;
        attaAp.setId(attaKey);
        attaAp.setKey(attaKey);
        attaAp.setLock("view");
        attaAp.setCollapsible(true);
        attaAp.setName(new LocaleString(ResManager.loadKDString((String)"\u4e13\u5c5e\u9644\u4ef6", (String)"BidWinNoticeEditUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("20px");
        style.setMargin(margin);
        attaAp.setStyle(style);
        Tips ctlTips = new Tips();
        ctlTips.setContent(new LocaleString(ResManager.loadKDString((String)"\u53d1\u5e03\u540e\u53ea\u6709\u6240\u5c5e\u4f9b\u5e94\u5546\u53ef\u89c1\u3002", (String)"BidWinNoticeEditUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        ctlTips.setTriggerType("hover");
        ctlTips.setType("text");
        ctlTips.setShowIcon(true);
        attaAp.setCtlTips(ctlTips);
        tpa.getItems().add(attaAp);
        return tpa;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("BidWinNoticeEdit", exp.getMessage()), new Object[0]);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object sectionId = formShowParameter.getCustomParam("sectionId");
        Object bidDecisionId = formShowParameter.getCustomParam("bidDecisionId");
        DynamicObject bidDecision = null;
        if (sectionId == null && bidDecisionId == null) {
            Object pkId = ((BaseShowParameter)formShowParameter).getPkId();
            DynamicObject winnotice = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()), (String)"bidproject,decisionsectionid", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
            sectionId = winnotice.getLong("decisionsectionid");
            long bidproject = winnotice.getLong("bidproject");
            DynamicObject decision = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidproject), new QFilter("billstatus", "!=", (Object)"XX")});
            bidDecision = BusinessDataServiceHelper.loadSingle((Object)decision.getLong("id"), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        } else {
            bidDecision = BusinessDataServiceHelper.loadSingle((Object)((Long)bidDecisionId), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        }
        List<DynamicObject> listSuppliers = DynamicTabHelper.listRecommendedSuppliers(sectionId, bidDecision);
        this.registDynamicProps(newMainType, listSuppliers);
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType, List<DynamicObject> listSuppliers) {
        for (int i = 0; i < listSuppliers.size(); ++i) {
            String supplierId = listSuppliers.get(i).getString("id");
            String supplierName = listSuppliers.get(i).getString("name");
            TextProp richTextProp = new TextProp();
            richTextProp.setName(RICHTEXT_TAG + supplierId);
            richTextProp.setDisplayName(new LocaleString(supplierName));
            richTextProp.setDbIgnore(true);
            richTextProp.setAlias(supplierName);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)richTextProp);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getKey().startsWith(RICHTEXT_TAG)) {
            RichTextEditor rechText = new RichTextEditor();
            String richKey = e.getKey();
            rechText.setKey(richKey);
            rechText.setView(this.getView());
            e.setControl((Control)rechText);
        } else if (e.getKey().startsWith(ATTACHE_TAG)) {
            AttachmentPanel panel = new AttachmentPanel();
            String key = e.getKey();
            panel.setKey(key);
            panel.setDefaultCollapse(false);
            panel.setView(this.getView());
            e.setControl((Control)panel);
        }
    }

    public void beforeBindData(EventObject e) {
        Object sectionName;
        Object noticeId = this.getNoticePkId(this.getView().getFormShowParameter());
        if (noticeId != null) {
            DynamicObject bidWinNotice = this.getWinNoticeById(noticeId);
            this.setSupplierEntry(bidWinNotice);
        }
        if ((sectionName = this.getView().getFormShowParameter().getCustomParam("sectionName")) != null) {
            this.getModel().setValue("sectionname", sectionName);
        }
    }

    private DynamicObject getWinNoticeById(Object winNoticeId) {
        DynamicObject bidWinNotice = BusinessDataServiceHelper.loadSingle((Object)winNoticeId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass())));
        return bidWinNotice;
    }

    private void setSupplierEntry(DynamicObject bidWinNotice) {
        DynamicObjectCollection coll = bidWinNotice.getDynamicObjectCollection("supplierentry");
        if (!coll.isEmpty()) {
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject supplierEntry = (DynamicObject)coll.get(i);
                String content = supplierEntry.getString("content");
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                String supplierId = supplier.getString("id");
                String richContentKey = RICHTEXT_TAG + supplierId;
                RichTextEditor richContent = (RichTextEditor)this.getView().getControl(richContentKey);
                richContent.setText(content);
                this.getView().updateView(richContentKey);
                String attaKey = ATTACHE_TAG + supplierId;
                AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(attaKey);
                panel.setKey(attaKey);
                panel.setKey(attaKey);
                panel.setDefaultCollapse(false);
                this.getView().updateView(attaKey);
            }
        }
    }

    public void afterBindData(EventObject e) {
        String status;
        Object noticeId;
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bidDecisionId = formShowParameter.getCustomParam("bidDecisionId");
        this.getView().setVisible(Boolean.FALSE, new String[]{"supplierflax"});
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SEND_BUTTON});
        }
        if ((noticeId = this.getNoticePkId(this.getView().getFormShowParameter())) == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SEND_BUTTON});
            this.getView().setVisible(Boolean.FALSE, new String[]{PREVIEW_BUTTON});
            DynamicObject bidDecision = BusinessDataServiceHelper.loadSingle((Object)((Long)bidDecisionId), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
            this.setNewBidProject(bidDecision);
        }
        if (!"".equals(status = this.getModel().getDataEntity().getString("status")) && !"A".equals(status)) {
            Object sectionId = formShowParameter.getCustomParam("sectionId");
            DynamicObject bidDecision = null;
            if (sectionId == null && bidDecisionId == null) {
                Object pkId = ((BaseShowParameter)formShowParameter).getPkId();
                DynamicObject winnotice = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()), (String)"bidproject,decisionsectionid", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
                sectionId = winnotice.getLong("decisionsectionid");
                long bidproject = winnotice.getLong("bidproject");
                DynamicObject decision = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidproject), new QFilter("billstatus", "!=", (Object)"XX")});
                bidDecision = BusinessDataServiceHelper.loadSingle((Object)decision.getLong("id"), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
            } else {
                bidDecision = BusinessDataServiceHelper.loadSingle((Object)((Long)bidDecisionId), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
            }
            List<DynamicObject> listSuppliers = DynamicTabHelper.listUnRecommendedSuppliers(sectionId, bidDecision);
            for (int i = 0; i < listSuppliers.size(); ++i) {
                String supplierId = listSuppliers.get(i).getString("id");
                this.getView().setEnable(Boolean.FALSE, new String[]{RICHTEXT_TAG + supplierId});
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            return;
        }
        IDataEntityProperty pro = e.getProperty();
        String filedName = pro.getName();
        if (StringUtils.equals((CharSequence)filedName, (CharSequence)"bidnoticetemplate")) {
            ChangeData[] datas = e.getChangeSet();
            ChangeData data = datas[0];
            Object newValue = data.getNewValue();
            if (newValue == null) {
                return;
            }
            if (data.getOldValue() == null && this.getNoticePkId(this.getView().getFormShowParameter()) != null) {
                return;
            }
            DynamicObject template = (DynamicObject)newValue;
            String templateContent = template.getString("content");
            data = datas[0];
            StringBuilder buffer = new StringBuilder();
            buffer.append(templateContent);
            this.getNewContent(buffer);
        }
    }

    private void setNewBidProject(DynamicObject bidDecision) {
        String name = bidDecision.getString("bidProject.name");
        this.getModel().setValue("name", (Object)String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u6807\u901a\u77e5\u4e66", (String)"BidWinNoticeEditUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), name));
        DynamicObject bidProject = this.projectService.getBidProjectAllById(Long.valueOf(bidDecision.getDynamicObject("bidProject").getLong("id")));
        this.getModel().setValue("bidproject", (Object)bidDecision.getDynamicObject("bidProject"));
        DynamicObject template = TemplateManageHelper.getDefaultByModelType(TemplateModelTypeEnum.BIDNOTIFICATION.getValue(), bidProject.getLong("org.id"));
        if (template != null) {
            this.getModel().setValue("bidnoticetemplate", (Object)template);
        }
    }

    private void getNewContent(StringBuilder content) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object sectionId = formShowParameter.getCustomParam("sectionId");
        Object bidDecisionId = formShowParameter.getCustomParam("bidDecisionId");
        DynamicObject bidDecision = BusinessDataServiceHelper.loadSingle((Object)((Long)bidDecisionId), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        List<DynamicObject> listSuppliers = DynamicTabHelper.listRecommendedSuppliers(sectionId, bidDecision);
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        bidProject = this.projectService.getBidProjectAllById((Long)bidProject.get("id"));
        DynamicObject bidAnnocument = this.bidAnnocumentService.getAnnouncementByProId(bidProject.get("id"), (Object)"bidproject", "annotitle");
        this.getModel().deleteEntryData("supplierentry");
        for (int i = 0; i < listSuppliers.size(); ++i) {
            DynamicObject supplier = listSuppliers.get(i);
            String richContentKey = RICHTEXT_TAG + supplier.getString("id");
            String contentStr = this.replaceContent(bidProject, bidDecision, bidAnnocument, supplier, new String(content));
            if (this.getView().getControl(richContentKey) != null) {
                ((RichTextEditor)this.getView().getControl(richContentKey)).setText(contentStr);
                this.getView().updateView(richContentKey);
            }
            int row = this.getModel().createNewEntryRow("supplierentry");
            this.getModel().setValue("supplier", (Object)supplier, row);
            this.getModel().setValue("content", (Object)contentStr, row);
        }
    }

    private String replaceContent(DynamicObject bidProject, DynamicObject bidDecision, DynamicObject bidAnnocument, DynamicObject supplier, String content) {
        DynamicObject data = this.getModel().getDataEntity(true);
        String winNoticeName = data.getString("name");
        DynamicObject currency = bidProject.getDynamicObject("currency");
        int scale = 2;
        if (currency != null) {
            scale = currency.getInt("amtprecision");
        }
        String recommendedSupplier = "";
        String finalPrice = "";
        String finalRate = "";
        String sectionName = "";
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object sectionId = formShowParameter.getCustomParam("sectionId");
        DynamicObjectCollection bidSectionColl = (DynamicObjectCollection)bidDecision.get("bidsection");
        for (DynamicObject bidSection : bidSectionColl) {
            Long sectionIdTemp = (Long)bidSection.get("id");
            if (!sectionIdTemp.toString().equals(sectionId.toString())) continue;
            sectionName = ((OrmLocaleValue)bidSection.get("sectionname")).toString();
            DynamicObjectCollection supplierEntryColl = (DynamicObjectCollection)bidSection.get("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                boolean isrecommended = (Boolean)supplierEntry.get("isrecommended");
                BigDecimal finalpriceAmount = (BigDecimal)supplierEntry.get("finalprice");
                DecimalFormat df = new DecimalFormat("0.00%");
                BigDecimal finalRateAmount = (BigDecimal)supplierEntry.get("finalrate");
                String finalRatePercent = df.format(finalRateAmount);
                DynamicObject supplierTemp = (DynamicObject)supplierEntry.get("supplier");
                OrmLocaleValue supplierName = (OrmLocaleValue)supplierTemp.get("name");
                if (!isrecommended) continue;
                recommendedSupplier = !"".equals(recommendedSupplier) ? recommendedSupplier + ";" + supplierName : recommendedSupplier + supplierName;
                finalPrice = !"".equals(finalPrice) ? finalPrice + ";" + finalpriceAmount.setScale(scale, 4) : finalPrice + finalpriceAmount.setScale(scale, 4);
                if (!"".equals(finalRate)) {
                    finalRate = finalRate + ";" + finalRatePercent;
                    continue;
                }
                finalRate = finalRate + finalRatePercent;
            }
        }
        String supplierName = supplier.getString("name");
        boolean isratebidding = (Boolean)bidProject.get("isratebidding");
        boolean enablemultisection = (Boolean)bidProject.get("enablemultisection");
        content = content.replace(TemplateManageHelper.getSpecialValue(DecisionEnum.SECTIONNAME.getValue()), enablemultisection ? sectionName : "");
        content = content.replace(TemplateManageHelper.getSpecialValue(BidNotificationEnum.NOTIFICATIONTITLE.getValue()), winNoticeName);
        content = content.replace(TemplateManageHelper.getSpecialValue(BidNotificationEnum.SUPPLIER.getValue()), supplierName);
        content = content.replace(TemplateManageHelper.getSpecialValue(DecisionEnum.ISRECOMMENDED.getValue()), recommendedSupplier);
        content = content.replace(TemplateManageHelper.getSpecialValue(DecisionEnum.FINALPRICE.getValue()), isratebidding ? "" : finalPrice);
        content = content.replace(TemplateManageHelper.getSpecialValue(DecisionEnum.FINALRATE.getValue()), isratebidding ? finalRate : "");
        content = TemplateManageHelper.replaceContent(bidProject, bidDecision, bidAnnocument, supplier, content, sectionName);
        return content;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection supplierEntryColl = data.getDynamicObjectCollection("supplierentry");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object sectionId = formShowParameter.getCustomParam("sectionId");
        Object bidDecisionId = formShowParameter.getCustomParam("bidDecisionId");
        DynamicObject bidDecision = BusinessDataServiceHelper.loadSingle((Object)((Long)bidDecisionId), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        if (PREVIEW_BUTTON.equals(operateKey)) {
            List<DynamicObject> listSuppliers;
            Tab tab = (Tab)this.getView().getControl("suppliertab");
            String supplierId = tab.getCurrentTab();
            if (supplierId == null && (listSuppliers = DynamicTabHelper.listRecommendedSuppliers(sectionId, bidDecision)) != null && listSuppliers.size() > 0) {
                supplierId = ((Long)listSuppliers.get(0).get("id")).toString();
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(FormTypeConstants.getFormConstant((String)"winnotice_preview", ((Object)((Object)this)).getClass()));
            showParameter.setStatus(OperationStatus.VIEW);
            Object winNoticeId = this.getModel().getValue("id");
            if (winNoticeId != null) {
                List<Map<String, Object>> publicAttachs = AttachmentHelper.listAttach(FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()), winNoticeId, "attachmentpanelap");
                RichTextEditor richText = (RichTextEditor)this.getView().getControl(RICHTEXT_TAG + supplierId);
                String contentStr = richText.getText();
                if (contentStr == null || contentStr.isEmpty()) {
                    for (DynamicObject row : supplierEntryColl) {
                        DynamicObject supplier = row.getDynamicObject("supplier");
                        if (supplier == null || Long.parseLong(supplierId) != (Long)supplier.getPkValue() || (contentStr = row.getString("content")) != null && !contentStr.isEmpty()) continue;
                        contentStr = row.getString("content_tag");
                    }
                }
                String content = this.setRichTextEditorapStr(contentStr, winNoticeId.toString(), supplierId, publicAttachs);
                showParameter.setCustomParam("content", (Object)content);
            }
            DynamicObject bidProject = data.getDynamicObject("bidproject");
            String title = ResManager.loadKDString((String)"\u4e2d\u6807\u901a\u77e5\u4e66", (String)"BidWinNoticeEditUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            showParameter.setCustomParam("title", (Object)title);
            showParameter.setCustomParam("publishdate", (Object)data.getDate("publishdate"));
            showParameter.setCustomParam("org", (Object)bidProject.getLocaleString("org.name").toString());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "previewnotice"));
            this.getView().showForm(showParameter);
        } else if (SEND_BUTTON.equals(operateKey)) {
            DynamicObject bidProject = bidDecision.getDynamicObject("bidproject");
            String projectName = bidProject.getString("name");
            String sectionName = "";
            String billstatus = (String)bidDecision.get("billstatus");
            if (billstatus == null || "".equals(billstatus) || "A".equals(billstatus) || "B".equals(billstatus) || "D".equals(billstatus) || "I".equals(billstatus)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u6807\u901a\u77e5\u4e66: \u5b9a\u6807\u5355\u636e\u672a\u5ba1\u6838\uff0c\u4e0d\u80fd\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u4e66\u3002", (String)"BidWinNoticeEditUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName));
                return;
            }
            if ("X".equals(billstatus)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u6807\u901a\u77e5\u4e66: \u5b9a\u6807\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u4e66\u3002", (String)"BidWinNoticeEditUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName));
                return;
            }
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            for (DynamicObject item : supplierEntryColl) {
                if (item.getLong("id") == 0L) continue;
                DynamicObject supplier = item.getDynamicObject("supplier");
                String tempSupplierId = supplier.getString("id");
                RichTextEditor richText = (RichTextEditor)this.getView().getControl(RICHTEXT_TAG + tempSupplierId);
                String contentStr = richText.getText();
                item.set("content", (Object)contentStr);
            }
            SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass())), (Object[])new DynamicObject[]{data});
            DynamicObjectCollection bidSectionCollection = (DynamicObjectCollection)bidDecision.get("bidsection");
            DynamicObjectCollection supplierColl = new DynamicObjectCollection();
            for (DynamicObject bidSectionItem : bidSectionCollection) {
                if (sectionId.toString().equals(bidSectionItem.get("id").toString())) {
                    bidSectionItem.set("issendwinnotice", (Object)1);
                    sectionName = bidSectionItem.getString("sectionname");
                }
                for (DynamicObject item : bidSectionItem.getDynamicObjectCollection("supplierentry")) {
                    supplierColl.add((Object)item);
                }
            }
            String getAppId = this.getModel().getDataEntityType().getAppId();
            SendDecisionResultUtil.updateDecisionSupEntryData(getAppId, data, "sendnoticeflag", bidDecision);
            this.getView().setVisible(Boolean.FALSE, new String[]{operateKey, "save"});
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e2d\u6807\u901a\u77e5\u4e66\u53d1\u9001\u6210\u529f\u3002", (String)"BidWinNoticeEditUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            boolean enable = SystemParamHelper.getSystemParameter((String)getAppId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
            if (enable) {
                new MyTenderUtils().toUpdateMyTender(bidProject, bidDecision, sectionId, supplierEntryColl, true, getAppId);
            }
            this.holdRichContent();
            NoticeMessageUtil.sendNoticeMessage(bidProject, data, supplierEntryColl, projectName, sectionName, getAppId, FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()));
            data.set("issuestatus", (Object)"ISSUED");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            this.getView().setVisible(Boolean.FALSE, new String[]{SEND_BUTTON});
        } else if (("save".equals(operateKey) || "submit".equals(operateKey)) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PREVIEW_BUTTON});
            this.holdRichContent();
        } else if ("submitandaudit".equals(operateKey)) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                data.set("status", (Object)"C");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"BidWinNoticeEditUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
                this.getView().setVisible(Boolean.TRUE, new String[]{SEND_BUTTON});
            }
            this.getView().updateView();
        } else if ("audit".equals(operateKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SEND_BUTTON});
        } else if ("unaudit".equals(operateKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SEND_BUTTON});
        }
    }

    private void holdRichContent() {
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection coll = (DynamicObjectCollection)data.get("supplierentry");
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject supplierEntry = (DynamicObject)coll.get(i);
            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
            String richKey = RICHTEXT_TAG + supplier.get("id");
            String content = supplierEntry.getString("content");
            if (content == null || content.isEmpty()) {
                content = supplierEntry.getString("content_tag");
            }
            ((RichTextEditor)this.getView().getControl(richKey)).setText(content);
        }
    }

    private String setRichTextEditorapStr(String content, String winNoticeId, Object pkValue, List<Map<String, Object>> publicAttachs) {
        ArrayList<Map<String, Object>> attachList = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> attachs = AttachmentHelper.listAttach(FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()), winNoticeId, ATTACHE_TAG + String.valueOf(pkValue));
        if (attachs != null) {
            attachList.addAll(attachs);
        }
        if (publicAttachs != null) {
            attachList.addAll(publicAttachs);
        }
        content = TemplateManageHelper.getRichContentPreview(attachList, content, ResManager.loadKDString((String)"\u9644\u4ef6", (String)"BidWinNoticeEditUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        return content;
    }

    private Object getNoticePkId(FormShowParameter formShowParameter) {
        BillShowParameter billShowParameter = (BillShowParameter)formShowParameter;
        Object noticeId = billShowParameter.getPkId();
        return noticeId;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("bidnoticetemplate");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object sectionId = formShowParameter.getCustomParam("sectionId");
        Object bidDecisionId = formShowParameter.getCustomParam("bidDecisionId");
        DynamicObject bidDecision = null;
        if (sectionId == null && bidDecisionId == null) {
            Object pkId = ((BaseShowParameter)formShowParameter).getPkId();
            DynamicObject winnotice = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"winnotice", ((Object)((Object)this)).getClass()), (String)"bidproject,decisionsectionid", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
            sectionId = winnotice.getLong("decisionsectionid");
            long bidproject = winnotice.getLong("bidproject");
            DynamicObject decision = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidproject), new QFilter("billstatus", "!=", (Object)"XX")});
            bidDecision = BusinessDataServiceHelper.loadSingle((Object)decision.getLong("id"), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        } else {
            bidDecision = BusinessDataServiceHelper.loadSingle((Object)((Long)bidDecisionId), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        }
        List<DynamicObject> suppliers = DynamicTabHelper.listRecommendedSuppliers(sectionId, bidDecision);
        for (int i = 0; i < suppliers.size(); ++i) {
            DynamicObject supplier = suppliers.get(i);
            String attakey = ATTACHE_TAG + supplier.get("id");
            AttachmentPanel atta = (AttachmentPanel)this.getView().getControl(attakey);
            atta.addUploadListener((UploadListener)this);
        }
        AttachmentPanel atta = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        atta.addUploadListener((UploadListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String fieldKey = paramBeforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bidnoticetemplate")) {
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            Set orgIds = OrgUnitHelper.getParentOrgUnitSet((Long)bidProject.getLong("org.id"));
            QFilter qFilter = new QFilter("org", "in", (Object)orgIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
            showParameter.setCustomParam("modelType", (Object)"bidnotification");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block4: {
            DynamicObject data;
            String operateKey;
            block3: {
                super.beforeDoOperation(args);
                FormOperate operate = (FormOperate)args.getSource();
                operateKey = operate.getOperateKey();
                data = this.getModel().getDataEntity(true);
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Object sectionId = formShowParameter.getCustomParam("sectionId");
                data.set("decisionsectionid", sectionId);
                if (!"save".equalsIgnoreCase(operateKey) && !"submit".equals(operateKey)) break block3;
                DynamicObjectCollection coll = (DynamicObjectCollection)data.get("supplierentry");
                for (int i = 0; i < coll.size(); ++i) {
                    DynamicObject supplierEntry = (DynamicObject)coll.get(i);
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    String richKey = RICHTEXT_TAG + supplier.get("id");
                    String content = ((RichTextEditor)this.getView().getControl(richKey)).getText();
                    if (content == null || content.isEmpty()) continue;
                    supplierEntry.set("content", (Object)content);
                }
                break block4;
            }
            if (!SEND_BUTTON.equals(operateKey)) break block4;
            DynamicObjectCollection coll = (DynamicObjectCollection)data.get("supplierentry");
            DynamicObject template = (DynamicObject)this.getModel().getValue("bidnoticetemplate");
            if (template == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2d\u6807\u901a\u77e5\u4e66\u6a21\u677f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BidWinNoticeEditUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject supplierEntry = (DynamicObject)coll.get(i);
                String content = supplierEntry.getString("content");
                if (!StringUtils.isEmpty((CharSequence)content)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2d\u6807\u901a\u77e5\u4e66\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BidWinNoticeEditUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String status;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)"previewnotice", (CharSequence)closedCallBackEvent.getActionId()) && (status = this.getModel().getDataEntity().getString("status")).equals("B")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }
}

