/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.Arrays;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.MyTenderUtils;
import kd.scm.bid.formplugin.bill.util.NoticeMessageUtil;
import kd.scm.bid.formplugin.bill.util.SendDecisionResultUtil;

public class BidWinNoticeListUI
extends AbstractListPlugin {
    private static final String SEND_BUTTON = "send";
    private static final String RICHTEXT_TAG = "rich";
    private static final String[] keys = new String[]{"delete", "submit", "unsubmit", "audit", "unaudit", "send", "submitandaudit"};

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getFieldName();
        if ("name".equals(fieldName)) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(this.getBillFormId());
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            long decisionId = (Long)this.getView().getFormShowParameter().getCustomParam("decisionId");
            billShowParameter.setCustomParam("bidDecisionId", (Object)decisionId);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            DynamicObject winnotice = QueryServiceHelper.queryOne((String)this.getBillFormId(), (String)"id,decisionsectionid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((Long)selectedRows.get(0).getPrimaryKeyValue()))});
            if (winnotice != null) {
                billShowParameter.setCustomParam("sectionId", (Object)winnotice.getLong("decisionsectionid"));
                billShowParameter.setPkId((Object)winnotice.getLong("id"));
            }
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    protected String getBillFormId() {
        return ((IListView)this.getView()).getBillFormId();
    }

    protected String getAppId() {
        return this.getBillFormId().split("_")[0] + "_";
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object bidproject = this.getView().getFormShowParameter().getCustomParam("bidproject");
        List customQFilters = e.getCustomQFilters();
        customQFilters.add(new QFilter("bidproject", "=", bidproject));
        customQFilters.add(new QFilter("entitytypeid", "=", (Object)this.getBillFormId()));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operatekey = ((FormOperate)args.getSource()).getOperateKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (this.operateKeys().contains(operatekey)) {
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u64cd\u4f5c\u3002", (String)"BidWinNoticeListUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (selectedRows.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BidWinNoticeListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    protected List<String> operateKeys() {
        return Arrays.asList(keys);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (SEND_BUTTON.equals(operateKey)) {
            Object decisionId = this.getView().getFormShowParameter().getCustomParam("decisionId");
            if (decisionId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9a\u6807\u5355\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"BidWinNoticeListUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject bidDecision = BusinessDataServiceHelper.loadSingle((Object)decisionId, (String)(this.getAppId() + "decision"));
            DynamicObject winNotice = this.getCurrentWinNotice();
            if (winNotice == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"BidWinNoticeListUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            this.sendWinNotice(operateKey, bidDecision, winNotice);
        } else if ("submitandaudit".equals(operateKey)) {
            DynamicObject winNotice = this.getCurrentWinNotice();
            if (winNotice == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"BidWinNoticeListUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            if (args.getOperationResult().isSuccess()) {
                winNotice.set("status", (Object)"C");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"BidWinNoticeListUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{winNotice});
            }
        }
        this.getView().updateView();
    }

    protected DynamicObject getCurrentWinNotice() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        long primaryKeyValue = (Long)selectedRows.get(0).getPrimaryKeyValue();
        return BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)this.getBillFormId());
    }

    protected void sendWinNotice(String operateKey, DynamicObject bidDecision, DynamicObject winNotice) {
        DynamicObject bidProject = bidDecision.getDynamicObject("bidproject");
        String projectName = bidProject.getString("name");
        String sectionName = "";
        String billstatus = (String)bidDecision.get("billstatus");
        if (billstatus == null || "".equals(billstatus) || "A".equals(billstatus) || "B".equals(billstatus) || "D".equals(billstatus) || "I".equals(billstatus)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u6807\u901a\u77e5\u4e66: \u5b9a\u6807\u5355\u636e\u672a\u5ba1\u6838\uff0c\u4e0d\u80fd\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u4e66\u3002", (String)"BidWinNoticeListUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName));
            return;
        }
        if ("X".equals(billstatus)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u6807\u901a\u77e5\u4e66: \u5b9a\u6807\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u4e66\u3002", (String)"BidWinNoticeListUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName));
            return;
        }
        String wBillStatus = winNotice.getString("status");
        String issueStatus = winNotice.getString("issuestatus");
        if (!"C".equals(wBillStatus) || !"UNISSUE".equals(issueStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u4e14\u672a\u53d1\u5e03\u7684\u6570\u636e\u8fdb\u884c\u53d1\u5e03\u3002", (String)"BidWinNoticeListUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection supplierEntryColl = winNotice.getDynamicObjectCollection("supplierentry");
        String sectionId = winNotice.getString("decisionsectionid");
        DynamicObjectCollection bidSectionCollection = (DynamicObjectCollection)bidDecision.get("bidsection");
        for (DynamicObject bidSectionItem : bidSectionCollection) {
            if (!sectionId.equals(bidSectionItem.get("id").toString())) continue;
            bidSectionItem.set("issendwinnotice", (Object)1);
            sectionName = bidSectionItem.getString("sectionname");
            break;
        }
        String getAppId = winNotice.getString("entitytypeid").split("_")[0];
        SendDecisionResultUtil.updateDecisionSupEntryData(getAppId, winNotice, "sendnoticeflag", bidDecision);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e2d\u6807\u901a\u77e5\u4e66\u53d1\u9001\u6210\u529f\u3002", (String)"BidWinNoticeListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        winNotice.set("issuestatus", (Object)"ISSUED");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{winNotice});
        boolean enable = SystemParamHelper.getSystemParameter((String)getAppId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (enable) {
            String appid = getAppId.split("_")[0];
            new MyTenderUtils().toUpdateMyTender(bidProject, bidDecision, sectionId, supplierEntryColl, true, appid);
        }
        NoticeMessageUtil.sendNoticeMessage(bidProject, winNotice, supplierEntryColl, projectName, sectionName, getAppId, this.getAppId() + "winnotice");
    }

    protected void setRichTextContent(DynamicObjectCollection supplierEntryColl, DynamicObject winNotice) {
        for (DynamicObject item : supplierEntryColl) {
            if (item.getLong("id") == 0L) continue;
            DynamicObject supplier = item.getDynamicObject("supplier");
            String tempSupplierId = supplier.getString("id");
            RichTextEditor richText = (RichTextEditor)this.getView().getControl(RICHTEXT_TAG + tempSupplierId);
            String contentStr = richText.getText();
            item.set("content", (Object)contentStr);
        }
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.getBillFormId()), (Object[])new DynamicObject[]{winNotice});
    }

    protected void holdRichContent(DynamicObjectCollection coll) {
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject supplierEntry = (DynamicObject)coll.get(i);
            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
            String richKey = RICHTEXT_TAG + supplier.get("id");
            ((RichTextEditor)this.getView().getControl(richKey)).setText(supplierEntry.getString("content"));
        }
    }
}

