/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.BizLog;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.common.enums.BidEvalMethodEnum;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.ScoreMethod;
import kd.scm.bid.formplugin.bill.util.BidEvaluationUtil;
import kd.scm.bid.formplugin.bill.util.ExpertGradingUtil;
import kd.scm.bid.formplugin.bill.util.NumberUtil;

public class ExpertGradingEdit
extends AbstractFormPlugin {
    protected ExpertGradingUtil expertGradingUtil = new ExpertGradingUtil();
    protected IBidEvaluationService bidEvaluationService = new BidEvaluationServiceImpl();

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        String hasTwo;
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Long bidEvaluationId = (Long)formShowParameter.getCustomParam("bidEvaluationId");
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        boolean isOnlineEval = (Boolean)formShowParameter.getCustomParam("isOnlineEval");
        String evalType = (String)formShowParameter.getCustomParam("evalType");
        String appId = formShowParameter.getServiceAppId();
        EntryAp evalScoreEntryAp = null;
        evalScoreEntryAp = StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.MULTI.getValue()) ? this.expertGradingUtil.createDynamicExpertGradingAp(bidEvaluationId, sectionId, isOnlineEval) : (StringUtils.equals((CharSequence)"true", (CharSequence)(hasTwo = (String)formShowParameter.getCustomParam("hasTwo"))) ? this.expertGradingUtil.createDynamicExpertGradingAp(bidEvaluationId, sectionId, isOnlineEval) : this.expertGradingUtil.createDynamicExpertGradingAp(bidEvaluationId, sectionId, isOnlineEval, evalType));
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "expertgrading");
        mapEntry.put("columns", (String)evalScoreEntryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long bidEvaluationId = (Long)formShowParameter.getCustomParam("bidEvaluationId");
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        this.expertGradingUtil.registDynamicProps(newMainType, bidEvaluationId, sectionId);
        e.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject e) {
        String hasTwo;
        FormView formView = (FormView)e.getSource();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Long bidEvaluationId = (Long)formShowParameter.getCustomParam("bidEvaluationId");
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        boolean isOnlineEval = (Boolean)formShowParameter.getCustomParam("isOnlineEval");
        String evalType = (String)formShowParameter.getCustomParam("evalType");
        EntryAp dynamicEntryAp = null;
        dynamicEntryAp = StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.MULTI.getValue()) ? this.expertGradingUtil.createDynamicExpertGradingAp(bidEvaluationId, sectionId, isOnlineEval) : (StringUtils.equals((CharSequence)"true", (CharSequence)(hasTwo = (String)formShowParameter.getCustomParam("hasTwo"))) ? this.expertGradingUtil.createDynamicExpertGradingAp(bidEvaluationId, sectionId, isOnlineEval) : this.expertGradingUtil.createDynamicExpertGradingAp(bidEvaluationId, sectionId, isOnlineEval, evalType));
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("expertgrading");
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                Container c = (Container)fieldEdit;
                for (Control control : c.getItems()) {
                    control.setView(this.getView());
                }
                fieldEdit.setView(this.getView());
                entryGrid.getItems().add(c);
                continue;
            }
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key != null) {
            if (key.startsWith("technical_")) {
                DecimalEdit technicalDecimalEdit = new DecimalEdit();
                technicalDecimalEdit.setKey(key);
                technicalDecimalEdit.setEntryKey("expertgrading");
                technicalDecimalEdit.setView(this.getView());
                e.setControl((Control)technicalDecimalEdit);
            } else if (key.startsWith("commercial_")) {
                DecimalEdit commercialDecimalEdit = new DecimalEdit();
                commercialDecimalEdit.setKey(key);
                commercialDecimalEdit.setEntryKey("expertgrading");
                commercialDecimalEdit.setView(this.getView());
                e.setControl((Control)commercialDecimalEdit);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.insertExpertGradingRow();
    }

    public void afterBindData(EventObject e) {
        block3: {
            String docType;
            List<String> columnKeys;
            block2: {
                super.afterBindData(e);
                IFormView formView = this.getView();
                FormShowParameter formShowParameter = formView.getFormShowParameter();
                Long bidEvaluationId = (Long)formShowParameter.getCustomParam("bidEvaluationId");
                Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
                columnKeys = this.expertGradingUtil.getExpertGradingSupplierColumnKeys(sectionId);
                DynamicObject bidEvaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"bidproject,bidproject.doctype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidEvaluationId)});
                DynamicObject bidProject = bidEvaluation.getDynamicObject("bidproject");
                docType = bidProject.getString("doctype");
                if (!StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)docType)) break block2;
                for (int i = 0; i < columnKeys.size(); ++i) {
                    String key = columnKeys.get(i);
                    if (!key.startsWith("commercial_")) continue;
                    this.getView().setVisible(Boolean.FALSE, new String[]{key});
                }
                break block3;
            }
            if (!StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)docType)) break block3;
            for (int i = 0; i < columnKeys.size(); ++i) {
                String key = columnKeys.get(i);
                if (!key.startsWith("technical_")) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{key});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if ("submit".equals(operateKey)) {
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("bidsection");
        }
    }

    protected void insertExpertGradingRow() {
        block6: {
            List<String> columnKeys;
            String evalType;
            int totalRowIndex;
            Long sectionId;
            block7: {
                String hasTwo;
                IFormView formView = this.getView();
                FormShowParameter formShowParameter = formView.getFormShowParameter();
                sectionId = (Long)formShowParameter.getCustomParam("sectionId");
                String cacheExpertGradingCollStr = (String)formShowParameter.getCustomParam("cacheData");
                boolean isOnlineEval = (Boolean)formShowParameter.getCustomParam("isOnlineEval");
                totalRowIndex = -1;
                totalRowIndex = StringUtils.isNotEmpty((CharSequence)cacheExpertGradingCollStr) ? this.insertScoreDetailByCache(cacheExpertGradingCollStr, sectionId) : this.insertScoreDetailByDataBase(sectionId);
                if (isOnlineEval) {
                    List<String> columnKeys2 = this.expertGradingUtil.getExpertGradingSupplierColumnKeys(sectionId);
                    for (int i = 0; i < totalRowIndex; ++i) {
                        String[] lockKeyArr = new String[columnKeys2.size()];
                        columnKeys2.toArray(lockKeyArr);
                        this.getView().setEnable(Boolean.FALSE, i, lockKeyArr);
                    }
                }
                if (!StringUtils.equals((CharSequence)"true", (CharSequence)(hasTwo = (String)this.getView().getFormShowParameter().getCustomParam("hasTwo")))) break block6;
                evalType = (String)formShowParameter.getCustomParam("evalType");
                if (!BidOpenTypeEnum.TECHNICAL.getValue().equals(evalType)) break block7;
                columnKeys = this.expertGradingUtil.getExpertGradingSupplierColumnKeys(sectionId);
                for (int i = 0; i < totalRowIndex; ++i) {
                    for (String column : columnKeys) {
                        if (!column.contains("commercial_")) continue;
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{column});
                    }
                }
                break block6;
            }
            if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(evalType)) break block6;
            columnKeys = this.expertGradingUtil.getExpertGradingSupplierColumnKeys(sectionId);
            for (int i = 0; i < totalRowIndex; ++i) {
                for (String column : columnKeys) {
                    if (!column.contains("technical_")) continue;
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{column});
                }
            }
        }
    }

    protected int insertScoreDetailByCache(String cacheExpertGradingCollStr, Long sectionId) {
        List bidEvalScoreDetailList = (List)SerializationUtils.fromJsonString((String)cacheExpertGradingCollStr, Object.class);
        IDataModel parentModel = this.getView().getParentView().getModel();
        String scoreMethod = (String)parentModel.getValue("scoremethod");
        if (bidEvalScoreDetailList != null) {
            IDataModel dataModel = this.getModel();
            List<String> columnKeys = this.expertGradingUtil.getExpertGradingColumnKeys(sectionId);
            for (int i = 0; i < bidEvalScoreDetailList.size(); ++i) {
                LinkedHashMap rowData = (LinkedHashMap)bidEvalScoreDetailList.get(i);
                Object proficientId = rowData.get("proficientid");
                boolean isTechnical = (Boolean)rowData.get("istechnical");
                boolean isCommercial = (Boolean)rowData.get("iscommercial");
                String evalType = (String)rowData.get("evaltype");
                String hasTwo = (String)this.getView().getFormShowParameter().getCustomParam("hasTwo");
                if (!StringUtils.equals((CharSequence)"true", (CharSequence)hasTwo) && (BidOpenTypeEnum.TECHNICAL.getValue().equals(evalType) && !isTechnical || BidOpenTypeEnum.BUSSINESS.getValue().equals(evalType) && !isCommercial)) continue;
                int newEntryRow = dataModel.createNewEntryRow("expertgrading");
                for (int j = 0; j < columnKeys.size(); ++j) {
                    String key = columnKeys.get(j);
                    if (!"evaltype".equals(key)) {
                        dataModel.setValue(key, rowData.get(key), newEntryRow);
                    }
                    if (key.startsWith("technical_") && !isTechnical) {
                        this.getView().setEnable(Boolean.FALSE, newEntryRow, new String[]{key});
                        continue;
                    }
                    if (!key.startsWith("commercial_") || isCommercial) continue;
                    this.getView().setEnable(Boolean.FALSE, newEntryRow, new String[]{key});
                }
            }
            this.handlerAvgScoreRow(columnKeys, true);
            DynamicObjectCollection entryColl = this.getModel().getEntryEntity("expertgrading");
            int totalRowIndex = entryColl.size() - 1;
            this.lockOrUnLockTotalRowColumn(sectionId, totalRowIndex);
            return totalRowIndex;
        }
        return -1;
    }

    protected int insertScoreDetailByDataBase(Long sectionId) {
        IDataModel dataModel = this.getModel();
        Map<Long, LinkedHashMap<String, Object>> rowMap = this.getScoreDetailByDataBase(sectionId);
        Set<Long> keySet = rowMap.keySet();
        Iterator<Long> iterator = keySet.iterator();
        for (Map.Entry<Long, LinkedHashMap<String, Object>> row : rowMap.entrySet()) {
            Long key = row.getKey();
            HashMap rowDataMap = row.getValue();
            boolean isTechnical = (Boolean)rowDataMap.get("istechnical");
            boolean isCommercial = (Boolean)rowDataMap.get("iscommercial");
            String evalType = (String)rowDataMap.get("evaltype");
            String hasTwo = (String)this.getView().getFormShowParameter().getCustomParam("hasTwo");
            if (!StringUtils.equals((CharSequence)"true", (CharSequence)hasTwo) && (!isTechnical && BidOpenTypeEnum.TECHNICAL.getValue().equals(evalType) || !isCommercial && BidOpenTypeEnum.BUSSINESS.getValue().equals(evalType))) continue;
            int newEntryRow = dataModel.createNewEntryRow("expertgrading");
            for (Map.Entry rowDataMapEntry : rowDataMap.entrySet()) {
                String rowDataKey = (String)rowDataMapEntry.getKey();
                Object rowData = rowDataMapEntry.getValue();
                if (!"evaltype".equals(rowDataKey)) {
                    dataModel.setValue(rowDataKey, rowData, newEntryRow);
                }
                if (rowDataKey.startsWith("technical_") && !isTechnical) {
                    this.getView().setEnable(Boolean.FALSE, newEntryRow, new String[]{rowDataKey});
                    continue;
                }
                if (!rowDataKey.startsWith("commercial_") || isCommercial) continue;
                this.getView().setEnable(Boolean.FALSE, newEntryRow, new String[]{rowDataKey});
            }
        }
        if (rowMap.size() == 0) {
            return -1;
        }
        IDataModel parentModel = this.getView().getParentView().getModel();
        String scoreMethod = (String)parentModel.getValue("scoremethod");
        List<String> columnKeys = this.expertGradingUtil.getExpertGradingColumnKeys(sectionId);
        this.handlerAvgScoreRow(columnKeys, false);
        return this.insertSupplierTotalScoreByDataBase(sectionId);
    }

    protected Map<Long, LinkedHashMap<String, Object>> getScoreDetailByDataBase(Long sectionId) {
        String scoreDetailSelectFields = "id,entryseq,technical,commercial,proficient,proficient.id,section.id,proficient.name,proficient.majortypenames,supplier.id,bidevaluationentry.supplier.id,bidevaluationentry.supplier.number,bidevaluationentry.supplier.name,commercialscore,technicalscore,bidevaluation.evaltype,bidevaluation.bidproject.id,bidevaluation.bidproject.bidopentype";
        DynamicObjectCollection bidEvalScoreDetailColl = this.bidEvaluationService.listBidEvalScoreDetailBySections(sectionId, scoreDetailSelectFields);
        BizLog.log((String)("sectionId:" + sectionId));
        BizLog.log((String)("bidEvalScoreDetailColl:" + bidEvalScoreDetailColl));
        LinkedHashMap<Long, LinkedHashMap<String, Object>> rowMap = new LinkedHashMap<Long, LinkedHashMap<String, Object>>();
        Long secondSectionId = this.getSecondSectionId();
        if (secondSectionId != 0L) {
            ArrayList<String> idList = new ArrayList<String>();
            for (DynamicObject bidEvalThere : bidEvalScoreDetailColl) {
                Object thereSupplierId = bidEvalThere.get("supplier.id");
                idList.add(thereSupplierId.toString());
            }
            DynamicObjectCollection bidEvalScoreDetailCollSecondSection = this.bidEvaluationService.listBidEvalScoreDetailBySections(secondSectionId, scoreDetailSelectFields);
            if (!CollectionUtils.isEmpty((Collection)bidEvalScoreDetailCollSecondSection)) {
                Iterator it = bidEvalScoreDetailCollSecondSection.iterator();
                while (it.hasNext()) {
                    DynamicObject thisScore = (DynamicObject)it.next();
                    Object thisSupplierId = thisScore.get("supplier.id");
                    if (CollectionUtils.isEmpty(idList) || idList.contains(thisSupplierId.toString())) continue;
                    it.remove();
                }
            }
            if (bidEvalScoreDetailCollSecondSection != null && bidEvalScoreDetailCollSecondSection.size() > 0) {
                bidEvalScoreDetailColl.addAll((Collection)bidEvalScoreDetailCollSecondSection);
            }
        }
        if (bidEvalScoreDetailColl != null && bidEvalScoreDetailColl.size() > 0) {
            String evalType = ((DynamicObject)bidEvalScoreDetailColl.get(0)).getString("bidevaluation.evaltype");
            for (int i = 0; i < bidEvalScoreDetailColl.size(); ++i) {
                BigDecimal commercialscore;
                DynamicObject bidEvalScoreDetail = (DynamicObject)bidEvalScoreDetailColl.get(i);
                Long proficientId = bidEvalScoreDetail.getLong("proficient.id");
                LinkedHashMap<String, Object> rowDataMap = (LinkedHashMap<String, Object>)rowMap.get(proficientId);
                if (rowDataMap == null) {
                    rowDataMap = new LinkedHashMap<String, Object>();
                    rowMap.put(proficientId, rowDataMap);
                    DynamicObject proficient = BusinessDataServiceHelper.loadSingle((Object)proficientId, (String)"bid_proficient", (String)"name, majortypenames");
                    BizLog.log((String)("bidEval bidEvalScoreDetail:" + bidEvalScoreDetail));
                    BizLog.log((String)("bidEval proficient\uff1a" + proficient));
                    String proficientName = proficient.getString("name");
                    BizLog.log((String)("bidEval proficient.name\uff1a" + proficientName));
                    String majortypenames = proficient.getString("majortypenames");
                    BizLog.log((String)("bidEval proficient.majortypenames\uff1a" + majortypenames));
                    boolean technical = bidEvalScoreDetail.getBoolean("technical");
                    boolean commercial = bidEvalScoreDetail.getBoolean("commercial");
                    rowDataMap.put("proficientid", proficientId);
                    rowDataMap.put("proficientname", proficientName);
                    rowDataMap.put("majortypenames", majortypenames);
                    rowDataMap.put("istechnical", technical);
                    rowDataMap.put("iscommercial", commercial);
                }
                String supplierNumber = bidEvalScoreDetail.getString("bidevaluationentry.supplier.number").toLowerCase();
                supplierNumber = supplierNumber.replace('.', '_');
                Long supplierId = bidEvalScoreDetail.getLong("bidevaluationentry.supplier.id");
                rowDataMap.put("supplierid_" + supplierNumber, supplierId);
                if (secondSectionId != 0L) {
                    String thisEvalType = bidEvalScoreDetail.getString("bidevaluation.evaltype");
                    if (thisEvalType.equals("TECHNICAL")) {
                        BigDecimal technicalscore = bidEvalScoreDetail.getBigDecimal("technicalscore");
                        rowDataMap.put("technical_" + supplierNumber, technicalscore);
                    } else {
                        commercialscore = bidEvalScoreDetail.getBigDecimal("commercialscore");
                        rowDataMap.put("commercial_" + supplierNumber, commercialscore);
                    }
                } else {
                    BigDecimal technicalscore = bidEvalScoreDetail.getBigDecimal("technicalscore");
                    rowDataMap.put("technical_" + supplierNumber, technicalscore);
                    commercialscore = bidEvalScoreDetail.getBigDecimal("commercialscore");
                    rowDataMap.put("commercial_" + supplierNumber, commercialscore);
                }
                rowDataMap.put("evaltype", evalType);
            }
        }
        return rowMap;
    }

    protected int insertSupplierTotalScoreByDataBase(Long sectionId) {
        IDataModel dataModel = this.getModel();
        int newEntryRow = dataModel.createNewEntryRow("expertgrading");
        dataModel.setValue("proficientname", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ExpertGradingEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), newEntryRow);
        String entrySelectFields = "id,entryseq,supplier.id,supplier.number,score,section.id";
        DynamicObjectCollection bidEvalEntryColl = this.bidEvaluationService.listBidEvalEntryBySections(sectionId, entrySelectFields);
        IDataModel parentdataModel = this.getView().getParentView().getModel();
        DynamicObject parentdataEntity = parentdataModel.getDataEntity(true);
        String scoremethod = parentdataEntity.getString("scoremethod");
        String evaltype = parentdataEntity.getString("evaltype");
        boolean isSpe = ScoreMethod.SPECIAL.getVal().equals(scoremethod);
        boolean istec = BidOpenTypeEnum.TECHNICAL.getValue().equals(evaltype);
        boolean flag = isSpe && istec;
        for (int i = 0; i < bidEvalEntryColl.size(); ++i) {
            DynamicObject bidEvalEntry = (DynamicObject)bidEvalEntryColl.get(i);
            Long supplierId = bidEvalEntry.getLong("supplier.id");
            String supplierNumber = bidEvalEntry.getString("supplier.number").toLowerCase();
            supplierNumber = supplierNumber.replace('.', '_');
            String supplierIdKey = "supplierid_" + supplierNumber;
            String technicalKey = "technical_" + supplierNumber;
            String commercialKey = "commercial_" + supplierNumber;
            BigDecimal score = bidEvalEntry.getBigDecimal("score");
            dataModel.setValue(supplierIdKey, (Object)supplierId, newEntryRow);
            if (flag) {
                dataModel.setValue(technicalKey, (Object)score, newEntryRow);
            } else {
                dataModel.setValue(commercialKey, (Object)score, newEntryRow);
            }
            dataModel.setValue("istechnical", (Object)Boolean.TRUE, newEntryRow);
            dataModel.setValue("iscommercial", (Object)Boolean.TRUE, newEntryRow);
        }
        this.lockOrUnLockTotalRowColumn(sectionId, newEntryRow);
        return newEntryRow;
    }

    protected void lockOrUnLockTotalRowColumn(Long sectionId, int totalRowIndex) {
        IDataModel dataModel = this.getView().getParentView().getModel();
        String scoreMethod = (String)dataModel.getValue("scoremethod");
        String evalType = (String)dataModel.getValue("evaltype");
        DynamicObject bidProject = (DynamicObject)dataModel.getValue("bidproject");
        String bidOpenType = bidProject.getString("bidopentype");
        List<String> columnKeys = this.expertGradingUtil.getExpertGradingSupplierColumnKeys(sectionId);
        ArrayList<String> technicalLockKeyList = new ArrayList<String>();
        ArrayList<String> commercialLockKeyList = new ArrayList<String>();
        for (int i = 0; i < columnKeys.size(); ++i) {
            String columnKey = columnKeys.get(i);
            if (columnKey.startsWith("technical_")) {
                technicalLockKeyList.add(columnKey);
                continue;
            }
            if (!columnKey.startsWith("commercial_")) continue;
            commercialLockKeyList.add(columnKey);
        }
        if (!BidOpenTypeEnum.TECHNICAL.getValue().equals(evalType)) {
            String[] technicalLockKeyArr = new String[technicalLockKeyList.size()];
            technicalLockKeyList.toArray(technicalLockKeyArr);
            this.getView().setEnable(Boolean.FALSE, totalRowIndex, technicalLockKeyArr);
        } else if (BidOpenSelectTypeEnum.BUSSINESSTECH.getValue().equals(bidOpenType)) {
            String[] technicalLockKeyArr = new String[technicalLockKeyList.size()];
            technicalLockKeyList.toArray(technicalLockKeyArr);
            this.getView().setEnable(Boolean.FALSE, totalRowIndex, technicalLockKeyArr);
        }
        if (ScoreMethod.AVG_SCORE.getVal().equals(scoreMethod) || ScoreMethod.TRUNC_AVG_SCORE.getVal().equals(scoreMethod)) {
            String[] commercialLockKeyArr = new String[commercialLockKeyList.size()];
            commercialLockKeyList.toArray(commercialLockKeyArr);
            this.getView().setEnable(Boolean.FALSE, totalRowIndex, commercialLockKeyArr);
            String[] technicalLockKeyArr = new String[technicalLockKeyList.size()];
            technicalLockKeyList.toArray(technicalLockKeyArr);
            this.getView().setEnable(Boolean.FALSE, totalRowIndex, technicalLockKeyArr);
            this.calcTotalRow(commercialLockKeyList, true);
        } else {
            this.calcTotalRow(commercialLockKeyList, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        ChangeData data = changeData[0];
        int rowIndex = data.getRowIndex();
        String propName = e.getProperty().getName();
        if (propName.startsWith("technical_") || propName.startsWith("commercial_")) {
            IDataModel parentModel = this.getView().getParentView().getModel();
            String scoreMethod = (String)parentModel.getValue("scoremethod");
            DynamicObjectCollection expertGradingColl = this.getModel().getEntryEntity("expertgrading");
            int totalRowIndex = expertGradingColl.size() - 1;
            if (rowIndex == totalRowIndex || rowIndex >= expertGradingColl.size() - 3) {
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
            List<String> columnKeys = this.expertGradingUtil.getExpertGradingColumnKeys(sectionId);
            this.handlerAvgScoreRow(columnKeys, false);
            ArrayList<String> commercialLockKeyList = new ArrayList<String>();
            for (int i = 0; i < columnKeys.size(); ++i) {
                String columnKey = columnKeys.get(i);
                if (!columnKey.startsWith("commercial_")) continue;
                commercialLockKeyList.add(columnKey);
            }
            this.calcTotalRow(commercialLockKeyList, true);
        }
    }

    protected void calcTotalRow(List<String> commercialLockKeyList, boolean flag) {
        DynamicObject bidevalResult_DOCC;
        DynamicObjectCollection bidevalResult_DOC;
        ArrayList list;
        Map map;
        DynamicObject bidprojectInfo;
        Object doctype;
        String proficientName;
        IDataModel dataModel = this.getModel();
        boolean viewWeightRow = (Boolean)this.getView().getFormShowParameter().getCustomParam("weightScoreVisiable");
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("expertgrading");
        if (entryColl == null || entryColl.size() <= 0) {
            return;
        }
        String hasTwo = (String)this.getView().getFormShowParameter().getCustomParam("hasTwo");
        final IDataModel parentModel = this.getView().getParentView().getModel();
        String scoreMethod = (String)parentModel.getValue("scoremethod");
        String evalType = (String)parentModel.getValue("evaltype");
        if (flag && (ScoreMethod.AVG_SCORE.getVal().equals(scoreMethod) || ScoreMethod.TRUNC_AVG_SCORE.getVal().equals(scoreMethod) || ScoreMethod.SPECIAL.getVal().equals(scoreMethod))) {
            int size = entryColl.size();
            int totalRowIndex = size - 1;
            DynamicObject weightEntryRow = (DynamicObject)entryColl.get(size - 2);
            for (String comColKey : commercialLockKeyList) {
                String techColkey = comColKey.replace("commercial_", "technical_");
                BigDecimal totalScore = NumberUtil.add(weightEntryRow.get(techColkey), weightEntryRow.get(comColKey));
                dataModel.setValue(comColKey, (Object)totalScore, totalRowIndex);
                if (StringUtils.equals((CharSequence)"true", (CharSequence)hasTwo) || !BidOpenTypeEnum.TECHNICAL.getValue().equals(evalType)) continue;
                dataModel.setValue(techColkey, (Object)totalScore, totalRowIndex);
            }
        }
        IFormView parentView = this.getView().getParentView();
        IDataModel model = this.getView().getParentView().getModel();
        BigDecimal techweight = (BigDecimal)model.getValue("techweight");
        BigDecimal commweight = (BigDecimal)model.getValue("commweight");
        String evalMethod = model.getValue("evaluatedmethod").toString();
        String evaltype = model.getValue("evaltype").toString();
        DynamicObjectCollection expertGradingColl = this.getModel().getEntryEntity("expertgrading");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        Long opensrcsectionid = (Long)formShowParameter.getCustomParam("opensrcsectionid");
        List<String> columnKeys = this.expertGradingUtil.getExpertGradingColumnKeys(sectionId);
        HashMap mapSupplier = new HashMap();
        boolean isAvg = false;
        boolean isqzAvg = false;
        for (DynamicObject expertGradingInfo : expertGradingColl) {
            proficientName = (String)expertGradingInfo.get("proficientname");
            if (proficientName.equals(ResManager.loadKDString((String)"\u8bc4\u6807\u5e73\u5747\u5206", (String)"ExpertGradingEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]))) {
                isAvg = true;
                continue;
            }
            if (!proficientName.equals(ResManager.loadKDString((String)"\u8bc4\u6807\u6743\u91cd\u5f97\u5206", (String)"ExpertGradingEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]))) continue;
            isqzAvg = true;
        }
        for (DynamicObject expertGradingInfo : expertGradingColl) {
            HashMap<String, Object> map2;
            Map supplierMap;
            String supplierNumber;
            String columnKey;
            int i;
            proficientName = (String)expertGradingInfo.get("proficientname");
            if (proficientName.equals(ResManager.loadKDString((String)"\u8bc4\u6807\u5e73\u5747\u5206", (String)"ExpertGradingEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]))) {
                for (i = 0; i < columnKeys.size(); ++i) {
                    columnKey = columnKeys.get(i);
                    if (columnKey.startsWith("technical_")) {
                        supplierNumber = columnKey.substring(10);
                        supplierMap = (Map)mapSupplier.get(supplierNumber);
                        if (!CollectionUtils.isEmpty((Map)supplierMap)) {
                            supplierMap.put("technicalscore", expertGradingInfo.get(columnKey));
                            continue;
                        }
                        map2 = new HashMap<String, Object>();
                        map2.put("technicalscore", expertGradingInfo.get(columnKey));
                        mapSupplier.put(supplierNumber, map2);
                        continue;
                    }
                    if (!columnKey.startsWith("commercial_")) continue;
                    supplierNumber = columnKey.substring(11);
                    supplierMap = (Map)mapSupplier.get(supplierNumber);
                    if (!CollectionUtils.isEmpty((Map)supplierMap)) {
                        supplierMap.put("commercialscore", expertGradingInfo.get(columnKey));
                        continue;
                    }
                    map2 = new HashMap();
                    map2.put("commercialscore", expertGradingInfo.get(columnKey));
                    mapSupplier.put(supplierNumber, map2);
                }
                continue;
            }
            if (proficientName.equals(ResManager.loadKDString((String)"\u8bc4\u6807\u6743\u91cd\u5f97\u5206", (String)"ExpertGradingEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]))) {
                for (i = 0; i < columnKeys.size(); ++i) {
                    columnKey = columnKeys.get(i);
                    if (columnKey.startsWith("technical_")) {
                        supplierNumber = columnKey.substring(10);
                        supplierMap = (Map)mapSupplier.get(supplierNumber);
                        if (!CollectionUtils.isEmpty((Map)supplierMap)) {
                            supplierMap.put("technicalscore", expertGradingInfo.get(columnKey));
                            continue;
                        }
                        map2 = new HashMap();
                        map2.put("technicalscore", expertGradingInfo.get(columnKey));
                        mapSupplier.put(supplierNumber, map2);
                        continue;
                    }
                    if (!columnKey.startsWith("commercial_")) continue;
                    supplierNumber = columnKey.substring(11);
                    supplierMap = (Map)mapSupplier.get(supplierNumber);
                    if (!CollectionUtils.isEmpty((Map)supplierMap)) {
                        supplierMap.put("commercialscore", expertGradingInfo.get(columnKey));
                        continue;
                    }
                    map2 = new HashMap();
                    map2.put("commercialscore", expertGradingInfo.get(columnKey));
                    mapSupplier.put(supplierNumber, map2);
                }
                continue;
            }
            if (!proficientName.equals(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ExpertGradingEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]))) continue;
            for (i = 0; i < columnKeys.size(); ++i) {
                HashMap<String, Object> map3;
                Map supplierMap2;
                String supplierNumber2;
                BigDecimal score;
                columnKey = columnKeys.get(i);
                if (columnKey.startsWith("technical_")) {
                    score = (BigDecimal)expertGradingInfo.get(columnKey);
                    supplierNumber2 = columnKey.substring(10);
                    supplierMap2 = (Map)mapSupplier.get(supplierNumber2);
                    if (!CollectionUtils.isEmpty((Map)supplierMap2)) {
                        supplierMap2.put("comprehensivescore", expertGradingInfo.get(columnKey));
                        continue;
                    }
                    map3 = new HashMap<String, Object>();
                    map3.put("comprehensivescore", expertGradingInfo.get(columnKey));
                    mapSupplier.put(supplierNumber2, map3);
                    continue;
                }
                if (!columnKey.startsWith("commercial_")) continue;
                score = (BigDecimal)expertGradingInfo.get(columnKey);
                supplierNumber2 = columnKey.substring(11);
                supplierMap2 = (Map)mapSupplier.get(supplierNumber2);
                if (!CollectionUtils.isEmpty((Map)supplierMap2)) {
                    supplierMap2.put("comprehensivescore", expertGradingInfo.get(columnKey));
                    continue;
                }
                map3 = new HashMap();
                map3.put("comprehensivescore", expertGradingInfo.get(columnKey));
                mapSupplier.put(supplierNumber2, map3);
            }
        }
        DynamicObject bidEvaluation = model.getDataEntity(true);
        final boolean isBussiness = BidEvaluationUtil.getIsBussiness(evalMethod, evaltype, bidEvaluation);
        boolean isMulit = false;
        if (!StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DX.getCode()) && evaltype.equals("BUSSINESS") && (doctype = (bidprojectInfo = bidEvaluation.getDynamicObject("bidproject")).getString("doctype")) != null && !((String)doctype).equals("") && ((String)doctype).equals("MULTI")) {
            isMulit = true;
        }
        DynamicObjectCollection bidsectionenrollCol = model.getDataEntity(true).getDynamicObjectCollection("bidsectionenroll");
        for (DynamicObject bidSectionenroll_DO : bidsectionenrollCol) {
            long opensectid = bidSectionenroll_DO.getLong("opensectid");
            if (opensectid != opensrcsectionid) continue;
            DynamicObjectCollection bidevalResult_DOC2 = bidSectionenroll_DO.getDynamicObjectCollection("bidevalresult");
            for (DynamicObject bidevalResult_DOCC2 : bidevalResult_DOC2) {
                String suppliernumber = bidevalResult_DOCC2.get("suppliernumber").toString();
                suppliernumber = suppliernumber.toLowerCase();
                map = (Map)mapSupplier.get(suppliernumber = suppliernumber.replace('.', '_'));
                if (CollectionUtils.isEmpty((Map)map)) continue;
                map.put("supplier", bidevalResult_DOCC2.get("supplier"));
                map.put("suppliername", bidevalResult_DOCC2.get("suppliername"));
                map.put("suppliernumber", bidevalResult_DOCC2.get("suppliernumber"));
                map.put("technicalresult", bidevalResult_DOCC2.get("technicalresult"));
                map.put("commercialresult", bidevalResult_DOCC2.get("commercialresult"));
                map.put("tenderprice", bidevalResult_DOCC2.get("tenderprice"));
                map.put("candidate", bidevalResult_DOCC2.get("candidate"));
                map.put("remark", bidevalResult_DOCC2.get("remark"));
                if (isAvg) continue;
                map.put("technicalscore", bidevalResult_DOCC2.get("technicalscore"));
                map.put("commercialscore", bidevalResult_DOCC2.get("commercialscore"));
            }
        }
        if (StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DX.getCode())) {
            list = new ArrayList(mapSupplier.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, Map<String, Object>>>(){

                @Override
                public int compare(Map.Entry<String, Map<String, Object>> o1, Map.Entry<String, Map<String, Object>> o2) {
                    Map<String, Object> map1 = o1.getValue();
                    Map<String, Object> map2 = o2.getValue();
                    BigDecimal tenderPrice1 = (BigDecimal)map1.get("tenderPrice");
                    BigDecimal tenderPrice2 = (BigDecimal)map2.get("tenderPrice");
                    String techevalresult1 = (String)map1.get("technicalresult");
                    String busevalresult1 = (String)map1.get("commercialresult");
                    String techevalresult2 = (String)map2.get("technicalresult");
                    String busevalresult2 = (String)map2.get("commercialresult");
                    if (tenderPrice1 == null) {
                        tenderPrice1 = BigDecimal.ZERO;
                    }
                    if (tenderPrice2 == null) {
                        tenderPrice2 = BigDecimal.ZERO;
                    }
                    if (techevalresult1 == null || techevalresult1.equals("")) {
                        techevalresult1 = "0";
                    }
                    if (techevalresult2 == null || techevalresult2.equals("")) {
                        techevalresult2 = "0";
                    }
                    if (busevalresult1 == null || busevalresult1.equals("")) {
                        busevalresult1 = "0";
                    }
                    if (busevalresult2 == null || busevalresult2.equals("")) {
                        busevalresult2 = "0";
                    }
                    if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                        return 0;
                    }
                    if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && techevalresult2.equals("1") && busevalresult2.equals("1")) {
                        return 1;
                    }
                    if (techevalresult1.equals("1") && busevalresult1.equals("1") && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                        return -1;
                    }
                    if (techevalresult1.equals("1") && busevalresult1.equals("1") && techevalresult2.equals("1") && busevalresult2.equals("1")) {
                        return tenderPrice1.compareTo(tenderPrice2);
                    }
                    return 0;
                }
            });
            for (DynamicObject bidSectionenroll_DO : bidsectionenrollCol) {
                long opensectid = bidSectionenroll_DO.getLong("opensectid");
                if (opensectid != opensrcsectionid) continue;
                bidevalResult_DOC = bidSectionenroll_DO.getDynamicObjectCollection("bidevalresult");
                for (int i = 0; i < bidevalResult_DOC.size(); ++i) {
                    bidevalResult_DOCC = (DynamicObject)bidevalResult_DOC.get(i);
                    map = null;
                    if (list.size() == bidevalResult_DOC.size()) {
                        map = (Map)((Map.Entry)list.get(i)).getValue();
                    } else {
                        String toString = bidevalResult_DOCC.getDynamicObject("supplier").getPkValue().toString();
                        map = list.stream().filter(l -> {
                            Map value = (Map)l.getValue();
                            DynamicObject supplier = (DynamicObject)value.get("supplier");
                            if (supplier == null) {
                                return false;
                            }
                            return StringUtils.equals((CharSequence)toString, (CharSequence)supplier.getPkValue().toString());
                        }).map(l -> (Map)l.getValue()).findFirst().get();
                        if (map == null || map.size() == 0) continue;
                    }
                    bidevalResult_DOCC.set("supplier", map.get("supplier"));
                    bidevalResult_DOCC.set("suppliername", map.get("suppliername"));
                    bidevalResult_DOCC.set("suppliernumber", map.get("suppliernumber"));
                    bidevalResult_DOCC.set("technicalresult", map.get("technicalresult"));
                    bidevalResult_DOCC.set("commercialresult", map.get("commercialresult"));
                    bidevalResult_DOCC.set("tenderprice", map.get("tenderprice"));
                    bidevalResult_DOCC.set("technicalscore", map.get("technicalscore"));
                    bidevalResult_DOCC.set("commercialscore", map.get("commercialscore"));
                    bidevalResult_DOCC.set("score", map.get("comprehensivescore"));
                    bidevalResult_DOCC.set("ranking", (Object)(i + 1));
                    bidevalResult_DOCC.set("candidate", map.get("candidate"));
                    bidevalResult_DOCC.set("remark", map.get("remark"));
                }
            }
        } else if (StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL.getCode())) {
            list = new ArrayList(mapSupplier.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, Map<String, Object>>>(){

                @Override
                public int compare(Map.Entry<String, Map<String, Object>> o1, Map.Entry<String, Map<String, Object>> o2) {
                    DynamicObject evaobject;
                    Map<String, Object> map1 = o1.getValue();
                    Map<String, Object> map2 = o2.getValue();
                    BigDecimal comprehensivescore1 = (BigDecimal)map1.get("comprehensivescore");
                    BigDecimal comprehensivescore2 = (BigDecimal)map2.get("comprehensivescore");
                    BigDecimal tenderPrice1 = (BigDecimal)map1.get("tenderprice");
                    BigDecimal tenderPrice2 = (BigDecimal)map2.get("tenderprice");
                    if (tenderPrice1 == null) {
                        tenderPrice1 = BigDecimal.ZERO;
                    }
                    if (tenderPrice2 == null) {
                        tenderPrice2 = BigDecimal.ZERO;
                    }
                    if (comprehensivescore1 == null) {
                        comprehensivescore1 = BigDecimal.ZERO;
                    }
                    if (comprehensivescore2 == null) {
                        comprehensivescore2 = BigDecimal.ZERO;
                    }
                    if ((evaobject = parentModel.getDataEntity(true).getDynamicObject("evaluatedecideway")) != null) {
                        String evaname = evaobject.getString("name");
                        Long typeId = evaobject.getLong("id");
                        if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                            return tenderPrice1.compareTo(tenderPrice2);
                        }
                    }
                    if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                        return tenderPrice1.compareTo(tenderPrice2);
                    }
                    return comprehensivescore2.compareTo(comprehensivescore1);
                }
            });
            for (DynamicObject bidSectionenroll_DO : bidsectionenrollCol) {
                long opensectid = bidSectionenroll_DO.getLong("opensectid");
                if (opensectid != opensrcsectionid) continue;
                bidevalResult_DOC = bidSectionenroll_DO.getDynamicObjectCollection("bidevalresult");
                for (int i = 0; i < list.size(); ++i) {
                    Map map4 = (Map)((Map.Entry)list.get(i)).getValue();
                    DynamicObject bidevalResult_DOCC3 = (DynamicObject)bidevalResult_DOC.get(i);
                    bidevalResult_DOCC3.set("supplier", map4.get("supplier"));
                    bidevalResult_DOCC3.set("suppliername", map4.get("suppliername"));
                    bidevalResult_DOCC3.set("suppliernumber", map4.get("suppliernumber"));
                    bidevalResult_DOCC3.set("technicalresult", map4.get("technicalresult"));
                    bidevalResult_DOCC3.set("commercialresult", map4.get("commercialresult"));
                    bidevalResult_DOCC3.set("tenderprice", map4.get("tenderprice"));
                    bidevalResult_DOCC3.set("technicalscore", map4.get("technicalscore"));
                    bidevalResult_DOCC3.set("commercialscore", map4.get("commercialscore"));
                    bidevalResult_DOCC3.set("score", map4.get("comprehensivescore"));
                    bidevalResult_DOCC3.set("ranking", (Object)(i + 1));
                    bidevalResult_DOCC3.set("candidate", map4.get("candidate"));
                    bidevalResult_DOCC3.set("remark", map4.get("remark"));
                }
            }
        } else if (StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DL_DX.getCode())) {
            list = new ArrayList(mapSupplier.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, Map<String, Object>>>(){

                @Override
                public int compare(Map.Entry<String, Map<String, Object>> o1, Map.Entry<String, Map<String, Object>> o2) {
                    Map<String, Object> map1 = o1.getValue();
                    Map<String, Object> map2 = o2.getValue();
                    BigDecimal comprehensivescore1 = (BigDecimal)map1.get("comprehensivescore");
                    BigDecimal comprehensivescore2 = (BigDecimal)map2.get("comprehensivescore");
                    String techevalresult1 = (String)map1.get("technicalresult");
                    String busevalresult1 = (String)map1.get("commercialresult");
                    String techevalresult2 = (String)map2.get("technicalresult");
                    String busevalresult2 = (String)map2.get("commercialresult");
                    BigDecimal tenderPrice1 = (BigDecimal)map1.get("tenderprice");
                    BigDecimal tenderPrice2 = (BigDecimal)map2.get("tenderprice");
                    if (tenderPrice1 == null) {
                        tenderPrice1 = BigDecimal.ZERO;
                    }
                    if (tenderPrice2 == null) {
                        tenderPrice2 = BigDecimal.ZERO;
                    }
                    if (comprehensivescore1 == null) {
                        comprehensivescore1 = BigDecimal.ZERO;
                    }
                    if (comprehensivescore2 == null) {
                        comprehensivescore2 = BigDecimal.ZERO;
                    }
                    if (techevalresult1 == null || techevalresult1.equals("")) {
                        techevalresult1 = "0";
                    }
                    if (techevalresult2 == null || techevalresult2.equals("")) {
                        techevalresult2 = "0";
                    }
                    if (busevalresult1 == null || busevalresult1.equals("")) {
                        busevalresult1 = "0";
                    }
                    if (busevalresult2 == null || busevalresult2.equals("")) {
                        busevalresult2 = "0";
                    }
                    DynamicObject evaobject = parentModel.getDataEntity(true).getDynamicObject("evaluatedecideway");
                    if (isBussiness) {
                        if (busevalresult1.equals("0") && busevalresult2.equals("0")) {
                            if (evaobject != null) {
                                String evaname = evaobject.getString("name");
                                Long typeId = evaobject.getLong("id");
                                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                                    return tenderPrice1.compareTo(tenderPrice2);
                                }
                            }
                            if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                            return comprehensivescore2.compareTo(comprehensivescore1);
                        }
                        if (busevalresult1.equals("0") && busevalresult2.equals("1")) {
                            return 1;
                        }
                        if (busevalresult1.equals("1") && busevalresult2.equals("0")) {
                            return -1;
                        }
                        if (busevalresult1.equals("1") && busevalresult2.equals("1")) {
                            if (evaobject != null) {
                                String evaname = evaobject.getString("name");
                                Long typeId = evaobject.getLong("id");
                                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                                    return tenderPrice1.compareTo(tenderPrice2);
                                }
                            }
                            if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                            return comprehensivescore2.compareTo(comprehensivescore1);
                        }
                    } else {
                        if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                            if (evaobject != null) {
                                String evaname = evaobject.getString("name");
                                Long typeId = evaobject.getLong("id");
                                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                                    return tenderPrice1.compareTo(tenderPrice2);
                                }
                            }
                            if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                            return comprehensivescore2.compareTo(comprehensivescore1);
                        }
                        if ((techevalresult1.equals("0") || busevalresult1.equals("0")) && techevalresult2.equals("1") && busevalresult2.equals("1")) {
                            return 1;
                        }
                        if (techevalresult1.equals("1") && busevalresult1.equals("1") && (techevalresult2.equals("0") || busevalresult2.equals("0"))) {
                            return -1;
                        }
                        if (techevalresult1.equals("1") && busevalresult1.equals("1") && (techevalresult2.equals("1") || busevalresult2.equals("1"))) {
                            if (evaobject != null) {
                                String evaname = evaobject.getString("name");
                                Long typeId = evaobject.getLong("id");
                                if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                                    return tenderPrice1.compareTo(tenderPrice2);
                                }
                            }
                            if (comprehensivescore1.compareTo(comprehensivescore2) == 0) {
                                return tenderPrice1.compareTo(tenderPrice2);
                            }
                            return comprehensivescore2.compareTo(comprehensivescore1);
                        }
                    }
                    return 0;
                }
            });
            for (DynamicObject bidSectionenroll_DO : bidsectionenrollCol) {
                long opensectid = bidSectionenroll_DO.getLong("opensectid");
                if (opensectid != opensrcsectionid) continue;
                bidevalResult_DOC = bidSectionenroll_DO.getDynamicObjectCollection("bidevalresult");
                for (int i = 0; i < bidevalResult_DOC.size(); ++i) {
                    bidevalResult_DOCC = (DynamicObject)bidevalResult_DOC.get(i);
                    map = null;
                    if (list.size() == bidevalResult_DOC.size()) {
                        map = (Map)((Map.Entry)list.get(i)).getValue();
                    } else {
                        String toString = bidevalResult_DOCC.getDynamicObject("supplier").getPkValue().toString();
                        map = list.stream().filter(l -> {
                            Map value = (Map)l.getValue();
                            DynamicObject supplier = (DynamicObject)value.get("supplier");
                            if (supplier == null) {
                                return false;
                            }
                            return StringUtils.equals((CharSequence)toString, (CharSequence)supplier.getPkValue().toString());
                        }).map(l -> (Map)l.getValue()).findFirst().get();
                        if (map == null || map.size() == 0) continue;
                    }
                    bidevalResult_DOCC.set("supplier", map.get("supplier"));
                    bidevalResult_DOCC.set("suppliername", map.get("suppliername"));
                    bidevalResult_DOCC.set("suppliernumber", map.get("suppliernumber"));
                    bidevalResult_DOCC.set("technicalresult", map.get("technicalresult"));
                    bidevalResult_DOCC.set("commercialresult", map.get("commercialresult"));
                    bidevalResult_DOCC.set("tenderprice", map.get("tenderprice"));
                    bidevalResult_DOCC.set("technicalscore", map.get("technicalscore"));
                    bidevalResult_DOCC.set("commercialscore", map.get("commercialscore"));
                    bidevalResult_DOCC.set("score", map.get("comprehensivescore"));
                    bidevalResult_DOCC.set("ranking", (Object)(i + 1));
                    bidevalResult_DOCC.set("candidate", map.get("candidate"));
                    bidevalResult_DOCC.set("remark", map.get("remark"));
                }
            }
        }
        parentView.updateView("bidevalresult");
        this.getView().sendFormAction(parentView);
    }

    protected Long getSecondSectionId() {
        Long secondSectionId = 0L;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String hasTwo = (String)formShowParameter.getCustomParam("hasTwo");
        if (StringUtils.equals((CharSequence)"true", (CharSequence)hasTwo)) {
            secondSectionId = (Long)formShowParameter.getCustomParam("secondSectionId");
        }
        return secondSectionId;
    }

    protected void handlerAvgScoreRow(List<String> columnKeys, boolean fromCache) {
        int avgRowIndex = -1;
        int weightRowIndex = -1;
        IDataModel dataModel = this.getModel();
        boolean viewWeightRow = (Boolean)this.getView().getFormShowParameter().getCustomParam("weightScoreVisiable");
        DynamicObjectCollection entryColl = dataModel.getDataEntity(true).getDynamicObjectCollection("expertgrading");
        if (entryColl == null || entryColl.size() <= 0) {
            return;
        }
        HashSet<Object> technicalPersonSet = new HashSet<Object>();
        HashSet<Object> commercialPersonSet = new HashSet<Object>();
        for (int i = 0; i < entryColl.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryColl.get(i);
            Object proficientId = entry.get("proficientid");
            if (null == proficientId || "0".equals(proficientId.toString())) {
                if (i == entryColl.size() - 1) continue;
                avgRowIndex = i;
                break;
            }
            if (entry.getBoolean("istechnical")) {
                technicalPersonSet.add(proficientId);
            }
            if (!entry.getBoolean("iscommercial")) continue;
            commercialPersonSet.add(proficientId);
        }
        if (avgRowIndex == -1) {
            if (fromCache) {
                avgRowIndex = entryColl.size() - 1;
                dataModel.insertEntryRow("expertgrading", avgRowIndex);
                if (viewWeightRow) {
                    weightRowIndex = avgRowIndex + 1;
                    dataModel.insertEntryRow("expertgrading", weightRowIndex);
                }
            } else {
                avgRowIndex = dataModel.createNewEntryRow("expertgrading");
                if (viewWeightRow) {
                    weightRowIndex = dataModel.createNewEntryRow("expertgrading");
                }
            }
            dataModel.setValue("proficientname", (Object)ResManager.loadKDString((String)"\u8bc4\u6807\u5e73\u5747\u5206", (String)"ExpertGradingEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), avgRowIndex);
            if (viewWeightRow) {
                dataModel.setValue("proficientname", (Object)ResManager.loadKDString((String)"\u8bc4\u6807\u6743\u91cd\u5f97\u5206", (String)"ExpertGradingEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), weightRowIndex);
            }
        } else if (viewWeightRow) {
            weightRowIndex = avgRowIndex + 1;
        }
        ArrayList<String> colKeyList = new ArrayList<String>();
        for (String columnKey : columnKeys) {
            if (!columnKey.startsWith("technical_") && !columnKey.startsWith("commercial_")) continue;
            colKeyList.add(columnKey);
        }
        HashMap<String, BigDecimal> scoreMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < avgRowIndex; ++i) {
            DynamicObject entry = (DynamicObject)entryColl.get(i);
            for (String colKey : colKeyList) {
                scoreMap.put(colKey, NumberUtil.add(scoreMap.get(colKey), entry.get(colKey)));
            }
        }
        IDataModel parentModel = this.getView().getParentView().getModel();
        String scoreMethod = (String)parentModel.getValue("scoremethod");
        if (ScoreMethod.AVG_SCORE.getVal().equals(scoreMethod) || ScoreMethod.SPECIAL.getVal().equals(scoreMethod)) {
            this.calcByAverageMethod(technicalPersonSet.size(), commercialPersonSet.size(), avgRowIndex, dataModel, scoreMap);
            this.changeEvalCtlTips(scoreMethod, false);
        } else if (ScoreMethod.TRUNC_AVG_SCORE.getVal().equals(scoreMethod)) {
            if (technicalPersonSet.size() == commercialPersonSet.size() && technicalPersonSet.containsAll(commercialPersonSet)) {
                this.calcByTruncatedSameProficient(avgRowIndex, colKeyList, entryColl);
                this.changeEvalCtlTips(scoreMethod, true);
            } else {
                this.calcByTruncatedAverageScore(technicalPersonSet.size(), commercialPersonSet.size(), avgRowIndex, colKeyList, entryColl, scoreMap);
                this.changeEvalCtlTips(scoreMethod, false);
            }
        }
        this.getView().setEnable(Boolean.FALSE, avgRowIndex, colKeyList.toArray(new String[colKeyList.size()]));
        if (viewWeightRow) {
            DynamicObject avgEntryRow = (DynamicObject)entryColl.get(avgRowIndex);
            this.handlerWeightScoreRow(weightRowIndex, avgEntryRow, colKeyList);
        }
    }

    protected void calcByTruncatedAverageScore(int technicalCount, int commercialCount, int avgRowIndex, List<String> colKeyList, DynamicObjectCollection entryColl, Map<String, BigDecimal> scoreMap) {
        IDataModel dataModel = this.getModel();
        HashMap<String, BigDecimal> maxValueMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> minValueMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < avgRowIndex; ++i) {
            DynamicObject entry = (DynamicObject)entryColl.get(i);
            boolean isTechnical = entry.getBoolean("istechnical");
            boolean isCommercial = entry.getBoolean("iscommercial");
            for (String colKey : colKeyList) {
                BigDecimal score = NumberUtil.toBigDecimal(entry.get(colKey));
                if (colKey.startsWith("technical_") && !isTechnical || colKey.startsWith("commercial_") && !isCommercial) continue;
                if (null == maxValueMap.get(colKey) || score.compareTo((BigDecimal)maxValueMap.get(colKey)) > 0) {
                    maxValueMap.put(colKey, score);
                }
                if (null != minValueMap.get(colKey) && score.compareTo((BigDecimal)minValueMap.get(colKey)) >= 0) continue;
                minValueMap.put(colKey, score);
            }
        }
        for (String colKey : colKeyList) {
            BigDecimal avgScore = NumberUtil.subtract(new Object[]{scoreMap.get(colKey), maxValueMap.get(colKey), minValueMap.get(colKey)});
            int evaSize = technicalCount;
            if (colKey.startsWith("commercial_")) {
                evaSize = commercialCount;
            }
            avgScore = NumberUtil.divide(avgScore, evaSize - 2, 2);
            dataModel.setValue(colKey, (Object)avgScore, avgRowIndex);
        }
    }

    protected void calcByAverageMethod(int technicalCount, int commercialCount, int newEntryRow, IDataModel dataModel, Map<String, BigDecimal> scoreMap) {
        for (Map.Entry<String, BigDecimal> col : scoreMap.entrySet()) {
            String colKey = col.getKey();
            if (colKey.startsWith("technical_")) {
                dataModel.setValue(colKey, (Object)NumberUtil.divide(scoreMap.get(colKey), technicalCount, 2), newEntryRow);
                continue;
            }
            dataModel.setValue(colKey, (Object)NumberUtil.divide(scoreMap.get(colKey), commercialCount, 2), newEntryRow);
        }
    }

    protected void calcByTruncatedSameProficient(int avgRowIndex, List<String> colKeyList, DynamicObjectCollection entryColl) {
        Map map;
        IDataModel parentModel = this.getView().getParentView().getModel();
        IDataModel model = this.getModel();
        BigDecimal techweight = (BigDecimal)parentModel.getValue("techweight");
        BigDecimal commweight = (BigDecimal)parentModel.getValue("commweight");
        HashMap<String, HashMap<Integer, BigDecimal>> rowScoreMap = new HashMap<String, HashMap<Integer, BigDecimal>>();
        HashMap reCalcScoreMap = new HashMap();
        for (int i = 0; i < avgRowIndex; ++i) {
            DynamicObject entry = (DynamicObject)entryColl.get(i);
            boolean isTechnical = entry.getBoolean("istechnical");
            boolean isCommercial = entry.getBoolean("iscommercial");
            for (String colKey : colKeyList) {
                BigDecimal score = NumberUtil.toBigDecimal(entry.get(colKey));
                if (colKey.startsWith("technical_") && !isTechnical || colKey.startsWith("commercial_") && !isCommercial) continue;
                String key = colKey.split("_")[1];
                HashMap<Integer, BigDecimal> map2 = (HashMap<Integer, BigDecimal>)reCalcScoreMap.get(key);
                if (null == map2) {
                    map2 = new HashMap<Integer, BigDecimal>();
                    reCalcScoreMap.put(key, map2);
                }
                BigDecimal weight = techweight;
                if (colKey.startsWith("commercial_")) {
                    weight = commweight;
                }
                map2.put(i, NumberUtil.add(map2.get(i), NumberUtil.multiply(score, weight)));
                HashMap<Integer, BigDecimal> rowMap = (HashMap<Integer, BigDecimal>)rowScoreMap.get(colKey);
                if (null == rowMap) {
                    rowMap = new HashMap<Integer, BigDecimal>();
                    rowScoreMap.put(colKey, rowMap);
                }
                rowMap.put(i, score);
            }
        }
        HashMap<String, Integer> maxRowMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> minRowMap = new HashMap<String, Integer>(16);
        for (Map.Entry reCalcScore : reCalcScoreMap.entrySet()) {
            map = (Map)reCalcScore.getValue();
            String key = (String)reCalcScore.getKey();
            int maxRowIndex = -1;
            int minRowIndex = -1;
            BigDecimal maxScore = null;
            BigDecimal minScore = null;
            for (Map.Entry mapEntry : map.entrySet()) {
                BigDecimal score = (BigDecimal)mapEntry.getValue();
                Integer rowIndex = (Integer)mapEntry.getKey();
                if (null == maxScore || NumberUtil.compareTo(maxScore, score) < 0) {
                    maxScore = score;
                    maxRowIndex = rowIndex;
                }
                if (null != minScore && NumberUtil.compareTo(minScore, score) <= 0) continue;
                minScore = score;
                minRowIndex = rowIndex;
            }
            maxRowMap.put(key, maxRowIndex);
            minRowMap.put(key, minRowIndex);
        }
        for (Map.Entry mapEntry : rowScoreMap.entrySet()) {
            String colKey;
            map = (Map)mapEntry.getValue();
            colKey = (String)mapEntry.getKey();
            String key = colKey.split("_")[1];
            map.remove(maxRowMap.get(key));
            map.remove(minRowMap.get(key));
            int mapSize = map.size();
            model.setValue(colKey, (Object)NumberUtil.divide(NumberUtil.add(map.values().toArray(new BigDecimal[mapSize])), mapSize, 2), avgRowIndex);
        }
    }

    protected void handlerWeightScoreRow(int weigthRowIndex, DynamicObject avgEntryRow, List<String> colKeyList) {
        IDataModel dataModel = this.getModel();
        IDataModel parentModel = this.getView().getParentView().getModel();
        BigDecimal techweight = (BigDecimal)parentModel.getValue("techweight");
        BigDecimal commweight = (BigDecimal)parentModel.getValue("commweight");
        for (String colKey : colKeyList) {
            if (colKey.startsWith("technical_")) {
                dataModel.setValue(colKey, (Object)NumberUtil.multiply(avgEntryRow.get(colKey), techweight, 2), weigthRowIndex);
                continue;
            }
            dataModel.setValue(colKey, (Object)NumberUtil.multiply(avgEntryRow.get(colKey), commweight, 2), weigthRowIndex);
        }
        this.getView().setEnable(Boolean.FALSE, weigthRowIndex, colKeyList.toArray(new String[colKeyList.size()]));
    }

    protected void changeEvalCtlTips(String scoreMethod, boolean isSameProficient) {
        HashMap prop = new HashMap(1);
        HashMap<String, String> tips = new HashMap<String, String>(1);
        StringBuilder buffer = new StringBuilder();
        String title = "";
        String content = "";
        if (ScoreMethod.AVG_SCORE.getVal().contains(scoreMethod) || ScoreMethod.TRUNC_AVG_SCORE.getVal().contains(scoreMethod)) {
            String msg;
            title = ResManager.loadKDString((String)"\u8ba1\u7b97\u8bf4\u660e\uff1a", (String)"ExpertGradingEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            if (ScoreMethod.AVG_SCORE.getVal().contains(scoreMethod)) {
                msg = ResManager.loadKDString((String)"\u8bc4\u6807\u5e73\u5747\u5206\uff1a", (String)"ExpertGradingEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807\u5e73\u5747\u5206=\u6280\u672f\u6807\u8bc4\u6807\u4e13\u5bb6\u7684\u8bc4\u5206\u4e4b\u548c/\u53c2\u4e0e\u6280\u672f\u6807\u8bc4\u6807\u7684\u4e13\u5bb6\u6570\uff1b", (String)"ExpertGradingEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807\u5e73\u5747\u5206=\u5546\u52a1\u6807\u8bc4\u6807\u4e13\u5bb6\u7684\u8bc4\u5206\u4e4b\u548c/\u53c2\u4e0e\u5546\u52a1\u6807\u8bc4\u6807\u7684\u4e13\u5bb6\u6570\uff1b", (String)"ExpertGradingEdit_6", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n";
                buffer.append(msg);
            } else {
                String msg1 = ResManager.loadKDString((String)"\u8bc4\u6807\u5e73\u5747\u5206\uff1a", (String)"ExpertGradingEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n";
                buffer.append(msg1);
                if (isSameProficient) {
                    String msg2 = ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807\u5e73\u5747\u5206=\uff08\u6280\u672f\u6807\u8bc4\u6807\u4e13\u5bb6\u7684\u8bc4\u5206\u4e4b\u548c-\u8bc4\u5206\u5408\u8ba1\u4e3a\u6700\u9ad8\u5206\u7684\u6280\u672f\u6807\u8bc4\u5206-\u8bc4\u5206\u5408\u8ba1\u4e3a\u6700\u4f4e\u5206\u7684\u6280\u672f\u6807\u8bc4\u5206\uff09/\uff08\u53c2\u4e0e\u6280\u672f\u6807\u8bc4\u6807\u7684\u4e13\u5bb6\u6570-2\uff09\uff1b", (String)"ExpertGradingEdit_7", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807\u5e73\u5747\u5206=\uff08\u5546\u52a1\u6807\u8bc4\u6807\u4e13\u5bb6\u7684\u8bc4\u5206\u4e4b\u548c-\u8bc4\u5206\u5408\u8ba1\u4e3a\u6700\u9ad8\u5206\u7684\u5546\u52a1\u6807\u8bc4\u5206-\u8bc4\u5206\u5408\u8ba1\u4e3a\u6700\u4f4e\u5206\u7684\u5546\u52a1\u6807\u8bc4\u5206\uff09/\uff08\u53c2\u4e0e\u5546\u52a1\u6807\u8bc4\u6807\u7684\u4e13\u5bb6\u6570-2\uff09\uff1b", (String)"ExpertGradingEdit_8", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n";
                    buffer.append(msg2);
                } else {
                    String msg3 = ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807\u5e73\u5747\u5206=\uff08\u6280\u672f\u6807\u8bc4\u6807\u4e13\u5bb6\u7684\u8bc4\u5206\u4e4b\u548c-\u6280\u672f\u6807\u6700\u9ad8\u5206-\u6280\u672f\u6807\u6700\u4f4e\u5206\uff09/\uff08\u53c2\u4e0e\u6280\u672f\u6807\u8bc4\u6807\u4e13\u5bb6\u6570-2\uff09\uff1b", (String)"ExpertGradingEdit_9", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807\u5e73\u5747\u5206=\uff08\u5546\u52a1\u6807\u8bc4\u6807\u4e13\u5bb6\u7684\u8bc4\u5206\u4e4b\u548c-\u5546\u52a1\u6807\u6700\u9ad8\u5206-\u5546\u52a1\u6807\u6700\u4f4e\u5206\uff09/\uff08\u53c2\u4e0e\u5546\u52a1\u6807\u8bc4\u6807\u4e13\u5bb6\u6570-2\uff09\uff1b", (String)"ExpertGradingEdit_10", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n";
                    buffer.append(msg3);
                }
            }
            msg = ResManager.loadKDString((String)"\u8bc4\u6807\u6743\u91cd\u5f97\u5206\uff1a", (String)"ExpertGradingEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u6280\u672f\u6807\u6743\u91cd\u5f97\u5206=\u6280\u672f\u6807\u8bc4\u6807\u5e73\u5747\u5206*\u6280\u672f\u6807\u6743\u91cd\uff1b", (String)"ExpertGradingEdit_12", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u5546\u52a1\u6807\u6743\u91cd\u5f97\u5206=\u5546\u52a1\u6807\u8bc4\u6807\u5e73\u5747\u5206*\u5546\u52a1\u6807\u6743\u91cd\uff1b", (String)"ExpertGradingEdit_13", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u5408\u8ba1\uff1a", (String)"ExpertGradingEdit_14", (String)"scm-bid-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u5408\u8ba1=\u6280\u672f\u6807\u6743\u91cd\u5f97\u5206+\u5546\u52a1\u6807\u6743\u91cd\u5f97\u5206", (String)"ExpertGradingEdit_15", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            buffer.append(msg);
            content = buffer.toString();
        }
        tips.put("title", title);
        tips.put("content", content);
        prop.put("tips", tips);
        this.getView().getParentView().updateControlMetadata("advconap1", prop);
        this.getView().sendFormAction(this.getView().getParentView());
    }
}

