/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.UnitField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.formplugin.bill.MateriaIdAndMaterialdes;

public class ListPriceComparison
extends AbstractFormPlugin
implements RowClickEventListener,
CellClickListener,
IBillPlugin {
    public static final String CACHE_BIDOPENID = "cacheBidOpenId";
    String appName = "bid";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.appName = e.getFormShowParameter().getServiceAppId();
    }

    public String getAppId() {
        if (this.getView() != null) {
            return this.getView().getFormShowParameter().getServiceAppId();
        }
        return this.appName;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        HashMap<String, Object> mapEntry = new HashMap<String, Object>();
        mapEntry.put("id", "comparisoninformation");
        FormShowParameter source = (FormShowParameter)e.getSource();
        mapEntry.put("columns", this.buildDyncColumns(source));
        e.getItems().add(mapEntry);
    }

    private Object buildDyncColumns(FormShowParameter source) {
        EntryAp entryAp = this.createDynamicEntryAp(source);
        if (entryAp == null) {
            return null;
        }
        return entryAp.createControl().get("columns");
    }

    private EntryAp createDynamicEntryAp(FormShowParameter formShowParameter) {
        EntityItem item2;
        int i;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(this.getAppId() + "_listpricecomparison"));
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        formMeta.bindEntityMetadata(entityMetadata);
        Optional<ControlAp> findFirst = formMeta.getItems().stream().filter(item -> item.getKey().equals("comparisoninformation")).findFirst();
        EntryAp entryAp = null;
        if (!findFirst.isPresent()) {
            return null;
        }
        entryAp = (EntryAp)findFirst.get();
        Map parentData = formShowParameter.getCustomParams();
        Object bidProjectID = parentData.get("bidproject");
        Object sectionName = parentData.get("sectionname");
        Object evalType = parentData.get("evaltype");
        QFilter qFilter_openType = null;
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle(bidProjectID, (String)"bid_project", (String)"bidopentype,doctype");
        String bidOpenSelectType = bidProject.getString("bidopentype");
        String docType = bidProject.getString("doctype");
        boolean isDark = (Boolean)parentData.get("isDark");
        boolean isOnlineEval = (Boolean)parentData.get("isOnlineEval");
        qFilter_openType = BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenSelectType) ? (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType) ? new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()) : new QFilter("opentype", "=", (Object)BidOpenTypeEnum.MULTI.getValue())) : new QFilter("opentype", "=", evalType);
        DynamicObject open = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"opentype,bidsection,sectionname,supplierentry,supplier,supplier_rate,supplier_istender,supplier_isinvalid,supplierdetail,pursupplier", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectID), new QFilter("bidsection.sectionname", "=", sectionName), qFilter_openType.and(new QFilter("billstatus", "=", (Object)"O"))});
        if (open == null) {
            return null;
        }
        HashMap<Long, String> supplierDarkNameMap = this.getSupplierDarkName(open, isOnlineEval, (String)sectionName, isDark);
        DynamicObject bidProjectColl = BusinessDataServiceHelper.loadSingle(bidProjectID, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"isratebidding,bidtype");
        Boolean isRate = bidProjectColl.getBoolean("isratebidding");
        ArrayList<String> supplierName = new ArrayList<String>();
        DynamicObjectCollection supplierDetailColl = open.getDynamicObjectCollection("bidsection");
        for (i = 0; i < supplierDetailColl.size(); ++i) {
            DynamicObject supplier = (DynamicObject)supplierDetailColl.get(i);
            String section = supplier.getString("sectionname");
            if (!section.equals(sectionName)) continue;
            supplierDetailColl = supplier.getDynamicObjectCollection("supplierentry");
            break;
        }
        for (i = 0; i < supplierDetailColl.size(); ++i) {
            DynamicObject supplierDetailRow = (DynamicObject)supplierDetailColl.get(i);
            boolean isTender = supplierDetailRow.getBoolean("supplier_istender");
            boolean isInvalId = supplierDetailRow.getBoolean("supplier_isinvalid");
            if (!isTender || isInvalId) continue;
            Long supplierId = (Long)supplierDetailRow.getDynamicObject("supplier").getPkValue();
            String purSupplier = isDark && supplierDarkNameMap.containsKey(supplierId) ? supplierDarkNameMap.get(supplierId) : supplierDetailRow.getString("supplier.name");
            supplierName.add(purSupplier);
        }
        HashMap<String, String> supplierToIdentification = new HashMap<String, String>(16);
        int j = 0;
        for (String string : supplierName) {
            String Identification = "dyn_column" + j;
            supplierToIdentification.put(string, Identification);
            ++j;
        }
        List items = entityMetadata.getItems();
        String currencyFieldId = null;
        if (items != null && items.size() > 0 && (item2 = items.stream().filter(e -> e.getKey().equals("currency")).findFirst().get()) != null) {
            currencyFieldId = item2.getId();
        }
        for (Map.Entry identification : supplierToIdentification.entrySet()) {
            String columnKey = (String)identification.getValue();
            String s = (String)identification.getKey();
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setId(columnKey);
            fieldAp.setKey(columnKey);
            fieldAp.setName(new LocaleString(s));
            fieldAp.setWidth(new LocaleString("220px"));
            if (isRate.booleanValue()) {
                fieldAp.setMask("%");
                fieldAp.setFireUpdEvt(true);
                fieldAp.setNoDisplayScaleZero(true);
                DecimalField decimalField = new DecimalField();
                decimalField.setId(columnKey);
                decimalField.setScale(4);
                decimalField.setName(new LocaleString(columnKey));
                decimalField.setZeroShow(true);
                decimalField.setPrecision(23);
                decimalField.setKey(columnKey);
                fieldAp.setField((Field)decimalField);
                entryAp.getItems().add(fieldAp);
                continue;
            }
            fieldAp.setFireUpdEvt(true);
            AmountField amountField = new AmountField();
            amountField.setId(columnKey);
            amountField.setName(new LocaleString(columnKey));
            amountField.setZeroShow(true);
            amountField.setPrecision(23);
            amountField.setCurrencyFieldId(currencyFieldId);
            amountField.setKey(columnKey);
            amountField.setEntityMetadata(entityMetadata);
            fieldAp.setField((Field)amountField);
            entryAp.getItems().add(fieldAp);
        }
        return entryAp;
    }

    private void buildResource(EntryAp entryAp, EntityMetadata entityMetadata) {
        EntryFieldAp resourceIdAp = new EntryFieldAp();
        resourceIdAp.setId("myresourceitem_number");
        resourceIdAp.setKey("myresourceitem_number");
        resourceIdAp.setName(new LocaleString(ResManager.loadKDString((String)"\u8d44\u6e90\u7f16\u7801", (String)"ListPriceComparison_10", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        BasedataField basedataField = new BasedataField();
        basedataField.setId("myresourceitem_number");
        basedataField.setBaseEntityNumber("ecbd_resourceitem");
        basedataField.setViewDetail(true);
        basedataField.setName(new LocaleString(ResManager.loadKDString((String)"\u8d44\u6e90\u7f16\u7801", (String)"ListPriceComparison_10", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        basedataField.setKey("myresourceitem_number");
        basedataField.setDisplayProp("number");
        resourceIdAp.setField((Field)basedataField);
        EntryFieldAp nametextAp = new EntryFieldAp();
        nametextAp.setId("myresourceitem_name");
        nametextAp.setKey("myresourceitem_name");
        nametextAp.setName(new LocaleString(ResManager.loadKDString((String)"\u8d44\u6e90\u540d\u79f0", (String)"ListPriceComparison_11", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        TextField nametextField = new TextField();
        nametextField.setId("myresourceitem_name");
        nametextField.setName(new LocaleString(ResManager.loadKDString((String)"\u8d44\u6e90\u540d\u79f0", (String)"ListPriceComparison_11", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        nametextField.setMaxLength(100);
        nametextField.setKey("myresourceitem_name");
        nametextField.setDefValue("myresourceitem_name");
        nametextAp.setField((Field)nametextField);
        EntryFieldAp modelnametextAp = new EntryFieldAp();
        modelnametextAp.setId("myresourceitem_modelname");
        modelnametextAp.setKey("myresourceitem_modelname");
        modelnametextAp.setName(new LocaleString(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"ListPriceComparison_5", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        TextField modelnametextField = new TextField();
        modelnametextField.setId("myresourceitem_modelname");
        modelnametextField.setName(new LocaleString(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"ListPriceComparison_5", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        modelnametextField.setMaxLength(100);
        modelnametextField.setKey("myresourceitem_modelname");
        modelnametextField.setDefValue("myresourceitem_modelname");
        modelnametextAp.setField((Field)modelnametextField);
        EntryFieldAp myunittextAp = new EntryFieldAp();
        myunittextAp.setId("myresourceitem_unit");
        myunittextAp.setKey("myresourceitem_unit");
        myunittextAp.setName(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ListPriceComparison_6", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        TextField myunittextField = new TextField();
        myunittextField.setId("myresourceitem_unit");
        myunittextField.setName(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ListPriceComparison_6", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        myunittextField.setMaxLength(100);
        myunittextField.setKey("myresourceitem_unit");
        myunittextField.setDefValue("myresourceitem_unit");
        myunittextAp.setField((Field)myunittextField);
        entryAp.getItems().add(resourceIdAp);
        entryAp.getItems().add(nametextAp);
        entryAp.getItems().add(modelnametextAp);
        entryAp.getItems().add(myunittextAp);
    }

    protected void buildMaterial(EntryAp entryAp, EntityMetadata entityMetadata) {
        EntryFieldAp martIdAp = new EntryFieldAp();
        martIdAp.setId("mymaterial_number");
        martIdAp.setKey("mymaterial_number");
        martIdAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"ListPriceComparison_2", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        BasedataField basedataField = new BasedataField();
        basedataField.setId("mymaterial_number");
        basedataField.setBaseEntityNumber("bd_material");
        basedataField.setViewDetail(true);
        basedataField.setName(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"ListPriceComparison_2", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        basedataField.setKey("mymaterial_number");
        basedataField.setDisplayProp("number");
        martIdAp.setField((Field)basedataField);
        EntryFieldAp nametextAp = new EntryFieldAp();
        nametextAp.setId("mymaterial_name");
        nametextAp.setKey("mymaterial_name");
        nametextAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"ListPriceComparison_3", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        TextField nametextField = new TextField();
        nametextField.setId("mymaterial_name");
        nametextField.setName(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"ListPriceComparison_3", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        nametextField.setMaxLength(100);
        nametextField.setKey("mymaterial_name");
        nametextField.setDefValue("mymaterial_name");
        nametextAp.setField((Field)nametextField);
        EntryFieldAp modelnametextAp = new EntryFieldAp();
        modelnametextAp.setId("mymaterial_modelname");
        modelnametextAp.setKey("mymaterial_modelname");
        modelnametextAp.setName(new LocaleString(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"ListPriceComparison_5", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        TextField modelnametextField = new TextField();
        modelnametextField.setId("mymaterial_modelname");
        modelnametextField.setName(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"ListPriceComparison_3", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        modelnametextField.setMaxLength(100);
        modelnametextField.setKey("mymaterial_modelname");
        modelnametextField.setDefValue("mymaterial_modelname");
        modelnametextAp.setField((Field)modelnametextField);
        EntryFieldAp myunittextAp = new EntryFieldAp();
        myunittextAp.setId("mymaterial_unit");
        myunittextAp.setKey("mymaterial_unit");
        myunittextAp.setName(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ListPriceComparison_6", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        UnitField unitField = new UnitField();
        unitField.setId("mymaterial_unit");
        unitField.setName(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ListPriceComparison_6", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        unitField.setKey("mymaterial_unit");
        unitField.setBaseEntityNumber("bd_measureunits");
        unitField.setEntityMetadata(entityMetadata);
        myunittextAp.setField((Field)unitField);
        entryAp.getItems().add(martIdAp);
        entryAp.getItems().add(nametextAp);
        entryAp.getItems().add(modelnametextAp);
        entryAp.getItems().add(myunittextAp);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (e.getKey().startsWith("dyn_column") || e.getKey().equals("purentrycontenttext")) {
            FieldEdit fieldEdit = new FieldEdit();
            fieldEdit.setKey(e.getKey());
            fieldEdit.setView(this.getView());
            fieldEdit.setEntryKey("comparisoninformation");
            e.setControl((Control)fieldEdit);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        int i;
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDBizException(e1.getMessage());
        }
        EntityType entryType = (EntityType)newMainType.getAllEntities().get("comparisoninformation");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map parentData = formShowParameter.getCustomParams();
        Object bidProjectID = parentData.get("bidproject");
        Object sectionName = parentData.get("sectionname");
        Object evalType = parentData.get("evaltype");
        QFilter qFilter_openType = null;
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle(bidProjectID, (String)"bid_project", (String)"bidopentype,doctype");
        String bidOpenSelectType = bidProject.getString("bidopentype");
        String docType = bidProject.getString("doctype");
        qFilter_openType = BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenSelectType) ? (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType) ? new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()) : new QFilter("opentype", "=", (Object)BidOpenTypeEnum.MULTI.getValue())) : new QFilter("opentype", "=", evalType);
        DynamicObject open = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"opentype,bidsection,sectionname,supplierentry,supplier,supplier_istender,supplier_isinvalid,supplierdetail,pursupplier", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectID), new QFilter("bidsection.sectionname", "=", sectionName), qFilter_openType.and(new QFilter("billstatus", "=", (Object)"O"))});
        TreeSet<String> supplierName = new TreeSet<String>();
        DynamicObjectCollection supplierDetailColl = open.getDynamicObjectCollection("bidsection");
        for (i = 0; i < supplierDetailColl.size(); ++i) {
            DynamicObject supplier = (DynamicObject)supplierDetailColl.get(i);
            String section = supplier.getString("sectionname");
            if (!section.equals(sectionName)) continue;
            supplierDetailColl = supplier.getDynamicObjectCollection("supplierentry");
            break;
        }
        for (i = 0; i < supplierDetailColl.size(); ++i) {
            DynamicObject supplierDetailRow = (DynamicObject)supplierDetailColl.get(i);
            boolean isTender = supplierDetailRow.getBoolean("supplier_istender");
            boolean isInvalId = supplierDetailRow.getBoolean("supplier_isinvalid");
            if (!isTender || isInvalId) continue;
            String purSupplier = supplierDetailRow.getString("supplier.name");
            supplierName.add(purSupplier);
        }
        HashMap<String, String> supplierToIdentification = new HashMap<String, String>(16);
        int j = 0;
        for (String string : supplierName) {
            String Identification = "dyn_column" + j;
            supplierToIdentification.put(string, Identification);
            ++j;
        }
        DynamicObject bidProjectColl = BusinessDataServiceHelper.loadSingle(bidProjectID, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidsection,sectionname,isratebidding,purtype,projectentry,controlamount,enablemultisection,bidtype");
        Boolean isRate = Boolean.FALSE;
        isRate = bidProjectColl.getBoolean("isratebidding");
        int bidtype = bidProjectColl.getInt("bidtype");
        if (bidtype != 0) {
            UnitProp myunit;
            TextProp modelname;
            TextProp mymaterialName;
            LongProp pRefId;
            BasedataProp materialNumber;
            DynamicObjectType dynamicObjectType;
            if (bidtype == 1) {
                dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"bd_material").getDynamicObjectType();
                materialNumber = new BasedataProp();
                materialNumber.setName("mymaterial_number");
                materialNumber.setBaseEntityId("bd_material");
                materialNumber.setComplexType((IDataEntityType)dynamicObjectType);
                materialNumber.setDisplayProp(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"ListPriceComparison_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                materialNumber.setDbIgnore(true);
                pRefId = new LongProp(true);
                pRefId.setPrimaryKey(false);
                pRefId.setName("mymaterial_number_id");
                materialNumber.setRefIdProp((IDataEntityProperty)pRefId);
                materialNumber.setRefIdPropName(pRefId.getName());
                mymaterialName = new TextProp();
                mymaterialName.setName("mymaterial_name");
                mymaterialName.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"ListPriceComparison_3", (String)"scm-bid-formplugin", (Object[])new Object[0])));
                modelname = new TextProp();
                modelname.setName("mymaterial_modelname");
                modelname.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"ListPriceComparison_5", (String)"scm-bid-formplugin", (Object[])new Object[0])));
                myunit = new UnitProp();
                myunit.setName("mymaterial_unit");
                myunit.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ListPriceComparison_6", (String)"scm-bid-formplugin", (Object[])new Object[0])));
                myunit.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_measureunits"));
                myunit.setDbIgnore(true);
                myunit.setBaseEntityId("bd_measureunits");
                pRefId = new LongProp(true);
                pRefId.setPrimaryKey(false);
                pRefId.setName("mymaterial_unit_id");
                myunit.setRefIdProp((IDataEntityProperty)pRefId);
                myunit.setRefIdPropName(pRefId.getName());
                entryType.registerComplexProperty((DynamicComplexProperty)materialNumber);
                entryType.addProperty((DynamicProperty)materialNumber.getRefIdProp());
                entryType.registerSimpleProperty((DynamicSimpleProperty)mymaterialName);
                entryType.registerSimpleProperty((DynamicSimpleProperty)modelname);
                entryType.registerComplexProperty((DynamicComplexProperty)myunit);
                entryType.addProperty((DynamicProperty)myunit.getRefIdProp());
            } else {
                dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"ecbd_resourceitem").getDynamicObjectType();
                materialNumber = new BasedataProp();
                materialNumber.setName("myresourceitem_number");
                materialNumber.setBaseEntityId("ecbd_resourceitem");
                materialNumber.setComplexType((IDataEntityType)dynamicObjectType);
                materialNumber.setDisplayProp(ResManager.loadKDString((String)"\u8d44\u6e90\u7f16\u7801", (String)"ListPriceComparison_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                materialNumber.setDbIgnore(true);
                pRefId = new LongProp(true);
                pRefId.setPrimaryKey(false);
                pRefId.setName("myresourceitem_number_id");
                materialNumber.setRefIdProp((IDataEntityProperty)pRefId);
                materialNumber.setRefIdPropName(pRefId.getName());
                mymaterialName = new TextProp();
                mymaterialName.setName("myresourceitem_name");
                mymaterialName.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u8d44\u6e90\u540d\u79f0", (String)"ListPriceComparison_11", (String)"scm-bid-formplugin", (Object[])new Object[0])));
                modelname = new TextProp();
                modelname.setName("myresourceitem_modelname");
                modelname.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"ListPriceComparison_5", (String)"scm-bid-formplugin", (Object[])new Object[0])));
                myunit = new TextProp();
                myunit.setName("myresourceitem_unit");
                myunit.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ListPriceComparison_6", (String)"scm-bid-formplugin", (Object[])new Object[0])));
                entryType.registerComplexProperty((DynamicComplexProperty)materialNumber);
                entryType.addProperty((DynamicProperty)materialNumber.getRefIdProp());
                entryType.registerSimpleProperty((DynamicSimpleProperty)mymaterialName);
                entryType.registerSimpleProperty((DynamicSimpleProperty)modelname);
                entryType.registerSimpleProperty((DynamicSimpleProperty)myunit);
            }
            TextProp mymaterialdesname = new TextProp();
            mymaterialdesname.setName("mymaterial_desname");
            mymaterialdesname.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u4ea7\u54c1\u63cf\u8ff0", (String)"ListPriceComparison_4", (String)"scm-bid-formplugin", (Object[])new Object[0])));
            TextProp mycurrency = new TextProp();
            mycurrency.setName("mymaterial_currency");
            mycurrency.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u5e01\u522b", (String)"ListPriceComparison_7", (String)"scm-bid-formplugin", (Object[])new Object[0])));
            QtyProp qtyProp = new QtyProp();
            qtyProp.setName("mymaterial_qty");
            qtyProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u6570\u91cf", (String)"ListPriceComparison_8", (String)"scm-bid-formplugin", (Object[])new Object[0])));
            entryType.registerSimpleProperty((DynamicSimpleProperty)mymaterialdesname);
            entryType.registerSimpleProperty((DynamicSimpleProperty)mycurrency);
            entryType.registerSimpleProperty((DynamicSimpleProperty)qtyProp);
        } else {
            TextProp textProp = new TextProp();
            textProp.setName("purentrycontenttext");
            textProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u62db\u6807\u5185\u5bb9", (String)"ListPriceComparison_9", (String)"scm-bid-formplugin", (Object[])new Object[0])));
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
        for (Map.Entry identification : supplierToIdentification.entrySet()) {
            String value = (String)identification.getValue();
            String key = (String)identification.getKey();
            if (isRate.booleanValue()) {
                DecimalProp decimalProp = new DecimalProp();
                decimalProp.setName(value);
                decimalProp.setDisplayName(new LocaleString(key));
                entryType.registerSimpleProperty((DynamicSimpleProperty)decimalProp);
                continue;
            }
            AmountProp amountProp = new AmountProp();
            amountProp.setName(value);
            amountProp.setDisplayName(new LocaleString(key));
            entryType.registerSimpleProperty((DynamicSimpleProperty)amountProp);
        }
        newMainType.createPropIndexsNoCache();
        e.setNewEntityType(newMainType);
    }

    public void bindData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        EntryAp entryAp = this.createDynamicEntryAp(formShowParameter);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("comparisoninformation");
        List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
        HashMap<String, String> map5 = new HashMap<String, String>();
        map5.put("h", "20");
        this.getView().updateControlMetadata("startdate", map5);
    }

    public BigDecimal bindByProject(DynamicObject bidProjectColl, String sectionName) {
        BigDecimal tempBigDecimal = BigDecimal.ZERO;
        DynamicObject purType = bidProjectColl.getDynamicObject("purtype");
        DynamicObjectCollection bidProjectSectionColl = bidProjectColl.getDynamicObjectCollection("bidsection");
        if (bidProjectSectionColl != null && bidProjectSectionColl.size() > 0) {
            for (int i = 0; i < bidProjectSectionColl.size(); ++i) {
                DynamicObjectCollection projectEntryColl;
                DynamicObject bidProjectSection = (DynamicObject)bidProjectSectionColl.get(i);
                if (bidProjectSection == null) continue;
                String projectSectionName = bidProjectSection.getString("sectionname");
                if (bidProjectSection == null || !projectSectionName.equals(sectionName) || (projectEntryColl = bidProjectSection.getDynamicObjectCollection("projectentry")) == null) continue;
                for (int j = 0; j < projectEntryColl.size(); ++j) {
                    DynamicObject projectEntry = (DynamicObject)projectEntryColl.get(j);
                    BigDecimal controlAmount = projectEntry.getBigDecimal("controlamount");
                    tempBigDecimal = tempBigDecimal.add(controlAmount);
                }
            }
        }
        return tempBigDecimal;
    }

    /*
     * WARNING - void declaration
     */
    public void beforeBindData(EventObject eventObject) {
        block121: {
            DynamicObject purSupplier;
            DynamicObject supplierDetailRow;
            String identification;
            String purrentryContent;
            DynamicObject calrifySupplierDetail;
            DynamicObjectCollection calrifySupplierDetailColl;
            String calrifySectionName;
            DynamicObject calrifyBidSection;
            DynamicObjectCollection clarifyBidSectionColl;
            DynamicObject questionClarify;
            Object listComparsionPurentryContent;
            String purentryContent;
            DynamicObject newComparisonInformation;
            String purentrycontent;
            ArrayList<String> purentryContentList;
            DynamicObject parentComparison;
            String pursupplier;
            String purSupplierName;
            this.bindData();
            DynamicObject listPriceComparsionModel = this.getModel().getDataEntity();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map parentData = formShowParameter.getCustomParams();
            Object bidProjectID = parentData.get("bidproject");
            Object sectionID = parentData.get("sectionid");
            String sectionName = (String)parentData.get("sectionname");
            this.getModel().setValue("bidproject", bidProjectID);
            this.getModel().setValue("pageeffective", (Object)Boolean.TRUE);
            StringBuilder supplierDeilSQl = new StringBuilder("entryentity,opentype,bidsection,sectionname,supplierdetail,supplierentry,supplier,supplier_taxrate,supplier_exceptvat,supplier_rate,supplier_taxrate,supplier_pricevat,supplier_tenderdate,supplier_tenderprice,supplier_tenderdate,supplier_istender,supplier_isinvalid,supplier_manager,supplier_workday,pursupplier,purentrycontent,purentryproject,materialid,materialname,model,baseunit,unit,materialdes,qty,inclutaxprice,inclutaxamount,taxrate,taxamount,excepttaxamount,costrate");
            if ("rebm".equals(this.getAppId())) {
                supplierDeilSQl.append(",resourceitem");
            }
            Object evalType = parentData.get("evaltype");
            QFilter qFilter_openType = null;
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle(bidProjectID, (String)"bid_project", (String)"bidopentype,doctype,currency");
            String bidOpenSelectType = bidProject.getString("bidopentype");
            String docType = bidProject.getString("doctype");
            qFilter_openType = BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenSelectType) ? (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType) ? new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()) : new QFilter("opentype", "=", (Object)BidOpenTypeEnum.MULTI.getValue())) : new QFilter("opentype", "=", evalType);
            DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)supplierDeilSQl.toString(), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectID), new QFilter("billstatus", "in", (Object)new String[]{"O", "X"}), qFilter_openType});
            if (bidOpen == null) {
                return;
            }
            Boolean isOnlineEval = (Boolean)this.getView().getFormShowParameter().getCustomParam("isOnlineEval");
            boolean isDark = (Boolean)this.getView().getFormShowParameter().getCustomParam("isDark");
            HashMap<Long, String> supplierDarkNameMap = this.getSupplierDarkName(bidOpen, isOnlineEval, sectionName, isDark);
            String bidOpenIdStr = bidOpen.getPkValue().toString();
            this.getPageCache().put(CACHE_BIDOPENID, bidOpenIdStr);
            BigDecimal lowestTotalPrice = BigDecimal.ZERO;
            BigDecimal maximumTotalPrice = BigDecimal.ZERO;
            BigDecimal avgTotlaPrice = BigDecimal.ZERO;
            ArrayList<Long> maxestSupplier = new ArrayList<Long>();
            ArrayList<Long> minestSupplier = new ArrayList<Long>();
            BigDecimal controlPriceSum = BigDecimal.ZERO;
            BigDecimal maxRate = BigDecimal.ZERO;
            ArrayList<Long> maxRateSupplier = new ArrayList<Long>();
            BigDecimal minRate = BigDecimal.ZERO;
            ArrayList<Long> minRateSupplier = new ArrayList<Long>();
            BigDecimal avgRate = BigDecimal.ZERO;
            Boolean materialPur = Boolean.FALSE;
            int bidType = 0;
            Boolean isRate = Boolean.FALSE;
            Boolean enablemultisection = Boolean.TRUE;
            DynamicObject bidProjectColl = BusinessDataServiceHelper.loadSingle(bidProjectID, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidsection,sectionname,isratebidding,purtype,projectentry,controlamount,enablemultisection,ismaterialpur,bidtype");
            if (bidProjectColl == null) {
                return;
            }
            controlPriceSum = this.bindByProject(bidProjectColl, sectionName);
            bidType = bidProjectColl.getInt("bidtype");
            isRate = bidProjectColl.getBoolean("isratebidding");
            enablemultisection = bidProjectColl.getBoolean("enablemultisection");
            if (bidType != 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"lowestrate", "miniratesupplier", "miniratesupdarkname", "maxrate", "topratesupplier", "topratesupdarkname", "avgrate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"summary_manager", "summary_workday", "summary_rate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"purentrycontent", "parity_purentrycontent", "informationmaxrate", "informationlowestrate", "informationlowestrate", "parity_rate", "informationavgrate"});
                if (bidType == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem", "resitemname", "resourcemodel", "resourceunit", "reference_resitemname", "parity_resitemname"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "model", "baseunit", "reference_materialname", "parity_materialname"});
                }
                Date endDate = new Date();
                Calendar startCalendar = Calendar.getInstance();
                startCalendar.setTime(endDate);
                startCalendar.add(5, -90);
                startCalendar.set(11, 0);
                startCalendar.set(12, 0);
                startCalendar.set(13, 0);
                Date startDate = startCalendar.getTime();
                listPriceComparsionModel.set("startdate", (Object)startDate);
                listPriceComparsionModel.set("enddate", (Object)endDate);
            } else {
                if ("rebm".equals(this.getAppId())) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"reference_resitemname", "reference_materialname", "parity_resitemname", "resourceitem", "resitemname"});
                }
                if (!isRate.booleanValue()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"lowestrate", "miniratesupplier", "miniratesupdarkname", "maxrate", "topratesupplier", "topratesupdarkname", "avgrate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "summary_rate", "materialdes", "model", "baseunit", "qty"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"informationmaxrate", "informationlowestrate", "informationavgrate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"parity_inclutaxprice", "parity_materialname", "parity_rate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"recentbidwinningreference"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"lowesttotalprice", "maximumprice", "topsupplier", "topsupdarkname", "averagetotalprice", "minimumsupdarkname", "minimumsupplier", "maximumtotalprice"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"summary_tenderprice", "summary_taxrate", "summary_pricevat", "summary_exceptvat"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"materialid", "materialdes", "materialname", "model", "baseunit", "qty", "maximumprice", "lowestprice", "avgprice", "lowestprice", "parity_materialname"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"parity_inclutaxprice", "parity_inclutaxamount", "parity_taxrate", "parity_taxamount", "parity_excepttaxamount"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"recentbidwinningreference"});
                }
            }
            this.getModel().setValue("currency", bidProject.get("currency"));
            this.getModel().setValue("purchasingcontrolamount", (Object)controlPriceSum);
            DynamicObjectCollection comparisonInformation = listPriceComparsionModel.getDynamicObjectCollection("comparisonInformation");
            DynamicObjectCollection supplierDetailColl = new DynamicObjectCollection();
            DynamicObjectCollection supplierEntryColl = new DynamicObjectCollection();
            if (bidOpen == null) break block121;
            DynamicObjectCollection bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
            if (bidSectionColl != null && bidSectionColl.size() > 0) {
                for (int i = 0; i < bidSectionColl.size(); ++i) {
                    void var42_49;
                    void var41_42;
                    DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                    BigDecimal bigDecimal = BigDecimal.ZERO;
                    BigDecimal bigDecimal2 = BigDecimal.ZERO;
                    if (bidSection == null || !sectionID.equals(bidSection.getPkValue())) continue;
                    supplierDetailColl = bidSection.getDynamicObjectCollection("supplierdetail");
                    supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                    DynamicObjectCollection dynamicObjectCollection = bidSection.getDynamicObjectCollection("supplierentry");
                    DynamicObject dataEntity = listPriceComparsionModel;
                    DynamicObjectCollection priceSummary = dataEntity.getDynamicObjectCollection("price_summary");
                    MainEntityType bidListPriceComparisonType = EntityMetadataCache.getDataEntityType((String)"bid_listpricecomparison");
                    EntityType priceSummaryType = (EntityType)bidListPriceComparisonType.getAllEntities().get("price_summary");
                    int invalidNum = 0;
                    for (int j = 0; j < dynamicObjectCollection.size(); ++j) {
                        DynamicObject supplier = (DynamicObject)dynamicObjectCollection.get(j);
                        Boolean isTender = supplier.getBoolean("supplier_istender");
                        Boolean idInvalid = supplier.getBoolean("supplier_isinvalid");
                        if (!isTender.booleanValue() || idInvalid.booleanValue()) {
                            ++invalidNum;
                            continue;
                        }
                        long supplierId = supplier.getLong("supplier.id");
                        BigDecimal sumPrice = (BigDecimal)supplier.get("supplier_tenderprice");
                        BigDecimal rate = supplier.getBigDecimal("supplier_rate");
                        DynamicObject questionClarify2 = this.getDataFromlatestData(bidProjectID, supplier.getDynamicObject("supplier"), enablemultisection, sectionName);
                        if (questionClarify2 != null) {
                            sumPrice = questionClarify2.getBigDecimal("tenderprice");
                            rate = questionClarify2.getBigDecimal("rate");
                        }
                        if (sumPrice == null) {
                            sumPrice = BigDecimal.ZERO;
                        }
                        if (rate == null) {
                            rate = BigDecimal.ZERO;
                        }
                        if (j == 0) {
                            lowestTotalPrice = sumPrice;
                        }
                        if (j == 0) {
                            minRate = rate;
                        }
                        if (sumPrice.compareTo(maximumTotalPrice) > 0) {
                            maximumTotalPrice = sumPrice;
                            maxestSupplier.clear();
                            maxestSupplier.add(supplierId);
                        } else if (sumPrice.compareTo(maximumTotalPrice) == 0) {
                            maxestSupplier.add(supplierId);
                        }
                        if (rate.compareTo(maxRate) > 0) {
                            maxRate = rate;
                            maxRateSupplier.clear();
                            maxRateSupplier.add(supplierId);
                        } else if (rate.compareTo(maxRate) == 0) {
                            maxRateSupplier.add(supplierId);
                        }
                        if (sumPrice.compareTo(lowestTotalPrice) < 0) {
                            lowestTotalPrice = sumPrice;
                            minestSupplier.clear();
                            minestSupplier.add(supplierId);
                        } else if (sumPrice.compareTo(lowestTotalPrice) == 0) {
                            minestSupplier.add(supplierId);
                        }
                        if (rate.compareTo(minRate) < 0) {
                            minRate = rate;
                            minRateSupplier.clear();
                            minRateSupplier.add(supplierId);
                        } else if (rate.compareTo(minRate) == 0) {
                            minRateSupplier.add(supplierId);
                        }
                        BigDecimal bigDecimal3 = sumPrice.add((BigDecimal)var41_42);
                        BigDecimal bigDecimal4 = var42_49.add(rate);
                        if (supplier.get("supplier") == null || supplier.get("supplier").toString().equals("")) continue;
                        DynamicObject newPriceSummary = new DynamicObject((DynamicObjectType)priceSummaryType);
                        DynamicObject summarySupplier = supplier.getDynamicObject("supplier");
                        Object summaryTenderDate = supplier.get("supplier_tenderdate");
                        Object summaryTenderPrice = supplier.get("supplier_tenderprice");
                        Object summaryTaxRate = supplier.get("supplier_taxrate");
                        Object summaryPricevat = supplier.get("supplier_pricevat");
                        Object summaryExceptvat = supplier.get("supplier_exceptvat");
                        Object summaryeManager = supplier.get("supplier_manager");
                        Object summaryWorkDay = supplier.get("supplier_workday");
                        if (questionClarify2 != null) {
                            summaryTenderPrice = questionClarify2.get("tenderprice");
                            summaryTaxRate = questionClarify2.get("pricevat");
                            summaryPricevat = questionClarify2.get("tax");
                            summaryExceptvat = questionClarify2.get("notaxtenderprice");
                            summaryTenderDate = questionClarify2.get("submitdate");
                            summaryeManager = questionClarify2.get("projectmanage");
                            summaryWorkDay = questionClarify2.get("workday");
                        }
                        if (bidType != 0) {
                            newPriceSummary.set("summary_supplier", (Object)summarySupplier);
                            if (isDark && supplierDarkNameMap.containsKey((Long)summarySupplier.getPkValue())) {
                                newPriceSummary.set("summary_darkname", (Object)supplierDarkNameMap.get((Long)summarySupplier.getPkValue()));
                            }
                            newPriceSummary.set("summary_tenderdate", summaryTenderDate);
                            newPriceSummary.set("summary_tenderprice", summaryTenderPrice);
                            newPriceSummary.set("summary_taxrate", (Object)new BigDecimal(summaryTaxRate.toString()).multiply(new BigDecimal("100")));
                            newPriceSummary.set("summary_pricevat", summaryPricevat);
                            newPriceSummary.set("summary_exceptvat", summaryExceptvat);
                            priceSummary.add((Object)newPriceSummary);
                            continue;
                        }
                        if (!isRate.booleanValue()) {
                            newPriceSummary.set("summary_supplier", (Object)summarySupplier);
                            if (isDark && supplierDarkNameMap.containsKey((Long)summarySupplier.getPkValue())) {
                                newPriceSummary.set("summary_darkname", (Object)supplierDarkNameMap.get((Long)summarySupplier.getPkValue()));
                            }
                            newPriceSummary.set("summary_tenderdate", summaryTenderDate);
                            newPriceSummary.set("summary_tenderprice", summaryTenderPrice);
                            newPriceSummary.set("summary_taxrate", (Object)new BigDecimal(summaryTaxRate.toString()).multiply(new BigDecimal("100")));
                            newPriceSummary.set("summary_pricevat", summaryPricevat);
                            newPriceSummary.set("summary_exceptvat", summaryExceptvat);
                            newPriceSummary.set("summary_manager", summaryeManager);
                            newPriceSummary.set("summary_workday", summaryWorkDay);
                            priceSummary.add((Object)newPriceSummary);
                            continue;
                        }
                        newPriceSummary.set("summary_supplier", (Object)summarySupplier);
                        if (isDark && supplierDarkNameMap.containsKey((Long)summarySupplier.getPkValue())) {
                            newPriceSummary.set("summary_darkname", (Object)supplierDarkNameMap.get(summarySupplier.getPkValue()));
                        }
                        newPriceSummary.set("summary_tenderdate", summaryTenderDate);
                        newPriceSummary.set("summary_rate", (Object)new BigDecimal(rate.toString()).multiply(new BigDecimal("100")));
                        newPriceSummary.set("summary_manager", summaryeManager);
                        newPriceSummary.set("summary_workday", summaryWorkDay);
                        priceSummary.add((Object)newPriceSummary);
                    }
                    if (dynamicObjectCollection.size() == invalidNum) {
                        this.getModel().setValue("pageeffective", (Object)Boolean.FALSE);
                        return;
                    }
                    avgTotlaPrice = var41_42.divide(new BigDecimal(dynamicObjectCollection.size() - invalidNum), 10, 4);
                    if (avgTotlaPrice.compareTo(BigDecimal.valueOf(0.0)) == 0) {
                        avgTotlaPrice = BigDecimal.ZERO;
                    }
                    if ((avgRate = var42_49.divide(new BigDecimal(dynamicObjectCollection.size() - invalidNum), 4, 4)).compareTo(BigDecimal.valueOf(0.0)) != 0) continue;
                    avgRate = BigDecimal.ZERO;
                }
            }
            this.getModel().setValue("lowesttotalprice", (Object)lowestTotalPrice);
            this.getModel().setValue("maximumtotalprice", (Object)maximumTotalPrice);
            this.getModel().setValue("averagetotalprice", (Object)avgTotlaPrice);
            this.getModel().setValue("minimumsupplier", (Object)minestSupplier.toArray());
            StringBuilder minestSupDarkName = new StringBuilder();
            for (Long l : minestSupplier) {
                if (!supplierDarkNameMap.containsKey(l)) continue;
                String string = supplierDarkNameMap.get(l);
                minestSupDarkName.append(string).append(";");
            }
            this.getModel().setValue("minimumsupdarkname", (Object)minestSupDarkName.toString());
            this.getModel().setValue("topsupplier", (Object)maxestSupplier.toArray());
            StringBuilder maxestSupDarkName = new StringBuilder();
            for (Long l : maxestSupplier) {
                if (!supplierDarkNameMap.containsKey(l)) continue;
                String string = supplierDarkNameMap.get(l);
                maxestSupDarkName.append(string).append(";");
            }
            this.getModel().setValue("topsupdarkname", (Object)maxestSupDarkName.toString());
            this.getModel().setValue("lowestrate", (Object)minRate.multiply(new BigDecimal("100")));
            this.getModel().setValue("maxrate", (Object)maxRate.multiply(new BigDecimal("100")));
            this.getModel().setValue("miniratesupplier", (Object)minRateSupplier.toArray());
            StringBuilder stringBuilder = new StringBuilder();
            for (Long l : minRateSupplier) {
                if (!supplierDarkNameMap.containsKey(l)) continue;
                String darkName = supplierDarkNameMap.get(l);
                stringBuilder.append(darkName).append(";");
            }
            this.getModel().setValue("miniratesupdarkname", (Object)stringBuilder.toString());
            this.getModel().setValue("topratesupplier", (Object)maxRateSupplier.toArray());
            StringBuilder stringBuilder2 = new StringBuilder();
            for (Long supplierId : maxRateSupplier) {
                if (!supplierDarkNameMap.containsKey(supplierId)) continue;
                String darkName = supplierDarkNameMap.get(supplierId);
                stringBuilder2.append(darkName).append(";");
            }
            this.getModel().setValue("topratesupdarkname", (Object)stringBuilder2.toString());
            this.getModel().setValue("avgrate", (Object)avgRate.multiply(new BigDecimal("100")));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < supplierEntryColl.size(); ++i) {
                DynamicObject supplierDetailRow2 = (DynamicObject)supplierEntryColl.get(i);
                boolean isInvalId = supplierDetailRow2.getBoolean("supplier_isinvalid");
                boolean isTender = supplierDetailRow2.getBoolean("supplier_istender");
                if (isInvalId || !isTender) continue;
                String purSupplier3 = supplierDetailRow2.getString("supplier.name");
                arrayList.add(purSupplier3);
            }
            HashMap<String, String> supplierToIdentification = new HashMap<String, String>(16);
            int j = 0;
            for (String string : arrayList) {
                String Identification = "dyn_column" + j;
                supplierToIdentification.put(string, Identification);
                ++j;
            }
            if (bidType != 0) {
                HashSet<String> supplierSetKey = new HashSet<String>();
                ArrayList<MateriaIdAndMaterialdes> materiaIdAndMteriadesList = new ArrayList<MateriaIdAndMaterialdes>();
                if (supplierDetailColl != null && supplierDetailColl.size() > 0) {
                    for (int i = 0; i < supplierDetailColl.size(); ++i) {
                        DynamicObject supplierDeatailRow = (DynamicObject)supplierDetailColl.get(i);
                        purSupplierName = supplierDeatailRow.getString("pursupplier.name");
                        if (!supplierToIdentification.containsKey(purSupplierName)) continue;
                        pursupplier = supplierDeatailRow.getDynamicObject("pursupplier").getPkValue().toString();
                        if (supplierSetKey.size() == 0) {
                            supplierSetKey.add(pursupplier);
                        } else if (!supplierSetKey.contains(pursupplier)) break;
                        DynamicObject materiaId = supplierDeatailRow.getDynamicObject("materialid");
                        Long materidaIdPk = materiaId == null ? null : Long.valueOf(Long.parseLong(materiaId.getPkValue().toString()));
                        String materiaIdes = supplierDeatailRow.getString("materialdes");
                        BigDecimal qty = supplierDeatailRow.getBigDecimal("qty");
                        String purentrycontent2 = supplierDeatailRow.getString("purentrycontent");
                        MateriaIdAndMaterialdes materiaIdAndMaterialdes = new MateriaIdAndMaterialdes(materiaId, materidaIdPk, materiaIdes, purentrycontent2, qty);
                        materiaIdAndMteriadesList.add(materiaIdAndMaterialdes);
                        DynamicObject newComparisonInformation2 = comparisonInformation.addNew();
                        if (bidType == 1) {
                            newComparisonInformation2.set("materialid", (Object)materiaId);
                        } else {
                            DynamicObject resourceItem = supplierDeatailRow.getDynamicObject("resourceitem");
                            newComparisonInformation2.set("resourceitem", (Object)resourceItem);
                        }
                        newComparisonInformation2.set("baseunit", supplierDeatailRow.get("baseunit"));
                        newComparisonInformation2.set("materialdes", (Object)materiaIdes);
                        newComparisonInformation2.set("qty", (Object)qty);
                        newComparisonInformation2.set("purentrycontent", (Object)purentrycontent2);
                    }
                }
                String idName = "";
                idName = bidType == 1 ? "materialid" : "resourceitem";
                for (int k = 0; k < supplierDetailColl.size(); ++k) {
                    DynamicObject supplierDeatailRow = (DynamicObject)supplierDetailColl.get(k);
                    String purSupplierName2 = supplierDeatailRow.getString("pursupplier.name");
                    if (!supplierToIdentification.containsKey(purSupplierName2)) continue;
                    String materiaIdes = supplierDeatailRow.getString("materialdes") == null ? "" : supplierDeatailRow.getString("materialdes");
                    BigDecimal incluTaxmount = supplierDeatailRow.getBigDecimal("inclutaxamount");
                    for (int i = 0; i < comparisonInformation.size(); ++i) {
                        String compariconMateriaIdes;
                        DynamicObject comparisonInformationRow = (DynamicObject)comparisonInformation.get(i);
                        DynamicObject materiaId = supplierDeatailRow.getDynamicObject(idName);
                        DynamicObject materidlId = comparisonInformationRow.getDynamicObject(idName);
                        String string = compariconMateriaIdes = comparisonInformationRow.getString("materialdes") == null ? "" : comparisonInformationRow.getString("materialdes");
                        if (materiaId == null || materidlId == null || !StringUtils.equals((CharSequence)materidlId.getPkValue().toString(), (CharSequence)materiaId.getPkValue().toString()) || !StringUtils.equals((CharSequence)compariconMateriaIdes, (CharSequence)materiaIdes)) continue;
                        DynamicObject questionClarify3 = this.getDataFromlatestData(bidProjectID, supplierDeatailRow.getDynamicObject("pursupplier"), enablemultisection, sectionName);
                        if (questionClarify3 != null) {
                            DynamicObjectCollection clarifyBidSectionColl2 = questionClarify3.getDynamicObjectCollection("bidsection");
                            for (int q = 0; q < clarifyBidSectionColl2.size(); ++q) {
                                DynamicObjectCollection calrifySupplierDetailColl2;
                                DynamicObject calrifyBidSection2 = (DynamicObject)clarifyBidSectionColl2.get(q);
                                String calrifySectionName2 = calrifyBidSection2.getString("sectionname");
                                if (enablemultisection.booleanValue() && (calrifySectionName2 == null || !calrifySectionName2.equals(sectionName)) || (calrifySupplierDetailColl2 = calrifyBidSection2.getDynamicObjectCollection("supplierdetail")) == null) continue;
                                for (int w = 0; w < calrifySupplierDetailColl2.size(); ++w) {
                                    DynamicObject calrifySupplierDetail2 = (DynamicObject)calrifySupplierDetailColl2.get(w);
                                    DynamicObject purSupplier4 = calrifySupplierDetail2.getDynamicObject("pursupplier");
                                    DynamicObject materialId = calrifySupplierDetail2.getDynamicObject(idName);
                                    String materialIdes = calrifySupplierDetail2.getString("materialdes") == null ? "" : calrifySupplierDetail2.getString("materialdes");
                                    BigDecimal calrifynclutaxAmount = calrifySupplierDetail2.getBigDecimal("inclutaxamount");
                                    if (((Long)purSupplier4.getPkValue()).compareTo((Long)supplierDeatailRow.getDynamicObject("pursupplier").getPkValue()) != 0 || ((Long)materialId.getPkValue()).compareTo((Long)materidlId.getPkValue()) != 0 || !StringUtils.equals((CharSequence)compariconMateriaIdes, (CharSequence)materialIdes)) continue;
                                    incluTaxmount = calrifynclutaxAmount;
                                }
                            }
                        }
                        comparisonInformationRow.set((String)supplierToIdentification.get(purSupplierName2), (Object)incluTaxmount);
                    }
                }
                for (int i = 0; i < comparisonInformation.size(); ++i) {
                    DynamicObject comparisonInformationRow = (DynamicObject)comparisonInformation.get(i);
                    BigDecimal maxPrice = BigDecimal.ZERO;
                    BigDecimal minPrice = BigDecimal.ZERO;
                    BigDecimal avgPrice = BigDecimal.ZERO;
                    BigDecimal sumPrice = BigDecimal.ZERO;
                    int size = 0;
                    for (Map.Entry supplier : supplierToIdentification.entrySet()) {
                        String identification2 = (String)supplier.getValue();
                        BigDecimal price = comparisonInformationRow.getBigDecimal(identification2);
                        if (minPrice.compareTo(BigDecimal.ZERO) == 0) {
                            minPrice = price;
                        }
                        sumPrice = sumPrice.add(price);
                        if (price.compareTo(maxPrice) > 0) {
                            maxPrice = price;
                        }
                        if (price.compareTo(minPrice) < 0) {
                            minPrice = price;
                        }
                        ++size;
                    }
                    avgPrice = sumPrice.divide(new BigDecimal(size), 2, 4);
                    if (avgPrice.compareTo(BigDecimal.valueOf(0.0)) == 0) {
                        avgPrice = BigDecimal.ZERO;
                    }
                    comparisonInformationRow.set("maximumprice", (Object)maxPrice);
                    comparisonInformationRow.set("lowestprice", (Object)minPrice);
                    comparisonInformationRow.set("avgprice", (Object)avgPrice);
                }
                DynamicObjectCollection parentComparisonColl = listPriceComparsionModel.getDynamicObjectCollection("comparisoninformation");
                HashMap<String, Integer> maritAndSupplierOffset = new HashMap<String, Integer>();
                for (int i = 0; i < parentComparisonColl.size(); ++i) {
                    parentComparison = (DynamicObject)parentComparisonColl.get(i);
                    DynamicObject materiaId = parentComparison.getDynamicObject(idName);
                    String purentryContent2 = parentComparison.getString("purentrycontent") == null ? "" : parentComparison.getString("purentrycontent");
                    this.setDecisonInfromation(materiaId, i);
                    DynamicObjectCollection parityColl = parentComparison.getDynamicObjectCollection("parity");
                    HashMap<String, Integer> tempOffset = new HashMap<String, Integer>();
                    for (int k = 0; k < supplierDetailColl.size(); ++k) {
                        Object calrifySupplierDetail3;
                        DynamicObject supplierDetailRow3 = (DynamicObject)supplierDetailColl.get(k);
                        DynamicObject purSupplier5 = supplierDetailRow3.getDynamicObject("pursupplier");
                        String purSupplierName3 = supplierDetailRow3.getString("pursupplier.name");
                        if (!supplierToIdentification.containsKey(purSupplierName3)) continue;
                        DynamicObject openMateriaId = supplierDetailRow3.getDynamicObject(idName);
                        String openPurentryContent = supplierDetailRow3.getString("purentrycontent") == null ? "" : supplierDetailRow3.getString("purentrycontent");
                        String openMateriaIdes = supplierDetailRow3.getString("materialdes") == null ? "" : supplierDetailRow3.getString("materialdes");
                        BigDecimal incutaxPrice = supplierDetailRow3.getBigDecimal("inclutaxprice");
                        BigDecimal inclutaxAmount = supplierDetailRow3.getBigDecimal("inclutaxamount");
                        BigDecimal taRxate = supplierDetailRow3.getBigDecimal("taxrate");
                        BigDecimal taxAmount = supplierDetailRow3.getBigDecimal("taxamount");
                        BigDecimal excepttaxAmount = supplierDetailRow3.getBigDecimal("excepttaxamount");
                        DynamicObject questionClarify4 = this.getDataFromlatestData(bidProjectID, purSupplier5, enablemultisection, sectionName);
                        if (questionClarify4 != null) {
                            DynamicObjectCollection clarifyBidSectionColl3 = questionClarify4.getDynamicObjectCollection("bidsection");
                            for (int q = 0; q < clarifyBidSectionColl3.size(); ++q) {
                                DynamicObjectCollection calrifySupplierDetailColl3;
                                DynamicObject calrifyBidSection3 = (DynamicObject)clarifyBidSectionColl3.get(q);
                                String calrifySectionName3 = calrifyBidSection3.getString("sectionname");
                                if (enablemultisection.booleanValue() && (calrifySectionName3 == null || !calrifySectionName3.equals(sectionName)) || (calrifySupplierDetailColl3 = calrifyBidSection3.getDynamicObjectCollection("supplierdetail")) == null) continue;
                                for (int w = 0; w < calrifySupplierDetailColl3.size(); ++w) {
                                    calrifySupplierDetail3 = (DynamicObject)calrifySupplierDetailColl3.get(w);
                                    DynamicObject calrifyPurSupplier = calrifySupplierDetail3.getDynamicObject("pursupplier");
                                    DynamicObject materialId = calrifySupplierDetail3.getDynamicObject(idName);
                                    String materialIdes = calrifySupplierDetail3.getString("materialdes") == null ? "" : calrifySupplierDetail3.getString("materialdes");
                                    BigDecimal calrifynclutaxAmount = calrifySupplierDetail3.getBigDecimal("inclutaxamount");
                                    if (openMateriaId == null || materialId == null || !StringUtils.equals((CharSequence)materialId.getPkValue().toString(), (CharSequence)openMateriaId.getPkValue().toString()) || !StringUtils.equals((CharSequence)materialIdes, (CharSequence)openMateriaIdes) || ((Long)calrifyPurSupplier.getPkValue()).compareTo((Long)purSupplier5.getPkValue()) != 0) continue;
                                    incutaxPrice = calrifySupplierDetail3.getBigDecimal("inclutaxprice");
                                    inclutaxAmount = calrifySupplierDetail3.getBigDecimal("inclutaxamount");
                                    taRxate = calrifySupplierDetail3.getBigDecimal("taxrate");
                                    taxAmount = calrifySupplierDetail3.getBigDecimal("taxamount");
                                    excepttaxAmount = calrifySupplierDetail3.getBigDecimal("excepttaxamount");
                                }
                            }
                        }
                        if (materiaId == null || openMateriaId == null || !StringUtils.equals((CharSequence)materiaId.getPkValue().toString(), (CharSequence)openMateriaId.getPkValue().toString()) || !StringUtils.equals((CharSequence)openPurentryContent, (CharSequence)purentryContent2) || openMateriaId == null || purSupplier5.getPkValue() == null) continue;
                        StringBuilder builder = new StringBuilder();
                        String s = builder.append(openMateriaId.getPkValue()).append(purSupplier5.getPkValue()).toString();
                        Integer tempOffsetInt = 0;
                        Integer realOffset = 0;
                        if (tempOffset.get(s) != null) {
                            tempOffsetInt = (Integer)tempOffset.get(s);
                        }
                        if (maritAndSupplierOffset.get(s) != null) {
                            realOffset = (Integer)maritAndSupplierOffset.get(s);
                        }
                        boolean flag = tempOffsetInt.intValue() != realOffset.intValue();
                        Integer w = tempOffsetInt;
                        tempOffsetInt = tempOffsetInt + 1;
                        calrifySupplierDetail3 = tempOffsetInt;
                        tempOffset.put(s, tempOffsetInt);
                        if (flag) continue;
                        w = tempOffsetInt;
                        tempOffsetInt = tempOffsetInt + 1;
                        calrifySupplierDetail3 = tempOffsetInt;
                        tempOffset.put(s, tempOffsetInt);
                        w = realOffset;
                        realOffset = realOffset + 1;
                        calrifySupplierDetail3 = realOffset;
                        maritAndSupplierOffset.put(s, realOffset);
                        String parityIdName = "";
                        parityIdName = bidType == 1 ? "parity_materiaid" : "parity_resourceitem";
                        DynamicObject parity = parityColl.addNew();
                        parity.set(parityIdName, (Object)openMateriaId);
                        parity.set("parity_purentrycontent", (Object)openPurentryContent);
                        parity.set("parity_supplier", (Object)purSupplier5);
                        if (isDark && supplierDarkNameMap.containsKey((Long)purSupplier5.getPkValue())) {
                            parity.set("parity_darkname", (Object)supplierDarkNameMap.get((Long)purSupplier5.getPkValue()));
                        }
                        parity.set("parity_inclutaxprice", (Object)incutaxPrice);
                        parity.set("parity_inclutaxamount", (Object)inclutaxAmount);
                        parity.set("parity_taxrate", (Object)taRxate.multiply(new BigDecimal("100")));
                        parity.set("parity_taxamount", (Object)taxAmount);
                        parity.set("parity_excepttaxamount", (Object)excepttaxAmount);
                    }
                }
            } else if (!isRate.booleanValue()) {
                purentryContentList = new ArrayList<String>();
                HashSet<String> supplierSetKey = new HashSet<String>();
                if (supplierDetailColl != null && supplierDetailColl.size() > 0) {
                    for (int i = 0; i < supplierDetailColl.size(); ++i) {
                        DynamicObject supplierDeatailRow = (DynamicObject)supplierDetailColl.get(i);
                        purSupplierName = supplierDeatailRow.getString("pursupplier.name");
                        if (!supplierToIdentification.containsKey(purSupplierName)) continue;
                        pursupplier = supplierDeatailRow.getDynamicObject("pursupplier").getPkValue().toString();
                        if (supplierSetKey.size() == 0) {
                            supplierSetKey.add(pursupplier);
                        } else if (!supplierSetKey.contains(pursupplier)) break;
                        purentrycontent = supplierDeatailRow.getString("purentrycontent");
                        purentryContentList.add(purentrycontent);
                    }
                }
                for (String purentrycontent3 : purentryContentList) {
                    newComparisonInformation = comparisonInformation.addNew();
                    newComparisonInformation.set("purentrycontent", (Object)purentrycontent3);
                }
                for (int k = 0; k < supplierDetailColl.size(); ++k) {
                    DynamicObject supplierDeatailRow = (DynamicObject)supplierDetailColl.get(k);
                    purSupplierName = supplierDeatailRow.getString("pursupplier.name");
                    if (!supplierToIdentification.containsKey(purSupplierName)) continue;
                    purentryContent = supplierDeatailRow.getString("purentrycontent");
                    BigDecimal incluTaxmount = supplierDeatailRow.getBigDecimal("inclutaxamount");
                    for (int i = 0; i < comparisonInformation.size(); ++i) {
                        DynamicObject comparisonInformationRow = (DynamicObject)comparisonInformation.get(i);
                        listComparsionPurentryContent = comparisonInformationRow.getString("purentrycontent");
                        if (listComparsionPurentryContent == null || !StringUtils.equals((CharSequence)listComparsionPurentryContent, (CharSequence)purentryContent)) continue;
                        questionClarify = this.getDataFromlatestData(bidProjectID, supplierDeatailRow.getDynamicObject("pursupplier"), enablemultisection, sectionName);
                        if (questionClarify != null) {
                            clarifyBidSectionColl = questionClarify.getDynamicObjectCollection("bidsection");
                            for (int q = 0; q < clarifyBidSectionColl.size(); ++q) {
                                calrifyBidSection = (DynamicObject)clarifyBidSectionColl.get(q);
                                calrifySectionName = calrifyBidSection.getString("sectionname");
                                if (enablemultisection.booleanValue() && (calrifySectionName == null || !StringUtils.equals((CharSequence)calrifySectionName, (CharSequence)sectionName)) || (calrifySupplierDetailColl = calrifyBidSection.getDynamicObjectCollection("supplierdetail")) == null) continue;
                                for (int w = 0; w < calrifySupplierDetailColl.size(); ++w) {
                                    calrifySupplierDetail = (DynamicObject)calrifySupplierDetailColl.get(w);
                                    DynamicObject purSupplier2 = calrifySupplierDetail.getDynamicObject("pursupplier");
                                    purrentryContent = calrifySupplierDetail.getString("purentrycontent");
                                    BigDecimal calrifynclutaxAmount = calrifySupplierDetail.getBigDecimal("inclutaxamount");
                                    if (((Long)purSupplier2.getPkValue()).compareTo((Long)supplierDeatailRow.getDynamicObject("pursupplier").getPkValue()) != 0 || !StringUtils.equals((CharSequence)listComparsionPurentryContent, (CharSequence)purrentryContent)) continue;
                                    incluTaxmount = calrifynclutaxAmount;
                                }
                            }
                        }
                        comparisonInformationRow.set((String)supplierToIdentification.get(purSupplierName), (Object)incluTaxmount);
                    }
                }
                for (int i = 0; i < comparisonInformation.size(); ++i) {
                    DynamicObject comparisonInformationRow = (DynamicObject)comparisonInformation.get(i);
                    BigDecimal maxPrice = BigDecimal.ZERO;
                    BigDecimal minPrice = BigDecimal.ZERO;
                    BigDecimal avgPrice = BigDecimal.ZERO;
                    BigDecimal sumPrice = BigDecimal.ZERO;
                    int size = 0;
                    for (Map.Entry supplierToIdentificationMap : supplierToIdentification.entrySet()) {
                        identification = (String)supplierToIdentificationMap.getValue();
                        BigDecimal price = comparisonInformationRow.getBigDecimal(identification);
                        if (minPrice.compareTo(BigDecimal.ZERO) == 0) {
                            minPrice = price;
                        }
                        sumPrice = sumPrice.add(price);
                        if (price.compareTo(maxPrice) > 0) {
                            maxPrice = price;
                        }
                        if (price.compareTo(minPrice) < 0) {
                            minPrice = price;
                        }
                        ++size;
                    }
                    avgPrice = sumPrice.divide(new BigDecimal(size), 2, 4);
                    if (avgPrice.compareTo(BigDecimal.valueOf(0.0)) == 0) {
                        avgPrice = BigDecimal.ZERO;
                    }
                    comparisonInformationRow.set("maximumprice", (Object)maxPrice);
                    comparisonInformationRow.set("lowestprice", (Object)minPrice);
                    comparisonInformationRow.set("avgprice", (Object)avgPrice);
                }
                HashMap<String, Integer> maritAndSupplierOffset = new HashMap<String, Integer>();
                DynamicObjectCollection parentComparisonColl = listPriceComparsionModel.getDynamicObjectCollection("comparisoninformation");
                for (int i = 0; i < parentComparisonColl.size(); ++i) {
                    DynamicObject parentComparison2 = (DynamicObject)parentComparisonColl.get(i);
                    String purentryContent3 = parentComparison2.getString("purentrycontent");
                    DynamicObjectCollection parityColl = parentComparison2.getDynamicObjectCollection("parity");
                    HashMap<String, Integer> tempOffset = new HashMap<String, Integer>();
                    for (int k = 0; k < supplierDetailColl.size(); ++k) {
                        String openPurentryContent;
                        Object calrifySupplierDetail4;
                        supplierDetailRow = (DynamicObject)supplierDetailColl.get(k);
                        purSupplier = supplierDetailRow.getDynamicObject("pursupplier");
                        String purSupplierName4 = supplierDetailRow.getString("pursupplier.name");
                        if (!supplierToIdentification.containsKey(purSupplierName4)) continue;
                        BigDecimal incutaxPrice = supplierDetailRow.getBigDecimal("inclutaxprice");
                        BigDecimal inclutaxAmount = supplierDetailRow.getBigDecimal("inclutaxamount");
                        BigDecimal taRxate = supplierDetailRow.getBigDecimal("taxrate");
                        BigDecimal taxAmount = supplierDetailRow.getBigDecimal("taxamount");
                        BigDecimal excepttaxAmount = supplierDetailRow.getBigDecimal("excepttaxamount");
                        DynamicObject questionClarify5 = this.getDataFromlatestData(bidProjectID, purSupplier, enablemultisection, sectionName);
                        if (questionClarify5 != null) {
                            DynamicObjectCollection clarifyBidSectionColl4 = questionClarify5.getDynamicObjectCollection("bidsection");
                            for (int q = 0; q < clarifyBidSectionColl4.size(); ++q) {
                                DynamicObjectCollection calrifySupplierDetailColl4;
                                DynamicObject calrifyBidSection4 = (DynamicObject)clarifyBidSectionColl4.get(q);
                                String calrifySectionName4 = calrifyBidSection4.getString("sectionname");
                                if (enablemultisection.booleanValue() && (calrifySectionName4 == null || !StringUtils.equals((CharSequence)calrifySectionName4, (CharSequence)sectionName)) || (calrifySupplierDetailColl4 = calrifyBidSection4.getDynamicObjectCollection("supplierdetail")) == null) continue;
                                for (int w = 0; w < calrifySupplierDetailColl4.size(); ++w) {
                                    calrifySupplierDetail4 = (DynamicObject)calrifySupplierDetailColl4.get(w);
                                    DynamicObject calrifyPurSupplier = calrifySupplierDetail4.getDynamicObject("pursupplier");
                                    String calrifyPurentryContent = calrifySupplierDetail4.getString("purentrycontent");
                                    BigDecimal calrifynclutaxAmount = calrifySupplierDetail4.getBigDecimal("inclutaxamount");
                                    if (!StringUtils.equals((CharSequence)purentryContent3, (CharSequence)calrifyPurentryContent) || ((Long)calrifyPurSupplier.getPkValue()).compareTo((Long)purSupplier.getPkValue()) != 0) continue;
                                    incutaxPrice = calrifySupplierDetail4.getBigDecimal("inclutaxprice");
                                    inclutaxAmount = calrifySupplierDetail4.getBigDecimal("inclutaxamount");
                                    taRxate = calrifySupplierDetail4.getBigDecimal("taxrate");
                                    taxAmount = calrifySupplierDetail4.getBigDecimal("taxamount");
                                    excepttaxAmount = calrifySupplierDetail4.getBigDecimal("excepttaxamount");
                                }
                            }
                        }
                        if ((openPurentryContent = supplierDetailRow.getString("purentrycontent")) == null || !StringUtils.equals((CharSequence)openPurentryContent, (CharSequence)purentryContent3) || openPurentryContent == null || purSupplier.getPkValue() == null) continue;
                        StringBuilder builder1 = new StringBuilder();
                        String s = openPurentryContent + purSupplier.getPkValue();
                        Integer tempOffsetInt = 0;
                        Integer realOffset = 0;
                        if (tempOffset.get(s) != null) {
                            tempOffsetInt = (Integer)tempOffset.get(s);
                        }
                        if (maritAndSupplierOffset.get(s) != null) {
                            realOffset = (Integer)maritAndSupplierOffset.get(s);
                        }
                        boolean flag = tempOffsetInt.intValue() != realOffset.intValue();
                        calrifySupplierDetail4 = tempOffsetInt;
                        Integer n = tempOffsetInt = Integer.valueOf(tempOffsetInt + 1);
                        tempOffset.put(s, tempOffsetInt);
                        if (flag) continue;
                        calrifySupplierDetail4 = tempOffsetInt;
                        n = tempOffsetInt = Integer.valueOf(tempOffsetInt + 1);
                        tempOffset.put(s, tempOffsetInt);
                        calrifySupplierDetail4 = realOffset;
                        n = realOffset = Integer.valueOf(realOffset + 1);
                        maritAndSupplierOffset.put(s, realOffset);
                        DynamicObject parity = parityColl.addNew();
                        parity.set("parity_purentrycontent", (Object)openPurentryContent);
                        parity.set("parity_supplier", (Object)purSupplier);
                        if (isDark && supplierDarkNameMap.containsKey((Long)purSupplier.getPkValue())) {
                            parity.set("parity_darkname", (Object)supplierDarkNameMap.get((Long)purSupplier.getPkValue()));
                        }
                        parity.set("parity_inclutaxamount", (Object)inclutaxAmount);
                        parity.set("parity_taxrate", (Object)taRxate.multiply(new BigDecimal("100")));
                        parity.set("parity_taxamount", (Object)taxAmount);
                        parity.set("parity_excepttaxamount", (Object)excepttaxAmount);
                    }
                }
            } else {
                purentryContentList = new ArrayList();
                HashSet<String> supplierSetKey = new HashSet<String>();
                for (int i = 0; i < supplierDetailColl.size(); ++i) {
                    DynamicObject supplierDeatailRow = (DynamicObject)supplierDetailColl.get(i);
                    purSupplierName = supplierDeatailRow.getString("pursupplier.name");
                    if (!supplierToIdentification.containsKey(purSupplierName)) continue;
                    pursupplier = supplierDeatailRow.getDynamicObject("pursupplier").getPkValue().toString();
                    if (supplierSetKey.size() == 0) {
                        supplierSetKey.add(pursupplier);
                    } else if (!supplierSetKey.contains(pursupplier)) break;
                    purentrycontent = supplierDeatailRow.getString("purentrycontent");
                    purentryContentList.add(purentrycontent);
                }
                for (String purentrycontent4 : purentryContentList) {
                    newComparisonInformation = comparisonInformation.addNew();
                    newComparisonInformation.set("purentrycontent", (Object)purentrycontent4);
                }
                for (int k = 0; k < supplierDetailColl.size(); ++k) {
                    DynamicObject supplierDeatailRow = (DynamicObject)supplierDetailColl.get(k);
                    purSupplierName = supplierDeatailRow.getString("pursupplier.name");
                    if (!supplierToIdentification.containsKey(purSupplierName)) continue;
                    purentryContent = supplierDeatailRow.getString("purentrycontent");
                    BigDecimal costRate = supplierDeatailRow.getBigDecimal("costrate");
                    for (int i = 0; i < comparisonInformation.size(); ++i) {
                        DynamicObject comparisonInformationRow = (DynamicObject)comparisonInformation.get(i);
                        listComparsionPurentryContent = comparisonInformationRow.getString("purentrycontent");
                        if (listComparsionPurentryContent == null || !StringUtils.equals((CharSequence)listComparsionPurentryContent, (CharSequence)purentryContent)) continue;
                        questionClarify = this.getDataFromlatestData(bidProjectID, supplierDeatailRow.getDynamicObject("pursupplier"), enablemultisection, sectionName);
                        if (questionClarify != null) {
                            clarifyBidSectionColl = questionClarify.getDynamicObjectCollection("bidsection");
                            for (int q = 0; q < clarifyBidSectionColl.size(); ++q) {
                                calrifyBidSection = (DynamicObject)clarifyBidSectionColl.get(q);
                                calrifySectionName = calrifyBidSection.getString("sectionname");
                                if (enablemultisection.booleanValue() && (calrifySectionName == null || !StringUtils.equals((CharSequence)calrifySectionName, (CharSequence)sectionName)) || (calrifySupplierDetailColl = calrifyBidSection.getDynamicObjectCollection("supplierdetail")) == null) continue;
                                for (int w = 0; w < calrifySupplierDetailColl.size(); ++w) {
                                    calrifySupplierDetail = (DynamicObject)calrifySupplierDetailColl.get(w);
                                    DynamicObject purSupplier2 = calrifySupplierDetail.getDynamicObject("pursupplier");
                                    purrentryContent = calrifySupplierDetail.getString("purentrycontent");
                                    BigDecimal purCostRate = calrifySupplierDetail.getBigDecimal("costrate");
                                    if (((Long)purSupplier2.getPkValue()).compareTo((Long)supplierDeatailRow.getDynamicObject("pursupplier").getPkValue()) != 0 || !StringUtils.equals((CharSequence)listComparsionPurentryContent, (CharSequence)purrentryContent)) continue;
                                    costRate = purCostRate;
                                }
                            }
                        }
                        comparisonInformationRow.set((String)supplierToIdentification.get(purSupplierName), (Object)costRate);
                    }
                }
                for (int i = 0; i < comparisonInformation.size(); ++i) {
                    DynamicObject comparisonInformationRow = (DynamicObject)comparisonInformation.get(i);
                    BigDecimal comparisionMaxRate = BigDecimal.ZERO;
                    BigDecimal comparisionMinRate = BigDecimal.ZERO;
                    BigDecimal comparisionAvgRate = BigDecimal.ZERO;
                    BigDecimal comparisionSumRate = BigDecimal.ZERO;
                    int size = 0;
                    for (Map.Entry supplierToIdentificationMap : supplierToIdentification.entrySet()) {
                        identification = (String)supplierToIdentificationMap.getValue();
                        BigDecimal price = comparisonInformationRow.getBigDecimal(identification);
                        if (comparisionMinRate.compareTo(BigDecimal.ZERO) == 0) {
                            comparisionMinRate = price;
                        }
                        comparisionSumRate = comparisionSumRate.add(price);
                        if (price.compareTo(comparisionMaxRate) > 0) {
                            comparisionMaxRate = price;
                        }
                        if (price.compareTo(comparisionMinRate) < 0) {
                            comparisionMinRate = price;
                        }
                        ++size;
                    }
                    comparisionAvgRate = comparisionSumRate.divide(new BigDecimal(size), 4, 4);
                    if (comparisionAvgRate.compareTo(BigDecimal.valueOf(0.0)) == 0) {
                        comparisionAvgRate = BigDecimal.ZERO;
                    }
                    comparisonInformationRow.set("informationmaxrate", (Object)comparisionMaxRate.multiply(new BigDecimal("100")));
                    comparisonInformationRow.set("informationlowestrate", (Object)comparisionMinRate.multiply(new BigDecimal("100")));
                    comparisonInformationRow.set("informationavgrate", (Object)comparisionAvgRate.multiply(new BigDecimal("100")));
                }
                HashMap<String, Integer> maritAndSupplierOffset = new HashMap<String, Integer>();
                DynamicObjectCollection parentComparisonColl = listPriceComparsionModel.getDynamicObjectCollection("comparisoninformation");
                HashMap<String, Integer> tempOffset = new HashMap<String, Integer>();
                for (int i = 0; i < parentComparisonColl.size(); ++i) {
                    parentComparison = (DynamicObject)parentComparisonColl.get(i);
                    String purentryContent4 = parentComparison.getString("purentrycontent");
                    DynamicObjectCollection parityColl = parentComparison.getDynamicObjectCollection("parity");
                    tempOffset.clear();
                    for (int k = 0; k < supplierDetailColl.size(); ++k) {
                        Object calrifySupplierDetailColl5;
                        supplierDetailRow = (DynamicObject)supplierDetailColl.get(k);
                        purSupplier = supplierDetailRow.getDynamicObject("pursupplier");
                        String purSupplierName5 = supplierDetailRow.getString("pursupplier.name");
                        if (!supplierToIdentification.containsKey(purSupplierName5)) continue;
                        BigDecimal parityRate = supplierDetailRow.getBigDecimal("costrate");
                        String openPurentryContent = supplierDetailRow.getString("purentrycontent");
                        DynamicObject questionClarify6 = this.getDataFromlatestData(bidProjectID, purSupplier, enablemultisection, sectionName);
                        if (questionClarify6 != null) {
                            DynamicObjectCollection clarifyBidSectionColl5 = questionClarify6.getDynamicObjectCollection("bidsection");
                            for (int q = 0; q < clarifyBidSectionColl5.size(); ++q) {
                                DynamicObject calrifyBidSection5 = (DynamicObject)clarifyBidSectionColl5.get(q);
                                String calrifySectionName5 = calrifyBidSection5.getString("sectionname");
                                if (enablemultisection.booleanValue() && (calrifySectionName5 == null || !StringUtils.equals((CharSequence)calrifySectionName5, (CharSequence)sectionName)) || (calrifySupplierDetailColl5 = calrifyBidSection5.getDynamicObjectCollection("supplierdetail")) == null) continue;
                                for (int w = 0; w < calrifySupplierDetailColl5.size(); ++w) {
                                    DynamicObject calrifySupplierDetail5 = (DynamicObject)calrifySupplierDetailColl5.get(w);
                                    DynamicObject calrifyPurSupplier = calrifySupplierDetail5.getDynamicObject("pursupplier");
                                    String calrifyPurentryContent = calrifySupplierDetail5.getString("purentrycontent");
                                    BigDecimal calrifynclutaxAmount = calrifySupplierDetail5.getBigDecimal("inclutaxamount");
                                    if (!StringUtils.equals((CharSequence)purentryContent4, (CharSequence)calrifyPurentryContent) || ((Long)calrifyPurSupplier.getPkValue()).compareTo((Long)purSupplier.getPkValue()) != 0) continue;
                                    parityRate = calrifySupplierDetail5.getBigDecimal("costrate");
                                }
                            }
                        }
                        if (openPurentryContent == null || !StringUtils.equals((CharSequence)openPurentryContent, (CharSequence)purentryContent4)) continue;
                        String s = purentryContent4 + "_" + purSupplier.getPkValue();
                        Integer tempOffsetInt = 0;
                        Integer realOffset = 0;
                        if (tempOffset.get(s) != null) {
                            tempOffsetInt = (Integer)tempOffset.get(s);
                        }
                        if (maritAndSupplierOffset.get(s) != null) {
                            realOffset = (Integer)maritAndSupplierOffset.get(s);
                        }
                        boolean flag = tempOffsetInt.intValue() != realOffset.intValue();
                        calrifySupplierDetailColl5 = tempOffsetInt;
                        Integer n = tempOffsetInt = Integer.valueOf(tempOffsetInt + 1);
                        tempOffset.put(s, tempOffsetInt);
                        if (flag) continue;
                        calrifySupplierDetailColl5 = tempOffsetInt;
                        n = tempOffsetInt = Integer.valueOf(tempOffsetInt + 1);
                        tempOffset.put(s, tempOffsetInt);
                        calrifySupplierDetailColl5 = realOffset;
                        n = realOffset = Integer.valueOf(realOffset + 1);
                        maritAndSupplierOffset.put(s, realOffset);
                        DynamicObject parity = parityColl.addNew();
                        parity.set("parity_purentrycontent", (Object)openPurentryContent);
                        parity.set("parity_supplier", (Object)purSupplier);
                        if (isDark && supplierDarkNameMap.containsKey((Long)purSupplier.getPkValue())) {
                            parity.set("parity_darkname", (Object)supplierDarkNameMap.get((Long)purSupplier.getPkValue()));
                        }
                        parity.set("parity_rate", (Object)parityRate.multiply(new BigDecimal("100")));
                    }
                }
            }
        }
    }

    public HashMap<Long, String> getSupplierDarkName(DynamicObject bidOpen, Boolean isOnlineEval, String sectionName, boolean isDark) {
        String appId = this.getAppId();
        DynamicObject bid_bidDark = null;
        if (isDark) {
            bid_bidDark = "bid".equals(appId) ? BusinessDataServiceHelper.loadSingle((String)"bid_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", bidOpen.getPkValue())}) : BusinessDataServiceHelper.loadSingle((String)"rebm_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", bidOpen.getPkValue())});
        }
        HashMap<Long, String> supplierDarkNameMap = new HashMap<Long, String>();
        if (bid_bidDark != null) {
            supplierDarkNameMap = isOnlineEval != false ? this.getDarkName(bid_bidDark, "bidonlinesection", sectionName, "onlinesectionname", "onlinesupplierentry", "onlinesupplier", "onlinedarkname") : this.getDarkName(bid_bidDark, "evaluationsection", sectionName, "evaluasectionname", "evaluasupplierentry", "evaluationsupplier", "evaluationdarkname");
        }
        return supplierDarkNameMap;
    }

    public HashMap<Long, String> getDarkName(DynamicObject bid_bidDark, String sectionTag, String sectionName, String sectionNameOfDark, String supplierEntryTag, String supplierTag, String darkNameTag) {
        DynamicObjectCollection sectionColl = bid_bidDark.getDynamicObjectCollection(sectionTag);
        HashMap<Long, String> supplierDarkNameMap = new HashMap<Long, String>();
        for (DynamicObject section : sectionColl) {
            if (!sectionName.equals(section.getString(sectionNameOfDark))) continue;
            DynamicObjectCollection supplierColl = section.getDynamicObjectCollection(supplierEntryTag);
            for (DynamicObject supplierEntry : supplierColl) {
                DynamicObject supplier = supplierEntry.getDynamicObject(supplierTag);
                String darkName = supplierEntry.getString(darkNameTag);
                supplierDarkNameMap.put((Long)supplier.getPkValue(), darkName);
            }
        }
        return supplierDarkNameMap;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid sectionEntryGrid = (EntryGrid)this.getControl("comparisoninformation");
        sectionEntryGrid.addCellClickListener((CellClickListener)this);
    }

    private void clickFristRows() {
        IDataModel dataModel = this.getModel();
        int sectionRowCount = dataModel.getEntryRowCount("comparisoninformation");
        if (sectionRowCount > 0) {
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("comparisoninformation");
            entryEntityGrid.addRowClickListener((RowClickEventListener)this);
            entryEntityGrid.selectRows(0, true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.clickFristRows();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("sz", Boolean.TRUE);
        this.getView().updateControlMetadata("mymaterial_qty", map);
        this.getView().updateView("comparisoninformation");
        boolean isDark = (Boolean)this.getView().getFormShowParameter().getCustomParam("isDark");
        this.setVisibleOfDark(isDark);
    }

    private void setVisibleOfDark(boolean isDark) {
        if (isDark) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"miniratesupplier", "minimumsupplier", "topratesupplier", "topsupplier", "summary_supplier", "parity_supplier"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"miniratesupdarkname", "minimumsupdarkname", "topratesupdarkname", "topsupdarkname", "summary_darkname", "parity_darkname"});
        }
    }

    private void setDecisonInfromation(DynamicObject materiaId, int index) {
        this.getView().setEnable(Boolean.TRUE, new String[]{"startdate", "enddate"});
        DynamicObject listPriceComparsionModel = this.getModel().getDataEntity(true);
        Date startDate = listPriceComparsionModel.getDate("startdate");
        Date endDate = listPriceComparsionModel.getDate("enddate");
        Calendar calendar = Calendar.getInstance();
        if (endDate == null) {
            return;
        }
        calendar.setTime(endDate);
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date endDateSQL = calendar.getTime();
        ((DynamicObject)listPriceComparsionModel.getDynamicObjectCollection("comparisoninformation").get(index)).getDynamicObjectCollection("reference").clear();
        this.getView().updateView("reference");
        StringBuilder decisioinSQL = new StringBuilder("bidproject,auditdate,bidsection,supplierentry,supplier,isrecommended,supfinaldetail,lpursupplier,lmaterialid,lmaterialname,lqty,linclutaxprice,linclutaxamount,ltaxrate,ltaxamount,lexcepttaxamount");
        if ("rebm".equals(this.getAppId())) {
            decisioinSQL.append(",lresourceitem");
        }
        QFilter billStatus = new QFilter("billstatus", "in", (Object)new String[]{"C", "S", "R"});
        DynamicObject project = listPriceComparsionModel.getDynamicObject("bidproject");
        DynamicObject org = project.getDynamicObject("org");
        Object orgPKValue = org.getPkValue();
        DynamicObject[] decisionList = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)decisioinSQL.toString(), (QFilter[])new QFilter[]{new QFilter("auditdate", "<", (Object)endDateSQL), new QFilter("auditdate", ">=", (Object)startDate), new QFilter("org", "=", orgPKValue), billStatus});
        for (int i = 0; i < decisionList.length; ++i) {
            DynamicObject bidProjectData;
            int bidType;
            DynamicObject decision = decisionList[i];
            DynamicObject bidProject = decision.getDynamicObject("bidproject");
            if (bidProject == null || (bidType = (bidProjectData = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidtype")).getInt("bidtype")) == 0) continue;
            DynamicObject bidProjectDetail = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"org");
            DynamicObject purchaseOrg = bidProjectDetail.getDynamicObject("org");
            ArrayList<DynamicObject> supplierDecision = new ArrayList<DynamicObject>(10);
            Date auditDate = decision.getDate("auditdate");
            DynamicObjectCollection bidSectionColl = decision.getDynamicObjectCollection("bidsection");
            for (int k = 0; k < bidSectionColl.size(); ++k) {
                DynamicObjectCollection dynamicObjectCollection2;
                DynamicObject bidSection = (DynamicObject)bidSectionColl.get(k);
                DynamicObjectCollection decisionSupplierColl = bidSection.getDynamicObjectCollection("supplierentry");
                for (int p = 0; p < decisionSupplierColl.size(); ++p) {
                    DynamicObject decisionSupplier = (DynamicObject)decisionSupplierColl.get(p);
                    DynamicObject supplier = decisionSupplier.getDynamicObject("supplier");
                    boolean isRecommended = decisionSupplier.getBoolean("isrecommended");
                    if (!isRecommended) continue;
                    supplierDecision.add(supplier);
                }
                DynamicObjectCollection supFinalDetailColl = bidSection.getDynamicObjectCollection("supfinaldetail");
                DynamicObjectCollection dynamicObjectCollection = listPriceComparsionModel.getDynamicObjectCollection("comparisoninformation");
                DynamicObjectCollection referenceColl = dynamicObjectCollection2 = ((DynamicObject)dynamicObjectCollection.get(index)).getDynamicObjectCollection("reference");
                for (int q = 0; q < supFinalDetailColl.size(); ++q) {
                    DynamicObject supFinalDetail = (DynamicObject)supFinalDetailColl.get(q);
                    DynamicObject lpurSupplier = supFinalDetail.getDynamicObject("lpursupplier");
                    String idName = "";
                    String referenceIdName = "";
                    DynamicObject purDynamicObject = null;
                    if (bidType == 1) {
                        idName = "lmaterialid";
                        referenceIdName = "reference_materialid";
                        purDynamicObject = supFinalDetail.getDynamicObject(idName);
                    } else if (bidType == 2 && "rebm".equals(this.getAppId())) {
                        idName = "lresourceitem";
                        referenceIdName = "reference_resourceitem";
                        purDynamicObject = supFinalDetail.getDynamicObject(idName);
                    }
                    BigDecimal dynamicObject = supFinalDetail.getBigDecimal("ltaxrate");
                    BigDecimal dynamicObject1 = supFinalDetail.getBigDecimal("linclutaxamount");
                    if (!supplierDecision.contains(lpurSupplier) || purDynamicObject == null || materiaId == null || ((Long)purDynamicObject.getPkValue()).compareTo((Long)materiaId.getPkValue()) != 0) continue;
                    DynamicObject reference = referenceColl.addNew();
                    reference.set("reference_purchaseorg", (Object)purchaseOrg);
                    reference.set(referenceIdName, (Object)purDynamicObject);
                    reference.set("reference_supplier", (Object)lpurSupplier);
                    reference.set("reference_scalingdate", (Object)auditDate);
                    reference.set("reference_num", (Object)supFinalDetail.getBigDecimal("lqty"));
                    reference.set("reference_inclutaxprice", (Object)supFinalDetail.getBigDecimal("linclutaxprice"));
                    reference.set("reference_inclutaxamount", (Object)supFinalDetail.getBigDecimal("linclutaxamount"));
                    reference.set("reference_taxrate", (Object)supFinalDetail.getBigDecimal("ltaxrate").multiply(new BigDecimal("100")));
                    reference.set("reference_excepttaxamount", (Object)supFinalDetail.getBigDecimal("lexcepttaxamount"));
                    reference.set("reference_name", (Object)decision.getString("bidproject.name"));
                }
                supplierDecision.clear();
            }
            this.getView().updateView("reference");
        }
    }

    public DynamicObject getDataFromlatestData(Object bidProjectId, Object supplierId, boolean enablemultisection, String sectionName) {
        DynamicObject[] load;
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProjectId);
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(((DynamicObject)supplierId).getPkValue() + "%"));
        if (enablemultisection) {
            supplierFilter.and(new QFilter("clarifysupplier", "like", (Object)("%" + sectionName)));
        }
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"SUBMITTED").or(new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED));
        QFilter clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS).or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI));
        String cacheBidOpenId = this.getPageCache().get(CACHE_BIDOPENID);
        if (cacheBidOpenId != null && !cacheBidOpenId.isEmpty()) {
            clarifyTypeFilter.and(new QFilter("bidopenid", "=", (Object)Long.parseLong(cacheBidOpenId)));
        }
        QFilter resubmisstendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        String orderBys = "submitdate desc";
        boolean top = true;
        StringBuilder supplierDeilSQl = new StringBuilder("bidproject,id,submitdate,billstatus,tenderprice,pricevat,projectmanage,workday,tax,notaxtenderprice,rate,bidsection,sectionname,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate");
        if ("rebm".equals(this.getAppId())) {
            supplierDeilSQl.append(",supplierdetail.resourceitem");
        }
        if ((load = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"questionclarify", ((Object)((Object)this)).getClass()), (String)supplierDeilSQl.toString(), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)Long.parseLong(bidProjectId.toString())), new QFilter("opentype", "!=", (Object)"TECHNICAL"), new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE), supplierFilter, new QFilter("billstatus", "=", (Object)"CLARIFIED"), clarifyTypeFilter}, (String)orderBys, (int)1)).length > 0) {
            DynamicObject latesDate = load[0];
            return latesDate;
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        EntryGrid comparisonInformationEntryGrid = (EntryGrid)this.getView().getControl("comparisoninformation");
        AbstractGrid.GridState comparisonInformationState = comparisonInformationEntryGrid.getEntryState();
        int sectionEntryFocusRow = comparisonInformationState.getFocusRow();
        if (sectionEntryFocusRow == -1) {
            sectionEntryFocusRow = 0;
        }
        DynamicObject listPriceComparsionModel = this.getModel().getDataEntity(true);
        boolean pageEffective = listPriceComparsionModel.getBoolean("pageeffective");
        DynamicObject bidProject = listPriceComparsionModel.getDynamicObject("bidproject");
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidtype");
        int bidType = bidProject.getInt("bidtype");
        if ("startdate".equals(propertyName)) {
            Date oldValue = (Date)changeData.getOldValue();
            Date newValue = (Date)changeData.getNewValue();
            Date endDate = listPriceComparsionModel.getDate("enddate");
            if (newValue != null && endDate != null && newValue.getTime() > endDate.getTime()) {
                this.getModel().setValue("startdate", (Object)oldValue);
                this.getView().showMessage(this.getStartDateErrorInformation());
                return;
            }
            if (!pageEffective) {
                return;
            }
            DynamicObject purDynamicObject = bidType == 1 ? ((DynamicObject)this.getModel().getEntryEntity("comparisoninformation").get(sectionEntryFocusRow)).getDynamicObject("materialid") : ((DynamicObject)this.getModel().getEntryEntity("comparisoninformation").get(sectionEntryFocusRow)).getDynamicObject("resourceitem");
            this.setDecisonInfromation(purDynamicObject, sectionEntryFocusRow);
        } else if ("enddate".equals(propertyName)) {
            Date oldValue = (Date)changeData.getOldValue();
            Date newValue = (Date)changeData.getNewValue();
            Date startDate = listPriceComparsionModel.getDate("startdate");
            if (newValue != null && startDate != null && newValue.getTime() < startDate.getTime()) {
                this.getModel().setValue("enddate", (Object)oldValue);
                this.getView().showMessage(this.getEndDateErrorInformation());
                return;
            }
            if (!pageEffective) {
                return;
            }
            DynamicObject purDynamicObject = bidType == 1 ? ((DynamicObject)this.getModel().getEntryEntity("comparisoninformation").get(sectionEntryFocusRow)).getDynamicObject("materialid") : ((DynamicObject)this.getModel().getEntryEntity("comparisoninformation").get(sectionEntryFocusRow)).getDynamicObject("resourceitem");
            this.setDecisonInfromation(purDynamicObject, sectionEntryFocusRow);
        }
    }

    public String getEndDateErrorInformation() {
        return ResManager.loadKDString((String)"\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"ListPriceComparison_12", (String)"scm-bid-formplugin", (Object[])new Object[0]);
    }

    public String getStartDateErrorInformation() {
        return ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u622a\u6b62\u65f6\u95f4\u3002", (String)"ListPriceComparison_13", (String)"scm-bid-formplugin", (Object[])new Object[0]);
    }

    public void cellClick(CellClickEvent var1) {
        DynamicObject listcomparsion = this.getModel().getDataEntity(true);
        DynamicObject bidProject = listcomparsion.getDynamicObject("bidproject");
        int bidType = (bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidtype")).getInt("bidtype");
        if (bidType == 0) {
            return;
        }
        EntryGrid comparisonInformationEntryGrid = (EntryGrid)this.getView().getControl("comparisoninformation");
        AbstractGrid.GridState comparisonInformationState = comparisonInformationEntryGrid.getEntryState();
        int sectionEntryFocusRow = comparisonInformationState.getFocusRow();
        if (sectionEntryFocusRow == -1) {
            sectionEntryFocusRow = 0;
        }
        DynamicObject purDynamicObject = bidType == 1 ? ((DynamicObject)this.getModel().getEntryEntity("comparisoninformation").get(sectionEntryFocusRow)).getDynamicObject("materialid") : ((DynamicObject)this.getModel().getEntryEntity("comparisoninformation").get(sectionEntryFocusRow)).getDynamicObject("resourceitem");
        this.setDecisonInfromation(purDynamicObject, sectionEntryFocusRow);
    }

    public void cellDoubleClick(CellClickEvent var1) {
    }
}

