/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.mvc.form.FormView;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.common.enums.EvalItemType;
import kd.scm.bid.common.enums.ScoreMode;
import kd.scm.bid.formplugin.bill.OnlineBidEvalAutoScoreUtil;
import kd.scm.bid.formplugin.bill.util.OnlineBidEvalScoreUtil;

public class OnlineBidEvalScoreEdit
extends AbstractFormPlugin {
    private final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();
    protected OnlineBidEvalScoreUtil onlineBidEvalScoreUtil = new OnlineBidEvalScoreUtil();

    protected OnlineBidEvalAutoScoreUtil newOnlineBidEvalAutoScoreUtil() {
        OnlineBidEvalAutoScoreUtil onlineBidEvalAutoScoreUtil = new OnlineBidEvalAutoScoreUtil(this.getView(), this.getModel(), this.getAppId());
        return onlineBidEvalAutoScoreUtil;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Long onlinebidevalId = (Long)formShowParameter.getCustomParam("onlinebidevalId");
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        String scoreMode = (String)formShowParameter.getCustomParam("scoreMode");
        EntryAp onlineBidEvalScoreEntryAp = this.onlineBidEvalScoreUtil.createDynamicOnlineBidEvalScoreAp(onlinebidevalId, sectionId, scoreMode, this.getAppId());
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "onlinebidevalscore");
        mapEntry.put("columns", (String)onlineBidEvalScoreEntryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long onlinebidevalId = (Long)formShowParameter.getCustomParam("onlinebidevalId");
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        String scoreMode = (String)formShowParameter.getCustomParam("scoreMode");
        this.onlineBidEvalScoreUtil.registDynamicProps(newMainType, onlinebidevalId, sectionId, scoreMode);
        e.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject e) {
        FormView formView = (FormView)e.getSource();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Long onlinebidevalId = (Long)formShowParameter.getCustomParam("onlinebidevalId");
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        String scoreMode = (String)formShowParameter.getCustomParam("scoreMode");
        EntryAp dynamicEntryAp = this.onlineBidEvalScoreUtil.createDynamicOnlineBidEvalScoreAp(onlinebidevalId, sectionId, scoreMode, this.getAppId());
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("onlinebidevalscore");
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                Container c = (Container)fieldEdit;
                for (Control control : c.getItems()) {
                    control.setView(this.getView());
                }
                fieldEdit.setView(this.getView());
                entryGrid.getItems().add(c);
                continue;
            }
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key != null && key.startsWith("suppscore_")) {
            DecimalEdit suppScoreDecimalEdit = new DecimalEdit();
            suppScoreDecimalEdit.setKey(key);
            suppScoreDecimalEdit.setEntryKey("onlinebidevalscore");
            suppScoreDecimalEdit.setView(this.getView());
            e.setControl((Control)suppScoreDecimalEdit);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.insertOnlineBidEvalScoreRow();
        this.setTotalRowColor();
    }

    private void insertOnlineBidEvalScoreRow() {
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        Long onlinebidevalId = (Long)formShowParameter.getCustomParam("onlinebidevalId");
        String scoreMode = (String)formShowParameter.getCustomParam("scoreMode");
        String cacheOnlineBidEvalScoreCollStr = (String)formShowParameter.getCustomParam("cacheData");
        String evalType = (String)formShowParameter.getCustomParam("evaltype");
        String falseVisableField = (String)formShowParameter.getCustomParam("falseVisableField");
        if (StringUtils.isNotEmpty((CharSequence)cacheOnlineBidEvalScoreCollStr)) {
            this.insertScoreDetailByCache(cacheOnlineBidEvalScoreCollStr, sectionId, scoreMode, evalType);
            if (falseVisableField != null) {
                String[] split;
                for (String splitOne : split = falseVisableField.split("###")) {
                    try {
                        this.getView().setVisible(Boolean.FALSE, new String[]{splitOne});
                    }
                    catch (Exception e) {
                        this.LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                this.getPageCache().put("falseVisableField", falseVisableField);
            }
        } else {
            this.insertScoreDetailByDataBase(onlinebidevalId, sectionId, scoreMode, evalType);
            this.replayCalcTotalScore();
        }
    }

    private void setTotalRowColor() {
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        Map<String, Integer> totalRowIndexMap = this.onlineBidEvalScoreUtil.getTotalRowIndex(sectionId, this.getAppId());
        int technicalTotalScoreIndex = totalRowIndexMap.get("technicalscore");
        int commercialTotalScoreIndex = totalRowIndexMap.get("commercialscore");
        int scoreIndex = totalRowIndexMap.get("totalscore");
        EntryGrid grid = (EntryGrid)this.getView().getControl("onlinebidevalscore");
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        if (technicalTotalScoreIndex > 0) {
            rowIndexList.add(technicalTotalScoreIndex);
        }
        if (commercialTotalScoreIndex > 0) {
            rowIndexList.add(commercialTotalScoreIndex);
        }
        if (scoreIndex > 0) {
            grid.setRowBackcolor("#FFFCF0", new int[]{scoreIndex});
        }
        int[] rowIndexes = new int[rowIndexList.size()];
        for (int i = 0; i < rowIndexList.size(); ++i) {
            int index;
            rowIndexes[i] = index = ((Integer)rowIndexList.get(i)).intValue();
        }
        grid.setRowBackcolor("#ffffdd", rowIndexes);
    }

    private void insertScoreDetailByCache(String cacheOnlineBidEvalScoreCollStr, Long sectionId, String scoreMode, String evalType) {
        List onlineBidEvalScoreList = (List)SerializationUtils.fromJsonString((String)cacheOnlineBidEvalScoreCollStr, Object.class);
        if (onlineBidEvalScoreList != null) {
            String falseVisableField;
            IDataModel dataModel = this.getModel();
            IFormView formView = this.getView();
            FormShowParameter formShowParameter = formView.getFormShowParameter();
            Long onlinebidevalId = (Long)formShowParameter.getCustomParam("onlinebidevalId");
            List<String> columnKeys = this.onlineBidEvalScoreUtil.getOnlineBidEvalScoreColumnKeysIncludeOld(onlinebidevalId, sectionId, scoreMode, this.getAppId());
            for (int i = 0; i < onlineBidEvalScoreList.size(); ++i) {
                LinkedHashMap rowData = (LinkedHashMap)onlineBidEvalScoreList.get(i);
                int newEntryRow = dataModel.createNewEntryRow("onlinebidevalscore");
                for (int j = 0; j < columnKeys.size(); ++j) {
                    String key = columnKeys.get(j);
                    try {
                        dataModel.setValue(key, rowData.get(key), newEntryRow);
                        continue;
                    }
                    catch (Exception e) {
                        this.LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            OnlineBidEvalAutoScoreUtil onlineBidEvalAutoScoreUtil = this.newOnlineBidEvalAutoScoreUtil();
            List<String> autoScoreItemList = onlineBidEvalAutoScoreUtil.autoCalScore();
            Map<String, Integer> totalRowIndexMap = this.onlineBidEvalScoreUtil.getTotalRowIndex(sectionId, this.getAppId());
            int technicalTotalScoreIndex = totalRowIndexMap.get("technicalscore");
            int commercialTotalScoreIndex = totalRowIndexMap.get("commercialscore");
            int scoreIndex = totalRowIndexMap.get("totalscore");
            if (technicalTotalScoreIndex > 0) {
                this.lockTotalRowColumn(technicalTotalScoreIndex, columnKeys);
            }
            if (commercialTotalScoreIndex > 0) {
                this.lockTotalRowColumn(commercialTotalScoreIndex, columnKeys);
            }
            if (scoreIndex > 0) {
                this.lockTotalRowColumn(scoreIndex, columnKeys);
            }
            if ((falseVisableField = this.getView().getParentView().getPageCache().get("falseVisableField" + sectionId)) != null && !falseVisableField.isEmpty()) {
                String[] split = falseVisableField.split("###");
                this.getView().setVisible(Boolean.FALSE, split);
            }
            this.calcTotalRows(dataModel, autoScoreItemList);
            onlineBidEvalAutoScoreUtil.lockAutoCalScoreRowColumn(autoScoreItemList, columnKeys);
        }
    }

    private void insertScoreDetailByDataBase(Long onlinebidevalId, Long sectionId, String scoreMode, String evalType) {
        IDataModel dataModel = this.getModel();
        Map<Long, LinkedHashMap<String, Object>> rowMap = this.onlineBidEvalScoreUtil.getScoreDetailByDataBase(onlinebidevalId, sectionId, scoreMode, evalType, this.getAppId());
        HashMap<String, Object> scoreMap = new HashMap<String, Object>();
        HashMap<Boolean, List> visableListMap = new HashMap<Boolean, List>();
        for (Map.Entry<Long, LinkedHashMap<String, Object>> rowMapEntry : rowMap.entrySet()) {
            HashMap rowDataMap = rowMapEntry.getValue();
            int newEntryRow = dataModel.createNewEntryRow("onlinebidevalscore");
            for (Map.Entry rowDataEntry : rowDataMap.entrySet()) {
                Object rowData;
                block18: {
                    String rowDataKey = (String)rowDataEntry.getKey();
                    rowData = rowDataEntry.getValue();
                    if (rowData instanceof Boolean) {
                        boolean visable = (Boolean)rowData;
                        try {
                            String[] split = rowDataKey.split("_hide");
                            String fieldName = split[0];
                            List list = (List)visableListMap.get(visable);
                            if (list == null) {
                                ArrayList<String> newList = new ArrayList<String>();
                                newList.add(fieldName);
                                visableListMap.put(visable, newList);
                                break block18;
                            }
                            if (!list.contains(fieldName)) {
                                list.add(fieldName);
                            }
                            visableListMap.put(visable, list);
                        }
                        catch (Exception e) {
                            this.LOG.error(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        dataModel.setValue(rowDataKey, rowData, newEntryRow);
                    }
                }
                if ((rowData == null || !rowData.toString().equals(EvalItemType.TECHNICAL.getAlias())) && (rowData == null || !rowData.toString().equals(EvalItemType.COMMERCIAL.getAlias()))) continue;
                BigDecimal score = BigDecimal.ZERO;
                if (rowDataMap.containsKey("score")) {
                    score = new BigDecimal(rowDataMap.get("score").toString());
                    scoreMap.put("scoremode", ScoreMode.STANDARD.getVal());
                } else if (rowDataMap.containsKey("weight")) {
                    score = new BigDecimal(rowDataMap.get("weight").toString());
                    scoreMap.put("scoremode", ScoreMode.WEIGHT.getVal());
                }
                String type = rowDataMap.get("type").toString();
                Object valueType = scoreMap.get(type);
                if (valueType != null) {
                    scoreMap.put(type, score.add(new BigDecimal(valueType.toString())));
                    continue;
                }
                scoreMap.put(type, score);
            }
        }
        OnlineBidEvalAutoScoreUtil onlineBidEvalAutoScoreUtil = this.newOnlineBidEvalAutoScoreUtil();
        List<String> autoScoreItemList = onlineBidEvalAutoScoreUtil.autoCalScore();
        if (rowMap.size() > 0) {
            Map<String, LinkedHashMap<String, Object>> totalRowMap = this.onlineBidEvalScoreUtil.getSupplierTotalScoreByDataBase(onlinebidevalId, sectionId, this.getAppId());
            List<String> supplierColumnKeyList = this.onlineBidEvalScoreUtil.getOnlineBidEvalSupplierColumnKeysIncludeOld(onlinebidevalId, sectionId, this.getAppId());
            this.insertSupplierTypeScoreByDataBase(sectionId, totalRowMap, supplierColumnKeyList, scoreMap);
            this.insertSupplierTotalScoreByDataBase(sectionId, totalRowMap, supplierColumnKeyList);
            this.calcTotalRows(dataModel, autoScoreItemList);
            onlineBidEvalAutoScoreUtil.lockAutoCalScoreRowColumn(autoScoreItemList, supplierColumnKeyList);
        }
        Boolean key = Boolean.FALSE;
        List value = null;
        StringBuilder valueStrSb = new StringBuilder();
        for (Map.Entry entry : visableListMap.entrySet()) {
            key = (Boolean)entry.getKey();
            value = (List)entry.getValue();
            if (value == null) continue;
            try {
                this.getView().setVisible(key, value.toArray(new String[value.size()]));
            }
            catch (Exception e) {
                this.LOG.error(e.getMessage(), (Throwable)e);
            }
            if (key.booleanValue()) continue;
            for (int i = 0; i < value.size(); ++i) {
                if (i == value.size() - 1) {
                    valueStrSb.append((String)value.get(i));
                    continue;
                }
                String valueStr = (String)value.get(i) + "###";
                valueStrSb.append(valueStr);
            }
            this.getPageCache().put("falseVisableField", valueStrSb.toString());
        }
    }

    protected void calcTotalRows(IDataModel dataModel, List<String> autoScoreItemList) {
        if (autoScoreItemList == null || autoScoreItemList.size() == 0) {
            return;
        }
        ArrayList<String> totalRowTypeList = new ArrayList<String>();
        totalRowTypeList.add(ResManager.loadKDString((String)"\u6280\u672f\u90e8\u5206\u5408\u8ba1", (String)"OnlineBidEvalScoreEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        totalRowTypeList.add(ResManager.loadKDString((String)"\u5546\u52a1\u90e8\u5206\u5408\u8ba1", (String)"OnlineBidEvalScoreEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        totalRowTypeList.add(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"OnlineBidEvalScoreEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        DynamicObjectCollection onlinebidevalscoreEntries = dataModel.getEntryEntity("onlinebidevalscore");
        if (onlinebidevalscoreEntries == null || onlinebidevalscoreEntries.size() == 0) {
            return;
        }
        EntryType entryEntityType = (EntryType)((DynamicObject)onlinebidevalscoreEntries.get(0)).getDynamicObjectType();
        Map entryFields = entryEntityType.getFields();
        for (int i = 0; i < onlinebidevalscoreEntries.size(); ++i) {
            String item;
            DynamicObject onlinebidevalscore = (DynamicObject)onlinebidevalscoreEntries.get(i);
            String type = onlinebidevalscore.getString("type");
            if (totalRowTypeList.contains(type) || !autoScoreItemList.contains(item = onlinebidevalscore.getString("item"))) continue;
            this.calcTotalRow(i, onlinebidevalscoreEntries);
        }
    }

    private void insertSupplierTypeScoreByDataBase(Long sectionId, Map<String, LinkedHashMap<String, Object>> totalRowMap, List<String> supplierColumnKeyList, Map scoreMap) {
        IDataModel dataModel = this.getModel();
        int technicalItemCount = this.onlineBidEvalService.getTypeItemCount(sectionId, EvalItemType.TECHNICAL.getVal());
        boolean isTechFirst = true;
        String scoreDetailSelectFields = "id,entryseq,score,type,evalItem.id,supplier.id,supplier.number";
        DynamicObjectCollection onlineScoreDetailColl = this.onlineBidEvalService.listOnlineScoreDetailBySections(sectionId, scoreDetailSelectFields, this.getAppId());
        if (onlineScoreDetailColl != null && onlineScoreDetailColl.size() > 0) {
            DynamicObject onlineScoreDetail = (DynamicObject)onlineScoreDetailColl.get(0);
            String type = onlineScoreDetail.getString("type");
            if (EvalItemType.TECHNICAL.getVal().equals(type)) {
                isTechFirst = true;
            } else if (EvalItemType.COMMERCIAL.getVal().equals(type)) {
                isTechFirst = false;
            }
        }
        if (isTechFirst) {
            int commercialItemCount;
            if (technicalItemCount > 0) {
                int newEntryRow = dataModel.insertEntryRow("onlinebidevalscore", technicalItemCount);
                dataModel.setValue("type", (Object)ResManager.loadKDString((String)"\u6280\u672f\u90e8\u5206\u5408\u8ba1", (String)"OnlineBidEvalScoreEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), newEntryRow);
                if (scoreMap != null) {
                    if (scoreMap.get("scoremode").equals(ScoreMode.STANDARD.getVal())) {
                        dataModel.setValue("score", scoreMap.get(EvalItemType.TECHNICAL.getAlias()), newEntryRow);
                    } else {
                        dataModel.setValue("weight", scoreMap.get(EvalItemType.TECHNICAL.getAlias()), newEntryRow);
                    }
                }
                LinkedHashMap<String, Object> technicalScoreRow = totalRowMap.get("technicalscore");
                for (Map.Entry<String, Object> rowDataIterator : technicalScoreRow.entrySet()) {
                    String rowDataKey = rowDataIterator.getKey();
                    Object rowData = rowDataIterator.getValue();
                    try {
                        dataModel.setValue(rowDataKey, rowData, newEntryRow);
                    }
                    catch (Exception e) {
                        this.LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                this.lockTotalRowColumn(newEntryRow, supplierColumnKeyList);
            }
            if ((commercialItemCount = this.onlineBidEvalService.getTypeItemCount(sectionId, EvalItemType.COMMERCIAL.getVal())) > 0) {
                int newEntryRow = dataModel.createNewEntryRow("onlinebidevalscore");
                dataModel.setValue("type", (Object)ResManager.loadKDString((String)"\u5546\u52a1\u90e8\u5206\u5408\u8ba1", (String)"OnlineBidEvalScoreEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), newEntryRow);
                if (scoreMap != null) {
                    if (scoreMap.get("scoremode").equals(ScoreMode.STANDARD.getVal())) {
                        dataModel.setValue("score", scoreMap.get(EvalItemType.COMMERCIAL.getAlias()), newEntryRow);
                    } else {
                        dataModel.setValue("weight", scoreMap.get(EvalItemType.COMMERCIAL.getAlias()), newEntryRow);
                    }
                }
                LinkedHashMap<String, Object> commercialScoreRow = totalRowMap.get("commercialscore");
                for (Map.Entry<String, Object> commercialScoreEntry : commercialScoreRow.entrySet()) {
                    String rowDataKey = commercialScoreEntry.getKey();
                    Object rowData = commercialScoreEntry.getValue();
                    try {
                        dataModel.setValue(rowDataKey, rowData, newEntryRow);
                    }
                    catch (Exception e) {
                        this.LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                this.lockTotalRowColumn(newEntryRow, supplierColumnKeyList);
            }
        } else {
            Object rowData;
            String rowDataKey;
            int commercialItemCount = this.onlineBidEvalService.getTypeItemCount(sectionId, EvalItemType.COMMERCIAL.getVal());
            if (commercialItemCount > 0) {
                int newEntryRow = dataModel.insertEntryRow("onlinebidevalscore", commercialItemCount);
                dataModel.setValue("type", (Object)ResManager.loadKDString((String)"\u5546\u52a1\u90e8\u5206\u5408\u8ba1", (String)"OnlineBidEvalScoreEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), newEntryRow);
                if (scoreMap != null) {
                    if (scoreMap.get("scoremode").equals(ScoreMode.STANDARD.getVal())) {
                        dataModel.setValue("score", scoreMap.get(EvalItemType.COMMERCIAL.getAlias()), newEntryRow);
                    } else {
                        dataModel.setValue("weight", scoreMap.get(EvalItemType.COMMERCIAL.getAlias()), newEntryRow);
                    }
                }
                LinkedHashMap<String, Object> commercialScoreRow = totalRowMap.get("commercialscore");
                for (Map.Entry<String, Object> commercialScoreEntry : commercialScoreRow.entrySet()) {
                    rowDataKey = commercialScoreEntry.getKey();
                    rowData = commercialScoreEntry.getValue();
                    try {
                        dataModel.setValue(rowDataKey, rowData, newEntryRow);
                    }
                    catch (Exception e) {
                        this.LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                this.lockTotalRowColumn(newEntryRow, supplierColumnKeyList);
            }
            if (technicalItemCount > 0) {
                int newEntryRow = dataModel.createNewEntryRow("onlinebidevalscore");
                dataModel.setValue("type", (Object)ResManager.loadKDString((String)"\u6280\u672f\u90e8\u5206\u5408\u8ba1", (String)"OnlineBidEvalScoreEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), newEntryRow);
                if (scoreMap != null) {
                    if (scoreMap.get("scoremode").equals(ScoreMode.STANDARD.getVal())) {
                        dataModel.setValue("score", scoreMap.get(EvalItemType.TECHNICAL.getAlias()), newEntryRow);
                    } else {
                        dataModel.setValue("weight", scoreMap.get(EvalItemType.TECHNICAL.getAlias()), newEntryRow);
                    }
                }
                LinkedHashMap<String, Object> technicalScoreRow = totalRowMap.get("technicalscore");
                for (Map.Entry<String, Object> entry : technicalScoreRow.entrySet()) {
                    rowDataKey = entry.getKey();
                    rowData = entry.getValue();
                    try {
                        dataModel.setValue(rowDataKey, rowData, newEntryRow);
                    }
                    catch (Exception e) {
                        this.LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                this.lockTotalRowColumn(newEntryRow, supplierColumnKeyList);
            }
        }
    }

    private void insertSupplierTotalScoreByDataBase(Long sectionId, Map<String, LinkedHashMap<String, Object>> totalRowMap, List<String> supplierColumnKeyList) {
        IDataModel dataModel = this.getModel();
        int newEntryRow = dataModel.createNewEntryRow("onlinebidevalscore");
        dataModel.setValue("type", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"OnlineBidEvalScoreEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), newEntryRow);
        LinkedHashMap<String, Object> scoreRow = totalRowMap.get("totalscore");
        for (Map.Entry<String, Object> rowDataIterator : scoreRow.entrySet()) {
            String rowDataKey = rowDataIterator.getKey();
            Object rowData = rowDataIterator.getValue();
            try {
                dataModel.setValue(rowDataKey, rowData, newEntryRow);
            }
            catch (Exception e) {
                this.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        this.lockTotalRowColumn(newEntryRow, supplierColumnKeyList);
    }

    private void lockTotalRowColumn(int totalRowIndex, List<String> lockKeyList) {
        for (String lockKey : lockKeyList) {
            try {
                this.getView().setEnable(Boolean.FALSE, totalRowIndex, new String[]{lockKey});
            }
            catch (Exception e) {
                this.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        ChangeData data = changeData[0];
        int rowIndex = data.getRowIndex();
        String propName = e.getProperty().getName();
        if (propName.startsWith("suppscore_")) {
            boolean flag = this.validateScore(rowIndex, data);
            if (!flag) {
                this.getModel().setValue(propertyName, data.getOldValue(), rowIndex);
                return;
            }
            DynamicObjectCollection onlineBidEvalScoreColl = this.getModel().getEntryEntity("onlinebidevalscore");
            this.calcTotalRow(rowIndex, onlineBidEvalScoreColl);
        }
    }

    public void replayCalcTotalScore() {
        DynamicObjectCollection onlineBidEvalScoreColl = this.getModel().getEntryEntity("onlinebidevalscore");
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        Long onlinebidevalId = (Long)formShowParameter.getCustomParam("onlinebidevalId");
        String scoreMode = (String)formShowParameter.getCustomParam("scoreMode");
        Map<String, Integer> totalRowIndexMap = this.onlineBidEvalScoreUtil.getTotalRowIndex(sectionId, this.getAppId());
        int technicalTotalScoreIndex = totalRowIndexMap.get("technicalscore");
        int commercialTotalScoreIndex = totalRowIndexMap.get("commercialscore");
        int scoreIndex = totalRowIndexMap.get("totalscore");
        Map<Long, HashMap<String, Object>> supplierMap = this.onlineBidEvalScoreUtil.sumSupplierSorce(onlinebidevalId, sectionId, scoreMode, onlineBidEvalScoreColl, this.getAppId());
        if (supplierMap != null) {
            for (Map.Entry<Long, HashMap<String, Object>> iteratorData : supplierMap.entrySet()) {
                HashMap<String, Object> supplier = iteratorData.getValue();
                BigDecimal sumTechnicalSorce = (BigDecimal)supplier.get("sumTechnicalSorce");
                BigDecimal sumCommercialSorce = (BigDecimal)supplier.get("sumCommercialSorce");
                String columnKey = (String)supplier.get("columnKey");
                if (technicalTotalScoreIndex > 0) {
                    sumTechnicalSorce = sumTechnicalSorce.setScale(2, 4);
                    dataModel.setValue(columnKey, (Object)sumTechnicalSorce, technicalTotalScoreIndex);
                }
                if (commercialTotalScoreIndex > 0) {
                    sumCommercialSorce = sumCommercialSorce.setScale(2, 4);
                    dataModel.setValue(columnKey, (Object)sumCommercialSorce, commercialTotalScoreIndex);
                }
                if (scoreIndex <= 0) continue;
                BigDecimal totalSorce = sumTechnicalSorce.add(sumCommercialSorce);
                totalSorce = totalSorce.setScale(2, 4);
                dataModel.setValue(columnKey, (Object)totalSorce, scoreIndex);
            }
        }
    }

    private boolean validateScore(int rowIndex, ChangeData data) {
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        String scoreMode = (String)formShowParameter.getCustomParam("scoreMode");
        Map<String, Integer> totalRowIndexMap = this.onlineBidEvalScoreUtil.getTotalRowIndex(sectionId, this.getAppId());
        int technicalTotalScoreIndex = totalRowIndexMap.get("technicalscore");
        int commercialTotalScoreIndex = totalRowIndexMap.get("commercialscore");
        int scoreIndex = totalRowIndexMap.get("totalscore");
        if (technicalTotalScoreIndex > 0 && rowIndex == technicalTotalScoreIndex || commercialTotalScoreIndex > 0 && rowIndex == commercialTotalScoreIndex || rowIndex == scoreIndex) {
            return true;
        }
        if (ScoreMode.STANDARD.getVal().equals(scoreMode)) {
            DynamicObject onlineBidEvalScoreRow = this.getModel().getEntryRowEntity("onlinebidevalscore", rowIndex);
            BigDecimal score = onlineBidEvalScoreRow.getBigDecimal("score");
            BigDecimal newScore = (BigDecimal)data.getNewValue();
            BigDecimal oldScore = (BigDecimal)data.getOldValue();
            if (oldScore.compareTo(score) > 0) {
                return true;
            }
            if (newScore.compareTo(score) > 0) {
                return false;
            }
        }
        return true;
    }

    private void calcTotalRow(int rowIndex, DynamicObjectCollection onlineBidEvalScoreColl) {
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Long sectionId = (Long)formShowParameter.getCustomParam("sectionId");
        Long onlinebidevalId = (Long)formShowParameter.getCustomParam("onlinebidevalId");
        String scoreMode = (String)formShowParameter.getCustomParam("scoreMode");
        Map<String, Integer> totalRowIndexMap = this.onlineBidEvalScoreUtil.getTotalRowIndex(sectionId, this.getAppId());
        int technicalTotalScoreIndex = totalRowIndexMap.get("technicalscore");
        int commercialTotalScoreIndex = totalRowIndexMap.get("commercialscore");
        int scoreIndex = totalRowIndexMap.get("totalscore");
        if (technicalTotalScoreIndex > 0 && rowIndex == technicalTotalScoreIndex || commercialTotalScoreIndex > 0 && rowIndex == commercialTotalScoreIndex || rowIndex == scoreIndex) {
            return;
        }
        Map<Long, HashMap<String, Object>> supplierMap = this.onlineBidEvalScoreUtil.sumSupplierSorce(onlinebidevalId, sectionId, scoreMode, onlineBidEvalScoreColl, this.getAppId());
        if (supplierMap != null) {
            for (Map.Entry<Long, HashMap<String, Object>> iteratorData : supplierMap.entrySet()) {
                HashMap<String, Object> supplier = iteratorData.getValue();
                BigDecimal sumTechnicalSorce = (BigDecimal)supplier.get("sumTechnicalSorce");
                BigDecimal sumCommercialSorce = (BigDecimal)supplier.get("sumCommercialSorce");
                String columnKey = (String)supplier.get("columnKey");
                if (technicalTotalScoreIndex > 0) {
                    sumTechnicalSorce = sumTechnicalSorce.setScale(2, 4);
                    dataModel.setValue(columnKey, (Object)sumTechnicalSorce, technicalTotalScoreIndex);
                }
                if (commercialTotalScoreIndex > 0) {
                    sumCommercialSorce = sumCommercialSorce.setScale(2, 4);
                    dataModel.setValue(columnKey, (Object)sumCommercialSorce, commercialTotalScoreIndex);
                }
                if (scoreIndex <= 0) continue;
                BigDecimal totalSorce = sumTechnicalSorce.add(sumCommercialSorce);
                totalSorce = totalSorce.setScale(2, 4);
                dataModel.setValue(columnKey, (Object)totalSorce, scoreIndex);
            }
        }
    }

    private String getAppId() {
        String appName = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
        return appName;
    }
}

