/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PartnerUserUpdate
extends AbstractBillPlugIn
implements AfterF7SelectListener,
RowClickEventListener {
    public static final String PAR_BID_SECTION = "bidrollsection";
    public static final String SUPPLIER_ENTRY = "supplierentry";
    public static final String SECTION_ENTRY_ENTITY = "rollsectionname";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.registerF7Listener("suppliername");
        this.registerF7Listener("supplier");
        EntryGrid fakeSectionGrid = (EntryGrid)this.getView().getControl(PAR_BID_SECTION);
        fakeSectionGrid.addRowClickListener((RowClickEventListener)this);
    }

    private void registerF7Listener(String f7Name) {
        Control control = this.getView().getControl(f7Name);
        if (control != null && BasedataEdit.class.isInstance(control)) {
            ((BasedataEdit)control).addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void entryRowClick(RowClickEvent rowclickevent) {
        EntryGrid entryGrid = (EntryGrid)rowclickevent.getSource();
        String key = entryGrid.getKey();
        if (!PAR_BID_SECTION.equals(key)) {
            return;
        }
        int rowIndex = rowclickevent.getRow();
        if (rowIndex <= -1) {
            return;
        }
        boolean enablemultisection = this.getView().getModel().getDataEntity(true).getBoolean("enablemultisection");
        if (!enablemultisection) {
            return;
        }
        HashMap<String, DynamicObject> supplierUser = new HashMap<String, DynamicObject>();
        String appId = this.getModel().getDataEntityType().getAppId();
        String supplierFlag = "";
        supplierFlag = StringUtils.equals((CharSequence)"rebm", (CharSequence)appId) ? "suppliername" : "supplier";
        DynamicObjectCollection sections = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION);
        for (DynamicObject section : sections) {
            DynamicObjectCollection supplierCollection = section.getDynamicObjectCollection(SUPPLIER_ENTRY);
            for (DynamicObject row : supplierCollection) {
                if (row.getDynamicObject(supplierFlag) == null) continue;
                String supplierPk = row.getDynamicObject(supplierFlag).getPkValue().toString();
                String cachePk = this.getPageCache().get(supplierPk);
                if (StringUtils.isBlank((CharSequence)cachePk)) continue;
                if (!supplierUser.containsKey(supplierPk)) {
                    if (cachePk.equals("0")) {
                        supplierUser.put(supplierPk, null);
                    } else {
                        DynamicObject bosUser = BusinessDataServiceHelper.loadSingle((Object)cachePk, (String)"bos_user");
                        supplierUser.put(supplierPk, bosUser);
                    }
                }
                DynamicObject modify = (DynamicObject)supplierUser.get(supplierPk);
                this.updateRow(row, modify);
            }
        }
        this.getView().updateView(SUPPLIER_ENTRY);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String field = e.getProperty().getName();
        if (field.equals("projectpartner")) {
            boolean enablemultisection = this.getView().getModel().getDataEntity(true).getBoolean("enablemultisection");
            if (!enablemultisection) {
                return;
            }
            String appId = this.getModel().getDataEntityType().getAppId();
            String supplierFlag = "";
            supplierFlag = StringUtils.equals((CharSequence)"rebm", (CharSequence)appId) ? "suppliername" : "supplier";
            DynamicObjectCollection supplierEntryColl = this.getModel().getEntryEntity(SUPPLIER_ENTRY);
            if (supplierEntryColl == null || supplierEntryColl.isEmpty()) {
                return;
            }
            DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(e.getChangeSet()[0].getRowIndex());
            DynamicObject supplier = supplierEntry.getDynamicObject(supplierFlag);
            if (supplier == null) {
                return;
            }
            String supplierId = supplier.getPkValue().toString();
            DynamicObject projectpartner = supplierEntry.getDynamicObject("projectpartner");
            if (projectpartner == null) {
                this.getPageCache().put(supplierId, "0");
            } else {
                this.getPageCache().put(supplierId, projectpartner.getPkValue().toString());
            }
        }
    }

    public void updateRow(DynamicObject row, DynamicObject newUser) {
        DynamicObject projectpartner = row.getDynamicObject("projectpartner");
        if (projectpartner == null && newUser == null) {
            return;
        }
        if (projectpartner == null && newUser != null) {
            row.set("projectpartner", (Object)newUser);
            row.set("suppliercontact", (Object)new LocaleString(newUser.getString("name")));
            row.set("contactphone", (Object)newUser.getString("phone"));
            row.set("email", (Object)newUser.getString("email"));
            return;
        }
        if (projectpartner != null && newUser == null) {
            row.set("projectpartner", (Object)newUser);
            return;
        }
        if (projectpartner != null && newUser != null && projectpartner.getPkValue().toString().equals(newUser.getPkValue().toString())) {
            return;
        }
        row.set("projectpartner", (Object)newUser);
        row.set("suppliercontact", (Object)new LocaleString(newUser.getString("name")));
        row.set("contactphone", (Object)newUser.getString("phone"));
        row.set("email", (Object)newUser.getString("email"));
    }

    public String getAppId() {
        return this.getModel().getDataEntityType().getAppId();
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        BasedataEdit source = (BasedataEdit)afterF7SelectEvent.getSource();
        String fieldKey = source.getFieldKey();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"projectpartner")) {
            // empty if block
        }
    }
}

