/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.ISupplierStatisticService;
import kd.scm.bid.business.basedata.serviceImpl.SupplierStatisticServiceImpl;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.BidBillEdit;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.scm.bid.formplugin.bill.util.PartnerUserDealHelper;
import kd.scm.bid.formplugin.bill.util.SupplierInvitationUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class SupplierInvitationEdit
extends BidBillEdit
implements BeforeF7SelectListener,
AfterF7SelectListener,
CellClickListener {
    protected ISupplierInvitationService service = new SupplierInvitationServiceImpl();
    private static final String needDeleteInvitationSupplierIds = "needDeleteInvitationSupplierIds";
    private static final IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    private static final String SUPPLIER_ENTRY_F7 = "projectpartner";
    private static final String SUPPLIER_ENROLL_F7 = "baoprojectpartner";
    private ISupplierStatisticService suppStatService = new SupplierStatisticServiceImpl();
    private PartnerUserDealHelper helper = new PartnerUserDealHelper();

    public void beforeBindData(EventObject e) {
        Long sourceBillId;
        DynamicObject bidMode;
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        if (bidProject != null && (bidMode = bidProject.getDynamicObject("bidmode")) != null) {
            if (BidModeHelper.isPublicBiddingByModel(bidMode)) {
                DynamicObjectCollection sectionColl = dataEntity.getDynamicObjectCollection("bidsection");
                for (int i = 0; i < sectionColl.size(); ++i) {
                    DynamicObjectCollection entry = ((DynamicObject)sectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                    for (int j = 0; j < entry.size(); ++j) {
                        this.getView().setEnable(Boolean.FALSE, j, new String[]{"isrecommend"});
                    }
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"extractsupplier"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"extracthistory"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"extractsupplier"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"extracthistory"});
            }
        }
        Long customSourceBillId = (Long)this.getView().getFormShowParameter().getCustomParam("sourcebillid");
        Long viewSourceBillId = dataEntity.getLong("sourcebillid");
        Long l = sourceBillId = customSourceBillId == null ? viewSourceBillId : customSourceBillId;
        if (sourceBillId != null && sourceBillId.intValue() != 0) {
            boolean flag = true;
            String isAgainInvitation = this.getPageCache().get("isAgainInvitation");
            if (!StringUtils.isEmpty((CharSequence)isAgainInvitation) && "1".equals(isAgainInvitation)) {
                flag = false;
            }
            if (customSourceBillId != null && flag) {
                this.getPageCache().put("isAgainInvitation", "1");
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "addinvitation", "baritemap1", "baritemap"});
                this.againSupplierInvitationData(customSourceBillId);
                this.againSupplierApplyuser(customSourceBillId);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"invalidflag"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tenderstatus"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invalidflag"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tenderstatus"});
        }
    }

    public void againSupplierApplyuser(Long sourceBillId) {
        DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"bid_supplierinvitation");
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection newDidenrollsection = dataEntity.getDynamicObjectCollection("bidenrollsection");
        DynamicObjectCollection oldDidenrollsection = supplierInvitation.getDynamicObjectCollection("bidenrollsection");
        if (oldDidenrollsection == null || oldDidenrollsection.size() <= 0) {
            return;
        }
        for (int index = 0; index < oldDidenrollsection.size(); ++index) {
            DynamicObject newBidSection = (DynamicObject)newDidenrollsection.get(index);
            DynamicObject oldBidSection = (DynamicObject)oldDidenrollsection.get(index);
            DynamicObjectCollection newEntry = newBidSection.getDynamicObjectCollection("supplierenrollentry");
            DynamicObjectCollection oldEntry = oldBidSection.getDynamicObjectCollection("supplierenrollentry");
            for (int entryIndex = 0; entryIndex < oldEntry.size(); ++entryIndex) {
                DynamicObject oldRow = (DynamicObject)oldEntry.get(entryIndex);
                DynamicObject applyuser = oldRow.getDynamicObject("applyuser");
                if (applyuser == null) continue;
                ((DynamicObject)newEntry.get(entryIndex)).set("applyuser", (Object)applyuser);
            }
        }
        this.getView().updateView("bidenrollsection");
        this.getView().updateView("supplierenrollentry");
    }

    public void againSupplierInvitationData(Long sourceBillId) {
        DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"bid_supplierinvitation");
        if (supplierInvitation != null) {
            DynamicObjectCollection currentInvitationSection;
            DynamicObjectCollection publishSections;
            this.getModel().setValue("sourcebillid", (Object)sourceBillId);
            DynamicObject bidProject = supplierInvitation.getDynamicObject(this.BID_PROJECT);
            String currentStep = SupplierInvitationUtil.getSupplierInvitationBidStep(supplierInvitation);
            this.getModel().setValue("bidstep", (Object)currentStep);
            this.getModel().setValue("rounds", (Object)0);
            this.getModel().setValue("sourcebillstatus", (Object)supplierInvitation.getString("billstatus"));
            this.getModel().setValue("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            this.getModel().setValue("sortfield", (Object)(bidProject.getString("id") + new Date().getTime()));
            String appId = this.getModel().getDataEntityType().getAppId();
            String selectSectionString = "bidmode,bidsection,bidsection.seq,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.suppliercomment,supplierentry.supplierstatistic,supplierentry.invitationstatus,supplierentry.isnew";
            String selectOpenSectionString = "bidmode,bidsection,bidsection.seq,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.supplier_isinvalid";
            DynamicObject[] bidOpenDatas = null;
            DynamicObject bidPublishData = null;
            DynamicObject bidInvData = null;
            if ("bid".equals(appId)) {
                bidOpenDatas = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)selectOpenSectionString, (QFilter[])new QFilter[]{new QFilter(this.BID_PROJECT, "=", bidProject.getPkValue()), new QFilter("rounds", "=", (Object)0)});
                bidPublishData = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)selectSectionString, (QFilter[])new QFilter[]{new QFilter(this.BID_PROJECT, "=", bidProject.getPkValue()), new QFilter("isnewbill", "=", (Object)Boolean.TRUE)});
                bidInvData = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"bid_supplierinvitation");
            } else {
                bidOpenDatas = BusinessDataServiceHelper.load((String)"rebm_bidopen", (String)selectOpenSectionString, (QFilter[])new QFilter[]{new QFilter(this.BID_PROJECT, "=", bidProject.getPkValue()), new QFilter("rounds", "=", (Object)0)});
                bidPublishData = BusinessDataServiceHelper.loadSingle((String)"rebm_bidpublish", (String)selectSectionString, (QFilter[])new QFilter[]{new QFilter(this.BID_PROJECT, "=", bidProject.getPkValue()), new QFilter("isnewbill", "=", (Object)Boolean.TRUE)});
                bidInvData = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"rebm_supplierinvitation");
            }
            String selectFields = "bidproject, supplier, entry,entry.sectionname, entry.projectsection, entry.sectionstatus, ispublicbid, tenderstatus";
            DynamicObject[] myTenderArr = null;
            if ("bid".equals(appId)) {
                myTenderArr = BusinessDataServiceHelper.load((String)"ten_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue())});
            } else if ("rebm".equals(appId)) {
                myTenderArr = BusinessDataServiceHelper.load((String)"resp_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue())});
            }
            ArrayList<DynamicObject> targetMyTenderArr = new ArrayList<DynamicObject>();
            if (myTenderArr != null) {
                for (DynamicObject aMyTender : myTenderArr) {
                    targetMyTenderArr.add(aMyTender);
                }
            }
            HashMap<String, Object> myTenderEntryMap = new HashMap<String, Object>();
            for (DynamicObject aMyTender : targetMyTenderArr) {
                for (DynamicObject dynamicObject : aMyTender.getDynamicObjectCollection("entry")) {
                    String sectionstatus = dynamicObject.getString("sectionstatus");
                    if (StringUtils.isEmpty((CharSequence)sectionstatus)) continue;
                    myTenderEntryMap.put(dynamicObject.getString("sectionname") + aMyTender.getDynamicObject("supplier").getPkValue(), sectionstatus);
                }
            }
            HashMap publishSectionSupplierMap = new HashMap();
            HashMap<String, DynamicObject> publishSupplierMap = new HashMap<String, DynamicObject>();
            if (bidPublishData != null && !CollectionUtils.isEmpty((Collection)(publishSections = bidPublishData.getDynamicObjectCollection("bidsection")))) {
                for (DynamicObject section : publishSections) {
                    String string = section.getString("sectionname");
                    DynamicObjectCollection publishSupplierEntryList = section.getDynamicObjectCollection("supplierentry");
                    LinkedHashSet<String> bdSupplierIds = new LinkedHashSet<String>();
                    for (DynamicObject publishSupplierEntry : publishSupplierEntryList) {
                        DynamicObject publishSupplier = publishSupplierEntry.getDynamicObject("supplier");
                        if (publishSupplier == null) continue;
                        bdSupplierIds.add(publishSupplier.getPkValue().toString());
                        publishSupplierMap.put(string + publishSupplier.getPkValue(), publishSupplierEntry);
                    }
                    if (CollectionUtils.isEmpty(bdSupplierIds)) continue;
                    publishSectionSupplierMap.put(string, bdSupplierIds);
                }
            }
            HashMap<String, Boolean> invalidFlagMap = new HashMap<String, Boolean>();
            if (bidOpenDatas != null && bidOpenDatas.length > 0) {
                for (DynamicObject bidOpenData : bidOpenDatas) {
                    DynamicObjectCollection openSections = bidOpenData.getDynamicObjectCollection("bidsection");
                    if (CollectionUtils.isEmpty((Collection)openSections)) continue;
                    for (DynamicObject section : openSections) {
                        String sectionName = section.getString("sectionname");
                        DynamicObjectCollection publishSupplierEntryList = section.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject publishSupplierEntry : publishSupplierEntryList) {
                            DynamicObject publishSupplier = publishSupplierEntry.getDynamicObject("supplier");
                            boolean invalid = publishSupplierEntry.getBoolean("supplier_isinvalid");
                            if (publishSupplier == null || !invalid) continue;
                            String key = (String)sectionName + publishSupplier.getPkValue();
                            invalidFlagMap.put(key, Boolean.TRUE);
                        }
                    }
                }
            }
            DynamicObjectCollection dynamicObjectCollection = bidInvData.getDynamicObjectCollection("bidsection");
            HashMap<String, DynamicObject> supplierInvSupplierMap = new HashMap<String, DynamicObject>();
            HashMap sectionSupplierIdMap = new HashMap();
            HashMap<String, String> invitationStatusMap = new HashMap<String, String>();
            HashMap<String, Boolean> recommendMap = new HashMap<String, Boolean>();
            TreeSet<String> invSupplierIds = new TreeSet<String>();
            LinkedHashSet publishSupplierIds = new LinkedHashSet();
            if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                for (DynamicObject section : dynamicObjectCollection) {
                    String sectionName = section.getString("sectionname");
                    DynamicObjectCollection invSupplierEntryList = section.getDynamicObjectCollection("supplierentry");
                    LinkedHashSet<String> sectionAllSupplierIds = new LinkedHashSet<String>();
                    for (DynamicObject invSupplierEntry : invSupplierEntryList) {
                        boolean l;
                        DynamicObject invSupplier = invSupplierEntry.getDynamicObject("supplier");
                        if (invSupplier == null) continue;
                        sectionAllSupplierIds.add(invSupplier.getPkValue().toString());
                        invSupplierIds.add(invSupplier.getPkValue().toString());
                        String key = sectionName + invSupplier.getPkValue();
                        supplierInvSupplierMap.put(key, invSupplierEntry);
                        invitationStatusMap.put(key, invSupplierEntry.getString("invitationstatus"));
                        Boolean recommendFlag = Boolean.FALSE;
                        Set secNameAndSupIdSet = publishSupplierMap.keySet();
                        if (!CollectionUtils.isEmpty(secNameAndSupIdSet) && secNameAndSupIdSet.contains(key)) {
                            recommendFlag = Boolean.TRUE;
                        }
                        if (!recommendFlag.booleanValue() && (l = invSupplierEntry.getBoolean("isrecommend"))) {
                            recommendFlag = Boolean.TRUE;
                        }
                        recommendMap.put(key, recommendFlag);
                    }
                    if (!CollectionUtils.isEmpty(publishSectionSupplierMap) && !CollectionUtils.isEmpty((Collection)(publishSupplierIds = (LinkedHashSet)publishSectionSupplierMap.get(sectionName)))) {
                        sectionAllSupplierIds.addAll(publishSupplierIds);
                    }
                    if (CollectionUtils.isEmpty(sectionAllSupplierIds)) continue;
                    sectionSupplierIdMap.put(sectionName, sectionAllSupplierIds);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(currentInvitationSection = this.getModel().getEntryEntity("bidsection")))) {
                for (DynamicObject section : currentInvitationSection) {
                    String sectionName = section.getString("sectionname");
                    DynamicObjectCollection invSupplierEntryList = section.getDynamicObjectCollection("supplierentry");
                    invSupplierEntryList.clear();
                    int index = 1;
                    LinkedHashSet allSupplierIds = (LinkedHashSet)sectionSupplierIdMap.get(sectionName);
                    if (CollectionUtils.isEmpty((Collection)allSupplierIds)) continue;
                    for (String supplierId : allSupplierIds) {
                        Boolean invalidFlag;
                        DynamicObject supplierEntry = invSupplierEntryList.addNew();
                        supplierEntry.set("seq", (Object)index);
                        supplierEntry.set("isnew", (Object)Boolean.FALSE);
                        String invitationStatus = " ";
                        DynamicObject publishSupplierEntry = (DynamicObject)publishSupplierMap.get(sectionName + supplierId);
                        if (publishSupplierEntry != null && publishSupplierEntry.getBoolean("isnew")) {
                            invitationStatus = " ";
                        } else if (!CollectionUtils.isEmpty(invitationStatusMap)) {
                            invitationStatus = (String)invitationStatusMap.get(sectionName + supplierId);
                            if (StringUtils.isEmpty((CharSequence)invitationStatus)) {
                                invitationStatus = "UNSEND";
                            }
                        } else {
                            invitationStatus = "UNSEND";
                        }
                        supplierEntry.set("invitationstatus", (Object)invitationStatus);
                        if (!recommendMap.isEmpty()) {
                            Boolean isRecommend = (Boolean)recommendMap.get(sectionName + supplierId);
                            supplierEntry.set("isrecommend", (Object)isRecommend);
                        }
                        if ((invalidFlag = (Boolean)invalidFlagMap.get(sectionName + supplierId)) != null) {
                            supplierEntry.set("invalidflag", (Object)invalidFlag);
                        } else if ("REJECTED".equals(invitationStatus)) {
                            supplierEntry.set("invalidflag", (Object)"");
                        } else {
                            supplierEntry.set("invalidflag", (Object)Boolean.FALSE);
                        }
                        String myTenderStatus = (String)myTenderEntryMap.get(sectionName + supplierId);
                        if (!StringUtils.isEmpty((CharSequence)myTenderStatus) && ("PRETENDERED".equals(myTenderStatus) || "TENDERED".equals(myTenderStatus) || "UNTENDERED".equals(myTenderStatus))) {
                            supplierEntry.set("tenderstatus", (Object)myTenderStatus);
                        } else {
                            supplierEntry.set("tenderstatus", (Object)"-");
                        }
                        if (!invSupplierIds.contains(supplierId) && publishSupplierIds.contains(supplierId)) {
                            supplierEntry.set("isfrompublish", (Object)Boolean.TRUE);
                        } else {
                            supplierEntry.set("isfrompublish", (Object)Boolean.FALSE);
                        }
                        DynamicObject bdSupplierInfo = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"resm_official_supplier", (String)"name,company_address,entry_linkman.contactperson,entry_linkman.contactphone,entry_linkman.isdefault_linkman,entry_linkman.contactfax,entry_linkman.contactemail") : BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"bd_supplier", (String)"id,name,entry_linkman.contactperson,entry_linkman.isdefault_linkman,entry_linkman.phone,entry_linkman.fax,entry_linkman.email,entry_linkman.invalid");
                        DynamicObject invSupplierEntry = (DynamicObject)supplierInvSupplierMap.get(sectionName + supplierId);
                        if (invSupplierEntry != null) {
                            BizLog.log((String)(ResManager.loadKDString((String)"\u589e\u8865\u5165\u56f4\u4ece\u5165\u56f4\u5e26\u5165\u7684\u4f9b\u5e94\u5546\u8bbe\u7f6e\u8054\u7cfb\u4eba\u4fe1\u606f\uff1a ", (String)"SupplierInvitationEdit_46", (String)"scm-bid-formplugin", (Object[])new Object[0]) + invSupplierEntry.get("suppliercontact")));
                            supplierEntry.set("suppliercontact", invSupplierEntry.get("suppliercontact"));
                            supplierEntry.set("contactphone", invSupplierEntry.get("contactphone"));
                            supplierEntry.set("email", invSupplierEntry.get("email"));
                            supplierEntry.set("fax", invSupplierEntry.get("fax"));
                            supplierEntry.set("address", invSupplierEntry.get("address"));
                            supplierEntry.set("suppliersecdeposit", invSupplierEntry.get("suppliersecdeposit"));
                            supplierEntry.set("invitation", invSupplierEntry.get("invitation"));
                            supplierEntry.set("invitationuser", invSupplierEntry.get("invitationuser"));
                            supplierEntry.set("extractcomment", invSupplierEntry.get("extractcomment"));
                            supplierEntry.set("ispatchsupplier", invSupplierEntry.get("ispatchsupplier"));
                            supplierEntry.set("isregister", invSupplierEntry.get("isregister"));
                            supplierEntry.set("announcementid", invSupplierEntry.get("announcementid"));
                            supplierEntry.set(SUPPLIER_ENTRY_F7, invSupplierEntry.get(SUPPLIER_ENTRY_F7));
                            DynamicObjectCollection newInviteAttachFiles = supplierEntry.getDynamicObjectCollection("inviteattachfile");
                            DynamicObjectCollection oldInviteAttachFiles = invSupplierEntry.getDynamicObjectCollection("inviteattachfile");
                            oldInviteAttachFiles.stream().forEach(item -> {
                                DynamicObject inviteAttach = newInviteAttachFiles.addNew();
                                inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
                            });
                        } else {
                            DynamicObjectCollection bdSupplierLinkManList;
                            boolean isFlag = true;
                            if (publishSupplierEntry != null) {
                                supplierEntry.set("suppliercontact", publishSupplierEntry.get("suppliercontact"));
                                supplierEntry.set("contactphone", publishSupplierEntry.get("contactphone"));
                                isFlag = false;
                            }
                            if ("rebm".equals(appId)) {
                                bdSupplierLinkManList = bdSupplierInfo.getDynamicObjectCollection("entry_linkman");
                                supplierEntry.set("address", (Object)bdSupplierInfo.getString("company_address"));
                                if (bdSupplierLinkManList != null && bdSupplierLinkManList.size() > 0) {
                                    for (DynamicObject linkman : bdSupplierLinkManList) {
                                        if (!linkman.getBoolean("isdefault_linkman")) continue;
                                        if (isFlag) {
                                            supplierEntry.set("suppliercontact", linkman.get("contactperson"));
                                            supplierEntry.set("contactphone", linkman.get("contactphone"));
                                        }
                                        supplierEntry.set("email", linkman.get("contactemail"));
                                        supplierEntry.set("fax", linkman.get("contactfax"));
                                    }
                                }
                            } else {
                                QFilter[] qFilter;
                                DynamicObject[] bdAddressInfo;
                                bdSupplierLinkManList = bdSupplierInfo.getDynamicObjectCollection("entry_linkman");
                                if (bdSupplierLinkManList != null && bdSupplierLinkManList.size() > 0) {
                                    for (DynamicObject linkman : bdSupplierLinkManList) {
                                        Boolean invalid = linkman.getBoolean("invalid");
                                        Boolean isDefaultLinkman = linkman.getBoolean("isdefault_linkman");
                                        if (!isDefaultLinkman.booleanValue() || invalid.booleanValue()) continue;
                                        if (isFlag) {
                                            supplierEntry.set("suppliercontact", (Object)linkman.getLocaleString("contactperson").getLocaleValue());
                                            supplierEntry.set("contactphone", linkman.get("phone"));
                                        }
                                        supplierEntry.set("email", linkman.get("email"));
                                        supplierEntry.set("fax", linkman.get("fax"));
                                    }
                                }
                                if ((bdAddressInfo = BusinessDataServiceHelper.load((String)"bd_address", (String)"number,name,detailaddress,invalid,default", (QFilter[])(qFilter = new QFilter[]{new QFilter("supplierid", "=", (Object)supplierId)}))) != null && bdAddressInfo.length > 0) {
                                    for (DynamicObject bdAddress : bdAddressInfo) {
                                        Boolean invalid = bdAddress.getBoolean("invalid");
                                        Boolean defaultAddress = bdAddress.getBoolean("default");
                                        if (!invalid.booleanValue() || !defaultAddress.booleanValue()) continue;
                                        supplierEntry.set("address", bdAddress.get("detailaddress"));
                                    }
                                }
                            }
                        }
                        supplierEntry.set("supplier", (Object)bdSupplierInfo);
                        DynamicObject supplierStatistic = this.suppStatService.getSupplierStatistic(Long.valueOf(supplierId), appId + "_supplierstatistic");
                        supplierEntry.set("supplierstatistic", (Object)supplierStatistic);
                        supplierEntry.set("isnew", (Object)Boolean.FALSE);
                        ++index;
                    }
                }
            }
        }
        this.getView().updateView("supplierentry");
        this.updateBackCroundColour();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (OperationStatus.EDIT.equals((Object)operationStatus) || OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            Object id = ((BillShowParameter)formShowParameter).getPkId();
            if (id == null) {
                return;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(id.toString()));
            DynamicObject object = QueryServiceHelper.queryOne((String)"bid_supplierinvitation", (String)"billstatus", (QFilter[])new QFilter[]{qFilter});
            if (object == null) {
                return;
            }
            boolean eFlag = BillStatusEnum.INVALID.getVal().equals(object.get("billstatus"));
            boolean bFlag = BillStatusEnum.AUDITING.getVal().equals(object.get("billstatus"));
            boolean xxFlag = BillStatusEnum.INVALIDXX.getVal().equals(object.get("billstatus"));
            if (eFlag || bFlag || xxFlag) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
        }
    }

    void setVisibleOfSupplierEnroll() {
        DynamicObject bidProject = this.getModel().getDataEntity().getDynamicObject("bidproject");
        if (bidProject == null) {
            return;
        }
        String appId = this.getModel().getDataEntityType().getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!BidModeHelper.isPublicBidding(bidProject)) {
            this.setButtonVisible(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"supplierenroll"});
        } else {
            this.setButtonVisible(!enable);
            this.getView().setVisible(Boolean.valueOf(enable), new String[]{"extractcomment"});
            this.getView().setVisible(Boolean.valueOf(enable), new String[]{"supplierenroll"});
            if (this.needHandleSection()) {
                this.setEnableEnrollMultiSection(!this.isSingleSection());
            }
            if (enable) {
                EntryGrid entryEntityGrid = (EntryGrid)this.getControl("supplierentry");
                entryEntityGrid.setColumnProperty("supplier", "l", (Object)55);
                entryEntityGrid.setColumnProperty(SUPPLIER_ENTRY_F7, "l", (Object)55);
            }
        }
    }

    @Override
    public void afterBindData(EventObject eventobject) {
        super.afterBindData(eventobject);
        Object billStatus = this.getModel().getDataEntity().get("billstatus");
        if (BillStatusEnum.DISBEGIN.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_del"});
        }
        this.setVisibleAgainInvitationButton();
        this.setVisibleOfSupplierEnroll();
        AdvContainer panel = (AdvContainer)this.getControl("supplierenroll");
        if (!BillStatusEnum.DISBEGIN.getVal().equals(billStatus) && !BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            panel.setCollapse(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"cancelsupplier"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"addsupplierenroll"});
        } else {
            panel.setCollapse(false);
        }
        boolean flag = false;
        String isAgainInvitation = this.getPageCache().get("isAgainInvitation");
        if (!StringUtils.isEmpty((CharSequence)isAgainInvitation) && "1".equals(isAgainInvitation)) {
            flag = true;
        }
        if (this.isInvitation() && this.isEnable()) {
            if (!flag) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"addinvitation"});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"invitationstatus"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invitationstatus"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"addinvitation"});
        }
        this.getModel().setDataChanged(false);
        this.updateValidSupplierCount();
    }

    public void setVisibleAgainInvitationButton() {
        Object billStatus = this.getModel().getDataEntity().get("billstatus");
        String appId = this.getModel().getDataEntityType().getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable || !BillStatusEnum.AUDITED.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblagaininvitation"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblagaininvitation"});
        }
    }

    public void updateValidSupplierCount() {
        TreeSet<String> supplierIdSet = new TreeSet<String>();
        DynamicObjectCollection invitationSections = this.getModel().getEntryEntity("bidsection");
        if (!CollectionUtils.isEmpty((Collection)invitationSections)) {
            for (DynamicObject section : invitationSections) {
                DynamicObjectCollection invSupplierEntryList = section.getDynamicObjectCollection("supplierentry");
                for (DynamicObject invSupplierEntry : invSupplierEntryList) {
                    DynamicObject invSupplier;
                    String tenderStatus = invSupplierEntry.getString("tenderstatus");
                    Boolean invalidFlag = invSupplierEntry.getBoolean("invalidflag");
                    Boolean isrecommendFlag = invSupplierEntry.getBoolean("isrecommend");
                    if (!isrecommendFlag.booleanValue() || invalidFlag.booleanValue() || "UNTENDERED".equals(tenderStatus) || (invSupplier = invSupplierEntry.getDynamicObject("supplier")) == null) continue;
                    supplierIdSet.add(invSupplier.getPkValue().toString());
                }
            }
        }
        Label label = (Label)this.getView().getControl("invsupliercount");
        label.setText(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u4f9b\u5e94\u5546\u6570\u91cf%1$s%2$s", (String)"SupplierInvitationEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), supplierIdSet.size(), ResManager.loadKDString((String)" \u4e2a", (String)"SupplierInvitationEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        this.getModel().setDataChanged(false);
    }

    private void setButtonVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"addsupplier", "delsupplier"});
        this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"cancelsupplier"});
    }

    protected void setEnableEnrollMultiSection(boolean enableMultiSec) {
        SplitContainer splitContainer = (SplitContainer)this.getControl("supplierenrollcontainer");
        if (splitContainer != null) {
            if (enableMultiSec) {
                splitContainer.changeFlexStatus(SplitDirection.left, false);
            } else {
                splitContainer.changeFlexStatus(SplitDirection.left, true);
            }
            EntryGrid section = (EntryGrid)this.getControl("bidenrollsection");
            DynamicObjectCollection sectionCols = this.getModel().getEntryEntity("bidenrollsection");
            if (sectionCols.size() > 0) {
                section.selectRows(0);
            }
        }
    }

    public void checkInvitationStatus() {
        IDataModel billModel = this.getModel();
        boolean isExixts = QueryServiceHelper.exists((String)"bid_supplierinvitation", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billModel.getDataEntity().getLong("id"))});
        String billPkValue = billModel.getDataEntity().getString("id");
        if (isExixts && !"0".equals(billPkValue)) {
            DynamicObject supplierInvitationStorage = BusinessDataServiceHelper.loadSingle((Object)billModel.getDataEntity().getPkValue(), (DynamicObjectType)billModel.getDataEntityType());
            DynamicObjectCollection sectionEntrysCur = billModel.getEntryEntity(this.SECTION_ENTRY_ENTITY);
            DynamicObjectCollection sectionEntrysStorage = supplierInvitationStorage.getDynamicObjectCollection(this.SECTION_ENTRY_ENTITY);
            if (null != sectionEntrysCur) {
                for (DynamicObject sectionEntryRowCur : sectionEntrysCur) {
                    for (DynamicObject sectionEntryRowStorage : sectionEntrysStorage) {
                        DynamicObjectCollection supplierEntrysCur = sectionEntryRowCur.getDynamicObjectCollection(this.SUPPLIER_ENTRY_ENTITY);
                        DynamicObjectCollection supplierEntrysStorage = sectionEntryRowStorage.getDynamicObjectCollection(this.SUPPLIER_ENTRY_ENTITY);
                        for (DynamicObject supplierEntryRowCur : supplierEntrysCur) {
                            for (DynamicObject supplierEntryRowStorage : supplierEntrysStorage) {
                                String invitationStatus;
                                if (!supplierEntryRowCur.getPkValue().equals(supplierEntryRowStorage.getPkValue()) || StringUtils.isEmpty((CharSequence)(invitationStatus = supplierEntryRowStorage.getString("invitationstatus"))) || !"ACCEPTED".equals(invitationStatus) && !"REJECTED".equals(invitationStatus)) continue;
                                supplierEntryRowCur.set("invitationstatus", (Object)invitationStatus);
                            }
                        }
                    }
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject bidProject;
        DynamicObject bidProject2;
        DynamicObject dataEntity;
        DynamicObject bidProject3;
        String appId;
        String sourceBillId;
        DynamicObject supplierInvitation;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        IDataModel billModel = this.getModel();
        if ("save".equals(operateKey)) {
            boolean supplierChangeFlag;
            DynamicObject supplierInvitation2;
            HashSet<Long> supplierIds = new HashSet<Long>();
            DynamicObjectCollection sectionEntrys = billModel.getEntryEntity(this.SECTION_ENTRY_ENTITY);
            if (null != sectionEntrys) {
                for (int i = 0; i < sectionEntrys.size(); ++i) {
                    DynamicObjectCollection supplierEntrys = ((DynamicObject)sectionEntrys.get(i)).getDynamicObjectCollection(this.SUPPLIER_ENTRY_ENTITY);
                    for (int j = 0; j < supplierEntrys.size(); ++j) {
                        DynamicObject supplier = ((DynamicObject)supplierEntrys.get(j)).getDynamicObject("supplier");
                        if (null == supplier) continue;
                        supplierIds.add((Long)supplier.getPkValue());
                    }
                }
            }
            billModel.getDataEntity().set("supplierqty", (Object)supplierIds.size());
            if (!"0".equals(String.valueOf(billModel.getDataEntity().getPkValue()))) {
                DynamicObjectCollection sectionEntrysCur = billModel.getEntryEntity(this.SECTION_ENTRY_ENTITY);
                HashSet<Long> hasSendSupplierSet = new HashSet<Long>();
                HashMap<Long, String> hasSendSupplierMap = new HashMap<Long, String>();
                if (null != sectionEntrysCur) {
                    String invitationStatus;
                    DynamicObjectCollection supplierEntrysCur;
                    this.checkInvitationStatus();
                    for (DynamicObject sectionEntryRowCur : sectionEntrysCur) {
                        supplierEntrysCur = sectionEntryRowCur.getDynamicObjectCollection(this.SUPPLIER_ENTRY_ENTITY);
                        for (DynamicObject supplierEntryRowCur : supplierEntrysCur) {
                            invitationStatus = supplierEntryRowCur.getString("invitationstatus");
                            if (!"UNCONFIRM".equals(invitationStatus) && !"ACCEPTED".equals(invitationStatus) || supplierEntryRowCur.getDynamicObject("supplier") == null) continue;
                            hasSendSupplierSet.add((Long)supplierEntryRowCur.getDynamicObject("supplier").getPkValue());
                            hasSendSupplierMap.put((Long)supplierEntryRowCur.getDynamicObject("supplier").getPkValue(), String.format(ResManager.loadKDString((String)"%1$s\u4e2d%2$s", (String)"SupplierInvitationEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionEntryRowCur.getString("sectionname"), supplierEntryRowCur.getString("supplier.name")));
                        }
                    }
                    for (DynamicObject sectionEntryRowCur : sectionEntrysCur) {
                        supplierEntrysCur = sectionEntryRowCur.getDynamicObjectCollection(this.SUPPLIER_ENTRY_ENTITY);
                        for (DynamicObject supplierEntryRowCur : supplierEntrysCur) {
                            invitationStatus = supplierEntryRowCur.getString("invitationstatus");
                            if ("UNSEND".equals(invitationStatus) && supplierEntryRowCur.getDynamicObject("supplier") != null && !hasSendSupplierSet.contains((Long)supplierEntryRowCur.getDynamicObject("supplier").getPkValue())) continue;
                        }
                    }
                }
            }
            if (SupplierInvitationUtil.isAgainSupplierInvitation(supplierInvitation2 = this.getModel().getDataEntity(true)) && !(supplierChangeFlag = this.checkSupplierChange(supplierInvitation2))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5165\u56f4\u4f9b\u5e94\u5546\u6ca1\u6709\u53d1\u751f\u53d8\u5316\uff0c\u65e0\u9700\u589e\u8865\u5165\u56f4\u3002", (String)"SupplierInvitationEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if ("submit".equals(operateKey)) {
            String checkResult;
            this.checkInvitationStatus();
            supplierInvitation = this.service.getSupplierInvitationById((Long)billModel.getDataEntity(true).getPkValue());
            if (SupplierInvitationUtil.isAgainSupplierInvitation(supplierInvitation) && !StringUtils.isEmpty((CharSequence)(sourceBillId = supplierInvitation.getString("sourcebillid"))) && !StringUtils.isEmpty((CharSequence)(checkResult = SupplierInvitationUtil.checkIsSubmitAudit(sourceBillId, appId = this.getModel().getDataEntityType().getAppId())))) {
                this.getView().showTipNotification(checkResult);
                args.setCancel(true);
                return;
            }
            bidProject3 = supplierInvitation.getDynamicObject("bidproject");
            if (bidProject3 != null) {
                boolean supplierChangeFlag;
                if (SupplierInvitationUtil.isAgainSupplierInvitation(supplierInvitation) && !(supplierChangeFlag = this.checkSupplierChange(supplierInvitation))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5165\u56f4\u4f9b\u5e94\u5546\u6ca1\u6709\u53d1\u751f\u53d8\u5316\uff0c\u65e0\u9700\u589e\u8865\u5165\u56f4\u3002", (String)"SupplierInvitationEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object dateLine = bidProject3.get("invitationdeadline");
                if (dateLine != null) {
                    Date newDate = (Date)dateLine;
                    Date now = new Date();
                    if (newDate.getTime() > now.getTime() && this.isInvitation() && this.isEnable()) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String str = dateFormat.format(newDate.getTime());
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5230\u201c\u9080\u8bf7\u51fd\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u201d%s\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"SupplierInvitationEdit_6", (String)"scm-bid-formplugin", (Object[])new Object[0]), str));
                        args.setCancel(true);
                        return;
                    }
                }
                if (this.isInvitation() && this.isEnable()) {
                    String yqhCheckResult;
                    boolean unconfirm = false;
                    DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)((Long)billModel.getDataEntity(true).getPkValue()), (String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()));
                    DynamicObjectCollection bidSectionColl = supplier.getDynamicObjectCollection("bidsection");
                    if (bidSectionColl != null && bidSectionColl.size() > 0) {
                        for (int i = 0; i < bidSectionColl.size(); ++i) {
                            DynamicObjectCollection supplierEntry = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                            if (supplierEntry == null || supplierEntry.size() <= 0) continue;
                            for (int m = 0; m < supplierEntry.size(); ++m) {
                                if (((DynamicObject)supplierEntry.get(m)).getString("invitationstatus").equals("UNSEND")) continue;
                                unconfirm = true;
                            }
                        }
                    }
                    if (!unconfirm && !"1".equals(yqhCheckResult = this.getPageCache().get("yqhCheckResult"))) {
                        this.getPageCache().put("yqhCheck", "1");
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u65e0\u4f9b\u5e94\u5546\u63a5\u53d7\u9080\u8bf7\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4?", (String)"SupplierInvitationEdit_7", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                        args.setCancel(true);
                        return;
                    }
                }
                HashSet<Long> supplierIds = new HashSet<Long>();
                DynamicObjectCollection sectionEntrys = billModel.getEntryEntity(this.SECTION_ENTRY_ENTITY);
                if (null != sectionEntrys) {
                    for (int i = 0; i < sectionEntrys.size(); ++i) {
                        DynamicObjectCollection supplierEntrys = ((DynamicObject)sectionEntrys.get(i)).getDynamicObjectCollection(this.SUPPLIER_ENTRY_ENTITY);
                        for (int j = 0; j < supplierEntrys.size(); ++j) {
                            DynamicObject supplierEntry = ((DynamicObject)supplierEntrys.get(j)).getDynamicObject("supplier");
                            if (null == supplierEntry) continue;
                            supplierIds.add((Long)supplierEntry.getPkValue());
                        }
                    }
                }
                billModel.getDataEntity().set("supplierqty", (Object)supplierIds.size());
            }
        } else if ("unsubmit".equals(operateKey)) {
            if (this.isInvitation() && this.isEnable()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"addinvitation"});
            }
        } else if ("addsupplierdetail".equals(operateKey)) {
            int select;
            int i;
            dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection enrollSupplierDetailColl = billModel.getEntryEntity("supplierenrollentry");
            DynamicObjectCollection supplierEntryDetailColl = null;
            DynamicObjectCollection bidSectionCol = dataEntity.getDynamicObjectCollection("bidsection");
            EntryGrid bidSectionGrid = (EntryGrid)this.getControl("bidsection");
            int[] bidSectionSelRows = bidSectionGrid.getSelectRows();
            int bidSectionSelRow = 0;
            if (bidSectionSelRows.length > 0) {
                bidSectionSelRow = bidSectionSelRows[0];
            }
            supplierEntryDetailColl = ((DynamicObject)bidSectionCol.get(bidSectionSelRow)).getDynamicObjectCollection("supplierentry");
            EntryGrid enrollSupplierGrid = (EntryGrid)this.getControl("supplierenrollentry");
            int[] selects = enrollSupplierGrid.getSelectRows();
            if (selects.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u64cd\u4f5c\u3002", (String)"SupplierInvitationEdit_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection toAddEnrollSupplierDetailColls = new DynamicObjectCollection();
            int isInvitation = 0;
            for (i = 0; i < selects.length; ++i) {
                select = selects[i];
                for (int j = 0; j < enrollSupplierDetailColl.size(); ++j) {
                    if (j != select) continue;
                    DynamicObject enrollDetail = (DynamicObject)enrollSupplierDetailColl.get(j);
                    if (enrollDetail.getBoolean("isinvitation")) {
                        ++isInvitation;
                    }
                    toAddEnrollSupplierDetailColls.add((Object)enrollDetail);
                }
            }
            if (isInvitation == selects.length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u4f9b\u5e94\u5546\u5df2\u63a8\u8350\u5165\u56f4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"SupplierInvitationEdit_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            for (i = 0; i < selects.length; ++i) {
                select = selects[i];
                this.getModel().setValue("isinvitation", (Object)Boolean.TRUE, select);
            }
            this.insertSupplierEntry(toAddEnrollSupplierDetailColls, supplierEntryDetailColl);
            this.updateValidSupplierCount();
        } else if ("deletesupplierentry".equals(operateKey)) {
            DynamicObjectCollection supplierEntryColl = billModel.getEntryEntity("supplierentry");
            EntryGrid detailType = (EntryGrid)this.getControl("supplierentry");
            int[] selects = detailType.getSelectRows();
            HashSet<Object> supplierIdSet = new HashSet<Object>();
            ArrayList<Object> notNewSupplier = new ArrayList<Object>();
            for (int i = 0; i < selects.length; ++i) {
                int select = selects[i];
                for (int j = 0; j < supplierEntryColl.size(); ++j) {
                    if (j != select) continue;
                    DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    Boolean isNew = supplierEntry.getBoolean("isnew");
                    if (!isNew.booleanValue()) {
                        notNewSupplier.add(supplier.get("id"));
                    }
                    supplierIdSet.add(supplier.get("id"));
                }
            }
            if (!CollectionUtils.isEmpty(notNewSupplier)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u672c\u6b21\u65b0\u589e\u7684\u4f9b\u5e94\u5546\u3002", (String)"SupplierInvitationEdit_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection enrollDetailColls = billModel.getEntryEntity("supplierenrollentry");
            for (int i = 0; i < enrollDetailColls.size(); ++i) {
                DynamicObject enrollDetail = (DynamicObject)enrollDetailColls.get(i);
                DynamicObject supplier = enrollDetail.getDynamicObject("enrollsupplier");
                if (!supplierIdSet.contains(supplier.get("id"))) continue;
                enrollDetail.set("isinvitation", (Object)Boolean.FALSE);
            }
            this.getView().updateView("supplierenrollentry");
        } else if ("addinvitation".equals(operateKey)) {
            String status;
            QFilter statusFilter;
            dataEntity = this.getModel().getDataEntity();
            if (dataEntity == null || dataEntity.equals("")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"SupplierInvitationEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            String billStatus = dataEntity.getString("billstatus");
            if (!billStatus.equals("A")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u624d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"SupplierInvitationEdit_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            bidProject2 = this.getModel().getDataEntity().getDynamicObject("bidproject");
            QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProject2.getLong("id"));
            DynamicObjectCollection invitationColl = QueryServiceHelper.query((String)"bid_invitation", (String)"id,status,releasestatus", (QFilter[])new QFilter[]{qFilter, statusFilter = new QFilter("status", "not in", (Object)new String[]{"XX", "X"})}, (String)"createtime desc");
            if (invitationColl != null && invitationColl.size() > 0 && !"A".equals(status = ((DynamicObject)invitationColl.get(0)).getString("status"))) {
                for (DynamicObject invitation : invitationColl) {
                    boolean flag = "P".equals(invitation.getString("releasestatus")) && "C".equals(invitation.getString("status"));
                    if (flag) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u9080\u8bf7\u51fd\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SupplierInvitationEdit_41", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()));
            DynamicObjectCollection bidSectionColl = supplier.getDynamicObjectCollection("bidsection");
            DynamicObjectCollection bidSectionCollCur = this.getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
            if (!CollectionUtils.isEmpty((Collection)bidSectionColl) && !CollectionUtils.isEmpty((Collection)bidSectionCollCur)) {
                this.updateInvitationstatus(bidSectionColl, bidSectionCollCur);
            }
            boolean isAgainInvitation = SupplierInvitationUtil.isAgainSupplierInvitation(dataEntity);
            boolean unSend = false;
            ArrayList<String> unSendSupplierEntryList = new ArrayList<String>();
            if (bidSectionColl != null && bidSectionColl.size() > 0 && bidSectionCollCur != null && bidSectionCollCur.size() > 0) {
                for (int j = 0; j < bidSectionCollCur.size(); ++j) {
                    DynamicObjectCollection supplierEntry = ((DynamicObject)bidSectionCollCur.get(j)).getDynamicObjectCollection("supplierentry");
                    if (supplierEntry == null || supplierEntry.size() <= 0) continue;
                    for (int m = 0; m < supplierEntry.size(); ++m) {
                        boolean isNew = ((DynamicObject)supplierEntry.get(m)).getBoolean("isnew");
                        boolean unSendStatus = "UNSEND".equals(((DynamicObject)supplierEntry.get(m)).getString("invitationstatus"));
                        if (isAgainInvitation) {
                            String tenderStatus;
                            if (isNew && unSendStatus) {
                                unSend = true;
                                unSendSupplierEntryList.add(((DynamicObject)supplierEntry.get(m)).getString("id"));
                            }
                            if (isNew || !unSendStatus || !StringUtils.isEmpty((CharSequence)(tenderStatus = ((DynamicObject)supplierEntry.get(m)).getString("tenderstatus"))) && !tenderStatus.contains("-")) continue;
                            unSend = true;
                            unSendSupplierEntryList.add(((DynamicObject)supplierEntry.get(m)).getString("id"));
                            continue;
                        }
                        if (!unSendStatus) continue;
                        unSend = true;
                        unSendSupplierEntryList.add(((DynamicObject)supplierEntry.get(m)).getString("id"));
                    }
                }
                if (null != bidSectionCollCur) {
                    for (DynamicObject sectionEntryRowCur : bidSectionCollCur) {
                        for (DynamicObject sectionEntryRowStorage : bidSectionColl) {
                            DynamicObjectCollection supplierEntrysCur = sectionEntryRowCur.getDynamicObjectCollection(this.SUPPLIER_ENTRY_ENTITY);
                            DynamicObjectCollection supplierEntrysStorage = sectionEntryRowStorage.getDynamicObjectCollection(this.SUPPLIER_ENTRY_ENTITY);
                            if (!sectionEntryRowCur.getPkValue().equals(sectionEntryRowStorage.getPkValue())) continue;
                            if (supplierEntrysCur.size() < supplierEntrysStorage.size()) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u90e8\u5206\u4f9b\u5e94\u5546\u88ab\u5220\u9664\u4e14\u672a\u4fdd\u5b58\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"SupplierInvitationEdit_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                return;
                            }
                            if (supplierEntrysCur.size() > supplierEntrysStorage.size()) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"SupplierInvitationEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                return;
                            }
                            if (supplierEntrysCur.size() != supplierEntrysStorage.size()) continue;
                            for (DynamicObject supplierEntryRowCur : supplierEntrysCur) {
                                for (DynamicObject supplierEntryRowStorage : supplierEntrysStorage) {
                                    if (supplierEntryRowCur.getPkValue().equals(supplierEntryRowStorage.getPkValue()) && supplierEntryRowCur.getDynamicObject("supplier") != null && supplierEntryRowStorage.getDynamicObject("supplier") != null && !supplierEntryRowCur.getDynamicObject("supplier").getPkValue().equals(supplierEntryRowStorage.getDynamicObject("supplier").getPkValue())) {
                                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"SupplierInvitationEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                        return;
                                    }
                                    if (supplierEntryRowCur.getPkValue() == null || !supplierEntryRowCur.getPkValue().toString().equals("0") || supplierEntryRowCur.getDynamicObject("supplier") == null || supplierEntryRowStorage.getDynamicObject("supplier") == null || supplierEntryRowCur.getDynamicObject("supplier").getPkValue().equals(supplierEntryRowStorage.getDynamicObject("supplier").getPkValue())) continue;
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"SupplierInvitationEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                    return;
                                }
                            }
                        }
                    }
                }
                String selectFields = "bidproject, supplier, entry,entry.sectionname, entry.projectsection, entry.sectionstatus, ispublicbid, tenderstatus";
                String appId2 = this.getModel().getDataEntityType().getAppId();
                DynamicObject[] myTenderArr = null;
                if ("bid".equals(appId2)) {
                    myTenderArr = BusinessDataServiceHelper.load((String)"ten_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject2.getPkValue())});
                } else if ("rebm".equals(appId2)) {
                    myTenderArr = BusinessDataServiceHelper.load((String)"resp_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject2.getPkValue())});
                }
                TreeSet<String> myTenderSupplierList = new TreeSet<String>();
                if (myTenderArr != null && myTenderArr.length > 0) {
                    for (DynamicObject aMyTender : myTenderArr) {
                        String supplierId = aMyTender.getDynamicObject("supplier").getPkValue().toString();
                        myTenderSupplierList.add(supplierId);
                    }
                }
                for (String supplierId : myTenderSupplierList) {
                    unSendSupplierEntryList.remove(supplierId);
                }
                if (CollectionUtils.isEmpty(unSendSupplierEntryList)) {
                    unSend = false;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f85\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"SupplierInvitationEdit_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!unSend) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f85\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"SupplierInvitationEdit_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            this.addInvitation(dataEntity, unSendSupplierEntryList);
        } else if ("deleteentry".equals(operateKey)) {
            if (this.isInvitation() && this.isEnable()) {
                EntryGrid detailType = (EntryGrid)this.getControl("supplierentry");
                int[] selects = detailType.getSelectRows();
                DynamicObjectCollection supplierEntry = this.getModel().getEntryEntity("supplierentry");
                if (supplierEntry != null && supplierEntry.size() > 0) {
                    String ids = this.getPageCache().get(needDeleteInvitationSupplierIds);
                    StringBuilder invIdsb = new StringBuilder();
                    if (ids == null) {
                        ids = "";
                    }
                    StringBuilder idsStrSb = new StringBuilder();
                    idsStrSb.append(ids);
                    String appId3 = this.getModel().getDataEntityType().getAppId();
                    DynamicObject bidProject4 = this.getModel().getDataEntity(true).getDynamicObject("bidproject");
                    for (int j = 0; j < selects.length; ++j) {
                        for (int i = 0; i < supplierEntry.size(); ++i) {
                            DynamicObject[] invitationDataArray;
                            DynamicObject supplier;
                            if (i != selects[j]) continue;
                            if (!((DynamicObject)supplierEntry.get(i)).getBoolean("isnew")) {
                                args.setCancel(true);
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u65b0\u589e\u7684\u4f9b\u5e94\u5546\u624d\u5141\u8bb8\u5220\u9664\u3002", (String)"SupplierInvitationEdit_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                return;
                            }
                            String invitationStatus = ((DynamicObject)supplierEntry.get(i)).getString("invitationstatus");
                            if (StringUtils.isNotBlank((CharSequence)invitationStatus)) {
                                if (!"UNSEND".equals(invitationStatus)) {
                                    args.setCancel(true);
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5206\u5f55\u53ea\u6709\u9080\u8bf7\u51fd\u72b6\u6001\u662f\u672a\u53d1\u9001\u72b6\u6001\u7684\u6570\u636e\u624d\u5141\u8bb8\u5220\u9664\u3002", (String)"SupplierInvitationEdit_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                    return;
                                }
                                if ("UNSEND".equals(invitationStatus) && (supplier = ((DynamicObject)supplierEntry.get(i)).getDynamicObject("supplier")) != null) {
                                    String value = supplier.getPkValue().toString() + "#";
                                    idsStrSb.append(value);
                                }
                            }
                            supplier = ((DynamicObject)supplierEntry.get(i)).getDynamicObject("supplier");
                            for (DynamicObject invitationData : invitationDataArray = BusinessDataServiceHelper.load((String)(appId3 + "_invitation"), (String)"status", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject4.getPkValue()), new QFilter("supplierentry.supplier.id", "=", supplier.getPkValue())}, (String)"createtime desc", (int)1)) {
                                if (!"A".equals(invitationData.getString("status"))) {
                                    args.setCancel(true);
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f53\u4f9b\u5e94\u5546\u5206\u5f55\u4e0d\u5b58\u5728\u5173\u8054\u7684\u9080\u8bf7\u51fd\u6216\u9080\u8bf7\u51fd\u5355\u636e\u72b6\u6001\u4e3a\u6682\u5b58\u65f6\u624d\u5141\u8bb8\u5220\u9664\u3002", (String)"SupplierInvitationEdit_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                    return;
                                }
                                invIdsb.append(invitationData.getPkValue()).append("##");
                            }
                        }
                    }
                    this.getPageCache().put("invIds", invIdsb.toString());
                    this.getPageCache().put(needDeleteInvitationSupplierIds, idsStrSb.toString());
                }
            }
        } else if ("addinvitationview".equals(operateKey) && (bidProject = this.getModel().getDataEntity().getDynamicObject("bidproject")) != null) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setCustomParam("bidProjectPk", bidProject.getPkValue());
            listShowParameter.setBillFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
            listShowParameter.setHasRight(true);
            listShowParameter.setMultiSelect(false);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u5217\u8868", (String)"SupplierInvitationEdit_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"newdelete")) {
            Long pk = (Long)this.getModel().getDataEntity().getPkValue();
            String billno = this.getModel().getDataEntity().getString("bidproject.billno");
            DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bid_supplierinvitation");
            boolean isAgainSupplierInvitation = SupplierInvitationUtil.isAgainSupplierInvitation(this.getModel().getDataEntity());
            DynamicObjectCollection bidSectionColl = supplier.getDynamicObjectCollection("bidsection");
            if (bidSectionColl != null && bidSectionColl.size() > 0) {
                for (int m = 0; m < bidSectionColl.size(); ++m) {
                    DynamicObjectCollection supplierEntry = ((DynamicObject)bidSectionColl.get(m)).getDynamicObjectCollection("supplierentry");
                    if (supplierEntry == null || supplierEntry.size() <= 0) continue;
                    for (int n = 0; n < supplierEntry.size(); ++n) {
                        boolean invitationStatusFlag;
                        String invitationStatus = ((DynamicObject)supplierEntry.get(n)).getString("invitationstatus");
                        if (!StringUtils.isNotBlank((CharSequence)invitationStatus)) continue;
                        boolean bl = invitationStatusFlag = !"UNSEND".equals(invitationStatus);
                        if (isAgainSupplierInvitation) {
                            if (!invitationStatusFlag || !((DynamicObject)supplierEntry.get(n)).getBoolean("isnew")) continue;
                            args.setCancel(true);
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62db\u6807\u540d\u79f0 [%s]:\u5b58\u5728\u5df2\u53d1\u9001\u9080\u8bf7\u51fd\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SupplierInvitationEdit_20", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
                            return;
                        }
                        if (!invitationStatusFlag) continue;
                        args.setCancel(true);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62db\u6807\u540d\u79f0 [%s]:\u5b58\u5728\u5df2\u53d1\u9001\u9080\u8bf7\u51fd\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SupplierInvitationEdit_20", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
                        return;
                    }
                }
            }
            DynamicObjectCollection bidenrollsection = supplier.getDynamicObjectCollection("bidenrollsection");
            if (bidSectionColl != null && bidSectionColl.size() > 0) {
                for (int m = 0; m < bidSectionColl.size(); ++m) {
                    DynamicObjectCollection supplierenrollentry = ((DynamicObject)bidenrollsection.get(m)).getDynamicObjectCollection("supplierenrollentry");
                    if (supplierenrollentry == null || supplierenrollentry.size() <= 0 || isAgainSupplierInvitation) continue;
                    args.setCancel(true);
                    String str = String.format(ResManager.loadKDString((String)"\u62db\u6807\u540d\u79f0[%s]:\u5df2\u5b58\u5728\u62a5\u540d\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SupplierInvitationEdit_45", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno);
                    this.getView().showTipNotification(str);
                    return;
                }
            }
            RefObject afterConfirm = new RefObject();
            if (!formOperate.getOption().tryGetVariableValue("newdelete", afterConfirm)) {
                args.setCancel(true);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("newdelete", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"SupplierInvitationEdit_23", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"audit")) {
            supplierInvitation = this.service.getSupplierInvitationById((Long)billModel.getDataEntity(true).getPkValue());
            if (SupplierInvitationUtil.isAgainSupplierInvitation(supplierInvitation)) {
                String tipMessage;
                String checkResult;
                sourceBillId = supplierInvitation.getString("sourcebillid");
                if (!StringUtils.isEmpty((CharSequence)sourceBillId) && !StringUtils.isEmpty((CharSequence)(checkResult = SupplierInvitationUtil.checkIsSubmitAudit(sourceBillId, appId = this.getModel().getDataEntityType().getAppId())))) {
                    this.getView().showTipNotification(checkResult);
                    args.setCancel(true);
                    return;
                }
                bidProject2 = supplierInvitation.getDynamicObject("bidproject");
                if (bidProject2 != null && !StringUtils.isEmpty((CharSequence)(tipMessage = SupplierInvitationUtil.invalidTipMessage(bidProject2.getPkValue(), sourceBillId)))) {
                    RefObject afterConfirm = new RefObject();
                    if (!formOperate.getOption().tryGetVariableValue("audit", afterConfirm)) {
                        args.setCancel(true);
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("audit", (IFormPlugin)this);
                        this.getView().showConfirm(tipMessage, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    }
                }
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit")) {
            supplierInvitation = this.service.getSupplierInvitationById((Long)billModel.getDataEntity(true).getPkValue());
            if (supplierInvitation != null) {
                if (SupplierInvitationUtil.existAgainSupplierInvitation(supplierInvitation.getPkValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u65b0\u7684\u589e\u8865\u5165\u56f4\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u539f\u5355\u636e\u3002", (String)"SupplierInvitationEdit_24", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (SupplierInvitationUtil.isAgainSupplierInvitation(supplierInvitation) && (bidProject3 = supplierInvitation.getDynamicObject("bidproject")) != null && SupplierInvitationUtil.checkAgainSupplierInvitationNextBusiness(bidProject3.getPkValue(), supplierInvitation.getPkValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4e0b\u6e38\u4e1a\u52a1\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SupplierInvitationEdit_25", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"tblagaininvitation")) {
            supplierInvitation = this.service.getSupplierInvitationById((Long)billModel.getDataEntity(true).getPkValue());
            if (supplierInvitation != null) {
                boolean existsInvite;
                String checkResult = SupplierInvitationUtil.checkAgainSupplierInvitation(supplierInvitation);
                if (!StringUtils.isEmpty((CharSequence)checkResult)) {
                    this.getView().showTipNotification(checkResult);
                    args.setCancel(true);
                    return;
                }
                Object bidproject = supplierInvitation.getDynamicObject("bidproject").getPkValue();
                boolean flag = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"supplierinvalid", ((Object)((Object)this)).getClass()), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("billstatus", "!=", (Object)"C")});
                if (flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u4f9b\u5e94\u5546\u6dd8\u6c70\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u589e\u8865\u5165\u56f4\u3002", (String)"SupplierInvitationEdit_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String appId4 = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
                boolean exsitBackBid = new ReBackBidUtil(appId4).checkBackBidFinished(bidproject);
                if (exsitBackBid) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u589e\u8865\u5165\u56f4\u3002", (String)"SupplierInvitationEdit_39", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String checkQueryIsProcess = questionClarifyService.checkQueryIsProcess(Long.valueOf(Long.parseLong(bidproject.toString())), appId4);
                if (StringUtils.isNotBlank((CharSequence)checkQueryIsProcess)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)checkQueryIsProcess, (String)"SupplierInvitationEdit_26", (String)"SupplierInvitationEdit_38", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean existFlag = QueryServiceHelper.exists((String)(appId4 + "_bustalk"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("billstatus", "in", (Object)new String[]{"B", "I"})});
                if (existFlag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5904\u4e8e\u5ba1\u6279\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u589e\u8865\u5165\u56f4\u3002", (String)"SupplierInvitationEdit_42", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject[] bustalks = BusinessDataServiceHelper.load((String)(appId4 + "_bustalk"), (String)"id,offerstoptime,createtime", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("openonlinesynergy", "=", (Object)Boolean.TRUE), new QFilter("billstatus", "in", (Object)new String[]{"C"})}, (String)"createtime desc");
                if (bustalks.length > 0 && (existsInvite = QueryServiceHelper.exists((String)(appId4 + "_negotiate_invite"), (QFilter[])new QFilter[]{new QFilter("bustalkid", "=", (Object)((Long)bustalks[0].getPkValue())), new QFilter("status", "in", (Object)new String[]{"B", "I"})}))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5904\u4e8e\u5ba1\u6279\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u589e\u8865\u5165\u56f4\u3002", (String)"SupplierInvitationEdit_43", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getCustomParams().put("iscopy", Boolean.TRUE);
                parameter.getCustomParams().put("isCopyRelateEntity", Boolean.TRUE);
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.setCaption(ResManager.loadKDString((String)"\u589e\u8865\u5165\u56f4", (String)"SupplierInvitationEdit_27", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                parameter.setPkId(this.getModel().getDataEntity().getPkValue());
                parameter.setCustomParam("sourcebillid", (Object)supplierInvitation.getLong("id"));
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"viewhistory") && (supplierInvitation = this.service.getSupplierInvitationById((Long)billModel.getDataEntity(true).getPkValue())) != null) {
            bidProject3 = supplierInvitation.getDynamicObject(this.BID_PROJECT);
            appId = this.getModel().getDataEntityType().getAppId();
            boolean existsHistory = QueryServiceHelper.exists((String)(appId + "_supplierinvitation"), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal()), new QFilter("bidproject", "=", bidProject3.getPkValue())});
            if (!existsHistory) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5386\u53f2\u589e\u8865\u5165\u56f4\u8bb0\u5f55\u3002", (String)"SupplierInvitationEdit_47", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setCustomParam("bidProjectPk", (Object)bidProject3.getPkValue().toString());
            listShowParameter.setMultiSelect(false);
            listShowParameter.setHasRight(true);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4\u8bb0\u5f55", (String)"SupplierInvitationEdit_29", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if ("bid".equals(appId)) {
                listShowParameter.setBillFormId("bid_supplierinvitation_ls");
            } else {
                listShowParameter.setBillFormId("rebm_supplierinvitatio_ls");
            }
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public boolean checkSupplierChange(DynamicObject supplierInvitation) {
        boolean flag = false;
        DynamicObjectCollection sections = this.getModel().getEntryEntity("bidsection");
        if (!CollectionUtils.isEmpty((Collection)sections)) {
            block0: for (DynamicObject section : sections) {
                DynamicObjectCollection supplierEntryList = section.getDynamicObjectCollection("supplierentry");
                for (DynamicObject publishSupplierEntry : supplierEntryList) {
                    boolean invalid = publishSupplierEntry.getBoolean("isnew");
                    if (!invalid) continue;
                    flag = true;
                    continue block0;
                }
            }
        }
        return flag;
    }

    protected void updateInvitationstatus(DynamicObjectCollection bidSectionColl, DynamicObjectCollection bidSectionCollCur) {
        HashMap sendStatusMap = new HashMap();
        bidSectionColl.forEach(bidSection -> {
            DynamicObjectCollection supplierEntry = bidSection.getDynamicObjectCollection("supplierentry");
            String pkValue = bidSection.getPkValue().toString();
            Map<String, String> invitationstatusMap = supplierEntry.stream().collect(Collectors.toMap(item -> pkValue + item.getPkValue(), item -> item.getString("invitationstatus")));
            sendStatusMap.putAll(invitationstatusMap);
        });
        bidSectionCollCur.forEach(bidSection -> {
            DynamicObjectCollection supplierEntry = bidSection.getDynamicObjectCollection("supplierentry");
            String pkValue = bidSection.getPkValue().toString();
            supplierEntry.forEach(entry -> entry.set("invitationstatus", (Object)sendStatusMap.getOrDefault(pkValue + entry.getPkValue(), entry.getString("invitationstatus"))));
        });
        this.getView().updateView("supplierentry");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        OperateOption operateOption;
        super.confirmCallBack(messageBoxClosedEvent);
        if ("newdelete".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue("newdelete", "true");
            this.getView().invokeOperation("newdelete", operateOption);
        }
        if ("submit".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("yqhCheckResult", "1");
            this.getView().invokeOperation("submit");
        }
        if ("audit".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue("audit", "true");
            this.getView().invokeOperation("audit", operateOption);
        }
    }

    public void addInvitation(DynamicObject dataEntity, List<String> unsendSupplierEntryList) {
        QFilter statusFilter;
        QFilter qFilter;
        DynamicObject[] invitationCol;
        Object supplierInvitationId = dataEntity.getPkValue();
        Lang lang = RequestContext.get().getLang();
        String operateName = ResManager.loadKDString((String)"\u53d1\u5e03", (String)"SupplierInvitationEdit_30", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        DynamicObject supplierInvitation = this.service.getSupplierInvitationById((Long)supplierInvitationId);
        DynamicObject bidProject = supplierInvitation.getDynamicObject("bidProject");
        Object bidProjectId = null;
        Object invitationId = null;
        if (bidProject != null && (invitationCol = BusinessDataServiceHelper.load((String)"bid_invitation", (String)"id,status", (QFilter[])new QFilter[]{qFilter = new QFilter("bidproject.id", "=", bidProjectId = bidProject.getPkValue()), statusFilter = new QFilter("status", "=", (Object)"A")}, (String)"createtime desc")) != null && invitationCol.length > 0) {
            invitationId = invitationCol[0].get("id");
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        showParameter.setCustomParam("supplierInvitationId", supplierInvitationId);
        showParameter.setCustomParam("bidProjectId", bidProjectId);
        showParameter.setCustomParam("unsendSupplierEntryList", unsendSupplierEntryList);
        showParameter.setPkId(invitationId);
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd%s", (String)"SupplierInvitationEdit_31", (String)"scm-bid-formplugin", (Object[])new Object[0]), " " + operateName));
        } else {
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd%s", (String)"SupplierInvitationEdit_31", (String)"scm-bid-formplugin", (Object[])new Object[0]), operateName));
        }
        showParameter.setStatus(invitationId == null ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bid_supplierinvitation");
        String pageId = this.getView().getFormShowParameter().getPageId();
        showParameter.setCustomParam("pageId", (Object)pageId);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String fieldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("bid_supplierinvitation".equals(fieldKey)) {
            DynamicObject dataEntity2 = this.getModel().getDataEntity(true);
            DynamicObjectCollection bidSectionColl = dataEntity2.getDynamicObjectCollection("bidsection");
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity(true).getPkValue(), (String)"bid_supplierinvitation");
            DynamicObjectCollection bidSection = dataEntity.getDynamicObjectCollection("bidsection");
            if (bidSection != null && bidSection.size() > 0 && bidSectionColl != null && bidSectionColl.size() > 0) {
                for (int j = 0; j < bidSection.size(); ++j) {
                    for (int m = 0; m < bidSectionColl.size(); ++m) {
                        if (!((DynamicObject)bidSection.get(j)).get("sectionname").equals(((DynamicObject)bidSection.get(m)).get("sectionname"))) continue;
                        DynamicObjectCollection supplierColl = ((DynamicObject)bidSection.get(j)).getDynamicObjectCollection("supplierentry");
                        DynamicObjectCollection supplierEntry = ((DynamicObject)bidSectionColl.get(m)).getDynamicObjectCollection("supplierentry");
                        if (supplierColl == null || supplierColl.size() <= 0 || supplierEntry == null || supplierEntry.size() <= 0) continue;
                        for (int i = 0; i < supplierEntry.size(); ++i) {
                            for (int k = 0; k < supplierColl.size(); ++k) {
                                if (((DynamicObject)supplierEntry.get(i)).getDynamicObject("supplier") == null || ((DynamicObject)supplierColl.get(k)).getDynamicObject("supplier") == null || !((DynamicObject)supplierEntry.get(i)).getDynamicObject("supplier").getPkValue().equals(((DynamicObject)supplierColl.get(k)).getDynamicObject("supplier").getPkValue())) continue;
                                ((DynamicObject)supplierEntry.get(i)).set("invitationstatus", (Object)((DynamicObject)supplierColl.get(k)).getString("invitationstatus"));
                            }
                        }
                    }
                }
            }
            this.getView().updateView("supplierentry");
        } else if (returnData != null && this.ADD_SUPPLIER_ACTION_ID.equals(fieldKey)) {
            this.updateValidSupplierCount();
            this.dealPartnerIsWriter();
        }
    }

    public void dealPartnerIsWriter() {
        Map<String, Boolean> writerMap = this.isWriterMap();
        DynamicObjectCollection sections = this.getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
        for (DynamicObject section : sections) {
            DynamicObjectCollection supplierCollection = section.getDynamicObjectCollection("supplierentry");
            Iterator supplierItertor = supplierCollection.iterator();
            int i = 0;
            while (supplierItertor.hasNext()) {
                DynamicObject row = (DynamicObject)supplierItertor.next();
                String supplierPk = row.getDynamicObject("supplier").getPkValue().toString();
                boolean partLockFlag = writerMap.get(supplierPk);
                this.getView().setEnable(Boolean.valueOf(partLockFlag), i, new String[]{SUPPLIER_ENTRY_F7});
                ++i;
            }
        }
    }

    public Map<String, Boolean> isWriterMap() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        DynamicObjectCollection sections = this.getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
        for (DynamicObject section : sections) {
            DynamicObjectCollection supplierCollection = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierCollection) {
                String supplierPk = row.getDynamicObject("supplier").getPkValue().toString();
                Boolean flag = Boolean.TRUE;
                Boolean supplierPkValue = (Boolean)result.get(supplierPk);
                if (supplierPkValue != null) {
                    flag = (Boolean)result.get(supplierPk);
                }
                if (!flag.booleanValue()) continue;
                String invitationstatus = row.getString("invitationstatus");
                String tenderstatus = row.getString("tenderstatus");
                flag = StringUtils.equals((CharSequence)"UNSEND", (CharSequence)invitationstatus) && StringUtils.equals((CharSequence)",-,", (CharSequence)tenderstatus);
                result.put(supplierPk, flag);
            }
        }
        return result;
    }

    public boolean isEnable() {
        String appId = this.getModel().getDataEntityType().getAppId();
        return SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
    }

    public boolean isInvitation() {
        DynamicObject bidMode;
        DynamicObject bidProject = this.getModel().getDataEntity().getDynamicObject("bidproject");
        return bidProject != null && (bidMode = bidProject.getDynamicObject("bidmode")) != null && !BidModeHelper.isPublicBiddingByModel(bidMode);
    }

    private void insertSupplierEntry(DynamicObjectCollection enrollDetailColls, DynamicObjectCollection sectionDetailColls) {
        Set supplierIdSet = this.getSelectEnrollSupplier();
        for (int i = 0; i < enrollDetailColls.size(); ++i) {
            DynamicObject detail = (DynamicObject)enrollDetailColls.get(i);
            DynamicObject toAddSupplierEntry = detail.getDynamicObject("enrollsupplier");
            if (toAddSupplierEntry == null || supplierIdSet.contains(toAddSupplierEntry.get("id"))) continue;
            DynamicObject supplierEntry = sectionDetailColls.addNew();
            supplierEntry.set("supplier", detail.get("enrollsupplier"));
            supplierEntry.set("suppliercontact", detail.get("enrollsuppliercontact"));
            supplierEntry.set("contactphone", detail.get("enrollcontactphone"));
            supplierEntry.set("suppliercomment", detail.get("enrollsuppliercomment"));
            supplierEntry.set("supplierstatistic", detail.get("enrollsupplierstatistic"));
            supplierEntry.set("email", detail.get("enrollemail"));
            supplierEntry.set("address", detail.get("enrolladdress"));
            supplierEntry.set("fax", detail.get("enrollfax"));
            supplierEntry.set("isnew", (Object)Boolean.TRUE);
            supplierEntry.set("instruction", detail.get("instructionsign"));
            supplierEntry.set("note", detail.get("notesign"));
            DynamicObjectCollection inviteAttachFiles = supplierEntry.getDynamicObjectCollection("inviteattachfile");
            DynamicObjectCollection registerAttachFiles = detail.getDynamicObjectCollection("registerattachfile");
            registerAttachFiles.stream().forEach(item -> {
                DynamicObject inviteAttach = inviteAttachFiles.addNew();
                inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
            });
            supplierEntry.set("isregister", (Object)Boolean.TRUE);
            supplierEntry.set("isrecommend", (Object)Boolean.TRUE);
            supplierEntry.set("announcementid", detail.get("announcement"));
            supplierEntry.set(SUPPLIER_ENTRY_F7, detail.get(SUPPLIER_ENROLL_F7));
        }
        this.getView().updateView("supplierentry");
        this.getView().updateView("supplierenrollentry");
    }

    public Set getSelectEnrollSupplier() {
        HashSet<Object> supplierIdSet = new HashSet<Object>();
        DynamicObject supplierInvitation = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSectionColl = supplierInvitation.getDynamicObjectCollection("bidsection");
        if (bidSectionColl.size() == 1) {
            DynamicObjectCollection supplierEntryColl = ((DynamicObject)bidSectionColl.get(0)).getDynamicObjectCollection("supplierentry");
            for (int i = 0; i < supplierEntryColl.size(); ++i) {
                DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(i);
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null) continue;
                supplierIdSet.add(supplier.get("id"));
            }
        } else {
            EntryGrid bidSection = (EntryGrid)this.getControl("bidsection");
            int[] selects = bidSection.getSelectRows();
            DynamicObjectCollection supplierEntryColl = ((DynamicObject)bidSectionColl.get(selects[0])).getDynamicObjectCollection("supplierentry");
            for (int i = 0; i < supplierEntryColl.size(); ++i) {
                DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(i);
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null) continue;
                supplierIdSet.add(supplier.get("id"));
            }
        }
        return supplierIdSet;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
            return;
        }
        IFormView view = this.getView();
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObject bidProject = data.getDynamicObject("bidproject");
        String appId = this.getModel().getDataEntityType().getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        switch (operateKey) {
            case "audit": {
                DynamicObjectCollection enrollEntry;
                this.setVisibleAgainInvitationButton();
                DynamicObjectCollection entry = this.getModel().getEntryEntity("supplierentry");
                if (entry != null && entry.size() != 0) {
                    for (int i = 0; i < entry.size(); ++i) {
                        this.getModel().setValue("supplierstatistic", ((DynamicObject)entry.get(i)).getDynamicObject("supplierstatistic").getPkValue(), i);
                    }
                }
                if ((enrollEntry = this.getModel().getEntryEntity("supplierenrollentry")) == null || enrollEntry.size() == 0) break;
                for (int i = 0; i < enrollEntry.size(); ++i) {
                    this.getModel().setValue("enrollsupplierstatistic", ((DynamicObject)enrollEntry.get(i)).getDynamicObject("enrollsupplierstatistic").getPkValue(), i);
                }
                break;
            }
            case "unaudit": {
                view.updateView("supplierentry");
                view.updateView("supplierenrollentry");
                if (!BidModeHelper.isPublicBidding(bidProject)) {
                    this.setButtonVisible(true);
                    if (enable) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"addinvitation"});
                    }
                } else {
                    if (enable) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"cancelsupplier", "addsupplierenroll"});
                        this.getView().setVisible(Boolean.FALSE, new String[]{"delsupplier"});
                    }
                    if (this.isInvitation() && this.isEnable()) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"addinvitation"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{"invitationstatus"});
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"invitationstatus"});
                        this.getView().setVisible(Boolean.FALSE, new String[]{"addinvitation"});
                    }
                }
                this.setIsrecommendEnable(data);
                break;
            }
            case "submit": {
                view.updateView("modifier");
                view.updateView("modifytime");
                this.setIsrecommendEnable(data);
                this.getView().updateView("supplierentry");
                this.getView().setVisible(Boolean.FALSE, new String[]{"cancelsupplier", "addsupplierenroll"});
                break;
            }
            case "unsubmit": {
                if (!enable) break;
                if (!BidModeHelper.isPublicBidding(bidProject)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"addinvitation"});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"cancelsupplier", "addsupplierenroll"});
                break;
            }
            case "save": {
                if (this.isInvitation() && this.isEnable()) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"addinvitation"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"invitationstatus"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"invitationstatus"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"addinvitation"});
                }
                this.setIsrecommendEnable(data);
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_del", "bar_submit", "baritemap1", "baritemap"});
                this.getView().updateView("supplierentry");
                Object invitationId = null;
                if (bidProject != null) {
                    QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProject.getLong("id"));
                    QFilter statusFilter = new QFilter("status", "=", (Object)"A");
                    DynamicObject invitation = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()), (String)"id,status", (QFilter[])new QFilter[]{qFilter, statusFilter});
                    if (invitation != null) {
                        invitationId = invitation.get("id");
                    }
                }
                String needDeleteIds = this.getPageCache().get(needDeleteInvitationSupplierIds);
                if (invitationId != null && needDeleteIds != null) {
                    DynamicObject invitation = BusinessDataServiceHelper.loadSingle(invitationId, (String)FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
                    DynamicObjectCollection supplierentry = invitation.getDynamicObjectCollection("supplierentry");
                    Iterator it1 = supplierentry.iterator();
                    while (it1.hasNext()) {
                        String[] split;
                        DynamicObject delOne = (DynamicObject)it1.next();
                        DynamicObject supplier = delOne.getDynamicObject("supplier");
                        if (supplier == null || needDeleteIds == null) continue;
                        for (String splitItem : split = needDeleteIds.split("#")) {
                            if (!splitItem.equals(supplier.getPkValue().toString())) continue;
                            it1.remove();
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invitation});
                    this.getPageCache().remove(needDeleteInvitationSupplierIds);
                }
                if (!SupplierInvitationUtil.isAgainSupplierInvitation(data)) break;
                String bidProjectName = data.get("bidproject.name").toString();
                String sourceBillId = data.getString("sourcebillid");
                DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"bid_supplierinvitation");
                if (sourceBill == null) break;
                sourceBill.set("listprojectname", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u4fee\u8ba2\u4e2d\uff09", (String)"SupplierInvitationEdit_32", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidProjectName));
                SaveServiceHelper.update((DynamicObject)sourceBill);
                break;
            }
            case "deleteentry": {
                this.updateValidSupplierCount();
                String invIdStr = this.getPageCache().get("invIds");
                if (StringUtils.isEmpty((CharSequence)invIdStr)) break;
                String[] invIdArray = invIdStr.split("##");
                ArrayList<Long> invIdList = new ArrayList<Long>();
                if (invIdArray == null || invIdStr.length() <= 0) break;
                for (String idStr : invIdArray) {
                    invIdList.add(Long.valueOf(idStr));
                }
                DeleteServiceHelper.delete((String)"bid_invitation", (QFilter[])new QFilter[]{new QFilter("id", "in", invIdList)});
                break;
            }
            case "deletesupplierentry": {
                this.updateValidSupplierCount();
                break;
            }
            case "undoinvitation": {
                this.getView().invokeOperation("refresh");
            }
        }
        this.updateBackCroundColour();
    }

    protected void setIsrecommendEnable(DynamicObject dataEntity) {
        DynamicObject bidMode;
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        if (bidProject != null && (bidMode = bidProject.getDynamicObject("bidmode")) != null && BidModeHelper.isPublicBiddingByModel(bidMode)) {
            DynamicObjectCollection sectionColl = dataEntity.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < sectionColl.size(); ++i) {
                DynamicObjectCollection entry = ((DynamicObject)sectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < entry.size(); ++j) {
                    this.getView().setEnable(Boolean.FALSE, j, new String[]{"isrecommend"});
                }
            }
        }
    }

    private void invitationView(DynamicObject dataEntity) {
        QFilter statusFilter;
        QFilter qFilter;
        DynamicObjectCollection invitationColl;
        Object supplierInvitationId = dataEntity.getPkValue();
        String operateName = ResManager.loadKDString((String)"\u67e5\u770b", (String)"SupplierInvitationEdit_33", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        OperationStatus operateStattus = OperationStatus.VIEW;
        DynamicObject supplierInvitation = this.service.getSupplierInvitationById((Long)supplierInvitationId);
        DynamicObject bidProject = supplierInvitation.getDynamicObject("bidProject");
        Object bidProjectId = null;
        Object invitationId = null;
        if (bidProject != null && (invitationColl = QueryServiceHelper.query((String)"bid_invitation", (String)"id,status", (QFilter[])new QFilter[]{qFilter = new QFilter("bidproject.id", "=", bidProjectId = bidProject.getPkValue()), statusFilter = new QFilter("status", "=", (Object)"B")}, (String)"publishdate desc")) != null && invitationColl.size() > 0) {
            invitationId = ((DynamicObject)invitationColl.get(0)).get("id");
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("supplierInvitationId", supplierInvitationId);
        showParameter.setCustomParam("bidProjectId", bidProjectId);
        showParameter.setPkId(invitationId);
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd%s", (String)"SupplierInvitationEdit_31", (String)"scm-bid-formplugin", (Object[])new Object[0]), operateName));
        showParameter.setStatus(operateStattus);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (BillStatusEnum.AUDITED.getVal().equals(billStatus) || BillStatusEnum.SUBMIT.getVal().equals(billStatus) || BillStatusEnum.AUDITING.getVal().equals(billStatus) || BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            this.getModel().setDataChanged(false);
        }
    }

    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("bidsection");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid enrollEntryGrid = (EntryGrid)this.getView().getControl("bidenrollsection");
        enrollEntryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid supplierEntryGrid = (EntryGrid)this.getView().getControl("supplierentry");
        supplierEntryGrid.addCellClickListener((CellClickListener)this);
        EntryGrid supplierEnrollEntryGrid = (EntryGrid)this.getView().getControl("supplierenrollentry");
        supplierEnrollEntryGrid.addCellClickListener((CellClickListener)this);
        this.registerF7Listener(SUPPLIER_ENTRY_F7);
        this.registerF7Listener(SUPPLIER_ENROLL_F7);
        BasedataEdit supplierCtrl = (BasedataEdit)this.getView().getControl("supplier");
        if (supplierCtrl != null) {
            supplierCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void registerF7Listener(String f7Name) {
        Control control = this.getView().getControl(f7Name);
        if (control != null && BasedataEdit.class.isInstance(control)) {
            ((BasedataEdit)control).addBeforeF7SelectListener((BeforeF7SelectListener)this);
            ((BasedataEdit)control).addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    @Override
    public void entryRowClick(RowClickEvent rowclickevent) {
        super.entryRowClick(rowclickevent);
        EntryGrid entryGrid = (EntryGrid)rowclickevent.getSource();
        if ("bidsection".equals(entryGrid.getKey())) {
            int rowIndex = rowclickevent.getRow();
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidenrollsection");
            entryEntityGrid.selectRows(rowIndex, true);
            DynamicObject data = this.getModel().getDataEntity(true);
            this.setIsrecommendEnable(data);
        } else if ("bidenrollsection".equals(entryGrid.getKey())) {
            int rowIndex = rowclickevent.getRow();
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidsection");
            entryEntityGrid.selectRows(rowIndex, true);
        } else if ("supplierentry".equals(entryGrid.getKey())) {
            int rowIndex = rowclickevent.getRow();
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidsection");
            entryEntityGrid.selectRows(rowIndex, true);
        }
    }

    @Override
    public String getBillId() {
        return FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass());
    }

    @Override
    protected boolean needHandleSupplier() {
        return true;
    }

    @Override
    protected boolean needContact() {
        return true;
    }

    @Override
    protected boolean needSupplierStatisticInfo() {
        return true;
    }

    @Override
    protected boolean needFlagNewSupplier() {
        return true;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)SUPPLIER_ENTRY_F7)) {
            this.helper.dealBeforeF7Select(this, arg0);
        }
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        String appId = this.getModel().getDataEntityType().getAppId();
        if ("rebm".equals(appId)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            showParameter.setCustomParam("selectorgId", org.getPkValue());
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"supplier")) {
            int sectionRow;
            EntryGrid supplierEntryGrid;
            IDataModel supplierEntryOperate;
            DynamicObject supplierEntry;
            String supplierSelectCache = this.getPageCache().get("supplierSelectCache");
            if ("1".equals(supplierSelectCache)) {
                this.getPageCache().put("supplierSelectCache", "0");
                return;
            }
            DynamicObject supplier = (DynamicObject)arg0.getOriginalValue();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            if (supplier != null && (supplierEntry = (supplierEntryOperate = (supplierEntryGrid = (EntryGrid)this.getView().getControl("supplierentry")).getModel()).getEntryRowEntity("supplierentry", sectionRow = supplierEntryOperate.getEntryCurrentRowIndex("supplierentry"))) != null) {
                String invitationStatus = supplierEntry.getString("invitationstatus");
                if ("UNSEND".equals(invitationStatus)) {
                    DynamicObject[] invitationData;
                    DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
                    if (bidProject != null && (invitationData = BusinessDataServiceHelper.load((String)(appId + "_invitation"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("supplierentry.supplier.id", "=", supplier.getPkValue()), new QFilter("status", "not in", (Object)new String[]{"XX", "X"})})) != null && invitationData.length > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f53\u4f9b\u5e94\u5546\u5206\u5f55\u7684\u9080\u8bf7\u51fd\u72b6\u6001\u4e3a\u672a\u53d1\u9001\u4e14\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\u5173\u8054\u7684\u9080\u8bf7\u51fd\uff0c\u624d\u5141\u8bb8\u4fee\u6539\u4f9b\u5e94\u5546\u540d\u79f0\uff0c\u5426\u5219\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SupplierInvitationEdit_44", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        this.getPageCache().put("supplierSelectCache", "1");
                        arg0.setCancel(true);
                        return;
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f53\u4f9b\u5e94\u5546\u5206\u5f55\u7684\u9080\u8bf7\u51fd\u72b6\u6001\u4e3a\u672a\u53d1\u9001\u4e14\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\u5173\u8054\u7684\u9080\u8bf7\u51fd\uff0c\u624d\u5141\u8bb8\u4fee\u6539\u4f9b\u5e94\u5546\u540d\u79f0\uff0c\u5426\u5219\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SupplierInvitationEdit_44", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    this.getPageCache().put("supplierSelectCache", "1");
                    arg0.setCancel(true);
                    return;
                }
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        BasedataEdit source = (BasedataEdit)afterF7SelectEvent.getSource();
        String fieldKey = source.getFieldKey();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)SUPPLIER_ENTRY_F7)) {
            this.helper.dealAfterF7Select(this, afterF7SelectEvent);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newVal = changeData.getNewValue();
        Object oldVal = changeData.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "isrecommend": {
                this.updateValidSupplierCount();
                break;
            }
        }
    }
}

