/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.auxiliary;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PublicProjectPartner
extends AbstractBillPlugIn
implements RowClickEventListener {
    public static final String PAR_BID_SECTION = "bidsection";
    public static final String SUPPLIER_ENTRY = "supplierentry";
    public static final String PAGE_CACHE_PRIX = "PARTNER";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid fakeSectionGrid = (EntryGrid)this.getView().getControl(PAR_BID_SECTION);
        fakeSectionGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String sourId = this.getModel().getDataEntity(true).get("sourcepublish").toString();
        Object sourcePublishId = this.getView().getFormShowParameter().getCustomParam("sourcePublishId");
        String operateStatus = this.getView().getFormShowParameter().getStatus().name();
        if (sourcePublishId != null && operateStatus.equals("ADDNEW") && !sourId.equals("0")) {
            sourcePublishId = this.getView().getFormShowParameter().getCustomParam("sourcePublishId");
            DynamicObject bidProject = this.getModel().getDataEntity(true).getDynamicObject("bidproject");
            String appID = bidProject.getString("entitytypeid").split("_")[0];
            if (sourcePublishId != null) {
                this.firstSetRepublicPartner(Long.parseLong(sourcePublishId.toString()), appID);
            }
        }
    }

    public void firstSetRepublicPartner(Long prvPublicLong, String appId) {
        String supplier;
        DynamicObjectCollection supplierentry;
        StringBuilder formId = new StringBuilder();
        formId.append(appId).append("_bidpublish");
        DynamicObject oldPublic = BusinessDataServiceHelper.loadSingle((Object)prvPublicLong, (String)formId.toString());
        HashMap<String, DynamicObject> supplierMap = new HashMap<String, DynamicObject>();
        DynamicObjectCollection bidsections = oldPublic.getDynamicObjectCollection(PAR_BID_SECTION);
        for (DynamicObject bidSectionNext : bidsections) {
            supplierentry = bidSectionNext.getDynamicObjectCollection(SUPPLIER_ENTRY);
            for (DynamicObject entryNext : supplierentry) {
                supplier = entryNext.getDynamicObject("supplier").getPkValue().toString();
                DynamicObject partner = entryNext.getDynamicObject("projectpartner");
                supplierMap.put(supplier, partner);
            }
        }
        bidsections = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION);
        for (DynamicObject bidSectionNext : bidsections) {
            supplierentry = bidSectionNext.getDynamicObjectCollection(SUPPLIER_ENTRY);
            for (DynamicObject entryNext : supplierentry) {
                supplier = entryNext.getDynamicObject("supplier").getPkValue().toString();
                DynamicObject object = (DynamicObject)supplierMap.get(supplier);
                entryNext.set("projectpartner", (Object)object);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String field = e.getProperty().getName();
        if (!field.equals("projectpartner")) {
            return;
        }
        DynamicObjectCollection supplierEntryColl = this.getModel().getEntryEntity(SUPPLIER_ENTRY);
        if (supplierEntryColl == null || supplierEntryColl.isEmpty()) {
            return;
        }
        DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(e.getChangeSet()[0].getRowIndex());
        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
        if (supplier == null) {
            return;
        }
        String supplierId = supplier.getPkValue().toString();
        StringBuilder key = new StringBuilder();
        String value = "PARTNER_" + supplierId;
        key.append(value);
        DynamicObject projectpartner = supplierEntry.getDynamicObject("projectpartner");
        if (projectpartner == null) {
            this.getView().getPageCache().put("removepartner", supplierId);
            ChangeData cd = e.getChangeSet()[0];
            DynamicObject oldVal = (DynamicObject)cd.getOldValue();
            if (oldVal != null) {
                this.getPageCache().put(key.toString(), oldVal.getPkValue().toString());
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("removepartner", (IFormPlugin)this);
            String message = ResManager.loadKDString((String)"\u5220\u9664\u540e\u8be5\u7528\u6237\u5c06\u65e0\u6cd5\u53c2\u4e0e\u540e\u7eed\u6295\u6807\u73af\u8282\uff0c\u786e\u8ba4\u5220\u9664\u5417\uff1f", (String)"PublicProjectPartner_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, confirmCallBacks);
        } else {
            this.getPageCache().put(key.toString(), projectpartner.getPkValue().toString());
        }
        EntryGrid sectionGrid = (EntryGrid)this.getControl(PAR_BID_SECTION);
        int[] selects = sectionGrid.getSelectRows();
        this.setTenderStrategyEditable(selects[0]);
    }

    public void entryRowClick(RowClickEvent rowclickevent) {
        EntryGrid entryGrid = (EntryGrid)rowclickevent.getSource();
        String key = entryGrid.getKey();
        if (!PAR_BID_SECTION.equals(key)) {
            return;
        }
        int rowIndex = rowclickevent.getRow();
        if (rowIndex <= -1) {
            return;
        }
        this.updateEntity();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if ("removepartner".equals(fieldKey)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String supplierId = this.getView().getPageCache().get("removepartner");
                StringBuilder key = new StringBuilder();
                String value = "PARTNER_" + supplierId;
                key.append(value);
                this.getView().getPageCache().put(key.toString(), "0");
            }
            this.getView().getPageCache().put("removepartner", "0");
            this.updateEntity();
        }
    }

    public void updateEntity() {
        HashMap<String, DynamicObject> supplierUser = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> idAdmint = new HashMap<String, DynamicObject>();
        DynamicObjectCollection sections = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION);
        for (DynamicObject section : sections) {
            DynamicObjectCollection supplierCollection = section.getDynamicObjectCollection(SUPPLIER_ENTRY);
            for (DynamicObject row : supplierCollection) {
                DynamicObject modify;
                if (row.getDynamicObject("supplier") == null) continue;
                String supplierPk = row.getDynamicObject("supplier").getPkValue().toString();
                StringBuilder key = new StringBuilder();
                String value = "PARTNER_" + supplierPk;
                key.append(value);
                String cachePk = this.getPageCache().get(key.toString());
                if (StringUtils.isBlank((CharSequence)cachePk)) continue;
                if (!supplierUser.containsKey(supplierPk) || !idAdmint.containsKey(supplierPk)) {
                    if (cachePk.equals("0")) {
                        QFilter manageFile;
                        DynamicObject bizpartner = row.getDynamicObject("supplier").getDynamicObject("bizpartner");
                        QFilter partnerFile = new QFilter("bizpartner", "=", bizpartner.getPkValue());
                        DynamicObject[] bos_bizpartnerusers = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"user", (QFilter[])new QFilter[]{partnerFile, manageFile = new QFilter("isadmin", "=", (Object)"1")});
                        if (bos_bizpartnerusers != null && bos_bizpartnerusers.length > 0) {
                            DynamicObject user = bos_bizpartnerusers[0].getDynamicObject("user");
                            idAdmint.put(supplierPk, user);
                        }
                    } else {
                        DynamicObject bosUser = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(cachePk), (String)"bos_user");
                        supplierUser.put(supplierPk, bosUser);
                    }
                }
                if ((modify = (DynamicObject)supplierUser.get(supplierPk)) != null) {
                    this.updateRow(row, modify);
                    continue;
                }
                modify = (DynamicObject)idAdmint.get(supplierPk);
                this.updateRowByAdmint(row, modify);
            }
        }
        EntryGrid sectionGrid = (EntryGrid)this.getControl(PAR_BID_SECTION);
        int[] selects = sectionGrid.getSelectRows();
        this.setTenderStrategyEditable(selects[0]);
        this.getView().updateView(SUPPLIER_ENTRY);
    }

    public void updateRow(DynamicObject row, DynamicObject newUser) {
        DynamicObject projectpartner = row.getDynamicObject("projectpartner");
        if (projectpartner == null && newUser == null) {
            return;
        }
        if (projectpartner == null && newUser != null) {
            row.set("projectpartner", (Object)newUser);
            row.set("suppliercontact", (Object)new LocaleString(newUser.getString("name")));
            row.set("contactphone", (Object)newUser.getString("phone"));
            return;
        }
        if (projectpartner != null && newUser == null) {
            row.set("projectpartner", (Object)newUser);
            return;
        }
        if (projectpartner != null && newUser != null && projectpartner.getPkValue().toString().equals(newUser.getPkValue().toString())) {
            return;
        }
        row.set("projectpartner", (Object)newUser);
        row.set("suppliercontact", (Object)new LocaleString(newUser.getString("name")));
        row.set("contactphone", (Object)newUser.getString("phone"));
    }

    public void updateRowByAdmint(DynamicObject row, DynamicObject newUser) {
        row.set("projectpartner", null);
        row.set("suppliercontact", (Object)new LocaleString(newUser.getString("name")));
        row.set("contactphone", (Object)newUser.getString("phone"));
    }

    public boolean isMulBidSection() {
        return this.getView().getModel().getDataEntity(true).getDynamicObject("bidproject").getBoolean("enablemultisection");
    }

    public void setTenderStrategyEditable(int row) {
        DynamicObjectCollection sectionColl = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION);
        for (int i = 0; i < sectionColl.size(); ++i) {
            if (i != row) continue;
            DynamicObjectCollection supplierEntryColl = ((DynamicObject)sectionColl.get(i)).getDynamicObjectCollection(SUPPLIER_ENTRY);
            for (int j = 0; j < supplierEntryColl.size(); ++j) {
                DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                this.getView().setEnable(Boolean.FALSE, new String[]{"tenderstrategy"});
                String tenderStatus = supplierEntry.getString("tenderstatus");
                if (!StringUtils.isEmpty((CharSequence)tenderStatus)) {
                    if (tenderStatus.equals("PRETENDERED")) {
                        this.getView().setEnable(Boolean.FALSE, j, new String[]{"tenderstrategy"});
                        continue;
                    }
                    this.getView().setEnable(Boolean.TRUE, j, new String[]{"tenderstrategy"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, j, new String[]{"tenderstrategy"});
            }
        }
    }
}

