/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.bidcenter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.BizLog;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bidcenter.IBidCenterService;
import kd.scm.bid.business.bidcenter.impl.BidCenterServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.bidcenter.BidCenterConstant;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.RespBusiness;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.formplugin.bill.bidcenter.BidCenterJSUtil;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;

public class BidCenterEdit
extends AbstractFormPlugin
implements TabSelectListener {
    private IBidCenterService bidCenterService = new BidCenterServiceImpl();
    private BidCenterConstant bidCenterConstant = new BidCenterConstant();
    public static final String STEP_ANSWER_FLAG = "answ";
    public static final String STEP_OPEN_FLAG = "open";
    public static final String STEP_ONEV_FLAG = "onev";
    public static final String STEP_EVAL_FLAG = "eval";
    public static final String STEP_BUSTALK_FLAG = "bustalk";
    public static final String KEY_COMM_FLAG = "comm";
    public static final String KEY_TECH_FLAG = "tech";
    public static final String SEPARATION_CHARACTER = "_";
    public static final String FIRST_FROM_LIST_OP = "first_from_list_op";
    public static final String MAIN_FLEX_PANEL = "mainflexpanel";
    public static final String NEED_REFRESH = "need_refresh";
    public static final String ALL_TABAP_FLEX = "all_tabap_flex";
    public static final String ANSWERQUESTION_TABAP = "answerquestion_tabap";
    public static final String BIDOPEN_TABAP = "bidopen_tabap";
    public static final String ONLINEEVALUATION_TABAP = "onlineevaluation_tabap";
    public static final String BIDEVALUATION_TABAP = "bidevaluation_tabap";
    public static final String BIDBUSTALK_TABAP = "bidbustalk_tabap";
    public static final String ONEV_COMMBEFORE_SONTAB = "onev_commbefore_sontab";
    public static final String ONEV_TECH_SONTAB = "onev_tech_sontab";
    public static final String ONEV_COMMAFTER_SONTAB = "onev_commafter_sontab";
    public static final String EVAL_COMMBEFORE_SONTAB = "eval_commbefore_sontab";
    public static final String EVAL_TECH_SONTAB = "eval_tech_sontab";
    public static final String EVAL_COMMAFTER_SONTAB = "eval_commafter_sontab";

    public void registerListener(EventObject e) {
        Tab answerquestion_tabap = (Tab)this.getView().getControl(ANSWERQUESTION_TABAP);
        Tab bidopen_tabap = (Tab)this.getView().getControl(BIDOPEN_TABAP);
        Tab onlineevaluation_tabap = (Tab)this.getView().getControl(ONLINEEVALUATION_TABAP);
        Tab bidevaluation_tabap = (Tab)this.getView().getControl(BIDEVALUATION_TABAP);
        Tab bidbustalk_tabap = (Tab)this.getView().getControl(BIDBUSTALK_TABAP);
        answerquestion_tabap.addTabSelectListener((TabSelectListener)this);
        bidopen_tabap.addTabSelectListener((TabSelectListener)this);
        onlineevaluation_tabap.addTabSelectListener((TabSelectListener)this);
        bidevaluation_tabap.addTabSelectListener((TabSelectListener)this);
        bidbustalk_tabap.addTabSelectListener((TabSelectListener)this);
    }

    public void createDynamicTabAp_answerQuestion(Long bidProjectId) {
        DynamicObject[] answerQuestionReco;
        Tab answerTab = (Tab)this.getView().getControl(ANSWERQUESTION_TABAP);
        String ANSWERTABSIZE = "answerTabSize";
        String size = this.getPageCache().get(ANSWERTABSIZE);
        if (StringUtils.isNotEmpty((CharSequence)size)) {
            int answerTabSize = Integer.parseInt(size);
            for (int i = 0; i < answerTabSize; ++i) {
                answerTab.deleteControls(new String[]{"answ_" + i});
            }
        }
        if ((answerQuestionReco = this.bidCenterService.getAnswerQuestionRecobybidprojectid((Object)bidProjectId)) != null && answerQuestionReco.length > 0) {
            int length = answerQuestionReco.length;
            this.getPageCache().put(ANSWERTABSIZE, String.valueOf(length));
            ArrayList<Map> items = new ArrayList<Map>(length);
            for (int i = 0; i < length; ++i) {
                DynamicObject answerQuestion = answerQuestionReco[i];
                String pkValue = answerQuestion.getPkValue().toString();
                String keyPage = "answ_" + i;
                this.getPageCache().put(keyPage, keyPage);
                String keyReal = "answ_" + pkValue + SEPARATION_CHARACTER + answerQuestion.getString("billstatus");
                this.getPageCache().put(STEP_ANSWER_FLAG + i, keyReal);
                TabPageAp tpa = BidCenterJSUtil.createTabPageAp(keyPage, pkValue, String.format(ResManager.loadKDString((String)"\u7b2c%1$s%2$s", (String)"BidCenterEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), length - i, ResManager.loadKDString((String)"\u6b21\u7b54\u7591", (String)"BidCenterEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0])));
                items.add(tpa.createControl());
            }
            answerTab.addControls(items);
        }
    }

    public boolean checkOpPermission(String permisionCode, DynamicObject entity, String formId) {
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        long orgId = (Long)entity.getDynamicObject("org").getPkValue();
        boolean orgHasPermission = PermissionUtils.checkPermission(permisionCode, orgId, appId, formId);
        DynamicObject entrustmentorgunit = entity.getDynamicObject("entrustmentorgunit");
        if (entrustmentorgunit == null) {
            return orgHasPermission;
        }
        Long entrustmentorgunitId = (Long)entrustmentorgunit.getPkValue();
        boolean entrustmentorgHasPermission = PermissionUtils.checkPermission(permisionCode, entrustmentorgunitId, appId, formId);
        return orgHasPermission || entrustmentorgHasPermission;
    }

    public void createDynamicTabAp_bidBustalk(Long bidProjectId) {
        DynamicObject[] bidBustalkReco;
        Tab answerTab = (Tab)this.getView().getControl(BIDBUSTALK_TABAP);
        String BIDBUSTALKSIZE = "bidbustalksize";
        String size = this.getPageCache().get(BIDBUSTALKSIZE);
        if (StringUtils.isNotEmpty((CharSequence)size)) {
            int answerTabSize = Integer.parseInt(size);
            for (int i = 0; i < answerTabSize; ++i) {
                answerTab.deleteControls(new String[]{"bustalk_" + i});
            }
        }
        if ((bidBustalkReco = this.bidCenterService.getBidBustalkRecobybidprojectid((Object)bidProjectId)) != null && bidBustalkReco.length > 0) {
            int length = bidBustalkReco.length;
            this.getPageCache().put(BIDBUSTALKSIZE, String.valueOf(length));
            ArrayList<Map> items = new ArrayList<Map>(10);
            for (int i = 0; i < length; ++i) {
                DynamicObject bidBustalk = bidBustalkReco[i];
                String pkValue = bidBustalk.getPkValue().toString();
                String keyPage = "bustalk_" + i;
                this.getPageCache().put(keyPage, keyPage);
                String keyReal = "bustalk_" + pkValue + SEPARATION_CHARACTER + bidBustalk.getString("billstatus");
                this.getPageCache().put(STEP_BUSTALK_FLAG + i, keyReal);
                TabPageAp tpa = null;
                tpa = length - i == 1 ? BidCenterJSUtil.createTabPageAp(keyPage, pkValue, ResManager.loadKDString((String)"\u9996\u8f6e\u8c08\u5224", (String)"BidCenterEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0])) : BidCenterJSUtil.createTabPageAp(keyPage, pkValue, String.format(ResManager.loadKDString((String)"\u7b2c%1$s%2$s", (String)"BidCenterEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), length - i, ResManager.loadKDString((String)"\u8f6e\u8c08\u5224", (String)"BidCenterEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0])));
                items.add(tpa.createControl());
            }
            answerTab.addControls(items);
        }
    }

    public void tabSelected(TabSelectEvent arg0) {
        String fieldkey = arg0.getTabKey();
        if (StringUtils.isEmpty((CharSequence)fieldkey)) {
            return;
        }
        DynamicObject bidProject = this.getModel().getDataEntity();
        Object bidProjectId = bidProject.getPkValue();
        String bidopentype = bidProject.getString("bidopentype");
        if (fieldkey.contains(STEP_ANSWER_FLAG)) {
            String mark_q = fieldkey.split(SEPARATION_CHARACTER)[0];
            String mark_i = fieldkey.split(SEPARATION_CHARACTER)[1];
            String realKey = this.getPageCache().get(mark_q + mark_i);
            String pkId = realKey.split(SEPARATION_CHARACTER)[1];
            String billStatus = realKey.split(SEPARATION_CHARACTER)[2];
            String formId = FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass());
            this.openMainFrom(formId, pkId, billStatus, "bidanswerquestion");
        } else if (fieldkey.contains(STEP_OPEN_FLAG)) {
            this.tabSelected_ByOpen(fieldkey, bidProjectId, bidopentype);
        } else if (fieldkey.contains(STEP_ONEV_FLAG)) {
            this.tabSelected_ByOnev(fieldkey, bidProjectId);
        } else if (fieldkey.contains(STEP_EVAL_FLAG)) {
            this.tabSelected_ByEval(fieldkey, bidProjectId);
        } else if (fieldkey.contains(STEP_BUSTALK_FLAG)) {
            String mark_q = fieldkey.split(SEPARATION_CHARACTER)[0];
            String mark_i = fieldkey.split(SEPARATION_CHARACTER)[1];
            String realKey = this.getPageCache().get(mark_q + mark_i);
            String pkId = realKey.split(SEPARATION_CHARACTER)[1];
            String billStatus = realKey.split(SEPARATION_CHARACTER)[2];
            String formId = FormTypeConstants.getFormConstant((String)STEP_BUSTALK_FLAG, ((Object)((Object)this)).getClass());
            this.openMainFrom(formId, pkId, billStatus, "bidbustalk");
        }
    }

    public void tabSelected_ByOpen(String fieldkey, Object bidProjectId, String bidopentype) {
        String formId = FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass());
        DynamicObject open = null;
        Tab opentab = (Tab)this.getView().getControl(BIDOPEN_TABAP);
        String lastOpenTab = this.getPageCache().get("lastOpenTab");
        if (fieldkey.contains(KEY_COMM_FLAG)) {
            Boolean checkCanBusinessOpen = this.bidCenterService.checkCanBusinessOpen(bidProjectId, bidopentype);
            if (!checkCanBusinessOpen.booleanValue()) {
                if (StringUtils.isNotEmpty((CharSequence)lastOpenTab)) {
                    opentab.activeTab("open_tech_sontab");
                }
                this.getView().showTipNotification(this.bidCenterConstant.CAN_NOT_BUSINESS_OPEN_TIP);
                return;
            }
            open = this.bidCenterService.getCommOpenDataByBidId(bidProjectId, null);
        } else if (fieldkey.contains(KEY_TECH_FLAG)) {
            Boolean checkCanTechnicalOpen = this.bidCenterService.checkCanTechnicalOpen(bidProjectId, bidopentype);
            if (!checkCanTechnicalOpen.booleanValue()) {
                if (StringUtils.isNotEmpty((CharSequence)lastOpenTab)) {
                    opentab.activeTab("open_comm_sontab");
                }
                this.getView().showTipNotification(this.bidCenterConstant.CAN_NOT_TECHNICAL_OPEN_TIP);
                return;
            }
            open = this.bidCenterService.getTechOpenDataByBidId(bidProjectId, null);
        }
        this.getPageCache().put("lastOpenTab", fieldkey);
        if (open != null) {
            this.openMainFrom(formId, open.getPkValue(), open.getString("billstatus"), "bidopen");
        }
    }

    public void tabSelected_ByEval(String fieldkey, Object bidProjectId) {
        String formId = FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass());
        DynamicObject eval = null;
        Tab eavltab = (Tab)this.getView().getControl(BIDEVALUATION_TABAP);
        String lastEvalTab = this.getPageCache().get("lastEvalTab");
        if (fieldkey.contains(KEY_COMM_FLAG)) {
            eval = this.bidCenterService.getCommEvalDataByBidId(bidProjectId, null);
        } else if (fieldkey.contains(KEY_TECH_FLAG)) {
            eval = this.bidCenterService.getTechEvalDataByBidId(bidProjectId, null);
        }
        this.getPageCache().put("lastEvalTab", fieldkey);
        if (eval != null) {
            this.openMainFrom(formId, eval.getPkValue(), eval.getString("billstatus"), "bidevaluation");
        }
    }

    public void tabSelected_ByOnev(String fieldkey, Object bidProjectId) {
        QFilter bidFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter typeFilter = null;
        if (fieldkey.contains(KEY_COMM_FLAG)) {
            typeFilter = new QFilter("evaltype", "=", (Object)"BUSSINESS");
        } else if (fieldkey.contains(KEY_TECH_FLAG)) {
            typeFilter = new QFilter("evaltype", "=", (Object)"TECHNICAL");
        }
        RequestContext context = RequestContext.get();
        String userId = context.getUserId();
        Long bidProjectIdLong = Long.parseLong(bidProjectId.toString());
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        boolean adminFlag = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        QFilter qFilter_eval = new QFilter("bidproject.id", "=", bidProjectId);
        if (!adminFlag) {
            QFilter proficientFilter = this.getProficientFilter(bidProjectIdLong);
            QFilter directorOrAppraiserFilter = this.getDirectorOrAppraiserFilter(bidProjectIdLong);
            qFilter_eval = directorOrAppraiserFilter != null ? proficientFilter.or(directorOrAppraiserFilter) : proficientFilter;
        }
        String bidOnlineBidEvalFormId = FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass());
        DynamicObject[] evalDatas = BusinessDataServiceHelper.load((String)bidOnlineBidEvalFormId, (String)"id,org,billstatus,evaltype", (QFilter[])new QFilter[]{typeFilter, qFilter_eval});
        this.openOnlineEvalFrom(evalDatas, bidFilter.and(typeFilter), Long.parseLong(bidProjectId.toString()));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject mainData = this.getModel().getDataEntity();
        Object pkId = mainData.getPkValue();
        String firstFromListFlag = this.getPageCache().get(FIRST_FROM_LIST_OP);
        if (StringUtils.isEmpty((CharSequence)firstFromListFlag)) {
            this.getPageCache().put(FIRST_FROM_LIST_OP, "true");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String operateKey = (String)formShowParameter.getCustomParam("opKeyFromList");
            if (StringUtils.isEmpty((CharSequence)operateKey)) {
                operateKey = "bidproject";
            }
            this.doBidProcessOp(operateKey);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String viewCache;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if ("bidanswerquestion".equals(key)) {
            String viewCache2 = this.getView().getPageCache().get("dy");
            BizLog.log((String)"dayi==bidanswerquestion==7");
            if ("0".equals(viewCache2)) {
                BizLog.log((String)"dayi==bidanswerquestion==8");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u7b54\u7591\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if ("bidbustalk".equals(key) && "0".equals(viewCache = this.getView().getPageCache().get("swtp"))) {
            BizLog.log((String)"dayi==bidanswerquestion==9");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u5546\u52a1\u8c08\u5224\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String opKey;
        Object newVal;
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        String fieldKey = e.getProperty().getName();
        if (fieldKey.equals("exitmark") && ((Boolean)(newVal = (Boolean)cd.getNewValue())).booleanValue()) {
            this.getView().close();
        }
        if (fieldKey.equals("markcurrent") && StringUtils.isNotEmpty((CharSequence)(newVal = cd.getNewValue().toString()))) {
            opKey = ((String)newVal).split("#")[0];
            this.doBidProcessOp(opKey);
        }
        if (fieldKey.equals("refreshmark") && StringUtils.isNotEmpty((CharSequence)(newVal = cd.getNewValue().toString()))) {
            opKey = ((String)newVal).split("#")[0];
            IFormView view = this.getView();
            DynamicObject bidProject = this.getModel().getDataEntity();
            Object bidProjectId = bidProject.getPkValue();
            BidCenterJSUtil.clickCurrentOp(view, opKey, Long.parseLong(bidProjectId.toString()), ((Object)((Object)this)).getClass());
            BidCenterJSUtil.activeFlexPanel(view, opKey);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperationResult opResult = args.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        String operateKey = formOperate.getOperateKey();
        boolean isAnswer = StringUtils.equals((CharSequence)"bidanswerquestion", (CharSequence)operateKey);
        if (isAnswer) {
            QFilter bidFilter;
            DynamicObject bidProject = this.getModel().getDataEntity();
            Object bidProjectId = bidProject.getPkValue();
            String formId = FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass());
            Boolean haveAnswerDataReco = QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{bidFilter = new QFilter("bidproject.id", "=", bidProjectId)});
            if (haveAnswerDataReco.booleanValue()) {
                this.doBidProcessOp(operateKey);
            } else {
                Boolean checkOpPermision = this.checkOpPermission("QXX0002", bidProject, formId);
                if (!checkOpPermision.booleanValue()) {
                    this.getView().showErrorNotification(this.bidCenterConstant.ADD_ANSWER_TIP);
                    return;
                }
                HashMap<String, String> recoEditMap = new HashMap<String, String>();
                recoEditMap.put("formId", formId);
                FormShowParameter recoEditPara = FormShowParameter.createFormShowParameter(recoEditMap);
                recoEditPara.setStatus(OperationStatus.ADDNEW);
                recoEditPara.setCustomParam("bidproject", bidProjectId);
                recoEditPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newanswer"));
                OpenStyle openStyle = recoEditPara.getOpenStyle();
                openStyle.setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(recoEditPara);
            }
        } else {
            this.doBidProcessOp(operateKey);
        }
    }

    public void doBidProcessOp(String operateKey) {
        if (BidCenterConstant.OPKEY_FLEX_MAP.containsKey(operateKey)) {
            this.getModel().setValue("exitmark", (Object)Boolean.FALSE);
            this.openMainFromByBidProcess(operateKey);
        }
    }

    public void openMainFromByBidProcess(String operateKey) {
        String formId = BidCenterConstant.getFormIdByOPKey((String)operateKey, ((Object)((Object)this)).getClass());
        DynamicObject bidProject = this.getModel().getDataEntity();
        Long bidProjectId = (Long)bidProject.getPkValue();
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidopentype,billstatus");
        String bidopentype = bidProject.getString("bidopentype");
        String bidbillstatus = bidProject.getString("billstatus");
        switch (operateKey) {
            case "bidproject": {
                this.openMainFrom(formId, bidProjectId, bidbillstatus, operateKey);
                break;
            }
            case "biddocument": {
                DynamicObject documentForm;
                if ("X".equals(bidbillstatus)) {
                    QFilter parentFilter = new QFilter("parent", "=", (Object)0);
                    documentForm = this.bidCenterService.getSingleFormByBidProjectIdCurrent(formId, "id,billstatus", (Object)bidProjectId, parentFilter);
                } else {
                    HashSet<String> status = new HashSet<String>();
                    status.add("J");
                    status.add("X");
                    status.add("XX");
                    QFilter billstatusFilter = new QFilter("billstatus", "not in", status);
                    documentForm = this.bidCenterService.getSingleFormByBidProjectIdCurrent(formId, "id,billstatus", (Object)bidProjectId, billstatusFilter);
                }
                this.openMainFrom(formId, documentForm.getPkValue(), documentForm.getString("billstatus"), operateKey);
                break;
            }
            case "bidpublish": {
                DynamicObject publishForm;
                if ("X".equals(bidbillstatus)) {
                    QFilter sourcepublishFilter = new QFilter("sourcepublish", "=", (Object)0L);
                    publishForm = this.bidCenterService.getSingleFormByBidProjectIdCurrent(formId, "id,billstatus", (Object)bidProjectId, sourcepublishFilter);
                } else {
                    HashSet<String> status = new HashSet<String>();
                    status.add("J");
                    status.add("X");
                    QFilter billstatusFilter = new QFilter("billstatus", "not in", status);
                    publishForm = this.bidCenterService.getSingleFormByBidProjectIdCurrent(formId, "id,billstatus", (Object)bidProjectId, billstatusFilter);
                }
                this.openMainFrom(formId, publishForm.getPkValue(), publishForm.getString("billstatus"), operateKey);
                break;
            }
            case "bidanswerquestion": {
                this.createDynamicTabAp_answerQuestion(Long.parseLong(bidProjectId.toString()));
                DynamicObject lastestRecoArr = this.bidCenterService.getLastestAnswerQuestionRecobybidprojectid((Object)bidProjectId);
                if (lastestRecoArr == null) break;
                this.openMainFrom(FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass()), lastestRecoArr.getPkValue(), lastestRecoArr.getString("billstatus"), operateKey);
                break;
            }
            case "bidbustalk": {
                this.createDynamicTabAp_bidBustalk(Long.parseLong(bidProjectId.toString()));
                DynamicObject lastestBustalk = this.bidCenterService.getLastestBidBustalkRecobybidprojectid((Object)bidProjectId);
                if (lastestBustalk == null) break;
                this.openMainFrom(formId, lastestBustalk.getPkValue(), lastestBustalk.getString("billstatus"), operateKey);
                break;
            }
            case "bidopen": {
                if (StringUtils.isNotBlank((CharSequence)bidopentype) && !BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype)) {
                    this.create_Open_TapByRespbusiness(Long.parseLong(bidProjectId.toString()), bidopentype);
                    break;
                }
                DynamicObject open = this.bidCenterService.getSingleFormByBidProjectId(formId, "id,billstatus", (Object)bidProjectId);
                if (open == null) {
                    open = this.bidCenterService.getSingleFormHisByBidProjectId(formId, "id,billstatus", (Object)bidProjectId);
                }
                this.openMainFrom(formId, open.getPkValue(), open.getString("billstatus"), operateKey);
                break;
            }
            case "onlineevaluation": {
                this.create_OnlineEval_TapByRespbusiness(bidProjectId, bidopentype);
                break;
            }
            case "bidevaluation": {
                if (StringUtils.isNotBlank((CharSequence)bidopentype) && !BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype)) {
                    this.create_Eval_TapByRespbusiness(bidProjectId, bidopentype);
                    break;
                }
                DynamicObject eval = this.bidCenterService.getSingleFormByBidProjectId(formId, "id,billstatus", (Object)bidProjectId);
                if (eval == null) {
                    eval = this.bidCenterService.getSingleFormHisByBidProjectId(formId, "id,billstatus", (Object)bidProjectId);
                }
                this.openMainFrom(formId, eval.getPkValue(), eval.getString("billstatus"), operateKey);
                break;
            }
            case "bidclarificaiton": {
                DynamicObject clarificaiton = this.bidCenterService.getSingleFormByBidProjectId(formId, "id,billstatus", (Object)bidProjectId);
                this.openMainFrom(formId, clarificaiton.getPkValue(), clarificaiton.getString("billstatus"), operateKey);
                break;
            }
            case "bidbottommake": {
                DynamicObject bidBottomMake = this.bidCenterService.getSingleFormByBidProjectId(formId, "id,billstatus", (Object)bidProjectId);
                this.openMainFrom(formId, bidBottomMake.getPkValue(), bidBottomMake.getString("billstatus"), operateKey);
                break;
            }
            default: {
                DynamicObject singleForm = this.bidCenterService.getSingleFormByBidProjectIdCurrent(formId, "id,billstatus", (Object)bidProjectId);
                this.openMainFrom(formId, singleForm.getPkValue(), singleForm.getString("billstatus"), operateKey);
            }
        }
    }

    public void create_Open_TapByRespbusiness(Long bidProjectId, String bidopentype) {
        Tab opentab;
        Boolean isTriggering;
        String respbusiness;
        boolean isdirector;
        RequestContext context = RequestContext.get();
        String userId = context.getUserId();
        Boolean isOne = Boolean.FALSE;
        String oneKey = null;
        DynamicObject permissionMember = this.bidCenterService.getPermissionMember((Object)userId, (Object)bidProjectId, RespBusiness.BidOpen.getVal());
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        if (!(isAdmin || permissionMember == null || (isdirector = permissionMember.getBoolean("isdirector")) || (respbusiness = permissionMember.getString("respbusiness")).contains(RespBusiness.TechnicalOpen.getVal()) && respbusiness.contains(RespBusiness.BusinessOpen.getVal()))) {
            if (respbusiness.contains(RespBusiness.TechnicalOpen.getVal())) {
                isOne = Boolean.TRUE;
                oneKey = KEY_TECH_FLAG;
            } else if (respbusiness.contains(RespBusiness.BusinessOpen.getVal())) {
                isOne = Boolean.TRUE;
                oneKey = KEY_COMM_FLAG;
            }
        }
        if (!(isTriggering = BidCenterJSUtil.createOpenTap(opentab = (Tab)this.getView().getControl(BIDOPEN_TABAP), bidopentype, isOne, oneKey)).booleanValue()) {
            opentab.selectTab(opentab.getCurrentTab());
        }
    }

    public void create_Eval_TapByRespbusiness(Long bidProjectId, String bidopentype) {
        Tab evalTab;
        Boolean isTriggering;
        String respbusiness;
        boolean isdirector;
        RequestContext context = RequestContext.get();
        String userId = context.getUserId();
        Boolean isOne = Boolean.FALSE;
        String oneKey = null;
        DynamicObject permissionMember = this.bidCenterService.getPermissionMember((Object)userId, (Object)bidProjectId, RespBusiness.BidEvaluation.getVal());
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        if (!(isAdmin || permissionMember == null || (isdirector = permissionMember.getBoolean("isdirector")) || (respbusiness = permissionMember.getString("respbusiness")).contains(RespBusiness.BusinessEval.getVal()) && respbusiness.contains(RespBusiness.TechnicalEval.getVal()))) {
            if (respbusiness.contains(RespBusiness.TechnicalEval.getVal())) {
                isOne = Boolean.TRUE;
                oneKey = KEY_TECH_FLAG;
            } else if (respbusiness.contains(RespBusiness.BusinessEval.getVal())) {
                isOne = Boolean.TRUE;
                oneKey = KEY_COMM_FLAG;
            }
        }
        if (!isOne.booleanValue()) {
            DynamicObject techEvalData = this.bidCenterService.getTechEvalDataByBidId((Object)bidProjectId, null);
            DynamicObject commEvalData = this.bidCenterService.getCommEvalDataByBidId((Object)bidProjectId, null);
            if (techEvalData != null && commEvalData == null) {
                isOne = Boolean.TRUE;
                oneKey = KEY_TECH_FLAG;
            }
            if (commEvalData != null && techEvalData == null) {
                isOne = Boolean.TRUE;
                oneKey = KEY_COMM_FLAG;
            }
        }
        if (!(isTriggering = BidCenterJSUtil.createEvalTap(evalTab = (Tab)this.getView().getControl(BIDEVALUATION_TABAP), bidopentype, isOne, oneKey)).booleanValue()) {
            evalTab.selectTab(evalTab.getCurrentTab());
        }
    }

    public void create_OnlineEval_TapByRespbusiness(Long bidProjectId, String bidopentype) {
        RequestContext context = RequestContext.get();
        String userId = context.getUserId();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        QFilter qFilter_eval = new QFilter("bidproject.id", "=", (Object)bidProjectId);
        if (!isAdmin) {
            QFilter proficientFilter = this.getProficientFilter(bidProjectId);
            QFilter directorOrAppraiserFilter = this.getDirectorOrAppraiserFilter(bidProjectId);
            qFilter_eval = directorOrAppraiserFilter != null ? proficientFilter.or(directorOrAppraiserFilter) : proficientFilter;
        }
        String entityName = FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass());
        qFilter_eval = qFilter_eval.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()));
        DynamicObject[] evalDatas = BusinessDataServiceHelper.load((String)entityName, (String)"id,billstatus,evaltype", (QFilter[])new QFilter[]{qFilter_eval});
        if (BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype)) {
            if (evalDatas.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u5728\u7ebf\u8bc4\u6807\u73af\u8282\u3002", (String)"BidCenterEdit_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openOnlineEvalFrom(evalDatas, qFilter_eval, bidProjectId);
            return;
        }
        Boolean commKey = Boolean.FALSE;
        Boolean techKey = Boolean.FALSE;
        for (DynamicObject evalData : evalDatas) {
            if ("BUSSINESS".equals(evalData.getString("evaltype"))) {
                commKey = Boolean.TRUE;
            }
            if (!"TECHNICAL".equals(evalData.getString("evaltype"))) continue;
            techKey = Boolean.TRUE;
        }
        Boolean isOne = Boolean.FALSE;
        String oneKey = null;
        if (commKey.booleanValue() && techKey.booleanValue()) {
            isOne = Boolean.FALSE;
            oneKey = null;
        } else if (commKey.booleanValue()) {
            isOne = Boolean.TRUE;
            oneKey = KEY_COMM_FLAG;
        } else if (techKey.booleanValue()) {
            isOne = Boolean.TRUE;
            oneKey = KEY_TECH_FLAG;
        }
        Tab evalTab = (Tab)this.getView().getControl(ONLINEEVALUATION_TABAP);
        Boolean isTriggering = BidCenterJSUtil.createOnlineEvalTap(evalTab, bidopentype, isOne, oneKey);
        if (!isTriggering.booleanValue()) {
            evalTab.selectTab(evalTab.getCurrentTab());
        }
    }

    public void openOnlineEvalFrom(DynamicObject[] evalDatas, QFilter qFilter_eval, Long bidProjectId) {
        String formId = FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass());
        int length = evalDatas.length;
        if (length > 1) {
            String orderBys = "createtime desc";
            ListFilterParameter listFilterParameter = this.getListFilterParameter(qFilter_eval, orderBys);
            this.synOpenList(formId, bidProjectId, listFilterParameter, "onlineevaluation");
            return;
        }
        DynamicObject evalData = evalDatas[0];
        this.openMainFrom(formId, evalData.getPkValue(), evalData.getString("billstatus"), "onlineevaluation");
    }

    public ListFilterParameter getListFilterParameter(QFilter qFilter, String orderBys) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        if (StringUtils.isEmpty((CharSequence)orderBys)) {
            orderBys = "createtime desc";
        }
        ListFilterParameter listFilterParameter = new ListFilterParameter(qFilters, orderBys);
        return listFilterParameter;
    }

    public void synOpenList(String formId, Long bidProjectId, ListFilterParameter listFilterParameter, String operateKey) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setMultiSelect(false);
        listShowParameter.setCustomParam("BidCenter", (Object)"BidCenter");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeOpen"));
        OpenStyle openStyle = listShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(MAIN_FLEX_PANEL);
        listShowParameter.setHasRight(true);
        listShowParameter.setCustomParam("bidProjectId", (Object)bidProjectId);
        listShowParameter.setBillFormId(formId);
        listShowParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)listShowParameter);
        this.getPageCache().put("lastFromId", formId);
        this.getPageCache().put("lastPkId", null);
        this.getPageCache().put("lastPageId", listShowParameter.getPageId());
        this.controlProcess(operateKey);
    }

    public void controlProcess(String operateKey) {
        IFormView view = this.getView();
        DynamicObject bidProject = this.getModel().getDataEntity();
        Long bidProjectId = (Long)bidProject.getPkValue();
        BidCenterJSUtil.clickCurrentOp(view, operateKey, bidProjectId, ((Object)((Object)this)).getClass());
        BidCenterJSUtil.activeFlexPanel(view, operateKey);
        this.controlAllTabFlex(operateKey);
    }

    public void openMainFrom(String formId, Object pkId, String billStatus, String operateKey) {
        block7: {
            String lastFromId = this.getPageCache().get("lastFromId");
            String lastPkId = this.getPageCache().get("lastPkId");
            String lastPageId = this.getPageCache().get("lastPageId");
            if (formId.equals(lastFromId) && pkId.toString().equals(lastPkId)) {
                return;
            }
            this.getPageCache().put("currentFromId", formId);
            this.getPageCache().put("currentPkId", pkId.toString());
            this.getPageCache().put("currentBillStatus", billStatus);
            this.getPageCache().put("currentOperateKey", operateKey);
            if (StringUtils.isNotEmpty((CharSequence)lastPageId)) {
                IFormView subPageView = this.getView().getView(lastPageId);
                if (subPageView != null) {
                    try {
                        subPageView.close();
                        if ("rebm_supplierinvitation".equals(formId)) {
                            this.synOpenFrom(formId, pkId, billStatus, operateKey);
                            break block7;
                        }
                        this.getView().sendFormAction(subPageView);
                    }
                    catch (Exception e) {
                        BizLog.log((String)e.getMessage());
                    }
                }
            } else {
                this.synOpenFrom(formId, pkId, billStatus, operateKey);
            }
        }
    }

    public void synOpenFrom(String formId, Object pkId, String billStatus, String operateKey) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setCustomParam("BidCenter", (Object)"BidCenter");
        showParameter.setCustomParam("operateKey", (Object)operateKey);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeOpen"));
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(MAIN_FLEX_PANEL);
        showParameter.setOpenStyle(openStyle);
        showParameter.setPkId(pkId);
        showParameter.setFormId(formId);
        showParameter.setHasRight(true);
        Boolean haveOpPermission = this.checkOpPermission("QXX0003", formId);
        if (haveOpPermission.booleanValue()) {
            showParameter.setStatus(this.convertOperationStatus(billStatus));
            showParameter.setBillStatus(this.convertBillOperationStatus(billStatus));
        } else {
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setBillStatus(BillOperationStatus.VIEW);
        }
        this.getView().showForm((FormShowParameter)showParameter);
        this.getPageCache().put("lastFromId", formId);
        this.getPageCache().put("lastPkId", pkId.toString());
        this.getPageCache().put("lastPageId", showParameter.getPageId());
        this.controlProcess(operateKey);
    }

    public boolean checkOpPermission(String permisionCode, String formId) {
        DynamicObject entity = this.getModel().getDataEntity();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        long orgId = (Long)entity.getDynamicObject("org").getPkValue();
        boolean orgHasPermission = PermissionUtils.checkPermission(permisionCode, orgId, appId, formId);
        DynamicObject entrustmentorgunit = entity.getDynamicObject("entrustmentorgunit");
        if (entrustmentorgunit == null) {
            return orgHasPermission;
        }
        Long entrustmentorgunitId = (Long)entrustmentorgunit.getPkValue();
        boolean entrustmentorgHasPermission = PermissionUtils.checkPermission(permisionCode, entrustmentorgunitId, appId, formId);
        return orgHasPermission || entrustmentorgHasPermission;
    }

    public OperationStatus convertOperationStatus(String value) {
        if (BillStatusEnum.INVALID.getVal().equals(value)) {
            return OperationStatus.VIEW;
        }
        if (BillStatusEnum.INVALIDXX.getVal().equals(value)) {
            return OperationStatus.VIEW;
        }
        return OperationStatus.EDIT;
    }

    public BillOperationStatus convertBillOperationStatus(String value) {
        if (BillStatusEnum.SAVE.getVal().equals(value) || BillStatusEnum.DISBEGIN.getVal().equals(value)) {
            return BillOperationStatus.EDIT;
        }
        if (BillStatusEnum.SUBMIT.getVal().equals(value)) {
            return BillOperationStatus.SUBMIT;
        }
        if (BillStatusEnum.AUDITED.getVal().equals(value)) {
            return BillOperationStatus.AUDIT;
        }
        if (BillStatusEnum.INVALID.getVal().equals(value)) {
            return BillOperationStatus.VIEW;
        }
        if (BillStatusEnum.PUBLISHED.getVal().equals(value)) {
            return BillOperationStatus.VIEW;
        }
        if (BillStatusEnum.ADJUSTING.getVal().equals(value)) {
            return BillOperationStatus.VIEW;
        }
        if (BillStatusEnum.INVALIDXX.getVal().equals(value)) {
            return BillOperationStatus.VIEW;
        }
        return BillOperationStatus.EDIT;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("newanswer".equals(actionId)) {
            DynamicObject bidProject = this.getModel().getDataEntity();
            Long bidProjectId = (Long)bidProject.getPkValue();
            String formId = FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass());
            QFilter bidFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
            Boolean haveAnswerDataReco = QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{bidFilter});
            if (haveAnswerDataReco.booleanValue()) {
                this.doBidProcessOp("bidanswerquestion");
            }
            return;
        }
        boolean exitmark = this.getModel().getDataEntity().getBoolean("exitmark");
        if (exitmark) {
            this.getView().close();
            return;
        }
        if ("closeOpen".equals(actionId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MAIN_FLEX_PANEL});
            String currentFromId = this.getPageCache().get("currentFromId");
            String id = this.getPageCache().get("currentPkId");
            if (StringUtils.isEmpty((CharSequence)id)) {
                return;
            }
            String reBackBid = this.getPageCache().get("reBackBid");
            if (StringUtils.isNotBlank((CharSequence)reBackBid)) {
                this.getView().close();
            } else {
                Long currentPkId = Long.parseLong(id);
                String currentBillStatus = this.getPageCache().get("currentBillStatus");
                String operateKey = this.getPageCache().get("currentOperateKey");
                this.synOpenFrom(currentFromId, currentPkId, currentBillStatus, operateKey);
            }
        }
    }

    public void controlAllTabFlex(String operateKey) {
        this.getView().setVisible(Boolean.FALSE, new String[]{ALL_TABAP_FLEX, ANSWERQUESTION_TABAP, BIDOPEN_TABAP, ONLINEEVALUATION_TABAP, BIDEVALUATION_TABAP, BIDBUSTALK_TABAP});
        DynamicObject bidProject = this.getModel().getDataEntity();
        String bidopentype = bidProject.getString("bidopentype");
        switch (operateKey) {
            case "bidanswerquestion": {
                this.getView().setVisible(Boolean.TRUE, new String[]{ALL_TABAP_FLEX, ANSWERQUESTION_TABAP});
                break;
            }
            case "bidopen": {
                if (BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype)) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{ALL_TABAP_FLEX, BIDOPEN_TABAP});
                break;
            }
            case "onlineevaluation": {
                if (BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype)) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{ALL_TABAP_FLEX, ONLINEEVALUATION_TABAP});
                break;
            }
            case "bidevaluation": {
                if (BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype)) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{ALL_TABAP_FLEX, BIDEVALUATION_TABAP});
                break;
            }
            case "bidbustalk": {
                this.getView().setVisible(Boolean.TRUE, new String[]{ALL_TABAP_FLEX, BIDBUSTALK_TABAP});
                break;
            }
            default: {
                this.getView().setVisible(Boolean.FALSE, new String[]{ALL_TABAP_FLEX});
            }
        }
    }

    public String getBidAdminRoleID() {
        return "/FFXFSRKI73+";
    }

    public QFilter getProficientFilter(Long bidProjectId) {
        QFilter bidFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        QFilter filter = new QFilter("bidevaluator.proficientname.id", "=", (Object)userId);
        return bidFilter.and(filter);
    }

    public QFilter getDirectorOrAppraiserFilter(Long bidProjectId) {
        QFilter bidFilter = new QFilter("bidproject", "=", (Object)bidProjectId);
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        QFilter qFilter = new QFilter("user", "=", (Object)userId);
        String bidProjectMemberFormId = FormTypeConstants.getFormConstant((String)"memberentity", ((Object)((Object)this)).getClass());
        DynamicObject member = BusinessDataServiceHelper.loadSingle((String)bidProjectMemberFormId, (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter, bidFilter});
        DynamicObject leader = BusinessDataServiceHelper.loadSingle((String)"bid_leadermemberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter, bidFilter});
        QFilter qFilter_eval = null;
        if (member != null) {
            boolean isdirector = member.getBoolean("isdirector");
            if (isdirector) {
                qFilter_eval = bidFilter;
            } else {
                String respbusiness = member.getString("respbusiness");
                if (respbusiness.contains(RespBusiness.BidEvaluation.getVal())) {
                    qFilter_eval = bidFilter;
                } else if (respbusiness.contains(RespBusiness.TechnicalEval.getVal()) && respbusiness.contains(RespBusiness.BusinessEval.getVal())) {
                    qFilter_eval = bidFilter;
                } else if (respbusiness.contains(RespBusiness.TechnicalEval.getVal())) {
                    qFilter_eval = new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()).and(bidFilter);
                } else if (respbusiness.contains(RespBusiness.BusinessEval.getVal())) {
                    qFilter_eval = new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()).and(bidFilter);
                }
            }
        }
        if (leader != null) {
            String respbusiness = leader.getString("respbusiness");
            if (respbusiness.contains(RespBusiness.BidEvaluation.getVal())) {
                qFilter_eval = bidFilter;
            } else if (respbusiness.contains(RespBusiness.TechnicalEval.getVal()) && respbusiness.contains(RespBusiness.BusinessEval.getVal())) {
                qFilter_eval = bidFilter;
            } else if (respbusiness.contains(RespBusiness.TechnicalEval.getVal())) {
                qFilter_eval = new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()).and(bidFilter);
            } else if (respbusiness.contains(RespBusiness.BusinessEval.getVal())) {
                qFilter_eval = new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()).and(bidFilter);
            }
        }
        return qFilter_eval;
    }
}

