/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.bidcenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Image;
import kd.bos.lang.Lang;
import kd.bos.logging.BizLog;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bidcenter.IBidCenterService;
import kd.scm.bid.business.bidcenter.impl.BidCenterServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.bidcenter.BidCenterConstant;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.formplugin.bill.util.BidProjectProcessUtil;

public class BidCenterJSUtil {
    private static IBidCenterService bidCenterService = new BidCenterServiceImpl();
    public static final String OPEN_COMM_SONTAB = "open_comm_sontab";
    public static final String OPEN_TECH_SONTAB = "open_tech_sontab";
    public static final String EVAL_COMM_SONTAB = "eval_comm_sontab";
    public static final String EVAL_TECH_SONTAB = "eval_tech_sontab";
    public static final String ONEV_COMM_SONTAB = "onev_comm_sontab";
    public static final String ONEV_TECH_SONTAB = "onev_tech_sontab";
    public static final String[] FLEX_KEYS = new String[]{"flex_bidproject", "flex_biddocument", "flex_supplierinvitation", "flex_bidpublish", "flex_bidanswerquestion", "flex_bidopen", "flex_onbidevaluation", "flex_bidevaluation", "flex_bidbustalk", "flex_biddecision", "flex_bidclarificaiton", "flex_bidbottommake"};
    public String NAME_COMM_FLAG = ResManager.loadKDString((String)"\u5546\u52a1\u6807", (String)"BidCenterJSUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);
    public String NAME_TECH_FLAG = ResManager.loadKDString((String)"\u6280\u672f\u6807", (String)"BidCenterJSUtil_1", (String)"scm-bid-formplugin", (Object[])new Object[0]);
    public static final String NAME_COMM_FLAG_US = "commercial bid";
    public static final String NAME_TECH_FLAG_US = "technical bid";
    public static final String ACTIVE_FLEX_FLAG = "activeflexflag";
    private static final String IMAGE_PATH = "/icons/pc/other/";
    private static final String IMAGE_ACTIVE_BGP = "white_bg.png";
    private static final String IMAGE_UNACTIVE_BGP = "blued_bg.png";
    private static final String IMAGE_ZBLX_Y_XZ = "zblx_40_40.png";
    private static final String IMAGE_BSBZ_Y_XZ = "bsbz_40_40.png";
    private static final String IMAGE_GFRW_Y_XZ = "gfrw_40_40.png";
    private static final String IMAGE_FB_Y_XZ = "fb_40_40.png";
    private static final String IMAGE_DY_Y_XZ = "dy_40_40.png";
    private static final String IMAGE_KB_Y_XZ = "kb_40_40.png";
    private static final String IMAGE_ZXPB_Y_XZ = "zxpb_40_40.png";
    private static final String IMAGE_PB_Y_XZ = "pb_40_40.png";
    private static final String IMAGE_SWTP_Y_XZ = "swtp_40_40.png";
    private static final String IMAGE_DB_Y_XZ = "db_40_40.png";
    private static final String IMAGE_ZBJD_Y_XZ = "db_40_40.png";
    private static final String IMAGE_BDBZ_Y_XZ = "pb_40_40.png";
    protected static final Map<String, String> OPKEY_IMAGEYXZ_MAP = new HashMap<String, String>(){
        {
            this.put("bidproject", BidCenterJSUtil.IMAGE_ZBLX_Y_XZ);
            this.put("biddocument", BidCenterJSUtil.IMAGE_BSBZ_Y_XZ);
            this.put("supplierinvitation", BidCenterJSUtil.IMAGE_GFRW_Y_XZ);
            this.put("bidpublish", BidCenterJSUtil.IMAGE_FB_Y_XZ);
            this.put("bidanswerquestion", BidCenterJSUtil.IMAGE_DY_Y_XZ);
            this.put("bidopen", BidCenterJSUtil.IMAGE_KB_Y_XZ);
            this.put("onlineevaluation", BidCenterJSUtil.IMAGE_ZXPB_Y_XZ);
            this.put("bidevaluation", "pb_40_40.png");
            this.put("bidbustalk", BidCenterJSUtil.IMAGE_SWTP_Y_XZ);
            this.put("biddecision", "db_40_40.png");
            this.put("bidclarificaiton", "db_40_40.png");
            this.put("bidbottommake", "pb_40_40.png");
        }
    };
    private static final String IMAGE_ZBLX_Y_WXZ = "zblxxz_40_40.png";
    private static final String IMAGE_BSBZ_Y_WXZ = "bsbzxz_40_40.png";
    private static final String IMAGE_GFRW_Y_WXZ = "gfrwxz_40_40.png";
    private static final String IMAGE_FB_Y_WXZ = "fbxz_40_40.png";
    private static final String IMAGE_DY_Y_WXZ = "dyxz_40_40.png";
    private static final String IMAGE_KB_Y_WXZ = "kbxz_40_40.png";
    private static final String IMAGE_ZXPB_Y_WXZ = "zxpbxz_40_40.png";
    private static final String IMAGE_PB_Y_WXZ = "pbxz_40_40.png";
    private static final String IMAGE_SWTP_Y_WXZ = "swtpxz_40_40.png";
    private static final String IMAGE_DB_Y_WXZ = "dbxz_40_40.png";
    private static final String IMAGE_ZBJD_Y_WXZ = "dbxz_40_40.png";
    private static final String IMAGE_BDBZ_Y_WXZ = "pbxz_40_40.png";
    private static final String IMAGE_ZBLX_W = "zblxwxz_40_40.png";
    private static final String IMAGE_BSBZ_W = "bsbzwxz_40_40.png";
    private static final String IMAGE_GFRW_W = "gfrwwxz_40_40.png";
    private static final String IMAGE_FB_W = "fbwxz_40_40.png";
    private static final String IMAGE_DY_W = "dywxz_40_40.png";
    private static final String IMAGE_KB_W = "kbwxz.png";
    private static final String IMAGE_ZXPB_W = "zxpbwxz_40_40.png";
    private static final String IMAGE_PB_W = "pbwxz_40_40.png";
    private static final String IMAGE_SWTP_W = "swtpwxz_40_40.png";
    private static final String IMAGE_DB_W = "dbwxz_40_40.png";
    private static final String IMAGE_ZBJD_W = "dbwxz_40_40.png";
    private static final String IMAGE_BDBZ_W = "pbwxz_40_40.png";
    public static final String IMAGE_KEY_ZBLX = "zblx";
    public static final String IMAGE_KEY_BSBZ = "bsbz";
    public static final String IMAGE_KEY_GFRW = "gfrw";
    public static final String IMAGE_KEY_FB = "fb";
    public static final String IMAGE_KEY_DY = "dy";
    public static final String IMAGE_KEY_KB = "kb";
    public static final String IMAGE_KEY_ZXPB = "zxpb";
    public static final String IMAGE_KEY_PB = "pb";
    public static final String IMAGE_KEY_SWTP = "swtp";
    public static final String IMAGE_KEY_DB = "db";
    public static final String IMAGE_KEY_ZBJD = "zbjd";
    public static final String IMAGE_KEY_BDBZ = "bdbz";
    protected static final BidStepEnum[] BID_STEP_KEYS = new BidStepEnum[]{BidStepEnum.BidDocument, BidStepEnum.SupplierInvitation, BidStepEnum.BidPublish, BidStepEnum.BidOpen, BidStepEnum.BidEvaluation, BidStepEnum.BidDecision};
    protected static final String[] IMAGE_FLEX_KEYS = new String[]{"flex_biddocument", "flex_supplierinvitation", "flex_bidpublish", "flex_bidopen", "flex_bidevaluation", "flex_biddecision", "flex_bidclarificaiton", "flex_bidbottommake"};
    protected static final String[] IMAGE_Y_WXZ_KEYS = new String[]{"bsbzxz_40_40.png", "gfrwxz_40_40.png", "fbxz_40_40.png", "kbxz_40_40.png", "pbxz_40_40.png", "dbxz_40_40.png", "dbxz_40_40.png", "pbxz_40_40.png"};
    protected static final String[] IMAGE_W_KEYS = new String[]{"bsbzwxz_40_40.png", "gfrwwxz_40_40.png", "fbwxz_40_40.png", "kbwxz.png", "pbwxz_40_40.png", "dbwxz_40_40.png", "dbwxz_40_40.png", "pbwxz_40_40.png"};
    protected static final String[] IMAGE_KEYS = new String[]{"bsbz", "gfrw", "fb", "kb", "pb", "db", "zbjd", "bdbz"};
    protected static final Map<String, String> OPKEY_IMAGEKEY_MAP = new HashMap<String, String>(){
        {
            this.put("bidproject", BidCenterJSUtil.IMAGE_KEY_ZBLX);
            this.put("biddocument", BidCenterJSUtil.IMAGE_KEY_BSBZ);
            this.put("supplierinvitation", BidCenterJSUtil.IMAGE_KEY_GFRW);
            this.put("bidpublish", BidCenterJSUtil.IMAGE_KEY_FB);
            this.put("bidanswerquestion", BidCenterJSUtil.IMAGE_KEY_DY);
            this.put("bidopen", BidCenterJSUtil.IMAGE_KEY_KB);
            this.put("onlineevaluation", BidCenterJSUtil.IMAGE_KEY_ZXPB);
            this.put("bidevaluation", BidCenterJSUtil.IMAGE_KEY_PB);
            this.put("bidbustalk", BidCenterJSUtil.IMAGE_KEY_SWTP);
            this.put("biddecision", BidCenterJSUtil.IMAGE_KEY_DB);
            this.put("bidclarificaiton", BidCenterJSUtil.IMAGE_KEY_ZBJD);
            this.put("bidbottommake", BidCenterJSUtil.IMAGE_KEY_BDBZ);
        }
    };

    public static TabPageAp createTabPageAp(String key, String id, String name) {
        TabPageAp tpa = new TabPageAp();
        tpa.setKey(key);
        tpa.setId(id);
        tpa.setName(new LocaleString(name));
        return tpa;
    }

    public static Boolean createOpenTap(Tab opentab, String bidopentype, Boolean isOne, String oneKey) {
        Boolean isTriggering = Boolean.FALSE;
        opentab.deleteControls(new String[]{OPEN_COMM_SONTAB, OPEN_TECH_SONTAB});
        String currentTab = opentab.getCurrentTab();
        ArrayList<Map> commTabAp = new ArrayList<Map>();
        ArrayList<Map> techTabAp = new ArrayList<Map>();
        Lang lang = RequestContext.get().getLang();
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            TabPageAp commtpa = BidCenterJSUtil.createTabPageAp(OPEN_COMM_SONTAB, OPEN_COMM_SONTAB, NAME_COMM_FLAG_US);
            TabPageAp techtpa = BidCenterJSUtil.createTabPageAp(OPEN_TECH_SONTAB, OPEN_TECH_SONTAB, NAME_TECH_FLAG_US);
            commTabAp.add(commtpa.createControl());
            techTabAp.add(techtpa.createControl());
        } else {
            BidCenterJSUtil bidCenterJSUtil = new BidCenterJSUtil();
            TabPageAp commtpa = BidCenterJSUtil.createTabPageAp(OPEN_COMM_SONTAB, OPEN_COMM_SONTAB, bidCenterJSUtil.NAME_COMM_FLAG);
            TabPageAp techtpa = BidCenterJSUtil.createTabPageAp(OPEN_TECH_SONTAB, OPEN_TECH_SONTAB, bidCenterJSUtil.NAME_TECH_FLAG);
            commTabAp.add(commtpa.createControl());
            techTabAp.add(techtpa.createControl());
        }
        if (isOne.booleanValue()) {
            if (OPEN_COMM_SONTAB.contains(oneKey)) {
                opentab.addControls(commTabAp);
                if (!OPEN_COMM_SONTAB.equals(currentTab)) {
                    opentab.activeTab(OPEN_COMM_SONTAB);
                    opentab.selectTab(OPEN_COMM_SONTAB);
                    isTriggering = Boolean.TRUE;
                }
            } else if (OPEN_TECH_SONTAB.contains(oneKey)) {
                opentab.addControls(techTabAp);
                if (!OPEN_TECH_SONTAB.equals(currentTab)) {
                    opentab.activeTab(OPEN_TECH_SONTAB);
                    opentab.selectTab(OPEN_TECH_SONTAB);
                    isTriggering = Boolean.TRUE;
                }
            }
        } else if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidopentype)) {
            opentab.addControls(techTabAp);
            opentab.addControls(commTabAp);
            if (!OPEN_TECH_SONTAB.equals(currentTab)) {
                opentab.activeTab(OPEN_TECH_SONTAB);
                opentab.selectTab(OPEN_TECH_SONTAB);
                isTriggering = Boolean.TRUE;
            }
        } else if (BidOpenSelectTypeEnum.BUSSINESSTECH.getValue().equals(bidopentype)) {
            opentab.addControls(commTabAp);
            opentab.addControls(techTabAp);
            if (!OPEN_COMM_SONTAB.equals(currentTab)) {
                opentab.activeTab(OPEN_COMM_SONTAB);
                opentab.selectTab(OPEN_COMM_SONTAB);
                isTriggering = Boolean.TRUE;
            }
        } else {
            return Boolean.FALSE;
        }
        return isTriggering;
    }

    public static Boolean createEvalTap(Tab evalTab, String bidopentype, Boolean isOne, String oneKey) {
        Boolean isTriggering = Boolean.FALSE;
        evalTab.deleteControls(new String[]{EVAL_COMM_SONTAB, EVAL_TECH_SONTAB});
        String currentTab = evalTab.getCurrentTab();
        ArrayList<Map> commTabAp = new ArrayList<Map>();
        ArrayList<Map> techTabAp = new ArrayList<Map>();
        Lang lang = RequestContext.get().getLang();
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            TabPageAp commtpa = BidCenterJSUtil.createTabPageAp(EVAL_COMM_SONTAB, EVAL_COMM_SONTAB, NAME_COMM_FLAG_US);
            TabPageAp techtpa = BidCenterJSUtil.createTabPageAp(EVAL_TECH_SONTAB, EVAL_TECH_SONTAB, NAME_TECH_FLAG_US);
            commTabAp.add(commtpa.createControl());
            techTabAp.add(techtpa.createControl());
        } else {
            BidCenterJSUtil bidCenterJSUtil = new BidCenterJSUtil();
            TabPageAp commtpa = BidCenterJSUtil.createTabPageAp(EVAL_COMM_SONTAB, EVAL_COMM_SONTAB, bidCenterJSUtil.NAME_COMM_FLAG);
            TabPageAp techtpa = BidCenterJSUtil.createTabPageAp(EVAL_TECH_SONTAB, EVAL_TECH_SONTAB, bidCenterJSUtil.NAME_TECH_FLAG);
            commTabAp.add(commtpa.createControl());
            techTabAp.add(techtpa.createControl());
        }
        if (isOne.booleanValue()) {
            if (EVAL_COMM_SONTAB.contains(oneKey)) {
                evalTab.addControls(commTabAp);
                if (!EVAL_COMM_SONTAB.equals(currentTab)) {
                    evalTab.activeTab(EVAL_COMM_SONTAB);
                    evalTab.selectTab(EVAL_COMM_SONTAB);
                    isTriggering = Boolean.TRUE;
                }
            } else if (EVAL_TECH_SONTAB.contains(oneKey)) {
                evalTab.addControls(techTabAp);
                if (!EVAL_TECH_SONTAB.equals(currentTab)) {
                    evalTab.activeTab(EVAL_TECH_SONTAB);
                    evalTab.selectTab(EVAL_TECH_SONTAB);
                    isTriggering = Boolean.TRUE;
                }
            }
        } else if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidopentype)) {
            evalTab.addControls(techTabAp);
            evalTab.addControls(commTabAp);
            if (!EVAL_TECH_SONTAB.equals(currentTab)) {
                evalTab.activeTab(EVAL_TECH_SONTAB);
                evalTab.selectTab(EVAL_TECH_SONTAB);
                isTriggering = Boolean.TRUE;
            }
        } else if (BidOpenSelectTypeEnum.BUSSINESSTECH.getValue().equals(bidopentype)) {
            evalTab.addControls(commTabAp);
            evalTab.addControls(techTabAp);
            if (!EVAL_COMM_SONTAB.equals(currentTab)) {
                evalTab.activeTab(EVAL_COMM_SONTAB);
                evalTab.selectTab(EVAL_COMM_SONTAB);
                isTriggering = Boolean.TRUE;
            }
        } else {
            return Boolean.FALSE;
        }
        return isTriggering;
    }

    public static Boolean createOnlineEvalTap(Tab evalTab, String bidopentype, Boolean isOne, String oneKey) {
        String commSonTab = ONEV_COMM_SONTAB;
        String techSonTab = ONEV_TECH_SONTAB;
        Boolean isTriggering = Boolean.FALSE;
        evalTab.deleteControls(new String[]{commSonTab, techSonTab});
        String currentTab = evalTab.getCurrentTab();
        ArrayList<Map> commTabAp = new ArrayList<Map>();
        ArrayList<Map> techTabAp = new ArrayList<Map>();
        Lang lang = RequestContext.get().getLang();
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            TabPageAp commtpa = BidCenterJSUtil.createTabPageAp(commSonTab, commSonTab, NAME_COMM_FLAG_US);
            TabPageAp techtpa = BidCenterJSUtil.createTabPageAp(techSonTab, techSonTab, NAME_TECH_FLAG_US);
            commTabAp.add(commtpa.createControl());
            techTabAp.add(techtpa.createControl());
        } else {
            BidCenterJSUtil bidCenterJSUtil = new BidCenterJSUtil();
            TabPageAp commtpa = BidCenterJSUtil.createTabPageAp(commSonTab, commSonTab, bidCenterJSUtil.NAME_COMM_FLAG);
            TabPageAp techtpa = BidCenterJSUtil.createTabPageAp(techSonTab, techSonTab, bidCenterJSUtil.NAME_TECH_FLAG);
            commTabAp.add(commtpa.createControl());
            techTabAp.add(techtpa.createControl());
        }
        if (isOne.booleanValue()) {
            if (commSonTab.contains(oneKey)) {
                evalTab.addControls(commTabAp);
                if (!commSonTab.equals(currentTab)) {
                    evalTab.activeTab(commSonTab);
                    evalTab.selectTab(commSonTab);
                    isTriggering = Boolean.TRUE;
                }
            } else if (techSonTab.contains(oneKey)) {
                evalTab.addControls(techTabAp);
                if (!techSonTab.equals(currentTab)) {
                    evalTab.activeTab(techSonTab);
                    evalTab.selectTab(techSonTab);
                    isTriggering = Boolean.TRUE;
                }
            }
        } else if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidopentype)) {
            evalTab.addControls(techTabAp);
            evalTab.addControls(commTabAp);
            if (!techSonTab.equals(currentTab)) {
                evalTab.activeTab(techSonTab);
                evalTab.selectTab(techSonTab);
                isTriggering = Boolean.TRUE;
            }
        } else if (BidOpenSelectTypeEnum.BUSSINESSTECH.getValue().equals(bidopentype)) {
            evalTab.addControls(commTabAp);
            evalTab.addControls(techTabAp);
            if (!commSonTab.equals(currentTab)) {
                evalTab.activeTab(commSonTab);
                evalTab.selectTab(commSonTab);
                isTriggering = Boolean.TRUE;
            }
        } else {
            return Boolean.FALSE;
        }
        return isTriggering;
    }

    public static void activeFlexPanel(IFormView view, String operateKey) {
        BidCenterJSUtil.unActiveAllFlexPanel(view);
        String flexPanel = (String)BidCenterConstant.OPKEY_FLEX_MAP.get(operateKey);
        if (flexPanel == null) {
            return;
        }
        BidCenterJSUtil.setFlexPanelBGPicture(view, flexPanel, "/icons/pc/other/white_bg.png");
    }

    private static void unActiveAllFlexPanel(IFormView view) {
        for (String flexPanel : FLEX_KEYS) {
            BidCenterJSUtil.setFlexPanelBGPicture(view, flexPanel, "/icons/pc/other/blued_bg.png");
        }
    }

    public static void setFlexPanelBGPicture(IFormView view, String flexPanel, String bGPicture) {
        Container c = (Container)view.getControl(flexPanel);
        if (c != null) {
            c.setBackgroundImg(bGPicture);
        }
    }

    private static void setAllPictureAndFlex(IFormView view, Long bidProjectId, Class cla) {
        String status;
        String status2;
        Image image;
        String[] FLEX_FORMID_KEYS = new String[]{FormTypeConstants.getFormConstant((String)"biddocument_edit", (Class)cla), FormTypeConstants.getFormConstant((String)"supplierinvitation", (Class)cla), FormTypeConstants.getFormConstant((String)"bidpublish", (Class)cla), FormTypeConstants.getFormConstant((String)"bidopen", (Class)cla), FormTypeConstants.getFormConstant((String)"bidevaluation", (Class)cla), FormTypeConstants.getFormConstant((String)"decision", (Class)cla)};
        int length = BID_STEP_KEYS.length;
        QFilter bidFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
        QFilter bidStatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
        for (int i = 0; i < length; ++i) {
            boolean haveStep = bidCenterService.checkContainStep((Object)bidProjectId, BID_STEP_KEYS[i]);
            if (haveStep) {
                view.setVisible(Boolean.TRUE, new String[]{IMAGE_FLEX_KEYS[i]});
                image = (Image)view.getControl(IMAGE_KEYS[i]);
                Boolean haveData = QueryServiceHelper.exists((String)FLEX_FORMID_KEYS[i], (QFilter[])new QFilter[]{bidFilter, bidStatusFilter});
                if (haveData.booleanValue()) {
                    image.setUrl(IMAGE_PATH + IMAGE_Y_WXZ_KEYS[i]);
                    continue;
                }
                image.setUrl(IMAGE_PATH + IMAGE_W_KEYS[i]);
                continue;
            }
            view.setVisible(Boolean.FALSE, new String[]{IMAGE_FLEX_KEYS[i]});
        }
        Image imageZblx = (Image)view.getControl(IMAGE_KEY_ZBLX);
        imageZblx.setUrl("/icons/pc/other/zblxxz_40_40.png");
        boolean haveStepBidAnswerQuestion = bidCenterService.checkContainStep((Object)bidProjectId, BidStepEnum.BidAnswerQuestion);
        if (haveStepBidAnswerQuestion) {
            view.setVisible(Boolean.TRUE, new String[]{"flex_bidanswerquestion"});
            image = (Image)view.getControl(IMAGE_KEY_DY);
            String answerQuestionFormId = FormTypeConstants.getFormConstant((String)"answerquestion", (Class)cla);
            Boolean haveAnswerData = QueryServiceHelper.exists((String)answerQuestionFormId, (QFilter[])new QFilter[]{bidFilter});
            BizLog.log((String)("dayi==haveAnswerData==" + haveAnswerData));
            if (haveAnswerData.booleanValue()) {
                DynamicObject answerData = BusinessDataServiceHelper.loadSingle((String)answerQuestionFormId, (String)"billstatus", (QFilter[])new QFilter[]{bidFilter});
                BizLog.log((String)("dayi==answerData==" + answerData));
                String billstatus = answerData.getString("billstatus");
                if (!"Q".equals(billstatus)) {
                    String answerquestRecoformId = FormTypeConstants.getFormConstant((String)"answerquestion_reco", (Class)cla);
                    Boolean haveAnswerDataReco = QueryServiceHelper.exists((String)answerquestRecoformId, (QFilter[])new QFilter[]{bidFilter});
                    BizLog.log((String)("dayi==haveAnswerDataReco==" + haveAnswerDataReco));
                    if (haveAnswerDataReco.booleanValue()) {
                        BizLog.log((String)"dayi==haveAnswerDataReco==1");
                        image.setUrl("/icons/pc/other/dyxz_40_40.png");
                        view.getPageCache().put(IMAGE_KEY_DY, "1");
                    } else {
                        BizLog.log((String)"dayi==haveAnswerDataReco==2");
                        image.setUrl("/icons/pc/other/dywxz_40_40.png");
                        view.getPageCache().put(IMAGE_KEY_DY, "0");
                    }
                } else {
                    BizLog.log((String)"dayi==haveAnswerDataReco==3");
                    image.setUrl("/icons/pc/other/dyxz_40_40.png");
                    view.getPageCache().put(IMAGE_KEY_DY, "1");
                }
                if (BidCenterJSUtil.containBillStep(bidProjectId, "BidAnswerQuestion")) {
                    image.setUrl("/icons/pc/other/dyxz_40_40.png");
                    BizLog.log((String)"dayi==haveAnswerDataReco==4");
                    view.getPageCache().put(IMAGE_KEY_DY, "1");
                } else {
                    image.setUrl("/icons/pc/other/dywxz_40_40.png");
                    BizLog.log((String)"dayi==haveAnswerDataReco==5");
                    view.getPageCache().put(IMAGE_KEY_DY, "0");
                }
            } else {
                image.setUrl("/icons/pc/other/dywxz_40_40.png");
                BizLog.log((String)"dayi==haveAnswerDataReco==6");
                view.getPageCache().put(IMAGE_KEY_DY, "0");
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"flex_bidanswerquestion"});
        }
        boolean haveStepBidBustalk = bidCenterService.checkContainStep((Object)bidProjectId, BidStepEnum.BidBustalk);
        if (haveStepBidBustalk) {
            view.setVisible(Boolean.TRUE, new String[]{"flex_bidbustalk"});
            Image image2 = (Image)view.getControl(IMAGE_KEY_SWTP);
            String bustalkFormId = FormTypeConstants.getFormConstant((String)"bustalk", (Class)cla);
            Boolean haveBustalkData = QueryServiceHelper.exists((String)bustalkFormId, (QFilter[])new QFilter[]{bidFilter});
            if (haveBustalkData.booleanValue()) {
                DynamicObject[] bustalkDatas = BusinessDataServiceHelper.load((String)bustalkFormId, (String)"billstatus,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier", (QFilter[])new QFilter[]{bidFilter});
                if (bustalkDatas.length == 1) {
                    Boolean flag = Boolean.FALSE;
                    DynamicObject bustalkOne = bustalkDatas[0];
                    String billstatus = bustalkOne.getString("billstatus");
                    if ("F".equals(billstatus)) {
                        DynamicObjectCollection bidsections = bustalkOne.getDynamicObjectCollection("bidsection");
                        for (DynamicObject bidsection : bidsections) {
                            DynamicObjectCollection supplierentry = bidsection.getDynamicObjectCollection("supplierentry");
                            if (supplierentry.size() <= 0) continue;
                            flag = Boolean.TRUE;
                        }
                        if (flag.booleanValue()) {
                            image2.setUrl("/icons/pc/other/swtpxz_40_40.png");
                            view.getPageCache().put(IMAGE_KEY_SWTP, "1");
                        } else {
                            image2.setUrl("/icons/pc/other/swtpwxz_40_40.png");
                            view.getPageCache().put(IMAGE_KEY_SWTP, "0");
                        }
                    } else {
                        image2.setUrl("/icons/pc/other/swtpxz_40_40.png");
                        view.getPageCache().put(IMAGE_KEY_SWTP, "1");
                    }
                } else {
                    image2.setUrl("/icons/pc/other/swtpxz_40_40.png");
                    view.getPageCache().put(IMAGE_KEY_SWTP, "1");
                }
                if (BidCenterJSUtil.containBillStep(bidProjectId, "BidBustalk")) {
                    image2.setUrl("/icons/pc/other/swtpxz_40_40.png");
                    view.getPageCache().put(IMAGE_KEY_SWTP, "1");
                } else {
                    image2.setUrl("/icons/pc/other/swtpwxz_40_40.png");
                    view.getPageCache().put(IMAGE_KEY_SWTP, "0");
                }
            } else {
                image2.setUrl("/icons/pc/other/swtpwxz_40_40.png");
                view.getPageCache().put(IMAGE_KEY_SWTP, "0");
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"flex_bidbustalk"});
        }
        Image imageKb = (Image)view.getControl(IMAGE_KEY_KB);
        if (BidCenterJSUtil.containBillStep(bidProjectId, "BidOpen")) {
            imageKb.setUrl("/icons/pc/other/kbxz_40_40.png");
        } else {
            imageKb.setUrl("/icons/pc/other/kbwxz.png");
        }
        Image imagePB = (Image)view.getControl(IMAGE_KEY_PB);
        if (BidCenterJSUtil.containBillStep(bidProjectId, "BidEvaluation")) {
            imagePB.setUrl("/icons/pc/other/pbxz_40_40.png");
        } else {
            imagePB.setUrl("/icons/pc/other/pbwxz_40_40.png");
        }
        boolean haveStepBidClarificaiton = bidCenterService.checkContainStep((Object)bidProjectId, BidStepEnum.Clarificaiton);
        boolean showBidClarificaiton = false;
        DynamicObject projectDynamic = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project");
        if (!(projectDynamic == null || "A".equals(status2 = projectDynamic.getString("billstatus")) || "B".equals(status2) || "I".equals(status2))) {
            showBidClarificaiton = true;
        }
        if (haveStepBidClarificaiton && showBidClarificaiton) {
            Boolean haveData = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"clarificaiton", (Class)cla), (QFilter[])new QFilter[]{bidFilter, bidStatusFilter});
            Image image3 = (Image)view.getControl(IMAGE_KEY_ZBJD);
            if (haveData.booleanValue()) {
                image3.setUrl("/icons/pc/other/dbxz_40_40.png");
            } else {
                image3.setUrl("/icons/pc/other/dbwxz_40_40.png");
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"flex_bidclarificaiton"});
        }
        boolean haveStepbidbottommake = false;
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"id,bidbottommake");
        if (bidProject != null) {
            haveStepbidbottommake = bidProject.getBoolean("bidbottommake");
        }
        boolean showbidbottommake = false;
        if (!(projectDynamic == null || "A".equals(status = projectDynamic.getString("billstatus")) || "B".equals(status) || "I".equals(status))) {
            showbidbottommake = true;
        }
        if (haveStepbidbottommake && showbidbottommake) {
            Boolean haveData = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"bottom_make", (Class)cla), (QFilter[])new QFilter[]{bidFilter, bidStatusFilter});
            Image image4 = (Image)view.getControl(IMAGE_KEY_BDBZ);
            if (haveData.booleanValue()) {
                image4.setUrl("/icons/pc/other/pbxz_40_40.png");
            } else {
                image4.setUrl("/icons/pc/other/pbwxz_40_40.png");
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"flex_bidbottommake"});
        }
        Image imageZxpb = (Image)view.getControl(IMAGE_KEY_ZXPB);
        String evalFromId = FormTypeConstants.getFormConstant((String)"onlinebideval", (Class)cla);
        DynamicObject bidProjectData = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", (Class)cla));
        boolean separateOpen = BidProjectProcessUtil.isSeparateOpen(bidProjectData);
        QFilter billstaus = new QFilter("billstatus", "=", (Object)BillStatusEnum.OPEN.getVal()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALID.getVal()));
        String openFormId = FormTypeConstants.getFormConstant((String)"bidopen", (Class)cla);
        String selectpro = "id,billstatus,isonlineeval";
        DynamicObject openData = BusinessDataServiceHelper.loadSingle((String)openFormId, (String)selectpro, (QFilter[])new QFilter[]{bidFilter, billstaus});
        if (separateOpen) {
            view.setVisible(Boolean.FALSE, new String[]{"flex_onbidevaluation"});
            if (openData == null) {
                view.setVisible(Boolean.FALSE, new String[]{"flex_onbidevaluation_bus", "flex_onbidevaluation_tech"});
                return;
            }
            if (openData.getBoolean("isonlineeval")) {
                view.setVisible(Boolean.TRUE, new String[]{"flex_onbidevaluation_tech", "flex_onbidevaluation_bus"});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"flex_onbidevaluation_bus", "flex_onbidevaluation_tech"});
            if (openData == null) {
                view.setVisible(Boolean.FALSE, new String[]{"flex_onbidevaluation"});
                return;
            }
            if (openData.getBoolean("isonlineeval")) {
                imageZxpb.setUrl("/icons/pc/other/zxpbxz_40_40.png");
                view.setVisible(Boolean.TRUE, new String[]{"flex_onbidevaluation"});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"flex_onbidevaluation"});
            }
        }
    }

    public static void clickCurrentOp(IFormView view, String opKey, Long bidProjectId, Class cla) {
        BidCenterJSUtil.setAllPictureAndFlex(view, bidProjectId, cla);
        String imageKey = OPKEY_IMAGEKEY_MAP.get(opKey);
        if (imageKey == null) {
            return;
        }
        String imageUrl = IMAGE_PATH + OPKEY_IMAGEYXZ_MAP.get(opKey);
        Image imageXz = (Image)view.getControl(imageKey);
        imageXz.setUrl(imageUrl);
    }

    public static boolean containBillStep(Long bidProjectId, String step) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"currentstep");
        List<String> allStep = Arrays.asList("BidProject", "SupplierInvitation", "BidDocument", "BidPublish", "BidAnswerQuestion", "BidOpen", "BidEvaluation", "BidBustalk", "BidDecision");
        List currentSteps = Arrays.asList(bidProject.getString("currentstep").split(",")).stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        boolean isEnable = false;
        isEnable = currentSteps.contains(step) ? true : allStep.indexOf(currentSteps.get(currentSteps.size() - 1)) >= allStep.indexOf(step);
        return isEnable;
    }
}

