/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.cancel;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.bid.common.util.PermissionUtil;
import kd.scm.bid.common.util.ReWfUtil;

public class BidProjectCancel
extends AbstractBillPlugIn {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void beforeBindData(EventObject e) {
        CodeRuleInfo codeRule;
        super.beforeBindData(e);
        Object bidProjectId = this.getView().getFormShowParameter().getCustomParam("bidProjectId");
        if (bidProjectId == null) {
            return;
        }
        String bidPkStr = bidProjectId.toString();
        if ("-1".equals(bidPkStr)) {
            return;
        }
        String replayflag = this.getView().getPageCache().get("replayflag");
        if (StringUtils.isNotBlank((CharSequence)replayflag)) {
            return;
        }
        String appId = this.getAppId();
        String formId = "bidproject_f7";
        if (StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) {
            formId = appId + "_" + formId;
        }
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidPkStr), (String)formId);
        DynamicObject pageData = this.getView().getModel().getDataEntity(true);
        pageData.set("bidproject", (Object)bidProject);
        pageData.set("bidmode", (Object)bidProject.getDynamicObject("bidmode"));
        pageData.set("org", (Object)bidProject.getDynamicObject("org"));
        boolean exist = CodeRuleServiceHelper.isExist((String)(appId + "_projectcancel"), (DynamicObject)pageData, null);
        if (exist && (codeRule = CodeRuleServiceHelper.getCodeRule((String)(appId + "_projectcancel"), (DynamicObject)pageData, null)) != null) {
            String billno = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)pageData);
            pageData.set("number", (Object)billno);
        }
        this.getView().getPageCache().put("replayflag", "-1");
    }

    public void afterBindData(EventObject e) {
        this.setEnableOrVisiable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String number;
        String cause;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String checkP = this.checkPermisstion(operateKey);
        if (!StringUtils.isBlank((CharSequence)checkP)) {
            this.getView().showConfirm(checkP, MessageBoxOptions.OK);
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)"refresh", (CharSequence)operateKey)) {
            try {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)(this.getAppId() + "_projectcancel"));
            }
            catch (Exception e) {
                args.setCancel(true);
                this.getView().getPageCache().remove("replayflag");
                return;
            }
        }
        if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") && StringUtils.isBlank((CharSequence)(cause = this.getView().getModel().getDataEntity(true).getString("cause")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"BidProjectCancel_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submitandauti")) {
            boolean flag = ReWfUtil.hasEableProcess((String)(this.getAppId() + "_projectcancel"));
            if (flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u542f\u52a8\u5ba1\u6279\u6d41\uff0c\u65e0\u6cd5\u64cd\u4f5c\u63d0\u4ea4\u5e76\u5ba1\u6838\u3002", (String)"BidProjectCancel_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String billstatus = this.getView().getModel().getDataEntity(true).getString("billstatus");
            if (!"A".equals(billstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u63d0\u4ea4\u5e76\u5ba1\u6838\u3002", (String)"BidProjectCancel_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)operateKey)) {
            this.getView().getModel().getDataEntity(true).set("auditdate", (Object)new Date());
            long currUserId = RequestContext.get().getCurrUserId();
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)currUserId, (String)"bos_user");
            this.getView().getModel().getDataEntity(true).set("auditor", (Object)user);
        }
        if (StringUtils.isBlank((CharSequence)(number = this.getView().getModel().getDataEntity(true).getString("number")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"BidProjectCancel_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        this.saveFile();
        this.setEnableOrVisiable();
    }

    public String checkPermisstion(String opkey) {
        boolean haspermission;
        String appId = this.getAppId();
        Long orgId = (Long)this.getModel().getDataEntity(true).getDynamicObject("org").getPkValue();
        String entityName = "";
        if ("save".equals(opkey) && !(haspermission = PermissionUtil.checkPermission((String)"QXX0196", (Long)orgId, (String)appId, (String)entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u4fdd\u5b58\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidProjectCancel_13", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("submit".equals(opkey) && !(haspermission = PermissionUtil.checkPermission((String)"QXX0009", (Long)orgId, (String)appId, (String)entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u63d0\u4ea4\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidProjectCancel_14", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("delete".equals(opkey) && !(haspermission = PermissionUtil.checkPermission((String)"QXX0004", (Long)orgId, (String)appId, (String)entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5220\u9664\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidProjectCancel_15", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("audit".equals(opkey) && !(haspermission = PermissionUtil.checkPermission((String)"QXX0006", (Long)orgId, (String)appId, (String)entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5ba1\u6838\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidProjectCancel_16", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("submitandauti".equals(opkey) && !(haspermission = PermissionUtil.checkPermission((String)"CANEEL-OP", (Long)orgId, (String)appId, (String)entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u63d0\u4ea4\u5e76\u5ba1\u6838\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidProjectCancel_17", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void saveFile() {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String cacheJsonString = cache.get("TampAttCache" + this.getView().getPageId());
        if (!StringUtils.isEmpty((CharSequence)cacheJsonString)) {
            Map attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
            AttachmentServiceHelper.saveTempAttachments((String)this.getView().getFormShowParameter().getFormId(), (Object)this.getModel().getDataEntity().getPkValue(), (String)this.getModel().getDataEntityType().getAppId(), (Map)attachmentInfo);
        }
    }

    public void setEnableOrVisiable() {
        boolean subAndAutiFlag = ReWfUtil.hasEableProcess((String)(this.getAppId() + "_projectcancel"));
        if (subAndAutiFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"submitandauti"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"submitandauti"});
        }
        String billstatus = this.getView().getModel().getDataEntity(true).getString("billstatus");
        if (StringUtils.isBlank((CharSequence)billstatus) || "A".equals(billstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"audit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"save", "submit", "submitandauti"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"save", "submit", "submitandauti"});
            if (subAndAutiFlag) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"submitandauti"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"unsubmit"});
            this.lockComponse(true);
        } else if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"B")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"submit", "submitandauti"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"audit", "submit", "submitandauti"});
            if (subAndAutiFlag) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"submitandauti"});
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"unsubmit"});
            this.lockComponse(false);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"submit", "audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"submit", "submitandauti", "unsubmit", "audit"});
            this.lockComponse(false);
        }
    }

    public void lockComponse(boolean flag) {
        CodeRuleInfo codeRule;
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"number", "bidproject", "bidmode", "cause", "attachmentpanelap"});
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        boolean exist = CodeRuleServiceHelper.isExist((String)(this.getAppId() + "_projectcancel"), (DynamicObject)dataEntity, null);
        if (flag && exist && (codeRule = CodeRuleServiceHelper.getCodeRule((String)(this.getAppId() + "_projectcancel"), (DynamicObject)dataEntity, null)) != null) {
            Boolean isModifiable = codeRule.getIsModifiable();
            this.getView().setEnable(isModifiable, new String[]{"number"});
        }
    }

    public String getAppId() {
        return "bid";
    }
}

