/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.clarify;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.formplugin.bill.util.DateUtils;

public class ModifyEndTime
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String queryId = (String)showParameter.getCustomParam("queryid");
        String appId = (String)showParameter.getCustomParam("appId");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(queryId), (String)(appId + "_multiquestclarify"));
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        dataEntity.set("datetimefield", (Object)dynamicObject.getDate("clarifydeadline"));
        dataEntity.set("datetimefield1", (Object)dynamicObject.getDate("initiationtime"));
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        this.getModel().setDataChanged(false);
        if ("sure".equals(operateKey)) {
            DynamicObject[] questionclarifys;
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String queryId = (String)showParameter.getCustomParam("queryid");
            String appId = (String)showParameter.getCustomParam("appId");
            Date clarifydeadline = dataEntity.getDate("datetimefield");
            if (clarifydeadline == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u3002", (String)"ModifyEndTime_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            Date publicTime = dataEntity.getDate("datetimefield1");
            Date nowTiem = new Date();
            if (clarifydeadline != null) {
                int compareTo = nowTiem.compareTo(clarifydeadline);
                if (compareTo > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u201d\u5fc5\u987b\u665a\u4e8e\u670d\u52a1\u5668\u5f53\u524d\u65f6\u95f4\u3002", (String)"ModifyEndTime_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
                compareTo = publicTime.compareTo(clarifydeadline);
                if (compareTo > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u201d\u5fc5\u987b\u665a\u4e8e\u6f84\u6e05\u53d1\u8d77\u65f6\u95f4\u3002", (String)"ModifyEndTime_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(queryId), (String)(appId + "_multiquestclarify"));
            DynamicObjectCollection bidsections = dynamicObject.getDynamicObjectCollection("bidsection");
            Iterator bidsectionIter = bidsections.iterator();
            dynamicObject.set("clarifydeadline", (Object)clarifydeadline);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            String entityName = "";
            entityName = "bid".equals(appId) ? "bid_query_letters" : "rebm_query_letters_inh";
            DynamicObject[] letters = BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("queryid", "=", dynamicObject.getPkValue())});
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            if (letters != null && letters.length > 0) {
                for (DynamicObject letter : letters) {
                    DynamicObject allLetter = BusinessDataServiceHelper.loadSingle((Object)letter.getPkValue(), (String)entityName);
                    Date endTime = allLetter.getDate("endTime");
                    String endTimeStr = DateUtils.date2StringSimpleOrDetail(endTime, Boolean.FALSE);
                    allLetter.set("endtime", (Object)clarifydeadline);
                    DynamicObjectCollection letterBids = allLetter.getDynamicObjectCollection("bidsection");
                    for (DynamicObject letterBid : letterBids) {
                        DynamicObjectCollection supplierentry = letterBid.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierRow : supplierentry) {
                            String content = supplierRow.getString("content_tag");
                            if (StringUtils.isBlank((CharSequence)content)) {
                                content = supplierRow.getString("content");
                            }
                            String clarifydeadlineStr = DateUtils.date2StringSimpleOrDetail(clarifydeadline, Boolean.FALSE);
                            this.replaceTime(endTimeStr, clarifydeadlineStr, content, supplierRow);
                        }
                    }
                    list.add(allLetter);
                }
                DynamicObject[] upletters = new DynamicObject[list.size()];
                list.toArray(upletters);
                SaveServiceHelper.update((DynamicObject[])upletters);
            }
            if ((questionclarifys = BusinessDataServiceHelper.load((String)(appId + "_questionclarify"), (String)"id,clarifydeadline,billstatus", (QFilter[])new QFilter[]{new QFilter("multiquestclarifyid", "in", dynamicObject.getPkValue())})) != null && questionclarifys.length > 0) {
                for (DynamicObject questionclarify : questionclarifys) {
                    Date oldDate = questionclarify.getDate("clarifydeadline");
                    String billstatus = questionclarify.getString("billstatus");
                    questionclarify.set("clarifydeadline", (Object)clarifydeadline);
                    if (clarifydeadline.compareTo(oldDate) <= 0 || !billstatus.equals(ClarifyStatusEnum.NOCLARIFIED.getValue())) continue;
                    questionclarify.set("billstatus", (Object)"UNCLARIFIED");
                }
                SaveServiceHelper.update((DynamicObject[])questionclarifys);
            }
            this.getModel().setDataChanged(false);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("success", "success");
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    public Boolean unsubmitStatus(Object mulPk, String openType, Object supplierId, String appId) {
        QFilter bidProjectFilter = new QFilter("multiquestclarifyid", "=", (Object)Long.parseLong(mulPk.toString()));
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplierId + "%"));
        QFilter clarifydeadlineFilter = new QFilter("clarifydeadline", ">", (Object)new Date());
        HashSet<String> status = new HashSet<String>();
        status.add(ClarifyStatusEnum.CLARIFIED.getValue());
        status.add(ClarifyStatusEnum.NOCLARIFIED.getValue());
        QFilter billstatusFilter = new QFilter("billstatus", "in", status);
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)openType);
        DynamicObject clarifyQest = BusinessDataServiceHelper.loadSingle((String)(appId + "_questionclarify"), (String)"id", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, clarifydeadlineFilter, billstatusFilter, openTypeFilter});
        if (clarifyQest != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void replaceTime(String oldConten, String name, String content, DynamicObject row) {
        String contentStr = content.replace(oldConten, name);
        if (contentStr.length() > 200) {
            row.set("content", (Object)contentStr.substring(0, 200));
            row.set("content_tag", (Object)contentStr);
        } else {
            row.set("content", (Object)contentStr);
        }
    }
}

