/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.evalback;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.BidEditBackBidEditPlugin;
import kd.scm.bid.formplugin.bill.util.InvalidBillUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class BidEditBackEvalutationPlugin
extends BidEditBackBidEditPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        boolean enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (enable) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"rebackbid"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rebackbid"});
        }
        String listrounds = this.getView().getModel().getDataEntity(true).getString("listrounds");
        if (StringUtils.isBlank((CharSequence)listrounds)) {
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            String evaltype = this.getModel().getValue("evaltype").toString();
            String billstatus = this.getModel().getValue("billstatus").toString();
            this.setRoundNumber(bidProject, evaltype, billstatus);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Object bidproject = this.getView().getModel().getDataEntity(true).getDynamicObject("bidproject").getPkValue();
        boolean exsitBackBid = new ReBackBidUtil(this.getAppId()).checkEvalutionOp(operateKey, bidproject);
        if (exsitBackBid) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidEditBackEvalutationPlugin_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    @Override
    public void openBackBidList(DynamicObject dataEntity) {
        DynamicObject entity = this.getView().getModel().getDataEntity(true);
        Object bidopenid = entity.get("bidopenid");
        if (bidopenid != null) {
            new ReBackBidUtil(this.getAppId()).openReBackBidList(bidopenid, this.getView());
        } else {
            DynamicObject bidOpenDyn = this.getBidOpen();
            if (bidOpenDyn != null) {
                new ReBackBidUtil(this.getAppId()).openReBackBidList(bidOpenDyn.getPkValue(), this.getView());
            }
        }
    }

    public void setRoundNumber(DynamicObject project, String evaltype, String billstatus) {
        String format = "";
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"XX")) {
            format = this.getModel().getValue("listrounds").toString();
        } else {
            QFilter pFilter = new QFilter("bidproject", "=", project.getPkValue());
            QFilter eFilter = new QFilter("evaltype", "=", (Object)evaltype);
            QFilter sFilter = new QFilter("billstatus", "=", (Object)"XX");
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)(this.getAppId() + "_bidevaluation"), (String)"id", (QFilter[])new QFilter[]{pFilter, eFilter, sFilter});
            int rounds = 1;
            if (ids != null && ids.length > 0) {
                rounds += ids.length;
            }
            format = String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u8bc4\u6807", (String)"BidEditBackEvalutationPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), InvalidBillUtil.toChinese(rounds + ""));
        }
        this.getView().getModel().getDataEntity(true).set("listrounds", (Object)format);
        this.getView().updateView("listrounds");
    }

    @Override
    public void openBackBidEdit(DynamicObject dataEntity) {
        DynamicObject bidOpenDyn = this.getBidOpen();
        if (bidOpenDyn != null) {
            new ReBackBidUtil(this.getAppId()).openReBackBidEdit(bidOpenDyn.getPkValue(), this.getView(), "EVAL");
        }
    }

    public DynamicObject getBidOpen() {
        DynamicObject entity = this.getView().getModel().getDataEntity(true);
        DynamicObject bidproject = entity.getDynamicObject("bidproject");
        QFilter bidProjectQFilter = new QFilter("bidproject", "=", bidproject.getPkValue());
        QFilter statusQFilter = new QFilter("billstatus", "=", (Object)"O");
        DynamicObject bidOpenDyn = null;
        String opentype = entity.getString("evaltype");
        if (StringUtils.equals((CharSequence)"MULTI", (CharSequence)opentype)) {
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)(this.getAppId() + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{bidProjectQFilter, statusQFilter});
            if (ids != null && ids.length > 0) {
                bidOpenDyn = ids[0];
            }
        } else if (StringUtils.equals((CharSequence)"TECHNICAL", (CharSequence)opentype)) {
            QFilter typeQFilter = new QFilter("opentype", "=", (Object)"TECHNICAL");
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)(this.getAppId() + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{bidProjectQFilter, statusQFilter, typeQFilter});
            if (ids != null && ids.length > 0) {
                bidOpenDyn = ids[0];
            }
        } else if (StringUtils.equals((CharSequence)"BUSSINESS", (CharSequence)opentype)) {
            QFilter typeQFilter = new QFilter("opentype", "=", (Object)"BUSSINESS");
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)(this.getAppId() + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{bidProjectQFilter, statusQFilter, typeQFilter});
            if (ids != null && ids.length > 0) {
                bidOpenDyn = ids[0];
            }
        }
        if (bidOpenDyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5df2\u5f00\u6807\u7684\u5f00\u6807\u5355\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u68c0\u67e5\u3002", (String)"BidEditBackEvalutationPlugin_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return null;
        }
        return bidOpenDyn;
    }

    @Override
    public String getAppId() {
        return "bid";
    }
}

