/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.ext;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;

public class BidDecisionPurDetailEditExt
extends AbstractFormPlugin
implements SetFilterListener {
    String[] supfinalDetails = new String[]{"lpurentrycontent", "lpurentryproject", "lmaterialid", "lmaterialdes", "lqty", "linclutaxprice", "linclutaxamount", "lbd_taxrate", "ltaxrate", "ltaxamount", "lexcepttaxamount", "lcostrate"};
    String[] rebmfinalDetails = new String[]{"lpurentrycontent", "lpurentryproject", "lmaterialid", "lresourceitem", "lmaterialdes", "lqty", "linclutaxprice", "linclutaxamount", "ltaxrate", "ltaxamount", "lexcepttaxamount", "lcostrate", "lbd_taxrate"};
    String[] supbackDetails = new String[]{"purentrycontent", "purentryproject", "materialid", "materialdes", "qty", "inclutaxprice", "inclutaxamount", "bd_taxrate", "taxrate", "taxamount", "excepttaxamount", "costrate"};
    String[] rebmbackDetails = new String[]{"purentrycontent", "purentryproject", "resourceitem", "materialid", "materialdes", "qty", "inclutaxprice", "inclutaxamount", "taxrate", "taxamount", "excepttaxamount", "costrate", "bd_taxrate"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerBill();
    }

    public void initialize() {
        super.initialize();
        String regiestFlag = this.getView().getPageCache().get("regiestFlag");
        if (null == regiestFlag) {
            this.registerBill();
            this.getView().getPageCache().put("regiestFlag", "1");
        }
    }

    private void registerBill() {
        BillList gradeBillList = (BillList)this.getControl("billlistap");
        gradeBillList.addSetFilterListener((SetFilterListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billStatus = formShowParameter.getStatus().toString();
        if ("EDIT".equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"callbacksave"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"addnew"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"delete"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"callbacksave"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"addnew"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"delete"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
        }
        String parentFormId = formShowParameter.getParentFormId();
        if ("bid_decisionwinning".equals(parentFormId)) {
            parentFormId = "bid_decision";
        } else if ("rebm_decisionwinning".equals(parentFormId)) {
            parentFormId = "rebm_decision";
        }
        if (!StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (CharSequence)parentFormId)) {
            return;
        }
        int entryCurrentRowIndex = (Integer)formShowParameter.getCustomParam("entryCurrentRowIndex");
        DynamicObject currencySection = this.getView().getParentView().getModel().getEntryRowEntity("bidsection", entryCurrentRowIndex);
        String supplierid = (String)formShowParameter.getCustomParam("supplierid");
        String sectionId = (String)formShowParameter.getCustomParam("sectionId");
        DynamicObjectCollection finalPurDetails = currencySection.getDynamicObjectCollection("supfinaldetail");
        DynamicObjectCollection backPurDetails = currencySection.getDynamicObjectCollection("supbackdetail");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection backFinalDetail = dataEntity.getDynamicObjectCollection("supbackdetail");
        DynamicObjectCollection supFinalDetail = dataEntity.getDynamicObjectCollection("supfinaldetail");
        this.createFinalPurDetailEntry(supplierid, sectionId, finalPurDetails, supFinalDetail);
        this.createBackPurDetailEntry(supplierid, sectionId, backPurDetails, backFinalDetail);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        BillList billList = (BillList)setFilterEvent.getSource();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long bidproject = (Long)formShowParameter.getCustomParam("bidprojectid");
        String sectionName = (String)formShowParameter.getCustomParam("sectionName");
        String supplier = (String)formShowParameter.getCustomParam("supplierid");
        QFilter projectqfilter = new QFilter("bidproject", "=", (Object)bidproject);
        QFilter sectionfilter = new QFilter("sectionname", "=", (Object)sectionName);
        QFilter supplierfilter = new QFilter("supplier", "=", (Object)Long.parseLong(supplier));
        List qFilters = setFilterEvent.getQFilters();
        qFilters.add(projectqfilter);
        qFilters.add(sectionfilter);
        qFilters.add(supplierfilter);
    }

    protected void createBackPurDetailEntry(String supplierid, String sectionId, DynamicObjectCollection backPurDetails, DynamicObjectCollection backFinalDetail) {
        backFinalDetail.clear();
        for (DynamicObject backPurDetail : backPurDetails) {
            DynamicObject backCurrencySupplier = backPurDetail.getDynamicObject("pursupplier");
            if (!StringUtils.equals((CharSequence)supplierid, (CharSequence)backCurrencySupplier.getPkValue().toString())) continue;
            DynamicObject backFinalDetailModel = backFinalDetail.addNew();
            backFinalDetailModel.set("sectionId", (Object)sectionId);
            backFinalDetailModel.set("pursupplier", (Object)backCurrencySupplier);
            String[] details = StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getView().getParentView().getModel().getDataEntityType().getAppId()) ? this.rebmbackDetails : this.supbackDetails;
            for (String key : details) {
                backFinalDetailModel.set(key, backPurDetail.get(key));
            }
        }
    }

    protected void createFinalPurDetailEntry(String supplierid, String sectionId, DynamicObjectCollection finalPurDetails, DynamicObjectCollection supFinalDetail) {
        supFinalDetail.clear();
        for (DynamicObject finalPurDetail : finalPurDetails) {
            boolean isdelinsonpage;
            DynamicObject finalCurrencySupplier = finalPurDetail.getDynamicObject("lpursupplier");
            if (!StringUtils.equals((CharSequence)supplierid, (CharSequence)finalCurrencySupplier.getPkValue().toString()) || (isdelinsonpage = finalPurDetail.getBoolean("isdelinsonpage"))) continue;
            DynamicObject supFinalDetailModel = supFinalDetail.addNew();
            supFinalDetailModel.set("lsectionId", (Object)sectionId);
            supFinalDetailModel.set("lpursupplier", (Object)finalCurrencySupplier);
            String[] details = StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getView().getParentView().getModel().getDataEntityType().getAppId()) ? this.rebmfinalDetails : this.supfinalDetails;
            for (String key : details) {
                supFinalDetailModel.set(key, finalPurDetail.get(key));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"callbacksave")) {
            String billstatus;
            Object id = this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject bidDecision = null;
            if (!(id == null || id.equals(0) || (billstatus = (bidDecision = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()))).getString("billstatus")).equals("A") || billstatus.equals("D"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b9a\u6807\u5355\u636e\u5df2\u88ab\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"BidDecisionPurDetailEditExt_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long bidProjectId = 0L;
            if (bidDecision != null && bidDecision.getDynamicObject("bidproject") != null) {
                bidProjectId = bidDecision.getDynamicObject("bidproject").getLong("id");
            }
            String appId = this.getView().getParentView().getModel().getDataEntityType().getAppId();
            String checkMessage = this.checkMaterialNumber(bidProjectId);
            if (!StringUtils.isEmpty((CharSequence)checkMessage)) {
                this.getView().showTipNotification(checkMessage);
                args.setCancel(true);
                return;
            }
            Map amountMap = (Map)this.getView().getFormShowParameter().getCustomParam("amountMap");
            if (amountMap != null) {
                DynamicObject purdetailmain = this.getModel().getDataEntity(true);
                DynamicObjectCollection supfinaldetail = purdetailmain.getDynamicObjectCollection("supfinaldetail");
                Map controlMap = (Map)amountMap.get("controlamount");
                Map finalMap = (Map)amountMap.get("finalauditamount");
                ArrayList<String> errorTips = new ArrayList<String>(16);
                for (int i = 0; i < supfinaldetail.size(); ++i) {
                    DynamicObject lResourceItem;
                    DynamicObject entry = (DynamicObject)supfinaldetail.get(i);
                    String lsectionid = entry.getString("lsectionid");
                    String lpurentrycontent = null;
                    if (StringUtils.isNotBlank((CharSequence)entry.getString("lpurentrycontent"))) {
                        lpurentrycontent = entry.getString("lpurentrycontent");
                    }
                    Object lpursupplier = entry.getDynamicObject("lpursupplier").getPkValue();
                    BigDecimal linclutaxamount = entry.getBigDecimal("linclutaxamount");
                    DynamicObject lpurentryproject = entry.getDynamicObject("lpurentryproject");
                    String projectId = null;
                    if (lpurentryproject != null) {
                        projectId = lpurentryproject.getString("id");
                    }
                    DynamicObject lmaterialid = entry.getDynamicObject("lmaterialid");
                    String materialId = null;
                    if (lmaterialid != null) {
                        materialId = lmaterialid.getString("id");
                    }
                    String resourceItemId = null;
                    if ("rebm".equals(appId) && (lResourceItem = entry.getDynamicObject("lresourceitem")) != null) {
                        resourceItemId = lResourceItem.getString("id");
                    }
                    String lMaterialdes = null;
                    if (StringUtils.isNotBlank((CharSequence)entry.getString("lmaterialdes"))) {
                        lMaterialdes = entry.getString("lmaterialdes");
                    }
                    if (controlMap == null || finalMap == null) continue;
                    String key = String.format("%s%s%s%s%s%s%s", lsectionid, lpursupplier, lpurentrycontent, projectId, materialId, resourceItemId, lMaterialdes);
                    BigDecimal botcontrolamount = (BigDecimal)controlMap.get(key);
                    BigDecimal finalauditamount = (BigDecimal)finalMap.get(key);
                    boolean isBotControl = false;
                    boolean isFinal = false;
                    if (finalauditamount == null) {
                        isFinal = true;
                        finalauditamount = BigDecimal.ZERO;
                    }
                    if (botcontrolamount == null) {
                        isBotControl = true;
                        botcontrolamount = BigDecimal.ZERO;
                    }
                    if (botcontrolamount.compareTo(BigDecimal.ZERO) == 0 && finalauditamount.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (!isBotControl && !isFinal && linclutaxamount.compareTo(finalauditamount) > 0 && linclutaxamount.compareTo(botcontrolamount) > 0) {
                        errorTips.add(String.format(ResManager.loadKDString((String)"\u6700\u7ec8\u62a5\u4ef7\u660e\u7ec6\u4e2d\u7b2c%s\u884c\u7684\u542b\u7a0e\u4ef7\u5927\u4e8e\u91c7\u8d2d\u63a7\u5236\u91d1\u989d\u3001\u6807\u5e95\u6700\u7ec8\u91d1\u989d;", (String)"BidDecisionPurDetailEditExt_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    if (!isFinal && linclutaxamount.compareTo(finalauditamount) > 0) {
                        errorTips.add(String.format(ResManager.loadKDString((String)"\u6700\u7ec8\u62a5\u4ef7\u660e\u7ec6\u4e2d\u7b2c%s\u884c\u7684\u542b\u7a0e\u4ef7\u5927\u4e8e\u6807\u5e95\u6700\u7ec8\u91d1\u989d;", (String)"BidDecisionPurDetailEditExt_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    if (isBotControl || linclutaxamount.compareTo(botcontrolamount) <= 0) continue;
                    errorTips.add(String.format(ResManager.loadKDString((String)"\u6700\u7ec8\u62a5\u4ef7\u660e\u7ec6\u4e2d\u7b2c%s\u884c\u7684\u542b\u7a0e\u4ef7\u5927\u4e8e\u91c7\u8d2d\u63a7\u5236\u91d1\u989d;", (String)"BidDecisionPurDetailEditExt_3", (String)"scm-bid-formplugin", (Object[])new Object[0]), i + 1));
                }
                if (errorTips.size() == 0) {
                    this.returnDataToParent();
                    return;
                }
                StringBuilder sb = new StringBuilder();
                if (errorTips.size() == 1) {
                    sb.append((String)errorTips.get(0));
                } else {
                    int i = 0;
                    for (String errorTip : errorTips) {
                        String index = ++i + "\u3001";
                        sb.append(index);
                        sb.append(errorTip);
                        sb.append("\r\n");
                    }
                }
                sb.append(ResManager.loadKDString((String)"\u662f\u5426\u4fdd\u5b58\uff1f", (String)"BidDecisionPurDetailEditExt_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("save", (IFormPlugin)this);
                this.getView().showConfirm(sb.toString(), MessageBoxOptions.OKCancel, confirmCallBackListener);
            }
        } else if ("addnew".equals(operateKey)) {
            this.openSupFinalDetailEdit();
        }
    }

    protected void openSupFinalDetailEdit() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        DynamicObjectCollection supFinalDetail = dataEntity.getDynamicObjectCollection("supfinaldetail");
        String supplierid = (String)formShowParameter.getCustomParam("supplierid");
        Set<String> detailEntrySet = this.currPurDetailEntrySet(supFinalDetail, supplierid, false);
        int entryCurrentRowIndex = (Integer)formShowParameter.getCustomParam("entryCurrentRowIndex");
        DynamicObject currencySection = this.getView().getParentView().getModel().getEntryRowEntity("bidsection", entryCurrentRowIndex);
        DynamicObjectCollection finalPurDetails = currencySection.getDynamicObjectCollection("supfinaldetail");
        String needAddDetailEntryIds = this.getNeedAddDetailEntryIds(finalPurDetails, detailEntrySet, supplierid);
        if (needAddDetailEntryIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u65b0\u589e\u6570\u636e\u3002", (String)"BidDecisionPurDetailEditExt_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormTypeConstants.getFormConstant((String)"supfinaldetail", ((Object)((Object)this)).getClass()));
        showParameter.setCustomParam("decisionId", formShowParameter.getCustomParam("id"));
        showParameter.setCustomParam("detailEntryIds", (Object)needAddDetailEntryIds);
        showParameter.setCustomParam("sectionId", formShowParameter.getCustomParam("sectionId"));
        showParameter.setCustomParam("isMaterialpur", formShowParameter.getCustomParam("isMaterialpur"));
        showParameter.setCustomParam("isratebidding", formShowParameter.getCustomParam("isratebidding"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addnew");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("addnew".equals(actionId)) {
            Object data = closedCallBackEvent.getReturnData();
            if (data == null) {
                return;
            }
            Map returnData = (Map)data;
            this.addNewEntryRow(returnData);
        }
    }

    protected void addNewEntryRow(Map<String, List<Object>> returnData) {
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        List<Object> purDetailIds = returnData.get("purDetailIds");
        DynamicObjectCollection supfinaldetail = this.getModel().getDataEntity(true).getDynamicObjectCollection("supfinaldetail");
        int entryCurrentRowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("entryCurrentRowIndex");
        DynamicObject currencySection = this.getView().getParentView().getModel().getEntryRowEntity("bidsection", entryCurrentRowIndex);
        DynamicObjectCollection parentSupFinaldetail = currencySection.getDynamicObjectCollection("supfinaldetail");
        parentSupFinaldetail.stream().filter(sup -> purDetailIds.contains(sup.getPkValue())).forEach(sup -> {
            DynamicObject entryRow = supfinaldetail.addNew();
            entryRow.set("lpurentrycontent", sup.get("lpurentrycontent"));
            entryRow.set("lpurentryproject", sup.get("lpurentryproject"));
            entryRow.set("lmaterialid", sup.get("lmaterialid"));
            entryRow.set("lsectionid", this.getView().getFormShowParameter().getCustomParam("sectionId"));
            entryRow.set("lpursupplier", sup.get("lpursupplier"));
            entryRow.set("lmaterialdes", sup.get("lmaterialdes"));
            entryRow.set("lqty", sup.get("lqty"));
            entryRow.set("linclutaxprice", sup.get("linclutaxprice"));
            entryRow.set("linclutaxamount", sup.get("linclutaxamount"));
            entryRow.set("lbd_taxrate", sup.get("lbd_taxrate"));
            entryRow.set("ltaxrate", sup.get("ltaxrate"));
            entryRow.set("ltaxamount", sup.get("ltaxamount"));
            entryRow.set("lexcepttaxamount", sup.get("lexcepttaxamount"));
            entryRow.set("lcostrate", sup.get("lcostrate"));
        });
        this.getView().updateView("supfinaldetail");
    }

    protected String getNeedAddDetailEntryIds(DynamicObjectCollection finalPurDetails, Set<String> detailEntrySet, String supplierid) {
        StringBuilder detailsEntryIds = new StringBuilder();
        if (finalPurDetails.size() == 0) {
            return null;
        }
        Set<String> decisionDetailEntrySet = this.currPurDetailEntrySet(finalPurDetails, supplierid, true);
        decisionDetailEntrySet.forEach(detail -> {
            String[] split = detail.split("@@@");
            if (!detailEntrySet.contains(split[0])) {
                detailsEntryIds.append(split[1]);
                detailsEntryIds.append("###");
            }
        });
        return detailsEntryIds.toString();
    }

    protected Set<String> currPurDetailEntrySet(DynamicObjectCollection supFinalDetail, String supplierid, boolean flag) {
        HashSet<String> entrySet = new HashSet<String>(16);
        if (supFinalDetail.size() == 0) {
            return entrySet;
        }
        supFinalDetail.forEach(entry -> {
            DynamicObject lpursupplier = entry.getDynamicObject("lpursupplier");
            if (lpursupplier == null) {
                return;
            }
            if (!StringUtils.equals((CharSequence)supplierid, (CharSequence)lpursupplier.getPkValue().toString())) {
                return;
            }
            String purentrycontent = entry.getString("lpurentrycontent");
            DynamicObject purentryproject = entry.getDynamicObject("lpurentryproject");
            DynamicObject materialid = entry.getDynamicObject("lmaterialid");
            StringBuilder sb = new StringBuilder();
            sb.append(supplierid);
            if (purentrycontent != null) {
                sb.append(purentrycontent);
            }
            if (purentryproject != null) {
                sb.append(purentryproject.getPkValue());
            }
            if (materialid != null) {
                sb.append(materialid.getPkValue());
            }
            if (flag) {
                String entryId = "@@@" + entry.getPkValue();
                sb.append(entryId);
            }
            entrySet.add(sb.toString());
        });
        return entrySet;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject bd_taxrate;
        Object newVal;
        BigDecimal ltaxrateRe;
        BigDecimal divide;
        BigDecimal taxrateRe;
        super.propertyChanged(e);
        ChangeData[] datas = e.getChangeSet();
        String keyname = e.getProperty().getName();
        ChangeData changedata = datas[0];
        int rowindex = changedata.getRowIndex();
        Object oldValue = changedata.getOldValue();
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowindex) == null ? new BigDecimal(0) : (BigDecimal)this.getModel().getValue("qty", rowindex);
        BigDecimal taxrate = (BigDecimal)this.getModel().getValue("taxrate", rowindex) == null ? new BigDecimal(0) : (BigDecimal)this.getModel().getValue("taxrate", rowindex);
        BigDecimal inclutaxprice = (BigDecimal)this.getModel().getValue("inclutaxprice", rowindex) == null ? new BigDecimal(0) : (BigDecimal)this.getModel().getValue("inclutaxprice", rowindex);
        BigDecimal inclutaxamount = new BigDecimal(0);
        BigDecimal taxamount = new BigDecimal(0);
        BigDecimal excepttaxamount = new BigDecimal(0);
        BigDecimal lqty = (BigDecimal)this.getModel().getValue("lqty", rowindex) == null ? new BigDecimal(0) : (BigDecimal)this.getModel().getValue("lqty", rowindex);
        BigDecimal ltaxrate = (BigDecimal)this.getModel().getValue("ltaxrate", rowindex) == null ? new BigDecimal(0) : (BigDecimal)this.getModel().getValue("ltaxrate", rowindex);
        BigDecimal linclutaxprice = (BigDecimal)this.getModel().getValue("linclutaxprice", rowindex) == null ? new BigDecimal(0) : (BigDecimal)this.getModel().getValue("linclutaxprice", rowindex);
        BigDecimal linclutaxamount = new BigDecimal(0);
        BigDecimal ltaxamount = new BigDecimal(0);
        BigDecimal lexcepttaxamount = new BigDecimal(0);
        boolean isMaterialpur = (Boolean)this.getView().getFormShowParameter().getCustomParam("isMaterialpur");
        int bidType = (Integer)this.getView().getFormShowParameter().getCustomParam("bidType");
        if (isMaterialpur) {
            if (keyname.equals("inclutaxprice")) {
                inclutaxamount = qty.multiply(inclutaxprice).setScale(10, 4);
                this.getModel().setValue("inclutaxamount", (Object)inclutaxamount, rowindex);
                taxrateRe = taxrate.divide(new BigDecimal("100"));
                divide = new BigDecimal(1).add(taxrateRe);
                taxamount = inclutaxamount.multiply(taxrateRe).divide(divide, 2, 4);
                excepttaxamount = inclutaxamount.subtract(taxamount);
                this.getModel().setValue("taxamount", (Object)taxamount, rowindex);
                this.getModel().setValue("excepttaxamount", (Object)excepttaxamount, rowindex);
            }
            if (keyname.equals("linclutaxprice")) {
                linclutaxamount = lqty.multiply(linclutaxprice).setScale(10, 4);
                this.getModel().setValue("linclutaxamount", (Object)linclutaxamount, rowindex);
                ltaxrateRe = ltaxrate.divide(new BigDecimal("100"));
                divide = new BigDecimal(1).add(ltaxrateRe);
                ltaxamount = linclutaxamount.multiply(ltaxrateRe).divide(divide, 2, 4);
                lexcepttaxamount = linclutaxamount.subtract(ltaxamount);
                this.getModel().setValue("ltaxamount", (Object)ltaxamount, rowindex);
                this.getModel().setValue("lexcepttaxamount", (Object)lexcepttaxamount, rowindex);
            }
        } else if (bidType == 2) {
            if (keyname.equals("linclutaxprice")) {
                linclutaxamount = lqty.multiply(linclutaxprice).setScale(10, 4);
                this.getModel().setValue("linclutaxamount", (Object)linclutaxamount, rowindex);
                ltaxrateRe = ltaxrate.divide(new BigDecimal("100"));
                divide = new BigDecimal(1).add(ltaxrateRe);
                ltaxamount = linclutaxamount.multiply(ltaxrateRe).divide(divide, 10, 4);
                lexcepttaxamount = linclutaxamount.subtract(ltaxamount);
                this.getModel().setValue("ltaxamount", (Object)ltaxamount, rowindex);
                this.getModel().setValue("lexcepttaxamount", (Object)lexcepttaxamount, rowindex);
            }
        } else {
            if (keyname.equals("inclutaxamount")) {
                inclutaxamount = (BigDecimal)this.getModel().getValue("inclutaxamount", rowindex) == null ? new BigDecimal(0) : (BigDecimal)this.getModel().getValue("inclutaxamount", rowindex);
                taxrateRe = taxrate.divide(new BigDecimal("100"));
                divide = new BigDecimal(1).add(taxrateRe);
                taxamount = inclutaxamount.multiply(taxrateRe).divide(divide, 10, 4);
                excepttaxamount = inclutaxamount.subtract(taxamount);
                this.getModel().setValue("taxamount", (Object)taxamount, rowindex);
                this.getModel().setValue("excepttaxamount", (Object)excepttaxamount, rowindex);
            }
            if (keyname.equals("linclutaxamount")) {
                linclutaxamount = (BigDecimal)this.getModel().getValue("linclutaxamount", rowindex) == null ? new BigDecimal(0) : (BigDecimal)this.getModel().getValue("linclutaxamount", rowindex);
                ltaxrateRe = ltaxrate.divide(new BigDecimal("100"));
                divide = new BigDecimal(1).add(ltaxrateRe);
                ltaxamount = linclutaxamount.multiply(ltaxrateRe).divide(divide, 10, 4);
                lexcepttaxamount = linclutaxamount.subtract(ltaxamount);
                this.getModel().setValue("ltaxamount", (Object)ltaxamount, rowindex);
                this.getModel().setValue("lexcepttaxamount", (Object)lexcepttaxamount, rowindex);
            }
        }
        if (keyname.equals("taxrate")) {
            inclutaxamount = (BigDecimal)this.getModel().getValue("inclutaxamount", rowindex) == null ? new BigDecimal(0) : (BigDecimal)this.getModel().getValue("inclutaxamount", rowindex);
            taxrateRe = taxrate.divide(new BigDecimal("100"));
            divide = new BigDecimal(1).add(taxrateRe);
            taxamount = inclutaxamount.multiply(taxrateRe).divide(divide, 10, 4);
            excepttaxamount = inclutaxamount.subtract(taxamount);
            this.getModel().setValue("taxamount", (Object)taxamount, rowindex);
            this.getModel().setValue("excepttaxamount", (Object)excepttaxamount, rowindex);
        }
        if (keyname.equals("ltaxrate")) {
            linclutaxamount = (BigDecimal)this.getModel().getValue("linclutaxamount", rowindex) == null ? new BigDecimal(0) : (BigDecimal)this.getModel().getValue("linclutaxamount", rowindex);
            ltaxrateRe = ltaxrate.divide(new BigDecimal("100"));
            divide = new BigDecimal(1).add(ltaxrateRe);
            ltaxamount = linclutaxamount.multiply(ltaxrateRe).divide(divide, 10, 4);
            lexcepttaxamount = linclutaxamount.subtract(ltaxamount);
            this.getModel().setValue("ltaxamount", (Object)ltaxamount, rowindex);
            this.getModel().setValue("lexcepttaxamount", (Object)lexcepttaxamount, rowindex);
        }
        if (keyname.equals("bd_taxrate")) {
            newVal = changedata.getNewValue();
            if (newVal == null) {
                this.getModel().setValue("taxrate", (Object)new BigDecimal(0), rowindex);
            } else {
                bd_taxrate = (DynamicObject)newVal;
                this.getModel().setValue("taxrate", (Object)bd_taxrate.getBigDecimal("taxrate"), rowindex);
            }
        }
        if (keyname.equals("lbd_taxrate")) {
            newVal = changedata.getNewValue();
            if (newVal == null) {
                this.getModel().setValue("ltaxrate", (Object)new BigDecimal(0), rowindex);
            } else {
                bd_taxrate = (DynamicObject)newVal;
                this.getModel().setValue("ltaxrate", (Object)bd_taxrate.getBigDecimal("taxrate"), rowindex);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPurTypeModelStatus();
    }

    private void setPurTypeModelStatus() {
        boolean isMaterialpur = (Boolean)this.getView().getFormShowParameter().getCustomParam("isMaterialpur");
        boolean isratebidding = (Boolean)this.getView().getFormShowParameter().getCustomParam("isratebidding");
        int bidType = (Integer)this.getView().getFormShowParameter().getCustomParam("bidType");
        if (bidType != 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"purentrycontent", "costrate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lpurentrycontent", "lcostrate"});
            EntryGrid supfinaldetailGrid = (EntryGrid)this.getControl("supfinaldetail");
            supfinaldetailGrid.setColumnProperty("linclutaxamount", "l", (Object)55);
            EntryGrid supbackdetailGrid = (EntryGrid)this.getControl("supbackdetail");
            supbackdetailGrid.setColumnProperty("inclutaxamount", "l", (Object)55);
            this.getView().setEnable(Boolean.FALSE, new String[]{"inclutaxamount"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"linclutaxamount"});
            supfinaldetailGrid.setColumnProperty("ltaxrate", "l", (Object)55);
            supbackdetailGrid.setColumnProperty("taxrate", "l", (Object)55);
            if (StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getView().getParentView().getModel().getDataEntityType().getAppId())) {
                if (bidType == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem", "resitemname", "resourcemodel", "resourceunit"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"lresourceitem", "lresitemname", "lresourcemodel", "lresourceunit"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"materialname", "materialid", "model", "unit"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"lmaterialname", "lmaterialid", "lmodel", "lunit"});
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "materialdes", "model", "unit", "baseunit", "qty", "inclutaxprice", "bd_taxrate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lmaterialid", "lmaterialname", "lmaterialdes", "lmodel", "lunit", "lbaseunit", "lqty", "linclutaxprice", "lbd_taxrate"});
            if (StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getView().getParentView().getModel().getDataEntityType().getAppId())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem", "resitemname", "resourcemodel", "resourceunit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"lresourceitem", "lresitemname", "lresourcemodel", "lresourceunit"});
            }
            if (!isratebidding) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"costrate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"lcostrate"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inclutaxamount", "taxrate", "taxamount", "excepttaxamount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"linclutaxamount", "ltaxrate", "ltaxamount", "lexcepttaxamount"});
            }
        }
    }

    public String checkMaterialNumber(Long bidProjectId) {
        StringBuilder checkMessage = new StringBuilder();
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        int bidType = bidProject.getInt("bidtype");
        int entryCurrentRowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("entryCurrentRowIndex");
        DynamicObject currencySection = this.getView().getParentView().getModel().getEntryRowEntity("bidsection", entryCurrentRowIndex);
        String currentSectionName = currencySection.getString("sectionName");
        if (bidType != 0) {
            String resourceItemKey;
            String materialKey;
            HashMap<String, BigDecimal> materialNumberMap = new HashMap<String, BigDecimal>(16);
            DynamicObjectCollection bidProjectSection = bidProject.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidSection : bidProjectSection) {
                DynamicObjectCollection projectEntryList = bidSection.getDynamicObjectCollection("projectentry");
                String sectionName = bidSection.getString("sectionName");
                for (DynamicObject projectEntry : projectEntryList) {
                    String materialDesc;
                    BigDecimal purQty = projectEntry.getBigDecimal("qty");
                    if (bidType == 1) {
                        DynamicObject material = projectEntry.getDynamicObject("materialid");
                        materialKey = material.getString("id");
                        materialDesc = projectEntry.getString("materialdes");
                        materialNumberMap.put(sectionName + "_" + materialKey + "_" + materialDesc, purQty);
                        continue;
                    }
                    DynamicObject resourceItem = projectEntry.getDynamicObject("resourceitem");
                    resourceItemKey = resourceItem.getString("id");
                    materialDesc = projectEntry.getString("materialdes");
                    materialNumberMap.put(sectionName + "_" + resourceItemKey + "_" + materialDesc, purQty);
                }
            }
            DynamicObject dattaEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection supFinalDetailList = dattaEntity.getDynamicObjectCollection("supfinaldetail");
            for (DynamicObject supFinalDetail : supFinalDetailList) {
                String materialDec;
                BigDecimal lQty = supFinalDetail.getBigDecimal("lqty");
                int seq = supFinalDetail.getInt("seq");
                BigDecimal projectMaterialNumber = new BigDecimal(0);
                if (bidType == 1) {
                    DynamicObject material = supFinalDetail.getDynamicObject("lmaterialid");
                    materialKey = material.getString("id");
                    materialDec = supFinalDetail.getString("lmaterialdes");
                    projectMaterialNumber = (BigDecimal)materialNumberMap.get(currentSectionName + "_" + materialKey + "_" + materialDec);
                } else {
                    DynamicObject resourceItem = supFinalDetail.getDynamicObject("lresourceItem");
                    resourceItemKey = resourceItem.getString("id");
                    materialDec = supFinalDetail.getString("lmaterialdes");
                    projectMaterialNumber = (BigDecimal)materialNumberMap.get(currentSectionName + "_" + resourceItemKey + "_" + materialDec);
                }
                if (lQty == null || projectMaterialNumber == null) {
                    return "";
                }
                int k = lQty.subtract(projectMaterialNumber).compareTo(BigDecimal.ZERO);
                if (k <= 0) continue;
                String tip = String.format(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u6570\u91cf\u5e94\u5c0f\u4e8e\u7b49\u4e8e%s", (String)"BidDecisionPurDetailEditExt_6", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectMaterialNumber) + "\n";
                String message = String.format(ResManager.loadKDString((String)"\u7b2c%1$s%2$s", (String)"BidDecisionPurDetailEditExt_7", (String)"scm-bid-formplugin", (Object[])new Object[0]), seq, tip);
                checkMessage.append(message);
            }
        }
        return checkMessage.toString();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("save".equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.returnDataToParent();
        }
    }

    protected void returnDataToParent() {
        Object[] resultObject = new Object[1];
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList resultList = new ArrayList(16);
        HashMap<String, Map<String, Object>> finalResultMap = new HashMap<String, Map<String, Object>>(16);
        DynamicObject purdetailmain = this.getModel().getDataEntity(true);
        DynamicObjectCollection finalPurDetails = purdetailmain.getDynamicObjectCollection("supfinaldetail");
        DynamicObjectCollection backPurDetails = purdetailmain.getDynamicObjectCollection("supbackdetail");
        int entryCurrentRowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("entryCurrentRowIndex");
        String supplierid = (String)this.getView().getFormShowParameter().getCustomParam("supplierid");
        resultMap.put("entryCurrentRowIndex", entryCurrentRowIndex);
        resultMap.put("supplierid", supplierid);
        String sectionId = (String)this.getView().getFormShowParameter().getCustomParam("sectionId");
        resultMap.put("sectionId", sectionId);
        String sectionName = (String)this.getView().getFormShowParameter().getCustomParam("sectionName");
        resultMap.put("sectionName", sectionName);
        int bidType = (Integer)this.getView().getFormShowParameter().getCustomParam("bidType");
        this.getFinalPurDetailMap(finalPurDetails, finalResultMap, supplierid, bidType);
        for (DynamicObject backPurDetail : backPurDetails) {
            HashMap<String, Object> resultDetailMap = new HashMap<String, Object>();
            resultDetailMap.put("purentrycontent", backPurDetail.getString("purentrycontent") == null ? "" : backPurDetail.getString("purentrycontent"));
            resultDetailMap.put("purentryprojectid", backPurDetail.getDynamicObject("purentryproject") == null ? "" : backPurDetail.getDynamicObject("purentryproject").getString("id"));
            resultDetailMap.put("materialid", backPurDetail.getDynamicObject("materialid") == null ? "" : backPurDetail.getDynamicObject("materialid").getString("id"));
            resultDetailMap.put("materialdes", backPurDetail.getString("materialdes") == null ? "" : backPurDetail.getString("materialdes"));
            resultDetailMap.put("inclutaxprice", backPurDetail.get("inclutaxprice"));
            resultDetailMap.put("inclutaxamount", backPurDetail.get("inclutaxamount"));
            resultDetailMap.put("bd_taxrate", backPurDetail.get("bd_taxrate"));
            resultDetailMap.put("taxrate", backPurDetail.get("taxrate"));
            resultDetailMap.put("qty", backPurDetail.get("qty"));
            resultDetailMap.put("taxamount", backPurDetail.get("taxamount"));
            resultDetailMap.put("excepttaxamount", backPurDetail.get("excepttaxamount"));
            resultDetailMap.put("costrate", backPurDetail.get("costrate"));
            if (bidType == 2) {
                resultDetailMap.put("resourceitem", backPurDetail.getDynamicObject("resourceitem") == null ? "" : backPurDetail.getDynamicObject("resourceitem").getString("id"));
            }
            resultList.add(resultDetailMap);
        }
        resultMap.put("resultList", resultList);
        resultMap.put("finalResultList", finalResultMap);
        resultObject[0] = resultMap;
        this.getView().returnDataToParent((Object)resultObject);
        this.getView().showMessage(ResManager.loadKDString((String)"\u5b9a\u6807\u660e\u7ec6\u4fdd\u5b58\u6210\u529f\u3002", (String)"BidDecisionPurDetailEditExt_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    protected void getFinalPurDetailMap(DynamicObjectCollection finalPurDetails, Map<String, Map<String, Object>> finalResultMap, String supplierid, int bidType) {
        for (DynamicObject finalPurDetail : finalPurDetails) {
            HashMap<String, Object> resultDetailMap = new HashMap<String, Object>();
            StringBuilder sb = new StringBuilder();
            sb.append(supplierid);
            String lpurentrycontent = finalPurDetail.getString("lpurentrycontent");
            if (lpurentrycontent != null) {
                sb.append(lpurentrycontent);
            }
            resultDetailMap.put("lpurentrycontent", lpurentrycontent);
            DynamicObject lpurentryproject = finalPurDetail.getDynamicObject("lpurentryproject");
            if (lpurentryproject != null) {
                sb.append(lpurentryproject.getPkValue());
            }
            resultDetailMap.put("lpurentryprojectid", lpurentryproject);
            DynamicObject lmaterialid = finalPurDetail.getDynamicObject("lmaterialid");
            if (lmaterialid != null) {
                sb.append(lmaterialid.getPkValue());
            }
            resultDetailMap.put("lmaterialid", lmaterialid);
            String lmaterialdes = finalPurDetail.getString("lmaterialdes");
            if (lmaterialdes != null) {
                sb.append(lmaterialdes);
            }
            if (bidType == 2) {
                DynamicObject lresourceitem = finalPurDetail.getDynamicObject("lresourceitem");
                resultDetailMap.put("lresourceitem", lresourceitem);
                if (lresourceitem != null) {
                    sb.append(lresourceitem.getPkValue());
                }
            }
            resultDetailMap.put("lmaterialdes", lmaterialdes);
            resultDetailMap.put("linclutaxprice", finalPurDetail.get("linclutaxprice"));
            resultDetailMap.put("linclutaxamount", finalPurDetail.get("linclutaxamount"));
            resultDetailMap.put("lbd_taxrate", finalPurDetail.get("lbd_taxrate"));
            resultDetailMap.put("ltaxrate", finalPurDetail.get("ltaxrate"));
            resultDetailMap.put("lqty", finalPurDetail.get("lqty"));
            resultDetailMap.put("ltaxamount", finalPurDetail.get("ltaxamount"));
            resultDetailMap.put("lexcepttaxamount", finalPurDetail.get("lexcepttaxamount"));
            resultDetailMap.put("lcostrate", finalPurDetail.get("lcostrate"));
            finalResultMap.put(sb.toString(), resultDetailMap);
        }
    }
}

