/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SupplierHelper {
    public static DynamicObject getSupplierByUserId(String userId) {
        if (userId == null) {
            userId = RequestContext.get().getUserId();
        }
        QFilter filter = new QFilter("user", "=", (Object)userId);
        DynamicObject partner = BusinessDataServiceHelper.loadSingle((String)"bos_bizpartneruser", (String)"bizpartner,org", (QFilter[])new QFilter[]{filter});
        if (partner == null) {
            return null;
        }
        DynamicObject bizPartner = (DynamicObject)partner.get("bizpartner");
        filter = new QFilter("bizpartner", "=", bizPartner.getPkValue());
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"name", (QFilter[])new QFilter[]{filter});
        return supplier;
    }

    public static DynamicObject[] listUserBySupplierId(Long supplierId) {
        QFilter filter = new QFilter("id", "=", (Object)supplierId);
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"id,bizpartner", (QFilter[])new QFilter[]{filter});
        if (supplier == null) {
            return null;
        }
        DynamicObject bizPartner = (DynamicObject)supplier.get("bizpartner");
        if (bizPartner == null || bizPartner.getPkValue() == null) {
            return new DynamicObject[0];
        }
        filter = new QFilter("bizpartner", "=", bizPartner.getPkValue());
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"user,org,isadmin", (QFilter[])new QFilter[]{filter});
        return coll;
    }

    public static List<Long> listUserIdBySupplier(Long supplierId) {
        DynamicObject[] coll = SupplierHelper.listUserBySupplierId(supplierId);
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (coll != null) {
            for (int i = 0; i < coll.length; ++i) {
                DynamicObject user = coll[i];
                userIds.add(user.getLong("user.id"));
            }
        }
        return userIds;
    }

    public static Long listAdminUserIdBySupplier(Long supplierId) {
        DynamicObject[] coll = SupplierHelper.listUserBySupplierId(supplierId);
        if (coll != null) {
            for (int i = 0; i < coll.length; ++i) {
                DynamicObject user = coll[i];
                if (!user.getBoolean("isadmin")) continue;
                return user.getLong("user.id");
            }
        }
        return 0L;
    }

    public static DynamicObject getRESMSupBySysSup(Long supplierId) {
        return BusinessDataServiceHelper.loadSingle((String)"resm_official_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("syssupplier", "=", (Object)supplierId)});
    }

    public static DynamicObject getSysSupByRESMSup(Long supplierId) {
        DynamicObject officialSupplier = BusinessDataServiceHelper.loadSingle((String)"resm_official_supplier", (String)"id,syssupplier", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
        if (officialSupplier != null) {
            return officialSupplier.getDynamicObject("syssupplier");
        }
        return null;
    }
}

